/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.driver.HPKDP706Packet;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.AppResponseListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class H2DisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    protected AtomicInteger sequenceCouter = new AtomicInteger(-1);
    protected volatile int needSendConfigScreenCountc = 0;
    protected volatile int screenCount0 = 0;
    protected volatile long updateDatetimeMill = 0L;
    protected volatile boolean needupdateTime = true;
    protected ScheduledFuture<?> schre;
    protected volatile long latestReceTimeMills;
    protected volatile String[] ad = new String[4];
    protected Object setconfigLock = new Object();
    protected volatile byte currentVolumeValue = (byte)-1;
    protected Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    protected Object displayLock = new Object();
    protected boolean clearDynDisplay = true;
    protected volatile long diplayTime;

    protected void start() {
        if (this.schre != null && !this.schre.isCancelled()) {
            this.schre.cancel(true);
        }
        this.schre = this.startTask();
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    protected void stop() {
        if (this.schre != null) {
            this.schre.cancel(true);
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    protected ScheduledFuture<?> startTask() {
        ScheduledFuture flx0 = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                H2DisplayAction.this.doRunJob();
            }
        }, 2000L, 2500L, TimeUnit.MILLISECONDS);
        return flx0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dosetConfigScreenCount(int screenCount) {
        Object object = this.setconfigLock;
        synchronized (object) {
            try {
                if (this.isWorkingProperly() && this.screenCount0 != screenCount) {
                    Integer t = (Integer)this.setConfigScreenCount(screenCount).get(4L, TimeUnit.SECONDS);
                    if (t == null || t != 0) {
                        if (this.isWorkingProperly()) {
                            ++this.needSendConfigScreenCountc;
                            if (this.needSendConfigScreenCountc >= 2) {
                                this.screenCount0 = screenCount;
                                ServiceLog.getLog().warn((Object)(String.valueOf(this.getAddressInfo()) + "\u8bbe\u7f6e\u5c4f\u884c\u6570\u5931\u8d25\uff01\u53ef\u80fd\u662f\u4e0d\u652f\u6301\u6b64\u547d\u4ee4\u5bfc\u81f4"));
                            }
                        }
                    } else {
                        this.screenCount0 = screenCount;
                    }
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)(String.valueOf(this.getAddressInfo()) + ",\u8bbe\u7f6e\u5c4f\u7684\u6570\u91cf\u5f02\u5e38!" + ex.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAd(Properties p) {
        Object object = this.setconfigLock;
        synchronized (object) {
            int screenCount = this.getDisplayCount();
            int s = 0;
            int i = 1;
            while (i <= screenCount) {
                s += this.setAd1(p.getProperty("x0" + i), i);
                ++i;
            }
            if (s > 0) {
                try {
                    this.finishDynamicDisplay().get(1L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected int setAd1(String x, int p) {
        if (this.isWorkingProperly() && x != null && x.length() > 2) {
            int index = p - 1;
            if (x.startsWith("1")) {
                if (!(index < 0 || index >= this.ad.length || this.ad[index] != null && x.equals(this.ad[index]))) {
                    String text = x.substring(1);
                    try {
                        Integer t = this.isLCD() ? (p > 1 ? (Integer)this.setDefaultText((byte)p, text).get(4L, TimeUnit.SECONDS) : (Integer)this.displayContent((byte)p, true, text, false, 10).get(4L, TimeUnit.SECONDS)) : (Integer)this.displayContent((byte)p, true, text, false, 10).get(4L, TimeUnit.SECONDS);
                        if (t == null || t != 0) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.getAddressInfo()) + " \u7b2c" + p + "\u5757\u5c4f\u4e0b\u8f7d\u5e7f\u544a\u8bed\u5931\u8d25!  :" + text));
                        }
                        this.ad[index] = x;
                        return 1;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.getAddressInfo()) + " \u7b2c" + p + "\u5757\u5c4f\u4e0b\u8f7d\u5e7f\u544a\u8bed\u5f02\u5e38!  :" + ex.getMessage() + " , " + text));
                    }
                }
            } else if (x.startsWith("2")) {
                if (index >= 0 && index < this.ad.length && this.ad[index] != null) {
                    this.ad[index] = null;
                }
            } else if (index >= 0 && index < this.ad.length && this.ad[index] != null) {
                this.ad[index] = null;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRunJob() throws Exception {
        this.sendHeartBeat0();
        if (this.isWorkingProperly()) {
            byte v;
            int screenCount = this.getDisplayCount();
            this.dosetConfigScreenCount(screenCount);
            if (this.needupdateTime) {
                this.updateDatetimeMill = ServiceUtil.getServiceContext().currentTimeMillis();
                Object object = this.setconfigLock;
                synchronized (object) {
                    try {
                        Integer t = (Integer)this.updateDisplayTime(null).get(4L, TimeUnit.SECONDS);
                        if (t == null || t != 0) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.getAddressInfo()) + ",\u66f4\u65b0\u65f6\u95f4\u5931\u8d25!"));
                        } else {
                            this.needupdateTime = false;
                            this.updateDatetimeMill = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)(String.valueOf(this.getAddressInfo()) + ",\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38!" + ex.getMessage()));
                    }
                }
            }
            if (ServiceUtil.getServiceContext().currentTimeMillis() - this.updateDatetimeMill >= TimeUnit.HOURS.toMillis(12L)) {
                this.needupdateTime = true;
            }
            this.setAd(this.getconfig());
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            Volume volume = applicationService.getVolume(this.equipment);
            if (volume != null && (v = this.getVolumeValue(volume)) != this.currentVolumeValue) {
                try {
                    Integer t = (Integer)this.setVolume0(v).get(4L, TimeUnit.SECONDS);
                    if (t == null || t != 0) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.getAddressInfo()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5931\u8d25!"));
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)(String.valueOf(this.getAddressInfo()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5f02\u5e38!" + ex.getMessage()));
                }
            }
            Object object = this.displayLock;
            synchronized (object) {
                long a1 = this.diplayTime;
                if (this.clearDynDisplay || a1 > 0L && ServiceUtil.getServiceContext().currentTimeMillis() > a1) {
                    this.clearDynDisplay = false;
                    this.diplayTime = 0L;
                    this.dispLayInfoTimeTable.clear();
                    this.finishDynamicDisplay();
                }
            }
        }
        this.clearDynDisplay = true;
    }

    protected Properties getconfig() {
        Properties p = new Properties();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 3;
        }
        String x01 = null;
        String x02 = null;
        String x03 = null;
        String x04 = null;
        if (this.equipment.getUse() == 1) {
            int i = 1;
            while (i <= display_count) {
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_free_type", (byte)1);
                String context = String.valueOf(showType);
                if (showType == 0 || showType == 1) {
                    String text = config.getConfigValue("display_position_" + i + "_free_type" + showType);
                    if (text == null || text.length() == 0) {
                        text = "\u8f66\u724c\u8bc6\u522b";
                    }
                    context = String.valueOf(context) + text;
                }
                if (i == 1) {
                    x01 = context;
                } else if (i == 2) {
                    x02 = context;
                } else if (i == 3) {
                    x03 = context;
                } else if (i == 4) {
                    x04 = context;
                }
                ++i;
            }
        } else if (this.equipment.getUse() == 2) {
            int i = 1;
            while (i <= display_count) {
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_type", (byte)2);
                String context = String.valueOf(showType);
                if (showType == 0 || showType == 1) {
                    String text = config.getConfigValue("display_position_" + i + "_type" + showType);
                    if (text == null || text.length() == 0) {
                        text = "\u8f66\u724c\u8bc6\u522b";
                    }
                    context = String.valueOf(context) + text;
                }
                if (i == 1) {
                    x01 = context;
                } else if (i == 2) {
                    x02 = context;
                } else if (i == 3) {
                    x03 = context;
                } else if (i == 4) {
                    x04 = context;
                }
                ++i;
            }
        }
        if (x01 != null && x01.length() > 0) {
            p.setProperty("x01", x01);
        }
        if (x02 != null && x02.length() > 0) {
            p.setProperty("x02", x02);
        }
        if (x03 != null && x03.length() > 0) {
            p.setProperty("x03", x03);
        }
        if (x04 != null && x04.length() > 0) {
            p.setProperty("x04", x04);
        }
        return p;
    }

    protected String getAddressInfo() {
        return "";
    }

    protected byte getconfigByteValue(EquipmentConfig config, String key, byte defualtValue) {
        if (config == null) {
            return defualtValue;
        }
        Integer v = config.getConfigIntValue(key);
        if (v == null) {
            return defualtValue;
        }
        return v.byteValue();
    }

    public OperationFuture<Integer> setConfigScreenCount(int count) {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -46 && packet.getData() != null && packet.getDataLength() > 1 && packet.getData()[packet.getDataOffset()] == 3) {
                        this.result = packet.getData()[packet.getDataOffset() + 1] & 0xFF;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-46);
            byte[] data = new byte[]{3, (byte)count};
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    protected void sendHeartBeat0() {
        HPKDP706Packet sendAppPacket = new HPKDP706Packet();
        sendAppPacket.setCommandType((byte)-2);
        sendAppPacket.setData(new byte[0]);
        this.send(new SendEntry(sendAppPacket, null, null));
    }

    public OperationFuture<Integer> sendHeartBeat() {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -2) {
                        this.result = 0;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-2);
            sendAppPacket.setData(new byte[0]);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    public OperationFuture<Integer> updateDisplayTime(Date datetime) {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -44 && packet.getData() != null && packet.getDataLength() > 0) {
                        this.result = packet.getData()[packet.getDataOffset()] & 0xFF;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            Calendar calendar = Calendar.getInstance();
            if (datetime != null) {
                calendar.setTime(datetime);
            }
            int week = calendar.get(7) - 1;
            int moth = calendar.get(2) + 1;
            int day = calendar.get(5);
            int hour = calendar.get(11);
            int min = calendar.get(12);
            int sec = calendar.get(13);
            SimpleDateFormat df = new SimpleDateFormat("yy");
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-44);
            byte[] data = new byte[]{(byte)sec, (byte)min, (byte)hour, (byte)day, (byte)moth, (byte)week, (byte)Integer.parseInt(df.format(calendar.getTime()))};
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    @Override
    protected void preHandleAppPacket(AppProtocolPacket receivePacket) throws Exception {
        this.latestReceTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    protected OperationFuture<Integer> finishDynamicDisplay() {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -42) {
                        this.result = 0;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-42);
            sendAppPacket.setData(new byte[0]);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    public boolean isLCD() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationFuture<Integer> displayContent(final byte position, boolean ad, String text, boolean sp, int displayTimes) {
        Object object = this.displayLock;
        synchronized (object) {
            OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
            try {
                long lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(displayTimes * 1500);
                if (!ad) {
                    Long x;
                    if (!sp) {
                        this.dispLayInfoTimeTable.put(Integer.valueOf(position), lockMills);
                    } else if (this.equipment.getUse() == 1 && (x = this.dispLayInfoTimeTable.get(position)) != null && ServiceUtil.getServiceContext().currentTimeMillis() < x) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                }
                AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                        HPKDP706Packet packet;
                        if (receivePacket == null || !(receivePacket instanceof HPKDP706Packet) || (packet = (HPKDP706Packet)receivePacket).getCommandType() != -43 || packet.getData() == null || packet.getDataLength() <= 0) return false;
                        if (H2DisplayAction.this.isLCD()) {
                            if (packet.getDataLength() < 3) return false;
                            byte px = (byte)(position - 1);
                            byte r1 = packet.getData()[packet.getDataOffset()];
                            if (px != r1) return false;
                            this.result = packet.getData()[packet.getDataOffset() + 2] & 0xFF;
                            return true;
                        } else {
                            this.result = packet.getData()[packet.getDataOffset()] & 0xFF;
                        }
                        return true;
                    }
                };
                l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
                HPKDP706Packet sendAppPacket = new HPKDP706Packet();
                sendAppPacket.setCommandType((byte)-43);
                int offset = 0;
                byte[] data = new byte[114];
                data[offset++] = (byte)(position - 1);
                if (text == null) {
                    text = "";
                }
                int dlen = data.length - 2;
                text = ServiceUtil.getString(text, dlen, "GBK");
                byte[] d1 = text.getBytes("GBK");
                int type = ad ? 81 : (this.isLCD() ? 82 : (d1.length <= 8 ? 37 : 82));
                data[offset++] = type;
                if (d1.length < dlen) {
                    dlen = d1.length;
                }
                System.arraycopy(d1, 0, data, offset, dlen);
                sendAppPacket.setData(data);
                sendAppPacket.setDataLength(offset += dlen);
                this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
                if (!sp && !ad) {
                    this.diplayTime = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(displayTimes * 1500);
                }
            }
            catch (Exception ex) {
                f1.setException((Throwable)ex);
            }
            return f1;
        }
    }

    @Override
    public boolean isWorkingProperly() {
        boolean connected;
        if (ServiceUtil.getServiceContext().currentTimeMillis() - this.latestReceTimeMills < 6500L) {
            connected = true;
        } else {
            connected = false;
            this.needupdateTime = true;
            this.clearDynDisplay = true;
        }
        return connected;
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.displayContent((byte)config.screenIndex, false, String.valueOf(config.spacefix) + v, true, 100);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        return null;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        return this;
    }

    protected byte getVolumeValue(Volume volume) {
        if (volume == null) {
            return 5;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        if (night) {
            return (byte)Math.round((float)volume.getNightVolume() / 10.0f);
        }
        return (byte)Math.round((float)volume.getDayVolume() / 10.0f);
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        final byte v = this.getVolumeValue(volume);
        OperationFuture<Integer> f = this.setVolume0(v);
        if (v > 0) {
            f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                }

                public void operationComplete(OperationFuture<Integer> da) {
                    if (da.getException() == null && da.getResult() != null && (Integer)da.getResult() == 0) {
                        H2DisplayAction.this.play("\u97f3\u91cf" + v);
                    }
                }
            });
        }
        return f;
    }

    protected OperationFuture<Integer> setVolume0(final byte volumeValue) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -46 && packet.getData() != null && packet.getDataLength() > 1 && packet.getData()[packet.getDataOffset()] == 2) {
                        this.result = packet.getData()[packet.getDataOffset() + 1] & 0xFF;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-46);
            byte[] data = new byte[]{2, volumeValue};
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
            f1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                }

                public void operationComplete(OperationFuture<Integer> da) {
                    if (da.getException() == null && da.getResult() != null && (Integer)da.getResult() == 0) {
                        H2DisplayAction.this.currentVolumeValue = volumeValue;
                    }
                }
            });
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (H2DisplayAction.this.checkAddressChanged()) {
                    Object object = H2DisplayAction.this.setconfigLock;
                    synchronized (object) {
                        int i = 0;
                        while (i < H2DisplayAction.this.ad.length) {
                            H2DisplayAction.this.ad[i] = null;
                            ++i;
                        }
                    }
                }
                H2DisplayAction.this.dosetConfigScreenCount(H2DisplayAction.this.getDisplayCount());
                H2DisplayAction.this.setAd(H2DisplayAction.this.getconfig());
            }
        });
    }

    protected boolean checkAddressChanged() {
        return false;
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(f1){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -45 && packet.getData() != null && packet.getDataLength() > 0) {
                        this.result = packet.getData()[packet.getDataOffset()] & 0xFF;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-45);
            if (text == null) {
                text = "";
            }
            byte[] data = text.getBytes("GB2312");
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length > 114 ? 114 : data.length);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        return this.play(text);
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 3;
        }
        return display_count;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.displayContent((byte)position, false, text, false, displayTimes);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    protected abstract void send(SendEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextSendSequence() {
        int h;
        int MaxSeq = 255;
        while ((h = this.sequenceCouter.incrementAndGet()) > MaxSeq) {
            AtomicInteger atomicInteger = this.sequenceCouter;
            synchronized (atomicInteger) {
                h = this.sequenceCouter.get();
                if (h > MaxSeq) {
                    this.sequenceCouter.set(-1);
                }
            }
        }
        return h;
    }

    @Override
    public boolean isSupportTrafficLights() {
        return false;
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
        h.setResult((Object)1);
        return h;
    }

    protected OperationFuture<Integer> setDefaultText(final byte position, String text) {
        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            byte[] datB = text == null || text.length() == 0 ? new byte[]{} : ServiceUtil.getString(text, 113, "GBK").getBytes("GBK");
            AppResponseListener<Integer> l = new AppResponseListener<Integer>(h){

                public boolean checkReceiveDataIsWaitData(AppProtocolPacket receivePacket) {
                    byte a;
                    HPKDP706Packet packet;
                    if (receivePacket != null && receivePacket instanceof HPKDP706Packet && (packet = (HPKDP706Packet)receivePacket).getCommandType() == -40 && packet.getData() != null && packet.getDataLength() > 1 && (a = (byte)(position - 1)) == packet.getData()[packet.getDataOffset()]) {
                        this.result = packet.getData()[packet.getDataOffset() + 1] & 0xFF;
                        return true;
                    }
                    return false;
                }
            };
            l.setWaitTimeout(3000L, TimeUnit.MILLISECONDS);
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-40);
            int offset = 0;
            byte[] data = new byte[datB.length + 1];
            data[offset++] = (byte)(position - 1);
            if (datB.length > 0) {
                System.arraycopy(datB, 0, data, offset, datB.length);
            }
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length);
            this.send(new SendEntry(sendAppPacket, l, (OperationFutureHandler<Integer>)h));
        }
        catch (Exception ex) {
            h.setException((Throwable)ex);
        }
        return h;
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int displaySec, String qrContent, String lineMsg) {
        OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            byte[] conectBytes;
            if (displaySec < 5) {
                qrContent = null;
            }
            byte[] byArray = conectBytes = qrContent == null || qrContent.length() == 0 ? new byte[]{} : qrContent.getBytes();
            if (conectBytes.length > 110) {
                f1.setResult((Object)1);
                return f1;
            }
            HPKDP706Packet sendAppPacket = new HPKDP706Packet();
            sendAppPacket.setCommandType((byte)-39);
            int offset = 0;
            byte[] data = new byte[conectBytes.length + 4];
            data[offset++] = 1;
            data[offset++] = 0;
            data[offset++] = 0;
            data[offset++] = 0;
            if (conectBytes.length > 0) {
                System.arraycopy(conectBytes, 0, data, offset, conectBytes.length);
            }
            sendAppPacket.setData(data);
            sendAppPacket.setDataLength(data.length);
            this.send(new SendEntry(sendAppPacket, null, (OperationFutureHandler<Integer>)f1));
        }
        catch (Exception ex) {
            f1.setException((Throwable)ex);
        }
        return f1;
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }

    protected static class SendEntry {
        public HPKDP706Packet sendAppPacket;
        public AppResponseListener<Integer> l;
        public OperationFutureHandler<Integer> f;

        public SendEntry(HPKDP706Packet sendAppPacket, AppResponseListener<Integer> l, OperationFutureHandler<Integer> f) {
            this.sendAppPacket = sendAppPacket;
            this.l = l;
            this.f = f;
        }
    }
}

