/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.driver.H2DisplayAction;
import com.wovoe.carpark.equipment.driver.HPKDP706Packet;
import com.wovoe.carpark.equipment.driver.HPKDP706ProtocolHandler;
import com.wovoe.carpark.equipment.driver.HPKDP706RootReadProtocolHandler;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.CommunicationHandleManger;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.udp.UDPConfig;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class H2NetDisplayAction
extends H2DisplayAction {
    public static final String NAME_UDP_PC_DP70X_HANDLE = "UDP_PC_HMH2DP70x_Handle";
    public static final String CONFIG_UDP_DP70X_PORT = "accept.udp.hmdp70x.port";
    private static volatile UDPConfig udpConfig;
    private SendQueue sendQueue = new SendQueue();
    private InetSocketAddress inetSocketAddress;
    private volatile long handleControlboxMills;
    private static final Object startPortUdpLock;

    static {
        startPortUdpLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUDPEndpointStart() {
        Object object = startPortUdpLock;
        synchronized (object) {
            if (ServiceUtil.getServiceContext().getUDPEndpoint().isShutdown()) {
                return;
            }
            if (udpConfig == null && ServiceUtil.getServiceContext().getUDPEndpoint().getUDPConfig(NAME_UDP_PC_DP70X_HANDLE) == null) {
                String v = ServiceUtil.getServiceContext().getConfig().getProperty(CONFIG_UDP_DP70X_PORT, "").trim();
                int portp = -1;
                if (v != null && v.length() > 0) {
                    try {
                        portp = Integer.parseInt(v);
                    }
                    catch (Exception ex) {
                        portp = -1;
                    }
                }
                if (portp <= 0 || portp > 65535) {
                    int end = 7000;
                    int begin = 5971;
                    boolean success = false;
                    int port = begin;
                    while (port < end) {
                        Dp70xUDPConfig udpConfig0 = new Dp70xUDPConfig(port);
                        try {
                            ServiceUtil.getServiceContext().getUDPEndpoint().bind((UDPConfig)udpConfig0);
                            success = true;
                            udpConfig = udpConfig0;
                            break;
                        }
                        catch (Exception e) {
                            ServiceLog.getLog().warn((Object)e.getMessage(), (Throwable)e);
                            ++port;
                        }
                    }
                    if (!success) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(new Object(), "\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8", 3, 12000));
                        ServiceLog.getLog().warn((Object)("\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8"));
                    }
                } else {
                    Dp70xUDPConfig udpConfig0 = new Dp70xUDPConfig(portp);
                    try {
                        ServiceUtil.getServiceContext().getUDPEndpoint().bind((UDPConfig)udpConfig0);
                        udpConfig = udpConfig0;
                    }
                    catch (Exception e) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(udpConfig0, "\u9519\u8bef\uff1a\u65e0\u6cd5\u5728\u7aef\u53e3" + portp + "\u542f\u52a8UDP\u4fa6\u542c\uff0c\u539f\u56e0: " + e.getMessage(), 3, 12000));
                        ServiceLog.getLog().warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public H2NetDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.inetSocketAddress == null) {
            this.inetSocketAddress = this.createInetSocketAddress();
        }
        return this.inetSocketAddress;
    }

    private InetSocketAddress createInetSocketAddress() {
        String ip = this.equipment.getEquipmentConfig().getConfigValue("ip");
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue("udp_port");
        int o = 5000;
        if (x != null && x > 0 && x < 65535) {
            o = x;
        }
        InetSocketAddress s = new InetSocketAddress(ip, o);
        return s;
    }

    @Override
    protected boolean checkAddressChanged() {
        InetSocketAddress szi = this.createInetSocketAddress();
        if (!szi.equals(this.getInetSocketAddress())) {
            this.inetSocketAddress = szi;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized void start() {
        H2NetDisplayAction.checkUDPEndpointStart();
        super.start();
    }

    @Override
    protected synchronized void stop() {
        super.stop();
    }

    @Override
    protected String getAddressInfo() {
        return this.getInetSocketAddress().toString();
    }

    @Override
    protected void send(H2DisplayAction.SendEntry entry) {
        entry.sendAppPacket.setAttribute("send.need.ack", Boolean.FALSE);
        entry.sendAppPacket.setAttribute("send.target.address", this.getInetSocketAddress());
        entry.sendAppPacket.setAttribute("send.packet.sequence", this.getNextSendSequence());
        this.sendQueue.send(entry);
    }

    @Override
    protected void handleAppPacket(AppProtocolPacket receivePacket) throws Exception {
        if (receivePacket != null && receivePacket instanceof HPKDP706Packet) {
            HPKDP706Packet packet = (HPKDP706Packet)receivePacket;
            if (packet.getServiceType() == 0 && packet.getCommandType() == -41 && packet.getData() != null && packet.getDataLength() > 1) {
                if ((packet.getData()[packet.getDataOffset()] & 0xFF) == 1 && (packet.getData()[packet.getDataOffset() + 1] & 0xFF) == 1) {
                    Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("controlbox_handtype");
                    if (handleType == null) {
                        handleType = 0;
                    }
                    if (handleType != 2) {
                        long xd1 = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.handleControlboxMills == 0L || xd1 - this.handleControlboxMills >= 5000L) {
                            this.handleControlboxMills = xd1;
                            List<String> channelNos = this.equipment.getChannelNos();
                            if (channelNos != null && !channelNos.isEmpty()) {
                                EnumSet<RoadBarrierStateEvent.SignalType> signals = null;
                                block0: for (String channelNo : channelNos) {
                                    Collection<Equipment> roadGateList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
                                    if (roadGateList == null || roadGateList.isEmpty()) continue;
                                    for (Equipment eq : roadGateList) {
                                        if (eq.getChannelNos() == null || !eq.getChannelNos().contains(channelNo)) continue;
                                        if (signals == null) {
                                            signals = EnumSet.noneOf(RoadBarrierStateEvent.SignalType.class);
                                            signals.add(RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN);
                                        }
                                        EquipmentState state = eq.getEquipmentAction().getEquipmentState();
                                        RoadBarrierStateEvent event = new RoadBarrierStateEvent(eq, state, state, signals, channelNo);
                                        event.setControlBoxOpenHandleType(handleType);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
                                        continue block0;
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (packet.getServiceType() == 0 && packet.getCommandType() == -2) {
                this.latestReceTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
            }
        }
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }

    @Override
    public boolean isLCD() {
        String v = this.equipment.getEquipmentConfig().getConfigValue("protocol_type");
        return v != null && Constants.YES_STR.equals(v);
    }

    public static class Dp70xUDPConfig
    implements UDPConfig {
        private int port;

        public Dp70xUDPConfig(int port) {
            this.port = port;
        }

        public ProtocolHandlerChain createProtocolHandlerChain(UDPEndpoint udpEndpoint) {
            ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
            rwchain.appendNextProtocolHandler((ProtocolHandler)new HPKDP706RootReadProtocolHandler());
            rwchain.appendNextProtocolHandler((ProtocolHandler)new HPKDP706ProtocolHandler());
            rwchain.appendNextProtocolHandler((ProtocolHandler)new RootWriteProtocolHandler());
            return rwchain;
        }

        public int getACKTimeoutMills() {
            return 0;
        }

        public String getAcceptName() {
            return H2NetDisplayAction.NAME_UDP_PC_DP70X_HANDLE;
        }

        public int getAcceptPort() {
            return this.port;
        }

        public int getReSendTimes() {
            return 0;
        }
    }

    private class SendQueue {
        LinkedBlockingDeque<H2DisplayAction.SendEntry> queue = new LinkedBlockingDeque();
        volatile long sendingTimeMills;
        AtomicBoolean sending = new AtomicBoolean(false);

        private SendQueue() {
        }

        public void send(H2DisplayAction.SendEntry entry) {
            long x1;
            this.queue.offer(entry);
            if (this.sending.get() && this.sendingTimeMills > 0L && (x1 = this.sendingTimeMills) > 0L && ServiceUtil.getServiceContext().currentTimeMillis() - x1 >= 5000L && x1 == this.sendingTimeMills && this.sending.compareAndSet(true, false)) {
                this.sendingTimeMills = 0L;
                ServiceLog.getLog().warn((Object)(String.valueOf(H2NetDisplayAction.this.getAddressInfo()) + "\u51fa\u73b0\u4e00\u6b21\u53d1\u9001\u5f02\u5e38\uff01\uff015s\u6ca1\u6709\u53d1\u9001\u5b8c\u6210! \u8be5\u5f02\u5e38\u4e0d\u5e94\u8be5\u51fa\u73b0\uff01\uff01\uff01\u8bf7\u68c0\u67e5!!!"));
                if (this.queue.size() > 10) {
                    this.queue.clear();
                    this.queue.offer(entry);
                }
            }
            this.doSend();
        }

        private void doSend() {
            block18: {
                if (this.sending.compareAndSet(false, true)) {
                    try {
                        this.sendingTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        H2DisplayAction.SendEntry e1 = this.queue.poll();
                        if (e1 == null) {
                            this.sendingTimeMills = 0L;
                            this.sending.set(false);
                            if (this.queue.peek() != null) {
                                this.doSend();
                            }
                            return;
                        }
                        try {
                            if (e1.f == null) {
                                e1.f = ServiceUtil.getServiceContext().createOperationFuture();
                            }
                            e1.f.addCompleteListener(new OperationFuture.CompleteListener(){

                                public void operationComplete(OperationFuture futrue) {
                                    this.waitCompleteTimeout();
                                }

                                public void waitCompleteTimeout() {
                                    SendQueue.this.sendingTimeMills = 0L;
                                    SendQueue.this.sending.set(false);
                                    if (SendQueue.this.queue.peek() != null) {
                                        SendQueue.this.doSend();
                                    }
                                }
                            }, 1000L, TimeUnit.MILLISECONDS);
                            this.directSend(e1);
                        }
                        catch (Throwable exs) {
                            try {
                                try {
                                    ServiceLog.getLog().error((Object)(String.valueOf(H2NetDisplayAction.this.getAddressInfo()) + "send error! " + exs));
                                    if (e1.l == null) break block18;
                                    try {
                                        e1.l.handleException(exs);
                                    }
                                    finally {
                                        H2NetDisplayAction.this.cancelInterestResponseListener(e1.l);
                                    }
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().error((Object)(String.valueOf(H2NetDisplayAction.this.getAddressInfo()) + "callback error! "), (Throwable)ex);
                                    this.sendingTimeMills = 0L;
                                    this.sending.set(false);
                                    if (this.queue.peek() != null) {
                                        this.doSend();
                                    }
                                }
                            }
                            finally {
                                this.sendingTimeMills = 0L;
                                this.sending.set(false);
                                if (this.queue.peek() != null) {
                                    this.doSend();
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.sendingTimeMills = 0L;
                        this.sending.set(false);
                        ServiceLog.getLog().error((Object)(String.valueOf(H2NetDisplayAction.this.getAddressInfo()) + "send error! "), (Throwable)ex);
                    }
                }
            }
        }

        private void directSend(final H2DisplayAction.SendEntry entry) throws Exception {
            CommunicationHandle h1 = CommunicationHandleManger.getCommunicationHandle((String)H2NetDisplayAction.NAME_UDP_PC_DP70X_HANDLE);
            if (h1 == null) {
                throw new IOException("UDP_PC_HMH2DP70x_Handle not register!");
            }
            if (entry.l != null) {
                H2NetDisplayAction.this.offerInterestResponseListener(entry.l);
            }
            h1.send((AppProtocolPacket)entry.sendAppPacket, new SendCallbackHandler(){

                public void onSendTimeout(CommunicationHandle handle) {
                    this.onSendException(new TimeoutException("\u53d1\u9001\u8d85\u65f6.. " + handle.getName()), handle);
                }

                public void onSendException(Throwable exception, CommunicationHandle handle) {
                    if (entry.l != null) {
                        try {
                            entry.l.handleException(exception);
                        }
                        finally {
                            H2NetDisplayAction.this.cancelInterestResponseListener(entry.l);
                        }
                    }
                }

                public void onSendCompleted(CommunicationHandle handle) {
                    if (entry.l == null && entry.f != null) {
                        entry.f.setResult((Object)0);
                    }
                }
            });
        }
    }
}

