/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.H2NetDisplayAction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class H2NetDisplayDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_hm_h2dp70x_net_screen_driver";

    public H2NetDisplayDriver() {
        this.init();
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("HMH2-DP70X")) + "\u8f66\u9053\u5c4f\u63a7\u5236\u5361\u3010\u7f51\u53e3\u3011\u9a71\u52a8";
        this.parentDriverNames = null;
        this.equipmentType = 10;
        this.defaultUse = 1;
        this.description = "\u7528\u4e8e\u663e\u793a\u51fa\u5165\u6216\u4f59\u4f4d\u4fe1\u606f";
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(1, "\u8f66\u9053\u4fe1\u606f\u5c4f");
        m.put(2, "\u4f59\u4f4d\u4fe1\u606f\u5c4f");
        return m;
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u8f66\u9053\u5c4f";
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        H2NetDisplayAction c = new H2NetDisplayAction(equipment, this);
        this.setAction(equipment, c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        H2NetDisplayAction action = (H2NetDisplayAction)equipment.getEquipmentAction();
        action.stop();
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        Map<String, String> vmap;
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("ip");
        p.setParameterNameDes("IP\u5730\u5740");
        p.setUnique(true);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("udp_port");
        p.setParameterNameDes("\u8fde\u63a5\u7aef\u53e3");
        p.setParameterDefaultValue("5000");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("protocol_type");
        p.setParameterNameDes("\u534f\u8bae\u7c7b\u578b");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        ArrayList<Object> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues.add(new KeyValueEntry((Object)"0", (Object)"LED\u5c4f\u534f\u8bae"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"LCD\u5c4f\u534f\u8bae"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_qrcode");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u663e\u793a");
        parameterSelectValues = new ArrayList(3);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u5173\u95ed"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u52a8\u6001\u4e8c\u7ef4\u7801"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u9759\u6001\u4e8c\u7ef4\u7801"));
        p.setInputType(1);
        p.setParameterSelectValues(parameterSelectValues);
        p.setParameterDefaultValue("0");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("qrcode_content");
        p.setParameterNameDes("\u9759\u6001\u4e8c\u7ef4\u7801\u5185\u5bb9");
        p.setParameterDefaultValue("0");
        pl.add(p);
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_SET");
            p.setParameterNameDes("\u767d\u5929\u65f6\u6bb5");
            p.setParameterDefaultValue("07:00:00-19:00:00");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_VOLUME");
            p.setParameterNameDes("\u767d\u5929\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("NIGHT_TIME_VOLUME");
            p.setParameterNameDes("\u591c\u95f4\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
        }
        p = new EquipmentParameter();
        p.setParameterName("controlbox_handtype");
        p.setParameterNameDes("\u5f53\u63a5\u6536\u5230\u9065\u63a7\u5668\u5f00\u95f8\u4fe1\u53f7");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(3);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u6709\u5f39\u6846\u65f6\u5f53\u4eba\u5de5\u70b9\u51fb\u786e\u8ba4\u653e\u884c,\u65e0\u5f39\u6846\u65f6\u8bb0\u5f55\u975e\u6cd5\u8d77\u6746"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u4e0d\u8003\u8651\u662f\u5426\u5f39\u6846(\u4e0d\u5904\u7406\u5f39\u6846),\u5168\u90e8\u8bb0\u5f55\u975e\u6cd5\u8d77\u6746"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u4e0d\u505a\u4efb\u4f55\u5904\u7406,\u4e22\u5f03\u4fe1\u53f7"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_count");
        p.setParameterNameDes("\u5c4f\u7684\u6570\u91cf");
        p.setParameterDefaultValue("3");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"2", (Object)"2\u884c\u5c4f"));
        parameterSelectValues.add(new KeyValueEntry((Object)"3", (Object)"3\u884c\u5c4f"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4", (Object)"4\u884c\u5c4f"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues0 = new ArrayList<KeyValueEntry<String, String>>(4);
        parameterSelectValues0.add(new KeyValueEntry((Object)"1", (Object)"\u5e7f\u544a\u4fe1\u606f"));
        parameterSelectValues0.add(new KeyValueEntry((Object)"2", (Object)"\u4f59\u4f4d\u4fe1\u606f"));
        LinkedList<KeyValueEntry<String, String>> parameterSelectValues1 = new LinkedList<KeyValueEntry<String, String>>();
        parameterSelectValues1.add(new KeyValueEntry((Object)"0", (Object)"\u603b\u4f59\u4f4d"));
        if (ServiceUtil.getServiceContext() != null && ServiceUtil.getServiceContext().getDBConfigCache() != null && (vmap = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap()) != null && !vmap.isEmpty()) {
            for (Map.Entry<String, String> e : vmap.entrySet()) {
                parameterSelectValues1.add(new KeyValueEntry((Object)e.getKey(), (Object)(String.valueOf(e.getValue()) + "\u4f59\u4f4d")));
                parameterSelectValues1.add(new KeyValueEntry((Object)("rs-" + e.getKey()), (Object)(String.valueOf(e.getValue()) + "\u4f59\u4f4d(\u4e0d\u542b\u5d4c\u5957\u573a\u533a)")));
            }
        }
        int i = 1;
        while (i <= 4) {
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_free_type");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_free_type");
            p.setParameterName("display_position_" + i + "_free_type" + 1);
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u5185\u5bb9");
            if (i == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_free_type");
            p.setParameterName("display_position_" + i + "_free_type" + 2);
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_free_type");
            p.setParameterName("display_position_" + i + "_free_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("\u4f59\u4f4d");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_type");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("2");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_type");
            p.setParameterName("display_position_" + i + "_type" + 1);
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u5185\u5bb9");
            if (i == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u8f66\u724c\u8bc6\u522b");
            }
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_type");
            p.setParameterName("display_position_" + i + "_type" + 2);
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_type");
            p.setParameterName("display_position_" + i + "_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("\u4f59\u4f4d");
            p.setUse(2);
            pl.add(p);
            ++i;
        }
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }
}

