/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.driver.H2DisplayAction;
import com.wovoe.carpark.equipment.driver.HPKDP706Packet;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CRC16;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class H2Rs485DispalyAction
extends H2DisplayAction {
    private boolean checkSeriaSetingok = false;
    private static final byte BEH = -86;
    private static final byte BES = 85;
    private static final byte END = -81;
    private volatile int uatIndex0 = -1;

    public H2Rs485DispalyAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        return action.isWorkingProperly();
    }

    @Override
    protected synchronized void start() {
        super.start();
    }

    @Override
    protected synchronized void stop() {
        super.stop();
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    @Override
    protected void doRunJob() throws Exception {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            return;
        }
        if (!this.checkSeriaSetingok) {
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
                this.uatIndex0 = uatIndex;
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        super.doRunJob();
    }

    @Override
    protected String getAddressInfo() {
        return this.equipment.getName();
    }

    @Override
    protected void sendHeartBeat0() {
    }

    private int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (H2Rs485DispalyAction.this.checkAddressChanged()) {
                    Object object = H2Rs485DispalyAction.this.setconfigLock;
                    synchronized (object) {
                        int i = 0;
                        while (i < H2Rs485DispalyAction.this.ad.length) {
                            H2Rs485DispalyAction.this.ad[i] = null;
                            ++i;
                        }
                    }
                } else {
                    H2Rs485DispalyAction.this.dosetConfigScreenCount(H2Rs485DispalyAction.this.getDisplayCount());
                    H2Rs485DispalyAction.this.setAd(H2Rs485DispalyAction.this.getconfig());
                }
            }
        });
    }

    @Override
    protected boolean checkAddressChanged() {
        Integer uatIndex = this.equipment.getEquipmentConfig().getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex != this.uatIndex0;
    }

    @Override
    protected void send(H2DisplayAction.SendEntry entry) {
        block6: {
            final OperationFutureHandler<Integer> h = entry.f;
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                if (h != null) {
                    h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                }
                return;
            }
            try {
                HPKDP706Packet appPacket = entry.sendAppPacket;
                int serviceType = appPacket.getServiceType() & 0xFF;
                byte seq = (byte)this.getNextSendSequence();
                int ba = 0;
                CRC16 crc16 = new CRC16();
                ByteBuffer byteBuffer = ByteBuffer.allocate(appPacket.getDataLength() + 10);
                byteBuffer.put((byte)-86);
                byteBuffer.put((byte)85);
                byteBuffer.put(seq);
                serviceType = ba | serviceType;
                byteBuffer.put((byte)serviceType);
                crc16.update((byte)serviceType);
                byteBuffer.put(appPacket.getCommandType());
                crc16.update(appPacket.getCommandType());
                int len1 = appPacket.getDataLength() << 16 >>> 24;
                int len2 = appPacket.getDataLength() << 24 >>> 24;
                byteBuffer.put((byte)len1);
                crc16.update((byte)len1);
                byteBuffer.put((byte)len2);
                crc16.update((byte)len2);
                if (appPacket.getDataLength() > 0) {
                    byteBuffer.put(appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength());
                    crc16.update(appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength());
                }
                int crcValue = crc16.getCRCValue();
                int crc1 = crcValue << 16 >>> 24;
                int crc2 = crcValue << 24 >>> 24;
                byteBuffer.put((byte)crc1);
                byteBuffer.put((byte)crc2);
                byteBuffer.put((byte)-81);
                byteBuffer.flip();
                byte[] sendData = new byte[byteBuffer.remaining()];
                byteBuffer.get(sendData);
                OperationFuture<Integer> inter = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, 300L);
                if (h != null) {
                    inter.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void waitCompleteTimeout() {
                            h.setException((Throwable)new TimeoutException("\u7b49\u7b49\u54cd\u5e94\u8d85\u65f6"));
                        }

                        public void operationComplete(OperationFuture<Integer> futrue) {
                            if (futrue.isCancelled()) {
                                h.cancel(true);
                            } else if (futrue.getException() != null) {
                                h.setException(futrue.getException());
                            } else {
                                h.setResult((Object)((Integer)futrue.getResult()));
                            }
                        }
                    });
                }
            }
            catch (Exception ex) {
                if (h == null) break block6;
                h.setException((Throwable)ex);
            }
        }
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }
}

