/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.driver.H2NetDisplayAction;
import com.wovoe.carpark.equipment.driver.HPKDP706Packet;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CRC16;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.DirectSendTask;
import com.wovoe.framework.communication.ParkingSocketAddress;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.SendCallbackHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HPKDP706ProtocolHandler
extends AbstractProtocolHandler {
    private static final byte BEH = -86;
    private static final byte BES = 85;
    private static final byte END = -81;
    private AtomicInteger sequenceCouter;

    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        SocketAddress sourceAddress = (SocketAddress)ctx.getAttribute("receive.source.address");
        if (sourceAddress == null) {
            throw new IOException("source address is NULL!");
        }
        if (sourceAddress instanceof ParkingSocketAddress) {
            sourceAddress = ((ParkingSocketAddress)sourceAddress).getSocketAddress();
            ctx.setAttribute("receive.source.address", (Object)sourceAddress);
        }
        Logger logger = ctx.getCommunicationHandle().getLogger();
        ByteArrayPacket byteArray = (ByteArrayPacket)ctx.getMessage();
        if (byteArray == null) {
            return false;
        }
        if (byteArray.getByteArray() == null || byteArray.getByteArrayLength() < 10 || byteArray.getByteArray().length < byteArray.getByteArrayLength() + byteArray.getByteArrayOffset()) {
            return false;
        }
        int offset = byteArray.getByteArrayOffset();
        byte[] frame = byteArray.getByteArray();
        int length = byteArray.getByteArrayLength();
        if (frame[offset] != -86) {
            return false;
        }
        if (frame[offset + 1] != 85) {
            return false;
        }
        if (frame[offset + length - 1] != -81) {
            return false;
        }
        CRC16 crc16 = new CRC16();
        offset += 2;
        byte seq = frame[offset++];
        int baServiceType = frame[offset++] & 0xFF;
        crc16.update((byte)baServiceType);
        int b = baServiceType << 24 >>> 31;
        int a = baServiceType << 25 >>> 31;
        byte serviceType = (byte)(baServiceType << 26 >>> 26);
        byte cmdType = frame[offset++];
        crc16.update(cmdType);
        byte len1 = frame[offset++];
        crc16.update(len1);
        int dataLen = (len1 & 0xFF) << 8;
        byte len2 = frame[offset++];
        crc16.update(len2);
        if (length != (dataLen |= len2 & 0xFF) + 10) {
            if (logger != null) {
                logger.warning(sourceAddress + ", \u9519\u8bef\u7684\u5e27\u957f\u5ea6! \u671f\u5f85:" + (dataLen + 10) + " \u5b9e\u9645:" + length + " ,\u6570\u636e\u5185\u5bb9\u957f\u5ea6:" + dataLen + ", \u5e27\u6570\u636e: " + BytesTool.byteArrayToHexString((byte[])byteArray.getByteArray(), (int)byteArray.getByteArrayOffset(), (int)byteArray.getByteArrayLength()));
            }
            return false;
        }
        int dataOffset = offset;
        crc16.update(byteArray.getByteArray(), offset, dataLen);
        offset += dataLen;
        int crcValue = crc16.getCRCValue();
        byte crc1 = (byte)(crcValue << 16 >>> 24);
        byte crc2 = (byte)(crcValue << 24 >>> 24);
        byte _crc1 = frame[offset++];
        byte _crc2 = frame[offset++];
        if (crc1 != _crc1) {
            if (logger != null) {
                logger.warning(sourceAddress + ", CRC1\u6821\u9a8c\u5931\u8d25! \u671f\u5f85:" + (crc1 & 0xFF) + ", \u5b9e\u9645:" + (_crc1 & 0xFF) + ", \u5e27\u6570\u636e: " + BytesTool.byteArrayToHexString((byte[])byteArray.getByteArray(), (int)byteArray.getByteArrayOffset(), (int)byteArray.getByteArrayLength()));
            }
            return false;
        }
        if (crc2 != _crc2) {
            if (logger != null) {
                logger.warning(sourceAddress + ", CRC2\u6821\u9a8c\u5931\u8d25! \u671f\u5f85:" + (crc2 & 0xFF) + ", \u5b9e\u9645:" + (_crc2 & 0xFF) + ", \u5e27\u6570\u636e: " + BytesTool.byteArrayToHexString((byte[])byteArray.getByteArray(), (int)byteArray.getByteArrayOffset(), (int)byteArray.getByteArrayLength()));
            }
            return false;
        }
        if (b == 1 && a == 1 && logger != null) {
            logger.warning(sourceAddress + ", \u5e27\u7c7b\u578b\u9519\u8bef!B/A \u90fd\u552f1" + ", \u5e27\u6570\u636e: " + BytesTool.byteArrayToHexString((byte[])byteArray.getByteArray(), (int)byteArray.getByteArrayOffset(), (int)byteArray.getByteArrayLength()));
        }
        if (!this.isLcd(sourceAddress)) {
            if (a == 1) {
                Object ackkey;
                TimeoutObjectPool timeoutObjectPool = ctx.getCommunicationHandle().getTimeoutObjectPool();
                DirectSendTask task = (DirectSendTask)timeoutObjectPool.removeObject(ackkey = this.getAckKey(sourceAddress, seq, serviceType, cmdType));
                if (task != null) {
                    if (logger != null && logger.isLoggable(Level.FINEST)) {
                        logger.finest("\u6210\u529f\u6536\u5230ACK\u5305,\u5e8f\u5217:" + seq);
                    }
                    task.setSendTimes(0);
                    if (task.getSendCallbackHandler() != null) {
                        task.getSendCallbackHandler().onSendCompleted(task.getCommunicationHandle());
                    }
                }
                return false;
            }
            if (b == 1) {
                this.sendACK(ctx, sourceAddress, seq, serviceType, cmdType);
            }
        }
        HPKDP706Packet appPacket = new HPKDP706Packet();
        appPacket.setCommandType(cmdType);
        appPacket.setServiceType(serviceType);
        appPacket.setData(frame);
        appPacket.setDataLength(dataLen);
        appPacket.setDataOffset(dataOffset);
        ctx.setMessage((Object)appPacket);
        return true;
    }

    protected void sendACK(ProtocolContext ctx, final SocketAddress sourceAddress, final byte seq, byte serviceType, byte cmdType) throws Exception {
        AckPacket packet = new AckPacket();
        packet.setAttribute("send.need.ack", Boolean.FALSE);
        packet.setAttribute("send.attempt.times", 1);
        packet.setAttribute("send.direct.priority", 1);
        packet.setAttribute("send.packet.sequence", seq & 0xFF);
        packet.setData(new byte[0]);
        packet.setDataLength(0);
        packet.setDataOffset(0);
        packet.setServiceType(serviceType);
        packet.setCommandType(cmdType);
        packet.setAttribute("send.target.address", sourceAddress);
        ctx.getCommunicationHandle().send((AppProtocolPacket)packet, new SendCallbackHandler(){

            public void onSendTimeout(CommunicationHandle handle) {
                if (handle.getLogger() != null) {
                    handle.getLogger().log(Level.WARNING, "\u53d1\u9001ACK\u8d85\u65f6\u5931\u8d25! seq:" + seq + " destAddress:" + sourceAddress);
                }
            }

            public void onSendException(Throwable exception, CommunicationHandle handle) {
                if (handle.getLogger() != null) {
                    handle.getLogger().log(Level.SEVERE, "\u53d1\u9001ACK\u5931\u8d25! seq:" + seq + " destAddress:" + sourceAddress, exception);
                }
            }

            public void onSendCompleted(CommunicationHandle handle) {
                if (handle.getLogger() != null && handle.getLogger().isLoggable(Level.FINEST)) {
                    handle.getLogger().log(Level.FINEST, "\u53d1\u9001ACK\u6210\u529f! seq:" + seq + " destAddress:" + sourceAddress);
                }
            }
        });
    }

    public boolean isLcd(SocketAddress socketAddress) {
        Collection<Equipment> eqls;
        if (socketAddress == null) {
            return false;
        }
        if (socketAddress instanceof InetSocketAddress && (eqls = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10)) != null && !eqls.isEmpty()) {
            for (Equipment eq : eqls) {
                H2NetDisplayAction action;
                InetSocketAddress address;
                Object obj = eq.getEquipmentAction();
                if (obj == null || !(obj instanceof H2NetDisplayAction) || (address = (action = (H2NetDisplayAction)obj).getInetSocketAddress()) == null || !((Object)address).equals(socketAddress)) continue;
                return action.isLCD();
            }
        }
        return false;
    }

    protected boolean handleWrite(ProtocolContext ctx) throws Exception {
        int ba;
        Integer sendSeq;
        SocketAddress socketAddress = (SocketAddress)ctx.getAttribute("send.target.address");
        if (socketAddress == null) {
            throw new IllegalArgumentException("Unknown SocketAddress!");
        }
        Object message = ctx.getMessage();
        if (message == null) {
            throw new IllegalArgumentException("send packet is null!");
        }
        if (!(message instanceof HPKDP706Packet)) {
            throw new IllegalArgumentException("Unknown send packet!");
        }
        HPKDP706Packet appPacket = (HPKDP706Packet)((Object)message);
        if (appPacket.getDataLength() > this.getSingleMaxDataLength()) {
            throw new IllegalArgumentException("send data too long!");
        }
        int serviceType = appPacket.getServiceType() & 0xFF;
        if (serviceType > 63) {
            throw new IllegalArgumentException("wrong ServiceType: " + serviceType);
        }
        Boolean needACK = (Boolean)ctx.getAttribute("send.need.ack");
        if (needACK == null) {
            needACK = Boolean.FALSE;
        }
        int seq = (sendSeq = (Integer)ctx.getAttribute("send.packet.sequence")) == null ? this.getNextSendSequence(socketAddress) : sendSeq.intValue();
        if (this.isLcd(socketAddress)) {
            ba = 0;
            needACK = Boolean.FALSE;
            ctx.setAttribute("send.need.ack", (Object)Boolean.FALSE);
        } else if (needACK.booleanValue()) {
            ba = 128;
            Object ackkey = this.getAckKey(socketAddress, (byte)seq, appPacket.getServiceType(), appPacket.getCommandType());
            ctx.setAttribute("send.ack.key", ackkey);
        } else {
            boolean isAckFrame = appPacket instanceof AckPacket;
            ba = isAckFrame ? 64 : 0;
        }
        CRC16 crc16 = new CRC16();
        ByteBuffer byteBuffer = ByteBuffer.allocate(appPacket.getDataLength() + 10);
        byteBuffer.put((byte)-86);
        byteBuffer.put((byte)85);
        byteBuffer.put((byte)seq);
        serviceType = ba | serviceType;
        byteBuffer.put((byte)serviceType);
        crc16.update((byte)serviceType);
        byteBuffer.put(appPacket.getCommandType());
        crc16.update(appPacket.getCommandType());
        int len1 = appPacket.getDataLength() << 16 >>> 24;
        int len2 = appPacket.getDataLength() << 24 >>> 24;
        byteBuffer.put((byte)len1);
        crc16.update((byte)len1);
        byteBuffer.put((byte)len2);
        crc16.update((byte)len2);
        if (appPacket.getDataLength() > 0) {
            byteBuffer.put(appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength());
            crc16.update(appPacket.getData(), appPacket.getDataOffset(), appPacket.getDataLength());
        }
        int crcValue = crc16.getCRCValue();
        int crc1 = crcValue << 16 >>> 24;
        int crc2 = crcValue << 24 >>> 24;
        byteBuffer.put((byte)crc1);
        byteBuffer.put((byte)crc2);
        byteBuffer.put((byte)-81);
        byteBuffer.flip();
        ByteBufferPacket sendPacket = new ByteBufferPacket(byteBuffer);
        sendPacket.setSocketAddress(socketAddress);
        ByteArrayPacket[] pas = new ByteArrayPacket[]{sendPacket};
        ctx.setMessage((Object)pas);
        return true;
    }

    protected int getSingleMaxDataLength() {
        return 114;
    }

    protected int getNextSendSequence(SocketAddress communicationAddress) {
        return this.getNextSendSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSendSequence() {
        int h;
        if (this.sequenceCouter == null) {
            HPKDP706ProtocolHandler hPKDP706ProtocolHandler = this;
            synchronized (hPKDP706ProtocolHandler) {
                if (this.sequenceCouter == null) {
                    this.sequenceCouter = new AtomicInteger(-1);
                }
            }
        }
        int MaxSeq = 255;
        while ((h = this.sequenceCouter.incrementAndGet()) > MaxSeq) {
            AtomicInteger atomicInteger = this.sequenceCouter;
            synchronized (atomicInteger) {
                h = this.sequenceCouter.get();
                if (h > MaxSeq) {
                    this.sequenceCouter.set(-1);
                }
            }
        }
        return h;
    }

    protected Object getAckKey(SocketAddress socketAddress, byte seq, byte serviceType, byte cmdType) {
        return new ACKKey(socketAddress, seq, serviceType, cmdType);
    }

    protected static class ACKKey {
        SocketAddress socketAddress;
        byte seq;
        byte serviceType;
        byte cmdType;

        ACKKey(SocketAddress socketAddress, byte seq, byte serviceType, byte cmdType) {
            this.socketAddress = socketAddress;
            this.seq = seq;
            this.serviceType = serviceType;
            this.cmdType = cmdType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cmdType;
            result = 31 * result + this.seq;
            result = 31 * result + this.serviceType;
            result = 31 * result + (this.socketAddress == null ? 0 : this.socketAddress.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ACKKey other = (ACKKey)obj;
            if (this.cmdType != other.cmdType) {
                return false;
            }
            if (this.seq != other.seq) {
                return false;
            }
            if (this.serviceType != other.serviceType) {
                return false;
            }
            return !(this.socketAddress == null ? other.socketAddress != null : !this.socketAddress.equals(other.socketAddress));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ACKKey [socketAddress=");
            builder.append(this.socketAddress);
            builder.append(", seq=");
            builder.append(this.seq);
            builder.append(", serviceType=");
            builder.append(this.serviceType);
            builder.append(", cmdType=");
            builder.append(this.cmdType);
            builder.append("]");
            return builder.toString();
        }
    }

    protected static class AckPacket
    extends HPKDP706Packet {
        protected AckPacket() {
        }
    }
}

