/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.driver.ICECameraUtil;
import com.wovoe.carpark.equipment.driver.RS485ThreadHandler;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.TCPConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Deprecated
public class ICECameraAction
extends AbstractEquipmentAction
implements PlateRegCameraAction,
CameraUartAction,
RoadBarrierAction,
ServiceAction {
    private ScheduledFuture<?> shedule;
    private volatile Long hwnd;
    public static final String ACTION_NAME = "/ICEIPCameraAction";
    private volatile long lastRevTimeMills;
    private volatile Collection<PlateEntry> whiteList;
    private volatile Collection<PlateEntry> blackList;
    private final RS485ThreadHandler[] rs485ThreadHandlers = new RS485ThreadHandler[2];
    private volatile boolean stopped = false;
    private static final String op_plateCaptureData = "plateCaptureData";
    private static final String op_RS485RECEIVEDATA = "rs485resData";
    private static final String OP_PARAM_NAME = "op";
    private Object downloadLocak = new Object();

    public ICECameraAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    ICECameraAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u6444\u50cf\u673a\u5f02\u5e38,ip:" + ICECameraAction.this.equipment.getIp() + ",\u539f\u56e0: " + ex.getMessage()));
                }
            }
        }, 1000L, 4000L, TimeUnit.MILLISECONDS);
    }

    private void connectIfNotConnected1() throws Exception {
        ScheduledFuture<?> shedule1 = this.shedule;
        this.stopped = false;
        if (shedule1 == null || shedule1.isCancelled()) {
            return;
        }
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            throw new Exception("\u76f8\u673aip\u672a\u914d\u7f6e");
        }
        OperationFuture<Integer> f = ServiceUtil.getServiceContext().getLocalProcessTransport().loadNativeDriveIfNeed("com.wovoe.camera.drive.ice.Drive", "\u52a0\u8f7dICE\u76f8\u673a\u672c\u5730\u9a71\u52a8");
        Integer a = (Integer)f.get(6500L, TimeUnit.MILLISECONDS);
        if (a == null || a != 0) {
            return;
        }
        if (shedule1 == null || shedule1.isCancelled()) {
            return;
        }
        f = this.registerIfNeed();
        a = (Integer)f.get(10500L, TimeUnit.MILLISECONDS);
        if (a == null || a != 0) {
            return;
        }
        if (shedule1 == null || shedule1.isCancelled()) {
            return;
        }
        String key = ICECameraUtil.getCameraDevID(ip);
        if (key == null || key.length() <= 0) {
            throw new Exception("\u83b7\u53d6ICECamera\u8bbe\u5907id\u5931\u8d25!");
        }
        this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    synchronized void stop() {
        try {
            this.stopped = true;
            if (this.shedule != null) {
                this.shedule.cancel(true);
            }
            int i = 0;
            while (i < this.rs485ThreadHandlers.length) {
                RS485ThreadHandler rs485ThreadHandler = this.rs485ThreadHandlers[i];
                if (rs485ThreadHandler != null) {
                    rs485ThreadHandler.stop();
                    this.rs485ThreadHandlers[i] = null;
                }
                ++i;
            }
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            String opName = "[" + this.equipment.getIp() + "]\u5173\u95ed\u76f8\u673a\u8fde\u63a5";
            String serviceName = "disConnect";
            long timeoutMills = 2000L;
            paramMap.put("cameraId", this.equipment.getEquipmentNo());
            paramMap.put("ip", this.equipment.getIp());
            ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)"", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RS485ThreadHandler getRS485ThreadHandler(int index) {
        RS485ThreadHandler rs485ThreadHandler;
        block7: {
            if (this.stopped) {
                return null;
            }
            if (index < 0 || index >= this.rs485ThreadHandlers.length) {
                return null;
            }
            rs485ThreadHandler = this.rs485ThreadHandlers[index];
            if (rs485ThreadHandler != null) break block7;
            ICECameraAction iCECameraAction = this;
            synchronized (iCECameraAction) {
                block6: {
                    rs485ThreadHandler = this.rs485ThreadHandlers[index];
                    if (rs485ThreadHandler != null) break block7;
                    if (!this.stopped) break block6;
                    return null;
                }
                rs485ThreadHandler = new RS485ThreadHandler(index){

                    @Override
                    protected OperationFuture<Boolean> directSend(byte[] data) {
                        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                        try {
                            TCPConnection conn = ServiceUtil.getServiceContext().getLocalProcessTransport().getProcessConnection();
                            if (conn != null) {
                                RequestSender sender = conn.createRequest();
                                sender.setHeader(ICECameraAction.OP_PARAM_NAME, "sendRS485Data");
                                sender.setHeader("cameraId", ICECameraAction.this.equipment.getEquipmentNo());
                                sender.setHeader("ip", ICECameraAction.this.equipment.getIp());
                                sender.setHeader("uatIndex", String.valueOf(this.portIndex));
                                sender.setSendData(data);
                                sender.setRequestActionName(ICECameraAction.ACTION_NAME);
                                sender.setNeedEncrypt(false);
                                sender.doRequest(new SendCallback(){

                                    public void onException(Throwable throwabe) {
                                        xf.setException(throwabe);
                                    }

                                    public void onCompleted() {
                                    }
                                }, new ReceiveCallback(){

                                    public void onWaitTimeout() throws Exception {
                                        xf.setException((Throwable)new TimeoutException("\u7b49\u5f85\u6570\u636e\u662f\u5426\u6210\u529f\u53d1\u9001\u4e32\u53e3\u64cd\u4f5c\u8d85\u65f6"));
                                    }

                                    public long getWaitTimeoutMills() {
                                        return 3000L;
                                    }

                                    public void doReceiver(Receiver receiver, int paramInt) throws Exception {
                                        String result = receiver.getHeaderValue("result");
                                        if ("true".equals(result)) {
                                            xf.setResult((Object)Boolean.TRUE);
                                        } else {
                                            String invokeerror = receiver.getHeaderValue("invokeerror");
                                            if ("1".equals(invokeerror)) {
                                                xf.setResult((Object)Boolean.FALSE);
                                            } else {
                                                String errmsg = receiver.getHeaderValue("msg");
                                                if (errmsg == null || errmsg.length() == 0) {
                                                    errmsg = "\u8c03\u7528\u76f8\u673a\u4e32\u53e3\u53d1\u9001\u6570\u636e\u5931\u8d25";
                                                }
                                                try {
                                                    xf.setException((Throwable)new Exception(errmsg));
                                                }
                                                finally {
                                                    ServiceLog.getLog().warn((Object)(String.valueOf(ICECameraAction.this.equipment.getIp()) + ":" + errmsg));
                                                }
                                            }
                                        }
                                    }
                                });
                            } else {
                                xf.setException((Throwable)new Exception("\u672c\u5730\u8fde\u63a5\u672a\u5efa\u7acb"));
                            }
                        }
                        catch (Throwable ex) {
                            xf.setException(ex);
                        }
                        return xf;
                    }
                };
                rs485ThreadHandler.start();
                this.rs485ThreadHandlers[index] = rs485ThreadHandler;
            }
        }
        return rs485ThreadHandler;
    }

    private boolean isConnected() {
        boolean cone;
        boolean bl = cone = ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevTimeMills <= 6000L;
        if (!cone) {
            this.whiteList = null;
            this.blackList = null;
        }
        return cone;
    }

    private OperationFuture<Integer> registerIfNeed() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "\u8fde\u63a5\u76f8\u673a[" + this.equipment.getIp() + "]";
        String serviceName = "regCallbackIfNotReg";
        long timeoutMills = 10000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        Long x = this.hwnd;
        if (x != null) {
            paramMap.put("componentID", x.toString());
        }
        paramMap.put("reciveRegPlate", String.valueOf(this.isNeedRegPlate()));
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        int flowControl;
        int parity;
        int screen_mode;
        int stopBits;
        int stopBits1;
        int baudRate;
        int baudRate1;
        int dataBits;
        int dataBits1;
        int uatIndex;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570"));
            return xf;
        }
        Object uatIndex0 = param.get("uatIndex");
        if (uatIndex0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570uatIndex"));
            return xf;
        }
        if (uatIndex0 instanceof Integer) {
            uatIndex = (Integer)uatIndex0;
        } else {
            try {
                uatIndex = Integer.parseInt(uatIndex0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (uatIndex != 0 && uatIndex != 1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u65700\u6216\u80051"));
            return xf;
        }
        Object dataBits0 = param.get("dataBits");
        if (dataBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570dataBits"));
            return xf;
        }
        if (dataBits0 instanceof Integer) {
            dataBits1 = (Integer)dataBits0;
        } else {
            try {
                dataBits1 = Integer.parseInt(dataBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (dataBits1) {
            case 5: {
                dataBits = 0;
                break;
            }
            case 6: {
                dataBits = 1;
                break;
            }
            case 7: {
                dataBits = 2;
                break;
            }
            case 8: {
                dataBits = 3;
                break;
            }
            default: {
                dataBits = -1;
            }
        }
        if (dataBits == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u30105\u30016\u30017\u30018\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object baudRate0 = param.get("baudRate");
        if (baudRate0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570baudRate"));
            return xf;
        }
        if (baudRate0 instanceof Integer) {
            baudRate1 = (Integer)baudRate0;
        } else {
            try {
                baudRate1 = Integer.parseInt(baudRate0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (baudRate1) {
            case 1200: {
                baudRate = 0;
                break;
            }
            case 2400: {
                baudRate = 1;
                break;
            }
            case 4800: {
                baudRate = 2;
                break;
            }
            case 9600: {
                baudRate = 3;
                break;
            }
            case 19200: {
                baudRate = 4;
                break;
            }
            case 38400: {
                baudRate = 5;
                break;
            }
            case 115200: {
                baudRate = 6;
                break;
            }
            default: {
                baudRate = -1;
            }
        }
        if (baudRate == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u30101200\u30012400\u30014800\u30019600\u300119200\u300138400\u3001115200\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object stopBits0 = param.get("stopBits");
        if (stopBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570stopBits"));
            return xf;
        }
        if (stopBits0 instanceof Integer) {
            stopBits1 = (Integer)stopBits0;
        } else {
            try {
                stopBits1 = Integer.parseInt(stopBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (stopBits1) {
            case 1: {
                stopBits = 0;
                break;
            }
            case 2: {
                stopBits = 1;
                break;
            }
            default: {
                stopBits = -1;
            }
        }
        if (stopBits == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u30101\u30012\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object screen_mode0 = param.get("screen_mode");
        if (screen_mode0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570screen_mode"));
            return xf;
        }
        if (screen_mode0 instanceof Integer) {
            screen_mode = (Integer)screen_mode0;
        } else {
            try {
                screen_mode = Integer.parseInt(screen_mode0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (screen_mode != 1 && screen_mode != 2) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u65701\u6216\u80052"));
            return xf;
        }
        Object parity0 = param.get("parity");
        if (parity0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570parity"));
            return xf;
        }
        String parity1 = parity0.toString();
        if ("PARITY_NONE".equals(parity1)) {
            parity = 0;
        } else if ("PARITY_ODD".equals(parity1)) {
            parity = 1;
        } else if ("PARITY_EVEN".equals(parity1)) {
            parity = 2;
        } else if ("PARITY_MARK".equals(parity1)) {
            parity = 3;
        } else if ("PARITY_SPACE".equals(parity1)) {
            parity = 4;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570parity\u5fc5\u987b\u662fPARITY_NONE\u3001PARITY_ODD\u3001PARITY_EVEN\u3001PARITY_MARK\u3001PARITY_SPACE"));
            return xf;
        }
        Object flowControl0 = param.get("flowControl");
        if (flowControl0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570flowControl"));
            return xf;
        }
        String flowControl1 = flowControl0.toString();
        if ("NONE".equals(flowControl1)) {
            flowControl = 0;
        } else if ("HARDWARE".equals(flowControl1)) {
            flowControl = 1;
        } else if ("XON".equals(flowControl1)) {
            flowControl = 2;
        } else if ("XOFF".equals(flowControl1)) {
            flowControl = 3;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570flowControl\u5fc5\u987b\u662fNONE\u3001HARDWARE\u3001XON\u3001XOFF"));
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("uatIndex", String.valueOf(uatIndex));
        paramMap.put("baudRate", String.valueOf(baudRate));
        paramMap.put("dataBits", String.valueOf(dataBits));
        paramMap.put("parity", String.valueOf(parity));
        paramMap.put("stopBits", String.valueOf(stopBits));
        paramMap.put("flowControl", String.valueOf(flowControl));
        paramMap.put("screen_mode", String.valueOf(screen_mode));
        String opName = "[" + this.equipment.getIp() + "]\u68c0\u67e5\u5e76\u8bbe\u7f6e\u4e32\u53e3\u64cd\u4f5c";
        String serviceName = "setSerialIfNeed";
        long timeoutMills = 5000L;
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u9519\u8bef\u53c2\u6570:componentID:" + x));
            return xf;
        }
        this.hwnd = hwnd0;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u64ad\u653e\u89c6\u9891";
        String serviceName = "playVisible";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("componentID", hwnd0.toString());
        paramMap.put("reciveRegPlate", String.valueOf(this.isNeedRegPlate()));
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    public boolean isNeedRegPlate() {
        List<String> list = this.equipment.getChannelNos();
        boolean r = false;
        if (list != null) {
            for (String channelNo : list) {
                boolean bl = r = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) != null;
                if (r) break;
            }
        }
        return r;
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u505c\u6b62\u64ad\u653e";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        if (param == null || param.get("savePath") == null) {
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570: savePath"));
            return xf;
        }
        final String savePath = param.get("savePath").toString();
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block9: {
                    try {
                        byte[] r = ICECameraUtil.capture(ICECameraAction.this.equipment.getIp());
                        if (r == null || r.length == 0) {
                            xf.setResult((Object)1);
                            break block9;
                        }
                        try {
                            File saveF = new File(savePath);
                            File pa = saveF.getParentFile();
                            if (!pa.exists()) {
                                pa.mkdirs();
                            }
                            try (FileOutputStream out = new FileOutputStream(saveF);){
                                out.write(r);
                            }
                            xf.setResult((Object)0);
                        }
                        catch (Exception ex) {
                            xf.setException((Throwable)ex);
                        }
                    }
                    catch (Throwable ex) {
                        xf.setException(ex);
                    }
                }
            }
        });
        return xf;
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    @Override
    public boolean isWorkingProperly() {
        return this.isConnected();
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    @Override
    public boolean isSupportWhiteList() {
        return true;
    }

    @Override
    public boolean isSupportBlackList() {
        return true;
    }

    private OperationFuture<String> downloadAllList(byte[] data01) {
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            TCPConnection conn = ServiceUtil.getServiceContext().getLocalProcessTransport().getProcessConnection();
            if (conn != null && conn.isConnected()) {
                RequestSender sender = conn.createRequest();
                sender.setHeader("cameraId", this.equipment.getEquipmentNo());
                sender.setHeader("ip", this.equipment.getIp());
                sender.setHeader(OP_PARAM_NAME, "importPlateList");
                sender.setRequestActionName(ACTION_NAME);
                sender.setSendData(data01);
                sender.setNeedEncrypt(false);
                sender.doRequest((SendCallback)new SendCallback0(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c"){

                    @Override
                    public void onException(Throwable exception) {
                        try {
                            super.onException(exception);
                        }
                        finally {
                            xf.setException(exception);
                        }
                    }
                }, (ReceiveCallback)new ReceiveCallback0(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c", 660000L){

                    @Override
                    protected void opSuccess(Receiver receiver) {
                        if (receiver.getData() != null && receiver.getDataLength() > 0) {
                            String v1;
                            try {
                                v1 = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "GBK");
                            }
                            catch (UnsupportedEncodingException e) {
                                v1 = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength());
                            }
                            xf.setResult((Object)v1);
                        } else {
                            xf.setResult((Object)"");
                        }
                    }

                    @Override
                    protected void opError(Receiver receiver) {
                        if (receiver == null) {
                            xf.setException((Throwable)new Exception("\u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c\u8d85\u65f6!"));
                        } else {
                            String msg1;
                            String msg = receiver.getHeaderValue("msg");
                            if (msg == null) {
                                msg = "";
                            }
                            if ((msg1 = receiver.getHeaderValue("msg1")) == null) {
                                msg1 = "";
                            }
                            xf.setException((Throwable)new Exception("\u4e0b\u8f7d\u9ed1\u767d\u540d\u5f02\u5e38! " + msg + msg1));
                        }
                    }
                });
            } else {
                xf.setException((Throwable)new Exception("\u672a\u8fde\u63a5!"));
            }
        }
        catch (Exception ex) {
            xf.setException((Throwable)ex);
        }
        return xf;
    }

    private OperationFuture<String> queryAllList(Map<String, Object> param) {
        OperationFutureHandler xf;
        block5: {
            xf = ServiceUtil.getServiceContext().createOperationFuture();
            try {
                TCPConnection conn = ServiceUtil.getServiceContext().getLocalProcessTransport().getProcessConnection();
                if (conn != null && conn.isConnected()) {
                    RequestSender sender = conn.createRequest();
                    sender.setHeader("cameraId", this.equipment.getEquipmentNo());
                    sender.setHeader("ip", this.equipment.getIp());
                    sender.setHeader(OP_PARAM_NAME, "getPlateList");
                    sender.setRequestActionName(ACTION_NAME);
                    if (param != null && !param.isEmpty()) {
                        for (Map.Entry<String, Object> o : param.entrySet()) {
                            sender.setHeader(o.getKey(), o.getValue().toString());
                        }
                    }
                    sender.setNeedEncrypt(false);
                    sender.doRequest((SendCallback)new SendCallback0(String.valueOf(this.equipment.getIp()) + ": \u67e5\u8be2\u9ed1\u767d\u540d\u5355\u64cd\u4f5c"){

                        @Override
                        public void onException(Throwable exception) {
                            try {
                                super.onException(exception);
                            }
                            finally {
                                xf.setException(exception);
                            }
                        }
                    }, (ReceiveCallback)new ReceiveCallback0(String.valueOf(this.equipment.getIp()) + ": \u67e5\u8be2\u9ed1\u767d\u540d\u5355\u64cd\u4f5c", 30000L){

                        @Override
                        protected void opSuccess(Receiver receiver) {
                            if (receiver.getData() != null && receiver.getDataLength() > 0) {
                                String v1;
                                try {
                                    v1 = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "GBK");
                                }
                                catch (UnsupportedEncodingException e) {
                                    v1 = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength());
                                }
                                xf.setResult((Object)v1);
                            } else {
                                xf.setResult((Object)"");
                            }
                        }

                        @Override
                        protected void opError(Receiver receiver) {
                            String evl1;
                            String evl = receiver == null ? null : receiver.getHeaderValue("msg");
                            String string = evl1 = receiver == null ? null : receiver.getHeaderValue("msg1");
                            if (evl == null) {
                                evl = "";
                            }
                            if (evl1 == null) {
                                evl1 = "";
                            }
                            xf.setException((Throwable)new Exception("\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u64cd\u4f5c\u5931\u8d25!" + evl + " " + evl1));
                        }
                    });
                    break block5;
                }
                throw new Exception("\u672a\u8fde\u63a5!");
            }
            catch (Exception ex) {
                xf.setException((Throwable)ex);
            }
        }
        return xf;
    }

    @Override
    public void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList0, Collection<PlateEntry> blackList0, PlateRegCameraAction.ImportPlateCallback callback) throws Exception {
        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, false);
    }

    private int getHanleStringCount(StringBuilder s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int count = 0;
        char v2 = '$';
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == v2) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList0, Collection<PlateEntry> blackList0, PlateRegCameraAction.ImportPlateCallback callback, boolean onlyCheck) throws Exception {
        try {
            if (callback != null) {
                callback.onCheck(this.equipment.getEquipmentNo(), onlyCheck);
            }
            if (!this.isConnected()) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            Object object = this.downloadLocak;
            synchronized (object) {
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd");
                Collection<PlateEntry> whiteList1 = this.whiteList;
                Collection<PlateEntry> blackList1 = this.blackList;
                if (whiteList1 == null || blackList1 == null) {
                    OperationFuture<String> v;
                    String v1;
                    if (callback != null) {
                        callback.onQueryAll(this.equipment.getEquipmentNo());
                    }
                    if ((v1 = (String)(v = this.queryAllList(null)).get(31L, TimeUnit.SECONDS)) == null) {
                        throw new Exception("\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u8bb0\u5f55\u8d85\u65f6!");
                    }
                    whiteList1 = new LinkedList<PlateEntry>();
                    blackList1 = new LinkedList<PlateEntry>();
                    if ((v1 = v1.trim()).length() > 0) {
                        String[] v2 = v1.split(",");
                        int i = 0;
                        while (i < v2.length) {
                            String v3 = ((String)v2[i]).trim();
                            if (v3.length() > 0) {
                                String[] a1;
                                String[] stringArray = a1 = v3.split("\\$");
                                int n = a1.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String[] t4;
                                    String a2 = stringArray[n2];
                                    if ((a2 = a2.trim()).length() != 0 && (t4 = a2.split("-")).length >= 3) {
                                        String plate = t4[0].trim();
                                        String date1 = t4[1].trim();
                                        String date2 = t4[2].trim();
                                        if (plate.length() > 0 && date1.length() > 0) {
                                            try {
                                                PlateEntry ell = new PlateEntry(plate, df1.format(df2.parse(date1)), df1.format(df2.parse(date2)));
                                                if (i == 0) {
                                                    whiteList1.add(ell);
                                                } else if (i == 1) {
                                                    blackList1.add(ell);
                                                }
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            ++i;
                        }
                    }
                    this.whiteList = whiteList1;
                    this.blackList = blackList1;
                }
                if (callback != null) {
                    callback.onQueryAllFinish(this.equipment.getEquipmentNo(), whiteList1.size(), blackList1.size(), whiteList0 == null ? 0 : whiteList0.size(), blackList0 == null ? 0 : blackList0.size());
                }
                String invalp = "-";
                String rinval = "";
                HashMap<String, PlateEntry> whiteList001Map = new HashMap<String, PlateEntry>();
                HashMap<String, PlateEntry> blackList001Map = new HashMap<String, PlateEntry>();
                for (PlateEntry e : whiteList1) {
                    whiteList001Map.put(e.getPlate(), e);
                }
                for (PlateEntry e : blackList1) {
                    blackList001Map.put(e.getPlate(), e);
                }
                HashMap<String, PlateEntry> whiteList002Map = new HashMap<String, PlateEntry>();
                if (whiteList0 != null) {
                    for (PlateEntry e : whiteList0) {
                        if (e.getPlate() != null && e.getPlate().indexOf(invalp) >= 0) {
                            e.setPlate(e.getPlate().replaceAll(invalp, rinval));
                        }
                        whiteList002Map.put(e.getPlate(), e);
                    }
                }
                HashMap<String, PlateEntry> blackList002Map = new HashMap<String, PlateEntry>();
                if (blackList0 != null) {
                    for (PlateEntry e : blackList0) {
                        if (e.getPlate() != null && e.getPlate().indexOf(invalp) >= 0) {
                            e.setPlate(e.getPlate().replaceAll(invalp, rinval));
                        }
                        blackList002Map.put(e.getPlate(), e);
                    }
                }
                StringBuilder insertW = new StringBuilder();
                StringBuilder updateW = new StringBuilder();
                StringBuilder deleteW = new StringBuilder();
                StringBuilder insertB = new StringBuilder();
                StringBuilder updateB = new StringBuilder();
                StringBuilder deleteB = new StringBuilder();
                LinkedList<PlateEntry> simpleList1 = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> simpleList2 = new LinkedList<PlateEntry>();
                this.setList(insertW, updateW, deleteW, whiteList001Map, whiteList002Map, simpleList1);
                this.setList(insertB, updateB, deleteB, blackList001Map, blackList002Map, simpleList2);
                if (insertW.length() == 0 && updateW.length() == 0 && deleteW.length() == 0 && insertB.length() == 0 && updateB.length() == 0 && deleteB.length() == 0) {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), 0, 0, 0, simpleList1.size(), 0, 0, 0, simpleList2.size(), onlyCheck);
                    }
                } else {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), this.getHanleStringCount(insertW), this.getHanleStringCount(updateW), this.getHanleStringCount(deleteW), simpleList1.size(), this.getHanleStringCount(insertB), this.getHanleStringCount(updateB), this.getHanleStringCount(deleteB), simpleList2.size(), onlyCheck);
                    }
                    if (onlyCheck) {
                        return;
                    }
                    if (ServiceLog.getLog().isInfoEnabled()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u53d1\u73b0\u8f66\u724c\u9700\u8981\u540c\u6b65\uff0c\u51c6\u5907\u4e0b\u8f7d\u6700\u65b0\u7684\u8f66\u724c\u4fe1\u606f! "));
                    }
                    if (callback != null) {
                        callback.onStartDownlod(this.equipment.getEquipmentNo());
                    }
                    boolean needRecheck = false;
                    try {
                        if ((whiteList0 == null || whiteList0.isEmpty()) && (blackList0 == null || blackList0.isEmpty())) {
                            Integer h = (Integer)this.clearBlackOrWhiteList(2).get(61L, TimeUnit.SECONDS);
                            if (h == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u8d85\u65f6!");
                            }
                            if (h != 0) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25!");
                            }
                            ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u9ed1\u767d\u540d\u5355\u5df2\u88ab\u6e05\u7a7a"));
                            if (callback != null) {
                                LinkedList<PlateEntry> emptyList = new LinkedList<PlateEntry>();
                                Collection<PlateEntry> wcl = whiteList002Map.values();
                                Collection<PlateEntry> bcl = blackList002Map.values();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), wcl, bcl, whiteList1, emptyList, blackList1, emptyList);
                            }
                            needRecheck = true;
                        } else {
                            StringBuilder sbr0 = new StringBuilder();
                            sbr0.append((CharSequence)insertW).append(',').append((CharSequence)updateW).append(',').append((CharSequence)deleteW).append(';');
                            sbr0.append((CharSequence)insertB).append(',').append((CharSequence)updateB).append(',').append((CharSequence)deleteB);
                            byte[] data01 = sbr0.toString().getBytes("GBK");
                            String h = (String)this.downloadAllList(data01).get(10L, TimeUnit.MINUTES);
                            if (h == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u8d85\u65f6!");
                            }
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c\u5b8c\u6210!"));
                            }
                            LinkedList<PlateEntry> whiteSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> whiteFaild = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackFaild = new LinkedList<PlateEntry>();
                            if (h.length() > 0) {
                                String[] vl = h.split(";");
                                int i = 0;
                                while (i < vl.length) {
                                    if (vl[i].length() > 0) {
                                        String[] l1 = vl[i].split(",");
                                        int j = 0;
                                        while (j < l1.length) {
                                            if (l1[j].length() > 0) {
                                                String[] la1;
                                                String[] stringArray = la1 = l1[j].split("\\$");
                                                int n = la1.length;
                                                int n3 = 0;
                                                while (n3 < n) {
                                                    String gj = stringArray[n3];
                                                    if (gj.length() > 0) {
                                                        PlateEntry th;
                                                        if (i == 0 && j == 0) {
                                                            th = whiteList002Map.get(gj);
                                                            if (th != null) {
                                                                whiteSuccess.add(th);
                                                            }
                                                        } else if (i == 1 && j == 0) {
                                                            th = whiteList002Map.get(gj);
                                                            if (th != null) {
                                                                whiteFaild.add(th);
                                                            }
                                                        } else if (i == 0 && j == 1) {
                                                            th = blackList002Map.get(gj);
                                                            if (th != null) {
                                                                blackSuccess.add(th);
                                                            }
                                                        } else if (i == 1 && j == 1 && (th = blackList002Map.get(gj)) != null) {
                                                            blackFaild.add(th);
                                                        }
                                                    }
                                                    ++n3;
                                                }
                                            }
                                            ++j;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                String ip = this.equipment.getIp();
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u767d\u540d\u5355\u603b\u8f66\u724c\u6570: " + whiteList002Map.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleList1.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + whiteSuccess.size() + " " + whiteSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + whiteFaild.size() + " " + whiteFaild));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u9ed1\u540d\u5355\u603b\u8f66\u724c\u6570: " + blackList002Map.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleList2.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + blackSuccess.size() + " " + blackSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + blackFaild.size() + " " + blackFaild));
                            }
                            if (callback != null) {
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList002Map.values(), blackList002Map.values(), whiteSuccess, whiteFaild, blackSuccess, blackFaild);
                            }
                            if (whiteFaild.size() == 0 && blackFaild.size() == 0) {
                                needRecheck = true;
                            }
                        }
                    }
                    finally {
                        this.whiteList = null;
                        this.blackList = null;
                    }
                    if (!onlyCheck && needRecheck) {
                        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                callback.onDownlodException(this.equipment.getEquipmentNo(), ex);
            }
            throw ex;
        }
    }

    private void setList(StringBuilder insert, StringBuilder update, StringBuilder delete, HashMap<String, PlateEntry> oldMap, HashMap<String, PlateEntry> newMap, List<PlateEntry> simpleList) throws Exception {
        char v1 = '-';
        char v2 = '$';
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy/MM/dd");
        for (Map.Entry<String, PlateEntry> newe : newMap.entrySet()) {
            PlateEntry owd = oldMap.remove(newe.getValue().getPlate());
            if (owd == null) {
                insert.append(newe.getValue().getPlate()).append(v1).append(df2.format(df1.parse(newe.getValue().getBeginDate()))).append(v1).append(df2.format(df1.parse(newe.getValue().getEndDate()))).append(v2);
                continue;
            }
            if (!newe.getValue().equals(owd)) {
                update.append(newe.getValue().getPlate()).append(v1).append(df2.format(df1.parse(newe.getValue().getBeginDate()))).append(v1).append(df2.format(df1.parse(newe.getValue().getEndDate()))).append(v2);
                continue;
            }
            simpleList.add(newe.getValue());
        }
        if (!oldMap.isEmpty()) {
            for (Map.Entry<String, PlateEntry> newe : oldMap.entrySet()) {
                delete.append(newe.getValue().getPlate()).append(v2);
            }
        }
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (data == null || data.length == 0) {
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        RS485ThreadHandler shandler = this.getRS485ThreadHandler(portIndex);
        if (shandler == null || !shandler.isStarted()) {
            if (this.stopped) {
                f.setException((Throwable)new IllegalStateException("\u9a71\u52a8\u5df2\u7ecf\u505c\u6b62!"));
                return f;
            }
            f.setException((Throwable)new IllegalStateException("\u521d\u59cb\u5316\u53d1\u9001\u4e32\u53e3\u7ebf\u7a0b\u5931\u8d25!"));
            return f;
        }
        shandler.sendToQueue(data, handler, f, waitMills);
        return f;
    }

    public void service(Receiver request) throws Exception {
        String _uatIndex;
        String op = request.getHeaderValue(OP_PARAM_NAME);
        if (op_plateCaptureData.equals(op)) {
            if (this.equipment.getUse() != 1) {
                return;
            }
            String plateNumber = request.getHeaderValue("plateNumber");
            String plateColor = request.getHeaderValue("plateColor");
            String vehicleColor = request.getHeaderValue("vehicleColor");
            String savePath = request.getHeaderValue("savePath");
            String smallSavePath = request.getHeaderValue("smallSavePath");
            String carLogo = request.getHeaderValue("carLogo");
            String _carSpeed = request.getHeaderValue("carSpeed");
            String _carType = request.getHeaderValue("carType");
            String carTypeName = request.getHeaderValue("carTypeName");
            String _plateConfidence = request.getHeaderValue("plateConfidence");
            String _plateType = request.getHeaderValue("plateType");
            String plateTypeName = request.getHeaderValue("plateTypeName");
            String _plateJudge = request.getHeaderValue("plateJudge");
            String plateJudgeName = request.getHeaderValue("plateJudgeName");
            String _dir = request.getHeaderValue("dir");
            String dirName = request.getHeaderValue("dirName");
            if (plateNumber != null) {
                CameraEvent event = new CameraEvent(this.equipment, plateNumber, plateColor, savePath);
                event.setCarLogo(carLogo);
                if (_carSpeed != null && _carSpeed.length() > 0) {
                    try {
                        event.setCarSpeed(Integer.valueOf(_carSpeed));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (_carType != null && _carType.length() > 0) {
                    try {
                        event.setCarType(Integer.valueOf(_carType));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setCarTypeDes(carTypeName);
                if (_dir != null && _dir.length() > 0) {
                    try {
                        event.setDir(Integer.valueOf(_dir));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setDirDes(dirName);
                if (_plateConfidence != null && _plateConfidence.length() > 0) {
                    try {
                        event.setPlateConfidence(Float.valueOf(_plateConfidence));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (_plateJudge != null && _plateJudge.length() > 0) {
                    try {
                        event.setPlateJudge(Integer.valueOf(_plateJudge));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setPlateJudgeDes(plateJudgeName);
                event.setPlateSmallPath(smallSavePath);
                if (_plateType != null && _plateType.length() > 0) {
                    try {
                        event.setPlateType(Integer.valueOf(_plateType));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setPlateTypeDes(plateTypeName);
                event.setVehicleColor(vehicleColor);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
            }
        } else if (op_RS485RECEIVEDATA.equals(op) && (_uatIndex = request.getHeaderValue("uatIndex")) != null && _uatIndex.length() > 0) {
            RS485ThreadHandler rs485ThreadHandler;
            int uatIndex;
            try {
                uatIndex = Integer.parseInt(_uatIndex);
            }
            catch (Exception ex) {
                uatIndex = -1;
            }
            if (uatIndex >= 0 && uatIndex < this.rs485ThreadHandlers.length && (rs485ThreadHandler = this.rs485ThreadHandlers[uatIndex]) != null && rs485ThreadHandler.isStarted()) {
                byte[] data = request.getData();
                int dataOffset = request.getDataOffset();
                int datalen = request.getDataLength();
                if (data != null && datalen > 0) {
                    rs485ThreadHandler.handleRecevie(data, dataOffset, datalen);
                }
            }
        }
    }

    private OperationFuture<Integer> clearBlackOrWhiteList(int hv) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u6e05\u7a7a\u9ed1\u767d\u540d\u5355";
        String serviceName = "clearBlackOrWhiteList";
        long timeoutMills = 60000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("hv", String.valueOf(hv));
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> triggerRegPlate() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u89e6\u53d1\u8f6f\u8bc6\u522b";
        String serviceName = "triggerRegPlate";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u5f00\u95f8";
        String serviceName = "openGate";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return ServiceUtil.getServiceContext().getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return false;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    private static class ReceiveCallback0
    implements ReceiveCallback {
        String opName;
        long timeoutMills;

        ReceiveCallback0(String opName, long timeoutMills) {
            this.opName = opName;
            this.timeoutMills = timeoutMills;
        }

        public void onWaitTimeout() throws Exception {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.opName) + " \u8d85\u65f6!"));
            this.opError(null);
        }

        public long getWaitTimeoutMills() {
            return this.timeoutMills;
        }

        protected void opSuccess(Receiver receiver) {
        }

        protected void opError(Receiver receiver) {
        }

        public void doReceiver(Receiver receiver, int sendId) throws Exception {
            String rx = receiver.getHeaderValue("result");
            if ("true".equals(rx)) {
                if (ServiceLog.getLog().isDebugEnabled()) {
                    ServiceLog.getLog().debug((Object)(String.valueOf(this.opName) + " \u64cd\u4f5c\u6210\u529f!"));
                }
                this.opSuccess(receiver);
            } else {
                if ("error".equals(rx) || "false".equals(rx)) {
                    String msg1;
                    StringBuilder sbr = new StringBuilder();
                    sbr.append(String.valueOf(this.opName) + " \u64cd\u4f5c\u5931\u8d25! ");
                    String msg = receiver.getHeaderValue("msg");
                    if (msg != null) {
                        sbr.append(' ').append(msg);
                    }
                    if ((msg1 = receiver.getHeaderValue("msg1")) != null) {
                        sbr.append(' ').append(msg1);
                    }
                    ServiceLog.getLog().warn((Object)sbr.toString());
                }
                this.opError(receiver);
            }
        }
    }

    private static class SendCallback0
    implements SendCallback {
        String opName;

        SendCallback0(String opName) {
            this.opName = opName;
        }

        public void onException(Throwable exception) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.opName) + " \u547d\u4ee4\u53d1\u9001\u5931\u8d25!" + exception.getMessage()));
        }

        public void onCompleted() {
            if (ServiceLog.getLog().isDebugEnabled()) {
                ServiceLog.getLog().debug((Object)(String.valueOf(this.opName) + " \u547d\u4ee4\u53d1\u9001\u6210\u529f!"));
            }
        }
    }
}

