/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.net.LanPassChannelHandleAction;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.driver.ICECameraUtil;
import com.wovoe.carpark.equipment.driver.QLMCameraAction;
import com.wovoe.carpark.equipment.driver.ZSCameraAction;
import com.wovoe.carpark.equipment.driver.ZSRGCameraAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.UpgradeService;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ICECameraRoadGateAction
extends AbstractEquipmentAction
implements RoadBarrierAction,
AlwaysOpenAction,
RoadBarrierStateAction,
RoadBarrierStateSupport {
    private volatile EquipmentState equipmentState;
    private volatile long equipmentStateMills;
    private volatile long menuOpenPoleMills;
    private volatile boolean alwaysOpening;
    private volatile long alwaysOpenMills;
    private volatile long setRemoteAlwaysOpenMills;
    private volatile long openCouterMills;
    private ScheduledFuture<?> sh;
    private final Object lock = new Object();
    private volatile int gateIoState = -1;
    private volatile long gettingGateIoStateMills;

    public ICECameraRoadGateAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.sh != null) {
            this.sh.cancel(true);
        }
        this.sh = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate((Runnable)new JobTask(){

            protected void doRun() throws Exception {
                ICECameraRoadGateAction.this.doSRun();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    synchronized void stop() {
        if (this.sh != null) {
            this.sh.cancel(true);
            this.sh = null;
        }
    }

    public RoadBarrierAction getRealRoadBarrierAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action != this && action instanceof RoadBarrierAction) {
            return (RoadBarrierAction)action;
        }
        return null;
    }

    @Override
    public boolean isWorkingProperly() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action != null) {
            return action.isWorkingProperly();
        }
        return false;
    }

    private boolean isSupportStateDetected() {
        return this.isSupportBarrierStateDetected();
    }

    @Override
    public boolean isSupportBarrierStateDetected() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action != null && action != this) {
            boolean x;
            if (action instanceof RoadBarrierStateSupport && (x = ((RoadBarrierStateSupport)((Object)action)).isSupportBarrierStateDetected())) {
                return true;
            }
            ZSRGCameraAction rgAction = this.getEnableGateStatusZSRGCameraAction();
            if (rgAction != null) {
                return true;
            }
        }
        return false;
    }

    private ZSRGCameraAction getEnableGateStatusZSRGCameraAction() {
        List<String> list;
        ZSRGCameraAction a = null;
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action != null && (list = action.getEquipment().getChannelNos()) != null && !list.isEmpty()) {
            String channelNo = list.get(0);
            Collection<Equipment> cl = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(33);
            if (cl != null) {
                for (Equipment eq : cl) {
                    ZSRGCameraAction z;
                    List<String> list0 = eq.getChannelNos();
                    if (list0 == null || !list0.contains(channelNo) || !(eq.getEquipmentAction() instanceof ZSRGCameraAction) || !(z = (ZSRGCameraAction)eq.getEquipmentAction()).isWorkingProperly() || !z.isEnableGateStatusDetect() || z.getRoadBarrierStateAction() != this) continue;
                    a = z;
                    break;
                }
            }
        }
        return a;
    }

    @Override
    public EquipmentState getEquipmentState() {
        if (!this.isWorkingProperly()) {
            return EquipmentState.DISCONNECTED;
        }
        RoadBarrierAction ac = this.getRealRoadBarrierAction();
        if (ac != null && ac.getEquipment() != null && ac.getEquipment().getAttribute("AlwaysOpen") != null) {
            return EquipmentState.BARRIER_RAISED_IN_PLACE;
        }
        if (this.isSupportStateDetected()) {
            return this.equipmentState;
        }
        if (this.equipmentState != null && ServiceUtil.getServiceContext().currentTimeMillis() - this.equipmentStateMills < 8000L) {
            return this.equipmentState;
        }
        return this.isWorkingProperly() ? EquipmentState.BARRIER_DROPPED_IN_PLACE : EquipmentState.DISCONNECTED;
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        if (this.isAlwaysOpen()) {
            LinkedList<CarparkHost> hostList = null;
            if (this.equipment.getChannelNos() != null && !this.equipment.getChannelNos().isEmpty()) {
                for (String channelNo : this.equipment.getChannelNos()) {
                    CarparkHost boxHost;
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                    if (passChannel == null || (boxHost = passChannel.getLanManageHost()) == null) continue;
                    if (hostList == null) {
                        hostList = new LinkedList<CarparkHost>();
                        hostList.add(boxHost);
                        continue;
                    }
                    boolean exist = false;
                    for (CarparkHost h : hostList) {
                        if (!h.getHost_no().equals(boxHost.getHost_no())) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    hostList.add(boxHost);
                }
            }
            if (hostList == null || hostList.isEmpty()) {
                RoadBarrierAction action = this.getRealRoadBarrierAction();
                OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
                if (action == null || !action.isWorkingProperly()) {
                    f.setResult((Object)1);
                } else {
                    f.setResult((Object)0);
                }
                return f;
            }
            LinkedList<HostSate> connectState = null;
            for (CarparkHost host : hostList) {
                HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
                if (state == null) continue;
                if (state.getHostNo() == null || state.getHostNo().length() == 0) {
                    state.setHostNo(host.getHost_no());
                }
                if (connectState == null) {
                    connectState = new LinkedList<HostSate>();
                }
                connectState.add(state);
            }
            if (connectState != null && connectState.size() == hostList.size()) {
                RoadBarrierAction action = this.getRealRoadBarrierAction();
                OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
                if (action == null || !action.isWorkingProperly()) {
                    f.setResult((Object)1);
                } else {
                    f.setResult((Object)0);
                }
                return f;
            }
        }
        return this.doRaisePoleAction0(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationFuture<Integer> doRaisePoleAction0(boolean alwaysOpen, final boolean task) {
        Object object = this.lock;
        synchronized (object) {
            final RoadBarrierAction action = this.getRealRoadBarrierAction();
            if (action == null) {
                OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
                f.setResult((Object)1);
                return f;
            }
            OperationFuture.CompleteListener<Integer> l = new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                }

                public void operationComplete(OperationFuture<Integer> f) {
                    if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                        long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                        ICECameraRoadGateAction.this.openCouterMills = c1;
                        if (!ICECameraRoadGateAction.this.isSupportStateDetected()) {
                            ICECameraRoadGateAction.this.equipmentStateMills = c1;
                            ICECameraRoadGateAction.this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                        }
                    }
                }
            };
            this.menuOpenPoleMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.openCouterMills = 0L;
            HostSate state = this.getOpenGateHostState(action);
            if (state == null) {
                OperationFuture<Integer> op = action.doRaisePoleAction();
                op.addCompleteListener((OperationFuture.CompleteListener)l);
                return op;
            }
            final OperationFutureHandler zop = ServiceUtil.getServiceContext().createOperationFuture();
            zop.addCompleteListener((OperationFuture.CompleteListener)l);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("eqNo", this.equipment.getEquipmentNo());
            paramMap.put("alwaysOpen", alwaysOpen ? Constants.YES_STR : Constants.NO_STR);
            final long mills = ServiceUtil.getServiceContext().currentTimeMillis();
            OperationFuture<KeyValueEntry<String, String>> pp1 = LanPassChannelHandleAction.doLanOpenGate(state.getHostNo(), state.getLanSocketAddress(), paramMap);
            pp1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<KeyValueEntry<String, String>>(){

                public void operationComplete(OperationFuture<KeyValueEntry<String, String>> f1) {
                    if (f1.isCancelled()) {
                        this.hanleError("Cancelled", "Cancelled");
                    } else if (f1.getException() != null) {
                        this.hanleError("Exception", f1.getException().getMessage());
                    } else {
                        KeyValueEntry lv = (KeyValueEntry)f1.getResult();
                        if (lv == null || lv.getKey() == null || ((String)lv.getKey()).length() == 0) {
                            this.hanleError("NullResult", "NullResult");
                        } else if ("SUCCESS".equals(lv.getKey())) {
                            zop.setResult((Object)0);
                        } else {
                            this.hanleError((String)lv.getKey(), (String)lv.getValue());
                        }
                    }
                }

                public void waitCompleteTimeout() {
                    this.hanleError("Timeout", "Wait response timeout");
                }

                private void hanleError(String errorCode, String messaage) {
                    if (!action.isWorkingProperly()) {
                        String msg = String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\u7684\u63a7\u5236\u4e91\u7f51\u5173\u4e3b\u673a\u5f00\u95f8\u5931\u8d25\uff0c\u672c\u673a\u5c06\u91cd\u65b0\u5c1d\u8bd5\u5f00\u95f8, \u539f\u56e0\u53ef\u80fd\u662f\u9053\u95f8\u4e0d\u5728\u7ebf\u5bfc\u81f4\uff01 \u8fd4\u56de\u9519\u8bef\uff1a" + messaage + ", \u8017\u65f6\uff1a" + (ServiceUtil.getServiceContext().currentTimeMillis() - mills);
                        ServiceLog.getLog().info((Object)msg);
                        zop.setResult((Object)1);
                    } else {
                        String msg = String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\u7684\u63a7\u5236\u4e91\u7f51\u5173\u4e3b\u673a\u5f00\u95f8\u5931\u8d25\uff0c\u672c\u673a\u5c06\u91cd\u65b0\u5c1d\u8bd5\u5f00\u95f8";
                        ServiceLog.getLog().info((Object)(String.valueOf(msg) + ", \u9519\u8bef\u63cf\u8ff0\uff1a" + messaage + ", \u8017\u65f6(\u6beb\u79d2): " + (ServiceUtil.getServiceContext().currentTimeMillis() - mills)));
                        if (!task) {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(ICECameraRoadGateAction.this.equipment, msg, 3));
                        }
                        this.reOpenLocal();
                    }
                }

                private void reOpenLocal() {
                    OperationFuture<Integer> op = action.doRaisePoleAction();
                    op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> futrue) {
                            if (futrue.isCancelled()) {
                                zop.cancel(true);
                            } else if (futrue.getException() != null) {
                                zop.setException(futrue.getException());
                            } else {
                                zop.setResult((Object)((Integer)futrue.getResult()));
                            }
                        }

                        public void waitCompleteTimeout() {
                            zop.setException((Throwable)new TimeoutException("Wait response timeout"));
                        }
                    });
                }
            });
            return zop;
        }
    }

    public HostSate getOpenGateHostState(RoadBarrierAction action) {
        if (action.getEquipment() == null) {
            return null;
        }
        String v = action.getEquipment().getEquipmentConfig().getConfigValue("inputIO2");
        if (v == null || v.length() == 0) {
            return null;
        }
        if (!"1".equals(v) && !"2".equals(v)) {
            return null;
        }
        List<String> list = action.getEquipment().getChannelNos();
        if (list == null || list.isEmpty()) {
            return null;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(list.get(0));
        if (channel == null) {
            return null;
        }
        HostSate state = channel.getLanConnectManageHostState();
        if (state == null || state.getLanSocketAddress() == null) {
            return null;
        }
        if (state.getVer() == null || state.getVer().length() == 0) {
            return null;
        }
        UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
        if (upgradeService.compareVersion(state.getVer(), "6.2.6.38") < 0) {
            return null;
        }
        return state;
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action == null) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setResult((Object)1);
            return f;
        }
        if (this.isAlwaysOpen()) {
            String ax;
            PassChannel passChannel;
            this.setAlwaysOpen(false);
            if (this.equipment.getChannelNos() != null && !this.equipment.getChannelNos().isEmpty() && (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(this.equipment.getChannelNos().get(0))) != null) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(passChannel.getChannel().getChannel_name()) + "\uff1a\u8f66\u961f\u6a21\u5f0f\u5df2\u5173\u95ed", 1));
            }
            if ((ax = this.equipment.getEquipmentConfig().getConfigValue("cancel_alwaysopen_close_pole")) != null && "1".equals(ax)) {
                return this.doDownPoleAction1();
            }
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setResult((Object)0);
            return f;
        }
        return this.doDownPoleAction1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> doDownPoleAction1() {
        Object object = this.lock;
        synchronized (object) {
            RoadBarrierAction action = this.getRealRoadBarrierAction();
            if (action == null) {
                OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
                f.setResult((Object)1);
                return f;
            }
            OperationFuture<Integer> of = action.doDownPoleAction();
            final long m1 = this.menuOpenPoleMills;
            of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void operationComplete(OperationFuture<Integer> f) {
                    if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                        if (m1 == ICECameraRoadGateAction.this.menuOpenPoleMills) {
                            ICECameraRoadGateAction.this.menuOpenPoleMills = 0L;
                        }
                        if (!ICECameraRoadGateAction.this.isSupportStateDetected()) {
                            long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                            ICECameraRoadGateAction.this.equipmentStateMills = c1;
                            ICECameraRoadGateAction.this.equipmentState = EquipmentState.BARRIER_DROPPED_IN_PLACE;
                        }
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
            return of;
        }
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action == null) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setResult((Object)1);
            return f;
        }
        return action.doStopPoleAction();
    }

    @Override
    public boolean isSupportStopPole() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action == null) {
            return false;
        }
        return action.isSupportStopPole();
    }

    @Override
    public boolean isSupportDownPole() {
        RoadBarrierAction action = this.getRealRoadBarrierAction();
        if (action == null) {
            return false;
        }
        return action.isSupportDownPole();
    }

    @Override
    @Deprecated
    public void setPoleSate(EquipmentState state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSRun() {
        Object object = this.lock;
        synchronized (object) {
            EquipmentConfig config;
            ZSCameraAction zsAction;
            boolean isWorkNormal;
            RoadBarrierAction action;
            boolean hasBox = false;
            if (this.equipment.getChannelNos() != null && !this.equipment.getChannelNos().isEmpty()) {
                for (String channelNo : this.equipment.getChannelNos()) {
                    CarparkHost boxHost;
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                    if (passChannel == null || (boxHost = passChannel.getLanManageHost()) == null) continue;
                    hasBox = true;
                }
            }
            if ((action = this.getRealRoadBarrierAction()) == null || !action.isWorkingProperly()) {
                this.gateIoState = -1;
                isWorkNormal = false;
            } else {
                isWorkNormal = true;
            }
            if (this.alwaysOpening) {
                if (!hasBox && isWorkNormal) {
                    if (action instanceof ZSCameraAction) {
                        zsAction = (ZSCameraAction)action;
                        config = zsAction.getEquipment().getEquipmentConfig();
                        Integer io = config.getConfigIntValue("roadGateIO");
                        if (io == null) {
                            io = 0;
                        }
                        long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                            this.gettingGateIoStateMills = tx;
                            OperationFuture<Integer> of = zsAction.doGetOutIOState(io);
                            of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                    ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                }

                                public void operationComplete(OperationFuture<Integer> fu) {
                                    ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                    if (fu.getException() == null && fu.getResult() != null && ((Integer)fu.getResult() == 0 || (Integer)fu.getResult() == 1)) {
                                        ICECameraRoadGateAction.this.gateIoState = (Integer)fu.getResult();
                                        if ((Integer)fu.getResult() == 0) {
                                            ZSCameraAction zsAction = (ZSCameraAction)action;
                                            zsAction.doOpenGateWithDelay(0, 1);
                                        } else {
                                            long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                            ICECameraRoadGateAction.this.menuOpenPoleMills = c1;
                                            ICECameraRoadGateAction.this.openCouterMills = c1;
                                            if (!ICECameraRoadGateAction.this.isSupportStateDetected()) {
                                                ICECameraRoadGateAction.this.equipmentStateMills = c1;
                                                ICECameraRoadGateAction.this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    } else if (action instanceof QLMCameraAction) {
                        long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                            this.gettingGateIoStateMills = tx;
                            final QLMCameraAction qlmAction = (QLMCameraAction)action;
                            qlmAction.getCheduiMode().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void operationComplete(OperationFuture<Integer> future) {
                                    if (!(future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0 && (Integer)future.getResult() != 1)) {
                                        ICECameraRoadGateAction.this.gateIoState = (Integer)future.getResult();
                                        Object object = ICECameraRoadGateAction.this.lock;
                                        synchronized (object) {
                                            if (ICECameraRoadGateAction.this.alwaysOpening && (Integer)future.getResult() == 0) {
                                                qlmAction.enableCheduiMode(true).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                                    public void operationComplete(OperationFuture<Integer> f1) {
                                                        if (f1.getResult() != null && (Integer)f1.getResult() == 0) {
                                                            ICECameraRoadGateAction.this.gateIoState = 1;
                                                        }
                                                    }

                                                    public void waitCompleteTimeout() {
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    } else if (action.getDriver() != null && "wovoe_ice_ip_camera_driver".equals(action.getDriver().getName())) {
                        long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                            this.gettingGateIoStateMills = tx;
                            EquipmentConfig config2 = action.getEquipment().getEquipmentConfig();
                            Integer outIoIndex = config2.getConfigIntValue("roadGateIO");
                            if (outIoIndex == null) {
                                outIoIndex = 0;
                            }
                            if (outIoIndex < 0) {
                                outIoIndex = 0;
                            } else if (outIoIndex > 3) {
                                outIoIndex = 3;
                            }
                            String ip = action.getEquipment().getIp();
                            KeyValueEntry<Integer, List<ICECameraUtil.RelayOutputs>> kv = ICECameraUtil.getRelayOutputs(ip);
                            if (kv != null && (Integer)kv.getKey() == 0 && kv.getValue() != null && !((List)kv.getValue()).isEmpty()) {
                                ICECameraUtil.RelayOutputs outPuts = null;
                                for (ICECameraUtil.RelayOutputs a : (List)kv.getValue()) {
                                    if (a == null || a.outIoIndex != outIoIndex) continue;
                                    outPuts = a;
                                    break;
                                }
                                if (outPuts != null && outPuts.state == 0 && outPuts.delayTimeSec == -1) {
                                    long c1;
                                    this.gateIoState = 1;
                                    this.menuOpenPoleMills = c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                    this.openCouterMills = c1;
                                    if (!this.isSupportStateDetected()) {
                                        this.equipmentStateMills = c1;
                                        this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                                    }
                                } else {
                                    int result = ICECameraUtil.setRelayOutputs(ip, outIoIndex, 0, -1);
                                    if (result == 0) {
                                        this.gateIoState = 1;
                                        this.doRaisePoleAction0(false, true);
                                    } else {
                                        this.gateIoState = 0;
                                    }
                                }
                            }
                            this.gettingGateIoStateMills = 0L;
                        }
                    } else if (action.getDriver() != null && "wlyk_uniview_ip_regplate_camera_driver".equals(action.getDriver().getName())) {
                        if (action.getEquipment().getAttribute("AlwaysOpen") == null) {
                            try {
                                HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
                                paramMap.put("controlType", 1);
                                OperationFuture of = action.doAction("doPoleAction", paramMap);
                                Integer result = (Integer)of.get(10L, TimeUnit.SECONDS);
                                if (result == null || result != 0) {
                                    throw new Exception();
                                }
                                this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f\u5df2\u5f00\u542f\u6210\u529f\uff01", 2));
                            }
                            catch (Exception ex) {
                                this.alwaysOpening = false;
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f\u5f00\u542f\u5931\u8d25\uff01", 4));
                            }
                        }
                    } else {
                        long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.alwaysOpenMills == 0L || tx - this.alwaysOpenMills > 6000L) {
                            this.alwaysOpenMills = tx;
                            OperationFuture<Integer> t = this.doRaisePoleAction0(true, true);
                            t.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                    ICECameraRoadGateAction.this.alwaysOpenMills = 0L;
                                }

                                public void operationComplete(OperationFuture<Integer> arg0) {
                                    ICECameraRoadGateAction.this.alwaysOpenMills = 0L;
                                }
                            });
                        }
                    }
                }
            } else {
                EquipmentConfig config3;
                Integer delaySecs;
                if (!hasBox && isWorkNormal) {
                    if (action instanceof ZSCameraAction) {
                        if (this.gateIoState != 0) {
                            zsAction = (ZSCameraAction)action;
                            config = zsAction.getEquipment().getEquipmentConfig();
                            Integer io = config.getConfigIntValue("roadGateIO");
                            if (io == null) {
                                io = 0;
                            }
                            long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                            if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                                this.gettingGateIoStateMills = tx;
                                OperationFuture<Integer> of = zsAction.doGetOutIOState(io);
                                of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                    public void waitCompleteTimeout() {
                                        ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                    }

                                    public void operationComplete(OperationFuture<Integer> fu) {
                                        ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                        if (fu.getException() == null && fu.getResult() != null && ((Integer)fu.getResult() == 0 || (Integer)fu.getResult() == 1)) {
                                            ICECameraRoadGateAction.this.gateIoState = (Integer)fu.getResult();
                                            if ((Integer)fu.getResult() == 1) {
                                                ZSCameraAction zsAction = (ZSCameraAction)action;
                                                zsAction.doOpenGateWithDelay(0, 0);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    } else if (action.getDriver() != null && "wovoe_ice_ip_camera_driver".equals(action.getDriver().getName())) {
                        if (this.gateIoState != 0) {
                            long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                            if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                                this.gettingGateIoStateMills = tx;
                                EquipmentConfig config4 = action.getEquipment().getEquipmentConfig();
                                Integer outIoIndex = config4.getConfigIntValue("roadGateIO");
                                if (outIoIndex == null) {
                                    outIoIndex = 0;
                                }
                                if (outIoIndex < 0) {
                                    outIoIndex = 0;
                                } else if (outIoIndex > 3) {
                                    outIoIndex = 3;
                                }
                                String ip = action.getEquipment().getIp();
                                KeyValueEntry<Integer, List<ICECameraUtil.RelayOutputs>> kv = ICECameraUtil.getRelayOutputs(ip);
                                if (kv != null && (Integer)kv.getKey() == 0 && kv.getValue() != null && !((List)kv.getValue()).isEmpty()) {
                                    ICECameraUtil.RelayOutputs outPuts = null;
                                    for (ICECameraUtil.RelayOutputs a : (List)kv.getValue()) {
                                        if (a == null || a.outIoIndex != outIoIndex) continue;
                                        outPuts = a;
                                        break;
                                    }
                                    if (outPuts != null && outPuts.state == 0 && outPuts.delayTimeSec == 1) {
                                        this.gateIoState = 0;
                                    } else {
                                        int result = ICECameraUtil.setRelayOutputs(ip, outIoIndex, 0, 1);
                                        if (result == 0) {
                                            this.gateIoState = 0;
                                        }
                                    }
                                }
                                this.gettingGateIoStateMills = 0L;
                            }
                        }
                    } else if (action instanceof QLMCameraAction) {
                        long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (this.gettingGateIoStateMills == 0L || tx - this.gettingGateIoStateMills > 5000L) {
                            this.gettingGateIoStateMills = tx;
                            final QLMCameraAction qlmAction = (QLMCameraAction)action;
                            qlmAction.getCheduiMode().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void operationComplete(OperationFuture<Integer> future) {
                                    if (!(future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0 && (Integer)future.getResult() != 1)) {
                                        ICECameraRoadGateAction.this.gateIoState = (Integer)future.getResult();
                                        Object object = ICECameraRoadGateAction.this.lock;
                                        synchronized (object) {
                                            if (!ICECameraRoadGateAction.this.alwaysOpening && (Integer)future.getResult() == 1) {
                                                qlmAction.enableCheduiMode(false).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                                    public void operationComplete(OperationFuture<Integer> f1) {
                                                        if (f1.getResult() != null && (Integer)f1.getResult() == 0) {
                                                            ICECameraRoadGateAction.this.gateIoState = 0;
                                                        }
                                                    }

                                                    public void waitCompleteTimeout() {
                                                    }
                                                });
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                if (this.openCouterMills > 0L && (delaySecs = (config3 = this.equipment.getEquipmentConfig()).getConfigIntValue("delay_close_gate_sesc")) != null && delaySecs > 0) {
                    long x = delaySecs.longValue() * 1000L;
                    long tx = ServiceUtil.getServiceContext().currentTimeMillis();
                    if (tx - this.openCouterMills >= x && this.openCouterMills > 0L) {
                        this.doDownPoleAction1();
                        this.openCouterMills = 0L;
                    }
                }
            }
        }
    }

    @Override
    public void setAlwaysOpenBoxValue(boolean alwaysOpen) {
        long nowMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (nowMills - this.setRemoteAlwaysOpenMills > 1000L) {
            this.alwaysOpening = alwaysOpen;
            if (alwaysOpen && !this.isSupportStateDetected()) {
                this.equipmentStateMills = nowMills;
                this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
            }
        }
    }

    public void setAlwaysOpenValue(boolean alwaysOpen) {
        this.alwaysOpening = alwaysOpen;
        if (alwaysOpen && !this.isSupportStateDetected()) {
            this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
        }
    }

    @Override
    public void setAlwaysOpen(final boolean alwaysOpen) {
        LinkedList<CarparkHost> hostList = null;
        if (this.equipment.getChannelNos() != null && !this.equipment.getChannelNos().isEmpty()) {
            for (String channelNo : this.equipment.getChannelNos()) {
                CarparkHost boxHost;
                PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                if (passChannel == null || (boxHost = passChannel.getLanManageHost()) == null) continue;
                if (hostList == null) {
                    hostList = new LinkedList<CarparkHost>();
                    hostList.add(boxHost);
                    continue;
                }
                boolean exist = false;
                for (CarparkHost h : hostList) {
                    if (!h.getHost_no().equals(boxHost.getHost_no())) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                hostList.add(boxHost);
            }
        }
        if (hostList == null || hostList.isEmpty()) {
            this.handleLocalAlwaysOpen(alwaysOpen);
        } else {
            LinkedList<HostSate> connectState = null;
            for (CarparkHost host : hostList) {
                HostSate state = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(host.getHost_no());
                if (state == null) continue;
                if (state.getHostNo() == null || state.getHostNo().length() == 0) {
                    state.setHostNo(host.getHost_no());
                }
                if (connectState == null) {
                    connectState = new LinkedList<HostSate>();
                }
                connectState.add(state);
            }
            if (connectState == null || connectState.isEmpty()) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u672a\u8fde\u63a5", 4));
            } else {
                this.setRemoteAlwaysOpenMills = ServiceUtil.getServiceContext().currentTimeMillis();
                boolean success = false;
                for (final HostSate hostState : connectState) {
                    try {
                        RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)hostState.getLanSocketAddress());
                        RequestSender requestSender = connection.createRequest();
                        requestSender.setRequestActionName("/LanPassEquipmentHandleAction");
                        requestSender.setHeader("op", "alwaysOpen");
                        requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
                        requestSender.setHeader("destHostNo", hostState.getHostNo());
                        requestSender.setHeader("eqNo", this.equipment.getEquipmentNo());
                        requestSender.setHeader("alwaysOpen", alwaysOpen ? Constants.YES_STR : Constants.NO_STR);
                        requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
                        requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
                        requestSender.doRequest(new SendCallback(){

                            public void onException(Throwable ex) {
                                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u4e91\u7f51\u5173\u9053\u95f8\u5e38\u5f00" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01" + hostState.getLanSocketAddress() + ", \u53d1\u9001\u5f02\u5e38\uff1a" + ex));
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u65e0\u6cd5\u8fde\u63a5", 4));
                            }

                            public void onCompleted() {
                            }
                        }, new ReceiveCallback(){

                            public void onWaitTimeout() throws Exception {
                                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u4e91\u7f51\u5173\u9053\u95f8\u5e38\u5f00" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01" + hostState.getLanSocketAddress() + ", \u4e91\u7f51\u5173\u54cd\u5e94\u8d85\u65f6"));
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u54cd\u5e94\u8d85\u65f6", 4));
                            }

                            public long getWaitTimeoutMills() {
                                return 5000L;
                            }

                            public void doReceiver(Receiver receiver, int id) throws Exception {
                                String respCode = receiver.getHeaderValue("respCode");
                                if (!"SUCCESS".equals(respCode)) {
                                    if ("RESP_CODE_METHOD_NOTFOUND".endsWith(respCode)) {
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u7248\u672c\u8fc7\u4f4e\uff01\u9700\u8981\u5347\u7ea7\u624d\u652f\u6301\u6b64\u529f\u80fd", 4));
                                    } else {
                                        ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u4e91\u7f51\u5173\u9053\u95f8\u5e38\u5f00" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01" + hostState.getLanSocketAddress() + ", " + receiver.getHeaderValue("respMsg")));
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(ICECameraRoadGateAction.this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u8fd4\u56de\u9519\u8bef: " + receiver.getHeaderValue("respMsg"), 4));
                                    }
                                } else {
                                    ICECameraRoadGateAction.this.alwaysOpening = alwaysOpen;
                                    if (alwaysOpen && !ICECameraRoadGateAction.this.isSupportStateDetected()) {
                                        ICECameraRoadGateAction.this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                        ICECameraRoadGateAction.this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                                    }
                                }
                            }
                        });
                        success = true;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u4e91\u7f51\u5173\u9053\u95f8\u5e38\u5f00" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01" + hostState.getLanSocketAddress() + ", " + ex.getMessage()));
                    }
                }
                if (!success) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f" + (alwaysOpen ? "\u5f00\u542f" : "\u5173\u95ed") + "\u5931\u8d25\uff01\u539f\u56e0: \u4e91\u7f51\u5173\u672a\u8fde\u63a5", 4));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLocalAlwaysOpen(boolean alwaysOpen) {
        Object object = this.lock;
        synchronized (object) {
            RoadBarrierAction action;
            boolean old = this.alwaysOpening;
            this.alwaysOpening = alwaysOpen;
            if (old) {
                RoadBarrierAction action2;
                if (!alwaysOpen && (action2 = this.getRealRoadBarrierAction()) != null && action2.isWorkingProperly()) {
                    String ax = this.equipment.getEquipmentConfig().getConfigValue("cancel_alwaysopen_close_pole");
                    final boolean autoDownPole = ax == null || !"1".equals(ax);
                    boolean downPole = autoDownPole;
                    if (action2 instanceof ZSCameraAction) {
                        if (this.gateIoState == 1) {
                            this.gettingGateIoStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            downPole = false;
                            ZSCameraAction zsAction = (ZSCameraAction)action2;
                            zsAction.doOpenGateWithDelay(0, 0).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                    ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                }

                                public void operationComplete(OperationFuture<Integer> f) {
                                    if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0 && autoDownPole) {
                                        ICECameraRoadGateAction.this.doDownPoleAction1();
                                    }
                                    ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                }
                            });
                        }
                    } else if (action2 instanceof QLMCameraAction) {
                        this.gettingGateIoStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        downPole = false;
                        final QLMCameraAction qlmAction = (QLMCameraAction)action2;
                        qlmAction.getCheduiMode().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(OperationFuture<Integer> future) {
                                if (!(future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0 && (Integer)future.getResult() != 1)) {
                                    ICECameraRoadGateAction.this.gateIoState = (Integer)future.getResult();
                                    Object object = ICECameraRoadGateAction.this.lock;
                                    synchronized (object) {
                                        if (!ICECameraRoadGateAction.this.alwaysOpening) {
                                            if ((Integer)future.getResult() == 1) {
                                                qlmAction.enableCheduiMode(false).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                                    public void operationComplete(OperationFuture<Integer> f1) {
                                                        if (f1.getResult() != null && (Integer)f1.getResult() == 0) {
                                                            ICECameraRoadGateAction.this.gateIoState = 0;
                                                            if (autoDownPole) {
                                                                ICECameraRoadGateAction.this.doDownPoleAction1();
                                                            }
                                                        }
                                                    }

                                                    public void waitCompleteTimeout() {
                                                    }
                                                });
                                            } else if (autoDownPole) {
                                                ICECameraRoadGateAction.this.doDownPoleAction1();
                                            }
                                        }
                                    }
                                }
                            }
                        });
                    } else if (action2.getDriver() != null && "wovoe_ice_ip_camera_driver".equals(action2.getDriver().getName())) {
                        if (this.gateIoState == 1) {
                            this.gettingGateIoStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            downPole = false;
                            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                                @Override
                                public void run() {
                                    RoadBarrierAction action = ICECameraRoadGateAction.this.getRealRoadBarrierAction();
                                    EquipmentConfig config = action.getEquipment().getEquipmentConfig();
                                    Integer outIoIndex = config.getConfigIntValue("roadGateIO");
                                    if (outIoIndex == null) {
                                        outIoIndex = 0;
                                    }
                                    if (outIoIndex < 0) {
                                        outIoIndex = 0;
                                    } else if (outIoIndex > 3) {
                                        outIoIndex = 3;
                                    }
                                    String ip = action.getEquipment().getIp();
                                    int result = ICECameraUtil.setRelayOutputs(ip, outIoIndex, 0, 1);
                                    if (result == 0 && autoDownPole) {
                                        ICECameraRoadGateAction.this.doDownPoleAction1();
                                    }
                                    ICECameraRoadGateAction.this.gettingGateIoStateMills = 0L;
                                }
                            });
                        }
                    } else if (action2.getDriver() != null && "wlyk_uniview_ip_regplate_camera_driver".equals(action2.getDriver().getName()) && action2.getEquipment().getAttribute("AlwaysOpen") != null) {
                        try {
                            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
                            paramMap.put("controlType", 2);
                            OperationFuture of = action2.doAction("doPoleAction", paramMap);
                            Integer result = (Integer)of.get(10L, TimeUnit.SECONDS);
                            if (result == null || result != 0) {
                                throw new Exception();
                            }
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f\u5df2\u6210\u529f\u5173\u95ed\uff01", 2));
                        }
                        catch (Exception ex) {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(this.equipment.getName()) + "\uff1a\u8f66\u961f\u6a21\u5f0f\u5173\u95ed\u5931\u8d25\uff01", 4));
                        }
                    }
                    if (downPole) {
                        this.doDownPoleAction1();
                    }
                }
            } else if (alwaysOpen && (action = this.getRealRoadBarrierAction()) != null && action.isWorkingProperly() && action instanceof QLMCameraAction) {
                this.gettingGateIoStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                final QLMCameraAction qlmAction = (QLMCameraAction)action;
                qlmAction.getCheduiMode().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(OperationFuture<Integer> future) {
                        if (!(future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0 && (Integer)future.getResult() != 1)) {
                            ICECameraRoadGateAction.this.gateIoState = (Integer)future.getResult();
                            Object object = ICECameraRoadGateAction.this.lock;
                            synchronized (object) {
                                if (ICECameraRoadGateAction.this.alwaysOpening && (Integer)future.getResult() == 0) {
                                    qlmAction.enableCheduiMode(true).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                        public void operationComplete(OperationFuture<Integer> f1) {
                                            if (f1.getResult() != null && (Integer)f1.getResult() == 0) {
                                                ICECameraRoadGateAction.this.gateIoState = 1;
                                            }
                                        }

                                        public void waitCompleteTimeout() {
                                        }
                                    });
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public boolean isAlwaysOpen() {
        return this.alwaysOpening;
    }

    @Override
    public void setPoleSate(EquipmentState state, Integer handleType, String channelNo) {
        Object action;
        long currentMills;
        if (state == null) {
            return;
        }
        EquipmentState oldState = this.equipmentState;
        long oldStateMills = this.equipmentStateMills;
        this.equipmentState = state;
        this.equipmentStateMills = currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (state == EquipmentState.BARRIER_RAISED_IN_PLACE && oldState != null && oldState == EquipmentState.BARRIER_DROPPED_IN_PLACE && currentMills - oldStateMills < 6000L && currentMills - this.menuOpenPoleMills > 15000L && (action = this.getParentEquipmentAction()) != null && handleType != null && handleType != 2 && this.equipment.getChannelNos() != null && !this.equipment.getChannelNos().isEmpty()) {
            EnumSet<RoadBarrierStateEvent.SignalType> signals = EnumSet.noneOf(RoadBarrierStateEvent.SignalType.class);
            signals.add(RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN);
            RoadBarrierStateEvent event = new RoadBarrierStateEvent(this.equipment, oldState, state, signals, channelNo);
            event.setControlBoxOpenHandleType(handleType);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
        }
    }
}

