/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.http.DefaultHttpResponse;
import com.wovoe.framework.http.HttpProxy;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpResponseDataCallback;
import com.wovoe.framework.http.HttpResponseLineStringCallback;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.http.SimpleX509TrustManager;
import com.wovoe.framework.http.UrlResolution;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ICECameraUtil {
    public static String strOnvifXmlns = "xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"\r\nxmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\"\r\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\nxmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\r\nxmlns:wsa5=\"http://www.w3.org/2005/08/addressing\"\r\nxmlns:tt=\"http://www.onvif.org/ver10/schema\"\r\n";
    public static String strOnvifDeviceXmlns = String.valueOf(strOnvifXmlns) + "xmlns:tds=\"http://www.onvif.org/ver10/device/wsdl\">\r\n";
    public static String strOnvifHdr = "POST / HTTP/1.1\r\nContent-Type: application/soap+xml;charset=utf-8;\r\nHost: %s:8080\r\nContent-Length: %d\r\n\r\n%s";
    public static String strOnvifReboot = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope\r\n" + strOnvifDeviceXmlns + "<SOAP-ENV:Header>\r\n" + "</SOAP-ENV:Header>\r\n" + "<SOAP-ENV:Body>\r\n" + "<tds:SystemReboot>\r\n" + "</tds:SystemReboot>\r\n" + "</SOAP-ENV:Body>\r\n" + "</SOAP-ENV:Envelope>";
    public static String GetRelayOutputs = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope\r\n" + strOnvifDeviceXmlns + "<SOAP-ENV:Header>\r\n" + "</SOAP-ENV:Header>\r\n" + "<SOAP-ENV:Body>\r\n" + "<tds:GetRelayOutputs>\r\n" + "</tds:GetRelayOutputs>\r\n" + "</SOAP-ENV:Body>\r\n" + "</SOAP-ENV:Envelope>";
    public static String[] strFilelist = new String[]{"0.g711a", "1.g711a", "2.g711a", "3.g711a", "4.g711a", "5.g711a", "6.g711a", "7.g711a", "8.g711a", "9.g711a", "10.g711a", "100.g711a", "1000.g711a", "year.g711a", "month.g711a", "date.g711a", "hour.g711a", "minute.g711a", "second.g711a", "yuan.g711a", "welcome.g711a", "welinr.g711a", "thsout.g711a", "readcdf.g711a", "cardbf.g711a", "cardaf.g711a", "cardend.g711a", "cardear.g711a", "readagain.g711a", "cardnuse.g711a", "cardloss.g711a", "cardedat.g711a", "entered.g711a", "exited.g711a", "park.g711a", "consume.g711a", "callin.g711a", "callout.g711a", "callbusy.g711a", "noanswer.g711a", "Errtime.g711a", "exitsub.g711a", "entersub.g711a", "exitmain.g711a", "netfail.g711a", "thsin.g711a", "thsouted.g711a", "lessmey.g711a", "nordcard.g711a", "notwork.g711a", "insertcard.g711a", "chargeagain.g711a", "takein.g711a", "takeout.g711a", "lestmey.g711a", "charge.g711a", "readOK.g711a", "Motorcycle.g711a", "SmallCar.g711a", "MiddleCar.g711a", "BigCar.g711a", "SpuCar.g711a", "PreDefCar.g711a", "NoAuthEnter.g711a", "WatchCard.g711a", "OperateCard.g711a", "ChsCarType.g711a", "tian.g711a", "takecard.g711a", "69.g711a", "70.g711a", "71.g711a", "72.g711a", "73.g711a", "74.g711a", "75.g711a"};
    public static int ICE_OSD_LOCATION_LEFT_TOP = 0;
    public static int ICE_OSD_LOCATION_RIGHT_TOP = 1;
    public static int ICE_OSD_LOCATION_LEFT_BOTTOM = 2;
    public static int ICE_OSD_LOCATION_RIGHT_BOTTOM = 3;
    public static int ICE_OSD_LOCATION_TOP_MID = 4;
    public static int ICE_OSD_LOCAtiON_BOTTOM_MID;

    public static void intToByteArray(int value, byte[] bytes, int offset, int count) {
        int i = 0;
        while (i < count) {
            bytes[offset + i] = (byte)(value >> 8 * i & 0xFF);
            ++i;
        }
    }

    public static int byteArrayToInt(byte[] bytes, int offset, int count) {
        int value = 0;
        int i = 0;
        while (i < count) {
            value += (bytes[offset + i] & 0xFF) << 8 * i;
            ++i;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] capture(String strIP) {
        try (Socket socket = new Socket();){
            InetSocketAddress endpoint = new InetSocketAddress(strIP, 8117);
            socket.connect(endpoint, 3000);
            socket.setSoTimeout(3000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[32];
            ICECameraUtil.intToByteArray(32, header, 0, 4);
            ICECameraUtil.intToByteArray(4147, header, 4, 4);
            writer.write(header);
            writer.flush();
            writer = null;
            int len = reader.read(header, 0, 32);
            if (32 != len) {
                reader = null;
                header = null;
                socket.close();
                socket = null;
                return null;
            }
            len = ICECameraUtil.byteArrayToInt(header, 0, 4) - 32;
            int type = ICECameraUtil.byteArrayToInt(header, 4, 4);
            header = null;
            if (4148 != type) {
                reader = null;
                socket.close();
                socket = null;
                return null;
            }
            byte[] picdata = new byte[len];
            int total = 0;
            while (true) {
                if (total >= len) {
                    reader = null;
                    byte[] byArray = picdata;
                    return byArray;
                }
                try {
                    total += reader.read(picdata, total, len - total);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean writeDataToCamera(String strIP, String strData) {
        try (Socket socket = new Socket(strIP, 8117);){
            if (strData == null) {
                strData = "";
            }
            socket.setSoTimeout(1000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[32];
            ICECameraUtil.intToByteArray(32 + strData.length(), header, 0, 4);
            ICECameraUtil.intToByteArray(20633, header, 4, 4);
            writer.write(header);
            writer.write(strData.getBytes());
            writer.flush();
            writer = null;
            reader.read(header, 0, 32);
            reader = null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readDataFromCamera(String strIP) throws Exception {
        Socket socket = new Socket(strIP, 8117);
        try {
            socket.setSoTimeout(5000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[32];
            ICECameraUtil.intToByteArray(32, header, 0, 4);
            ICECameraUtil.intToByteArray(20737, header, 4, 4);
            writer.write(header);
            writer.flush();
            writer = null;
            int len = reader.read(header, 0, 32);
            if (32 != len) {
                reader = null;
                header = null;
                socket.close();
                socket = null;
                return null;
            }
            int size = ICECameraUtil.byteArrayToInt(header, 0, 4);
            int type = ICECameraUtil.byteArrayToInt(header, 4, 4);
            header = null;
            if (20738 != type) {
                reader = null;
                socket.close();
                socket = null;
                return null;
            }
            byte[] param = new byte[size - 32];
            reader.read(param, 0, size - 32);
            reader = null;
            return new String(param);
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCameraDevID(String strIP) throws Exception {
        Socket socket = new Socket(strIP, 8117);
        try {
            socket.setSoTimeout(5000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[32];
            ICECameraUtil.intToByteArray(32, header, 0, 4);
            ICECameraUtil.intToByteArray(20627, header, 4, 4);
            writer.write(header);
            writer.flush();
            writer = null;
            int len = reader.read(header, 0, 32);
            if (32 != len) {
                reader = null;
                header = null;
                socket.close();
                socket = null;
                return null;
            }
            int size = ICECameraUtil.byteArrayToInt(header, 0, 4);
            int type = ICECameraUtil.byteArrayToInt(header, 4, 4);
            header = null;
            if (20628 != type) {
                reader = null;
                socket.close();
                socket = null;
                return null;
            }
            byte[] param = new byte[size - 32];
            reader.read(param, 0, size - 32);
            reader = null;
            return new String(param);
        }
        finally {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
    }

    public static boolean reboot(String strIP) {
        try (Socket socket = new Socket(strIP, 8080);){
            socket.setSoTimeout(1000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            Formatter fmt = new Formatter();
            fmt.format(strOnvifHdr, strIP, strOnvifReboot.length(), strOnvifReboot);
            writer.write(fmt.toString().getBytes());
            writer.flush();
            writer = null;
            fmt.close();
            fmt = null;
            byte[] buf = new byte[2048];
            reader.read(buf, 0, 2048);
            Object var3_4 = null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean openGate(String strIP) {
        try (Socket socket = new Socket(strIP, 8117);){
            socket.setSoTimeout(2000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[32];
            ICECameraUtil.intToByteArray(32, header, 0, 4);
            ICECameraUtil.intToByteArray(20581, header, 4, 4);
            writer.write(header);
            writer.flush();
            writer = null;
            reader.read(header, 0, 32);
            reader.close();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setOsdCfg(String strIP, int nPosVideo, int nColorVideo, boolean bDateTimeVideo, boolean bLicense, boolean bCustomVideo, String strCustomVideo, int nPosJpeg, int nColorJpeg, boolean bDateTimeJpeg, boolean bAlgo, boolean bCustomJpeg, String strCustomJpeg) {
        try (Socket socket = new Socket(strIP, 8117);){
            socket.setSoTimeout(1000);
            DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
            DataInputStream reader = new DataInputStream(socket.getInputStream());
            byte[] header = new byte[1248];
            ICECameraUtil.intToByteArray(1248, header, 0, 4);
            ICECameraUtil.intToByteArray(20563, header, 4, 4);
            ICECameraUtil.intToByteArray(nPosVideo, header, 32, 4);
            ICECameraUtil.intToByteArray(nColorVideo, header, 36, 4);
            ICECameraUtil.intToByteArray(bDateTimeVideo ? 1 : 0, header, 40, 4);
            ICECameraUtil.intToByteArray(bLicense ? 1 : 0, header, 44, 4);
            ICECameraUtil.intToByteArray(bCustomVideo ? 1 : 0, header, 48, 4);
            int len = strCustomVideo.getBytes().length;
            if (len > 383) {
                len = 383;
            }
            System.arraycopy(strCustomVideo.getBytes(), 0, header, 480, len);
            header[480 + len] = 0;
            ICECameraUtil.intToByteArray(nPosJpeg, header, 116, 4);
            ICECameraUtil.intToByteArray(nColorJpeg, header, 120, 4);
            ICECameraUtil.intToByteArray(bDateTimeJpeg ? 1 : 0, header, 124, 4);
            ICECameraUtil.intToByteArray(bAlgo ? 1 : 0, header, 128, 4);
            ICECameraUtil.intToByteArray(bCustomJpeg ? 1 : 0, header, 412, 4);
            len = strCustomJpeg.getBytes().length;
            if (len > 383) {
                len = 383;
            }
            System.arraycopy(strCustomJpeg.getBytes(), 0, header, 864, len);
            header[864 + len] = 0;
            writer.write(header);
            writer.flush();
            writer = null;
            reader.read(header, 0, 32);
            reader = null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <R> R doPost(String requestUrl, Map<String, ?> headMap, String contentType, String postData, HttpResponseCallback<R> callback, int connectTimout, int readTimeout, Proxy proxy) throws Exception {
        Object result;
        block37: {
            HttpURLConnection httpUrlConn = null;
            result = null;
            try {
                try {
                    UrlResolution resol = HttpUtil.getUrlResolution();
                    if (resol != null) {
                        requestUrl = resol.resolution(requestUrl, 0, proxy);
                    }
                    if (requestUrl.startsWith("https://")) {
                        TrustManager[] trustManagerArray = new TrustManager[]{new SimpleX509TrustManager()};
                        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                        sslContext.init(null, trustManagerArray, new SecureRandom());
                        SSLSocketFactory ssf = sslContext.getSocketFactory();
                        URL url = new URL(requestUrl);
                        if (proxy == null) {
                            proxy = HttpProxy.getProxy((String)requestUrl);
                        }
                        HttpsURLConnection httpUrlConn1 = proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy);
                        httpUrlConn1.setSSLSocketFactory(ssf);
                        httpUrlConn = httpUrlConn1;
                    } else {
                        URL uRL = new URL(requestUrl);
                        if (proxy == null) {
                            proxy = HttpProxy.getProxy((String)requestUrl);
                        }
                        httpUrlConn = proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(proxy);
                    }
                    if (headMap != null && !headMap.isEmpty()) {
                        for (Map.Entry entry : headMap.entrySet()) {
                            Object a1;
                            Object a;
                            Object ao = entry.getValue();
                            if (ao == null) continue;
                            if (ao instanceof String[]) {
                                a = (String[])ao;
                                String[] stringArray = a;
                                int n = ((String[])a).length;
                                int n2 = 0;
                                while (n2 < n) {
                                    a1 = stringArray[n2];
                                    httpUrlConn.addRequestProperty((String)entry.getKey(), (String)a1);
                                    ++n2;
                                }
                                continue;
                            }
                            if (ao instanceof Collection) {
                                a = (Collection)ao;
                                Iterator iterator = a.iterator();
                                while (iterator.hasNext()) {
                                    a1 = iterator.next();
                                    httpUrlConn.addRequestProperty((String)entry.getKey(), a1.toString());
                                }
                                continue;
                            }
                            httpUrlConn.setRequestProperty((String)entry.getKey(), ao.toString());
                        }
                    }
                    if (connectTimout > 0) {
                        httpUrlConn.setConnectTimeout(connectTimout);
                    }
                    if (readTimeout > 0) {
                        httpUrlConn.setReadTimeout(readTimeout);
                    }
                    httpUrlConn.setUseCaches(false);
                    String string = "UTF-8";
                    if (postData != null && postData.length() > 0) {
                        httpUrlConn.setRequestProperty("Content-Type", contentType);
                        httpUrlConn.setRequestMethod("POST");
                        httpUrlConn.setDoOutput(true);
                        OutputStream out = httpUrlConn.getOutputStream();
                        out.write(postData.getBytes(string));
                        out.close();
                    }
                    httpUrlConn.connect();
                    boolean obtainContext = true;
                    if (callback != null) {
                        obtainContext = callback.onHeaders((HttpResponse)new DefaultHttpResponse(httpUrlConn.getHeaderFields(), httpUrlConn.getResponseCode(), httpUrlConn.getResponseMessage(), httpUrlConn.getContentLengthLong(), httpUrlConn.getContentEncoding(), httpUrlConn.getContentType()));
                    }
                    if (!obtainContext) break block37;
                    InputStream inputStream = null;
                    try {
                        inputStream = httpUrlConn.getInputStream();
                        if (callback instanceof HttpResponseDataCallback) {
                            int len;
                            HttpResponseDataCallback ak = (HttpResponseDataCallback)callback;
                            byte[] data = new byte[1024];
                            while ((len = inputStream.read(data)) != -1) {
                                if (len <= 0 || ak.callback(data, 0, len)) continue;
                                break block37;
                            }
                            break block37;
                        }
                        if (callback instanceof HttpResponseLineStringCallback) {
                            HttpResponseLineStringCallback a1 = (HttpResponseLineStringCallback)callback;
                            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            String str = null;
                            while ((str = bufferedReader.readLine()) != null) {
                                if (a1.callback(str)) continue;
                                break block37;
                            }
                            break block37;
                        }
                        while (inputStream.read() != -1) {
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                            inputStream = null;
                        }
                    }
                }
                catch (Throwable ex) {
                    if (callback != null) {
                        callback.onException(ex);
                    }
                    if (ex instanceof Exception) {
                        throw (Exception)ex;
                    }
                    throw new Exception(ex.getMessage(), ex);
                }
            }
            finally {
                if (httpUrlConn != null) {
                    try {
                        httpUrlConn.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (callback != null) {
            result = callback.onComplete();
        }
        return (R)result;
    }

    public static KeyValueEntry<Integer, List<RelayOutputs>> getRelayOutputs(String strIP) {
        if (strIP == null || strIP.length() == 0) {
            return new KeyValueEntry((Object)-1, null);
        }
        String requestUrl = "http://" + strIP + ":8080";
        String contentType = "application/soap+xml;charset=utf-8";
        try {
            KeyValueEntry result = (KeyValueEntry)ICECameraUtil.doPost(requestUrl, null, contentType, GetRelayOutputs, new HttpResponseLineStringCallback<KeyValueEntry<Integer, String>>(){
                KeyValueEntry<Integer, String> kv = new KeyValueEntry();
                StringBuilder sbr = new StringBuilder();

                public KeyValueEntry<Integer, String> onComplete() {
                    this.kv.setValue((Object)this.sbr.toString());
                    return this.kv;
                }

                public void onException(Throwable ex) {
                }

                public boolean callback(String line) {
                    if (line != null && (line = line.trim()).length() > 0) {
                        this.sbr.append(line.trim());
                    }
                    return true;
                }

                public boolean onHeaders(HttpResponse response) {
                    this.kv.setKey((Object)response.getResponseCode());
                    return response.getResponseCode() == 200;
                }
            }, 5000, 6000, null);
            if (result == null || result.getKey() == null) {
                return new KeyValueEntry((Object)-2, null);
            }
            if ((Integer)result.getKey() != 200) {
                LogUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u8fd4\u56deHTTP\u9519\u8bef\uff1a" + result.getKey()));
                return new KeyValueEntry((Object)((Integer)result.getKey()), null);
            }
            if (result.getValue() == null || ((String)result.getValue()).length() == 0) {
                LogUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u8fd4\u56de\u7a7a\u6570\u636e"));
                return new KeyValueEntry((Object)-3, null);
            }
            try {
                String c = "</SOAP-ENV:Body>";
                int a = ((String)result.getValue()).indexOf("<SOAP-ENV:Body>");
                int b = ((String)result.getValue()).indexOf(c);
                if (a == -1 || b == -1 || a >= b) {
                    LogUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u8fd4\u56de\u9519\u8bef\u6570\u636e\uff1a" + (String)result.getValue()));
                    return new KeyValueEntry((Object)-3, null);
                }
                String z = ((String)result.getValue()).substring(a, b + c.length());
                ArrayList<RelayOutputs> returnList = new ArrayList<RelayOutputs>(4);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + z)));
                NodeList commonParamNodeList = document.getFirstChild().getChildNodes();
                String s1 = "tds:GetRelayOutputsResponse";
                String s11 = "tds:RelayOutputs";
                String s12 = "tt:Properties";
                String s13 = "tt:DelayTime";
                String s14 = "tt:IdleState";
                String attrNameToken = "token";
                String attrVRelayOutput = "RelayOutput";
                String openStr = "open";
                String closedStr = "closed";
                String _PT = "PT";
                String _S = "S";
                if (commonParamNodeList != null) {
                    int slzise = commonParamNodeList.getLength();
                    int kj = 0;
                    while (kj < slzise) {
                        NodeList nodeList1;
                        Node commonParamNode = commonParamNodeList.item(kj);
                        if ("tds:GetRelayOutputsResponse".equals(commonParamNode.getNodeName()) && (nodeList1 = commonParamNode.getChildNodes()) != null) {
                            int len = nodeList1.getLength();
                            int k1 = 0;
                            while (k1 < len) {
                                String ioIndexName = null;
                                Node nNode = nodeList1.item(k1);
                                if ("tds:RelayOutputs".equals(nNode.getNodeName())) {
                                    NamedNodeMap nodeMap = nNode.getAttributes();
                                    int i = 0;
                                    while (i < nodeMap.getLength()) {
                                        Node attribute = nodeMap.item(i);
                                        String attrName = attribute.getNodeName();
                                        if ("token".equals(attrName)) {
                                            ioIndexName = attribute.getNodeValue();
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                if (ioIndexName != null && ioIndexName.startsWith("RelayOutput")) {
                                    RelayOutputs relayOutputsEntity = new RelayOutputs();
                                    relayOutputsEntity.outIoIndex = ioIndexName.equals("RelayOutput") ? 0 : Integer.parseInt(ioIndexName.substring("RelayOutput".length())) - 1;
                                    NodeList propertiesList = nNode.getChildNodes();
                                    if (propertiesList != null) {
                                        int pLen = propertiesList.getLength();
                                        int k2 = 0;
                                        while (k2 < pLen) {
                                            NodeList proNodeList;
                                            Node propertiesNode = propertiesList.item(k2);
                                            if ("tt:Properties".equals(propertiesNode.getNodeName()) && (proNodeList = propertiesNode.getChildNodes()) != null) {
                                                int tLen = proNodeList.getLength();
                                                int k3 = 0;
                                                while (k3 < tLen) {
                                                    String tValue;
                                                    Node tNode = proNodeList.item(k3);
                                                    if ("tt:DelayTime".equals(tNode.getNodeName())) {
                                                        tValue = tNode.getTextContent();
                                                        if (tValue != null && (tValue = tValue.trim()).length() > 0 && tValue.startsWith(_PT) && tValue.endsWith(_S)) {
                                                            relayOutputsEntity.delayTimeSec = Integer.parseInt(tValue.substring(_PT.length(), tValue.length() - 1));
                                                        }
                                                    } else if ("tt:IdleState".equals(tNode.getNodeName()) && (tValue = tNode.getTextContent()) != null && (tValue = tValue.trim()).length() > 0) {
                                                        if ("open".equals(tValue)) {
                                                            relayOutputsEntity.state = 0;
                                                        } else if ("closed".equals(tValue)) {
                                                            relayOutputsEntity.state = 1;
                                                        }
                                                    }
                                                    ++k3;
                                                }
                                            }
                                            ++k2;
                                        }
                                    }
                                    if (relayOutputsEntity.outIoIndex != -1 && relayOutputsEntity.state != -1) {
                                        returnList.add(relayOutputsEntity);
                                    } else {
                                        LogUtil.getLog().warn((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u5b58\u5728\u8fd4\u56de\u4e0d\u6b63\u786e\u7684\u6570\u636e\uff1a" + (String)result.getValue()));
                                    }
                                }
                                ++k1;
                            }
                        }
                        ++kj;
                    }
                }
                return new KeyValueEntry((Object)0, returnList);
            }
            catch (Exception ex) {
                LogUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u8fd4\u56de\u9519\u8bef\u6570\u636e\uff1a" + (String)result.getValue()));
                return new KeyValueEntry((Object)-3, null);
            }
        }
        catch (Throwable e) {
            LogUtil.getLog().error((Object)("\u67e5\u8be2\u76f8\u673a: " + strIP + "\u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u7f51\u7edc\u5f02\u5e38\uff01" + e));
            return new KeyValueEntry((Object)-2, null);
        }
    }

    public static int setRelayOutputs(String strIP, int outIoIndex, int state, int delayTimeSec) {
        KeyValueEntry result;
        block16: {
            block15: {
                String RelayOutput;
                if (strIP == null || strIP.length() == 0) {
                    return -1;
                }
                if (state != 0 && state != 1) {
                    return -1;
                }
                if (delayTimeSec != -1 && (delayTimeSec < 1 || delayTimeSec > 10)) {
                    return -1;
                }
                if (outIoIndex == 0) {
                    RelayOutput = "RelayOutput";
                } else if (outIoIndex == 1) {
                    RelayOutput = "RelayOutput2";
                } else if (outIoIndex == 2) {
                    RelayOutput = "RelayOutput3";
                } else if (outIoIndex == 3) {
                    RelayOutput = "RelayOutput4";
                } else {
                    return -1;
                }
                String PT = "PT" + delayTimeSec + "S";
                String stateStr = state == 0 ? "open" : "closed";
                String xml = "<tds:SetRelayOutputSettings><tds:RelayOutputToken>" + RelayOutput + "</tds:RelayOutputToken><tds:Properties><Mode>Monostable</Mode><DelayTime>" + PT + "</DelayTime><IdleState>" + stateStr + "</IdleState></tds:Properties></tds:SetRelayOutputSettings>";
                String sendData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<SOAP-ENV:Envelope\r\n" + strOnvifDeviceXmlns + "<SOAP-ENV:Header>\r\n" + "</SOAP-ENV:Header>\r\n" + "<SOAP-ENV:Body>\r\n" + xml + "\r\n" + "</SOAP-ENV:Body>\r\n</SOAP-ENV:Envelope>";
                try {
                    String requestUrl = "http://" + strIP + ":8080";
                    String contentType = "application/soap+xml;charset=utf-8";
                    result = (KeyValueEntry)ICECameraUtil.doPost(requestUrl, null, contentType, sendData, new HttpResponseLineStringCallback<KeyValueEntry<Integer, String>>(){
                        KeyValueEntry<Integer, String> kv = new KeyValueEntry();
                        StringBuilder sbr = new StringBuilder();

                        public KeyValueEntry<Integer, String> onComplete() {
                            this.kv.setValue((Object)this.sbr.toString());
                            return this.kv;
                        }

                        public void onException(Throwable ex) {
                        }

                        public boolean callback(String line) {
                            if (line != null && (line = line.trim()).length() > 0) {
                                this.sbr.append(line.trim());
                            }
                            return true;
                        }

                        public boolean onHeaders(HttpResponse response) {
                            this.kv.setKey((Object)response.getResponseCode());
                            return response.getResponseCode() == 200;
                        }
                    }, 5000, 6000, null);
                    if (result != null && result.getKey() != null) break block15;
                    return -2;
                }
                catch (Throwable e) {
                    LogUtil.getLog().error((Object)("\u8bbe\u7f6e\u76f8\u673a: " + strIP + ", \u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u7f51\u7edc\u5f02\u5e38\uff01" + e));
                    return -2;
                }
            }
            if ((Integer)result.getKey() != 200) break block16;
            return 0;
        }
        LogUtil.getLog().error((Object)("\u8bbe\u7f6e\u76f8\u673a: " + strIP + ", \u5e38\u5f00\u6216\u53d6\u6d88\u5e38\u5f00\u8fd4\u56deHTTP\u9519\u8bef\uff1a" + result.getKey()));
        return (Integer)result.getKey();
    }

    public static class RelayOutputs {
        public int outIoIndex = -1;
        public int state = -1;
        public int delayTimeSec = -2;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RelayOutputs [outIoIndex=");
            builder.append(this.outIoIndex);
            builder.append(", state=");
            builder.append(this.state);
            builder.append(", delayTimeSec=");
            builder.append(this.delayTimeSec);
            builder.append("]");
            return builder.toString();
        }
    }
}

