/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentAction;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.IoControlGateAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.driver.DnctChannelBoardActtion;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;

public class IOBordGateAction
extends AbstractEquipmentAction
implements RoadBarrierAction,
AlwaysOpenAction {
    private volatile EquipmentState equipmentState;
    private volatile long equipmentStateMills;
    private volatile long menuOpenPoleMills;
    private volatile long setRemoteAlwaysOpenMills;
    private volatile boolean alwaysOpening;

    public IOBordGateAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    protected EquipmentAction getRealRoadBarrierAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action != this && (action instanceof RoadBarrierAction || action instanceof IoControlGateAction)) {
            return action;
        }
        return null;
    }

    @Override
    public boolean isWorkingProperly() {
        EquipmentAction action = this.getRealRoadBarrierAction();
        if (action != null) {
            return action.isWorkingProperly();
        }
        return false;
    }

    public long getMenuOpenPoleMills() {
        return this.menuOpenPoleMills;
    }

    @Override
    public EquipmentState getEquipmentState() {
        if (!this.isWorkingProperly()) {
            return EquipmentState.DISCONNECTED;
        }
        EquipmentAction ac = this.getRealRoadBarrierAction();
        if (ac != null && ac.getEquipment() != null && ac.getEquipment().getAttribute("AlwaysOpen") != null) {
            return EquipmentState.BARRIER_RAISED_IN_PLACE;
        }
        if (this.alwaysOpening) {
            return EquipmentState.BARRIER_RAISED_IN_PLACE;
        }
        if (this.isSupportStateDetected()) {
            return this.equipmentState;
        }
        if (this.equipmentState != null && ServiceUtil.getServiceContext().currentTimeMillis() - this.equipmentStateMills < 8000L) {
            return this.equipmentState;
        }
        return this.isWorkingProperly() ? EquipmentState.BARRIER_DROPPED_IN_PLACE : EquipmentState.DISCONNECTED;
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        if (this.isAlwaysOpen() && this.getRealRoadBarrierAction() instanceof DnctChannelBoardActtion) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setResult((Object)0);
            return f;
        }
        EquipmentAction action = this.getRealRoadBarrierAction();
        if (action != null) {
            int ioIndex;
            OperationFuture<Integer> op = null;
            if (action instanceof RoadBarrierAction) {
                op = ((RoadBarrierAction)action).doRaisePoleAction();
            } else if (action instanceof IoControlGateAction && (ioIndex = this.getOpenGateIoIndex()) > 0) {
                op = ((IoControlGateAction)action).doOutputIo(ioIndex, 1000L);
            }
            if (op != null) {
                op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                            IOBordGateAction.this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
                            IOBordGateAction.this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                });
                return op;
            }
        }
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        final EquipmentAction action = this.getRealRoadBarrierAction();
        if (action != null) {
            int ioIndex;
            if (this.isAlwaysOpen() && this.getRealRoadBarrierAction() instanceof DnctChannelBoardActtion) {
                final OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
                OperationFuture<Integer> of = ((DnctChannelBoardActtion)action).doAlwaysOpen(false);
                of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (!f.isCancelled() && f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                            IOBordGateAction.this.alwaysOpening = false;
                            OperationFuture<Integer> op = ((DnctChannelBoardActtion)action).doDownPoleAction();
                            op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                }

                                public void operationComplete(OperationFuture<Integer> f2) {
                                    if (f2.getException() == null && f2.getResult() != null && (Integer)f2.getResult() == 0) {
                                        IOBordGateAction.this.equipmentState = EquipmentState.BARRIER_DROPPED_IN_PLACE;
                                        IOBordGateAction.this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                    }
                                    if (f2.isCancelled()) {
                                        f1.cancel(true);
                                    } else if (f2.getException() != null) {
                                        f1.setException(f2.getException());
                                    } else {
                                        f1.setResult((Object)((Integer)f2.getResult()));
                                    }
                                }
                            });
                        } else {
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(IOBordGateAction.this.equipment.getName()) + "\uff1a\u5173\u95ed\u5e38\u5f00\u6a21\u5f0f\u5931\u8d25", 1));
                            if (f.isCancelled()) {
                                f1.cancel(true);
                            } else if (f.getException() != null) {
                                f1.setException(f.getException());
                            } else {
                                f1.setResult((Object)((Integer)f.getResult()));
                            }
                        }
                    }
                });
                return f1;
            }
            OperationFuture<Integer> op = null;
            if (action instanceof RoadBarrierAction) {
                op = ((RoadBarrierAction)action).doDownPoleAction();
            } else if (action instanceof IoControlGateAction && (ioIndex = this.getCloseGateIoIndex()) > 0) {
                op = ((IoControlGateAction)action).doOutputIo(ioIndex, 1000L);
            }
            if (op != null) {
                op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                            IOBordGateAction.this.equipmentState = EquipmentState.BARRIER_DROPPED_IN_PLACE;
                            IOBordGateAction.this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                });
                return op;
            }
        }
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        EquipmentAction action = this.getRealRoadBarrierAction();
        if (action == null) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setResult((Object)1);
            return f;
        }
        if (action instanceof RoadBarrierAction) {
            return ((RoadBarrierAction)action).doStopPoleAction();
        }
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        EquipmentAction eAction = this.getRealRoadBarrierAction();
        if (eAction == null) {
            return false;
        }
        if (eAction instanceof RoadBarrierAction) {
            return ((RoadBarrierAction)eAction).isSupportStopPole();
        }
        return false;
    }

    private int getOpenGateIoIndex() {
        Integer a = this.equipment.getEquipmentConfig().getConfigIntValue("open_output_io");
        if (a != null) {
            return a;
        }
        return 0;
    }

    private int getCloseGateIoIndex() {
        Integer a = this.equipment.getEquipmentConfig().getConfigIntValue("close_output_io");
        if (a != null) {
            return a;
        }
        return 0;
    }

    @Override
    public boolean isSupportDownPole() {
        EquipmentAction eAction = this.getRealRoadBarrierAction();
        if (eAction == null) {
            return false;
        }
        if (eAction instanceof RoadBarrierAction) {
            return ((RoadBarrierAction)eAction).isSupportDownPole();
        }
        if (eAction instanceof IoControlGateAction) {
            return this.getCloseGateIoIndex() > 0;
        }
        return false;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
        if (state == null) {
            return;
        }
        this.equipmentState = state;
        this.equipmentStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    @Override
    public void setAlwaysOpen(final boolean alwaysOpen) {
        EquipmentAction eAction = this.getRealRoadBarrierAction();
        if (eAction == null) {
            return;
        }
        if (alwaysOpen ? this.alwaysOpening : !alwaysOpen && !this.alwaysOpening) {
            return;
        }
        if (!(eAction instanceof DnctChannelBoardActtion)) {
            return;
        }
        OperationFuture<Integer> of = ((DnctChannelBoardActtion)eAction).doAlwaysOpen(alwaysOpen);
        of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> f) {
                if (!f.isCancelled() && f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    IOBordGateAction.this.alwaysOpening = alwaysOpen;
                } else if (alwaysOpen) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(IOBordGateAction.this.equipment.getName()) + "\uff1a\u6253\u5f00\u5e38\u5f00\u6a21\u5f0f\u5931\u8d25", 1));
                } else {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(IOBordGateAction.this.equipment.getName()) + "\uff1a\u5173\u95ed\u5e38\u5f00\u6a21\u5f0f\u5931\u8d25", 1));
                }
            }
        });
    }

    @Override
    public void setAlwaysOpenBoxValue(boolean alwaysOpen) {
        long nowMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (nowMills - this.setRemoteAlwaysOpenMills > 1000L) {
            this.alwaysOpening = alwaysOpen;
            if (alwaysOpen && !this.isSupportStateDetected()) {
                this.equipmentStateMills = nowMills;
                this.equipmentState = EquipmentState.BARRIER_RAISED_IN_PLACE;
            }
        }
    }

    private boolean isSupportStateDetected() {
        return false;
    }

    @Override
    public boolean isAlwaysOpen() {
        return this.alwaysOpening;
    }
}

