/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.driver.IceCameraTcpProtocol;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;

public class IceCameraKeepAliveConnection
implements IoHandler,
IceCameraTcpProtocol.IceCameraPackageHandler {
    private static final int ALARM_CONN_PORT = 8200;
    private volatile IoSession alarmIosession;
    private final Object alarmLock = new Object();
    private volatile long alarmConnectingMills;
    private ConnectFuture alarmConnectFuture;
    private volatile long alarmSendHeartBeatMills = 0L;
    private volatile long alarmRevHeartBeatMills = 0L;
    private static final int SESSION_TYPE_ALARM = 0;
    private String cameraIp;
    private volatile boolean stopped = false;
    private final Object closeJobLock = new Object();
    private volatile OperationFutureHandler<Integer> sendAlarmHeartBeatHandler;
    private final Object sendingArmRequestLock = new Object();
    private static final String SESSION_TYPE_ATTR_NAME = "IceCameraTcpAction.SESSION_TYPE";
    private static final String IceCameraTcpProtocolName = IceCameraTcpProtocol.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRevConnHandler(String cameraIp0) {
        IoSession session;
        boolean connected;
        this.cameraIp = cameraIp0;
        if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
            ConnectFuture cancelf = null;
            Object object = this.alarmLock;
            synchronized (object) {
                if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() - this.alarmConnectingMills > 8000L) {
                        cancelf = this.alarmConnectFuture;
                        this.alarmConnectingMills = 0L;
                        this.alarmConnectFuture = null;
                        ServiceLog.getLog().warn((Object)("Camera connection timeout! ip: " + this.cameraIp));
                    } else {
                        if (this.stopped && !this.alarmConnectFuture.isDone()) {
                            this.alarmConnectFuture.cancel();
                            this.alarmConnectingMills = 0L;
                            this.alarmConnectFuture = null;
                        }
                        return;
                    }
                }
            }
            if (cancelf != null) {
                cancelf.cancel();
            }
        }
        boolean bl = connected = (session = this.alarmIosession) != null && session.isConnected() && !session.isClosing();
        if (connected && ServiceUtil.getServiceContext().currentTimeMillis() - this.alarmRevHeartBeatMills > 9000L) {
            session.close(true);
            this.alarmIosession = null;
            connected = false;
        }
        if (!connected) {
            this.doAlarmConnect();
            return;
        }
        this.sendRequestAlarmRequest(session);
        IoSession session1 = this.alarmIosession;
        String ip = this.cameraIp;
        if (session1 != null && ip != null && ip.length() > 0 && !new InetSocketAddress(ip, 8200).equals(session1.getRemoteAddress())) {
            session1.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = true;
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        ConnectFuture cancelf = null;
        Object object = this.alarmLock;
        synchronized (object) {
            if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
                cancelf = this.alarmConnectFuture;
                this.alarmConnectingMills = 0L;
                this.alarmConnectFuture = null;
            }
        }
        if (cancelf != null) {
            cancelf.cancel();
        }
        object = this.alarmLock;
        synchronized (object) {
            IoSession session = this.alarmIosession;
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
                this.alarmIosession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> sendRequestAlarmRequest(IoSession session) {
        OperationFutureHandler sending;
        if (session == null) {
            OperationFutureHandler h1 = ServiceUtil.getServiceContext().createOperationFuture();
            h1.setResult((Object)-1);
            return h1;
        }
        Object object = this.sendingArmRequestLock;
        synchronized (object) {
            sending = this.sendAlarmHeartBeatHandler;
            long a1 = ServiceUtil.getServiceContext().currentTimeMillis();
            if (sending != null && !sending.isDone()) {
                if (a1 - this.alarmSendHeartBeatMills < 3500L) {
                    return sending;
                }
                sending.setException((Throwable)new TimeoutException());
            }
            this.alarmSendHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.sendAlarmHeartBeatHandler = sending = ServiceUtil.getServiceContext().createOperationFuture();
        }
        try {
            IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
            int type = 4103;
            p.setHeadType(type);
            p.setHeadStatus(1);
            p.setHeadChannel(1);
            IoBuffer buf = IceCameraTcpProtocol.toSendBuf(p);
            WriteFuture f = session.write((Object)buf);
            f.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture arg0) {
                    OperationFutureHandler sending0;
                    if (arg0.getException() != null && (sending0 = IceCameraKeepAliveConnection.this.sendAlarmHeartBeatHandler) != null) {
                        sending0.setException(arg0.getException());
                    }
                }
            });
        }
        catch (Exception ex) {
            sending.setException((Throwable)ex);
        }
        return sending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAlarmConnect() {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
        }
        object = this.alarmLock;
        synchronized (object) {
            ConnectFuture future;
            ConnectFuture f1 = this.alarmConnectFuture;
            if (this.alarmConnectingMills > 0L && f1 != null && !f1.isDone()) {
                return;
            }
            final String ip = this.cameraIp;
            if (ip == null || ip.length() == 0) {
                return;
            }
            this.alarmSendHeartBeatMills = 0L;
            this.sendAlarmHeartBeatHandler = null;
            this.alarmConnectFuture = future = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, 8200), (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

                public void initializeSession(IoSession session, ConnectFuture f) {
                    IceCameraKeepAliveConnection.this.setAlarmSession(session);
                }
            });
            this.alarmConnectingMills = ServiceUtil.getServiceContext().currentTimeMillis();
            future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ConnectFuture f) {
                    if (f.getException() != null) {
                        ServiceLog.getLog().warn((Object)("Unable to establish connection with camera [" + ip + ":" + 8200 + "], cause: " + f.getException().getMessage()));
                    } else if (f.getSession() != null) {
                        Object object = IceCameraKeepAliveConnection.this.closeJobLock;
                        synchronized (object) {
                            if (IceCameraKeepAliveConnection.this.stopped) {
                                f.getSession().close(true);
                                return;
                            }
                        }
                        IceCameraKeepAliveConnection.this.sendRequestAlarmRequest(f.getSession());
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlarmSession(IoSession session) {
        session.setAttribute((Object)SESSION_TYPE_ATTR_NAME, (Object)0);
        session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        session.setAttribute((Object)IceCameraTcpProtocolName, (Object)new IceCameraTcpProtocol("[" + this.cameraIp + ":" + 8200 + "]"));
        this.alarmRevHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.alarmIosession = session;
        Object object = this.alarmLock;
        synchronized (object) {
            this.alarmConnectFuture = null;
            this.alarmConnectingMills = 0L;
        }
    }

    public boolean isWorkingProperly() {
        IoSession alarmIosession0 = this.alarmIosession;
        if (alarmIosession0 == null) {
            return false;
        }
        if (!alarmIosession0.isConnected()) {
            return false;
        }
        if (alarmIosession0.isClosing()) {
            return false;
        }
        long a1 = ServiceUtil.getServiceContext().currentTimeMillis();
        return a1 - this.alarmRevHeartBeatMills <= 9000L;
    }

    @Override
    public void handlerPackage(IceCameraTcpProtocol.IceCameraPackage p, Object attach) throws Exception {
        IoSession session = (IoSession)attach;
        int sessionType = (Integer)session.getAttribute((Object)SESSION_TYPE_ATTR_NAME);
        if (sessionType == 0) {
            this.responseAckIfNeed(p, (IoSession)attach);
            if (p.getHeadType() == 4104 || p.getHeadType() == 4162 || p.getHeadType() == 4168) {
                if (4162 == p.getHeadType() && -1609957371 == p.getHeadStatus()) {
                    ServiceLog.getLog().warn((Object)("Unable to connect camera " + this.cameraIp + ", wrong password"));
                    session.close(true);
                    return;
                }
                this.alarmRevHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
                OperationFutureHandler<Integer> sending = this.sendAlarmHeartBeatHandler;
                if (sending != null) {
                    sending.setResult((Object)0);
                }
                return;
            }
            if (p.getHeadType() != 8448 && p.getHeadType() != 8447 && p.getHeadType() == 8194) {
                this.handleAramPackage(p, session);
            }
        }
    }

    private void responseAckIfNeed(IceCameraTcpProtocol.IceCameraPackage p, IoSession session) {
        try {
            if (p.getHeadChannel() == 1) {
                IceCameraTcpProtocol.IceCameraPackage ack = new IceCameraTcpProtocol.IceCameraPackage();
                ack.setHeadType(4111);
                ack.setHeadId(p.getHeadTime());
                IoBuffer buf = IceCameraTcpProtocol.toSendBuf(ack);
                session.write((Object)buf);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.cameraIp) + ": write ACK error:" + ex.getMessage()));
        }
    }

    public void handleAramPackage(IceCameraTcpProtocol.IceCameraPackage p, IoSession session) throws Exception {
        p.getHeadType();
    }

    public void exceptionCaught(IoSession session, Throwable e) throws Exception {
        try {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.cameraIp) + ": " + e.getMessage()));
        }
        finally {
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        if (buf == null) {
            return;
        }
        int sessionType = (Integer)session.getAttribute((Object)SESSION_TYPE_ATTR_NAME);
        if (sessionType == 0) {
            IceCameraTcpProtocol protocl = (IceCameraTcpProtocol)session.getAttribute((Object)IceCameraTcpProtocolName);
            protocl.parse(buf, this, session);
        }
    }

    public void messageSent(IoSession arg0, Object arg1) throws Exception {
    }

    public void sessionClosed(IoSession arg0) throws Exception {
        ServiceLog.getLog().info((Object)("Lost connection with camera " + this.cameraIp));
    }

    public void sessionCreated(IoSession arg0) throws Exception {
    }

    public void sessionIdle(IoSession arg0, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession arg0) throws Exception {
    }
}

