/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.dto.CarparkRegplateRecord;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.driver.CameraSign;
import com.wovoe.carpark.equipment.driver.ICECameraUtil;
import com.wovoe.carpark.equipment.driver.IceCameraKeepAliveConnection;
import com.wovoe.carpark.equipment.driver.IceCameraTcpPlateResult;
import com.wovoe.carpark.equipment.driver.IceCameraTcpProtocol;
import com.wovoe.carpark.equipment.driver.RS485ThreadHandler;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CancelAdvice;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.CancelException;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.http.HttpUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;

public class IceCameraTcpAction
extends AbstractEquipmentAction
implements PlateRegCameraAction,
CameraUartAction,
RoadBarrierAction,
RoadBarrierStateSupport,
IoHandler,
IceCameraTcpProtocol.IceCameraPackageHandler,
InputIoDetectedAction {
    public static final String LIBRARY_NAME = "ice_ipcsdk";
    private static final String IceCameraTcpProtocolName = IceCameraTcpProtocol.class.getName();
    private static final int ALARM_CONN_PORT = 8200;
    private static final int OPT_CONN_PORT = 8117;
    private volatile IoSession alarmIosession;
    private final Object alarmLock = new Object();
    private volatile long alarmConnectingMills;
    private ConnectFuture alarmConnectFuture;
    private volatile long alarmSendHeartBeatMills = 0L;
    private volatile long alarmRevHeartBeatMills = 0L;
    private static final String SESSION_TYPE_ATTR_NAME = "IceCameraTcpAction.SESSION_TYPE";
    private static final int SESSION_TYPE_ALARM = 0;
    private static final byte[] defaultEncryptByts = BytesTool.hexStringToByteArray((String)"2000000041100000010000000100000037D96188216C12EF5BA59A366B80D619");
    private static final String SESSION_SerialReadQueue = "ICESerialReadQueue.";
    public static final String VIDEO_ACTION = "/ICEVideoCameraAction";
    public static final String NATIVE_DRIVE_NAME = "com.wovoe.camera.drive.ice.Drive";
    private Object downloadLocak = new Object();
    private long throwMsgMills;
    private ScheduledFuture<?> jobTaskHandle;
    private ScheduledFuture<?> getIoSateJobTaskHandle;
    private volatile boolean stopped = false;
    private final Object closeJobLock = new Object();
    private volatile Uart[] serialConfigList = null;
    private static final int serialcount = 2;
    private final RS485ThreadHandler[] rs485ThreadHandlers = new RS485ThreadHandler[2];
    private volatile Collection<PlateEntryWrap> whiteList;
    private volatile Collection<PlateEntryWrap> blackList;
    private volatile OperationFutureHandler<Integer> sendAlarmHeartBeatHandler;
    private final Object sendingArmRequestLock = new Object();
    private volatile Long hwnd;
    private volatile String lastRegPlate;
    private volatile int lastRegPlateId = -1;
    private volatile long latestRevZeroRegNumMills;
    private IceCameraKeepAliveConnection iceCameraKeepAliveConnection;
    private String equipmentIp;
    private volatile long handleControlboxMills;
    private volatile boolean groundPressure;
    private volatile long groundPressureMills;
    private volatile long groundReleaseMills;
    private volatile boolean startCheckOpenPole;
    private volatile long poleOpenedMills;
    private String eq_serial_no;
    private LocalProcessTransport localProcessTransport;
    private volatile EquipmentState lastEquipmentState;
    public static final int ICE_PLATE_UNCERTAIN = 0;
    public static final int ICE_PLATE_BLUE = 1;
    public static final int ICE_PLATE_YELLOW = 2;
    public static final int ICE_PLATE_POLICE = 4;
    public static final int ICE_PLATE_WUJING = 8;
    public static final int ICE_PLATE_DBYELLOW = 16;
    public static final int ICE_PLATE_MOTOR = 32;
    public static final int ICE_PLATE_INSTRUCTIONCAR = 64;
    public static final int ICE_PLATE_MILITARY = 128;
    public static final int ICE_PLATE_PERSONAL = 256;
    public static final int ICE_PLATE_GANGAO = 512;
    public static final int ICE_PLATE_EMBASSY = 1024;
    public static final int ICE_PLATE_NONGLARE = 2048;
    public static final int ICE_PLATE_AVIATION = 4096;
    public static final int ICE_PLATE_NEWENERGY = 8192;

    public IceCameraTcpAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
        this.iceCameraKeepAliveConnection = new IceCameraKeepAliveConnection();
    }

    private void throwErrTipMsg(String msg) {
        long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
        if (c1 - this.throwMsgMills > 10000L) {
            this.throwMsgMills = c1;
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 8000));
        }
    }

    @Override
    public boolean isConnGround(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        Integer ioOp1 = this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
        return ioOp1 != null && ioOp1 == 4;
    }

    @Override
    public boolean isGroundPressure(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        return this.isWorkingProperly() && this.groundPressure;
    }

    public boolean hasLineGround() {
        return this.isWorkingProperly() && this.groundPressureMills > 0L;
    }

    public long getPressureMills() {
        if (this.isWorkingProperly() && this.groundPressure && this.groundPressureMills > 0L) {
            return ServiceUtil.getServiceContext().currentTimeMillis() - this.groundPressureMills;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.iceCameraKeepAliveConnection.start();
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = false;
            if (this.jobTaskHandle == null) {
                this.jobTaskHandle = ServiceUtil.getServiceContext().schedule(new JobTask(){

                    protected void doRun() throws Exception {
                        if (IceCameraTcpAction.this.stopped) {
                            return;
                        }
                        IceCameraTcpAction.this.checkHandleRevConnHandler();
                    }
                }, 1000L, 3000L, TimeUnit.MILLISECONDS);
            }
            if (this.getIoSateJobTaskHandle == null) {
                this.getIoSateJobTaskHandle = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){
                    private long nextQueryTimlls;

                    @Override
                    public void run() {
                        try {
                            if (!IceCameraTcpAction.this.isWorkingProperly()) {
                                return;
                            }
                            if (!IceCameraTcpAction.this.isNeedRegPlate()) {
                                return;
                            }
                            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            if (currentMills < this.nextQueryTimlls) {
                                return;
                            }
                            boolean ioInputIndex1 = false;
                            boolean ioInputIndex2 = true;
                            Integer ioOp1 = IceCameraTcpAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
                            Integer ioOp2 = IceCameraTcpAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO2");
                            int ioOpValue1 = 0;
                            int ioOpValue2 = 0;
                            if (ioOp1 != null) {
                                ioOpValue1 = ioOp1;
                            }
                            if (ioOp2 != null) {
                                ioOpValue2 = ioOp2;
                            }
                            if (ioOpValue1 != 4) {
                                ioOpValue1 = 0;
                            }
                            if (ioOpValue2 != 1 && ioOpValue2 != 2 && ioOpValue2 != 3 && ioOpValue2 != 5) {
                                ioOpValue2 = 0;
                            }
                            if (ioOpValue2 == 5 && ServiceUtil.getServiceContext().getFirefightingJob() == null) {
                                ioOpValue2 = 0;
                            }
                            if (ioOpValue1 == 0 && ioOpValue2 == 0) {
                                IceCameraTcpAction.this.startCheckOpenPole = false;
                                return;
                            }
                            final int ioOp1Value = ioOpValue1;
                            final int ioOp2Value = ioOpValue2;
                            this.nextQueryTimlls = currentMills + 6000L;
                            IceCameraTcpAction.this.doGetIOState().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<byte[]>(){

                                public void waitCompleteTimeout() {
                                }

                                public void operationComplete(OperationFuture<byte[]> f) {
                                    long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                    nextQueryTimlls = c1;
                                    if (f.getException() != null) {
                                        ServiceLog.getLog().warn((Object)("[" + IceCameraTcpAction.this.equipment.getIp() + "] Query IO status exception! cause: " + f.getException().getMessage()));
                                    } else if (f.getResult() != null) {
                                        int ioValue;
                                        if (ioOp1Value == 4) {
                                            ioValue = ((byte[])f.getResult())[0] & 0xFF;
                                            if (ioValue == 0) {
                                                if (!IceCameraTcpAction.this.groundPressure) {
                                                    IceCameraTcpAction.this.groundPressure = true;
                                                    IceCameraTcpAction.this.groundPressureMills = c1;
                                                    IceCameraTcpAction.this.startCheckOpenPole = false;
                                                    List<String> channelNos = IceCameraTcpAction.this.equipment.getChannelNos();
                                                    if (channelNos != null && !channelNos.isEmpty()) {
                                                        VehicleDetectorEvent event = new VehicleDetectorEvent(IceCameraTcpAction.this.equipment, 0, 1, channelNos.get(0));
                                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                                    }
                                                }
                                            } else if (ioValue == 1 && IceCameraTcpAction.this.groundPressure) {
                                                IceCameraTcpAction.this.groundPressure = false;
                                                IceCameraTcpAction.this.groundReleaseMills = c1;
                                                IceCameraTcpAction.this.poleOpenedMills = 0L;
                                                IceCameraTcpAction.this.startCheckOpenPole = true;
                                                List<String> channelNos = IceCameraTcpAction.this.equipment.getChannelNos();
                                                if (channelNos != null && !channelNos.isEmpty()) {
                                                    VehicleDetectorEvent event = new VehicleDetectorEvent(IceCameraTcpAction.this.equipment, 0, 0, channelNos.get(0));
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                                }
                                            }
                                        } else {
                                            IceCameraTcpAction.this.startCheckOpenPole = false;
                                        }
                                        if (!(ioOp2Value != 1 && ioOp2Value != 2 && ioOp2Value != 3 && ioOp2Value != 5 || ((byte[])f.getResult()).length < 2 || (ioValue = ((byte[])f.getResult())[1] & 0xFF) != 0 && ioValue != 1)) {
                                            if (ioOp2Value == 5) {
                                                IceCameraTcpAction.this.handleFirefighting(ioOp2Value, ioValue);
                                            } else {
                                                IceCameraTcpAction.this.handleGateState(ioOp2Value, ioValue);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                    }
                }, 2000L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void handleFirefighting(int configV, int ioValue) {
        if (configV != 5) {
            return;
        }
        if (ioValue == 0) {
            try {
                if (ServiceUtil.getServiceContext().getFirefightingJob() != null) {
                    ServiceUtil.getServiceContext().getFirefightingJob().firefighting(this.equipment.getEquipmentNo(), this.equipment.getName(), false);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private long handleGateState(int configV, int ioValue) {
        EquipmentState state = null;
        if (configV == 1) {
            state = ioValue == 0 ? EquipmentState.BARRIER_RAISED_IN_PLACE : EquipmentState.BARRIER_DROPPED_IN_PLACE;
        } else if (configV == 2) {
            state = ioValue == 0 ? EquipmentState.BARRIER_DROPPED_IN_PLACE : EquipmentState.BARRIER_RAISED_IN_PLACE;
        } else if (configV == 3) {
            if (ioValue == 0) {
                this.triggerIllOpenPole();
            }
            return 0L;
        }
        if (state != null) {
            Collection<Equipment> eqs;
            long openedPoleDuration;
            boolean autoDownloadPole;
            block29: {
                autoDownloadPole = false;
                openedPoleDuration = 0L;
                if (state == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    if (this.startCheckOpenPole) {
                        if (this.poleOpenedMills > 0L) {
                            String channelNo = null;
                            List<String> chs = this.equipment.getChannelNos();
                            if (chs != null && !chs.isEmpty()) {
                                channelNo = chs.get(0);
                            }
                            if (channelNo != null && channelNo.length() > 0) {
                                String v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_POLE_DOWN_TIMEOUT");
                                if (v != null && v.length() > 0) {
                                    try {
                                        int a = Integer.parseInt(v);
                                        if (a > 0) {
                                            long timeoutMills = a * 1000;
                                            openedPoleDuration = ServiceUtil.getServiceContext().currentTimeMillis() - this.poleOpenedMills;
                                            if (openedPoleDuration >= timeoutMills) {
                                                autoDownloadPole = true;
                                                this.startCheckOpenPole = false;
                                                this.poleOpenedMills = 0L;
                                            }
                                            break block29;
                                        }
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                    catch (Exception ex) {
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                } else {
                                    this.startCheckOpenPole = false;
                                    this.poleOpenedMills = 0L;
                                }
                            } else {
                                this.startCheckOpenPole = false;
                                this.poleOpenedMills = 0L;
                            }
                        } else {
                            this.poleOpenedMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                } else if (this.lastEquipmentState == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                } else if (this.startCheckOpenPole && ServiceUtil.getServiceContext().currentTimeMillis() - this.groundReleaseMills >= 5000L) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                }
            }
            if ((eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9)) != null) {
                Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    for (Equipment e : eqs) {
                        PassChannel passChannel;
                        if (e.getParentEquipmentNo() == null || !this.equipment.getEquipmentNo().equals(e.getParentEquipmentNo())) continue;
                        if (e.getEquipmentAction() instanceof RoadBarrierStateAction) {
                            ((RoadBarrierStateAction)e.getEquipmentAction()).setPoleSate(state, handleType, channelNos.get(0));
                        }
                        if (!autoDownloadPole) continue;
                        boolean isAlwaysOpen = false;
                        if (e.getEquipmentAction() instanceof AlwaysOpenAction) {
                            isAlwaysOpen = ((AlwaysOpenAction)e.getEquipmentAction()).isAlwaysOpen();
                        }
                        if (isAlwaysOpen || !(e.getEquipmentAction() instanceof RoadBarrierAction) || (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNos.get(0))) == null || passChannel.getLanConnectManageHostState() != null) continue;
                        ((RoadBarrierAction)e.getEquipmentAction()).doDownPoleAction();
                        ServiceLog.getLog().info((Object)("\u68c0\u6d4b\u5230\u8f66\u8f86\u79bb\u5f00\u8bc6\u522b\u533a\u540e\uff0c\u6ca1\u6709\u4efb\u4f55\u8f66\u8f86\uff0c\u9053\u95f8\u6746\u5f53\u524d\u662f\u5f00\u5230\u4f4d\uff0c\u8fd9\u79cd\u72b6\u6001\u5df2\u7ecf\u8fde\u7eed" + openedPoleDuration + "\u6beb\u79d2, \u9053\u95f8\u672a\u8bbe\u7f6e\u5e38\u5f00, \u8fd9\u5c06\u53d1\u9001\u843d\u6746\u6307\u4ee4"));
                    }
                }
            }
            this.lastEquipmentState = state;
        }
        return 0L;
    }

    protected void triggerIllOpenPole() {
        Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
        if (handleType != null && handleType != 2) {
            long xd1 = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.handleControlboxMills == 0L || xd1 - this.handleControlboxMills >= 5000L) {
                this.handleControlboxMills = xd1;
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    EnumSet<RoadBarrierStateEvent.SignalType> signals = null;
                    block0: for (String channelNo : channelNos) {
                        Collection<Equipment> roadGateList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
                        if (roadGateList == null || roadGateList.isEmpty()) continue;
                        for (Equipment eq : roadGateList) {
                            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(channelNo) || eq.getEquipmentAction().getParentEquipmentAction() != this) continue;
                            if (signals == null) {
                                signals = EnumSet.noneOf(RoadBarrierStateEvent.SignalType.class);
                                signals.add(RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN);
                            }
                            EquipmentState state = eq.getEquipmentAction().getEquipmentState();
                            RoadBarrierStateEvent event = new RoadBarrierStateEvent(eq, state, state, signals, channelNo);
                            event.setControlBoxOpenHandleType(handleType);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectTcp() {
        ConnectFuture cancelf = null;
        Object object = this.alarmLock;
        synchronized (object) {
            if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
                cancelf = this.alarmConnectFuture;
                this.alarmConnectingMills = 0L;
                this.alarmConnectFuture = null;
            }
        }
        if (cancelf != null) {
            cancelf.cancel();
        }
        object = this.alarmLock;
        synchronized (object) {
            IoSession session = this.alarmIosession;
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
                this.alarmIosession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = true;
            if (this.jobTaskHandle != null) {
                this.jobTaskHandle.cancel(true);
                this.jobTaskHandle = null;
            }
            if (this.getIoSateJobTaskHandle != null) {
                this.getIoSateJobTaskHandle.cancel(true);
            }
        }
        this.iceCameraKeepAliveConnection.stop();
        this.disconnectTcp();
        object = this.closeJobLock;
        synchronized (object) {
            int i = 0;
            while (i < this.rs485ThreadHandlers.length) {
                RS485ThreadHandler rs485ThreadHandler = this.rs485ThreadHandlers[i];
                if (rs485ThreadHandler != null) {
                    rs485ThreadHandler.stop();
                    this.rs485ThreadHandlers[i] = null;
                }
                ++i;
            }
        }
        this.hwnd = null;
        this.disconnectNativeConnect();
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = IceCameraTcpAction.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/ice_ipcsdk/" + IceCameraTcpAction.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = IceCameraTcpAction.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/ice_ipcsdk/" + IceCameraTcpAction.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/ice_ipcsdk/" + IceCameraTcpAction.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "ice_ipcsdk.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "ice_ipcsdk.so";
        }
        return "ice_ipcsdk.dll";
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private void setTime() {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "http://" + IceCameraTcpAction.this.equipment.getIp() + ":8000/cgi-bin/set.cgi";
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("key", "time_setting");
                    paramMap.put("camera_date", String.valueOf(System.currentTimeMillis() / 1000L));
                    String result = HttpUtil.doRequest((String)url, null, paramMap, (int)5000, (int)5000);
                    if (result == null || !"0".equals(result.trim())) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(IceCameraTcpAction.this.equipment.getIp()) + ": Failed to set camera time, return\uff1a" + result));
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(IceCameraTcpAction.this.equipment.getIp()) + ": Failed to set camera time, setting time returned exception: " + ex.getClass() + ", " + ex.getMessage()));
                }
            }
        });
    }

    private void disconnectNativeConnect() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] close camera connection";
        String serviceName = "disConnect";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    private void checkHandleRevConnHandler() {
        if (this.equipmentIp == null || this.equipmentIp.length() == 0) {
            this.equipmentIp = this.equipment.getIp();
        } else if (!this.equipmentIp.equals(this.equipment.getIp())) {
            this.iceCameraKeepAliveConnection.disconnect();
            this.disconnectTcp();
            this.disconnectNativeConnect();
            this.equipmentIp = this.equipment.getIp();
        }
        if (this.equipmentIp == null || this.equipmentIp.length() == 0) {
            return;
        }
        this.iceCameraKeepAliveConnection.handleRevConnHandler(this.equipmentIp);
        this.handleRevConnHandler(this.equipmentIp);
    }

    public String getEq_serial_no() {
        return this.eq_serial_no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRevConnHandler(String connectIp) {
        IoSession session;
        boolean connected;
        if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
            ConnectFuture cancelf = null;
            Object object = this.alarmLock;
            synchronized (object) {
                if (this.alarmConnectingMills > 0L && this.alarmConnectFuture != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() - this.alarmConnectingMills > 8000L) {
                        cancelf = this.alarmConnectFuture;
                        this.alarmConnectingMills = 0L;
                        this.alarmConnectFuture = null;
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + ", Camera connection timeout! " + this.equipment.getIp() + ":" + 8200));
                    } else {
                        if (this.stopped && !this.alarmConnectFuture.isDone()) {
                            this.alarmConnectFuture.cancel();
                            this.alarmConnectingMills = 0L;
                            this.alarmConnectFuture = null;
                        }
                        return;
                    }
                }
            }
            if (cancelf != null) {
                cancelf.cancel();
            }
        }
        boolean bl = connected = (session = this.alarmIosession) != null && session.isConnected() && !session.isClosing();
        if (connected && ServiceUtil.getServiceContext().currentTimeMillis() - this.alarmRevHeartBeatMills > 9000L) {
            session.close(true);
            this.alarmIosession = null;
            connected = false;
        }
        if (!connected) {
            this.eq_serial_no = null;
            this.doAlarmConnect(connectIp);
            return;
        }
        this.sendRequestAlarmRequest(session);
        IoSession session1 = this.alarmIosession;
        String ip = connectIp;
        if (session1 != null && ip != null && ip.length() > 0 && !new InetSocketAddress(ip, 8200).equals(session1.getRemoteAddress())) {
            session1.close(true);
        }
        this.connectIfNotConnected1(true, connectIp);
        if (this.eq_serial_no == null || this.eq_serial_no.length() == 0) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String s1 = ICECameraUtil.getCameraDevID(IceCameraTcpAction.this.getEquipment().getIp());
                        if (s1 != null && s1.length() > 0) {
                            IceCameraTcpAction.this.eq_serial_no = s1;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlarmSession(IoSession session) {
        session.setAttribute((Object)SESSION_TYPE_ATTR_NAME, (Object)0);
        session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        session.setAttribute((Object)IceCameraTcpProtocolName, (Object)new IceCameraTcpProtocol(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + ":" + 8200 + "]"));
        int i = 0;
        while (i < 2) {
            session.setAttribute((Object)(SESSION_SerialReadQueue + i), (Object)new SerialReadQueue());
            ++i;
        }
        this.whiteList = null;
        this.blackList = null;
        this.alarmRevHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.alarmIosession = session;
        Object object = this.alarmLock;
        synchronized (object) {
            this.alarmConnectFuture = null;
            this.alarmConnectingMills = 0L;
        }
        this.serialConfigList = null;
    }

    private void connectIfNotConnected1(final boolean force, final String connectIp) {
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            return;
        }
        OperationFuture<Integer> f = this.getLocalProcessTransport().loadNativeDriveIfNeed(NATIVE_DRIVE_NAME, "Loading camera local video driver");
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> xd) {
                if (xd.getException() == null && xd.getResult() != null && (Integer)xd.getResult() == 0) {
                    IceCameraTcpAction.this.playIfNeed(force, connectIp);
                }
            }
        });
    }

    private void playIfNeed(boolean force, String connectIp) {
        Long hwnd0 = this.hwnd;
        if (hwnd0 != null) {
            this.nativePlay(hwnd0, force, connectIp);
        }
    }

    private void throwTipErrorMsg(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        String key = String.valueOf(this.getClass().getSimpleName()) + "-" + this.getEquipment().getEquipmentNo() + "-throwTipErrorMsg00009";
        if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 30L, TimeUnit.SECONDS);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
        }
    }

    private boolean checkSign(String connectIp) {
        String encryptData;
        String serialNo;
        boolean needCheckCameraSign = ServiceUtil.getServiceContext().getAuthInfo().isN();
        try {
            serialNo = ICECameraUtil.getCameraDevID(connectIp);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + connectIp + "\u5e8f\u5217\u53f7\u7f51\u7edc\u5f02\u5e38\uff01" + ex));
            return true;
        }
        if (serialNo == null || serialNo.length() == 0) {
            ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + connectIp + "\u5e8f\u5217\u53f7\u5931\u8d25\uff01"));
            return true;
        }
        this.eq_serial_no = serialNo;
        try {
            encryptData = ICECameraUtil.readDataFromCamera(connectIp);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + connectIp + " \u7b7e\u540d\u6570\u636e\u7f51\u7edc\u5f02\u5e38\uff01" + ex));
            return true;
        }
        String realEncryptData = null;
        if (encryptData != null && encryptData.length() > 4 && encryptData.startsWith("WL")) {
            try {
                int hexLen = BytesTool.hexStringToByteArray((String)encryptData.substring(2, 4))[0] & 0xFF;
                String x = encryptData.substring(4, hexLen + 4);
                if (x.endsWith("YK")) {
                    realEncryptData = x.substring(0, x.length() - 2);
                }
            }
            catch (Exception hexLen) {
                // empty catch block
            }
        }
        if (realEncryptData == null || realEncryptData.length() == 0) {
            return true;
        }
        encryptData = realEncryptData;
        Key aeskey = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
        CameraSign cameraSign = CameraSign.parse(encryptData, aeskey);
        if (cameraSign == null) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + connectIp + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u672a\u7b7e\u540d, \u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
                return false;
            }
            return true;
        }
        if (!serialNo.equals(cameraSign.getSerialNo())) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + connectIp + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u7b7e\u540d\u6570\u636e\u9519\u8bef");
                return false;
            }
            return true;
        }
        if (ServiceUtil.getServiceContext().getAuthInfo().getOrgId() != cameraSign.getOrgId()) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + connectIp + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u53d1\u884c\u4e3b\u4f53\u9519\u8bef\uff01\u76f8\u673a\u53d1\u884c\u4e3b\u4f53:" + cameraSign.getOrgId() + "[" + cameraSign.getLicenceId() + "]");
            } else {
                this.throwTipErrorMsg("\u76f8\u673a:" + connectIp + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u5df2\u88ab\u5382\u5546\u52a0\u5bc6\uff01\u76f8\u673a\u53d1\u884c\u4e3b\u4f53:" + cameraSign.getOrgId() + "[" + cameraSign.getLicenceId() + "]");
            }
            return false;
        }
        if (!CameraSign.checkSign(encryptData, aeskey, ServiceUtil.getServiceContext().getAuthInfo().getL())) {
            this.throwTipErrorMsg("\u76f8\u673a:" + connectIp + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u8fde\u63a5\u7b7e\u540d\u9519\u8bef\uff01\u76f8\u673a\u53d1\u884c\u8bb8\u53ef\u8bc1:" + cameraSign.getLicenceId());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAlarmConnect(final String connectIp) {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
        }
        object = this.alarmLock;
        synchronized (object) {
            ConnectFuture future;
            try {
                if (!this.checkSign(connectIp)) {
                    return;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a\u7b7e\u540d\u6570\u636e\u5f02\u5e38! " + ex));
            }
            ConnectFuture f1 = this.alarmConnectFuture;
            if (this.alarmConnectingMills > 0L && f1 != null && !f1.isDone()) {
                return;
            }
            final String ip = connectIp;
            if (ip == null || ip.length() == 0) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + ": CAMERA IP not configured"));
                this.throwErrTipMsg(String.valueOf(this.equipment.getName()) + ": CAMERA IP not configured");
                return;
            }
            this.alarmSendHeartBeatMills = 0L;
            this.sendAlarmHeartBeatHandler = null;
            this.alarmConnectFuture = future = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, 8200), (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

                public void initializeSession(IoSession session, ConnectFuture f) {
                    IceCameraTcpAction.this.setAlarmSession(session);
                }
            });
            this.alarmConnectingMills = ServiceUtil.getServiceContext().currentTimeMillis();
            future.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ConnectFuture f) {
                    if (f.getException() != null) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(IceCameraTcpAction.this.equipment.getName()) + ": The connection could not be established: " + ip + ":" + 8200 + ", reason: " + f.getException().getMessage()));
                    } else if (f.getSession() != null) {
                        Object object = IceCameraTcpAction.this.closeJobLock;
                        synchronized (object) {
                            if (IceCameraTcpAction.this.stopped) {
                                f.getSession().close(true);
                                return;
                            }
                        }
                        IceCameraTcpAction.this.sendRequestAlarmRequest(f.getSession());
                        IceCameraTcpAction.this.setTime();
                        IceCameraTcpAction.this.connectIfNotConnected1(true, connectIp);
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> sendRequestAlarmRequest(IoSession session) {
        OperationFutureHandler sending;
        if (session == null) {
            OperationFutureHandler h1 = ServiceUtil.getServiceContext().createOperationFuture();
            h1.setResult((Object)-1);
            return h1;
        }
        Object object = this.sendingArmRequestLock;
        synchronized (object) {
            sending = this.sendAlarmHeartBeatHandler;
            long a1 = ServiceUtil.getServiceContext().currentTimeMillis();
            if (sending != null && !sending.isDone()) {
                if (a1 - this.alarmSendHeartBeatMills < 3500L) {
                    return sending;
                }
                sending.setException((Throwable)new TimeoutException());
            }
            this.alarmSendHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.sendAlarmHeartBeatHandler = sending = ServiceUtil.getServiceContext().createOperationFuture();
        }
        try {
            WriteFuture f;
            boolean usePwd = true;
            if (!usePwd) {
                IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
                int type = 4103;
                p.setHeadType(type);
                p.setHeadStatus(1);
                p.setHeadChannel(1);
                IoBuffer buf = IceCameraTcpProtocol.toSendBuf(p);
                f = session.write((Object)buf);
            } else {
                IoBuffer buf = IoBuffer.allocate((int)defaultEncryptByts.length);
                buf.put(defaultEncryptByts);
                buf.flip();
                f = session.write((Object)buf);
            }
            f.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture arg0) {
                    OperationFutureHandler sending0;
                    if (arg0.getException() != null && (sending0 = IceCameraTcpAction.this.sendAlarmHeartBeatHandler) != null) {
                        sending0.setException(arg0.getException());
                    }
                }
            });
        }
        catch (Exception ex) {
            sending.setException((Throwable)ex);
        }
        return sending;
    }

    private OperationFuture<Integer> nativePlay(Long hwnd0, boolean force, String connectIp) {
        this.hwnd = hwnd0;
        if (!force && !this.isWorkingProperly()) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setResult((Object)-1);
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] Play the video";
        String serviceName = "playVisible";
        long timeoutMills = 5000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", connectIp);
        paramMap.put("componentID", hwnd0.toString());
        return this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID:" + x));
            return xf;
        }
        String ip = this.equipmentIp;
        if (ip == null || ip.length() == 0) {
            ip = this.equipment.getIp();
        }
        return this.nativePlay(hwnd0, false, ip);
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        return this.stopNativePlay();
    }

    private OperationFuture<Integer> stopNativePlay() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] stop playing";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        if (param == null || param.get("savePath") == null) {
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570: savePath"));
            return xf;
        }
        final String savePath = param.get("savePath").toString();
        final String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u6293\u62cd\u56fe\u7247";
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(4147);
        return this.doOptRequest(p, 6100L, new IceOpHandler<Integer>(){
            private int result = 1;

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (sendP.getHeadType() + 1 == revP.getHeadType() && revP.getHeadStatus() == 1 && revP.getBodyDataLen() > 0) {
                    try {
                        File saveF = new File(savePath);
                        File pa = saveF.getParentFile();
                        if (!pa.exists()) {
                            pa.mkdirs();
                        }
                        try (FileOutputStream out = new FileOutputStream(saveF);){
                            out.write(revP.getBodyData(), revP.getBodyDataOffset(), revP.getBodyDataLen());
                        }
                        this.result = 0;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(opName) + "\u4fdd\u5b58\u56fe\u7247\u5931\u8d25!"), (Throwable)ex);
                    }
                }
                return true;
            }

            @Override
            public Integer getResult() {
                return this.result;
            }
        }, opName);
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    @Override
    public boolean isWorkingProperly() {
        IoSession alarmIosession0 = this.alarmIosession;
        if (alarmIosession0 == null) {
            return false;
        }
        if (!alarmIosession0.isConnected()) {
            return false;
        }
        if (alarmIosession0.isClosing()) {
            return false;
        }
        long a1 = ServiceUtil.getServiceContext().currentTimeMillis();
        return a1 - this.alarmRevHeartBeatMills <= 9000L;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    public void exceptionCaught(IoSession session, Throwable e) throws Exception {
        try {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": " + e.getMessage()));
        }
        finally {
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        if (buf == null) {
            return;
        }
        int sessionType = (Integer)session.getAttribute((Object)SESSION_TYPE_ATTR_NAME);
        if (sessionType == 0) {
            IceCameraTcpProtocol protocl = (IceCameraTcpProtocol)session.getAttribute((Object)IceCameraTcpProtocolName);
            protocl.parse(buf, this, session);
        }
    }

    public void messageSent(IoSession session, Object arg1) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        ServiceLog.getLog().info((Object)("\u4e0e\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u5931\u53bb\u8fde\u63a5 "));
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private OperationFuture<byte[]> doGetIOState() {
        final String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u83b7\u53d6io\u72b6\u6001";
        int type = 4165;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(type);
        return this.doOptRequest(p, 6100L, new IceOpHandler<byte[]>(){
            byte[] ioStates = null;

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (4166 == revP.getHeadType() && 1 == revP.getHeadStatus()) {
                    byte[] data = revP.getBodyData();
                    int offset = revP.getBodyDataOffset();
                    int length = revP.getBodyDataLen();
                    if (data != null && length >= 4 && offset + length <= data.length) {
                        this.ioStates = new byte[4];
                        this.ioStates[0] = data[offset + 0];
                        this.ioStates[1] = data[offset + 1];
                        this.ioStates[2] = data[offset + 2];
                        this.ioStates[3] = data[offset + 3];
                    }
                }
                if (this.ioStates == null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(opName) + " \u83b7\u53d6IO\u72b6\u6001\u4fe1\u606f\u5931\u8d25: \u6570\u636e\u4fe1\u606f: " + revP));
                }
                return true;
            }

            @Override
            public byte[] getResult() {
                return this.ioStates;
            }
        }, opName);
    }

    public OperationFuture<PlateRegCameraAction.XYRegRangle> doGetQuadRangle() {
        final String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u83b7\u53d6\u8bc6\u522b\u7ebf\u5708\u533a\u57df";
        int type = 17157;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(type);
        return this.doOptRequest(p, 6100L, new IceOpHandler<PlateRegCameraAction.XYRegRangle>(){
            PlateRegCameraAction.XYRegRangle r = new PlateRegCameraAction.XYRegRangle();

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (17158 == revP.getHeadType() && 1 == revP.getHeadStatus()) {
                    byte[] data = revP.getBodyData();
                    int offset = revP.getBodyDataOffset();
                    int length = revP.getBodyDataLen();
                    if (data != null && length >= 272 && offset + length <= data.length) {
                        this.r.leftTopX = IceCameraTcpAction.byteArrayToInt(data, offset + 168, 2);
                        this.r.leftTopY = IceCameraTcpAction.byteArrayToInt(data, offset + 170, 2);
                        this.r.leftBottomX = IceCameraTcpAction.byteArrayToInt(data, offset + 172, 2);
                        this.r.leftBottomY = IceCameraTcpAction.byteArrayToInt(data, offset + 174, 2);
                        this.r.rightBottomX = IceCameraTcpAction.byteArrayToInt(data, offset + 176, 2);
                        this.r.rightBottomY = IceCameraTcpAction.byteArrayToInt(data, offset + 178, 2);
                        this.r.rightTopX = IceCameraTcpAction.byteArrayToInt(data, offset + 180, 2);
                        this.r.rightTopY = IceCameraTcpAction.byteArrayToInt(data, offset + 182, 2);
                        this.r.width = IceCameraTcpAction.byteArrayToInt(data, offset + 268, 4);
                        this.r.height = IceCameraTcpAction.byteArrayToInt(data, offset + 272, 4);
                    }
                }
                if (this.r.width == 0 || this.r.height == 0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(opName) + " \u83b7\u53d6\u8bc6\u522b\u7ebf\u5708\u533a\u57df\u5931\u8d25: \u6570\u636e\u4fe1\u606f: " + revP));
                }
                return true;
            }

            @Override
            public PlateRegCameraAction.XYRegRangle getResult() {
                return this.r;
            }
        }, opName);
    }

    private static int byteArrayToInt(byte[] bytes, int offset, int count) {
        int value = 0;
        int i = 0;
        while (i < count) {
            value += (bytes[offset + i] & 0xFF) << 8 * i;
            ++i;
        }
        return value;
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",IO\u5f00\u95f8";
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer io = config.getConfigIntValue("roadGateIO");
        if (io == null) {
            io = 0;
        }
        int type = io == 1 ? 20791 : 20581;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(type);
        return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
    }

    private OperationFuture<Integer> setUartConfig(Uart[] uarts) {
        if (uarts == null || uarts.length != 2 || uarts[0] == null || uarts[1] == null) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new Exception("\u4e32\u53e3\u6570\u91cf\u9519\u8bef!"));
            return f;
        }
        ByteBuffer buf = ByteBuffer.allocate(136);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        Uart[] uartArray = uarts;
        int n = uarts.length;
        int n2 = 0;
        while (n2 < n) {
            Uart uart = uartArray[n2];
            buf.putInt(uart.uartEn);
            buf.putInt(uart.uartWorkMode);
            buf.putInt(uart.baudRate);
            buf.putInt(uart.dataBits);
            buf.putInt(uart.parity);
            buf.putInt(uart.stopBits);
            buf.putInt(uart.flowControl);
            buf.putInt(uart.LEDControlCardType);
            buf.putInt(uart.LEDBusinessType);
            buf.putInt(uart.u32UartProcOneReSendCnt);
            buf.put(uart.screen_mode);
            buf.put(uart.as32Reserved);
            ++n2;
        }
        buf.position(0);
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u8bbe\u7f6e\u4e32\u53e3\u914d\u7f6e";
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(20599);
        IceCameraTcpAction.setBordyData(p, buf);
        return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
    }

    private static void setBordyData(IceCameraTcpProtocol.IceCameraPackage p, ByteBuffer buf) {
        byte[] array;
        int length;
        int offset;
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        p.setBodyDataOffset(offset);
        p.setBodyDataLen(length);
        p.setBodyData(array);
    }

    private OperationFuture<Uart[]> getUartConfig() {
        final String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u83b7\u53d6\u4e32\u53e3\u914d\u7f6e";
        int reqtype = 20601;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(reqtype);
        return this.doOptRequest(p, 6100L, new IceOpHandler<Uart[]>(){
            Uart[] uarts = null;

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (20608 == revP.getHeadType() && 1 == revP.getHeadStatus()) {
                    this.uarts = Uart.parse(revP.getBodyData(), revP.getBodyDataOffset(), revP.getBodyDataLen());
                }
                if (this.uarts == null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(opName) + " \u83b7\u53d6\u4e32\u53e3\u4fe1\u606f\u5931\u8d25: \u6570\u636e\u4fe1\u606f: " + revP));
                }
                return true;
            }

            @Override
            public Uart[] getResult() {
                return this.uarts;
            }
        }, opName);
    }

    private int getOpenPoleIoPort(EquipmentConfig config) {
        Integer io = config.getConfigIntValue("roadGateIO");
        if (io == null) {
            io = 0;
        }
        return io;
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",IO\u843d\u95f8";
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        int openPoleIo = this.getOpenPoleIoPort(config);
        if (openPoleIo != 0) {
            openPoleIo = 1;
        }
        boolean io = openPoleIo == 0;
        int type = io ? 20791 : 20581;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(type);
        return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        int flowControl;
        int parity;
        int screen_mode;
        int stopBits;
        int stopBits1;
        int baudRate;
        int baudRate1;
        int dataBits;
        int dataBits1;
        int uatIndex;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570"));
            return xf;
        }
        Object uatIndex0 = param.get("uatIndex");
        if (uatIndex0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570uatIndex"));
            return xf;
        }
        if (uatIndex0 instanceof Integer) {
            uatIndex = (Integer)uatIndex0;
        } else {
            try {
                uatIndex = Integer.parseInt(uatIndex0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (uatIndex != 0 && uatIndex != 1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u65700\u6216\u80051"));
            return xf;
        }
        Object dataBits0 = param.get("dataBits");
        if (dataBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570dataBits"));
            return xf;
        }
        if (dataBits0 instanceof Integer) {
            dataBits1 = (Integer)dataBits0;
        } else {
            try {
                dataBits1 = Integer.parseInt(dataBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (dataBits1) {
            case 5: {
                dataBits = 0;
                break;
            }
            case 6: {
                dataBits = 1;
                break;
            }
            case 7: {
                dataBits = 2;
                break;
            }
            case 8: {
                dataBits = 3;
                break;
            }
            default: {
                dataBits = -1;
            }
        }
        if (dataBits == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u30105\u30016\u30017\u30018\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object baudRate0 = param.get("baudRate");
        if (baudRate0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570baudRate"));
            return xf;
        }
        if (baudRate0 instanceof Integer) {
            baudRate1 = (Integer)baudRate0;
        } else {
            try {
                baudRate1 = Integer.parseInt(baudRate0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (baudRate1) {
            case 1200: {
                baudRate = 0;
                break;
            }
            case 2400: {
                baudRate = 1;
                break;
            }
            case 4800: {
                baudRate = 2;
                break;
            }
            case 9600: {
                baudRate = 3;
                break;
            }
            case 19200: {
                baudRate = 4;
                break;
            }
            case 38400: {
                baudRate = 5;
                break;
            }
            case 115200: {
                baudRate = 6;
                break;
            }
            default: {
                baudRate = -1;
            }
        }
        if (baudRate == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u30101200\u30012400\u30014800\u30019600\u300119200\u300138400\u3001115200\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object stopBits0 = param.get("stopBits");
        if (stopBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570stopBits"));
            return xf;
        }
        if (stopBits0 instanceof Integer) {
            stopBits1 = (Integer)stopBits0;
        } else {
            try {
                stopBits1 = Integer.parseInt(stopBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (stopBits1) {
            case 1: {
                stopBits = 0;
                break;
            }
            case 2: {
                stopBits = 1;
                break;
            }
            default: {
                stopBits = -1;
            }
        }
        if (stopBits == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u30101\u30012\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object screen_mode0 = param.get("screen_mode");
        if (screen_mode0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570screen_mode"));
            return xf;
        }
        if (screen_mode0 instanceof Integer) {
            screen_mode = (Integer)screen_mode0;
        } else {
            try {
                screen_mode = Integer.parseInt(screen_mode0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (screen_mode != 1 && screen_mode != 2) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u65701\u6216\u80052"));
            return xf;
        }
        Object parity0 = param.get("parity");
        if (parity0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570parity"));
            return xf;
        }
        String parity1 = parity0.toString();
        if ("PARITY_NONE".equals(parity1)) {
            parity = 0;
        } else if ("PARITY_ODD".equals(parity1)) {
            parity = 1;
        } else if ("PARITY_EVEN".equals(parity1)) {
            parity = 2;
        } else if ("PARITY_MARK".equals(parity1)) {
            parity = 3;
        } else if ("PARITY_SPACE".equals(parity1)) {
            parity = 4;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570parity\u5fc5\u987b\u662fPARITY_NONE\u3001PARITY_ODD\u3001PARITY_EVEN\u3001PARITY_MARK\u3001PARITY_SPACE"));
            return xf;
        }
        Object flowControl0 = param.get("flowControl");
        if (flowControl0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570flowControl"));
            return xf;
        }
        String flowControl1 = flowControl0.toString();
        if ("NONE".equals(flowControl1)) {
            flowControl = 0;
        } else if ("HARDWARE".equals(flowControl1)) {
            flowControl = 1;
        } else if ("XON".equals(flowControl1)) {
            flowControl = 2;
        } else if ("XOFF".equals(flowControl1)) {
            flowControl = 3;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570flowControl\u5fc5\u987b\u662fNONE\u3001HARDWARE\u3001XON\u3001XOFF"));
            return xf;
        }
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        Uart[] uarts = this.serialConfigList;
        if (uarts == null || uarts.length != 2 || uarts[0] == null || uarts[1] == null) {
            final int uatIndex5 = uatIndex;
            final int baudRate5 = baudRate;
            final int dataBits5 = dataBits;
            final int parity5 = parity;
            final int stopBits5 = stopBits;
            final int flowControl5 = flowControl;
            final int screen_mode5 = screen_mode;
            this.getUartConfig().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Uart[]>(){

                public void waitCompleteTimeout() {
                    xf.setException((Throwable)new TimeoutException());
                }

                public void operationComplete(OperationFuture<Uart[]> f1) {
                    if (f1.getException() != null) {
                        xf.setException(f1.getException());
                    } else if (f1.getResult() == null) {
                        xf.setResult((Object)-1);
                    } else {
                        IceCameraTcpAction.this.serialConfigList = (Uart[])f1.getResult();
                        IceCameraTcpAction.this.setUatConfigIfChanged(uatIndex5, baudRate5, dataBits5, parity5, stopBits5, flowControl5, screen_mode5, (Uart[])f1.getResult(), (OperationFutureHandler<Integer>)xf);
                    }
                }
            });
        } else {
            this.setUatConfigIfChanged(uatIndex, baudRate, dataBits, parity, stopBits, flowControl, screen_mode, uarts, (OperationFutureHandler<Integer>)xf);
        }
        return xf;
    }

    private void setUatConfigIfChanged(int uatIndex, int baudRate, int dataBits, int parity, int stopBits, int flowControl, int screen_mode, Uart[] uarts, final OperationFutureHandler<Integer> xf) {
        try {
            Uart olduart = uarts[uatIndex];
            Uart newUart = new Uart(olduart.as32Reserved);
            newUart.uartEn = 1;
            newUart.uartWorkMode = 1;
            newUart.baudRate = baudRate;
            newUart.dataBits = dataBits;
            newUart.parity = parity;
            newUart.stopBits = stopBits;
            newUart.flowControl = flowControl;
            newUart.screen_mode = (byte)screen_mode;
            newUart.LEDControlCardType = olduart.LEDControlCardType;
            newUart.LEDBusinessType = olduart.LEDBusinessType;
            newUart.u32UartProcOneReSendCnt = olduart.u32UartProcOneReSendCnt;
            if (!newUart.equals1(olduart)) {
                final Uart[] newUarts = new Uart[uarts.length];
                int i = 0;
                while (i < uarts.length) {
                    newUarts[i] = uarts[i];
                    ++i;
                }
                newUarts[uatIndex] = newUart;
                this.setUartConfig(newUarts).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                        xf.setException((Throwable)new TimeoutException());
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() != null) {
                            xf.setException(f.getException());
                        } else {
                            if (f.getResult() != null && (Integer)f.getResult() == 0) {
                                IceCameraTcpAction.this.serialConfigList = newUarts;
                            }
                            xf.setResult((Object)((Integer)f.getResult()));
                        }
                    }
                });
            } else {
                xf.setResult((Object)0);
            }
        }
        catch (Exception ex) {
            xf.setException((Throwable)ex);
        }
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (data == null || data.length == 0) {
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        RS485ThreadHandler shandler = this.getRS485ThreadHandler(portIndex);
        if (shandler == null || !shandler.isStarted()) {
            if (this.stopped) {
                f.setException((Throwable)new IllegalStateException("\u9a71\u52a8\u5df2\u7ecf\u505c\u6b62!"));
                return f;
            }
            f.setException((Throwable)new IllegalStateException("\u521d\u59cb\u5316\u53d1\u9001\u4e32\u53e3\u7ebf\u7a0b\u5931\u8d25!"));
            return f;
        }
        shandler.sendToQueue(data, handler, f, waitMills);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RS485ThreadHandler getRS485ThreadHandler(int index) {
        RS485ThreadHandler rs485ThreadHandler;
        block7: {
            if (this.stopped) {
                return null;
            }
            if (index < 0 || index >= this.rs485ThreadHandlers.length) {
                return null;
            }
            rs485ThreadHandler = this.rs485ThreadHandlers[index];
            if (rs485ThreadHandler != null) break block7;
            Object object = this.closeJobLock;
            synchronized (object) {
                block6: {
                    rs485ThreadHandler = this.rs485ThreadHandlers[index];
                    if (rs485ThreadHandler != null) break block7;
                    if (!this.stopped) break block6;
                    return null;
                }
                rs485ThreadHandler = new RS485ThreadHandler(index){

                    @Override
                    protected OperationFuture<Boolean> directSend(byte[] data) {
                        try {
                            return IceCameraTcpAction.this.sendSerialData(this.portIndex, data);
                        }
                        catch (Throwable ex) {
                            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                            xf.setException(ex);
                            return xf;
                        }
                    }
                };
                rs485ThreadHandler.start();
                this.rs485ThreadHandlers[index] = rs485ThreadHandler;
            }
        }
        return rs485ThreadHandler;
    }

    private OperationFuture<Boolean> sendSerialData(int portIndex, byte[] data) {
        if (data == null || data.length == 0) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new NullPointerException("send data is null at port:" + portIndex));
            return xf;
        }
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u5411\u4e32\u53e3" + portIndex + "\u53d1\u9001\u6570\u636e";
        int requestType = portIndex == 0 ? 4151 : 4163;
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(requestType);
        p.setBodyData(data);
        p.setBodyDataLen(data.length);
        p.setBodyDataOffset(0);
        return this.doOptRequest(p, 6100L, new IceOpHandler<Boolean>(){
            boolean result = false;

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (sendP.getHeadType() + 1 == revP.getHeadType() && 1 == revP.getHeadStatus()) {
                    this.result = true;
                    try {
                        if (IceCameraTcpAction.this.alarmIosession != null) {
                            IceCameraTcpAction.this.sendRequestAlarmRequest(IceCameraTcpAction.this.alarmIosession);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }

            @Override
            public Boolean getResult() {
                return this.result;
            }
        }, opName);
    }

    @Override
    public boolean isSupportWhiteList() {
        return true;
    }

    @Override
    public boolean isSupportBlackList() {
        return true;
    }

    @Override
    public void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList0, Collection<PlateEntry> blackList0, PlateRegCameraAction.ImportPlateCallback callback) throws Exception {
        if (whiteList0 == null) {
            whiteList0 = new LinkedList<PlateEntry>();
        }
        if (blackList0 == null) {
            blackList0 = new LinkedList<PlateEntry>();
        }
        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downlodAllWhiteBlackList(Collection<PlateEntry> whiteListxx, Collection<PlateEntry> blackListxx, PlateRegCameraAction.ImportPlateCallback callback, boolean onlyCheck) throws Exception {
        try {
            if (callback != null) {
                callback.onCheck(this.equipment.getEquipmentNo(), onlyCheck);
            }
            if (!this.isWorkingProperly()) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            Object object = this.downloadLocak;
            synchronized (object) {
                Collection whiteList1 = this.whiteList;
                Collection blackList1 = this.blackList;
                if (whiteList1 == null || blackList1 == null) {
                    OperationFuture<KeyValueEntry<List<PlateEntryWrap>, List<PlateEntryWrap>>> v;
                    KeyValueEntry v1;
                    if (callback != null) {
                        callback.onQueryAll(this.equipment.getEquipmentNo());
                    }
                    if ((v1 = (KeyValueEntry)(v = this.queryAllBalckWhiteList(15000L)).get(16L, TimeUnit.SECONDS)) == null || v1.getKey() == null || v1.getValue() == null) {
                        throw new Exception("\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u8bb0\u5f55\u8d85\u65f6!");
                    }
                    whiteList1 = (Collection)v1.getKey();
                    blackList1 = (Collection)v1.getValue();
                    this.whiteList = whiteList1;
                    this.blackList = blackList1;
                }
                if (callback != null) {
                    callback.onQueryAllFinish(this.equipment.getEquipmentNo(), whiteList1.size(), blackList1.size(), whiteListxx.size(), blackListxx.size());
                }
                HashMap<String, PlateEntryWrap> newWhiteListMap = new HashMap<String, PlateEntryWrap>();
                HashMap<String, PlateEntryWrap> newBlackListMap = new HashMap<String, PlateEntryWrap>();
                if (whiteListxx != null && !whiteListxx.isEmpty()) {
                    for (PlateEntry e : whiteListxx) {
                        newWhiteListMap.put(e.getPlate(), new PlateEntryWrap(e));
                    }
                }
                if (blackListxx != null && !blackListxx.isEmpty()) {
                    for (PlateEntry e : blackListxx) {
                        newBlackListMap.put(e.getPlate(), new PlateEntryWrap(e));
                    }
                }
                LinkedList<PlateEntryWrap> insertW = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> updateW = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> deleteW = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> insertB = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> updateB = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> deleteB = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> simpleListW = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> simpleListB = new LinkedList<PlateEntryWrap>();
                this.setList(insertW, updateW, deleteW, whiteList1, newWhiteListMap, simpleListW);
                this.setList(insertB, updateB, deleteB, blackList1, newBlackListMap, simpleListB);
                if (insertW.size() == 0 && updateW.size() == 0 && deleteW.size() == 0 && insertB.size() == 0 && updateB.size() == 0 && deleteB.size() == 0) {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), 0, 0, 0, simpleListW.size(), 0, 0, 0, simpleListB.size(), onlyCheck);
                    }
                } else {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), insertW.size(), updateW.size(), deleteW.size(), simpleListW.size(), insertB.size(), updateB.size(), deleteB.size(), simpleListB.size(), onlyCheck);
                    }
                    if (onlyCheck) {
                        return;
                    }
                    if (ServiceLog.getLog().isInfoEnabled()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u53d1\u73b0\u8f66\u724c\u9700\u8981\u540c\u6b65\uff0c\u51c6\u5907\u4e0b\u8f7d\u6700\u65b0\u7684\u8f66\u724c\u4fe1\u606f! "));
                    }
                    if (callback != null) {
                        callback.onStartDownlod(this.equipment.getEquipmentNo());
                    }
                    boolean needRecheck = false;
                    try {
                        if ((blackListxx == null || blackListxx.isEmpty()) && (whiteListxx == null || whiteListxx.isEmpty())) {
                            Integer h = (Integer)this.delteAllBalckWhiteList(8000L).get(9L, TimeUnit.SECONDS);
                            if (h == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u8d85\u65f6!");
                            }
                            if (h != 0) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25!");
                            }
                            ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u9ed1\u767d\u540d\u5355\u5df2\u88ab\u6e05\u7a7a"));
                            if (callback != null) {
                                LinkedList<PlateEntry> emptyList = new LinkedList<PlateEntry>();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteListxx, blackListxx, whiteListxx, emptyList, blackListxx, emptyList);
                            }
                            needRecheck = true;
                        } else {
                            LinkedList<PlateEntry> whiteSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> whiteFaild = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackFaild = new LinkedList<PlateEntry>();
                            this.doOpWorBList(insertW, updateW, deleteW, whiteSuccess, whiteFaild, "W");
                            this.doOpWorBList(insertB, updateB, deleteB, blackSuccess, blackFaild, "B");
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c\u5b8c\u6210!"));
                            }
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                String ip = this.equipment.getIp();
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u767d\u540d\u5355\u603b\u8f66\u724c\u6570: " + whiteListxx.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleListW.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + whiteSuccess.size() + " " + whiteSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + whiteFaild.size() + " " + whiteFaild));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u9ed1\u540d\u5355\u603b\u8f66\u724c\u6570: " + blackListxx.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleListB.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + blackSuccess.size() + " " + blackSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + blackFaild.size() + " " + blackFaild));
                            }
                            if (callback != null) {
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteListxx, blackListxx, whiteSuccess, whiteFaild, blackSuccess, blackFaild);
                            }
                            if (whiteFaild.size() == 0 && blackFaild.size() == 0) {
                                needRecheck = true;
                            }
                        }
                    }
                    finally {
                        this.whiteList = null;
                        this.blackList = null;
                    }
                    if (!onlyCheck && needRecheck) {
                        this.downlodAllWhiteBlackList(whiteListxx, blackListxx, callback, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                callback.onDownlodException(this.equipment.getEquipmentNo(), ex);
            }
            throw ex;
        }
    }

    private void doOpWorBList(List<PlateEntryWrap> insertList, List<PlateEntryWrap> updateList, List<PlateEntryWrap> delteList, List<PlateEntry> successList, List<PlateEntry> errorList, String opType) {
        Integer h;
        if (delteList != null && !delteList.isEmpty()) {
            for (PlateEntryWrap en : delteList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    try {
                        h = (Integer)this.deleteBalckWhiteListItem(en.getPlate()).get(6500L, TimeUnit.MILLISECONDS);
                        if (h != null && h == 0) {
                            successList.add(en);
                            continue;
                        }
                        errorList.add(en);
                    }
                    catch (Exception ex) {
                        errorList.add(en);
                    }
                    continue;
                }
                errorList.add(en);
            }
        }
        if (insertList != null && !insertList.isEmpty()) {
            for (PlateEntryWrap en : insertList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    try {
                        h = (Integer)this.addBalckWhiteListItem(en, opType).get(6500L, TimeUnit.MILLISECONDS);
                        if (h != null && h == 0) {
                            successList.add(en);
                            continue;
                        }
                        errorList.add(en);
                    }
                    catch (Exception ex) {
                        errorList.add(en);
                    }
                    continue;
                }
                errorList.add(en);
            }
        }
        if (updateList != null && !updateList.isEmpty()) {
            for (PlateEntryWrap en : updateList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    try {
                        h = (Integer)this.moidfyBalckWhiteListItem(en, opType).get(6500L, TimeUnit.MILLISECONDS);
                        if (h != null && h == 0) {
                            successList.add(en);
                            continue;
                        }
                        errorList.add(en);
                    }
                    catch (Exception ex) {
                        errorList.add(en);
                    }
                    continue;
                }
                errorList.add(en);
            }
        }
    }

    private OperationFuture<Integer> delteAllBalckWhiteList(long timeMills) {
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u5220\u9664\u6240\u6709\u9ed1\u767d\u540d\u5355\u8f66\u724c";
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(20761);
        return this.doOptRequest(p, timeMills, new SimpleTypeHandler(p.getHeadType() + 1), opName);
    }

    private void setList(List<PlateEntryWrap> insert, List<PlateEntryWrap> update, List<PlateEntryWrap> delete, Collection<PlateEntryWrap> oldList, HashMap<String, PlateEntryWrap> newMap, List<PlateEntryWrap> simpleList) throws Exception {
        for (PlateEntryWrap oldE : oldList) {
            PlateEntryWrap newEntry = newMap.remove(oldE.getPlate());
            if (newEntry == null) {
                delete.add(oldE);
                continue;
            }
            if (oldE.equals(newEntry)) {
                simpleList.add(oldE);
                continue;
            }
            update.add(newEntry);
        }
        if (!newMap.isEmpty()) {
            insert.addAll(newMap.values());
        }
    }

    private OperationFuture<Integer> deleteBalckWhiteListItem(String plateNumber) {
        try {
            byte[] header = new byte[135];
            byte[] data = plateNumber.getBytes("GB2312");
            System.arraycopy(data, 0, header, 0, data.length);
            String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u5220\u9664\u9ed1\u767d\u540d\u5355\u8f66\u724c" + plateNumber;
            IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
            p.setHeadType(20755);
            p.setBodyData(header);
            p.setBodyDataLen(header.length);
            p.setBodyDataOffset(0);
            return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)ex);
            return xf;
        }
    }

    private OperationFuture<Integer> moidfyBalckWhiteListItem(PlateEntryWrap wrap, String BL) {
        try {
            String timeEnd;
            byte[] header = new byte[135];
            String beginDate = wrap.plateEntry.getBeginDate();
            beginDate = beginDate == null || beginDate.length() == 0 ? "2000/01/01" : beginDate.replaceAll("-", "/");
            String endDate = wrap.plateEntry.getEndDate();
            endDate = endDate == null || endDate.length() == 0 ? beginDate : endDate.replaceAll("-", "/");
            String timeBegin = wrap.beginTime;
            if (timeBegin == null || timeBegin.length() == 0) {
                timeBegin = "00:00:00";
            }
            if ((timeEnd = wrap.endTime) == null || timeEnd.length() == 0) {
                timeEnd = "23:59:59";
            }
            String type = "B".equals(BL) ? "B" : "W";
            byte[] data = wrap.plateEntry.getPlate().getBytes("GB2312");
            System.arraycopy(data, 0, header, 0, data.length);
            data = beginDate.getBytes("GB2312");
            System.arraycopy(data, 0, header, 16, data.length);
            data = endDate.getBytes("GB2312");
            System.arraycopy(data, 0, header, 27, data.length);
            data = timeBegin.getBytes("GB2312");
            System.arraycopy(data, 0, header, 38, data.length);
            data = timeEnd.getBytes("GB2312");
            System.arraycopy(data, 0, header, 49, data.length);
            data = type.getBytes("GB2312");
            System.arraycopy(data, 0, header, 60, data.length);
            String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u4fee\u6539\u9ed1\u767d\u540d\u5355" + wrap.plateEntry;
            IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
            p.setHeadType(20757);
            p.setBodyData(header);
            p.setBodyDataLen(header.length);
            p.setBodyDataOffset(0);
            return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)ex);
            return xf;
        }
    }

    private OperationFuture<Integer> addBalckWhiteListItem(PlateEntryWrap wrap, String BL) {
        try {
            String timeEnd;
            byte[] header = new byte[135];
            String beginDate = wrap.plateEntry.getBeginDate();
            beginDate = beginDate == null || beginDate.length() == 0 ? "2000/01/01" : beginDate.replaceAll("-", "/");
            String endDate = wrap.plateEntry.getEndDate();
            endDate = endDate == null || endDate.length() == 0 ? beginDate : endDate.replaceAll("-", "/");
            String timeBegin = wrap.beginTime;
            if (timeBegin == null || timeBegin.length() == 0) {
                timeBegin = "00:00:00";
            }
            if ((timeEnd = wrap.endTime) == null || timeEnd.length() == 0) {
                timeEnd = "23:59:59";
            }
            String type = "B".equals(BL) ? "B" : "W";
            byte[] data = wrap.plateEntry.getPlate().getBytes("GB2312");
            System.arraycopy(data, 0, header, 0, data.length);
            data = beginDate.getBytes("GB2312");
            System.arraycopy(data, 0, header, 16, data.length);
            data = endDate.getBytes("GB2312");
            System.arraycopy(data, 0, header, 27, data.length);
            data = timeBegin.getBytes("GB2312");
            System.arraycopy(data, 0, header, 38, data.length);
            data = timeEnd.getBytes("GB2312");
            System.arraycopy(data, 0, header, 49, data.length);
            data = type.getBytes("GB2312");
            System.arraycopy(data, 0, header, 60, data.length);
            String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u6dfb\u52a0\u9ed1\u767d\u540d\u5355" + wrap.plateEntry;
            IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
            p.setHeadType(20753);
            p.setBodyData(header);
            p.setBodyDataLen(header.length);
            p.setBodyDataOffset(0);
            return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)ex);
            return xf;
        }
    }

    private OperationFuture<KeyValueEntry<List<PlateEntryWrap>, List<PlateEntryWrap>>> queryAllBalckWhiteList(long timeoutMills) {
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u67e5\u8be2\u6240\u6709\u9ed1\u767d\u540d\u5355";
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(20741);
        return this.doOptRequest(p, timeoutMills, new IceOpHandler<KeyValueEntry<List<PlateEntryWrap>, List<PlateEntryWrap>>>(){
            KeyValueEntry<List<PlateEntryWrap>, List<PlateEntryWrap>> entry = new KeyValueEntry();

            @Override
            public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
                if (sendP.getHeadType() + 1 == revP.getHeadType() && 1 == revP.getHeadStatus()) {
                    this.hanle(revP);
                }
                return true;
            }

            private void setEmptyResult() {
                this.entry.setKey(new LinkedList());
                this.entry.setValue(new LinkedList());
            }

            private void hanle(IceCameraTcpProtocol.IceCameraPackage revP) throws Exception {
                if (revP.getBodyData() == null || revP.getBodyDataLen() == 0) {
                    this.setEmptyResult();
                    return;
                }
                String strContent = new String(revP.getBodyData(), revP.getBodyDataOffset(), revP.getBodyDataLen(), "GB2312");
                if (strContent == null || strContent.length() == 0) {
                    this.setEmptyResult();
                    return;
                }
                String[] lines = strContent.split("\r\n|\n");
                LinkedList<PlateEntryWrap> whiteList = new LinkedList<PlateEntryWrap>();
                LinkedList<PlateEntryWrap> blackList = new LinkedList<PlateEntryWrap>();
                this.entry.setKey(whiteList);
                this.entry.setValue(blackList);
                String rep1 = "/";
                String rep2 = "-";
                int i = 0;
                while (i < lines.length) {
                    String strPlate;
                    String[] items;
                    if (lines[i].length() > 0 && (items = lines[i].split(",|\t| ")).length >= 6 && (strPlate = items[0]) != null && strPlate.length() != 0) {
                        String strDateBegin = items[1];
                        if (strDateBegin == null || strDateBegin.length() == 0) {
                            strDateBegin = "2000/01/01";
                        }
                        strDateBegin = strDateBegin.replaceAll(rep1, rep2);
                        String strDateEnd = items[2];
                        if (strDateEnd == null || strDateEnd.length() == 0) {
                            strDateEnd = "2000/01/01";
                        }
                        strDateEnd = strDateEnd.replaceAll(rep1, rep2);
                        String strTimeBegin = items[3];
                        String strTimeEnd = items[4];
                        String strType = items[5];
                        if (strTimeBegin == null || strTimeBegin.length() == 0) {
                            strTimeBegin = "00:00:00";
                        }
                        if (strTimeEnd == null || strTimeEnd.length() == 0) {
                            strTimeEnd = "23:59:59";
                        }
                        PlateEntryWrap entry = new PlateEntryWrap(strPlate, strDateBegin, strDateEnd, strTimeBegin, strTimeEnd);
                        if ("B".equals(strType)) {
                            blackList.add(entry);
                        } else {
                            whiteList.add(entry);
                        }
                    }
                    ++i;
                }
            }

            @Override
            public KeyValueEntry<List<PlateEntryWrap>, List<PlateEntryWrap>> getResult() {
                return this.entry;
            }
        }, opName);
    }

    @Override
    public OperationFuture<Integer> triggerRegPlate() {
        String opName = String.valueOf(this.equipment.getIp()) + ":" + 8117 + ",\u8f6f\u89e6\u53d1\u8bc6\u522b\u8f66\u724c";
        IceCameraTcpProtocol.IceCameraPackage p = new IceCameraTcpProtocol.IceCameraPackage();
        p.setHeadType(4101);
        return this.doOptRequest(p, 6100L, new SimpleTypeHandler(p.getHeadType() + 1), opName);
    }

    private <R> OperationFuture<R> doOptRequest(IceCameraTcpProtocol.IceCameraPackage p, long timeoutMills, IceOpHandler<R> iceOpHandler, String opName) {
        OperationFutureHandler fa = ServiceUtil.getServiceContext().createOperationFuture();
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            fa.setException((Throwable)new IllegalStateException("\u76f8\u673a[" + this.equipment.getName() + "]IP\u672a\u8bbe\u7f6e"));
            return fa;
        }
        if (!this.isWorkingProperly()) {
            fa.setException((Throwable)new IOException("\u76f8\u673a[" + this.equipment.getIp() + "]\u672a\u8fde\u63a5"));
            return fa;
        }
        if (p == null) {
            fa.setException((Throwable)new IOException("\u53d1\u9001\u6570\u636e\u4e0d\u80fdnull"));
            return fa;
        }
        try {
            ((OptRequestEntry)new OptRequestEntry<R>(fa, iceOpHandler, timeoutMills, opName, p)).doRequest(new InetSocketAddress(ip, 8117));
        }
        catch (Throwable ex) {
            fa.setException(ex);
        }
        return fa;
    }

    public boolean isNeedRegPlate() {
        List<String> list = this.equipment.getChannelNos();
        boolean r = false;
        if (list != null) {
            for (String channelNo : list) {
                boolean bl = r = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) != null;
                if (r) break;
            }
        }
        return r;
    }

    private void responseAckIfNeed(IceCameraTcpProtocol.IceCameraPackage p, IoSession session) {
        try {
            if (p.getHeadChannel() == 1) {
                IceCameraTcpProtocol.IceCameraPackage ack = new IceCameraTcpProtocol.IceCameraPackage();
                ack.setHeadType(4111);
                ack.setHeadId(p.getHeadTime());
                IoBuffer buf = IceCameraTcpProtocol.toSendBuf(ack);
                session.write((Object)buf);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "] \u54cd\u5e94ACK\u5f02\u5e38!  \u539f\u56e0:" + ex.getMessage()));
        }
    }

    @Override
    public void handlerPackage(final IceCameraTcpProtocol.IceCameraPackage p, Object attach) throws Exception {
        final IoSession session = (IoSession)attach;
        int sessionType = (Integer)session.getAttribute((Object)SESSION_TYPE_ATTR_NAME);
        if (sessionType == 0) {
            this.responseAckIfNeed(p, (IoSession)attach);
            if (p.getHeadType() == 4104 || p.getHeadType() == 4162 || p.getHeadType() == 4168) {
                if (4162 == p.getHeadType() && -1609957371 == p.getHeadStatus()) {
                    ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u8fde\u63a5\u76f8\u673a " + this.equipment.getName() + "[" + this.equipment.getIp() + "]\uff0c\u5bc6\u7801\u9519\u8bef"));
                    this.throwErrTipMsg("\u65e0\u6cd5\u8fde\u63a5\u76f8\u673a " + this.equipment.getName() + "[" + this.equipment.getIp() + "]\uff0c\u5bc6\u7801\u9519\u8bef");
                    session.close(true);
                    return;
                }
                this.alarmRevHeartBeatMills = ServiceUtil.getServiceContext().currentTimeMillis();
                OperationFutureHandler<Integer> sending = this.sendAlarmHeartBeatHandler;
                if (sending != null) {
                    sending.setResult((Object)0);
                }
                return;
            }
            if (p.getHeadType() == 8448 || p.getHeadType() == 8447) {
                SerialReadQueue queue;
                int uatIndex = p.getHeadType() == 8448 ? 0 : 1;
                RS485ThreadHandler rs485ThreadHandler = this.rs485ThreadHandlers[uatIndex];
                if (rs485ThreadHandler != null && rs485ThreadHandler.isStarted() && (queue = (SerialReadQueue)session.getAttribute((Object)(SESSION_SerialReadQueue + uatIndex))) != null) {
                    queue.push(rs485ThreadHandler, p);
                }
            } else if (p.getHeadType() == 8194) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IceCameraTcpAction.this.handleAramPackage(p, session);
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + IceCameraTcpAction.this.equipment.getName() + "[" + IceCameraTcpAction.this.equipment.getIp() + "] \u5904\u7406\u5e94\u7528\u5305\u5f02\u5e38!"), (Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    public void handleAramPackage(IceCameraTcpProtocol.IceCameraPackage p, IoSession session) throws Exception {
        if (p.getHeadType() == 8194) {
            this.handlePlateResult(p, session);
        }
    }

    private static String getPlateTypeString(int plateTypeCode) {
        String cl;
        switch (plateTypeCode) {
            case 1: {
                cl = "\u84dd\u724c\u8f66";
                break;
            }
            case 2: {
                cl = "\u5355\u5c42\u9ec4\u724c\u8f66";
                break;
            }
            case 4: {
                cl = "\u8b66\u8f66";
                break;
            }
            case 8: {
                cl = "\u6b66\u8b66\u8f66\u8f86";
                break;
            }
            case 16: {
                cl = "\u53cc\u5c42\u9ec4\u724c";
                break;
            }
            case 32: {
                cl = "\u6469\u6258\u8f66";
                break;
            }
            case 64: {
                cl = "\u6559\u7ec3\u8f66";
                break;
            }
            case 128: {
                cl = "\u519b\u8f66";
                break;
            }
            case 256: {
                cl = "\u4e2a\u6027\u5316\u8f66";
                break;
            }
            case 512: {
                cl = "\u6e2f\u6fb3\u8f66";
                break;
            }
            case 1024: {
                cl = "\u4f7f\u9986\u8f66";
                break;
            }
            case 2048: {
                cl = "\u8001\u5f0f\u8f66\u724c";
                break;
            }
            case 4096: {
                cl = "\u6c11\u822a\u8f66\u724c";
                break;
            }
            case 8192: {
                cl = "\u65b0\u80fd\u6e90\u8f66\u724c";
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    public void handlePlateResult(IceCameraTcpProtocol.IceCameraPackage p, IoSession attach) throws Exception {
        String smallSavePath;
        String bigPicsavePath;
        String plateJudgeName;
        int plateJudge;
        float carSpeed;
        String carTypeName;
        int carType;
        String plateTypeName;
        int plateType;
        float plateConfidence;
        String dirName;
        int dir;
        String carLogo;
        String plateColor;
        String plate;
        IceCameraTcpPlateResult result;
        block28: {
            if (!this.isNeedRegPlate()) {
                return;
            }
            if (this.equipment.getUse() != 1) {
                return;
            }
            result = IceCameraTcpPlateResult.parse(p.getBodyData(), p.getBodyDataOffset(), p.getBodyDataLen());
            plate = result.getPlateNum();
            if (plate == null || plate.length() == 0) {
                return;
            }
            Calendar cl111 = Calendar.getInstance();
            boolean mayBeReUpload = false;
            if (result.getU32SerialNum() == 0 && result.getStLiveCapTime() != null) {
                cl111.setTime(result.getStLiveCapTime());
                if (cl111.get(14) == 0) {
                    mayBeReUpload = true;
                }
            }
            if (result.getStLiveCapTime() != null && !mayBeReUpload) {
                cl111.setTime(result.getStLiveCapTime());
                cl111.set(14, 0);
                result.setStLiveCapTime(cl111.getTime());
            }
            if (mayBeReUpload) {
                long cumill = ServiceUtil.getServiceContext().currentTimeMillis();
                long latestRevZeroRegNumMills0 = this.latestRevZeroRegNumMills;
                this.latestRevZeroRegNumMills = cumill;
                if (cumill - latestRevZeroRegNumMills0 < 5000L) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.getEquipment().getIp()) + ": \u4e22\u5f03\u79bb\u7ebf\u4e0a\u4f20\u8f66\u724c\u53f71\uff1a" + plate + ", \u8bc6\u522b\u65f6\u95f4\uff1a" + (result.getStLiveCapTime() == null ? "\u672a\u77e5" : String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(result.getStLiveCapTime())) + ", \u8f66\u8f86\u6d41\u6c34\u53f7:" + result.getU32SerialNum())));
                    return;
                }
                if (System.currentTimeMillis() - result.getStLiveCapTime().getTime() > 60000L) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.getEquipment().getIp()) + ": \u4e22\u5f03\u79bb\u7ebf\u4e0a\u4f20\u8f66\u724c\u53f72\uff1a" + plate + ", \u8bc6\u522b\u65f6\u95f4\uff1a" + (result.getStLiveCapTime() == null ? "\u672a\u77e5" : String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(result.getStLiveCapTime())) + ", \u8f66\u8f86\u6d41\u6c34\u53f7:" + result.getU32SerialNum())));
                    return;
                }
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkRegplateRecord.class)).addEQ("camera_reg_time", (Object)result.getStLiveCapTime().getTime()).addEQ("camera_no", (Object)this.equipment.getEquipmentNo()).addEQ("plate_number", (Object)plate));
                if (count > 0L) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.getEquipment().getIp()) + ": \u4e22\u5f03\u79bb\u7ebf\u4e0a\u4f20\u5230\u8f66\u724c\u53f73\uff1a" + plate + ", \u8bc6\u522b\u65f6\u95f4\uff1a" + (result.getStLiveCapTime() == null ? "\u672a\u77e5" : String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(result.getStLiveCapTime())) + ", \u8f66\u8f86\u6d41\u6c34\u53f7:" + result.getU32SerialNum())));
                    return;
                }
            }
            int lastRegPlateId0 = this.lastRegPlateId;
            String lastRegPlate0 = this.lastRegPlate;
            this.lastRegPlateId = result.getU32SerialNum();
            this.lastRegPlate = plate;
            if (lastRegPlate0 != null && plate.equals(lastRegPlate0) && result.getU32SerialNum() == lastRegPlateId0) {
                ServiceLog.getLog().warn((Object)("\u4e22\u5f03\u6536\u5230\u91cd\u590d\u8f66\u724c\u4fe1\u606f\uff1a" + plate + ", \u8bc6\u522bid\uff1a" + result.getU32SerialNum()));
                return;
            }
            plateColor = result.getPlateColor();
            if (plateColor != null && plateColor.length() > 1) {
                plateColor = plateColor.substring(0, 1);
            }
            carLogo = result.getSzLogName();
            dir = result.getCarDir();
            dirName = dir == 0 ? "\u8f66\u5934\u65b9\u5411" : (dir == 1 ? "\u8f66\u5c3e\u65b9\u5411 " : (dir == 2 ? "\u8f66\u5934\u8f66\u5c3e" : null));
            plateConfidence = result.getPlateConfidence();
            plateType = result.getePlateType();
            plateTypeName = IceCameraTcpAction.getPlateTypeString(plateType);
            carType = result.getS32VehicleType();
            carTypeName = result.getcVehicleType();
            carSpeed = result.getCarSpeed();
            plateJudge = result.getFalsePlate();
            plateJudgeName = plateJudge == 1 ? "\u5047\u8f66\u724c" : "\u771f\u8f66\u724c";
            bigPicsavePath = null;
            smallSavePath = null;
            try {
                FileOutputStream out;
                File saveF;
                byte[] b1;
                try {
                    b1 = plate.getBytes("GB2312");
                }
                catch (Exception ex) {
                    b1 = plate.getBytes();
                }
                String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                long xatime = System.currentTimeMillis();
                Random r = new Random();
                int ranx = Math.abs(r.nextInt());
                if (result.getPicData() == null || result.getPicData().length <= 0) break block28;
                StringBuilder fileNameBtr = new StringBuilder(128).append("plate_").append(plateHex).append('_').append(xatime).append('_').append(ranx).append(".jpg");
                try {
                    saveF = new File(this.getPlateSaveDir(), fileNameBtr.toString());
                    out = new FileOutputStream(saveF);
                    try {
                        out.write(result.getPicData(), 0, result.getPicData().length);
                    }
                    finally {
                        out.close();
                    }
                    bigPicsavePath = saveF.getAbsolutePath();
                }
                catch (IOException e) {
                    ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u5168\u666f\u56fe\u5931\u8d25!", (Throwable)e);
                }
                if (result.getCloseupPictureData() == null || result.getCloseupPictureData().length <= 0) break block28;
                fileNameBtr = new StringBuilder(128).append("plateSmall_").append(plateHex).append('_').append(xatime).append('_').append(ranx).append(".jpg");
                try {
                    saveF = new File(this.getPlateSaveDir(), fileNameBtr.toString());
                    out = new FileOutputStream(saveF);
                    try {
                        out.write(result.getCloseupPictureData(), 0, result.getCloseupPictureData().length);
                    }
                    finally {
                        out.close();
                    }
                    smallSavePath = saveF.getAbsolutePath();
                }
                catch (IOException e) {
                    ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u7279\u5199\u56fe\u5931\u8d25!", (Throwable)e);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u5904\u7406\u8f66\u724c\u8bc6\u522b\u56fe\u7247\u5f02\u5e38: ", (Throwable)ex);
            }
        }
        CameraEvent event = new CameraEvent(this.equipment, plate, plateColor, bigPicsavePath);
        event.setCarLogo(carLogo);
        event.setCarSpeed((int)carSpeed);
        event.setCarType(carType);
        event.setCarTypeDes(carTypeName);
        event.setDir(dir);
        event.setDirDes(dirName);
        event.setPlateConfidence(Float.valueOf(plateConfidence));
        event.setPlateJudge(plateJudge);
        event.setPlateJudgeDes(plateJudgeName);
        event.setPlateSmallPath(smallSavePath);
        event.setPlateType(plateType);
        event.setPlateTypeDes(plateTypeName);
        String carColor = result.getCarColor();
        if (carColor != null && carColor.length() > 0 && !"\u672a\u77e5".equals(carColor)) {
            event.setVehicleColor(carColor);
        }
        if (result.getStLiveCapTime() != null) {
            event.setCameraRegPlateMills(result.getStLiveCapTime().getTime());
        }
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
    }

    public File getPlateSaveDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        File dateDir = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
        File eqFile = new File(dateDir, this.equipment.getEquipmentNo());
        if (!eqFile.exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    @Override
    public boolean isSupportBarrierStateDetected() {
        Integer ioOp = this.getEquipment().getEquipmentConfig().getConfigIntValue("inputIO2");
        return ioOp != null && (ioOp == 1 || ioOp == 2);
    }

    public static interface IceOpHandler<R> {
        public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage var1, IceCameraTcpProtocol.IceCameraPackage var2, IoSession var3) throws Exception;

        public R getResult();
    }

    private static class OptRequestEntry<R>
    extends IoHandlerAdapter
    implements IceOpHandler<R>,
    IoSessionInitializer<ConnectFuture>,
    TimeoutObjectPool.TimeoutCallback,
    IoFutureListener<IoFuture>,
    CancelAdvice,
    IceCameraTcpProtocol.IceCameraPackageHandler {
        private OperationFutureHandler<R> fa;
        private IceOpHandler<R> opHandler;
        private String opName;
        private IceCameraTcpProtocol.IceCameraPackage sendPackage;
        private ConnectFuture connectFuture;
        private long timeoutMills;
        private long connectMills;
        private IceCameraTcpProtocol protocol;
        private boolean loggedException = false;
        private volatile IoSession ioSession;
        private volatile boolean addTimeoutPool;

        private void doRequest(InetSocketAddress address) {
            if (this.connectFuture == null) {
                try {
                    this.connectFuture = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)address, (IoSessionInitializer)this);
                    this.connectFuture.addListener((IoFutureListener)this);
                }
                catch (Throwable ex) {
                    this.exceptionCaught0(null, ex);
                }
            }
        }

        private void exceptionCaught0(IoSession session, Throwable e) {
            try {
                try {
                    try {
                        try {
                            if (this.addTimeoutPool) {
                                this.addTimeoutPool = false;
                                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                if (session == null) {
                                    session = this.ioSession;
                                }
                                if (session != null && session.isConnected() && !session.isClosing()) {
                                    session.close(true);
                                }
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    finally {
                        try {
                            if (session == null) {
                                session = this.ioSession;
                            }
                            if (session != null && session.isConnected() && !session.isClosing()) {
                                session.close(true);
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    block35: {
                        try {
                            try {
                                if (!this.loggedException) {
                                    this.loggedException = true;
                                    ServiceLog.getLog().warn((Object)(String.valueOf(this.opName) + " \u64cd\u4f5c\u5f02\u5e38,\u539f\u56e0: " + e.getMessage()));
                                }
                            }
                            catch (Exception exception) {
                                if (!this.fa.isDone()) {
                                    this.fa.setException(e);
                                }
                                break block35;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!this.fa.isDone()) {
                                this.fa.setException(e);
                            }
                            throw throwable;
                        }
                        if (!this.fa.isDone()) {
                            this.fa.setException(e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void exceptionCaught(IoSession session, Throwable e) throws Exception {
            this.exceptionCaught0(session, e);
        }

        public void sessionClosed(IoSession session) throws Exception {
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            IoBuffer buf = (IoBuffer)message;
            if (buf == null) {
                return;
            }
            this.protocol.parse(buf, this, session);
        }

        public OptRequestEntry(OperationFutureHandler<R> fa, IceOpHandler<R> opHandler, long timeoutMills, String opName, IceCameraTcpProtocol.IceCameraPackage sendPackage) {
            if (fa == null || sendPackage == null) {
                throw new NullPointerException();
            }
            if (opName == null) {
                opName = "";
            }
            this.fa = fa;
            this.opHandler = opHandler;
            this.opName = opName;
            this.sendPackage = sendPackage;
            if (timeoutMills < 6000L) {
                timeoutMills = 6000L;
            }
            this.timeoutMills = timeoutMills;
            this.protocol = new IceCameraTcpProtocol(opName);
            fa.setCancelAdvice((CancelAdvice)this);
            this.connectMills = ServiceUtil.getServiceContext().currentTimeMillis();
        }

        @Override
        public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
            if (this.opHandler != null) {
                return this.opHandler.handlerPackage(sendP, revP, session);
            }
            return true;
        }

        @Override
        public R getResult() {
            if (this.opHandler != null) {
                return this.opHandler.getResult();
            }
            Integer a = 0;
            return (R)a;
        }

        public void initializeSession(IoSession session, ConnectFuture f) {
            session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
            this.ioSession = session;
        }

        public void onTimeout(Object key, Object value) throws Exception {
            this.addTimeoutPool = false;
            IoSession session = value instanceof IoSession ? (IoSession)value : this.ioSession;
            this.exceptionCaught0(session, new TimeoutException("wait response timeout!"));
        }

        public void operationComplete(IoFuture iof) {
            if (iof instanceof WriteFuture) {
                this.onWriteComplete((WriteFuture)iof);
            } else if (iof instanceof ConnectFuture) {
                this.onConnectComplete((ConnectFuture)iof);
            }
        }

        private void onConnectComplete(ConnectFuture f) {
            try {
                if (f.getException() != null) {
                    this.exceptionCaught0(null, f.getException());
                } else if (f.getSession() != null) {
                    if (this.fa.isCancelled() || this.fa.isDone()) {
                        this.exceptionCaught0(f.getSession(), (Throwable)new CancelException("\u8fde\u63a5\u6210\u529f\u540e,\u88ab\u53d6\u6d88"));
                    } else {
                        long x = ServiceUtil.getServiceContext().currentTimeMillis() - this.connectMills;
                        long z = this.timeoutMills - x;
                        if (z <= 0L) {
                            this.exceptionCaught0(f.getSession(), new TimeoutException("\u8fde\u63a5\u6210\u529f\u540e\u7acb\u5373\u8d85\u65f6,\u8d85\u65f6\u671f\u8bbe\u7f6e\u592a\u77ed\u5bfc\u81f4"));
                        } else {
                            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)this, (Object)f.getSession(), (TimeoutObjectPool.TimeoutCallback)this, z, TimeUnit.MILLISECONDS);
                            this.addTimeoutPool = true;
                            IoBuffer sendBuf = IceCameraTcpProtocol.toSendBuf(this.sendPackage);
                            WriteFuture wf = f.getSession().write((Object)sendBuf);
                            wf.addListener((IoFutureListener)this);
                        }
                    }
                } else {
                    this.exceptionCaught0(null, new IOException("\u672a\u8fde\u63a5,\u6216\u8fde\u63a5\u8d85\u65f6"));
                }
            }
            catch (Throwable ex) {
                this.exceptionCaught0(this.ioSession, ex);
            }
        }

        private void onWriteComplete(WriteFuture f) {
            if (f.getException() != null) {
                this.exceptionCaught0(f.getSession(), f.getException());
            }
        }

        public void cancel(boolean arg0) {
            if (this.connectFuture != null && !this.connectFuture.isDone()) {
                this.connectFuture.cancel();
            }
        }

        @Override
        public void handlerPackage(IceCameraTcpProtocol.IceCameraPackage p, Object attach) throws Exception {
            block12: {
                IoSession session = (IoSession)attach;
                try {
                    boolean ex = this.handlerPackage(this.sendPackage, p, session);
                    if (!ex) break block12;
                    try {
                        if (this.addTimeoutPool) {
                            this.addTimeoutPool = false;
                            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this);
                        }
                    }
                    finally {
                        try {
                            if (session != null && session.isConnected() && !session.isClosing()) {
                                session.close(true);
                            }
                        }
                        finally {
                            this.fa.setResult(this.getResult());
                        }
                    }
                }
                catch (Throwable ex) {
                    this.exceptionCaught(session, ex);
                }
            }
        }
    }

    private static class PlateEntryWrap
    extends PlateEntry {
        private static final String BEGIN = "00:00:00";
        private static final String END = "23:59:59";
        private static final String TYPE_B = "B";
        private static final String TYPE_W = "W";
        private PlateEntry plateEntry;
        private String beginTime;
        private String endTime;

        @Override
        public String toString() {
            if (this.plateEntry != null) {
                return this.plateEntry.toString();
            }
            return super.toString();
        }

        public PlateEntryWrap(PlateEntry plateEntry) {
            this.plateEntry = plateEntry;
            this.beginTime = BEGIN;
            this.endTime = END;
        }

        public PlateEntryWrap(String plate, String beginDate, String endDate, String beginTime, String endTime) {
            this.plateEntry = new PlateEntry(plate, beginDate, endDate);
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        @Override
        public String getPlate() {
            if (this.plateEntry == null) {
                return null;
            }
            return this.plateEntry.getPlate();
        }

        @Override
        public void setPlate(String plate) {
            if (this.plateEntry == null) {
                this.plateEntry = new PlateEntry();
            }
            this.plateEntry.setPlate(plate);
        }

        @Override
        public String getBeginDate() {
            if (this.plateEntry == null) {
                return null;
            }
            return this.plateEntry.getBeginDate();
        }

        @Override
        public void setBeginDate(String beginDate) {
            if (this.plateEntry == null) {
                this.plateEntry = new PlateEntry();
            }
            this.plateEntry.setBeginDate(beginDate);
        }

        @Override
        public String getEndDate() {
            if (this.plateEntry == null) {
                return null;
            }
            return this.plateEntry.getEndDate();
        }

        @Override
        public void setEndDate(String endDate) {
            if (this.plateEntry == null) {
                this.plateEntry = new PlateEntry();
            }
            this.plateEntry.setEndDate(endDate);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.beginTime == null ? 0 : this.beginTime.hashCode());
            result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
            result = 31 * result + (this.plateEntry == null ? 0 : this.plateEntry.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlateEntryWrap other = (PlateEntryWrap)obj;
            if (this.beginTime == null ? other.beginTime != null : !this.beginTime.equals(other.beginTime)) {
                return false;
            }
            if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
                return false;
            }
            return !(this.plateEntry == null ? other.plateEntry != null : !this.plateEntry.equals(other.plateEntry));
        }
    }

    private static class SerialReadQueue
    implements Runnable {
        private ConcurrentLinkedQueue<KeyValueEntry<RS485ThreadHandler, IceCameraTcpProtocol.IceCameraPackage>> queue = new ConcurrentLinkedQueue();
        private volatile boolean running = false;

        private SerialReadQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(RS485ThreadHandler handler, IceCameraTcpProtocol.IceCameraPackage p) {
            if (p == null || p.getBodyData() == null || p.getBodyDataLen() == 0 || handler == null) {
                return;
            }
            SerialReadQueue serialReadQueue = this;
            synchronized (serialReadQueue) {
                this.queue.offer((KeyValueEntry<RS485ThreadHandler, IceCameraTcpProtocol.IceCameraPackage>)new KeyValueEntry((Object)handler, (Object)p));
                if (!this.running && this.queue.peek() != null) {
                    try {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(this);
                    }
                    catch (Exception ex) {
                        this.queue.clear();
                        this.running = false;
                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                KeyValueEntry<RS485ThreadHandler, IceCameraTcpProtocol.IceCameraPackage> entry;
                if ((entry = this.queue.poll()) != null) {
                    try {
                        ((RS485ThreadHandler)entry.getKey()).handleRecevie(((IceCameraTcpProtocol.IceCameraPackage)entry.getValue()).getBodyData(), ((IceCameraTcpProtocol.IceCameraPackage)entry.getValue()).getBodyDataOffset(), ((IceCameraTcpProtocol.IceCameraPackage)entry.getValue()).getBodyDataLen());
                    }
                    catch (Throwable ex) {
                        ServiceLog.getLog().warn((Object)"", ex);
                    }
                    continue;
                }
                SerialReadQueue serialReadQueue = this;
                synchronized (serialReadQueue) {
                    if (this.queue.peek() == null) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
    }

    private static class SimpleTypeHandler
    implements IceOpHandler<Integer> {
        private int result = 1;
        private int responseType;

        private SimpleTypeHandler(int responseType) {
            this.responseType = responseType;
        }

        @Override
        public boolean handlerPackage(IceCameraTcpProtocol.IceCameraPackage sendP, IceCameraTcpProtocol.IceCameraPackage revP, IoSession session) throws Exception {
            if (this.responseType == revP.getHeadType() && revP.getHeadStatus() == 1) {
                this.result = 0;
            }
            return true;
        }

        @Override
        public Integer getResult() {
            return this.result;
        }
    }

    static class Uart {
        public int uartEn;
        public int uartWorkMode;
        public int baudRate;
        public int dataBits;
        public int parity;
        public int stopBits;
        public int flowControl;
        public int LEDControlCardType;
        public int LEDBusinessType;
        public int u32UartProcOneReSendCnt;
        public byte screen_mode;
        public byte[] as32Reserved;

        public Uart() {
            this(null);
        }

        public Uart(byte[] as32Reserved) {
            if (as32Reserved == null || as32Reserved.length != 7) {
                as32Reserved = new byte[7];
            }
            this.as32Reserved = as32Reserved;
        }

        public static Uart[] parse(byte[] data, int offset, int length) {
            if (data == null || length < 96 || offset + length > data.length) {
                return null;
            }
            Uart[] uarts = new Uart[]{new Uart(), new Uart()};
            ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            int i = 0;
            while (i < uarts.length) {
                uarts[i].uartEn = buf.getInt();
                uarts[i].uartWorkMode = buf.getInt();
                uarts[i].baudRate = buf.getInt();
                uarts[i].dataBits = buf.getInt();
                uarts[i].parity = buf.getInt();
                uarts[i].stopBits = buf.getInt();
                uarts[i].flowControl = buf.getInt();
                uarts[i].LEDControlCardType = buf.getInt();
                uarts[i].LEDBusinessType = buf.getInt();
                uarts[i].u32UartProcOneReSendCnt = buf.getInt();
                uarts[i].screen_mode = buf.get();
                buf.get(uarts[i].as32Reserved);
                ++i;
            }
            return uarts;
        }

        public boolean equals1(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Uart)) {
                return false;
            }
            Uart other = (Uart)obj;
            if (this.LEDBusinessType != other.LEDBusinessType) {
                return false;
            }
            if (this.LEDControlCardType != other.LEDControlCardType) {
                return false;
            }
            if (this.baudRate != other.baudRate) {
                return false;
            }
            if (this.dataBits != other.dataBits) {
                return false;
            }
            if (this.flowControl != other.flowControl) {
                return false;
            }
            if (this.parity != other.parity) {
                return false;
            }
            if (this.screen_mode != other.screen_mode) {
                return false;
            }
            if (this.stopBits != other.stopBits) {
                return false;
            }
            if (this.u32UartProcOneReSendCnt != other.u32UartProcOneReSendCnt) {
                return false;
            }
            if (this.uartEn != other.uartEn) {
                return false;
            }
            return this.uartWorkMode == other.uartWorkMode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Uart [uartEn=");
            builder.append(this.uartEn);
            builder.append(", uartWorkMode=");
            builder.append(this.uartWorkMode);
            builder.append(", baudRate=");
            builder.append(this.baudRate);
            builder.append(", dataBits=");
            builder.append(this.dataBits);
            builder.append(", parity=");
            builder.append(this.parity);
            builder.append(", stopBits=");
            builder.append(this.stopBits);
            builder.append(", flowControl=");
            builder.append(this.flowControl);
            builder.append(", LEDControlCardType=");
            builder.append(this.LEDControlCardType);
            builder.append(", LEDBusinessType=");
            builder.append(this.LEDBusinessType);
            builder.append(", u32UartProcOneReSendCnt=");
            builder.append(this.u32UartProcOneReSendCnt);
            builder.append(", screen_mode=");
            builder.append(this.screen_mode);
            builder.append(", as32Reserved=");
            builder.append(Arrays.toString(this.as32Reserved));
            builder.append("]");
            return builder.toString();
        }
    }
}

