/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.internel.ServiceLog;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.Date;

public class IceCameraTcpPlateResult {
    private static final byte ENDSTRINGBYTE = 0;
    private int alarmType;
    private Date stLiveCapTime;
    private int u32SerialNum;
    private int u32PlateWidth;
    private int u32ExtSnapPixel;
    private int u32PictureHashID;
    private int u32Encrypt;
    private byte u8PlateTea;
    private int falsePlate;
    private int s32TripWireEventCode;
    private int s32VehicleIntensity;
    private String cVehicleType;
    private int enVehicleColor;
    private int s32VehicleType;
    private Date stCapTime;
    private int haveCloseUp;
    private short carRect16Left;
    private short carRect16Top;
    private short carRect16Right;
    private short carRect16Bottom;
    private int carDir;
    private float carSpeed;
    private String carColor;
    private String plateColor;
    private int existPlate;
    private String plateNum;
    private short plateRect16Left;
    private short plateRect16Top;
    private short plateRect16Right;
    private short plateRect16Bottom;
    private float plateConfidence;
    private int plateIntensity;
    private int ePlateColor;
    private int ePlateType;
    private int eVehicleColor;
    private float flPlateAngleH;
    private float flPlateAngleV;
    private int plateColorRate;
    private int u32FrameId;
    private int picWidth;
    private int picHeight;
    private int picDataLen;
    private byte[] picData;
    private int closeupPicDataLen;
    private byte[] closeupPictureData;
    private String szLogName;
    private String szSubLogName;
    private String szProductYearName;

    public static IceCameraTcpPlateResult parse(byte[] data, int offet, int length) {
        if (data == null || length < 368 || offet + length > data.length) {
            return null;
        }
        IceCameraTcpPlateResult r = new IceCameraTcpPlateResult();
        ByteBuffer buf = ByteBuffer.wrap(data, offet, length);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(buf.position() + 136);
        r.u32SerialNum = buf.getInt();
        r.stLiveCapTime = IceCameraTcpPlateResult.parseDate(buf);
        r.u32SerialNum = buf.getInt();
        r.u32PlateWidth = buf.getInt();
        r.u32ExtSnapPixel = buf.getInt();
        buf.position(buf.position() + 8);
        r.u32PictureHashID = buf.getInt();
        r.u32Encrypt = buf.getInt();
        r.u8PlateTea = buf.get();
        buf.position(buf.position() + 50);
        r.falsePlate = buf.get() & 0xFF;
        r.s32TripWireEventCode = buf.getInt();
        r.s32VehicleIntensity = buf.getInt();
        r.cVehicleType = IceCameraTcpPlateResult.parseString(buf, 12, "GB2312");
        r.enVehicleColor = buf.getInt();
        r.s32VehicleType = buf.getInt();
        r.stCapTime = IceCameraTcpPlateResult.parseDate(buf);
        r.haveCloseUp = buf.getInt();
        r.carRect16Left = buf.getShort();
        r.carRect16Top = buf.getShort();
        r.carRect16Right = buf.getShort();
        r.carRect16Bottom = buf.getShort();
        r.carDir = buf.getInt();
        r.carSpeed = buf.getFloat();
        r.carColor = IceCameraTcpPlateResult.parseString(buf, 32, "GB2312");
        r.plateColor = IceCameraTcpPlateResult.parseString(buf, 32, "GB2312");
        r.existPlate = buf.getInt();
        if (buf.remaining() < 160) {
            r.plateNum = "\u65e0\u724c\u8f66";
            return r;
        }
        if (r.existPlate == 1) {
            r.plateNum = IceCameraTcpPlateResult.parseString(buf, 16, "GB2312");
            r.plateRect16Left = buf.getShort();
            r.plateRect16Top = buf.getShort();
            r.plateRect16Right = buf.getShort();
            r.plateRect16Bottom = buf.getShort();
            buf.position(buf.position() + 56 + 28);
            r.plateConfidence = buf.getFloat();
            r.plateIntensity = buf.getInt();
            r.ePlateColor = buf.getInt();
            r.ePlateType = buf.getInt();
            r.eVehicleColor = buf.getInt();
            r.flPlateAngleH = buf.getFloat();
            r.flPlateAngleV = buf.getFloat();
            r.plateColorRate = buf.get() & 0xFF;
            buf.position(buf.position() + 19);
            r.u32FrameId = buf.getInt();
        } else {
            r.plateNum = "\u65e0\u724c\u8f66";
            buf.position(buf.position() + 160);
        }
        if (buf.remaining() < 8) {
            return r;
        }
        r.picWidth = buf.getShort() & 0xFFFF;
        r.picHeight = buf.getShort() & 0xFFFF;
        r.picDataLen = buf.getInt();
        if (r.picDataLen < 0) {
            r.picDataLen = 0;
            return r;
        }
        if (r.picDataLen > 0) {
            if (buf.remaining() < r.picDataLen) {
                r.picDataLen = 0;
                return r;
            }
            r.picData = new byte[r.picDataLen];
            buf.get(r.picData);
        } else {
            if (buf.remaining() <= 4) {
                return r;
            }
            buf.getInt();
        }
        while (buf.hasRemaining()) {
            if (buf.remaining() <= 4) {
                return r;
            }
            int tlv_len = buf.getShort() & 0xFFFF;
            int tlv_type = buf.getShort() & 0xFFFF;
            if (tlv_len <= 0) continue;
            if (buf.remaining() < tlv_len) {
                return r;
            }
            if (tlv_type == 0 && r.haveCloseUp == 1 && r.existPlate == 1) {
                r.closeupPicDataLen = tlv_len;
                r.closeupPictureData = new byte[tlv_len];
                buf.get(r.closeupPictureData);
                continue;
            }
            if (tlv_type == 1) {
                if (tlv_len >= 20) {
                    r.szLogName = IceCameraTcpPlateResult.parseString(buf, 20, "UTF-8");
                    tlv_len -= 20;
                }
                if (tlv_len >= 20) {
                    r.szSubLogName = IceCameraTcpPlateResult.parseString(buf, 20, "UTF-8");
                    tlv_len -= 20;
                }
                if (tlv_len >= 20) {
                    r.szProductYearName = IceCameraTcpPlateResult.parseString(buf, 20, "UTF-8");
                    tlv_len -= 20;
                }
                if (tlv_len <= 0) continue;
                buf.position(buf.position() + tlv_len);
                continue;
            }
            buf.position(buf.position() + tlv_len);
        }
        return r;
    }

    private static String parseString(ByteBuffer buf, int len, String charset) {
        if (buf.remaining() >= len) {
            byte[] ba = new byte[len];
            int index = 0;
            boolean isEnd = false;
            int i = 0;
            while (i < len) {
                byte b = buf.get();
                if (!isEnd) {
                    if (b == 0) {
                        isEnd = true;
                    } else {
                        ba[index++] = b;
                    }
                }
                ++i;
            }
            if (index == 0) {
                return "";
            }
            try {
                return new String(ba, 0, index, charset);
            }
            catch (UnsupportedEncodingException e) {
                ServiceLog.getLog().warn((Object)("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u683c\u5f0f: " + charset + ", " + e.getMessage()));
                return new String(ba, 0, index);
            }
        }
        return null;
    }

    private static Date parseDate(ByteBuffer buf) {
        int year = buf.getShort() & 0xFFFF;
        int month = buf.getShort() & 0xFFFF;
        if (month <= 0) {
            month = 1;
        }
        buf.getShort();
        int day = buf.getShort() & 0xFFFF;
        int hour = buf.getShort() & 0xFFFF;
        int min = buf.getShort() & 0xFFFF;
        int sec = buf.getShort() & 0xFFFF;
        int mills = buf.getShort() & 0xFFFF;
        Calendar cl = Calendar.getInstance();
        cl.set(14, mills);
        cl.set(year, month - 1, day, hour, min, sec);
        return cl.getTime();
    }

    public int getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(int alarmType) {
        this.alarmType = alarmType;
    }

    public Date getStLiveCapTime() {
        return this.stLiveCapTime;
    }

    public void setStLiveCapTime(Date stLiveCapTime) {
        this.stLiveCapTime = stLiveCapTime;
    }

    public int getU32SerialNum() {
        return this.u32SerialNum;
    }

    public void setU32SerialNum(int u32SerialNum) {
        this.u32SerialNum = u32SerialNum;
    }

    public int getU32PlateWidth() {
        return this.u32PlateWidth;
    }

    public void setU32PlateWidth(int u32PlateWidth) {
        this.u32PlateWidth = u32PlateWidth;
    }

    public int getU32ExtSnapPixel() {
        return this.u32ExtSnapPixel;
    }

    public void setU32ExtSnapPixel(int u32ExtSnapPixel) {
        this.u32ExtSnapPixel = u32ExtSnapPixel;
    }

    public int getU32PictureHashID() {
        return this.u32PictureHashID;
    }

    public void setU32PictureHashID(int u32PictureHashID) {
        this.u32PictureHashID = u32PictureHashID;
    }

    public int getU32Encrypt() {
        return this.u32Encrypt;
    }

    public void setU32Encrypt(int u32Encrypt) {
        this.u32Encrypt = u32Encrypt;
    }

    public byte getU8PlateTea() {
        return this.u8PlateTea;
    }

    public void setU8PlateTea(byte u8PlateTea) {
        this.u8PlateTea = u8PlateTea;
    }

    public int getFalsePlate() {
        return this.falsePlate;
    }

    public void setFalsePlate(int falsePlate) {
        this.falsePlate = falsePlate;
    }

    public int getS32TripWireEventCode() {
        return this.s32TripWireEventCode;
    }

    public void setS32TripWireEventCode(int s32TripWireEventCode) {
        this.s32TripWireEventCode = s32TripWireEventCode;
    }

    public int getS32VehicleIntensity() {
        return this.s32VehicleIntensity;
    }

    public void setS32VehicleIntensity(int s32VehicleIntensity) {
        this.s32VehicleIntensity = s32VehicleIntensity;
    }

    public String getcVehicleType() {
        return this.cVehicleType;
    }

    public void setcVehicleType(String cVehicleType) {
        this.cVehicleType = cVehicleType;
    }

    public int getEnVehicleColor() {
        return this.enVehicleColor;
    }

    public void setEnVehicleColor(int enVehicleColor) {
        this.enVehicleColor = enVehicleColor;
    }

    public int getS32VehicleType() {
        return this.s32VehicleType;
    }

    public void setS32VehicleType(int s32VehicleType) {
        this.s32VehicleType = s32VehicleType;
    }

    public Date getStCapTime() {
        return this.stCapTime;
    }

    public void setStCapTime(Date stCapTime) {
        this.stCapTime = stCapTime;
    }

    public int getHaveCloseUp() {
        return this.haveCloseUp;
    }

    public void setHaveCloseUp(int haveCloseUp) {
        this.haveCloseUp = haveCloseUp;
    }

    public short getCarRect16Left() {
        return this.carRect16Left;
    }

    public void setCarRect16Left(short carRect16Left) {
        this.carRect16Left = carRect16Left;
    }

    public short getCarRect16Top() {
        return this.carRect16Top;
    }

    public void setCarRect16Top(short carRect16Top) {
        this.carRect16Top = carRect16Top;
    }

    public short getCarRect16Right() {
        return this.carRect16Right;
    }

    public void setCarRect16Right(short carRect16Right) {
        this.carRect16Right = carRect16Right;
    }

    public short getCarRect16Bottom() {
        return this.carRect16Bottom;
    }

    public void setCarRect16Bottom(short carRect16Bottom) {
        this.carRect16Bottom = carRect16Bottom;
    }

    public int getCarDir() {
        return this.carDir;
    }

    public void setCarDir(int carDir) {
        this.carDir = carDir;
    }

    public float getCarSpeed() {
        return this.carSpeed;
    }

    public void setCarSpeed(float carSpeed) {
        this.carSpeed = carSpeed;
    }

    public String getCarColor() {
        return this.carColor;
    }

    public void setCarColor(String carColor) {
        this.carColor = carColor;
    }

    public String getPlateColor() {
        return this.plateColor;
    }

    public void setPlateColor(String plateColor) {
        this.plateColor = plateColor;
    }

    public int getExistPlate() {
        return this.existPlate;
    }

    public void setExistPlate(int existPlate) {
        this.existPlate = existPlate;
    }

    public String getPlateNum() {
        return this.plateNum;
    }

    public void setPlateNum(String plateNum) {
        this.plateNum = plateNum;
    }

    public short getPlateRect16Left() {
        return this.plateRect16Left;
    }

    public void setPlateRect16Left(short plateRect16Left) {
        this.plateRect16Left = plateRect16Left;
    }

    public short getPlateRect16Top() {
        return this.plateRect16Top;
    }

    public void setPlateRect16Top(short plateRect16Top) {
        this.plateRect16Top = plateRect16Top;
    }

    public short getPlateRect16Right() {
        return this.plateRect16Right;
    }

    public void setPlateRect16Right(short plateRect16Right) {
        this.plateRect16Right = plateRect16Right;
    }

    public short getPlateRect16Bottom() {
        return this.plateRect16Bottom;
    }

    public void setPlateRect16Bottom(short plateRect16Bottom) {
        this.plateRect16Bottom = plateRect16Bottom;
    }

    public float getPlateConfidence() {
        return this.plateConfidence;
    }

    public void setPlateConfidence(float plateConfidence) {
        this.plateConfidence = plateConfidence;
    }

    public int getPlateIntensity() {
        return this.plateIntensity;
    }

    public void setPlateIntensity(int plateIntensity) {
        this.plateIntensity = plateIntensity;
    }

    public int getePlateColor() {
        return this.ePlateColor;
    }

    public void setePlateColor(int ePlateColor) {
        this.ePlateColor = ePlateColor;
    }

    public int getePlateType() {
        return this.ePlateType;
    }

    public void setePlateType(int ePlateType) {
        this.ePlateType = ePlateType;
    }

    public int geteVehicleColor() {
        return this.eVehicleColor;
    }

    public void seteVehicleColor(int eVehicleColor) {
        this.eVehicleColor = eVehicleColor;
    }

    public float getFlPlateAngleH() {
        return this.flPlateAngleH;
    }

    public void setFlPlateAngleH(float flPlateAngleH) {
        this.flPlateAngleH = flPlateAngleH;
    }

    public float getFlPlateAngleV() {
        return this.flPlateAngleV;
    }

    public void setFlPlateAngleV(float flPlateAngleV) {
        this.flPlateAngleV = flPlateAngleV;
    }

    public int getPlateColorRate() {
        return this.plateColorRate;
    }

    public void setPlateColorRate(int plateColorRate) {
        this.plateColorRate = plateColorRate;
    }

    public int getU32FrameId() {
        return this.u32FrameId;
    }

    public void setU32FrameId(int u32FrameId) {
        this.u32FrameId = u32FrameId;
    }

    public int getPicWidth() {
        return this.picWidth;
    }

    public void setPicWidth(int picWidth) {
        this.picWidth = picWidth;
    }

    public int getPicHeight() {
        return this.picHeight;
    }

    public void setPicHeight(int picHeight) {
        this.picHeight = picHeight;
    }

    public int getPicDataLen() {
        return this.picDataLen;
    }

    public void setPicDataLen(int picDataLen) {
        this.picDataLen = picDataLen;
    }

    public byte[] getPicData() {
        return this.picData;
    }

    public void setPicData(byte[] picData) {
        this.picData = picData;
    }

    public int getCloseupPicDataLen() {
        return this.closeupPicDataLen;
    }

    public void setCloseupPicDataLen(int closeupPicDataLen) {
        this.closeupPicDataLen = closeupPicDataLen;
    }

    public byte[] getCloseupPictureData() {
        return this.closeupPictureData;
    }

    public void setCloseupPictureData(byte[] closeupPictureData) {
        this.closeupPictureData = closeupPictureData;
    }

    public String getSzLogName() {
        return this.szLogName;
    }

    public void setSzLogName(String szLogName) {
        this.szLogName = szLogName;
    }

    public String getSzSubLogName() {
        return this.szSubLogName;
    }

    public void setSzSubLogName(String szSubLogName) {
        this.szSubLogName = szSubLogName;
    }

    public String getSzProductYearName() {
        return this.szProductYearName;
    }

    public void setSzProductYearName(String szProductYearName) {
        this.szProductYearName = szProductYearName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(1024);
        builder.append("IceCameraTcpPlateResult [alarmType=");
        builder.append(this.alarmType);
        builder.append(", stLiveCapTime=");
        builder.append(this.stLiveCapTime);
        builder.append(", u32SerialNum=");
        builder.append(this.u32SerialNum);
        builder.append(", u32PlateWidth=");
        builder.append(this.u32PlateWidth);
        builder.append(", u32ExtSnapPixel=");
        builder.append(this.u32ExtSnapPixel);
        builder.append(", u32PictureHashID=");
        builder.append(this.u32PictureHashID);
        builder.append(", u32Encrypt=");
        builder.append(this.u32Encrypt);
        builder.append(", u8PlateTea=");
        builder.append(this.u8PlateTea);
        builder.append(", falsePlate=");
        builder.append(this.falsePlate);
        builder.append(", s32TripWireEventCode=");
        builder.append(this.s32TripWireEventCode);
        builder.append(", s32VehicleIntensity=");
        builder.append(this.s32VehicleIntensity);
        builder.append(", cVehicleType=");
        builder.append(this.cVehicleType);
        builder.append(", enVehicleColor=");
        builder.append(this.enVehicleColor);
        builder.append(", s32VehicleType=");
        builder.append(this.s32VehicleType);
        builder.append(", stCapTime=");
        builder.append(this.stCapTime);
        builder.append(", haveCloseUp=");
        builder.append(this.haveCloseUp);
        builder.append(", carRect16Left=");
        builder.append(this.carRect16Left);
        builder.append(", carRect16Top=");
        builder.append(this.carRect16Top);
        builder.append(", carRect16Right=");
        builder.append(this.carRect16Right);
        builder.append(", carRect16Bottom=");
        builder.append(this.carRect16Bottom);
        builder.append(", carDir=");
        builder.append(this.carDir);
        builder.append(", carSpeed=");
        builder.append(this.carSpeed);
        builder.append(", carColor=");
        builder.append(this.carColor);
        builder.append(", plateColor=");
        builder.append(this.plateColor);
        builder.append(", existPlate=");
        builder.append(this.existPlate);
        builder.append(", plateNum=");
        builder.append(this.plateNum);
        builder.append(", plateRect16Left=");
        builder.append(this.plateRect16Left);
        builder.append(", plateRect16Top=");
        builder.append(this.plateRect16Top);
        builder.append(", plateRect16Right=");
        builder.append(this.plateRect16Right);
        builder.append(", plateRect16Bottom=");
        builder.append(this.plateRect16Bottom);
        builder.append(", plateConfidence=");
        builder.append(this.plateConfidence);
        builder.append(", plateIntensity=");
        builder.append(this.plateIntensity);
        builder.append(", ePlateColor=");
        builder.append(this.ePlateColor);
        builder.append(", ePlateType=");
        builder.append(this.ePlateType);
        builder.append(", eVehicleColor=");
        builder.append(this.eVehicleColor);
        builder.append(", flPlateAngleH=");
        builder.append(this.flPlateAngleH);
        builder.append(", flPlateAngleV=");
        builder.append(this.flPlateAngleV);
        builder.append(", plateColorRate=");
        builder.append(this.plateColorRate);
        builder.append(", u32FrameId=");
        builder.append(this.u32FrameId);
        builder.append(", picWidth=");
        builder.append(this.picWidth);
        builder.append(", picHeight=");
        builder.append(this.picHeight);
        builder.append(", picDataLen=");
        builder.append(this.picDataLen);
        builder.append(", closeupPicDataLen=");
        builder.append(this.closeupPicDataLen);
        builder.append(", szLogName=");
        builder.append(this.szLogName);
        builder.append(", szSubLogName=");
        builder.append(this.szSubLogName);
        builder.append(", szProductYearName=");
        builder.append(this.szProductYearName);
        builder.append("]");
        return builder.toString();
    }
}

