/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;

public class IceCameraTcpProtocol {
    public static final int ICE_CONTROL_TYPE_VDR_REQUEST_ALARM_DATA = 4103;
    public static final int ICE_CONTROL_TYPE_VDR_REQUEST_ALARM_DATA_RSP = 4104;
    public static final int ICE_CONTROL_TYPE_VDR_REQUEST_ALARM1_DATA = 4167;
    public static final int ICE_CONTROL_TYPE_VDR_REQUEST_ALARM1_DATA_NO_PIC_RSP = 4168;
    public static final int REQUEST_ALARM_DATA_WITH_PWD = 4161;
    public static final int REQUEST_ALARM_DATA_WITH_PWD_RSP = 4162;
    public static final int PWD_ERROR = -1609957371;
    public static final int ICE_EVENT_TYPE_VLPR_EVENT = 8194;
    public static final int ICE_EVENT_TYPE_ACK_RSP = 4111;
    public static final int ICE_RS485_DATA_EVENT = 8448;
    public static final int ICE_RS232_DATA_EVENT = 8447;
    private static final int WAIT_PACKAGELEN = 0;
    private static final int WAIT_TYPE = 1;
    private static final int WAIT_STATUS = 2;
    private static final int WAIT_CHANNEL = 3;
    private static final int WAIT_TIME = 4;
    private static final int WAIT_DATE = 5;
    private static final int WAIT_ID = 6;
    private static final int WAIT_LEVEL = 7;
    private static final int WAIT_BODYDATA = 8;
    private static final int WAIT_BEGIN = 9;
    private static final int WAIT_END1 = 10;
    private static final int WAIT_END2 = 11;
    private static final byte V_7E = 126;
    private static final byte V_5A = 90;
    private static final int MAXDATALEN = 0x500000;
    private static final int MAX_WAIT_TIMEOUT_MILLS = 5000;
    private static final int HEAD_LENGTH = 32;
    private String logName;
    private byte[] headBytes = new byte[4];
    private volatile int headBytesIndex = 0;
    private volatile IceCameraPackage framePackage;
    private volatile int state = 0;
    private volatile long revPackLenMills;
    private volatile int bodyDataIndex;
    private volatile byte[] bodyData;
    private volatile boolean splitFrame;
    private final Map<SplitKey, IceCameraPackageQueue> spiltPackegeMap = new HashMap<SplitKey, IceCameraPackageQueue>();

    public IceCameraTcpProtocol(String logName) {
        if (logName == null) {
            logName = "";
        }
        this.logName = logName;
    }

    private void clear() {
        this.headBytesIndex = 0;
        this.revPackLenMills = 0L;
        this.state = 0;
        this.bodyData = null;
        this.framePackage = null;
        this.bodyDataIndex = 0;
        this.splitFrame = false;
    }

    private void checkSpiltPackegeMap() {
        if (!this.spiltPackegeMap.isEmpty()) {
            long s1 = ServiceUtil.getServiceContext().currentTimeMillis();
            Iterator<Map.Entry<SplitKey, IceCameraPackageQueue>> it = this.spiltPackegeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<SplitKey, IceCameraPackageQueue> e = it.next();
                if (e.getValue() == null || e.getKey() == null) {
                    it.remove();
                    continue;
                }
                if (s1 - e.getValue().createMills <= 10000L) continue;
                it.remove();
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u7b49\u5f85\u7ed3\u675f\u5e27\u8d85\u65f6\uff0c\u8fd9\u5c06\u79fb\u9664\u4e4b\u524d\u5df2\u6536\u5230\u7684\u6240\u6709\u5305, \u4e22\u5f03\u5305\u6570\u91cf" + e.getValue().size() + ", \u5305Key\u4fe1\u606f: " + e.getKey()));
            }
        }
    }

    public synchronized void parse(IoBuffer buf, IceCameraPackageHandler handler, Object attach) {
        long revMills;
        if (buf == null) {
            return;
        }
        boolean logged = false;
        if (this.revPackLenMills != 0L && (revMills = ServiceUtil.getServiceContext().currentTimeMillis()) - this.revPackLenMills > 5000L) {
            this.clear();
            ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u89e3\u6790\u9519\u8bef\uff01\u51fa\u73b0\u6570\u636e\u4e22\u5931\uff01\u7b49\u5f85\u4e00\u4e2a\u5b8c\u6574\u6570\u636e\u62a5\u65f6\u95f4\u8d85\u8fc7" + 5000 + "\u6beb\u79d2\uff0c\u8fd9\u5c06\u4e22\u5f03\u4e4b\u524d\u63a5\u6536\u7684\u6570\u636e"));
        }
        while (buf.hasRemaining()) {
            IceCameraPackage frameSp;
            IceCameraPackageQueue queue;
            boolean isend;
            byte b = buf.get();
            if (this.state == 0) {
                if (this.headBytesIndex == 0 && !this.splitFrame) {
                    this.revPackLenMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    if (b == 126) {
                        this.state = 9;
                        continue;
                    }
                }
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                int packLen = IceCameraTcpProtocol.bytesToInt(this.headBytes, 0);
                if (packLen > 0x500000) {
                    this.clear();
                    if (logged) continue;
                    logged = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u957f\u5ea6\u9519\u8bef\uff01\u6570\u636e\u957f\u5ea6\u8fc7\u5927,\u957f\u5ea6: " + packLen));
                    continue;
                }
                if (packLen < 32) {
                    this.clear();
                    if (logged) continue;
                    logged = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u957f\u5ea6\u9519\u8bef\uff01\u6570\u636e\u957f\u5ea6\u5c0f\u4e8e" + 32 + ",\u957f\u5ea6: " + packLen));
                    continue;
                }
                this.framePackage = new IceCameraPackage();
                this.framePackage.setHeadAndBodylen(packLen);
                this.bodyDataIndex = 0;
                if (packLen > 32) {
                    this.framePackage.setBodyDataLen(packLen - 32);
                }
                this.headBytesIndex = 0;
                this.state = 1;
                continue;
            }
            if (this.state == 1) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadType(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 2;
                continue;
            }
            if (this.state == 2) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadStatus(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 3;
                continue;
            }
            if (this.state == 3) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadChannel(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 4;
                continue;
            }
            if (this.state == 4) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadTime(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 5;
                continue;
            }
            if (this.state == 5) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadDate(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 6;
                continue;
            }
            if (this.state == 6) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadId(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                this.headBytesIndex = 0;
                this.state = 7;
                continue;
            }
            if (this.state == 7) {
                this.headBytes[this.headBytesIndex++] = b;
                if (this.headBytesIndex != this.headBytes.length) continue;
                this.framePackage.setHeadLevel(IceCameraTcpProtocol.bytesToInt(this.headBytes, 0));
                if (this.framePackage.getBodyDataLen() > 0) {
                    this.bodyData = new byte[this.framePackage.getBodyDataLen()];
                    this.framePackage.setBodyData(this.bodyData);
                    this.bodyDataIndex = 0;
                    this.framePackage.setBodyDataOffset(0);
                    this.headBytesIndex = 0;
                    this.state = 8;
                    continue;
                }
                if (this.splitFrame) {
                    this.state = 10;
                    continue;
                }
                IceCameraPackage framePackage0 = this.framePackage;
                this.clear();
                try {
                    if (handler == null) continue;
                    handler.handlerPackage(framePackage0, attach);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u5e94\u7528\u6570\u636e\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                }
                continue;
            }
            if (this.state == 8) {
                this.bodyData[this.bodyDataIndex++] = b;
                if (this.bodyDataIndex != this.bodyData.length) continue;
                if (this.splitFrame) {
                    this.state = 10;
                    continue;
                }
                IceCameraPackage framePackage0 = this.framePackage;
                this.clear();
                try {
                    if (handler == null) continue;
                    handler.handlerPackage(framePackage0, attach);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u5e94\u7528\u6570\u636e\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                }
                continue;
            }
            if (this.state == 9) {
                if (b == 90) {
                    this.splitFrame = true;
                } else {
                    this.headBytes[this.headBytesIndex++] = 126;
                    this.headBytes[this.headBytesIndex++] = b;
                }
                this.state = 0;
                continue;
            }
            if (this.state == 10) {
                if (b != 90) {
                    this.clear();
                    if (logged) continue;
                    logged = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u62c6\u5305\u7ed3\u675f\u6807\u8bc6\u9519\u8bef\uff1a\u671f\u5f85" + 90 + ",\u4f46\u662f\u4e3a " + b));
                    continue;
                }
                this.state = 11;
                continue;
            }
            if (this.state != 11) continue;
            if (b != 126) {
                this.clear();
                if (logged) continue;
                logged = true;
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u62c6\u5305\u7ed3\u675f\u6807\u8bc6\u9519\u8bef\uff1a\u671f\u5f85" + 126 + ",\u4f46\u662f\u4e3a " + b));
                continue;
            }
            IceCameraPackage framePackage0 = this.framePackage;
            this.clear();
            SplitKey splitKey = new SplitKey(framePackage0);
            boolean isfirst = (framePackage0.getHeadStatus() & 0x80) == 128;
            boolean bl = isend = (framePackage0.getHeadStatus() & 0x40) == 64;
            if (isfirst && isend) {
                framePackage0.setSpiltDataFrame(true);
                framePackage0.setSpiltDataFrameCount(1);
                this.spiltPackegeMap.remove(splitKey);
                this.checkSpiltPackegeMap();
                try {
                    if (handler == null) continue;
                    handler.handlerPackage(framePackage0, attach);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u5e94\u7528\u6570\u636e\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                }
                continue;
            }
            if (isfirst) {
                this.checkSpiltPackegeMap();
                queue = new IceCameraPackageQueue();
                queue.offerLast(framePackage0);
                IceCameraPackageQueue iceCameraPackageQueue = queue;
                iceCameraPackageQueue.bufSize = iceCameraPackageQueue.bufSize + framePackage0.getBodyDataLen();
                this.spiltPackegeMap.put(splitKey, queue);
                continue;
            }
            queue = isend ? this.spiltPackegeMap.remove(splitKey) : this.spiltPackegeMap.get(splitKey);
            this.checkSpiltPackegeMap();
            if (queue == null) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u65e0\u6cd5\u627e\u5230\u5305\u5bf9\u5e94\u7684\u7f13\u5b58\u961f\u5217,\u53ef\u80fd\u662f\u7f51\u7edc\u5ef6\u8fdf\uff0c\u7b49\u5f85\u8d85\u65f6, \u6216\u8005\u51fa\u73b0\u8fc7\u5305\u4e22\u5931\u5bfc\u81f4\uff0c\u8fd9\u5c06\u4e22\u5f03\u8be5\u5305, \u5305\u4fe1\u606f: " + framePackage0));
                continue;
            }
            IceCameraPackage lastP = (IceCameraPackage)queue.peekLast();
            if (lastP == null) {
                if (!isend) {
                    this.spiltPackegeMap.remove(splitKey);
                }
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u65e0\u6cd5\u627e\u5230\u591a\u5305\u5f00\u59cb\u5e27\u7d22\u5f15,\u53ef\u80fd\u662f\u7f51\u7edc\u5ef6\u8fdf\uff0c\u7b49\u5f85\u8d85\u65f6\u5bfc\u81f4\uff0c\u8fd9\u5c06\u4e22\u5f03\u5305, \u5305\u4fe1\u606f: " + framePackage0));
                continue;
            }
            if (lastP.headId + 1 != framePackage0.headId) {
                String sm;
                if (!isend) {
                    this.spiltPackegeMap.remove(splitKey);
                    sm = ",\u548c\u540e\u7eed\u63a5\u6536\u5230\u6b64\u7c7b\u578b\u5bf9\u5e94\u7d22\u5f15\u5305";
                } else {
                    sm = "";
                }
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u51fa\u73b0\u5305\u4e22\u5931\uff0c\u671f\u5f85\u5e27\u7d22\u5f15\u4e3a:" + (lastP.headId + 1) + "\uff0c\u4f46\u662f\u6536\u5230\u4e3a:" + framePackage0.headId + ",\u8fd9\u5c06\u4e22\u5f03\u4e4b\u524d\u5df2\u7ecf\u6536\u5230\u7684" + queue.size() + "\u4e2a\u5305,\u4ee5\u53ca\u672c\u5305" + sm + ", \u672c\u5305\u4fe1\u606f: " + framePackage0));
                continue;
            }
            queue.offerLast(framePackage0);
            IceCameraPackageQueue iceCameraPackageQueue = queue;
            iceCameraPackageQueue.bufSize = iceCameraPackageQueue.bufSize + framePackage0.getBodyDataLen();
            if (!isend) continue;
            byte[] bufdata = new byte[queue.bufSize];
            int bufIndex = 0;
            int frameCount = queue.size();
            while ((frameSp = (IceCameraPackage)queue.poll()) != null) {
                if (frameSp.getBodyData() == null || frameSp.getBodyDataLen() <= 0) continue;
                System.arraycopy(frameSp.getBodyData(), frameSp.getBodyDataOffset(), bufdata, bufIndex, frameSp.getBodyDataLen());
                bufIndex += frameSp.getBodyDataLen();
            }
            framePackage0.setBodyDataOffset(0);
            framePackage0.setBodyDataLen(bufdata.length);
            framePackage0.setBodyData(bufdata);
            framePackage0.setHeadAndBodylen(framePackage0.getBodyDataLen() + 32);
            framePackage0.setSpiltDataFrame(true);
            framePackage0.setSpiltDataFrameCount(frameCount);
            try {
                if (handler == null) continue;
                handler.handlerPackage(framePackage0, attach);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u5e94\u7528\u6570\u636e\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public static IoBuffer toSendBuf(IceCameraPackage p) {
        int len = 32 + p.getBodyDataLen();
        p.setHeadAndBodylen(len);
        IoBuffer buf = IoBuffer.allocate((int)len);
        IceCameraTcpProtocol.putInt(buf, len);
        IceCameraTcpProtocol.putInt(buf, p.getHeadType());
        IceCameraTcpProtocol.putInt(buf, p.getHeadStatus());
        IceCameraTcpProtocol.putInt(buf, p.getHeadChannel());
        IceCameraTcpProtocol.putInt(buf, p.getHeadTime());
        IceCameraTcpProtocol.putInt(buf, p.getHeadDate());
        IceCameraTcpProtocol.putInt(buf, p.getHeadId());
        IceCameraTcpProtocol.putInt(buf, p.getHeadLevel());
        if (p.getBodyDataLen() > 0) {
            buf.put(p.getBodyData(), p.getBodyDataOffset(), p.getBodyDataLen());
        }
        buf.flip();
        return buf;
    }

    public static int bytesToInt(byte[] b, int offset) {
        return BytesTool.makeInt((byte)b[offset + 3], (byte)b[offset + 2], (byte)b[offset + 1], (byte)b[offset + 0]);
    }

    public static void putInt(IoBuffer buf, int x) {
        buf.put((byte)(x >> 0));
        buf.put((byte)(x >> 8));
        buf.put((byte)(x >> 16));
        buf.put((byte)(x >> 24));
    }

    public static byte[] intToBytes(int x) {
        byte[] b = new byte[4];
        b[3] = (byte)(x >> 24);
        b[2] = (byte)(x >> 16);
        b[1] = (byte)(x >> 8);
        b[0] = (byte)(x >> 0);
        return b;
    }

    public static class IceCameraPackage {
        private int headAndBodylen;
        private int headType;
        private int headStatus;
        private int headChannel;
        private int headTime;
        private int headDate;
        private int headId;
        private int headLevel;
        private byte[] bodyData;
        private int bodyDataOffset;
        private int bodyDataLen;
        private boolean spiltDataFrame;
        private int spiltDataFrameCount;

        public int getHeadAndBodylen() {
            return this.headAndBodylen;
        }

        public void setHeadAndBodylen(int headAndBodylen) {
            this.headAndBodylen = headAndBodylen;
        }

        public int getHeadType() {
            return this.headType;
        }

        public void setHeadType(int headType) {
            this.headType = headType;
        }

        public int getHeadStatus() {
            return this.headStatus;
        }

        public void setHeadStatus(int headStatus) {
            this.headStatus = headStatus;
        }

        public int getHeadChannel() {
            return this.headChannel;
        }

        public void setHeadChannel(int headChannel) {
            this.headChannel = headChannel;
        }

        public int getHeadTime() {
            return this.headTime;
        }

        public void setHeadTime(int headTime) {
            this.headTime = headTime;
        }

        public int getHeadDate() {
            return this.headDate;
        }

        public void setHeadDate(int headDate) {
            this.headDate = headDate;
        }

        public int getHeadId() {
            return this.headId;
        }

        public void setHeadId(int headId) {
            this.headId = headId;
        }

        public int getHeadLevel() {
            return this.headLevel;
        }

        public void setHeadLevel(int headLevel) {
            this.headLevel = headLevel;
        }

        public byte[] getBodyData() {
            return this.bodyData;
        }

        public void setBodyData(byte[] bodyData) {
            this.bodyData = bodyData;
        }

        public int getBodyDataOffset() {
            return this.bodyDataOffset;
        }

        public void setBodyDataOffset(int bodyDataOffset) {
            this.bodyDataOffset = bodyDataOffset;
        }

        public int getBodyDataLen() {
            return this.bodyDataLen;
        }

        public void setBodyDataLen(int bodyDataLen) {
            this.bodyDataLen = bodyDataLen;
        }

        public boolean isSpiltDataFrame() {
            return this.spiltDataFrame;
        }

        public void setSpiltDataFrame(boolean spiltDataFrame) {
            this.spiltDataFrame = spiltDataFrame;
        }

        public int getSpiltDataFrameCount() {
            return this.spiltDataFrameCount;
        }

        public void setSpiltDataFrameCount(int spiltDataFrameCount) {
            this.spiltDataFrameCount = spiltDataFrameCount;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IceCameraPackage [headAndBodylen=");
            builder.append(this.headAndBodylen);
            builder.append(", headType=");
            builder.append(this.headType);
            builder.append(", headStatus=");
            builder.append(this.headStatus);
            builder.append(", headChannel=");
            builder.append(this.headChannel);
            builder.append(", headTime=");
            builder.append(this.headTime);
            builder.append(", headDate=");
            builder.append(this.headDate);
            builder.append(", headId=");
            builder.append(this.headId);
            builder.append(", headLevel=");
            builder.append(this.headLevel);
            builder.append(", bodyDataOffset=");
            builder.append(this.bodyDataOffset);
            builder.append(", bodyDataLen=");
            builder.append(this.bodyDataLen);
            builder.append(", spiltDataFrame=");
            builder.append(this.spiltDataFrame);
            builder.append(", spiltDataFrameCount=");
            builder.append(this.spiltDataFrameCount);
            builder.append("]");
            return builder.toString();
        }
    }

    public static interface IceCameraPackageHandler {
        public void handlerPackage(IceCameraPackage var1, Object var2) throws Exception;
    }

    private static class IceCameraPackageQueue
    extends LinkedList<IceCameraPackage> {
        private static final long serialVersionUID = 1L;
        private long createMills = ServiceUtil.getServiceContext().currentTimeMillis();
        private int bufSize = 0;
    }

    private static class SplitKey {
        private int headType;
        private int headChannel;
        private int headTime;
        private int headDate;
        private int headLevel;

        public SplitKey(IceCameraPackage p) {
            this.headType = p.headType;
            this.headChannel = p.headChannel;
            this.headTime = p.headTime;
            this.headDate = p.headDate;
            this.headLevel = p.headLevel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.headChannel;
            result = 31 * result + this.headDate;
            result = 31 * result + this.headLevel;
            result = 31 * result + this.headTime;
            result = 31 * result + this.headType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SplitKey other = (SplitKey)obj;
            if (this.headChannel != other.headChannel) {
                return false;
            }
            if (this.headDate != other.headDate) {
                return false;
            }
            if (this.headLevel != other.headLevel) {
                return false;
            }
            if (this.headTime != other.headTime) {
                return false;
            }
            return this.headType == other.headType;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SplitKey [headType=");
            builder.append(this.headType);
            builder.append(", headChannel=");
            builder.append(this.headChannel);
            builder.append(", headTime=");
            builder.append(this.headTime);
            builder.append(", headDate=");
            builder.append(this.headDate);
            builder.append(", headLevel=");
            builder.append(this.headLevel);
            builder.append("]");
            return builder.toString();
        }
    }
}

