/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionC0;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class KefaChannelDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
CarparkLoudspeakerAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private static ConcurrentHashMap<String, Properties> synConMap = new ConcurrentHashMap();
    private ScheduledFuture<?> shedule;
    private volatile boolean checkSeriaSetingok = false;
    private volatile long lastestSyncTimeMills;
    private volatile long receiveheardbeatTimemills;
    private Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    private Object displayLock = new Object();
    private AtomicBoolean checkingConfig = new AtomicBoolean(false);
    protected volatile byte currentVolumeValue = (byte)-1;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;
    private volatile long displayingQrCodeMills;
    private ReceiveDataHandler<Integer> notStrictReceiveHandler;
    private static int[] _CRCHi;
    private static int[] _CRCLo;

    static {
        int[] nArray = new int[256];
        nArray[1] = 193;
        nArray[2] = 129;
        nArray[3] = 64;
        nArray[4] = 1;
        nArray[5] = 192;
        nArray[6] = 128;
        nArray[7] = 65;
        nArray[8] = 1;
        nArray[9] = 192;
        nArray[10] = 128;
        nArray[11] = 65;
        nArray[13] = 193;
        nArray[14] = 129;
        nArray[15] = 64;
        nArray[16] = 1;
        nArray[17] = 192;
        nArray[18] = 128;
        nArray[19] = 65;
        nArray[21] = 193;
        nArray[22] = 129;
        nArray[23] = 64;
        nArray[25] = 193;
        nArray[26] = 129;
        nArray[27] = 64;
        nArray[28] = 1;
        nArray[29] = 192;
        nArray[30] = 128;
        nArray[31] = 65;
        nArray[32] = 1;
        nArray[33] = 192;
        nArray[34] = 128;
        nArray[35] = 65;
        nArray[37] = 193;
        nArray[38] = 129;
        nArray[39] = 64;
        nArray[41] = 193;
        nArray[42] = 129;
        nArray[43] = 64;
        nArray[44] = 1;
        nArray[45] = 192;
        nArray[46] = 128;
        nArray[47] = 65;
        nArray[49] = 193;
        nArray[50] = 129;
        nArray[51] = 64;
        nArray[52] = 1;
        nArray[53] = 192;
        nArray[54] = 128;
        nArray[55] = 65;
        nArray[56] = 1;
        nArray[57] = 192;
        nArray[58] = 128;
        nArray[59] = 65;
        nArray[61] = 193;
        nArray[62] = 129;
        nArray[63] = 64;
        nArray[64] = 1;
        nArray[65] = 192;
        nArray[66] = 128;
        nArray[67] = 65;
        nArray[69] = 193;
        nArray[70] = 129;
        nArray[71] = 64;
        nArray[73] = 193;
        nArray[74] = 129;
        nArray[75] = 64;
        nArray[76] = 1;
        nArray[77] = 192;
        nArray[78] = 128;
        nArray[79] = 65;
        nArray[81] = 193;
        nArray[82] = 129;
        nArray[83] = 64;
        nArray[84] = 1;
        nArray[85] = 192;
        nArray[86] = 128;
        nArray[87] = 65;
        nArray[88] = 1;
        nArray[89] = 192;
        nArray[90] = 128;
        nArray[91] = 65;
        nArray[93] = 193;
        nArray[94] = 129;
        nArray[95] = 64;
        nArray[97] = 193;
        nArray[98] = 129;
        nArray[99] = 64;
        nArray[100] = 1;
        nArray[101] = 192;
        nArray[102] = 128;
        nArray[103] = 65;
        nArray[104] = 1;
        nArray[105] = 192;
        nArray[106] = 128;
        nArray[107] = 65;
        nArray[109] = 193;
        nArray[110] = 129;
        nArray[111] = 64;
        nArray[112] = 1;
        nArray[113] = 192;
        nArray[114] = 128;
        nArray[115] = 65;
        nArray[117] = 193;
        nArray[118] = 129;
        nArray[119] = 64;
        nArray[121] = 193;
        nArray[122] = 129;
        nArray[123] = 64;
        nArray[124] = 1;
        nArray[125] = 192;
        nArray[126] = 128;
        nArray[127] = 65;
        nArray[128] = 1;
        nArray[129] = 192;
        nArray[130] = 128;
        nArray[131] = 65;
        nArray[133] = 193;
        nArray[134] = 129;
        nArray[135] = 64;
        nArray[137] = 193;
        nArray[138] = 129;
        nArray[139] = 64;
        nArray[140] = 1;
        nArray[141] = 192;
        nArray[142] = 128;
        nArray[143] = 65;
        nArray[145] = 193;
        nArray[146] = 129;
        nArray[147] = 64;
        nArray[148] = 1;
        nArray[149] = 192;
        nArray[150] = 128;
        nArray[151] = 65;
        nArray[152] = 1;
        nArray[153] = 192;
        nArray[154] = 128;
        nArray[155] = 65;
        nArray[157] = 193;
        nArray[158] = 129;
        nArray[159] = 64;
        nArray[161] = 193;
        nArray[162] = 129;
        nArray[163] = 64;
        nArray[164] = 1;
        nArray[165] = 192;
        nArray[166] = 128;
        nArray[167] = 65;
        nArray[168] = 1;
        nArray[169] = 192;
        nArray[170] = 128;
        nArray[171] = 65;
        nArray[173] = 193;
        nArray[174] = 129;
        nArray[175] = 64;
        nArray[176] = 1;
        nArray[177] = 192;
        nArray[178] = 128;
        nArray[179] = 65;
        nArray[181] = 193;
        nArray[182] = 129;
        nArray[183] = 64;
        nArray[185] = 193;
        nArray[186] = 129;
        nArray[187] = 64;
        nArray[188] = 1;
        nArray[189] = 192;
        nArray[190] = 128;
        nArray[191] = 65;
        nArray[193] = 193;
        nArray[194] = 129;
        nArray[195] = 64;
        nArray[196] = 1;
        nArray[197] = 192;
        nArray[198] = 128;
        nArray[199] = 65;
        nArray[200] = 1;
        nArray[201] = 192;
        nArray[202] = 128;
        nArray[203] = 65;
        nArray[205] = 193;
        nArray[206] = 129;
        nArray[207] = 64;
        nArray[208] = 1;
        nArray[209] = 192;
        nArray[210] = 128;
        nArray[211] = 65;
        nArray[213] = 193;
        nArray[214] = 129;
        nArray[215] = 64;
        nArray[217] = 193;
        nArray[218] = 129;
        nArray[219] = 64;
        nArray[220] = 1;
        nArray[221] = 192;
        nArray[222] = 128;
        nArray[223] = 65;
        nArray[224] = 1;
        nArray[225] = 192;
        nArray[226] = 128;
        nArray[227] = 65;
        nArray[229] = 193;
        nArray[230] = 129;
        nArray[231] = 64;
        nArray[233] = 193;
        nArray[234] = 129;
        nArray[235] = 64;
        nArray[236] = 1;
        nArray[237] = 192;
        nArray[238] = 128;
        nArray[239] = 65;
        nArray[241] = 193;
        nArray[242] = 129;
        nArray[243] = 64;
        nArray[244] = 1;
        nArray[245] = 192;
        nArray[246] = 128;
        nArray[247] = 65;
        nArray[248] = 1;
        nArray[249] = 192;
        nArray[250] = 128;
        nArray[251] = 65;
        nArray[253] = 193;
        nArray[254] = 129;
        nArray[255] = 64;
        _CRCHi = nArray;
        int[] nArray2 = new int[256];
        nArray2[1] = 192;
        nArray2[2] = 193;
        nArray2[3] = 1;
        nArray2[4] = 195;
        nArray2[5] = 3;
        nArray2[6] = 2;
        nArray2[7] = 194;
        nArray2[8] = 198;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 199;
        nArray2[12] = 5;
        nArray2[13] = 197;
        nArray2[14] = 196;
        nArray2[15] = 4;
        nArray2[16] = 204;
        nArray2[17] = 12;
        nArray2[18] = 13;
        nArray2[19] = 205;
        nArray2[20] = 15;
        nArray2[21] = 207;
        nArray2[22] = 206;
        nArray2[23] = 14;
        nArray2[24] = 10;
        nArray2[25] = 202;
        nArray2[26] = 203;
        nArray2[27] = 11;
        nArray2[28] = 201;
        nArray2[29] = 9;
        nArray2[30] = 8;
        nArray2[31] = 200;
        nArray2[32] = 216;
        nArray2[33] = 24;
        nArray2[34] = 25;
        nArray2[35] = 217;
        nArray2[36] = 27;
        nArray2[37] = 219;
        nArray2[38] = 218;
        nArray2[39] = 26;
        nArray2[40] = 30;
        nArray2[41] = 222;
        nArray2[42] = 223;
        nArray2[43] = 31;
        nArray2[44] = 221;
        nArray2[45] = 29;
        nArray2[46] = 28;
        nArray2[47] = 220;
        nArray2[48] = 20;
        nArray2[49] = 212;
        nArray2[50] = 213;
        nArray2[51] = 21;
        nArray2[52] = 215;
        nArray2[53] = 23;
        nArray2[54] = 22;
        nArray2[55] = 214;
        nArray2[56] = 210;
        nArray2[57] = 18;
        nArray2[58] = 19;
        nArray2[59] = 211;
        nArray2[60] = 17;
        nArray2[61] = 209;
        nArray2[62] = 208;
        nArray2[63] = 16;
        nArray2[64] = 240;
        nArray2[65] = 48;
        nArray2[66] = 49;
        nArray2[67] = 241;
        nArray2[68] = 51;
        nArray2[69] = 243;
        nArray2[70] = 242;
        nArray2[71] = 50;
        nArray2[72] = 54;
        nArray2[73] = 246;
        nArray2[74] = 247;
        nArray2[75] = 55;
        nArray2[76] = 245;
        nArray2[77] = 53;
        nArray2[78] = 52;
        nArray2[79] = 244;
        nArray2[80] = 60;
        nArray2[81] = 252;
        nArray2[82] = 253;
        nArray2[83] = 61;
        nArray2[84] = 255;
        nArray2[85] = 63;
        nArray2[86] = 62;
        nArray2[87] = 254;
        nArray2[88] = 250;
        nArray2[89] = 58;
        nArray2[90] = 59;
        nArray2[91] = 251;
        nArray2[92] = 57;
        nArray2[93] = 249;
        nArray2[94] = 248;
        nArray2[95] = 56;
        nArray2[96] = 40;
        nArray2[97] = 232;
        nArray2[98] = 233;
        nArray2[99] = 41;
        nArray2[100] = 235;
        nArray2[101] = 43;
        nArray2[102] = 42;
        nArray2[103] = 234;
        nArray2[104] = 238;
        nArray2[105] = 46;
        nArray2[106] = 47;
        nArray2[107] = 239;
        nArray2[108] = 45;
        nArray2[109] = 237;
        nArray2[110] = 236;
        nArray2[111] = 44;
        nArray2[112] = 228;
        nArray2[113] = 36;
        nArray2[114] = 37;
        nArray2[115] = 229;
        nArray2[116] = 39;
        nArray2[117] = 231;
        nArray2[118] = 230;
        nArray2[119] = 38;
        nArray2[120] = 34;
        nArray2[121] = 226;
        nArray2[122] = 227;
        nArray2[123] = 35;
        nArray2[124] = 225;
        nArray2[125] = 33;
        nArray2[126] = 32;
        nArray2[127] = 224;
        nArray2[128] = 160;
        nArray2[129] = 96;
        nArray2[130] = 97;
        nArray2[131] = 161;
        nArray2[132] = 99;
        nArray2[133] = 163;
        nArray2[134] = 162;
        nArray2[135] = 98;
        nArray2[136] = 102;
        nArray2[137] = 166;
        nArray2[138] = 167;
        nArray2[139] = 103;
        nArray2[140] = 165;
        nArray2[141] = 101;
        nArray2[142] = 100;
        nArray2[143] = 164;
        nArray2[144] = 108;
        nArray2[145] = 172;
        nArray2[146] = 173;
        nArray2[147] = 109;
        nArray2[148] = 175;
        nArray2[149] = 111;
        nArray2[150] = 110;
        nArray2[151] = 174;
        nArray2[152] = 170;
        nArray2[153] = 106;
        nArray2[154] = 107;
        nArray2[155] = 171;
        nArray2[156] = 105;
        nArray2[157] = 169;
        nArray2[158] = 168;
        nArray2[159] = 104;
        nArray2[160] = 120;
        nArray2[161] = 184;
        nArray2[162] = 185;
        nArray2[163] = 121;
        nArray2[164] = 187;
        nArray2[165] = 123;
        nArray2[166] = 122;
        nArray2[167] = 186;
        nArray2[168] = 190;
        nArray2[169] = 126;
        nArray2[170] = 127;
        nArray2[171] = 191;
        nArray2[172] = 125;
        nArray2[173] = 189;
        nArray2[174] = 188;
        nArray2[175] = 124;
        nArray2[176] = 180;
        nArray2[177] = 116;
        nArray2[178] = 117;
        nArray2[179] = 181;
        nArray2[180] = 119;
        nArray2[181] = 183;
        nArray2[182] = 182;
        nArray2[183] = 118;
        nArray2[184] = 114;
        nArray2[185] = 178;
        nArray2[186] = 179;
        nArray2[187] = 115;
        nArray2[188] = 177;
        nArray2[189] = 113;
        nArray2[190] = 112;
        nArray2[191] = 176;
        nArray2[192] = 80;
        nArray2[193] = 144;
        nArray2[194] = 145;
        nArray2[195] = 81;
        nArray2[196] = 147;
        nArray2[197] = 83;
        nArray2[198] = 82;
        nArray2[199] = 146;
        nArray2[200] = 150;
        nArray2[201] = 86;
        nArray2[202] = 87;
        nArray2[203] = 151;
        nArray2[204] = 85;
        nArray2[205] = 149;
        nArray2[206] = 148;
        nArray2[207] = 84;
        nArray2[208] = 156;
        nArray2[209] = 92;
        nArray2[210] = 93;
        nArray2[211] = 157;
        nArray2[212] = 95;
        nArray2[213] = 159;
        nArray2[214] = 158;
        nArray2[215] = 94;
        nArray2[216] = 90;
        nArray2[217] = 154;
        nArray2[218] = 155;
        nArray2[219] = 91;
        nArray2[220] = 153;
        nArray2[221] = 89;
        nArray2[222] = 88;
        nArray2[223] = 152;
        nArray2[224] = 136;
        nArray2[225] = 72;
        nArray2[226] = 73;
        nArray2[227] = 137;
        nArray2[228] = 75;
        nArray2[229] = 139;
        nArray2[230] = 138;
        nArray2[231] = 74;
        nArray2[232] = 78;
        nArray2[233] = 142;
        nArray2[234] = 143;
        nArray2[235] = 79;
        nArray2[236] = 141;
        nArray2[237] = 77;
        nArray2[238] = 76;
        nArray2[239] = 140;
        nArray2[240] = 68;
        nArray2[241] = 132;
        nArray2[242] = 133;
        nArray2[243] = 69;
        nArray2[244] = 135;
        nArray2[245] = 71;
        nArray2[246] = 70;
        nArray2[247] = 134;
        nArray2[248] = 130;
        nArray2[249] = 66;
        nArray2[250] = 67;
        nArray2[251] = 131;
        nArray2[252] = 65;
        nArray2[253] = 129;
        nArray2[254] = 128;
        nArray2[255] = 64;
        _CRCLo = nArray2;
    }

    public KefaChannelDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    KefaChannelDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + KefaChannelDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 5000L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    private byte getAddress() {
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue("RS485_ADDR");
        if (x == null) {
            return 0;
        }
        return x.byteValue();
    }

    private void connectIfNotConnected1() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            this.lastestSyncTimeMills = 0L;
            return;
        }
        if (!this.checkSeriaSetingok) {
            Integer baudRate;
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            if ((baudRate = config.getConfigIntValue("baudRate")) == null) {
                baudRate = 19200;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", baudRate);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        boolean sendHeatBeat = true;
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer dataResponseCheck = config.getConfigIntValue("dataResponseCheck");
        if (dataResponseCheck == null) {
            dataResponseCheck = 2;
        }
        if (dataResponseCheck != null && dataResponseCheck == 2) {
            sendHeatBeat = false;
        }
        if (sendHeatBeat) {
            OperationFuture<Integer> result = this.sendOpData(action, (byte)0, new byte[6]);
            if (!this.isWorkingProperly()) {
                try {
                    Integer t = (Integer)result.get(3L, TimeUnit.SECONDS);
                    if (t == null) {
                        result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                                ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u5bf9\u65b9\u65e0\u5e94\u7b54"));
                            }

                            public void operationComplete(OperationFuture<Integer> f) {
                                if (f.isDone()) {
                                    if (f.getException() != null) {
                                        ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u539f\u56e0:" + f.getException().getMessage()));
                                    } else {
                                        Integer a = (Integer)f.getResult();
                                        if (a == null) {
                                            ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u9519\u8bef:\u8d85\u65f6"));
                                        } else if (a != 0) {
                                            ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u9519\u8bef\u4ee3\u7801:" + a));
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u539f\u56e0:" + e.getMessage()));
                }
            }
        }
        if (this.isWorkingProperly()) {
            ApplicationService applicationService;
            Volume volume;
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.lastestSyncTimeMills == 0L || currentMills - this.lastestSyncTimeMills > TimeUnit.HOURS.toMillis(4L)) {
                OperationFuture<Integer> result = this.sendOpData(action, (byte)5, KefaChannelDisplayAction.getSynTimeSendData(null));
                result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                        ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u540c\u6b65\u65f6\u95f4\u8d85\u65f6!\u5bf9\u65b9\u65e0\u5e94\u7b54"));
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.isDone()) {
                            if (f.getException() != null) {
                                ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u540c\u6b65\u65f6\u95f4\u5931\u8d25!\u539f\u56e0:" + f.getException().getMessage()));
                            } else {
                                Integer a = (Integer)f.getResult();
                                if (a == null) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u540c\u6b65\u65f6\u95f4\u5931\u8d25!\u9519\u8bef:\u8d85\u65f6"));
                                } else if (a != 0) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(KefaChannelDisplayAction.this.equipment.getName()) + "\u540c\u6b65\u65f6\u95f4\u5931\u8d25!\u9519\u8bef\u4ee3\u7801:" + a));
                                }
                            }
                        }
                    }
                });
                this.lastestSyncTimeMills = currentMills;
            }
            if ((volume = (applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getVolume(this.equipment)) != null) {
                byte v = this.getVolumeValue(volume);
                if (this.currentVolumeValue == -1) {
                    this.currentVolumeValue = v;
                } else if (v != this.currentVolumeValue) {
                    try {
                        Integer t = (Integer)this.setVolume0(action, v).get(4L, TimeUnit.SECONDS);
                        if (t == null || t != 0) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5931\u8d25!"));
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)(String.valueOf(this.equipment.getName()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5f02\u5e38!" + ex.getMessage()));
                    }
                }
            }
            this.checkAdConfig();
        } else {
            this.lastestSyncTimeMills = 0L;
        }
    }

    private OperationFuture<Integer> sendOpData(CameraUartAction action, byte cmd, byte[] data) {
        byte[] heartBitdata = KefaChannelDisplayAction.toSendBytes(this.getAddress(), cmd, data);
        ReceiveDataHandler<Integer> handler = this.createReceiveHandler(cmd);
        OperationFuture<Integer> resultHandler = handler == null ? action.sendNoResponseRS485Data(this.getUatIndex(), heartBitdata, 250L) : action.sendHaveResponseRS485Data(this.getUatIndex(), heartBitdata, handler);
        return resultHandler;
    }

    private ReceiveDataHandler<Integer> createNotStrictReceiveHandler() {
        if (this.notStrictReceiveHandler == null) {
            this.notStrictReceiveHandler = new ReceiveDataHandler<Integer>(){
                int result = -1;

                @Override
                public boolean handleData(byte[] data, int offset, int len) {
                    KefaChannelDisplayAction.this.receiveheardbeatTimemills = ServiceUtil.getServiceContext().currentTimeMillis();
                    this.result = 0;
                    return true;
                }

                @Override
                public Integer getResponseResult() {
                    return this.result;
                }
            };
        }
        return this.notStrictReceiveHandler;
    }

    protected ReceiveDataHandler<Integer> createReceiveHandler(byte cmd) {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer dataResponseCheck = config.getConfigIntValue("dataResponseCheck");
        if (dataResponseCheck == null) {
            dataResponseCheck = 2;
        }
        if (dataResponseCheck == 0) {
            return this.createNotStrictReceiveHandler();
        }
        if (dataResponseCheck == 1) {
            return new StrictACKReceiveHandler(cmd, this);
        }
        return null;
    }

    private int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.displayTempText(action, 100, config.screenIndex, String.valueOf(config.spacefix) + v, true);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        if (!action.isWorkingProperly()) {
            return false;
        }
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer dataResponseCheck = config.getConfigIntValue("dataResponseCheck");
        if (dataResponseCheck != null && dataResponseCheck == 2) {
            return true;
        }
        long timeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        return timeMills - this.receiveheardbeatTimemills < 11000L;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        DynLoudspeakerAction a = this.getDynLoudspeakerAction();
        if (a != null) {
            return null;
        }
        return this;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        boolean isSuportDyn = Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("voice_type"));
        if (isSuportDyn) {
            return this;
        }
        return null;
    }

    protected byte getVolumeValue(Volume volume) {
        if (volume == null) {
            return 50;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        if (night) {
            int x = Math.round((float)volume.getNightVolume() / 10.0f);
            return (byte)(x * 10);
        }
        int x = Math.round((float)volume.getDayVolume() / 10.0f);
        return (byte)(x * 10);
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte v = this.getVolumeValue(volume);
        OperationFuture<Integer> f = this.setVolume0(action, v);
        return f;
    }

    protected OperationFuture<Integer> setVolume0(CameraUartAction action, final byte volumeValue) {
        if (volumeValue == 0) {
            OperationFutureHandler f1 = ServiceUtil.getServiceContext().createOperationFuture();
            f1.setResult((Object)0);
            this.currentVolumeValue = volumeValue;
            return f1;
        }
        OperationFuture<Integer> f1 = this.sendOpData(action, (byte)13, new byte[]{volumeValue});
        f1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> da) {
                if (da.getException() == null && da.getResult() != null && (Integer)da.getResult() == 0) {
                    KefaChannelDisplayAction.this.currentVolumeValue = volumeValue;
                }
            }
        });
        return f1;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        if (changedProperties != null && changedProperties.containsKey("baudRate")) {
            this.checkSeriaSetingok = false;
        }
        this.checkAdConfig();
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        byte v;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        Volume volume = applicationService.getVolume(this.equipment);
        if (volume != null && (v = this.getVolumeValue(volume)) == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        byte[] bx = new byte[codes.length + 1];
        bx[0] = 1;
        System.arraycopy(codes, 0, bx, 1, codes.length);
        return this.sendOpData(action, (byte)48, bx);
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public boolean isSupportTrafficLights() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("trafficLights");
        return v != null && "1".equals(v);
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        if (sec < 1) {
            sec = 1;
        } else if (sec > 255) {
            sec = 255;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] bx = new byte[6];
        bx[bx.length - 1] = (byte)sec;
        return this.sendOpData(action, (byte)15, bx);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        return this.displayTempText(action, displayTimes, position, text, false);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationFuture<Integer> displayTempText(CameraUartAction action, int displayTimes, int position, String text, boolean spaceInfo) {
        Object object = this.displayLock;
        synchronized (object) {
            try {
                byte[] textBytes;
                byte[] dcolor;
                Integer displayAc;
                Integer textwait;
                Integer ecSpeed;
                String displayColor;
                if (displayTimes < 1) {
                    displayTimes = 1;
                } else if (displayTimes > 255) {
                    displayTimes = 255;
                }
                if (!spaceInfo) {
                    this.dispLayInfoTimeTable.put(position, ServiceUtil.getServiceContext().currentTimeMillis() + (long)((displayTimes + 1) * 1000));
                } else if (this.equipment.getUse() == 1) {
                    Long x = this.dispLayInfoTimeTable.get(position);
                    long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    if (x != null && currentMills < x) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                    if (this.displayingQrCodeMills > 0L && currentMills < this.displayingQrCodeMills) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                }
                if (this.displayingQrCodeMills > 0L) {
                    if (this.getProtocolVersion() == 2) {
                        this.sendOpData(action, (byte)-124, this.getQrCodeVersion2Bytes(" ", true));
                    }
                    if (position == 1 || position == 2) {
                        this.displayingQrCodeMills = 0L;
                    }
                }
                if (text == null) {
                    text = "";
                }
                EquipmentConfig config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() == 1) {
                    displayColor = config.getConfigValue("display_position_" + position + "_color");
                    ecSpeed = config.getConfigIntValue("display_position_" + position + "_exspeed");
                    textwait = config.getConfigIntValue("display_position_" + position + "_textwait");
                    displayAc = config.getConfigIntValue("display_position_" + position + "_action");
                } else {
                    displayColor = config.getConfigValue("display_position_" + position + "_color1");
                    ecSpeed = config.getConfigIntValue("display_position_" + position + "_exspeed1");
                    textwait = config.getConfigIntValue("display_position_" + position + "_textwait1");
                    displayAc = config.getConfigIntValue("display_position_" + position + "_action1");
                }
                try {
                    if (displayColor == null || displayColor.length() == 0) {
                        byte[] byArray = new byte[3];
                        byArray[0] = -1;
                        dcolor = byArray;
                    } else {
                        dcolor = BytesTool.hexStringToByteArray((String)displayColor);
                        if (dcolor.length != 3) {
                            byte[] byArray = new byte[3];
                            byArray[0] = -1;
                            dcolor = byArray;
                        }
                    }
                }
                catch (Exception ex) {
                    byte[] byArray = new byte[3];
                    byArray[0] = -1;
                    dcolor = byArray;
                }
                if (ecSpeed == null || ecSpeed < 1 || ecSpeed > 32) {
                    ecSpeed = 1;
                }
                if (textwait == null || textwait < 0 || textwait > 255) {
                    textwait = 2;
                }
                if (displayAc == null) {
                    displayAc = 21;
                }
                if ((textBytes = ServiceUtil.getString(text, 228, "GB2312").getBytes("GB2312")).length <= 8) {
                    displayAc = 0;
                }
                byte[] databytes = new byte[textBytes.length + 19];
                int index = 0;
                byte TWID = (byte)(position - 1);
                if (TWID < 0) {
                    TWID = 0;
                }
                databytes[index++] = TWID;
                databytes[index++] = displayAc.byteValue();
                databytes[index++] = ecSpeed.byteValue();
                databytes[index++] = 0;
                databytes[index++] = textwait.byteValue();
                databytes[index++] = displayAc.byteValue();
                databytes[index++] = ecSpeed.byteValue();
                databytes[index++] = 3;
                databytes[index++] = (byte)displayTimes;
                databytes[index++] = dcolor[0];
                databytes[index++] = dcolor[1];
                databytes[index++] = dcolor[2];
                databytes[index++] = 0;
                databytes[index++] = 0;
                databytes[index++] = 0;
                databytes[index++] = 0;
                databytes[index++] = 0;
                databytes[index++] = (byte)textBytes.length;
                databytes[index++] = (byte)(textBytes.length >> 8);
                if (textBytes.length > 0) {
                    System.arraycopy(textBytes, 0, databytes, index, textBytes.length);
                    index += textBytes.length;
                }
                return this.sendOpData(action, (byte)98, databytes);
            }
            catch (Throwable ex) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException(ex);
                return h;
            }
        }
    }

    protected byte[] getAdData(EquipmentConfig config, int position, String text) {
        try {
            byte[] dcolor;
            Integer displayAc;
            Integer textwait;
            Integer ecSpeed;
            String displayColor;
            if (text == null) {
                text = "";
            }
            if (this.equipment.getUse() == 1) {
                displayColor = config.getConfigValue("display_position_" + position + "_color");
                ecSpeed = config.getConfigIntValue("display_position_" + position + "_exspeed");
                textwait = config.getConfigIntValue("display_position_" + position + "_textwait");
                displayAc = config.getConfigIntValue("display_position_" + position + "_action");
            } else {
                displayColor = config.getConfigValue("display_position_" + position + "_color1");
                ecSpeed = config.getConfigIntValue("display_position_" + position + "_exspeed1");
                textwait = config.getConfigIntValue("display_position_" + position + "_textwait1");
                displayAc = config.getConfigIntValue("display_position_" + position + "_action1");
            }
            try {
                if (displayColor == null || displayColor.length() == 0) {
                    byte[] byArray = new byte[3];
                    byArray[0] = -1;
                    dcolor = byArray;
                } else {
                    dcolor = BytesTool.hexStringToByteArray((String)displayColor);
                    if (dcolor.length != 3) {
                        byte[] byArray = new byte[3];
                        byArray[0] = -1;
                        dcolor = byArray;
                    }
                }
            }
            catch (Exception ex) {
                byte[] byArray = new byte[3];
                byArray[0] = -1;
                dcolor = byArray;
            }
            if (ecSpeed == null || ecSpeed < 1 || ecSpeed > 32) {
                ecSpeed = 1;
            }
            if (textwait == null || textwait < 0 || textwait > 255) {
                textwait = 2;
            }
            if (displayAc == null) {
                displayAc = 21;
            }
            byte[] textBytes = ServiceUtil.getString(text, 228, "GB2312").getBytes("GB2312");
            byte[] databytes = new byte[textBytes.length + 20];
            int index = 0;
            byte TWID = (byte)(position - 1);
            if (TWID < 0) {
                TWID = 0;
            }
            databytes[index++] = TWID;
            databytes[index++] = 0;
            databytes[index++] = 12;
            databytes[index++] = displayAc.byteValue();
            databytes[index++] = ecSpeed.byteValue();
            databytes[index++] = 0;
            databytes[index++] = textwait.byteValue();
            databytes[index++] = displayAc.byteValue();
            databytes[index++] = ecSpeed.byteValue();
            databytes[index++] = 3;
            databytes[index++] = dcolor[0];
            databytes[index++] = dcolor[1];
            databytes[index++] = dcolor[2];
            databytes[index++] = 0;
            databytes[index++] = 0;
            databytes[index++] = 0;
            databytes[index++] = 0;
            databytes[index++] = 0;
            databytes[index++] = (byte)textBytes.length;
            databytes[index++] = (byte)(textBytes.length >> 8);
            if (textBytes.length > 0) {
                System.arraycopy(textBytes, 0, databytes, index, textBytes.length);
                index += textBytes.length;
            }
            return databytes;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    protected OperationFuture<Integer> setAd(CameraUartAction action, int position, String text) {
        try {
            byte[] databytes = this.getAdData(this.equipment.getEquipmentConfig(), position, text);
            return this.sendOpData(action, (byte)103, databytes);
        }
        catch (Throwable ex) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException(ex);
            return h;
        }
    }

    public OperationFuture<Integer> displayAd(int position) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte TWID = (byte)(position - 1);
        if (TWID < 0) {
            TWID = 0;
        }
        byte[] byArray = new byte[2];
        byArray[0] = TWID;
        return this.sendOpData(action, (byte)104, byArray);
    }

    private Properties getAdConfig() {
        Properties p = new Properties();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        int i = 1;
        while (i <= display_count) {
            String showTypeKey = this.equipment.getUse() == 1 ? "display_position_" + i + "_free_type" : "display_position_" + i + "_type";
            Integer showType = config.getConfigIntValue(showTypeKey);
            if (showType == null) {
                showType = this.equipment.getUse() == 1 ? Integer.valueOf(1) : Integer.valueOf(2);
            }
            if (showType == 0 || showType == 1) {
                String text = this.equipment.getUse() == 1 ? config.getConfigValue("display_position_" + i + "_free_type" + showType) : config.getConfigValue("display_position_" + i + "_type" + showType);
                if (text == null || text.length() == 0) {
                    text = "\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf";
                }
                byte[] databytes = this.getAdData(config, i, text);
                String content = BytesTool.byteArrayToHexString((byte[])databytes);
                p.setProperty("x0" + i, content);
            }
            ++i;
        }
        return p;
    }

    private Map<String, String> getAdChangeConfig(Properties curentP, Properties cacheP) {
        if (curentP == null) {
            return null;
        }
        int display_count = this.getDisplayCount();
        LinkedHashMap<String, String> needSetMap = null;
        int i = 1;
        while (i <= display_count) {
            String s;
            String key = "x0" + i;
            String c = curentP.getProperty(key);
            if (c != null && c.length() != 0 && !c.equals(s = cacheP == null ? null : cacheP.getProperty(key))) {
                if (needSetMap == null) {
                    needSetMap = new LinkedHashMap<String, String>();
                }
                needSetMap.put(key, c);
            }
            ++i;
        }
        return needSetMap;
    }

    private void checkAdConfig() {
        if (!this.isWorkingProperly()) {
            return;
        }
        if (this.checkingConfig.compareAndSet(false, true)) {
            try {
                Map<String, String> changeADMap;
                Properties curentP = this.getAdConfig();
                Properties synP = synConMap.get(this.equipment.getEquipmentNo());
                if (synP == null) {
                    synConMap.putIfAbsent(this.equipment.getEquipmentNo(), new Properties());
                    synP = synConMap.get(this.equipment.getEquipmentNo());
                }
                if ((changeADMap = this.getAdChangeConfig(curentP, synP)) != null && !changeADMap.isEmpty()) {
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    KefaChannelDisplayAction.this.doSynAdConfig(changeADMap);
                                }
                                catch (Throwable ex) {
                                    ServiceLog.getLog().warn((Object)"\u540c\u6b65\u914d\u7f6e\u5f02\u5e38", ex);
                                    KefaChannelDisplayAction.this.checkingConfig.set(false);
                                }
                            }
                            finally {
                                KefaChannelDisplayAction.this.checkingConfig.set(false);
                            }
                        }
                    });
                } else {
                    this.checkingConfig.set(false);
                }
            }
            catch (Throwable ex) {
                this.checkingConfig.set(false);
                ServiceLog.getLog().warn((Object)("\u68c0\u67e5\u914d\u7f6e\u5f02\u5e38:" + ex.getMessage()));
            }
        }
    }

    private void doSynAdConfig(Map<String, String> adconfig) throws Throwable {
        if (adconfig == null || adconfig.isEmpty()) {
            return;
        }
        Properties synP = synConMap.get(this.equipment.getEquipmentNo());
        if (synP == null) {
            return;
        }
        if (!this.isWorkingProperly()) {
            return;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            return;
        }
        block9: for (Map.Entry<String, String> av1 : adconfig.entrySet()) {
            try {
                int i = 0;
                while (i < 2) {
                    try {
                        byte[] sendAdData = BytesTool.hexStringToByteArray((String)av1.getValue());
                        Integer v1 = (Integer)this.sendOpData(action, (byte)103, sendAdData).get(5L, TimeUnit.SECONDS);
                        if (v1 != null && v1 == 0) {
                            try {
                                this.displayAd(Integer.parseInt(av1.getKey().substring(2))).get(5L, TimeUnit.SECONDS);
                            }
                            catch (Exception exception) {}
                            continue block9;
                        }
                        if (v1 == null) {
                            throw new Exception("\u64cd\u4f5c\u8d85\u65f6");
                        }
                        throw new Exception("\u9519\u8bef\u4ee3\u7801:" + v1);
                    }
                    catch (Throwable ex) {
                        try {
                            String msg = "\u8bbe\u7f6e\u7b2c:" + av1.getKey().substring(1) + "\u884c\u663e\u793a\u5c4f\u5e7f\u544a\u5931\u8d25\uff01\u539f\u56e0:" + ex.getMessage();
                            if (i == 0) {
                                msg = String.valueOf(msg) + ",\u8fd9\u5c06\u91cd\u65b0\u5c1d\u8bd51\u6b21";
                            }
                            ServiceLog.getLog().warn((Object)msg);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
            finally {
                synP.setProperty(av1.getKey(), av1.getValue());
            }
        }
    }

    public static int mbCRC16(byte[] data, int offset, int length) {
        int FF;
        int CRCHi = FF = 255;
        int CRCLo = FF;
        int end = offset + length;
        int i = offset;
        while (i < end) {
            int index = (CRCLo ^ data[i]) & FF;
            CRCLo = (CRCHi ^ _CRCHi[index]) & FF;
            CRCHi = _CRCLo[index] & FF;
            ++i;
        }
        return CRCHi << 8 | CRCLo;
    }

    public static byte[] toSendBytes(byte address, byte cmd, byte[] data) {
        int dataLen;
        int n = dataLen = data == null ? 0 : data.length;
        if (dataLen > 255) {
            dataLen = 255;
        }
        int len = 8 + dataLen;
        byte[] reb = new byte[len];
        int index = 0;
        reb[index++] = address;
        reb[index++] = 100;
        reb[index++] = -1;
        reb[index++] = -1;
        reb[index++] = cmd;
        reb[index++] = (byte)dataLen;
        if (dataLen > 0) {
            System.arraycopy(data, 0, reb, index, dataLen);
            index += dataLen;
        }
        int crc = KefaChannelDisplayAction.mbCRC16(reb, 0, index);
        reb[index++] = (byte)crc;
        reb[index++] = (byte)(crc >> 8);
        return reb;
    }

    public static byte[] getSynTimeSendData(Date date) {
        Calendar cl = Calendar.getInstance();
        if (date != null) {
            cl.setTime(date);
        }
        int year = cl.get(1);
        int month = cl.get(2) + 1;
        int day = cl.get(5);
        int week = cl.get(7);
        int hour = cl.get(11);
        int min = cl.get(12);
        int sec = cl.get(13);
        byte[] data = new byte[8];
        int index = 0;
        data[index++] = (byte)year;
        data[index++] = (byte)(year >> 8);
        data[index++] = (byte)month;
        data[index++] = (byte)day;
        data[index++] = (byte)week;
        data[index++] = (byte)hour;
        data[index++] = (byte)min;
        data[index++] = (byte)sec;
        return data;
    }

    public int getProtocolVersion() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer ax = config.getConfigIntValue("protocol_version");
        if (ax == null) {
            return 1;
        }
        return ax;
    }

    private byte[] getQRCodeRGB() {
        try {
            byte[] ax;
            String v = this.equipment.getEquipmentConfig().getConfigValue("display_qrcode_color");
            if (v != null && v.length() == 6 && (ax = BytesTool.hexStringToByteArray((String)v)).length == 3) {
                return ax;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        return byArray;
    }

    private byte[] getQrCodeVersion1Bytes(int playTimes, String qrContent, String lineMsg) {
        byte[] lineMsgBytes;
        byte[] qrContentBytes;
        if (qrContent != null && qrContent.length() > 0) {
            try {
                qrContentBytes = qrContent.getBytes("GBK");
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    qrContentBytes = qrContent.getBytes("GB2312");
                }
                catch (UnsupportedEncodingException ex1) {
                    qrContentBytes = qrContent.getBytes();
                }
            }
        } else {
            qrContentBytes = new byte[]{};
        }
        if (lineMsg != null && lineMsg.length() > 0) {
            try {
                lineMsgBytes = lineMsg.getBytes("GBK");
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    lineMsgBytes = lineMsg.getBytes("GB2312");
                }
                catch (UnsupportedEncodingException ex1) {
                    lineMsgBytes = lineMsg.getBytes();
                }
            }
        } else {
            lineMsgBytes = new byte[]{};
        }
        int screenCount = this.getDisplayCount();
        if (screenCount <= 2) {
            lineMsgBytes = new byte[]{};
        }
        byte[] dataBytes = new byte[qrContentBytes.length + lineMsgBytes.length + 34];
        int index = 0;
        dataBytes[index++] = 1;
        dataBytes[index++] = 0;
        dataBytes[index++] = 0;
        if (playTimes < 0) {
            playTimes = 0;
        } else if (playTimes > 255) {
            playTimes = 255;
        }
        dataBytes[index++] = (byte)playTimes;
        dataBytes[index++] = 0;
        byte[] rgbBytes = this.getQRCodeRGB();
        dataBytes[index++] = rgbBytes[0];
        dataBytes[index++] = rgbBytes[1];
        dataBytes[index++] = rgbBytes[2];
        dataBytes[index++] = 0;
        index += 4;
        dataBytes[index++] = (byte)qrContentBytes.length;
        dataBytes[index++] = (byte)lineMsgBytes.length;
        dataBytes[index++] = -128;
        dataBytes[index++] = screenCount <= 3 ? (byte)1 : 0;
        index += 15;
        if (qrContentBytes.length > 0) {
            System.arraycopy(qrContentBytes, 0, dataBytes, index, qrContentBytes.length);
            index += qrContentBytes.length;
        }
        dataBytes[index++] = 0;
        if (lineMsgBytes.length > 0) {
            System.arraycopy(lineMsgBytes, 0, dataBytes, index, lineMsgBytes.length);
            index += lineMsgBytes.length;
        }
        dataBytes[index++] = 0;
        return dataBytes;
    }

    private byte[] getQrCodeVersion2Bytes(String qrContent, boolean clean) {
        byte[] qrContentBytes;
        if (qrContent != null && qrContent.length() > 0) {
            try {
                qrContentBytes = qrContent.getBytes("GBK");
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    qrContentBytes = qrContent.getBytes("GB2312");
                }
                catch (UnsupportedEncodingException ex1) {
                    qrContentBytes = qrContent.getBytes();
                }
            }
        } else {
            qrContentBytes = new byte[]{};
        }
        byte[] dataBytes = new byte[qrContentBytes.length + 6];
        int index = 0;
        dataBytes[index++] = 0;
        dataBytes[index++] = 0;
        dataBytes[index++] = 0;
        dataBytes[index++] = 0;
        dataBytes[index++] = clean ? (byte)0 : 1;
        dataBytes[index++] = 0;
        if (qrContentBytes.length > 0) {
            System.arraycopy(qrContentBytes, 0, dataBytes, index, qrContentBytes.length);
            index += qrContentBytes.length;
        }
        return dataBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<Integer> displayQrCode(int playTimes, String qrContent, String lineMsg) {
        OperationFuture<Integer> f;
        Object object = this.displayLock;
        synchronized (object) {
            if (qrContent == null || qrContent.length() == 0) {
                OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
                opHander.setResult((Object)1);
                return opHander;
            }
            if (!this.isWorkingProperly()) {
                OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
                opHander.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return opHander;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
                opHander.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return opHander;
            }
            if (playTimes < 1) {
                playTimes = 1;
            } else if (playTimes > 255) {
                playTimes = 255;
            }
            int version = this.getProtocolVersion();
            if (version == 2) {
                if (this.displayingQrCodeMills > 0L) {
                    this.sendOpData(action, (byte)-124, this.getQrCodeVersion2Bytes(" ", true));
                    this.displayingQrCodeMills = 0L;
                }
                if (playTimes <= 1) {
                    if (lineMsg != null && lineMsg.length() > 0 && this.getDisplayCount() >= 4) {
                        this.displayTempText(action, playTimes, 4, lineMsg, false);
                    }
                    OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
                    opHander.setResult((Object)0);
                    return opHander;
                }
                f = this.sendOpData(action, (byte)-31, this.getQrCodeVersion2Bytes(qrContent, false));
                if (lineMsg != null && lineMsg.length() > 0 && this.getDisplayCount() >= 4) {
                    this.displayTempText(action, playTimes, 4, lineMsg, false);
                }
                this.displayingQrCodeMills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(playTimes * 1000);
            } else {
                if (playTimes <= 1 && (this.displayingQrCodeMills == 0L || ServiceUtil.getServiceContext().currentTimeMillis() > this.displayingQrCodeMills)) {
                    OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
                    opHander.setResult((Object)0);
                    return opHander;
                }
                f = this.sendOpData(action, (byte)-31, this.getQrCodeVersion1Bytes(playTimes, qrContent, lineMsg));
                this.displayingQrCodeMills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(playTimes * 1000);
            }
        }
        return f;
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        if (text == null || text.length() == 0) {
            OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
            opHander.setResult((Object)1);
            return opHander;
        }
        try {
            return this.play(text.getBytes("GB2312"));
        }
        catch (UnsupportedEncodingException e) {
            return this.play(text.getBytes());
        }
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionC0();
        }
        return staticLoudSpeakerServiceAction;
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }

    private static class StrictACKReceiveHandler
    extends StrictReceiveHandler<Integer> {
        private byte waitCmd;
        private KefaChannelDisplayAction action;

        public StrictACKReceiveHandler(byte waitCmd, KefaChannelDisplayAction ac) {
            this.result = -1;
            this.waitCmd = waitCmd;
            this.action = ac;
        }

        @Override
        protected Integer onHanlderResult(int errcode, byte[] frame, int dataOffset, int dataLen) {
            if (errcode != 0) {
                return errcode;
            }
            if (frame == null) {
                return -6;
            }
            if (frame.length < 5) {
                return -6;
            }
            if (this.action != null) {
                this.action.receiveheardbeatTimemills = ServiceUtil.getServiceContext().currentTimeMillis();
            }
            if (this.waitCmd != frame[4]) {
                return -5;
            }
            if (dataLen <= 0) {
                return -6;
            }
            return frame[dataOffset] & 0xFF;
        }
    }

    private static abstract class StrictReceiveHandler<T>
    implements ReceiveDataHandler<T> {
        private byte addr;
        private byte[] xb;
        private volatile int index = 0;
        private byte[] frameBytes;
        protected T result;
        private int dataLength;

        private StrictReceiveHandler() {
        }

        protected abstract T onHanlderResult(int var1, byte[] var2, int var3, int var4);

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public synchronized boolean handleData(byte[] data, int offset, int len) {
            if (data == null) return false;
            if (len == 0) {
                return false;
            }
            int end = offset + len;
            int i = offset;
            while (i < end) {
                byte b = data[i];
                if (this.index == 0) {
                    this.addr = b;
                    ++this.index;
                } else if (this.index == 1) {
                    if (b == 100) {
                        this.xb = new byte[6];
                        this.xb[0] = this.addr;
                        this.xb[this.index++] = b;
                    } else {
                        if (b != -56) {
                            this.result = this.onHanlderResult(-2, null, -1, 0);
                            return true;
                        }
                        this.xb = new byte[7];
                        this.xb[0] = this.addr;
                        this.xb[this.index++] = b;
                    }
                } else if (this.index < this.xb.length) {
                    this.xb[this.index++] = b;
                    if (this.xb.length == this.index) {
                        int dataLen;
                        if (this.xb.length == 6) {
                            dataLen = this.xb[5] & 0xFF;
                            if (dataLen > 255) {
                                this.result = this.onHanlderResult(-4, null, -1, 0);
                                return true;
                            }
                        } else {
                            dataLen = (this.xb[6] & 0xFF) << 8 | this.xb[5] & 0xFF;
                            if (dataLen > 65535) {
                                this.result = this.onHanlderResult(-4, null, -1, 0);
                                return true;
                            }
                        }
                        this.dataLength = dataLen;
                        this.frameBytes = new byte[dataLen + 2 + this.xb.length];
                        System.arraycopy(this.xb, 0, this.frameBytes, 0, this.xb.length);
                    }
                } else {
                    this.frameBytes[this.index++] = b;
                    if (this.index == this.frameBytes.length) {
                        int crc = KefaChannelDisplayAction.mbCRC16(this.frameBytes, 0, this.frameBytes.length - 2);
                        if ((byte)crc == this.frameBytes[this.frameBytes.length - 2] && (byte)(crc >> 8) == this.frameBytes[this.frameBytes.length - 1]) {
                            this.result = this.onHanlderResult(0, this.frameBytes, this.xb.length, this.dataLength);
                            return true;
                        }
                        this.result = this.onHanlderResult(-3, null, -1, 0);
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        @Override
        public T getResponseResult() {
            return this.result;
        }
    }
}

