/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.KefaChannelDisplayAction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class KefaChannelDisplayDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_kefab_screen_driver";

    public KefaChannelDisplayDriver() {
        this.init();
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        KefaChannelDisplayAction c = new KefaChannelDisplayAction(equipment, this);
        this.setAction(equipment, c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        KefaChannelDisplayAction action = (KefaChannelDisplayAction)equipment.getEquipmentAction();
        action.stop();
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u8f66\u9053\u5c4f";
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(1, "\u8f66\u9053\u4fe1\u606f\u5c4f");
        m.put(2, "\u4f59\u4f4d\u4fe1\u606f\u5c4f");
        return m;
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = "KEF_EP01\u8f66\u9053\u5c4f\u63a7\u5236\u5361\u9a71\u52a8";
        this.equipmentType = 10;
        this.defaultUse = 1;
        this.description = "\u7528\u4e8e\u663e\u793a\u51fa\u5165\u6216\u4f59\u4f4d\u4fe1\u606f";
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
        this.parentDriverNames = new String[]{"wovoe_ice_ip_camera_driver", "wovoe_qy_ip_camera_driver", "wovoe_zhenshi_ip_camera_driver", "wlyk_hikvision_ip_regplate_camera_driver", "wlyk_uniview_ip_regplate_camera_driver", "wlyk_qlmrg_ip_camera_driver"};
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        Map<String, String> vmap;
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("uatIndex");
        p.setParameterNameDes("\u8fde\u63a5\u76f8\u673a\u4e32\u53e3\u7aef\u53e3");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        ArrayList<Object> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues.add(new KeyValueEntry((Object)"0", (Object)"\u4e32\u53e31"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u4e32\u53e32"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("baudRate");
        p.setParameterNameDes("\u5c4f\u5361\u4e32\u53e3\u6ce2\u7279\u7387");
        p.setParameterDefaultValue("19200");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(7);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"2400", (Object)"2400"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4800", (Object)"4800"));
        parameterSelectValues.add(new KeyValueEntry((Object)"9600", (Object)"9600"));
        parameterSelectValues.add(new KeyValueEntry((Object)"19200", (Object)"19200"));
        parameterSelectValues.add(new KeyValueEntry((Object)"38400", (Object)"38400"));
        parameterSelectValues.add(new KeyValueEntry((Object)"57600", (Object)"57600"));
        parameterSelectValues.add(new KeyValueEntry((Object)"115200", (Object)"115200"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("RS485_ADDR");
        p.setParameterNameDes("\u5c4f\u5361RS485\u901a\u4fe1\u5730\u5740");
        p.setParameterDefaultValue("0");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("protocol_version");
        p.setParameterNameDes("\u534f\u8bae\u7248\u672c");
        p.setParameterDefaultValue("1");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"1", (Object)"\u7248\u672c1(KEF)"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u7248\u672c2(RRC)"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_SET");
            p.setParameterNameDes("\u767d\u5929\u65f6\u6bb5");
            p.setParameterDefaultValue("07:00:00-19:00:00");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_VOLUME");
            p.setParameterNameDes("\u767d\u5929\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("NIGHT_TIME_VOLUME");
            p.setParameterNameDes("\u591c\u95f4\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
        }
        p = new EquipmentParameter();
        p.setParameterName("dataResponseCheck");
        p.setParameterNameDes("\u54cd\u5e94\u6570\u636e\u6821\u9a8c");
        p.setParameterDefaultValue("2");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(3);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u4e0d\u4e25\u683c\u6821\u9a8c"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u4e25\u683c\u6821\u9a8c"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u4e0d\u6821\u9a8c,(\u534a\u5de5\u6a21\u5f0f)"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("trafficLights");
        p.setParameterNameDes("\u7ea2\u7eff\u706f");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u5173\u95ed"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u542f\u7528"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_count");
        p.setParameterNameDes("\u5c4f\u7684\u6570\u91cf");
        p.setParameterDefaultValue("2");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"2", (Object)"2\u884c\u5c4f"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4", (Object)"4\u884c\u5c4f"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("voice_type");
        p.setParameterNameDes("\u8bed\u97f3\u6a21\u5757");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u9759\u6001\u8bed\u97f3"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"TTS\u8bed\u97f3"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_qrcode");
        p.setParameterNameDes("\u901a\u9053\u4e8c\u7ef4\u7801");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u4e0d\u663e\u793a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u663e\u793a\u52a8\u6001\u4e8c\u7ef4\u7801"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u663e\u793a\u9759\u6001\u4e8c\u7ef4\u7801"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("qrcode_content");
        p.setParameterNameDes("\u9759\u6001\u4e8c\u7ef4\u7801\u5185\u5bb9");
        p.setParameterDefaultValue("");
        pl.add(p);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues4 = new ArrayList<KeyValueEntry<String, String>>(7);
        parameterSelectValues4.add(new KeyValueEntry((Object)"FF0000", (Object)"\u7ea2\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"00FF00", (Object)"\u7eff\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"0000FF", (Object)"\u84dd\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"FFFF00", (Object)"\u9ec4\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"FF00FF", (Object)"\u7d2b\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"00FFFF", (Object)"\u9752\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"FFFFFF", (Object)"\u767d\u8272"));
        p = new EquipmentParameter();
        p.setParameterName("display_qrcode_color");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u989c\u8272");
        p.setParameterDefaultValue("FF0000");
        p.setInputType(1);
        p.setParameterSelectValues(parameterSelectValues4);
        p.setParameterValueDes("");
        pl.add(p);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues0 = new ArrayList<KeyValueEntry<String, String>>(4);
        parameterSelectValues0.add(new KeyValueEntry((Object)"1", (Object)"\u5e7f\u544a\u4fe1\u606f"));
        parameterSelectValues0.add(new KeyValueEntry((Object)"2", (Object)"\u4f59\u4f4d\u4fe1\u606f"));
        LinkedList<KeyValueEntry<String, String>> parameterSelectValues1 = new LinkedList<KeyValueEntry<String, String>>();
        parameterSelectValues1.add(new KeyValueEntry((Object)"0", (Object)"\u603b\u4f59\u4f4d"));
        if (ServiceUtil.getServiceContext() != null && ServiceUtil.getServiceContext().getDBConfigCache() != null && (vmap = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap()) != null && !vmap.isEmpty()) {
            for (Map.Entry<String, String> e : vmap.entrySet()) {
                parameterSelectValues1.add(new KeyValueEntry((Object)e.getKey(), (Object)(String.valueOf(e.getValue()) + "\u4f59\u4f4d")));
                parameterSelectValues1.add(new KeyValueEntry((Object)("rs-" + e.getKey()), (Object)(String.valueOf(e.getValue()) + "\u4f59\u4f4d(\u4e0d\u542b\u5d4c\u5957\u573a\u533a)")));
            }
        }
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues2 = new ArrayList<KeyValueEntry<String, String>>(3);
        int i = 1;
        while (i <= 32) {
            String xx = String.valueOf(i);
            parameterSelectValues2.add(new KeyValueEntry((Object)xx, (Object)xx));
            ++i;
        }
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues3 = new ArrayList<KeyValueEntry<String, String>>(11);
        parameterSelectValues3.add(new KeyValueEntry((Object)"0", (Object)"\u7acb\u5373\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"1", (Object)"\u4ece\u53f3\u5411\u5de6\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"2", (Object)"\u4ece\u5de6\u5411\u53f3\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"3", (Object)"\u4ece\u4e0b\u5411\u4e0a\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"4", (Object)"\u4ece\u4e0a\u5411\u4e0b\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"5", (Object)"\u5411\u4e0b\u62c9\u7a97"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"6", (Object)"\u5411\u4e0a\u62c9\u7a97"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"7", (Object)"\u5411\u5de6\u62c9\u7a97"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"8", (Object)"\u5411\u53f3\u62c9\u7a97"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"9", (Object)"\u53cd\u4eae\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"10", (Object)"\u65e0\u64cd\u4f5c "));
        parameterSelectValues3.add(new KeyValueEntry((Object)"11", (Object)"\u4e2d\u901f\u5de6\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"12", (Object)"\u4e2d\u901f\u53f3\u79fb\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"13", (Object)"\u9010\u5b57\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"14", (Object)"\u5411\u5de6\u5f00\u6805"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"15", (Object)"\u5411\u53f3\u5f00\u6805"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"16", (Object)"\u96ea\u82b1\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"17", (Object)"\u9694\u884c\u51fa\u73b0"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"18", (Object)"\u9694\u5217\u51fa\u73b0"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"19", (Object)"\u6162\u901f\u5de6\u79fb"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"20", (Object)"\u6162\u901f\u53f3\u79fb"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"21", (Object)"\u8fde\u7eed\u5de6\u79fb"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"22", (Object)"\u4e2d\u901f\u8fde\u7eed\u5de6\u79fb"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"23", (Object)"\u6162\u901f\u8fde\u7eed\u5de6\u79fb "));
        int i2 = 1;
        while (i2 <= 4) {
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_free_type");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 1);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u5185\u5bb9");
            if (i2 == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i2 == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i2 == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 2);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("\u4f59\u4f4d");
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_color");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u989c\u8272");
            p.setParameterDefaultValue("FF0000");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues4);
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_exspeed");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u6587\u5b57\u901f\u5ea6");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues2);
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_textwait");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u6587\u5b57\u505c\u7559\u65f6\u95f4(\u79d2)");
            p.setParameterDefaultValue("2");
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_action");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u52a8\u4f5c");
            p.setParameterDefaultValue("21");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues3);
            p.setParameterValueDes("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_type");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("2");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 1);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u5185\u5bb9");
            if (i2 == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i2 == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i2 == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("\u4f59\u4f4d");
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_color1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u989c\u8272");
            p.setParameterDefaultValue("FF0000");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues4);
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_exspeed1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u6587\u5b57\u901f\u5ea6");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues2);
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_textwait1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u6587\u5b57\u505c\u7559\u65f6\u95f4(\u79d2)");
            p.setParameterDefaultValue("2");
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_action1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u52a8\u4f5c");
            p.setParameterDefaultValue("21");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues3);
            p.setParameterValueDes("");
            p.setUse(2);
            pl.add(p);
            ++i2;
        }
    }
}

