/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.event.app.ScanCodeFoundEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;

public class NT371QRCodeScanAction
extends AbstractEquipmentAction
implements Runnable,
IoHandler,
IoSessionInitializer<ConnectFuture> {
    private volatile boolean started;
    private ScheduledFuture<?> jobTaskHandle;
    private volatile long connectingMills;
    private volatile ConnectFuture connectFuture;
    private volatile String connectIp;
    private volatile int connectPort;
    private volatile IoSession connectSession;
    private final Object lock = new Object();
    private final Object readLock = new Object();
    private byte[] cacheBuffer = new byte[512];
    private volatile int cacheBufferOffet = 0;
    private volatile long readMills;
    private final byte HEX_D = (byte)13;
    private final byte HEX_A = (byte)10;
    private volatile String lastRevCode = null;
    private volatile long lastRevCodeMills = 0L;

    public NT371QRCodeScanAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    @Override
    public boolean isWorkingProperly() {
        IoSession connectSession0 = this.connectSession;
        return connectSession0 != null && connectSession0.isConnected();
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                this.started = true;
                this.jobTaskHandle = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(this, 1000L, 3000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                this.started = false;
                if (this.jobTaskHandle != null) {
                    try {
                        this.jobTaskHandle.cancel(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.jobTaskHandle = null;
                }
                if (this.connectFuture != null) {
                    try {
                        if (!this.connectFuture.isDone()) {
                            this.connectFuture.cancel();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connectFuture = null;
                }
                this.connectingMills = 0L;
                if (this.connectSession != null) {
                    try {
                        this.connectSession.close(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connectSession = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                IoSession connectSession0;
                Integer port;
                String ip;
                if (!this.started) {
                    return;
                }
                if (this.connectingMills > 0L && this.connectFuture != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() - this.connectingMills >= 5000L) {
                        try {
                            if (!this.connectFuture.isDone()) {
                                this.connectFuture.cancel();
                            }
                        }
                        finally {
                            this.connectingMills = 0L;
                            this.connectFuture = null;
                        }
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + "] connection timeout! ip: " + this.connectIp + ":" + this.connectPort));
                    } else {
                        return;
                    }
                }
                if ((ip = this.equipment.getIp()) == null || ip.length() == 0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " \u672a\u8bbe\u7f6eIP"));
                }
                if ((port = this.equipment.getEquipmentConfig().getConfigIntValue("port")) == null) {
                    port = 8849;
                }
                if (port < 1 || port > 65535) {
                    port = 8849;
                }
                if ((connectSession0 = this.connectSession) != null && connectSession0.isConnected()) {
                    if (!ip.equals(this.connectIp) || port != this.connectPort) {
                        connectSession0.close(true);
                    } else {
                        return;
                    }
                }
                this.connectIp = ip;
                this.connectPort = port;
                this.connectingMills = ServiceUtil.getServiceContext().currentTimeMillis();
                this.connectFuture = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, (int)port), (IoSessionInitializer)this);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("NT371QRCodeScanAction.run\u9519\u8bef: " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSession(IoSession session, ConnectFuture future) {
        session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        Object object = this.lock;
        synchronized (object) {
            this.connectSession = session;
            this.connectFuture = null;
            this.connectingMills = 0L;
        }
    }

    public void exceptionCaught(IoSession arg0, Throwable arg1) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(IoSession session, Object message) throws Exception {
        List<String> channelNos;
        IoBuffer buf = (IoBuffer)message;
        if (buf == null) {
            return;
        }
        String scanCodeValue = null;
        Object object = this.readLock;
        synchronized (object) {
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.cacheBufferOffet > 0 && currentMills - this.readMills >= 3000L) {
                this.cacheBufferOffet = 0;
            }
            while (buf.hasRemaining()) {
                if (this.cacheBufferOffet == 0) {
                    this.readMills = currentMills;
                } else if (this.cacheBufferOffet >= this.cacheBuffer.length) {
                    this.cacheBufferOffet = 0;
                    return;
                }
                byte b = buf.get();
                this.cacheBuffer[this.cacheBufferOffet++] = b;
                if (this.cacheBufferOffet < 2 || this.cacheBuffer[this.cacheBufferOffet - 2] != 13 && this.cacheBuffer[this.cacheBufferOffet - 1] != 10) continue;
                try {
                    String value;
                    if (this.cacheBufferOffet <= 2) continue;
                    scanCodeValue = value = new String(this.cacheBuffer, 0, this.cacheBufferOffet - 2);
                }
                finally {
                    this.cacheBufferOffet = 0;
                }
            }
            if (scanCodeValue != null && scanCodeValue.length() > 0) {
                if (this.lastRevCode != null && scanCodeValue.equals(this.lastRevCode) && currentMills - this.lastRevCodeMills < 3000L) {
                    return;
                }
                this.lastRevCode = scanCodeValue;
                this.lastRevCodeMills = currentMills;
            }
        }
        if (scanCodeValue != null && scanCodeValue.length() > 0 && (channelNos = this.equipment.getChannelNos()) != null && !channelNos.isEmpty()) {
            CarparkHost host;
            String slaveHostNo;
            String channelNo = channelNos.get(0);
            PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (channel == null) {
                return;
            }
            CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            if (config != null && config.getCarpark_deploy_type() == 1 && config.getNet_mode() == 2 && config.getHost_use() == 1 && (slaveHostNo = channel.getChannel().getSlave_managed_host_no()) != null && slaveHostNo.length() > 0 && !slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) && (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) != null && host.getHost_use() == 1 && host.getNet_mode() == 2) {
                return;
            }
            if (ValidateUtil.isNumeric(scanCodeValue)) {
                ScanCodeFoundEvent event = new ScanCodeFoundEvent(scanCodeValue, channelNo);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
            }
        }
    }

    public void messageSent(IoSession arg0, Object arg1) throws Exception {
    }

    public void sessionClosed(IoSession arg0) throws Exception {
        ServiceLog.getLog().info((Object)("\u4e0e\u8bbe\u5907: " + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u5931\u53bb\u8fde\u63a5"));
    }

    public void sessionCreated(IoSession arg0) throws Exception {
    }

    public void sessionIdle(IoSession arg0, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession arg0) throws Exception {
    }
}

