/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.driver.ICECameraRoadGateAction;
import com.wovoe.carpark.equipment.driver.QLMCameraTool;
import com.wovoe.carpark.equipment.driver.RS485ThreadHandler;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class QLMCameraAction
extends AbstractEquipmentAction
implements PlateRegCameraAction,
CameraUartAction,
RoadBarrierAction,
RoadBarrierStateSupport,
InputIoDetectedAction {
    public static final String LIBRARY_NAME = "yydsLprSdk";
    private ScheduledFuture<?> jobTask;
    private TaskRunner taskRunner;
    private static final String DataPacketParserKey = "QLMCameraTool_DataPacketParser";
    private IoHandler cameraMessageIoHandler;
    private volatile Long hwnd;
    private ConcurrentLinkedQueue<SoftTriggerPlatePacketCallback<?>> softTriggerQueue = new ConcurrentLinkedQueue();
    private volatile long latestedOpSuccessMills;
    public static final String NATIVE_DRIVE_NAME = "com.wovoe.carmera.drive.qlm.Drive";
    private LocalProcessTransport localProcessTransport;
    public static final String VIDEO_ACTION = "/QLMLPRCameraAction";
    private static final int serialcount = 2;
    private final RS485ThreadHandler[] rs485ThreadHandlers = new RS485ThreadHandler[2];
    private volatile EquipmentState lastEquipmentState;
    private volatile long handleControlboxMills;
    private volatile boolean groundPressure;
    private volatile long groundPressureMills;
    private volatile long groundReleaseMills;
    private volatile boolean startCheckOpenPole;
    private volatile long poleOpenedMills;
    private volatile Map<String, QLMCameraTool.CameraPlate> cameraBlackWhiteList;
    private volatile String cameraBlackWhiteSn;
    private final Object downloadBlackWhiteListLock = new Object();
    private static final String TIME1 = " 00:00:00";
    private static final String TIME2 = " 23:59:59";

    public QLMCameraAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.jobTask == null) {
            this.taskRunner = new TaskRunner();
            this.jobTask = ServiceUtil.getServiceContext().schedule(this.taskRunner, 2L, 5L, TimeUnit.SECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    synchronized void stop() {
        if (this.jobTask != null && this.taskRunner != null && !this.taskRunner.stopped) {
            this.taskRunner.stop();
            this.jobTask.cancel(true);
            this.jobTask = null;
            this.hwnd = null;
            this.cameraBlackWhiteList = null;
            this.cameraBlackWhiteSn = null;
            try {
                this.disconnectNativeConnect();
            }
            finally {
                i = 0;
                ** while (i < this.rs485ThreadHandlers.length)
            }
lbl-1000:
            // 1 sources

            {
                rs485ThreadHandler = this.rs485ThreadHandlers[i];
                if (rs485ThreadHandler != null) {
                    rs485ThreadHandler.stop();
                    this.rs485ThreadHandlers[i] = null;
                }
                ++i;
                continue;
            }
        }
lbl21:
        // 3 sources

    }

    private void disconnectNativeConnect() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] close camera connection";
        String serviceName = "disConnect";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    private IoHandler createCameraMessageIoHandler() {
        return new IoHandlerAdapter(){

            public void messageReceived(IoSession session, Object message) throws Exception {
                Object obj = session.getAttribute((Object)QLMCameraAction.DataPacketParserKey);
                if (obj instanceof QLMCameraTool.DataPacketParser) {
                    QLMCameraTool.DataPacketParser parser = (QLMCameraTool.DataPacketParser)obj;
                    if (message instanceof IoBuffer) {
                        IoBuffer buf = (IoBuffer)message;
                        while (buf.hasRemaining()) {
                            QLMCameraTool.DataPacket packet;
                            try {
                                packet = parser.parsePacket(buf);
                            }
                            catch (Exception ex) {
                                try {
                                    ServiceLog.getLog().error((Object)("\u89e3\u6790\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "]\u6570\u636e\u5f02\u5e38" + ex));
                                }
                                finally {
                                    if (session.isConnected() && !session.isClosing()) {
                                        session.close(true);
                                    }
                                }
                                return;
                            }
                            if (packet == null) continue;
                            QLMCameraAction.this.handleCameraRevPacket(packet);
                        }
                    }
                }
            }

            public void exceptionCaught(IoSession session, Throwable ex) throws Exception {
                try {
                    ServiceLog.getLog().error((Object)("\u4e0e\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] \u5931\u53bb\u8fde\u63a5, \u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\uff01 " + ex));
                }
                finally {
                    if (session.isConnected() && !session.isClosing()) {
                        session.close(true);
                    }
                }
            }

            public void messageSent(IoSession session, Object message) throws Exception {
            }

            public void sessionClosed(IoSession session) throws Exception {
                ServiceLog.getLog().error((Object)("\u4e0e\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] \u5931\u53bb\u8fde\u63a5"));
            }
        };
    }

    private void handleCameraRevPacket(QLMCameraTool.DataPacket packet) {
        try {
            PlatePacket platePacket;
            if (!Arrays.equals(QLMCameraTool.DataPacket.HEAD_0, packet.head)) {
                return;
            }
            byte cmd0 = packet.cmd[0];
            byte cmd1 = packet.cmd[1];
            if (packet.reserve != 0) {
                return;
            }
            if (packet.cmdType != 0) {
                return;
            }
            if (packet.data == null || packet.length == 0) {
                return;
            }
            if (cmd0 == 2 && cmd1 == 16) {
                this.hanleSerialData(0, packet);
            } else if (cmd0 == 3 && cmd1 == 16) {
                this.hanleSerialData(1, packet);
            } else if (cmd0 == 0 && cmd1 == 0 && (platePacket = PlatePacket.parse(packet.data, packet.dataOffset, packet.length)) != null) {
                if (platePacket.triggerMethod == 8) {
                    SoftTriggerPlatePacketCallback<?> call = this.pollSoftTriggerPlatePacketCallback();
                    if (call != null) {
                        call.callback(platePacket);
                    }
                } else {
                    this.asynThrowPlate(platePacket);
                }
            }
        }
        catch (Throwable ex) {
            ServiceLog.getLog().error((Object)"\u5904\u7406\u76f8\u673a\u6570\u636e\u5305\u5f02\u5e38!", ex);
        }
    }

    private void hanleSerialData(int port, QLMCameraTool.DataPacket packet) {
        RS485ThreadHandler rs485ThreadHandler = this.rs485ThreadHandlers[port];
        if (rs485ThreadHandler != null && rs485ThreadHandler.isStarted() && packet.length > 0) {
            rs485ThreadHandler.handleRecevie(packet.data, packet.dataOffset, packet.length);
        }
    }

    private void handleFirefighting(int configV, int ioValue) {
        if (configV != 5) {
            return;
        }
        if (ioValue == 1) {
            try {
                if (ServiceUtil.getServiceContext().getFirefightingJob() != null) {
                    ServiceUtil.getServiceContext().getFirefightingJob().firefighting(this.equipment.getEquipmentNo(), this.equipment.getName(), false);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    protected void triggerIllOpenPole() {
        Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
        if (handleType != null && handleType != 2) {
            long xd1 = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.handleControlboxMills == 0L || xd1 - this.handleControlboxMills >= 5000L) {
                this.handleControlboxMills = xd1;
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    EnumSet<RoadBarrierStateEvent.SignalType> signals = null;
                    block0: for (String channelNo : channelNos) {
                        Collection<Equipment> roadGateList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
                        if (roadGateList == null || roadGateList.isEmpty()) continue;
                        for (Equipment eq : roadGateList) {
                            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(channelNo) || eq.getEquipmentAction().getParentEquipmentAction() != this) continue;
                            if (signals == null) {
                                signals = EnumSet.noneOf(RoadBarrierStateEvent.SignalType.class);
                                signals.add(RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN);
                            }
                            EquipmentState state = eq.getEquipmentAction().getEquipmentState();
                            RoadBarrierStateEvent event = new RoadBarrierStateEvent(eq, state, state, signals, channelNo);
                            event.setControlBoxOpenHandleType(handleType);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    private long handleGateState(int configV, int ioValue) {
        int cv = 1;
        EquipmentState state = null;
        if (configV == 1) {
            state = ioValue == cv ? EquipmentState.BARRIER_RAISED_IN_PLACE : EquipmentState.BARRIER_DROPPED_IN_PLACE;
        } else if (configV == 2) {
            state = ioValue == cv ? EquipmentState.BARRIER_DROPPED_IN_PLACE : EquipmentState.BARRIER_RAISED_IN_PLACE;
        } else if (configV == 3) {
            if (ioValue == cv) {
                this.triggerIllOpenPole();
            }
            return 0L;
        }
        if (state != null) {
            Collection<Equipment> eqs;
            long openedPoleDuration;
            boolean autoDownloadPole;
            block29: {
                autoDownloadPole = false;
                openedPoleDuration = 0L;
                if (state == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    if (this.startCheckOpenPole) {
                        if (this.poleOpenedMills > 0L) {
                            String channelNo = null;
                            List<String> chs = this.equipment.getChannelNos();
                            if (chs != null && !chs.isEmpty()) {
                                channelNo = chs.get(0);
                            }
                            if (channelNo != null && channelNo.length() > 0) {
                                String v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_POLE_DOWN_TIMEOUT");
                                if (v != null && v.length() > 0) {
                                    try {
                                        int a = Integer.parseInt(v);
                                        if (a > 0) {
                                            long timeoutMills = a * 1000;
                                            openedPoleDuration = ServiceUtil.getServiceContext().currentTimeMillis() - this.poleOpenedMills;
                                            if (openedPoleDuration >= timeoutMills) {
                                                autoDownloadPole = true;
                                                this.startCheckOpenPole = false;
                                                this.poleOpenedMills = 0L;
                                            }
                                            break block29;
                                        }
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                    catch (Exception ex) {
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                } else {
                                    this.startCheckOpenPole = false;
                                    this.poleOpenedMills = 0L;
                                }
                            } else {
                                this.startCheckOpenPole = false;
                                this.poleOpenedMills = 0L;
                            }
                        } else {
                            this.poleOpenedMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                } else if (this.lastEquipmentState == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                } else if (this.startCheckOpenPole && ServiceUtil.getServiceContext().currentTimeMillis() - this.groundReleaseMills >= 5000L) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                }
            }
            if ((eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9)) != null) {
                Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    for (Equipment e : eqs) {
                        PassChannel passChannel;
                        if (e.getParentEquipmentNo() == null || !this.equipment.getEquipmentNo().equals(e.getParentEquipmentNo())) continue;
                        if (e.getEquipmentAction() instanceof RoadBarrierStateAction) {
                            ((RoadBarrierStateAction)e.getEquipmentAction()).setPoleSate(state, handleType, channelNos.get(0));
                        }
                        if (!autoDownloadPole) continue;
                        boolean isAlwaysOpen = false;
                        if (e.getEquipmentAction() instanceof AlwaysOpenAction) {
                            isAlwaysOpen = ((AlwaysOpenAction)e.getEquipmentAction()).isAlwaysOpen();
                        }
                        if (isAlwaysOpen || !(e.getEquipmentAction() instanceof RoadBarrierAction) || (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNos.get(0))) == null || passChannel.getLanConnectManageHostState() != null) continue;
                        ((RoadBarrierAction)e.getEquipmentAction()).doDownPoleAction();
                        ServiceLog.getLog().info((Object)("\u68c0\u6d4b\u5230\u8f66\u8f86\u79bb\u5f00\u8bc6\u522b\u533a\u540e\uff0c\u6ca1\u6709\u4efb\u4f55\u8f66\u8f86\uff0c\u9053\u95f8\u6746\u5f53\u524d\u662f\u5f00\u5230\u4f4d\uff0c\u8fd9\u79cd\u72b6\u6001\u5df2\u7ecf\u8fde\u7eed" + openedPoleDuration + "\u6beb\u79d2, \u9053\u95f8\u672a\u8bbe\u7f6e\u5e38\u5f00, \u8fd9\u5c06\u53d1\u9001\u843d\u6746\u6307\u4ee4"));
                    }
                }
            }
            this.lastEquipmentState = state;
        }
        return 0L;
    }

    private void asynThrowPlate(final PlatePacket platePacket) {
        if (platePacket == null) {
            return;
        }
        if (this.getPassChannel() == null) {
            return;
        }
        if (this.equipment.getUse() != 1) {
            return;
        }
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] b1;
                    String plateNumber0;
                    int plateLen = platePacket.getPlateLength();
                    if (plateLen > 0) {
                        if (plateLen > 15) {
                            ServiceLog.getLog().error((Object)(String.valueOf(QLMCameraAction.this.equipment.getIp()) + ": \u65e0\u6548\u8f66\u724c\uff01\u8f66\u724c\u53ef\u80fd\u5df2\u52a0\u5bc6,\u957f\u5ea6:" + plateLen));
                            PassChannel ph = QLMCameraAction.this.getPassChannel();
                            if (ph != null) {
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(ph, String.valueOf(ph.getChannel().getChannel_name()) + "\u76f8\u673a:" + QLMCameraAction.this.equipment.getIp() + "\u8bc6\u522b\u7684\u8f66\u724c\u53f7\u65e0\u6548,\u957f\u5ea6\u9519\u8bef,\u8f66\u724c\u53ef\u80fd\u5df2\u52a0\u5bc6", 4, 8000));
                            }
                            return;
                        }
                        try {
                            plateNumber0 = new String(platePacket.plateBytes, 0, plateLen, "GBK");
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)("\u8bc6\u522b\u8f66\u724c\u7f16\u7801\u9519\u8bef! " + ex));
                            return;
                        }
                    } else {
                        plateNumber0 = "";
                    }
                    String throwPlateNumer = plateNumber0.length() == 0 ? "\u65e0\u724c\u8f66" : plateNumber0;
                    try {
                        b1 = throwPlateNumer.getBytes("GBK");
                    }
                    catch (Exception ex) {
                        b1 = throwPlateNumer.getBytes();
                    }
                    String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                    long xatime = System.currentTimeMillis();
                    Random r = new Random();
                    int ranx = Math.abs(r.nextInt());
                    String localBigPicPath = null;
                    String localPlatePicPath = null;
                    if (platePacket.pic != null && platePacket.pic.length > 0) {
                        StringBuilder fileNameBtr = new StringBuilder(128).append("plate_").append(plateHex).append('_').append(xatime).append('_').append(ranx);
                        fileNameBtr.append(".jpg");
                        try {
                            File saveF = new File(QLMCameraAction.this.getPlateSaveDir(), fileNameBtr.toString());
                            try (FileOutputStream out = new FileOutputStream(saveF);){
                                out.write(platePacket.pic);
                            }
                            localBigPicPath = saveF.getAbsolutePath();
                        }
                        catch (Exception e) {
                            ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u5168\u666f\u56fe\u5931\u8d25!", (Throwable)e);
                        }
                        if (platePacket.platePicRight > 0 && platePacket.platePicLeft >= 0 && platePacket.platePicTop >= 0 && platePacket.platePicBottom > 0 && platePacket.platePicRight > platePacket.platePicLeft && platePacket.platePicBottom > platePacket.platePicTop) {
                            try {
                                int with = platePacket.platePicRight - platePacket.platePicLeft;
                                int height = platePacket.platePicBottom - platePacket.platePicTop;
                                BufferedImage image = ImageIO.read(new ByteArrayInputStream(platePacket.pic));
                                BufferedImage newImage = new BufferedImage(with, height, image.getType());
                                Graphics2D g = newImage.createGraphics();
                                try {
                                    g.drawImage((Image)image, -platePacket.platePicLeft, -platePacket.platePicTop, null);
                                }
                                finally {
                                    g.dispose();
                                }
                                fileNameBtr = new StringBuilder(128).append("plateSmall_").append(plateHex).append('_').append(xatime).append('_').append(ranx);
                                fileNameBtr.append(".jpg");
                                File saveF = new File(QLMCameraAction.this.getPlateSaveDir(), fileNameBtr.toString());
                                ImageIO.write((RenderedImage)newImage, "JPEG", saveF);
                                localPlatePicPath = saveF.getAbsolutePath();
                            }
                            catch (Exception e) {
                                ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u56fe\u5931\u8d25!", (Throwable)e);
                            }
                        }
                    }
                    String plateNumber = throwPlateNumer;
                    String plateColor = platePacket.getPlateColor();
                    String vehicleColor = null;
                    CameraEvent event = new CameraEvent(QLMCameraAction.this.equipment, plateNumber, plateColor, localBigPicPath);
                    event.setPlateSmallPath(localPlatePicPath);
                    event.setVehicleColor(vehicleColor);
                    if (platePacket.dateTime != null) {
                        event.setCameraRegPlateMills(platePacket.dateTime.getTime());
                    } else {
                        event.setCameraRegPlateMills(System.currentTimeMillis());
                    }
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    public File getPlateSaveDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        File dateDir = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
        File eqFile = new File(dateDir, this.equipment.getEquipmentNo());
        if (!eqFile.exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    private SoftTriggerPlatePacketCallback<?> pollSoftTriggerPlatePacketCallback() {
        SoftTriggerPlatePacketCallback<?> c;
        long x = 0L;
        while ((c = this.softTriggerQueue.poll()) != null) {
            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(c);
            if (x == 0L) {
                x = ServiceUtil.getServiceContext().currentTimeMillis();
            }
            if (x - c.addQueueMills < 5000L) {
                return c;
            }
            try {
                if (c.future == null || c.future.isDone()) continue;
                c.future.setException((Throwable)new TimeoutException("Wait timeout"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private PassChannel getPassChannel() {
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos != null && !channelNos.isEmpty()) {
            PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNos.get(0));
            return passChannel;
        }
        return null;
    }

    public String getCameraSn() {
        TaskRunner taskRunner0 = this.taskRunner;
        if (taskRunner0 != null) {
            return taskRunner0.cameraSn;
        }
        return null;
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("Missing parameter: componentID:" + x));
            return xf;
        }
        this.hwnd = hwnd0;
        return this.nativePlay(hwnd0, false, this.equipment.getIp());
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        return this.stopNativePlay();
    }

    private OperationFuture<Integer> stopNativePlay() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] stop playing";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    @Override
    public boolean isWorkingProperly() {
        TaskRunner taskRunner0 = this.taskRunner;
        if (taskRunner0 != null) {
            return taskRunner0.isConnected();
        }
        return false;
    }

    @Override
    public OperationFuture<Integer> triggerRegPlate() {
        OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        SoftTriggerPlatePacketCallback<Integer> ax = new SoftTriggerPlatePacketCallback<Integer>(this){

            @Override
            public Integer onSuccess(PlatePacket packet) throws Exception {
                this.asynThrowPlate(packet);
                return 0;
            }
        };
        ax.addToQueue(xf);
        OperationFuture<Integer> r = QLMCameraTool.softTrigger(this.equipment.getIp());
        this.setOpLog(r, "\u8f6f\u89e6\u53d1\u8bc6\u522b");
        return r;
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        if (param == null || param.get("savePath") == null) {
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570: savePath"));
            return xf;
        }
        final String savePath = param.get("savePath").toString();
        final SoftTriggerPlatePacketCallback<Integer> ax = new SoftTriggerPlatePacketCallback<Integer>(this){

            @Override
            public Integer onSuccess(PlatePacket packet) throws Exception {
                try {
                    if (packet.pic == null || packet.pic.length == 0) {
                        return 1;
                    }
                    File saveF = new File(savePath);
                    File pa = saveF.getParentFile();
                    if (!pa.exists()) {
                        pa.mkdirs();
                    }
                    try (FileOutputStream out = new FileOutputStream(saveF);){
                        out.write(packet.pic);
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().info((Object)(String.valueOf(equipment.getName()) + "[" + equipment.getIp() + "]\u4fdd\u5b58\u56fe\u7247\u5f02\u5e38: " + ex.getMessage()));
                    return -30000;
                }
                return 0;
            }
        };
        ax.isAsynRunCallback = true;
        ax.addToQueue(xf);
        OperationFuture<Integer> r = QLMCameraTool.softTrigger(this.equipment.getIp());
        this.setOpLog(r, "\u6293\u62cd\u56fe\u7247(\u8f6f\u89e6\u53d1\u8bc6\u522b)");
        r.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> future) {
                if (future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0) {
                    QLMCameraAction.this.softTriggerQueue.remove(ax);
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)ax);
                    xf.setResult((Object)1);
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return xf;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    private void setOpLog(OperationFuture<Integer> f, final String opName) {
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> futrue) {
                if (futrue.isCancelled()) {
                    ServiceLog.getLog().error((Object)("\u76f8\u673a: " + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] " + opName + ", \u64cd\u4f5c\u88ab\u53d6\u6d88"));
                } else if (futrue.getException() != null) {
                    ServiceLog.getLog().error((Object)("\u76f8\u673a: " + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] " + opName + ", \u64cd\u4f5c\u5f02\u5e38\uff0c\u539f\u56e0: " + futrue.getException()));
                } else if (futrue.getResult() == null) {
                    ServiceLog.getLog().error((Object)("\u76f8\u673a: " + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] " + opName + ", \u64cd\u4f5c\u5931\u8d25, \u672a\u77e5\u7ed3\u679c"));
                } else if ((Integer)futrue.getResult() != 0) {
                    ServiceLog.getLog().error((Object)("\u76f8\u673a: " + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "] " + opName + ", \u64cd\u4f5c\u5931\u8d25\uff0c\u9519\u8bef\u7801: " + futrue.getResult()));
                } else {
                    QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                }
            }
        });
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        Integer io = this.equipment.getEquipmentConfig().getConfigIntValue("roadGateIO");
        if (io == null) {
            io = 0;
        }
        OperationFuture<Integer> f = QLMCameraTool.setOutputGPIOValue(this.equipment.getIp(), io == 0 ? 1 : 2, 0);
        this.setOpLog(f, String.valueOf(io == 0 ? "\u7ee7\u7535\u56681" : "\u7ee7\u7535\u56682") + "\u5f00\u95f8");
        return f;
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        Integer io1 = this.equipment.getEquipmentConfig().getConfigIntValue("roadGateIO");
        if (io1 == null) {
            io1 = 0;
        }
        boolean io = io1 == 0;
        OperationFuture<Integer> f = QLMCameraTool.setOutputGPIOValue(this.equipment.getIp(), !io ? 1 : 2, 0);
        this.setOpLog(f, String.valueOf(!io ? "\u7ee7\u7535\u56681" : "\u7ee7\u7535\u56682") + "\u5173\u95f8");
        return f;
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public boolean isConnGround(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        Integer ioOp1 = this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
        return ioOp1 != null && ioOp1 == 4;
    }

    @Override
    public boolean isGroundPressure(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        return this.isWorkingProperly() && this.groundPressure;
    }

    public boolean hasLineGround() {
        return this.isWorkingProperly() && this.groundPressureMills > 0L;
    }

    public long getPressureMills() {
        if (this.isWorkingProperly() && this.groundPressure && this.groundPressureMills > 0L) {
            return ServiceUtil.getServiceContext().currentTimeMillis() - this.groundPressureMills;
        }
        return 0L;
    }

    @Override
    public boolean isSupportBarrierStateDetected() {
        Integer ioOp = this.getEquipment().getEquipmentConfig().getConfigIntValue("inputIO2");
        return ioOp != null && (ioOp == 1 || ioOp == 2);
    }

    public OperationFuture<Integer> getCheduiMode() {
        OperationFuture<Integer> fx = QLMCameraTool.getCheduiMode(this.equipment.getIp());
        fx.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> future) {
                if (!(future.isCancelled() || future.getException() != null || future.getResult() == null || (Integer)future.getResult() != 0 && (Integer)future.getResult() != 1)) {
                    QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return fx;
    }

    public OperationFuture<Integer> enableCheduiMode(boolean enable) {
        OperationFuture<Integer> fx = QLMCameraTool.enableCheduiMode(this.equipment.getIp(), enable);
        this.setOpLog(fx, String.valueOf(enable ? "\u5f00\u542f" : "\u5173\u95ed") + "\u8f66\u961f\u6a21\u5f0f");
        return fx;
    }

    @Override
    @Deprecated
    public void setPoleSate(EquipmentState state) {
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        final QLMCameraTool.SerialPortConfig config = QLMCameraTool.SerialPortConfig.createFromMap(param);
        OperationFuture<QLMCameraTool.SerialPortConfig> ix = QLMCameraTool.getSerialPortConfig(this.equipment.getIp(), config.port);
        ix.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<QLMCameraTool.SerialPortConfig>(){

            public void operationComplete(OperationFuture<QLMCameraTool.SerialPortConfig> fu) {
                if (fu.isCancelled()) {
                    xf.cancel(true);
                } else if (fu.getException() != null) {
                    xf.setException(fu.getException());
                } else {
                    QLMCameraTool.SerialPortConfig config1 = (QLMCameraTool.SerialPortConfig)fu.getResult();
                    if (config1 == null || !config1.equals(config)) {
                        OperationFuture<Integer> ix1 = QLMCameraTool.setSerialPortConfig(QLMCameraAction.this.equipment.getIp(), config);
                        QLMCameraAction.this.setOpLog((OperationFuture<Integer>)ix1, "\u8bbe\u7f6e\u4e32\u53e3" + config.port + "\u8bbe\u7f6e");
                        ix1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void operationComplete(OperationFuture<Integer> f9) {
                                if (f9.isCancelled()) {
                                    xf.cancel(true);
                                } else if (f9.getException() != null) {
                                    xf.setException(f9.getException());
                                } else {
                                    xf.setResult((Object)((Integer)f9.getResult()));
                                }
                            }

                            public void waitCompleteTimeout() {
                            }
                        });
                    } else {
                        xf.setResult((Object)0);
                    }
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return xf;
    }

    private OperationFuture<Integer> startSerial(int port) {
        String opName = "\u6253\u5f00\u4e32\u53e3" + port;
        OperationFuture<Integer> f = QLMCameraTool.enableRs485Transparent(this.equipment.getIp(), port, true);
        this.setOpLog(f, opName);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RS485ThreadHandler getRS485ThreadHandler(int index) {
        RS485ThreadHandler rs485ThreadHandler;
        block7: {
            TaskRunner taskRunner0 = this.taskRunner;
            if (taskRunner0 == null || taskRunner0.stopped) {
                return null;
            }
            if (index < 0 || index >= this.rs485ThreadHandlers.length) {
                return null;
            }
            rs485ThreadHandler = this.rs485ThreadHandlers[index];
            if (rs485ThreadHandler != null) break block7;
            QLMCameraAction qLMCameraAction = this;
            synchronized (qLMCameraAction) {
                block6: {
                    rs485ThreadHandler = this.rs485ThreadHandlers[index];
                    if (rs485ThreadHandler != null) break block7;
                    if (!taskRunner0.stopped) break block6;
                    return null;
                }
                rs485ThreadHandler = new RS485ThreadHandler(index){

                    @Override
                    protected OperationFuture<Boolean> directSend(byte[] data) {
                        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                        try {
                            OperationFuture<Integer> of = QLMCameraTool.sendSerialData(QLMCameraAction.this.equipment.getIp(), this.portIndex, data);
                            QLMCameraAction.this.setOpLog((OperationFuture<Integer>)of, "\u5411\u4e32\u53e3" + this.portIndex + "\u53d1\u9001RS485\u6570\u636e");
                            of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                }

                                public void operationComplete(OperationFuture<Integer> future) {
                                    if (future.isCancelled()) {
                                        xf.cancel(true);
                                    } else if (future.getException() != null) {
                                        xf.setException(future.getException());
                                    } else {
                                        xf.setResult((Object)(future.getResult() != null && (Integer)future.getResult() == 0 ? 1 : 0));
                                    }
                                }
                            });
                        }
                        catch (Throwable ex) {
                            xf.setException(ex);
                        }
                        return xf;
                    }
                };
                rs485ThreadHandler.start();
                this.rs485ThreadHandlers[index] = rs485ThreadHandler;
                this.startSerial(index);
            }
        }
        return rs485ThreadHandler;
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (data == null || data.length == 0) {
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        TaskRunner taskRunner0 = this.taskRunner;
        RS485ThreadHandler shandler = this.getRS485ThreadHandler(portIndex);
        if (shandler == null || !shandler.isStarted()) {
            if (taskRunner0 == null || taskRunner0.stopped) {
                f.setException((Throwable)new IllegalStateException("\u9a71\u52a8\u5df2\u7ecf\u505c\u6b62!"));
                return f;
            }
            f.setException((Throwable)new IllegalStateException("\u521d\u59cb\u5316\u53d1\u9001\u4e32\u53e3\u7ebf\u7a0b\u5931\u8d25!"));
            return f;
        }
        shandler.sendToQueue(data, handler, f, waitMills);
        return f;
    }

    private void connectIfNotConnected1(final boolean force, final String connectIp) {
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            return;
        }
        OperationFuture<Integer> f = this.getLocalProcessTransport().loadNativeDriveIfNeed(NATIVE_DRIVE_NAME, "Loading camera local video driver");
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> xd) {
                if (xd.getException() == null && xd.getResult() != null && (Integer)xd.getResult() == 0) {
                    QLMCameraAction.this.playIfNeed(force, connectIp);
                }
            }
        });
    }

    private void playIfNeed(boolean force, String connectIp) {
        Long hwnd0 = this.hwnd;
        if (hwnd0 != null) {
            this.nativePlay(hwnd0, force, connectIp);
        }
    }

    private OperationFuture<Integer> nativePlay(Long hwnd0, boolean force, String connectIp) {
        if (!force && !this.isWorkingProperly()) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setResult((Object)-1);
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] Play the video";
        String serviceName = "playVisible";
        long timeoutMills = 5000L;
        this.setNativeReusetParam(paramMap);
        paramMap.put("ip", connectIp);
        paramMap.put("componentID", hwnd0.toString());
        return this.getLocalProcessTransport().doRemoteService(VIDEO_ACTION, serviceName, paramMap, timeoutMills, opName);
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = QLMCameraAction.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/qlmlprsdk/" + QLMCameraAction.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = QLMCameraAction.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/qlmlprsdk/" + QLMCameraAction.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/qlmlprsdk/" + QLMCameraAction.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "yydsLprSdk.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "yydsLprSdk.so";
        }
        return "yydsLprSdk.dll";
    }

    private void setNativeReusetParam(Map<String, String> paramMap) {
        String userPwd;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("port", "8857");
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String userName = config.getConfigValue("login_user");
        if (userName == null || userName.length() == 0) {
            userName = "admin";
        }
        if ((userPwd = config.getConfigValue("login_pwd")) == null || userPwd.length() == 0) {
            userPwd = "admin";
        }
        paramMap.put("userName", userName);
        paramMap.put("userPwd", userPwd);
    }

    @Override
    public boolean isSupportWhiteList() {
        return true;
    }

    @Override
    public boolean isSupportBlackList() {
        return true;
    }

    @Override
    public void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList, Collection<PlateEntry> blackList, PlateRegCameraAction.ImportPlateCallback callback) throws Exception {
        this.downlodAllWhiteBlackList(whiteList, blackList, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList01, Collection<PlateEntry> blackList01, PlateRegCameraAction.ImportPlateCallback callback, boolean onlyCheck) throws Exception {
        try {
            TaskRunner taskRunner0;
            if (callback != null) {
                callback.onCheck(this.equipment.getEquipmentNo(), onlyCheck);
            }
            if ((taskRunner0 = this.taskRunner) == null) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            if (!taskRunner0.isConnected()) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            String camearaSn = taskRunner0.cameraSn;
            if (camearaSn == null || camearaSn.length() == 0) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            if (this.cameraBlackWhiteSn != null && !camearaSn.equals(this.cameraBlackWhiteSn)) {
                this.cameraBlackWhiteSn = null;
                this.cameraBlackWhiteList = null;
            }
            Collection<PlateEntry> whiteList0 = whiteList01 != null ? whiteList01 : new LinkedList<PlateEntry>();
            Collection<PlateEntry> blackList0 = blackList01 != null ? blackList01 : new LinkedList<PlateEntry>();
            Object object = this.downloadBlackWhiteListLock;
            synchronized (object) {
                long eTime;
                boolean needUpdate;
                QLMCameraTool.CameraPlate plateA;
                String ip = this.equipment.getIp();
                Map<String, QLMCameraTool.CameraPlate> cameraBlackWhiteListMap = this.cameraBlackWhiteList;
                if (cameraBlackWhiteListMap == null) {
                    QLMCameraTool.CameraPlateList list;
                    if (callback != null) {
                        callback.onQueryAll(this.equipment.getEquipmentNo());
                    }
                    HashMap<String, QLMCameraTool.CameraPlate> map = new HashMap<String, QLMCameraTool.CameraPlate>();
                    int pageNum = 1;
                    do {
                        OperationFuture<QLMCameraTool.CameraPlateList> of;
                        if (taskRunner0.stopped) {
                            throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u5df2\u65ad\u5f00\u8fde\u63a5!");
                        }
                        if (!taskRunner0.isConnected()) {
                            throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u5df2\u65ad\u5f00\u8fde\u63a5!");
                        }
                        if ((list = (QLMCameraTool.CameraPlateList)(of = QLMCameraTool.queryBlackWhiteList(ip, pageNum++, null)).get(12L, TimeUnit.SECONDS)) == null) {
                            throw new Exception("\u8bbe\u5907" + this.equipment.getName() + " \u67e5\u8be2\u9ed1\u767d\u540d\u5355\u5217\u8868\u8d85\u65f6");
                        }
                        if (list.list == null || list.list.isEmpty()) continue;
                        for (QLMCameraTool.CameraPlate cameraPlate : list.list) {
                            if (cameraPlate == null || cameraPlate.plate == null || cameraPlate.plate.length() <= 0) continue;
                            map.put(cameraPlate.plate, cameraPlate);
                        }
                    } while (list.count != 0 && list.list != null && !list.list.isEmpty() && list.list.size() >= list.pageSize);
                    cameraBlackWhiteListMap = map;
                    this.cameraBlackWhiteSn = camearaSn;
                    this.cameraBlackWhiteList = cameraBlackWhiteListMap;
                }
                HashMap<String, QLMCameraTool.CameraPlate> cameraPlateListMap0 = new HashMap<String, QLMCameraTool.CameraPlate>();
                int cameraWhiteCount = 0;
                int cameraBlackCount = 0;
                for (QLMCameraTool.CameraPlate p : cameraBlackWhiteListMap.values()) {
                    if (p.type == 0) {
                        ++cameraWhiteCount;
                    } else {
                        ++cameraBlackCount;
                    }
                    cameraPlateListMap0.put(p.plate, p);
                }
                if (callback != null) {
                    callback.onQueryAllFinish(this.equipment.getEquipmentNo(), cameraWhiteCount, cameraBlackCount, whiteList0.size(), blackList0.size());
                }
                LinkedList<PlateEntry> insertW = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> linkedList = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> deleteW = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> insertB = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> updateB = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> deleteB = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> simpleListW = new LinkedList<PlateEntry>();
                LinkedList<PlateEntry> simpleListB = new LinkedList<PlateEntry>();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (PlateEntry white : whiteList0) {
                    if (white.getPlate() == null || white.getPlate().length() <= 0) continue;
                    plateA = (QLMCameraTool.CameraPlate)cameraPlateListMap0.remove(white.getPlate());
                    if (plateA == null) {
                        insertW.add(white);
                        continue;
                    }
                    needUpdate = false;
                    if (!plateA.enable || plateA.useTimeSeg || plateA.type != 0) {
                        needUpdate = true;
                    } else {
                        long bTime = this.getTimeSecs(white.getBeginDate(), df, true);
                        eTime = this.getTimeSecs(white.getEndDate(), df, false);
                        if (bTime != plateA.beginTime || eTime != plateA.endTime) {
                            needUpdate = true;
                        }
                    }
                    if (needUpdate) {
                        linkedList.add(white);
                        continue;
                    }
                    simpleListW.add(white);
                }
                for (PlateEntry black : blackList0) {
                    if (black.getPlate() == null || black.getPlate().length() <= 0) continue;
                    plateA = (QLMCameraTool.CameraPlate)cameraPlateListMap0.remove(black.getPlate());
                    if (plateA == null) {
                        insertB.add(black);
                        continue;
                    }
                    needUpdate = false;
                    if (!plateA.enable || plateA.useTimeSeg || plateA.type != 1) {
                        needUpdate = true;
                    } else {
                        long bTime2 = this.getTimeSecs(black.getBeginDate(), df, true);
                        eTime = this.getTimeSecs(black.getEndDate(), df, false);
                        if (bTime2 != plateA.beginTime || eTime != plateA.endTime) {
                            needUpdate = true;
                        }
                    }
                    if (needUpdate) {
                        updateB.add(black);
                        continue;
                    }
                    simpleListB.add(black);
                }
                if (!cameraPlateListMap0.isEmpty()) {
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                    Iterator it = cameraPlateListMap0.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        it.remove();
                        PlateEntry del = new PlateEntry();
                        del.setPlate(((QLMCameraTool.CameraPlate)entry.getValue()).plate);
                        try {
                            del.setBeginDate(df1.format(new Date(((QLMCameraTool.CameraPlate)entry.getValue()).beginTime * 1000L)));
                            del.setEndDate(df1.format(new Date(((QLMCameraTool.CameraPlate)entry.getValue()).endTime * 1000L)));
                        }
                        catch (Exception bTime2) {
                            // empty catch block
                        }
                        if (((QLMCameraTool.CameraPlate)entry.getValue()).type == 0) {
                            deleteW.add(del);
                            continue;
                        }
                        deleteB.add(del);
                    }
                }
                if (insertW.size() == 0 && linkedList.size() == 0 && deleteW.size() == 0 && insertB.size() == 0 && updateB.size() == 0 && deleteB.size() == 0) {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), 0, 0, 0, simpleListW.size(), 0, 0, 0, simpleListB.size(), onlyCheck);
                    }
                } else {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), insertW.size(), linkedList.size(), deleteW.size(), simpleListW.size(), insertB.size(), updateB.size(), deleteB.size(), simpleListB.size(), onlyCheck);
                    }
                    if (onlyCheck) {
                        return;
                    }
                    if (ServiceLog.getLog().isInfoEnabled()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u53d1\u73b0\u8f66\u724c\u9700\u8981\u540c\u6b65\uff0c\u51c6\u5907\u4e0b\u8f7d\u6700\u65b0\u7684\u8f66\u724c\u4fe1\u606f! "));
                    }
                    if (callback != null) {
                        callback.onStartDownlod(this.equipment.getEquipmentNo());
                    }
                    boolean needRecheck = false;
                    boolean reLoadAll = true;
                    try {
                        if (whiteList0.isEmpty() && blackList0.isEmpty() && !cameraBlackWhiteListMap.isEmpty()) {
                            Integer h = (Integer)QLMCameraTool.clearAllBlackWhiteList(ip).get(15L, TimeUnit.SECONDS);
                            if (h == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u8d85\u65f6!");
                            }
                            if (h != 0) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25!");
                            }
                            ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u9ed1\u767d\u540d\u5355\u5df2\u88ab\u6e05\u7a7a"));
                            if (callback != null) {
                                LinkedList<PlateEntry> emptyList = new LinkedList<PlateEntry>();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, whiteList0, emptyList, blackList0, emptyList);
                            }
                            needRecheck = true;
                        } else {
                            LinkedList<PlateEntry> whiteSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> whiteFaild = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackSuccess = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> blackFaild = new LinkedList<PlateEntry>();
                            this.doOpWhiteBlackList(ip, cameraBlackWhiteListMap, insertW, linkedList, deleteW, whiteSuccess, whiteFaild, 0);
                            this.doOpWhiteBlackList(ip, cameraBlackWhiteListMap, insertB, updateB, deleteB, blackSuccess, blackFaild, 1);
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4e0b\u8f7d\u9ed1\u767d\u540d\u5355\u64cd\u4f5c\u5b8c\u6210!"));
                            }
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u767d\u540d\u5355\u603b\u8f66\u724c\u6570: " + whiteList0.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleListW.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + whiteSuccess.size() + " " + whiteSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + whiteFaild.size() + " " + whiteFaild));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u9ed1\u540d\u5355\u603b\u8f66\u724c\u6570: " + blackList0.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + simpleListB.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + blackSuccess.size() + " " + blackSuccess));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u9ed1\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + blackFaild.size() + " " + blackFaild));
                            }
                            if (callback != null) {
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, whiteSuccess, whiteFaild, blackSuccess, blackFaild);
                            }
                            if (whiteFaild.size() == 0 && blackFaild.size() == 0) {
                                reLoadAll = false;
                            }
                        }
                    }
                    finally {
                        if (reLoadAll) {
                            this.cameraBlackWhiteList = null;
                        }
                    }
                    if (!onlyCheck && needRecheck) {
                        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                ExecutionException ex1;
                if (ex instanceof ExecutionException && (ex1 = (ExecutionException)ex).getCause() != null) {
                    Throwable ex0 = ex1.getCause();
                    ex = ex0 instanceof Exception ? (Exception)ex0 : new Exception(ex0.getMessage(), ex0);
                }
                callback.onDownlodException(this.equipment.getEquipmentNo(), ex);
            }
            throw ex;
        }
    }

    private long getTimeSecs(String dateTime, SimpleDateFormat dateTimeFormat, boolean beginTime) {
        long timeMills = 0L;
        if (dateTime != null && dateTime.length() > 0) {
            if (dateTime.length() == 10) {
                dateTime = beginTime ? String.valueOf(dateTime) + TIME1 : String.valueOf(dateTime) + TIME2;
            }
            if (dateTimeFormat == null) {
                dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
            try {
                timeMills = dateTimeFormat.parse(dateTime).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (timeMills <= 0L) {
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            cl.set(2000, 0, 1, 0, 0, 0);
            timeMills = cl.getTimeInMillis();
        }
        return timeMills / 1000L;
    }

    private void doOpWhiteBlackList(String ip, Map<String, QLMCameraTool.CameraPlate> cameraBlackWhiteListMap, List<PlateEntry> insertList, List<PlateEntry> updateList, List<PlateEntry> deleteList, List<PlateEntry> successList, List<PlateEntry> errorList, int opType) {
        if (deleteList != null && !deleteList.isEmpty()) {
            for (PlateEntry en : deleteList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    QLMCameraTool.CameraPlate old = cameraBlackWhiteListMap.get(en.getPlate());
                    if (old != null) {
                        try {
                            Integer h = (Integer)QLMCameraTool.delBlackWhiteListById(ip, old.id).get(8500L, TimeUnit.MILLISECONDS);
                            if (h != null && h == 0) {
                                successList.add(en);
                                cameraBlackWhiteListMap.remove(old.plate);
                                continue;
                            }
                            errorList.add(en);
                        }
                        catch (Exception ex) {
                            errorList.add(en);
                        }
                        continue;
                    }
                    errorList.add(en);
                    continue;
                }
                errorList.add(en);
            }
        }
        SimpleDateFormat dateTimeFormat = null;
        if (updateList != null && !updateList.isEmpty()) {
            for (PlateEntry en : updateList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    QLMCameraTool.CameraPlate old = cameraBlackWhiteListMap.get(en.getPlate());
                    if (old != null) {
                        try {
                            QLMCameraTool.CameraPlate updateP = new QLMCameraTool.CameraPlate();
                            updateP.id = old.id;
                            updateP.createTime = old.createTime;
                            updateP.plate = old.plate;
                            updateP.useTimeSeg = false;
                            updateP.enable = true;
                            updateP.type = opType;
                            if (dateTimeFormat == null) {
                                dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            }
                            updateP.beginTime = this.getTimeSecs(en.getBeginDate(), dateTimeFormat, true);
                            updateP.endTime = this.getTimeSecs(en.getEndDate(), dateTimeFormat, false);
                            Integer h = (Integer)QLMCameraTool.updateBlackWhiteList(ip, updateP).get(8500L, TimeUnit.MILLISECONDS);
                            if (h != null && h == 0) {
                                old.useTimeSeg = updateP.useTimeSeg;
                                old.enable = updateP.enable;
                                old.type = updateP.type;
                                old.beginTime = updateP.beginTime;
                                old.endTime = updateP.endTime;
                                successList.add(en);
                                continue;
                            }
                            errorList.add(en);
                        }
                        catch (Exception ex) {
                            errorList.add(en);
                        }
                        continue;
                    }
                    errorList.add(en);
                    continue;
                }
                errorList.add(en);
            }
        }
        if (insertList != null && !insertList.isEmpty()) {
            for (PlateEntry en : insertList) {
                if (en.getPlate() != null && en.getPlate().length() > 0) {
                    if (!this.isWorkingProperly()) {
                        errorList.add(en);
                        continue;
                    }
                    QLMCameraTool.CameraPlate add = new QLMCameraTool.CameraPlate();
                    add.plate = en.getPlate();
                    add.useTimeSeg = false;
                    add.enable = true;
                    add.type = opType;
                    if (dateTimeFormat == null) {
                        dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    add.beginTime = this.getTimeSecs(en.getBeginDate(), dateTimeFormat, true);
                    add.endTime = this.getTimeSecs(en.getEndDate(), dateTimeFormat, false);
                    try {
                        QLMCameraTool.CameraPlate newAdd = (QLMCameraTool.CameraPlate)QLMCameraTool.addBlackWhiteListOne(ip, add).get(8500L, TimeUnit.MILLISECONDS);
                        if (newAdd == null) {
                            errorList.add(en);
                            continue;
                        }
                        if (add.plate.equals(newAdd.plate) && add.type == newAdd.type && add.enable == newAdd.enable && add.useTimeSeg == newAdd.useTimeSeg && add.beginTime == newAdd.beginTime && add.endTime == newAdd.endTime) {
                            cameraBlackWhiteListMap.put(newAdd.plate, newAdd);
                            successList.add(en);
                            continue;
                        }
                        errorList.add(en);
                    }
                    catch (Exception ex) {
                        errorList.add(en);
                    }
                    continue;
                }
                errorList.add(en);
            }
        }
    }

    private static class PlatePacket {
        public static final int DEVICE_NET_LPRC_PLATECOLOR_BLUE = 1;
        public static final int DEVICE_NET_LPRC_PLATECOLOR_YELLOW = 2;
        public static final int DEVICE_NET_LPRC_PLATECOLOR_WHITE = 3;
        public static final int DEVICE_NET_LPRC_PLATECOLOR_BLACK = 4;
        public static final int DEVICE_NET_LPRC_PLATECOLOR_GREEN = 5;
        int triggerMethod;
        byte[] plateBytes;
        int plateColor;
        int platePicLeft;
        int platePicTop;
        int platePicRight;
        int platePicBottom;
        Date dateTime;
        byte[] pic;

        private PlatePacket() {
        }

        public static PlatePacket parse(byte[] data, int offset, int lendth) {
            int len = 84;
            if (lendth >= len) {
                PlatePacket packet = new PlatePacket();
                ByteBuffer buf = ByteBuffer.wrap(data, offset, lendth);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                packet.triggerMethod = buf.getInt();
                packet.plateBytes = new byte[16];
                buf.get(packet.plateBytes);
                buf.getInt();
                packet.plateColor = buf.getInt();
                buf.getInt();
                packet.platePicLeft = buf.getInt();
                packet.platePicTop = buf.getInt();
                packet.platePicRight = buf.getInt();
                packet.platePicBottom = buf.getInt();
                int picLength = buf.getInt();
                int year = buf.getInt();
                int month = buf.getInt();
                int day = buf.getInt();
                int hour = buf.getInt();
                int mins = buf.getInt();
                int secs = buf.getInt();
                Calendar cl = Calendar.getInstance();
                cl.set(14, 0);
                cl.set(year, month - 1, day, hour, mins, secs);
                packet.dateTime = cl.getTime();
                buf.getInt();
                buf.getInt();
                if (picLength > 0 && lendth - len >= picLength) {
                    packet.pic = new byte[picLength];
                    buf.get(packet.pic);
                }
                return packet;
            }
            return null;
        }

        public int getPlateLength() {
            int len = 0;
            if (this.plateBytes != null && this.plateBytes.length > 0) {
                int i = 0;
                while (i < this.plateBytes.length) {
                    if (this.plateBytes[i] == 0) break;
                    ++len;
                    ++i;
                }
            }
            return len;
        }

        public String getPlateColor() {
            String cl;
            switch (this.plateColor) {
                case 1: {
                    cl = "\u84dd";
                    break;
                }
                case 2: {
                    cl = "\u9ec4";
                    break;
                }
                case 3: {
                    cl = "\u767d";
                    break;
                }
                case 4: {
                    cl = "\u9ed1";
                    break;
                }
                case 5: {
                    cl = "\u7eff";
                    break;
                }
                default: {
                    cl = "\u84dd";
                }
            }
            return cl;
        }
    }

    private abstract class SoftTriggerPlatePacketCallback<T>
    implements TimeoutObjectPool.TimeoutCallback {
        OperationFutureHandler<T> future;
        long addQueueMills;
        boolean isAsynRunCallback;

        private SoftTriggerPlatePacketCallback() {
        }

        public void callback(final PlatePacket packet) {
            if (this.isAsynRunCallback) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        SoftTriggerPlatePacketCallback.this.callback0(packet);
                    }
                });
            } else {
                this.callback0(packet);
            }
        }

        protected void callback0(PlatePacket packet) {
            Object result = null;
            try {
                result = this.onSuccess(packet);
            }
            catch (Throwable ex) {
                if (this.future != null && !this.future.isDone()) {
                    this.future.setException(ex);
                }
                return;
            }
            if (this.future != null && !this.future.isDone()) {
                this.future.setResult(result);
            }
        }

        public abstract T onSuccess(PlatePacket var1) throws Exception;

        public void onTimeout(Object key, Object value) throws Exception {
            QLMCameraAction.this.softTriggerQueue.remove(this);
            if (this.future != null && !this.future.isDone()) {
                this.future.setException((Throwable)new TimeoutException("Wait timeout"));
            }
        }

        public void addToQueue(OperationFutureHandler<T> future) {
            this.future = future;
            this.addQueueMills = ServiceUtil.getServiceContext().currentTimeMillis();
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)this, (Object)this, (TimeoutObjectPool.TimeoutCallback)this, 5000L, TimeUnit.MILLISECONDS);
            QLMCameraAction.this.softTriggerQueue.offer(this);
        }
    }

    private class TaskRunner
    extends JobTask {
        volatile boolean stopped;
        volatile IoSession iosession;
        String cameraSn;
        String cameraIp;
        volatile long connectingMills;
        OperationFuture<IoSession> connectFuture;
        volatile boolean tConnected;
        private ScheduledFuture<?> getIoSateJobTask;

        private TaskRunner() {
        }

        public boolean isConnected() {
            if (QLMCameraAction.this.getPassChannel() == null) {
                return this.tConnected;
            }
            IoSession session = this.iosession;
            boolean connected = session != null && session.isConnected() && !session.isClosing();
            return connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            Object obj;
            boolean connected;
            if (this.stopped) {
                return;
            }
            if (QLMCameraAction.this.getPassChannel() == null) {
                String connIp;
                boolean connected2;
                IoSession session = this.iosession;
                boolean bl = connected2 = session != null && session.isConnected() && !session.isClosing();
                if (connected2) {
                    session.close(true);
                }
                if (this.getIoSateJobTask != null) {
                    TaskRunner taskRunner = this;
                    synchronized (taskRunner) {
                        if (this.getIoSateJobTask != null) {
                            this.getIoSateJobTask.cancel(true);
                            this.getIoSateJobTask = null;
                        }
                    }
                }
                if ((connIp = QLMCameraAction.this.equipment.getIp()) == null || connIp.length() == 0) {
                    this.tConnected = false;
                    if (QLMCameraAction.this.hwnd != null) {
                        QLMCameraAction.this.stopNativePlay();
                    }
                } else {
                    if (!connIp.equals(this.cameraIp) && QLMCameraAction.this.hwnd != null) {
                        QLMCameraAction.this.stopNativePlay();
                    }
                    this.cameraIp = connIp;
                    QLMCameraTool.getDeviceSn(connIp).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<String>(){

                        public void waitCompleteTimeout() {
                        }

                        public void operationComplete(OperationFuture<String> futrue) {
                            if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null && ((String)futrue.getResult()).length() > 0) {
                                TaskRunner.this.cameraSn = (String)futrue.getResult();
                                TaskRunner.this.tConnected = true;
                                QLMCameraAction.this.connectIfNotConnected1(false, connIp);
                                if (QLMCameraAction.this.cameraBlackWhiteSn != null && !((String)futrue.getResult()).equals(QLMCameraAction.this.cameraBlackWhiteSn)) {
                                    if (QLMCameraAction.this.cameraBlackWhiteList != null) {
                                        QLMCameraAction.this.cameraBlackWhiteList = null;
                                    }
                                    QLMCameraAction.this.cameraBlackWhiteSn = null;
                                }
                            } else {
                                TaskRunner.this.tConnected = false;
                            }
                        }
                    });
                }
                return;
            }
            String connIp = QLMCameraAction.this.equipment.getIp();
            IoSession session = this.iosession;
            boolean bl = connected = session != null && session.isConnected() && !session.isClosing();
            if (connected) {
                if (connIp == null || connIp.length() == 0 || !connIp.equals(this.cameraIp)) {
                    this.disconnect();
                    connected = false;
                    if (QLMCameraAction.this.hwnd != null) {
                        QLMCameraAction.this.stopNativePlay();
                    }
                    if (this.getIoSateJobTask != null) {
                        TaskRunner taskRunner = this;
                        synchronized (taskRunner) {
                            if (this.getIoSateJobTask != null) {
                                this.getIoSateJobTask.cancel(true);
                                this.getIoSateJobTask = null;
                            }
                        }
                    }
                } else {
                    QLMCameraTool.DataPacketParser parser;
                    obj = session.getAttribute((Object)QLMCameraAction.DataPacketParserKey);
                    if (obj instanceof QLMCameraTool.DataPacketParser && (parser = (QLMCameraTool.DataPacketParser)obj).isReadTimeout()) {
                        ServiceLog.getLog().error((Object)("\u8bfb\u53d6 " + QLMCameraAction.this.equipment.getName() + "[" + connIp + "] \u6570\u636e\u5305\u8d85\u65f6, \u53ef\u80fd\u7f51\u7edc\u4e22\u5305\u5bfc\u81f4\uff0c\u8fd9\u5c06\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5!"));
                        session.close(true);
                        connected = false;
                    }
                }
            }
            if (connIp == null || connIp.length() == 0) {
                return;
            }
            if (!connected) {
                if (this.connectingMills == 0L || ServiceUtil.getServiceContext().currentTimeMillis() - this.connectingMills >= 8500L) {
                    obj = this;
                    synchronized (obj) {
                        OperationFuture<IoSession> connectFuture0 = this.connectFuture;
                        if (connectFuture0 != null) {
                            if (!connectFuture0.isDone()) {
                                connectFuture0.cancel(true);
                            }
                            if (connectFuture0.getResult() != null && ((IoSession)connectFuture0.getResult()).isConnected()) {
                                ((IoSession)connectFuture0.getResult()).close(true);
                            }
                        }
                        this.connectFuture = this.connect(connIp);
                    }
                }
            } else {
                long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                boolean triggerTest = false;
                Object obj2 = session.getAttribute((Object)QLMCameraAction.DataPacketParserKey);
                if (obj2 instanceof QLMCameraTool.DataPacketParser) {
                    QLMCameraTool.DataPacketParser parser = (QLMCameraTool.DataPacketParser)obj2;
                    if (currentMills - parser.getLatestRevMills() >= 30000L) {
                        triggerTest = true;
                    }
                } else {
                    session.close(true);
                    return;
                }
                if (triggerTest) {
                    OperationFutureHandler futureX = ServiceUtil.getServiceContext().createOperationFuture();
                    SoftTriggerPlatePacketCallback<Boolean> callx = new SoftTriggerPlatePacketCallback<Boolean>(QLMCameraAction.this){

                        @Override
                        public Boolean onSuccess(PlatePacket packet) throws Exception {
                            return Boolean.TRUE;
                        }
                    };
                    callx.addToQueue(futureX);
                    final IoSession checkSession = session;
                    futureX.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Boolean>(){

                        public void operationComplete(OperationFuture<Boolean> futrue) {
                            IoSession session = TaskRunner.this.iosession;
                            if (checkSession == session) {
                                boolean connected;
                                boolean bl = connected = session != null && session.isConnected() && !session.isClosing();
                                if (connected) {
                                    Object obj = session.getAttribute((Object)QLMCameraAction.DataPacketParserKey);
                                    if (obj instanceof QLMCameraTool.DataPacketParser) {
                                        QLMCameraTool.DataPacketParser parser = (QLMCameraTool.DataPacketParser)obj;
                                        if (ServiceUtil.getServiceContext().currentTimeMillis() - parser.getLatestRevMills() >= 5000L) {
                                            ServiceLog.getLog().error((Object)("\u68c0\u6d4b\u5230\u76f8\u673a\u957f\u65f6\u95f4\u65e0\u7ed3\u679c\u8f93\u51fa,\u8c03\u7528\u5f3a\u5236\u8bc6\u522b\u89e6\u53d15\u79d2\u540e\u4ecd\u7136\u6ca1\u7ed3\u679c\u8f93\u51fa, \u8fd9\u5c06\u65ad\u5f00\u4e0e\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "]\u8fde\u63a5"));
                                            session.close(true);
                                        }
                                    } else {
                                        session.close(true);
                                    }
                                }
                            }
                        }

                        public void waitCompleteTimeout() {
                        }
                    });
                    try {
                        Integer ax = (Integer)QLMCameraTool.softTrigger(connIp).get(4000L, TimeUnit.MILLISECONDS);
                        if (ax == null || ax != 0) {
                            throw new Exception();
                        }
                        QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    }
                    catch (Exception ex) {
                        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)callx);
                        QLMCameraAction.this.softTriggerQueue.remove(callx);
                        session.close(true);
                        ServiceLog.getLog().error((Object)("\u8c03\u7528\u8f6f\u4ef6\u89e6\u53d1\u8bc6\u522b\u68c0\u6d4b\u8fde\u63a5\u64cd\u4f5c\u5931\u8d25, \u8fd9\u5c06\u65ad\u5f00\u4e0e\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "]\u8fde\u63a5"));
                        return;
                    }
                }
                if (currentMills - QLMCameraAction.this.latestedOpSuccessMills >= 3000L) {
                    try {
                        String v = (String)QLMCameraTool.getDeviceSn(connIp).get(4000L, TimeUnit.MILLISECONDS);
                        if (v == null || v.length() == 0) {
                            throw new Exception();
                        }
                        QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        this.cameraSn = v;
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)("\u8c03\u7528\u83b7\u53d6\u8bbe\u5907\u5e8f\u5217\u53f7\u68c0\u6d4b\u8fde\u63a5\u64cd\u4f5c\u5931\u8d25, \u8fd9\u5c06\u65ad\u5f00\u4e0e\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + QLMCameraAction.this.equipment.getIp() + "]\u8fde\u63a5"));
                        session.close(true);
                        return;
                    }
                }
                QLMCameraAction.this.connectIfNotConnected1(false, this.cameraIp);
                this.checkGpioJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkGpioJob() {
            Integer ioOp1 = QLMCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
            Integer ioOp2 = QLMCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO2");
            boolean checkIo1 = false;
            boolean checkIo2 = false;
            if (ioOp1 != null && ioOp1 == 4) {
                checkIo1 = true;
            }
            if (ioOp2 != null) {
                if (ioOp2 == 1 || ioOp2 == 2 || ioOp2 == 3) {
                    checkIo2 = true;
                } else if (ioOp2 == 5 && ServiceUtil.getServiceContext().getFirefightingJob() != null) {
                    checkIo2 = true;
                }
            }
            if (checkIo1 || checkIo2) {
                if (this.getIoSateJobTask == null) {
                    TaskRunner taskRunner = this;
                    synchronized (taskRunner) {
                        if (this.getIoSateJobTask == null && !this.stopped) {
                            this.getIoSateJobTask = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(this.newGpioJob(), 1000L, 500L, TimeUnit.MILLISECONDS);
                        }
                    }
                }
            } else if (this.getIoSateJobTask != null) {
                TaskRunner taskRunner = this;
                synchronized (taskRunner) {
                    if (this.getIoSateJobTask != null) {
                        this.getIoSateJobTask.cancel(true);
                        this.getIoSateJobTask = null;
                    }
                }
            }
        }

        Runnable newGpioJob() {
            return new Runnable(){
                private long nextQueryTimlls1;
                private long nextQueryTimlls2;

                private void doRunx2() {
                    long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    if (currentMills < this.nextQueryTimlls2) {
                        return;
                    }
                    boolean ioInputIndex = true;
                    Integer ioOp = QLMCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO2");
                    if (ioOp == null) {
                        return;
                    }
                    final int ioOpValue = ioOp;
                    if (ioOpValue != 1 && ioOpValue != 2 && ioOpValue != 3 && ioOpValue != 5) {
                        QLMCameraAction.this.startCheckOpenPole = false;
                        return;
                    }
                    if (ioOpValue == 5) {
                        QLMCameraAction.this.startCheckOpenPole = false;
                        if (ServiceUtil.getServiceContext().getFirefightingJob() == null) {
                            return;
                        }
                    }
                    this.nextQueryTimlls2 = currentMills + 6000L;
                    QLMCameraTool.getInputGPIOValue(QLMCameraAction.this.equipment.getIp(), 1).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void waitCompleteTimeout() {
                        }

                        public void operationComplete(OperationFuture<Integer> f) {
                            long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                            nextQueryTimlls2 = c1;
                            if (f.getException() != null) {
                                ServiceLog.getLog().warn((Object)("[" + QLMCameraAction.this.equipment.getIp() + "] \u67e5\u8be2Io2\u72b6\u6001\u5f02\u5e38\uff01 \u539f\u56e0: " + f.getException().getMessage()));
                            } else if (f.getResult() != null && ((Integer)f.getResult() == 0 || (Integer)f.getResult() == 1)) {
                                QLMCameraAction.this.latestedOpSuccessMills = c1;
                                if (ioOpValue == 1 || ioOpValue == 2 || ioOpValue == 3) {
                                    QLMCameraAction.this.handleGateState(ioOpValue, (Integer)f.getResult());
                                } else if (ioOpValue == 5) {
                                    QLMCameraAction.this.handleFirefighting(ioOpValue, (Integer)f.getResult());
                                }
                            }
                        }
                    });
                }

                private void doRunx1() {
                    long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    if (currentMills < this.nextQueryTimlls1) {
                        return;
                    }
                    boolean ioInputIndex = false;
                    Integer ioOp = QLMCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
                    if (ioOp == null) {
                        return;
                    }
                    final int ioOpValue = ioOp;
                    if (ioOpValue != 4) {
                        QLMCameraAction.this.startCheckOpenPole = false;
                        return;
                    }
                    this.nextQueryTimlls1 = currentMills + 6000L;
                    QLMCameraTool.getInputGPIOValue(QLMCameraAction.this.equipment.getIp(), 0).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void waitCompleteTimeout() {
                        }

                        public void operationComplete(OperationFuture<Integer> f) {
                            long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                            nextQueryTimlls1 = c1;
                            if (f.getException() != null) {
                                ServiceLog.getLog().warn((Object)("[" + QLMCameraAction.this.equipment.getIp() + "] \u67e5\u8be2Io1\u72b6\u6001\u5f02\u5e38\uff01 \u539f\u56e0: " + f.getException().getMessage()));
                            } else if (f.getResult() != null && ((Integer)f.getResult() == 0 || (Integer)f.getResult() == 1)) {
                                QLMCameraAction.this.latestedOpSuccessMills = c1;
                                if (ioOpValue == 4) {
                                    int ioValue = (Integer)f.getResult();
                                    if (ioValue == 1) {
                                        if (!QLMCameraAction.this.groundPressure) {
                                            QLMCameraAction.this.groundPressure = true;
                                            QLMCameraAction.this.groundPressureMills = c1;
                                            QLMCameraAction.this.startCheckOpenPole = false;
                                            List<String> channelNos = QLMCameraAction.this.equipment.getChannelNos();
                                            if (channelNos != null && !channelNos.isEmpty()) {
                                                VehicleDetectorEvent event = new VehicleDetectorEvent(QLMCameraAction.this.equipment, 0, 1, channelNos.get(0));
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                            }
                                        }
                                    } else if (ioValue == 0 && QLMCameraAction.this.groundPressure) {
                                        QLMCameraAction.this.groundPressure = false;
                                        QLMCameraAction.this.groundReleaseMills = c1;
                                        QLMCameraAction.this.poleOpenedMills = 0L;
                                        QLMCameraAction.this.startCheckOpenPole = true;
                                        List<String> channelNos = QLMCameraAction.this.equipment.getChannelNos();
                                        if (channelNos != null && !channelNos.isEmpty()) {
                                            VehicleDetectorEvent event = new VehicleDetectorEvent(QLMCameraAction.this.equipment, 0, 0, channelNos.get(0));
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                        }
                                    }
                                } else {
                                    QLMCameraAction.this.startCheckOpenPole = false;
                                }
                            }
                        }
                    });
                }

                @Override
                public void run() {
                    if (!TaskRunner.this.isConnected()) {
                        return;
                    }
                    if (QLMCameraAction.this.getPassChannel() == null) {
                        return;
                    }
                    if (QLMCameraAction.this.equipment.getUse() == 1) {
                        this.doRunx1();
                        this.doRunx2();
                    }
                }
            };
        }

        OperationFuture<IoSession> connect(final String connIp) {
            this.connectingMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.cameraIp = connIp;
            final OperationFutureHandler returnFuture = ServiceUtil.getServiceContext().createOperationFuture();
            QLMCameraTool.getDeviceSn(connIp).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<String>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(OperationFuture<String> futrue) {
                    TaskRunner taskRunner = TaskRunner.this;
                    synchronized (taskRunner) {
                        if (!returnFuture.isCancelled()) {
                            if (futrue.isCancelled()) {
                                TaskRunner.this.connectingMills = 0L;
                                ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + connIp + "]\u5931\u8d25, \u83b7\u53d6\u76f8\u673aSN\u5931\u8d25"));
                                returnFuture.setException((Throwable)new ConnectException("\u83b7\u53d6\u76f8\u673aSN\u5931\u8d25"));
                            } else if (futrue.getException() != null) {
                                TaskRunner.this.connectingMills = 0L;
                                ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + connIp + "]\u5931\u8d25, \u83b7\u53d6\u76f8\u673aSN\u5931\u8d25, " + futrue.getException()));
                                returnFuture.setException(futrue.getException());
                            } else {
                                String sn = (String)futrue.getResult();
                                if (sn != null && sn.length() > 0) {
                                    TaskRunner.this.cameraSn = sn;
                                    if (!sn.equals(QLMCameraAction.this.cameraBlackWhiteSn)) {
                                        QLMCameraAction.this.cameraBlackWhiteList = null;
                                        QLMCameraAction.this.cameraBlackWhiteSn = null;
                                    }
                                    QLMCameraTool.getCheduiMode(connIp).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                        public void waitCompleteTimeout() {
                                        }

                                        public void operationComplete(OperationFuture<Integer> f6) {
                                            if (!(f6.isCancelled() || f6.getException() != null || f6.getResult() == null || (Integer)f6.getResult() != 0 && (Integer)f6.getResult() != 1)) {
                                                PassChannel passChannel;
                                                List<String> channelNos;
                                                Collection<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
                                                if (eqs != null && (channelNos = QLMCameraAction.this.equipment.getChannelNos()) != null && !channelNos.isEmpty()) {
                                                    for (Equipment e : eqs) {
                                                        if (e.getParentEquipmentNo() == null || !QLMCameraAction.this.equipment.getEquipmentNo().equals(e.getParentEquipmentNo()) || !(e.getEquipmentAction() instanceof ICECameraRoadGateAction)) continue;
                                                        ((ICECameraRoadGateAction)e.getEquipmentAction()).setAlwaysOpenValue((Integer)f6.getResult() == 1);
                                                    }
                                                }
                                                if ((Integer)f6.getResult() == 1 && (passChannel = QLMCameraAction.this.getPassChannel()) != null) {
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + " \u5f53\u524d\u5904\u4e8e\u8f66\u961f\u5e38\u5f00\u6a21\u5f0f", 2, 15000));
                                                }
                                                TaskRunner.this.connectRegPlate(connIp, 8865, (OperationFutureHandler<IoSession>)returnFuture);
                                            }
                                        }
                                    });
                                } else {
                                    TaskRunner.this.connectingMills = 0L;
                                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + connIp + "]\u5931\u8d25, \u83b7\u53d6\u76f8\u673aSN\u5931\u8d25,\u8fd4\u56de\u7a7a\u5b57\u7b26\u4e32"));
                                    returnFuture.setException((Throwable)new ConnectException("\u83b7\u53d6\u76f8\u673aSN\u5931\u8d25, \u76f8\u673a\u8fd4\u56de\u7a7a\u5b57\u7b26"));
                                }
                            }
                        }
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
            return returnFuture;
        }

        void connectRegPlate(final String ip, int port, final OperationFutureHandler<IoSession> returnFutrue) {
            try {
                ConnectFuture connectFuture9 = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, port));
                connectFuture9.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(ConnectFuture future) {
                        if (future.isConnected()) {
                            IoSession session;
                            try {
                                session = future.getSession();
                            }
                            catch (Throwable ex) {
                                session = null;
                            }
                            TaskRunner taskRunner = TaskRunner.this;
                            synchronized (taskRunner) {
                                if (session == null) {
                                    TaskRunner.this.connectingMills = 0L;
                                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + ip + "]\u5931\u8d25"));
                                    returnFutrue.setException((Throwable)new ConnectException("connect failed"));
                                } else {
                                    IoSession session0 = TaskRunner.this.iosession;
                                    if (session0 != null && session0 != session && session0.isConnected()) {
                                        session0.close(true);
                                    }
                                    session.setAttribute((Object)QLMCameraAction.DataPacketParserKey, (Object)new QLMCameraTool.DataPacketParser());
                                    if (QLMCameraAction.this.cameraMessageIoHandler == null) {
                                        QLMCameraAction.this.cameraMessageIoHandler = QLMCameraAction.this.createCameraMessageIoHandler();
                                    }
                                    session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)QLMCameraAction.this.cameraMessageIoHandler);
                                    QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                    TaskRunner.this.iosession = session;
                                    TaskRunner.this.connectingMills = 0L;
                                    TaskRunner.this.connectFuture = null;
                                    returnFutrue.setResult((Object)session);
                                    TaskRunner.this.doConnectSuccess(ip);
                                }
                            }
                            QLMCameraAction.this.connectIfNotConnected1(false, TaskRunner.this.cameraIp);
                        } else if (!returnFutrue.isDone()) {
                            Throwable tx = future.getException();
                            if (tx != null) {
                                TaskRunner.this.connectingMills = 0L;
                                ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + ip + "]\u5931\u8d25,  " + tx));
                                returnFutrue.setException(tx);
                            } else {
                                TaskRunner.this.connectingMills = 0L;
                                ServiceLog.getLog().error((Object)("\u8fde\u63a5\u76f8\u673a" + QLMCameraAction.this.equipment.getName() + "[" + ip + "]\u5931\u8d25"));
                                returnFutrue.setException((Throwable)new ConnectException("connect failed"));
                            }
                        }
                    }
                });
            }
            catch (Throwable ex) {
                returnFutrue.setException(ex);
            }
        }

        void doConnectSuccess(final String ip) {
            final long sendT = ServiceUtil.getServiceContext().currentTimeMillis();
            QLMCameraTool.getDeviceDateTime(ip).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Date>(){

                public void operationComplete(OperationFuture<Date> futrue) {
                    if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null) {
                        QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        long c = (ServiceUtil.getServiceContext().currentTimeMillis() - sendT) / 2L;
                        long cameraMills = ((Date)futrue.getResult()).getTime() + c;
                        long nowMills = new Date().getTime();
                        long abs = Math.abs(nowMills - cameraMills);
                        if (abs >= 2000L) {
                            TaskRunner.this.setCameraTime(ip, new Date(nowMills + c));
                        } else {
                            TaskRunner.this.setOSD(ip);
                        }
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
            this.checkGpioJob();
        }

        private void setCameraTime(final String ip, Date date) {
            QLMCameraTool.setDeviceDateTime(ip, date).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void operationComplete(OperationFuture<Integer> futrue) {
                    if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null && (Integer)futrue.getResult() == 0) {
                        QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        TaskRunner.this.setOSD(ip);
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
        }

        private void setOSD(final String ip) {
            PassChannel channel = QLMCameraAction.this.getPassChannel();
            String channeName = null;
            if (channel != null) {
                channeName = ServiceUtil.getString(channel.getChannel().getChannel_name(), 60, "GBK");
            }
            final String channeName0 = channeName;
            if (channeName != null && channeName.length() > 0) {
                QLMCameraTool.getOsdTextConfig(ip).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<QLMCameraTool.OsdText>(){

                    public void operationComplete(OperationFuture<QLMCameraTool.OsdText> futrue) {
                        if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null) {
                            QLMCameraAction.this.latestedOpSuccessMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            QLMCameraTool.OsdText osdText = QLMCameraTool.OsdText.createOsdText(channeName0);
                            if (!osdText.equals(futrue.getResult())) {
                                OperationFuture<Integer> of = QLMCameraTool.setOsdTextConfig(ip, osdText);
                                QLMCameraAction.this.setOpLog((OperationFuture<Integer>)of, "\u8bbe\u7f6e\u89c6\u9891OSD\u5b57\u7b26\u53e0\u52a0");
                            }
                        }
                    }

                    public void waitCompleteTimeout() {
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnect() {
            TaskRunner taskRunner = this;
            synchronized (taskRunner) {
                IoSession session;
                boolean connected;
                OperationFuture<IoSession> connectFuture0 = this.connectFuture;
                if (connectFuture0 != null && !connectFuture0.isDone()) {
                    connectFuture0.cancel(true);
                }
                boolean bl = connected = (session = this.iosession) != null && session.isConnected() && !session.isClosing();
                if (connected) {
                    session.close(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            TaskRunner taskRunner = this;
            synchronized (taskRunner) {
                if (this.stopped) {
                    return;
                }
                this.stopped = true;
                if (this.getIoSateJobTask != null) {
                    this.getIoSateJobTask.cancel(true);
                    this.getIoSateJobTask = null;
                }
            }
            this.disconnect();
        }
    }
}

