/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CancelAdvice;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

public class QLMCameraTool {
    public static final int CONTROL_PORT = 8862;
    public static final int IO_1 = 1;
    public static final int IO_2 = 2;
    public static final int OUTPUT_IO_AUTO_CLOSE = 0;
    public static final int OUTPUT_IO_OPEN = 1;
    public static final int OUTPUT_IO_CLOSE = 2;
    public static final int SERIAL_PORT_1 = 0;
    public static final int SERIAL_PORT_2 = 1;
    private static final AtomicInteger seq = new AtomicInteger(0);

    public static OperationFuture<String> getDeviceSn(String ip) {
        DataPacket sendPacket = new DataPacket();
        byte[] byArray = new byte[2];
        byArray[1] = 16;
        sendPacket.cmd = byArray;
        sendPacket.cmdType = (byte)15;
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new BasicReadCallback<String>(){

            @Override
            protected String handleRevData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<String> returnFutrue) throws Exception {
                int gLeng = 16;
                if (revPacket.length >= gLeng) {
                    return QLMCameraTool.getString(revPacket.data, revPacket.dataOffset, 16);
                }
                return null;
            }
        });
    }

    public static OperationFuture<Device> getDeviceInfo(String ip) {
        DataPacket sendPacket = new DataPacket();
        byte[] byArray = new byte[2];
        byArray[1] = 16;
        sendPacket.cmd = byArray;
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new BasicReadCallback<Device>(){

            @Override
            protected Device handleRevData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<Device> returnFutrue) throws Exception {
                int gLeng = 184;
                if (revPacket.length >= gLeng) {
                    Device device = new Device();
                    int offset = revPacket.dataOffset;
                    device.type = QLMCameraTool.getString(revPacket.data, offset, 32);
                    device.mac = QLMCameraTool.getString(revPacket.data, offset += 32, 18);
                    offset += 18;
                    device.sn = QLMCameraTool.getString(revPacket.data, offset += 6, 32);
                    offset += 32;
                    device.softVer = QLMCameraTool.getString(revPacket.data, offset += 32, 32);
                    device.algVer = QLMCameraTool.getString(revPacket.data, offset += 32, 32);
                    return device;
                }
                return null;
            }
        });
    }

    public static OperationFuture<Date> getDeviceDateTime(String ip) {
        DataPacket sendPacket = new DataPacket();
        byte[] byArray = new byte[2];
        byArray[1] = 64;
        sendPacket.cmd = byArray;
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new BasicReadCallback<Date>(){

            @Override
            protected Date handleRevData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<Date> returnFutrue) throws Exception {
                int gLeng = 24;
                if (revPacket.length >= gLeng) {
                    int offset = revPacket.dataOffset;
                    int year = BytesTool.bytesToIntL((byte[])revPacket.data, (int)offset);
                    int month1_12 = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 4));
                    int day = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 4));
                    int hourOfDay = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 4));
                    int minute = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 4));
                    int second = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 4));
                    Calendar cl = Calendar.getInstance();
                    cl.set(14, 0);
                    cl.set(year, month1_12 - 1, day, hourOfDay, minute, second);
                    return cl.getTime();
                }
                return null;
            }
        });
    }

    public static OperationFuture<Integer> setDeviceDateTime(String ip, Date dateTime) {
        Calendar cl = Calendar.getInstance();
        if (dateTime != null) {
            cl.setTime(dateTime);
        }
        int year = cl.get(1);
        int month1_12 = cl.get(2) + 1;
        int day = cl.get(5);
        int hour = cl.get(11);
        int mins = cl.get(12);
        int secs = cl.get(13);
        byte[] data = new byte[24];
        ByteBuffer dataBuf = ByteBuffer.wrap(data);
        dataBuf.order(ByteOrder.LITTLE_ENDIAN);
        dataBuf.putInt(year);
        dataBuf.putInt(month1_12);
        dataBuf.putInt(day);
        dataBuf.putInt(hour);
        dataBuf.putInt(mins);
        dataBuf.putInt(secs);
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{1, 64};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.length = data.length;
        sendPacket.data = data;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> getInputGPIOValue(String ip, int inputIoPort) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{7, 96};
        byte[] byArray = new byte[4];
        byArray[0] = (byte)inputIoPort;
        sendPacket.subCmd = byArray;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> setOutputGPIOValue(String ip, int outputIoPort, int type) {
        int value = outputIoPort == 2 ? (type == 1 ? 3 : (type == 2 ? 5 : 1)) : (type == 1 ? 2 : (type == 2 ? 4 : 0));
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{4, 96};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.length = 4;
        byte[] byArray = new byte[4];
        byArray[0] = (byte)value;
        sendPacket.data = byArray;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> softTrigger(String ip) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{10, 112};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<SerialPortConfig> getSerialPortConfig(String ip, int serialPortIndex) {
        DataPacket sendPacket = new DataPacket();
        byte[] byArray = new byte[2];
        byArray[1] = 97;
        sendPacket.cmd = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = (byte)(serialPortIndex + 1);
        sendPacket.subCmd = byArray2;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new BasicReadCallback<SerialPortConfig>(){

            @Override
            protected SerialPortConfig handleRevData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<SerialPortConfig> returnFutrue) throws Exception {
                return SerialPortConfig.parse(revPacket.data, revPacket.dataOffset, revPacket.length);
            }
        });
    }

    public static OperationFuture<Integer> setSerialPortConfig(String ip, SerialPortConfig config) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{1, 97};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.data = config.toDataBytes();
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> enableRs485Transparent(String ip, int serialPortIndex, boolean enable) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{6, 97};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        byte[] data = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(serialPortIndex);
        buf.putInt(enable ? 1 : 0);
        sendPacket.data = data;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> sendSerialData(String ip, int serialPortIndex, byte[] data) {
        return QLMCameraTool.sendSerialData(ip, serialPortIndex, data, 0, data.length);
    }

    public static OperationFuture<Integer> sendSerialData(String ip, int serialPortIndex, byte[] data, int offset, int length) {
        byte[] datax = new byte[length + 12];
        ByteBuffer buf = ByteBuffer.wrap(datax);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(serialPortIndex);
        buf.putInt(length);
        buf.putInt(seq.incrementAndGet());
        System.arraycopy(data, offset, datax, 12, length);
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{5, 97};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.data = datax;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> getCheduiMode(String ip) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{5, 96};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> enableCheduiMode(String ip, boolean enable) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{6, 96};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        byte a = enable ? (byte)1 : 0;
        byte[] byArray = new byte[4];
        byArray[0] = a;
        sendPacket.data = byArray;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<OsdText> getOsdTextConfig(String ip) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{6, 80};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new BasicReadCallback<OsdText>(){

            @Override
            protected OsdText handleRevData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<OsdText> returnFutrue) throws Exception {
                return OsdText.parse(revPacket.data, revPacket.dataOffset, revPacket.length);
            }
        });
    }

    public static OperationFuture<Integer> setOsdTextConfig(String ip, OsdText osdText) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.cmd = new byte[]{7, 80};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.data = osdText.toDataBytes();
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 5000, new OperationReadCallback());
    }

    public static OperationFuture<CameraPlateList> queryBlackWhiteList(String ip, int pageNum, String plateNumber) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.cmd = new byte[]{6, 113};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        byte[] data = new byte[20];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(pageNum);
        if (plateNumber != null && plateNumber.length() > 0) {
            byte[] ax;
            try {
                ax = plateNumber.getBytes("GBK");
            }
            catch (Exception ex) {
                ax = plateNumber.getBytes();
            }
            int pLen = ax.length >= 16 ? 16 : ax.length;
            int i = 0;
            while (i < pLen) {
                buf.put(ax[i]);
                ++i;
            }
        }
        sendPacket.data = data;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 10000, new ReadCallback<CameraPlateList>(){

            @Override
            public CameraPlateList onReadData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<CameraPlateList> returnFutrue) throws Exception {
                int offset;
                int count;
                CameraPlateList pList = new CameraPlateList();
                pList.pageSize = 20;
                pList.pageNum = BytesTool.bytesToIntL((byte[])sendPacket.data, (int)sendPacket.dataOffset);
                if (revPacket.length >= 16 && (count = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset = revPacket.dataOffset))) > 0) {
                    int aRecordLen;
                    int recordLength;
                    pList.count = count;
                    int num = BytesTool.bytesToIntL((byte[])revPacket.data, (int)(offset += 8));
                    offset += 8;
                    if (num > 0 && num <= pList.pageSize && (recordLength = num * (aRecordLen = 176)) <= revPacket.length - 16) {
                        pList.list = new ArrayList<CameraPlate>(num);
                        int i = 0;
                        while (i < num) {
                            CameraPlate p = CameraPlate.parse(revPacket.data, offset, aRecordLen);
                            offset += aRecordLen;
                            if (p != null) {
                                pList.list.add(p);
                            }
                            ++i;
                        }
                    }
                }
                return pList;
            }
        });
    }

    public static OperationFuture<CameraPlate> addBlackWhiteListOne(String ip, CameraPlate cameraPlate) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        byte[] byArray = new byte[2];
        byArray[1] = 113;
        sendPacket.cmd = byArray;
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.data = cameraPlate.toBytes();
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 8000, new ReadCallback<CameraPlate>(){

            @Override
            public CameraPlate onReadData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<CameraPlate> returnFutrue) throws Exception {
                if (revPacket.length > 172) {
                    return CameraPlate.parse(revPacket.data, revPacket.dataOffset, revPacket.length);
                }
                return null;
            }
        });
    }

    public static OperationFuture<Integer> delBlackWhiteListById(String ip, long id) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.cmd = new byte[]{2, 113};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        byte[] data = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(id);
        sendPacket.data = data;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 8000, new OperationReadCallback());
    }

    public static OperationFuture<CameraPlate> queyBlackWhiteListByPlate(String ip, String plateNumber) {
        byte[] pateD;
        if (plateNumber == null || plateNumber.length() == 0) {
            OperationFutureHandler returnFutrue0 = ServiceUtil.getServiceContext().createOperationFuture();
            returnFutrue0.setResult(null);
            return returnFutrue0;
        }
        try {
            pateD = plateNumber.getBytes("GBK");
        }
        catch (Exception ex) {
            OperationFutureHandler returnFutrue0 = ServiceUtil.getServiceContext().createOperationFuture();
            returnFutrue0.setException((Throwable)ex);
            return returnFutrue0;
        }
        if (pateD.length > 16) {
            OperationFutureHandler returnFutrue0 = ServiceUtil.getServiceContext().createOperationFuture();
            returnFutrue0.setResult(null);
            return returnFutrue0;
        }
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.cmd = new byte[]{5, 113};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        byte[] data = new byte[16];
        System.arraycopy(pateD, 0, data, 0, pateD.length);
        sendPacket.data = data;
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 8000, new ReadCallback<CameraPlate>(){

            @Override
            public CameraPlate onReadData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<CameraPlate> returnFutrue) throws Exception {
                if (revPacket.length > 172) {
                    return CameraPlate.parse(revPacket.data, revPacket.dataOffset, revPacket.length);
                }
                return null;
            }
        });
    }

    public static OperationFuture<Integer> updateBlackWhiteList(String ip, CameraPlate plate) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.cmd = new byte[]{4, 113};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        sendPacket.data = plate.toBytes();
        sendPacket.length = sendPacket.data.length;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 8000, new OperationReadCallback());
    }

    public static OperationFuture<Integer> clearAllBlackWhiteList(String ip) {
        DataPacket sendPacket = new DataPacket();
        sendPacket.head = DataPacket.HEAD_0;
        sendPacket.cmd = new byte[]{3, 113};
        sendPacket.subCmd = DataPacket.NOSUBCMD;
        return QLMCameraTool.doAction(ip, 8862, sendPacket, 14000, new OperationReadCallback());
    }

    static <T> OperationFuture<T> doAction(String ip, int port, DataPacket sendPacket, int waitResposeTimeoutMills, ReadCallback<T> callback) {
        OperationFutureHandler returnFutrue0 = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (sendPacket == null) {
                returnFutrue0.setException((Throwable)new NullPointerException("sendPacket is null"));
                return returnFutrue0;
            }
            if (callback == null) {
                returnFutrue0.setException((Throwable)new NullPointerException("callback is null"));
                return returnFutrue0;
            }
            ConnectFuture connectFuture = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, port));
            final DataPacketV tv = new DataPacketV();
            tv.callback = callback;
            tv.sendPacket = sendPacket;
            tv.returnFutrue = returnFutrue0;
            tv.connectFuture = connectFuture;
            tv.waitResponseMills = waitResposeTimeoutMills <= 0 ? 5000 : waitResposeTimeoutMills;
            connectFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                public void operationComplete(ConnectFuture future) {
                    if (future.isConnected()) {
                        IoSession session;
                        try {
                            session = future.getSession();
                        }
                        catch (Throwable ex) {
                            session = null;
                        }
                        if (session == null) {
                            if (!tv.returnFutrue.isDone()) {
                                tv.returnFutrue.setException((Throwable)new ConnectException("connect failed"));
                            }
                        } else if (tv.returnFutrue.isDone()) {
                            session.close(true);
                        } else {
                            try {
                                session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)tv);
                                byte[] sendData = tv.sendPacket.toSendData();
                                if (sendData == null || sendData.length == 0) {
                                    throw new NullPointerException("send data null or length 0");
                                }
                                boolean success = ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)tv, (Object)tv, (TimeoutObjectPool.TimeoutCallback)tv, tv.waitResponseMills, TimeUnit.MILLISECONDS);
                                if (!success) {
                                    throw new IllegalStateException("add wait timeout pool failed");
                                }
                                tv.addedPool = true;
                                IoBuffer buf = IoBuffer.wrap((byte[])sendData);
                                WriteFuture wf = session.write((Object)buf);
                                wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                                    public void operationComplete(WriteFuture s) {
                                        if (s.isDone() && s.getException() != null) {
                                            try {
                                                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)tv);
                                            }
                                            finally {
                                                try {
                                                    if (s.getSession() != null && s.getSession().isConnected()) {
                                                        s.getSession().close(true);
                                                    }
                                                }
                                                finally {
                                                    tv.returnFutrue.setException(s.getException());
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Throwable ex) {
                                try {
                                    try {
                                        if (tv.addedPool) {
                                            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)tv);
                                        }
                                        session.removeAttribute((Object)"WOVOE_TCPCONNECTIOHANLER");
                                    }
                                    finally {
                                        if (session.isConnected()) {
                                            session.close(true);
                                        }
                                    }
                                }
                                finally {
                                    tv.returnFutrue.setException(ex);
                                }
                            }
                        }
                    } else if (!tv.returnFutrue.isDone()) {
                        Throwable tx = future.getException();
                        if (tx != null) {
                            tv.returnFutrue.setException(tx);
                        } else {
                            tv.returnFutrue.setException((Throwable)new ConnectException("connect failed"));
                        }
                    }
                }
            });
            returnFutrue0.setCancelAdvice(tv);
        }
        catch (Throwable ex) {
            returnFutrue0.setException(ex);
        }
        return returnFutrue0;
    }

    static String getString(byte[] bytes, int offset, int maxLength) {
        return QLMCameraTool.getString(bytes, offset, maxLength, "GBK");
    }

    static String getString(byte[] bytes, int offset, int maxLength, String charset) {
        int len = 0;
        int end = offset + maxLength;
        byte e = 0;
        int i = offset;
        while (i < end) {
            if (bytes[i] == e) break;
            ++len;
            ++i;
        }
        if (len == 0) {
            return "";
        }
        if (charset == null || charset.length() == 0) {
            return new String(bytes, offset, len);
        }
        try {
            return new String(bytes, offset, len, charset);
        }
        catch (UnsupportedEncodingException e1) {
            return new String(bytes, offset, len);
        }
    }

    protected static abstract class BasicReadCallback<T>
    implements ReadCallback<T> {
        protected BasicReadCallback() {
        }

        @Override
        public T onReadData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<T> returnFutrue) throws Exception {
            if (!Arrays.equals(sendPacket.head, revPacket.head)) {
                throw new IOException("Response header error, does not match what was sent");
            }
            if (!revPacket.isResponse()) {
                throw new IOException("Response frame identification error");
            }
            if (!revPacket.isCmdEquealsRequest(sendPacket.cmd, sendPacket.reserve, sendPacket.cmdType)) {
                throw new IOException("Response cmd error, does not match what was sent");
            }
            return this.handleRevData(sendPacket, revPacket, returnFutrue);
        }

        protected abstract T handleRevData(DataPacket var1, DataPacket var2, OperationFutureHandler<T> var3) throws Exception;
    }

    public static class CameraPlate {
        public static final int TYPE_WHITE_LIST = 0;
        public static final int TYPE_BLACK_LIST = 1;
        public long id;
        public String plate;
        public boolean enable;
        public int type;
        public long beginTime;
        public long endTime;
        public boolean useTimeSeg;
        public long createTime;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CameraPlate [id=");
            builder.append(this.id);
            builder.append(", plate=");
            builder.append(this.plate);
            builder.append(", enable=");
            builder.append(this.enable);
            builder.append(", type=");
            builder.append(this.type);
            builder.append(", beginTime=");
            builder.append(this.beginTime);
            builder.append(", endTime=");
            builder.append(this.endTime);
            builder.append(", useTimeSeg=");
            builder.append(this.useTimeSeg);
            builder.append(", createTime=");
            builder.append(this.createTime);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.beginTime ^ this.beginTime >>> 32);
            result = 31 * result + (int)(this.createTime ^ this.createTime >>> 32);
            result = 31 * result + (this.enable ? 1231 : 1237);
            result = 31 * result + (int)(this.endTime ^ this.endTime >>> 32);
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.plate == null ? 0 : this.plate.hashCode());
            result = 31 * result + this.type;
            result = 31 * result + (this.useTimeSeg ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CameraPlate other = (CameraPlate)obj;
            if (this.beginTime != other.beginTime) {
                return false;
            }
            if (this.createTime != other.createTime) {
                return false;
            }
            if (this.enable != other.enable) {
                return false;
            }
            if (this.endTime != other.endTime) {
                return false;
            }
            if (this.id != other.id) {
                return false;
            }
            if (this.plate == null ? other.plate != null : !this.plate.equals(other.plate)) {
                return false;
            }
            if (this.type != other.type) {
                return false;
            }
            return this.useTimeSeg == other.useTimeSeg;
        }

        public static CameraPlate parse(byte[] data, int offset, int length) {
            if (length == 0 || data == null || data.length < length) {
                return null;
            }
            if (length >= 172) {
                ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                CameraPlate plate = new CameraPlate();
                plate.id = buf.getLong();
                byte[] plateBytes = new byte[16];
                buf.get(plateBytes);
                plate.plate = QLMCameraTool.getString(plateBytes, 0, plateBytes.length);
                plate.createTime = (long)buf.getInt() & 0xFFFFFFFFL;
                plate.beginTime = (long)buf.getInt() & 0xFFFFFFFFL;
                plate.endTime = (long)buf.getInt() & 0xFFFFFFFFL;
                byte en = buf.get();
                plate.enable = en == 1;
                byte t = buf.get();
                plate.type = t == 1 ? 1 : 0;
                buf.get();
                buf.get();
                buf.getInt();
                buf.getInt();
                byte useS = buf.get();
                plate.useTimeSeg = useS == 1;
                return plate;
            }
            return null;
        }

        public byte[] toBytes() {
            byte[] data = new byte[176];
            ByteBuffer buf = ByteBuffer.wrap(data);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putLong(this.id);
            int pos = buf.position();
            if (this.plate != null && this.plate.length() > 0) {
                byte[] plateBytes;
                try {
                    plateBytes = this.plate.getBytes("GBK");
                }
                catch (Exception ex) {
                    plateBytes = this.plate.getBytes();
                }
                int len = plateBytes.length > 16 ? 16 : plateBytes.length;
                int i = 0;
                while (i < len) {
                    buf.put(plateBytes[i]);
                    ++i;
                }
            }
            buf.position(pos + 16);
            if (this.createTime == 0L) {
                this.createTime = (int)(System.currentTimeMillis() / 1000L);
            }
            buf.putInt((int)this.createTime);
            buf.putInt((int)this.beginTime);
            buf.putInt((int)this.endTime);
            if (this.enable) {
                buf.put((byte)1);
            } else {
                buf.put((byte)0);
            }
            if (this.type == 1) {
                buf.put((byte)1);
            } else {
                buf.put((byte)0);
            }
            buf.put((byte)0);
            buf.put((byte)0);
            buf.putInt(1);
            buf.putInt(1);
            buf.putInt(this.useTimeSeg ? 1 : 0);
            pos = buf.position();
            buf.position(pos + 84);
            buf.putInt(1);
            return data;
        }
    }

    public static class CameraPlateList {
        public int count;
        public int pageNum;
        public int pageSize;
        public List<CameraPlate> list;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CameraPlateList [count=");
            builder.append(this.count);
            builder.append(", pageNum=");
            builder.append(this.pageNum);
            builder.append(", pageSize=");
            builder.append(this.pageSize);
            builder.append(", list=");
            builder.append(this.list);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class DataPacket {
        public static final byte[] HEAD_0 = new byte[]{110, 97, 97, 100};
        public static final byte[] NOSUBCMD = new byte[4];
        public byte[] head;
        public byte[] cmd;
        public byte reserve;
        public byte cmdType;
        public int length;
        public byte[] subCmd;
        public byte[] data;
        public int dataOffset;

        public boolean isResponse() {
            return (this.cmdType & 0xF0) == 240;
        }

        public boolean isCmdEquealsRequest(byte[] requestCmd, byte requestReserve, byte requestCmdType) {
            return this.cmd[0] == requestCmd[0] && this.cmd[1] == requestCmd[1] && this.reserve == requestReserve && (this.cmdType & 0xF) == requestCmdType;
        }

        public byte[] toSendData() {
            byte[] rBytes = new byte[16 + this.length];
            int offset = 0;
            System.arraycopy(this.head, 0, rBytes, offset, this.head.length);
            System.arraycopy(this.cmd, 0, rBytes, offset += this.head.length, this.cmd.length);
            offset += this.cmd.length;
            rBytes[offset++] = this.reserve;
            rBytes[offset++] = this.cmdType;
            byte[] lenBytes = BytesTool.intToBytesL((int)this.length);
            System.arraycopy(lenBytes, 0, rBytes, offset, lenBytes.length);
            System.arraycopy(this.subCmd, 0, rBytes, offset += lenBytes.length, this.subCmd.length);
            offset += this.subCmd.length;
            if (this.length > 0) {
                System.arraycopy(this.data, this.dataOffset, rBytes, offset, this.length);
            }
            return rBytes;
        }
    }

    public static class DataPacketParser {
        private volatile int revState = 0;
        private volatile int tempOffset = 0;
        private volatile DataPacket revPacket;
        private static final int MAXBytes = 0x500000;
        private volatile long revMills;
        private long readTimeoutMills = 5000L;
        private volatile long latestRevMills;

        public synchronized boolean isReadTimeout() {
            return this.revMills > 0L && ServiceUtil.getServiceContext().currentTimeMillis() - this.revMills >= this.readTimeoutMills;
        }

        public long getLatestRevMills() {
            return this.latestRevMills;
        }

        public void setReadTimeoutMills(long mills) {
            this.readTimeoutMills = mills;
        }

        public synchronized DataPacket parsePacket(IoBuffer buf) throws IOException {
            this.latestRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
            while (buf.hasRemaining()) {
                byte b = buf.get();
                if (this.revState == 0) {
                    if (this.tempOffset == 0) {
                        this.revPacket = new DataPacket();
                        this.revMills = this.latestRevMills;
                    }
                    if (this.tempOffset == 0 && this.revPacket.head == null) {
                        this.revPacket.head = new byte[4];
                    }
                    this.revPacket.head[this.tempOffset++] = b;
                    if (this.revPacket.head.length != this.tempOffset) continue;
                    this.revState = 1;
                    this.tempOffset = 0;
                    continue;
                }
                if (this.revState == 1) {
                    if (this.tempOffset == 0 && this.revPacket.cmd == null) {
                        this.revPacket.cmd = new byte[2];
                    }
                    this.revPacket.cmd[this.tempOffset++] = b;
                    if (this.tempOffset != this.revPacket.cmd.length) continue;
                    this.revState = 2;
                    this.tempOffset = 0;
                    continue;
                }
                if (this.revState == 2) {
                    this.revPacket.reserve = b;
                    this.revState = 3;
                    this.tempOffset = 0;
                    continue;
                }
                if (this.revState == 3) {
                    this.revPacket.cmdType = b;
                    this.revState = 4;
                    this.tempOffset = 0;
                    continue;
                }
                if (this.revState == 4) {
                    if (this.tempOffset == 0 && this.revPacket.subCmd == null) {
                        this.revPacket.subCmd = new byte[4];
                    }
                    this.revPacket.subCmd[this.tempOffset++] = b;
                    if (this.tempOffset != this.revPacket.subCmd.length) continue;
                    this.revPacket.length = BytesTool.bytesToIntL((byte[])this.revPacket.subCmd);
                    if (this.revPacket.length > 0x500000 || this.revPacket.length < 0) {
                        this.revState = 0;
                        this.tempOffset = 0;
                        this.revMills = 0L;
                        throw new IOException("Parse error, Received data length is too large, Package length: " + this.revPacket.length);
                    }
                    this.revState = 5;
                    this.tempOffset = 0;
                    continue;
                }
                if (this.revState == 5) {
                    if (this.tempOffset == 0 && this.revPacket.subCmd == null) {
                        this.revPacket.subCmd = new byte[4];
                    }
                    this.revPacket.subCmd[this.tempOffset++] = b;
                    if (this.tempOffset != this.revPacket.subCmd.length) continue;
                    if (this.revPacket.length > 0) {
                        this.revPacket.data = new byte[this.revPacket.length];
                        this.revState = 6;
                        this.tempOffset = 0;
                        continue;
                    }
                    this.revState = 100;
                    this.tempOffset = 0;
                    break;
                }
                if (this.revState != 6) continue;
                this.revPacket.data[this.tempOffset++] = b;
                if (this.tempOffset != this.revPacket.length) continue;
                this.revState = 100;
                this.tempOffset = 0;
                break;
            }
            if (this.revState == 100 && this.revPacket != null) {
                this.revMills = 0L;
                this.revState = 0;
                this.tempOffset = 0;
                DataPacket r = this.revPacket;
                this.revPacket = null;
                return r;
            }
            return null;
        }
    }

    private static class DataPacketV<T>
    extends IoHandlerAdapter
    implements TimeoutObjectPool.TimeoutCallback,
    CancelAdvice {
        DataPacket sendPacket;
        ReadCallback<T> callback;
        IoSession session;
        OperationFutureHandler<T> returnFutrue;
        ConnectFuture connectFuture;
        long waitResponseMills;
        boolean addedPool;
        DataPacketParser dataPacketParser;

        private DataPacketV() {
        }

        public void onTimeout(Object key, Object value) throws Exception {
            try {
                if (this.session != null && this.session.isConnected()) {
                    this.session.close(true);
                }
            }
            finally {
                if (this.returnFutrue != null) {
                    this.returnFutrue.setException((Throwable)new TimeoutException("Wait response timeout"));
                }
            }
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            block17: {
                if (message instanceof IoBuffer) {
                    try {
                        DataPacket packet;
                        IoBuffer buf = (IoBuffer)message;
                        if (this.dataPacketParser == null) {
                            this.dataPacketParser = new DataPacketParser();
                        }
                        if ((packet = this.dataPacketParser.parsePacket(buf)) == null) break block17;
                        Object result = this.callback != null ? this.callback.onReadData(this.sendPacket, packet, this.returnFutrue) : null;
                        try {
                            try {
                                try {
                                    if (this.addedPool) {
                                        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this);
                                    }
                                    if (session != null) {
                                        session.removeAttribute((Object)"WOVOE_TCPCONNECTIOHANLER");
                                    }
                                }
                                finally {
                                    if (session != null && session.isConnected()) {
                                        session.close(true);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (this.returnFutrue != null && !this.returnFutrue.isDone()) {
                                    this.returnFutrue.setResult(result);
                                }
                            }
                        }
                        finally {
                            if (this.returnFutrue != null && !this.returnFutrue.isDone()) {
                                this.returnFutrue.setResult(result);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        this.setErrorResult(ex);
                    }
                }
            }
        }

        public void cancel(boolean mayInterruptIfRunning) {
            if (this.connectFuture != null && !this.connectFuture.isDone()) {
                this.connectFuture.cancel();
            }
        }

        public void setErrorResult(Throwable ex) {
            try {
                try {
                    if (this.addedPool) {
                        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this);
                    }
                    if (this.session != null) {
                        this.session.removeAttribute((Object)"WOVOE_TCPCONNECTIOHANLER");
                    }
                }
                finally {
                    if (this.session != null && this.session.isConnected()) {
                        this.session.close(true);
                    }
                }
            }
            finally {
                if (this.returnFutrue != null && !this.returnFutrue.isDone()) {
                    this.returnFutrue.setException(ex);
                }
            }
        }
    }

    public static class Device {
        public String type;
        public String mac;
        public String sn;
        public String softVer;
        public String algVer;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Device [type=");
            builder.append(this.type);
            builder.append(", mac=");
            builder.append(this.mac);
            builder.append(", sn=");
            builder.append(this.sn);
            builder.append(", softVer=");
            builder.append(this.softVer);
            builder.append(", algVer=");
            builder.append(this.algVer);
            builder.append("]");
            return builder.toString();
        }
    }

    protected static class OperationReadCallback
    implements ReadCallback<Integer> {
        private int dataLength;

        public OperationReadCallback() {
            this(4);
        }

        public OperationReadCallback(int dataLength) {
            this.dataLength = dataLength;
        }

        @Override
        public Integer onReadData(DataPacket sendPacket, DataPacket revPacket, OperationFutureHandler<Integer> returnFutrue) throws Exception {
            if (revPacket.length == this.dataLength) {
                if (this.dataLength == 0) {
                    return 0;
                }
                if (this.dataLength == 4) {
                    return BytesTool.bytesToIntL((byte[])revPacket.data, (int)revPacket.dataOffset);
                }
            }
            return -9;
        }
    }

    public static class OsdText {
        public static final int OSD_TYPE_DATE_Y_M_D = 1;
        public static final int OSD_TYPE_DATE_M_D_Y = 2;
        public static final int OSD_TYP_EDATE_D_M_Y = 3;
        public static final int OSD_TYP_EDATE_YMD = 4;
        public static final int OSD_TYP_EDATE_MDY = 5;
        public static final int OSD_TYP_EDATE_DMY = 6;
        public static final int OSD_TYPE_TIME_12H = 1;
        public static final int OSD_TYPE_TIME_24H = 2;
        public int dateEnable;
        public int dateFormat;
        public int datePosX;
        public int datePosY;
        public int timeEnable;
        public int timeFormat;
        public int timePosX;
        public int timePosY;
        public int textEnable;
        public int textPositionX;
        public int textPositionY;
        public String text;

        public static OsdText createOsdText(String t) {
            OsdText text = new OsdText();
            text.dateEnable = 1;
            text.dateFormat = 4;
            text.datePosX = 20;
            text.datePosY = 20;
            text.timeEnable = 1;
            text.timeFormat = 2;
            text.timePosX = 160;
            text.timePosY = 20;
            text.textEnable = t == null || t.length() == 0 ? 0 : 1;
            text.textPositionX = 20;
            text.textPositionY = 80;
            text.text = t;
            return text;
        }

        public static OsdText parse(byte[] data, int offset, int length) {
            if (length >= 104) {
                ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                OsdText text = new OsdText();
                text.dateEnable = buf.getInt();
                text.dateFormat = buf.getInt();
                text.datePosX = buf.getInt();
                text.datePosY = buf.getInt();
                text.timeEnable = buf.getInt();
                text.timeFormat = buf.getInt();
                text.timePosX = buf.getInt();
                text.timePosY = buf.getInt();
                text.textEnable = buf.getInt();
                text.textPositionX = buf.getInt();
                text.textPositionY = buf.getInt();
                text.text = QLMCameraTool.getString(data, 44, 60);
                return text;
            }
            return null;
        }

        public byte[] toDataBytes() {
            byte[] data = new byte[104];
            ByteBuffer buf = ByteBuffer.wrap(data);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.dateEnable);
            buf.putInt(this.dateFormat);
            buf.putInt(this.datePosX);
            buf.putInt(this.datePosY);
            buf.putInt(this.timeEnable);
            buf.putInt(this.timeFormat);
            buf.putInt(this.timePosX);
            buf.putInt(this.timePosY);
            buf.putInt(this.textEnable);
            buf.putInt(this.textPositionX);
            buf.putInt(this.textPositionY);
            if (this.text != null && this.text.length() > 0) {
                byte[] textBytes;
                try {
                    textBytes = this.text.getBytes("GBK");
                }
                catch (UnsupportedEncodingException e) {
                    textBytes = this.text.getBytes();
                }
                int r = textBytes.length >= 60 ? 60 : textBytes.length;
                System.arraycopy(textBytes, 0, data, 44, r);
            }
            return data;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OsdText [dateEnable=");
            builder.append(this.dateEnable);
            builder.append(", dateFormat=");
            builder.append(this.dateFormat);
            builder.append(", datePosX=");
            builder.append(this.datePosX);
            builder.append(", datePosY=");
            builder.append(this.datePosY);
            builder.append(", timeEnable=");
            builder.append(this.timeEnable);
            builder.append(", timeFormat=");
            builder.append(this.timeFormat);
            builder.append(", timePosX=");
            builder.append(this.timePosX);
            builder.append(", timePosY=");
            builder.append(this.timePosY);
            builder.append(", textEnable=");
            builder.append(this.textEnable);
            builder.append(", textPositionX=");
            builder.append(this.textPositionX);
            builder.append(", textPositionY=");
            builder.append(this.textPositionY);
            builder.append(", text=");
            builder.append(this.text);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dateEnable;
            result = 31 * result + this.dateFormat;
            result = 31 * result + this.datePosX;
            result = 31 * result + this.datePosY;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 31 * result + this.textEnable;
            result = 31 * result + this.textPositionX;
            result = 31 * result + this.textPositionY;
            result = 31 * result + this.timeEnable;
            result = 31 * result + this.timeFormat;
            result = 31 * result + this.timePosX;
            result = 31 * result + this.timePosY;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OsdText other = (OsdText)obj;
            if (this.dateEnable != other.dateEnable) {
                return false;
            }
            if (this.dateFormat != other.dateFormat) {
                return false;
            }
            if (this.datePosX != other.datePosX) {
                return false;
            }
            if (this.datePosY != other.datePosY) {
                return false;
            }
            if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
                return false;
            }
            if (this.textEnable != other.textEnable) {
                return false;
            }
            if (this.textPositionX != other.textPositionX) {
                return false;
            }
            if (this.textPositionY != other.textPositionY) {
                return false;
            }
            if (this.timeEnable != other.timeEnable) {
                return false;
            }
            if (this.timeFormat != other.timeFormat) {
                return false;
            }
            if (this.timePosX != other.timePosX) {
                return false;
            }
            return this.timePosY == other.timePosY;
        }
    }

    private static interface ReadCallback<T> {
        public T onReadData(DataPacket var1, DataPacket var2, OperationFutureHandler<T> var3) throws Exception;
    }

    public static class SerialPortConfig {
        public static final int DEVICE_NET_BAUDRATE_300 = 0;
        public static final int DEVICE_NET_BAUDRATE_600 = 1;
        public static final int DEVICE_NET_BAUDRATE_1200 = 2;
        public static final int DEVICE_NET_BAUDRATE_2400 = 3;
        public static final int DEVICE_NET_BAUDRATE_4800 = 4;
        public static final int DEVICE_NET_BAUDRATE_9600 = 5;
        public static final int DEVICE_NET_BAUDRATE_19200 = 6;
        public static final int DEVICE_NET_BAUDRATE_38400 = 7;
        public static final int DEVICE_NET_BAUDRATE_57600 = 8;
        public static final int DEVICE_NET_BAUDRATE_115200 = 9;
        public static final int DEVICE_NET_PARITY_NONE = 0;
        public static final int DEVICE_NET_PARITY_ODD = 1;
        public static final int DEVICE_NET_PARITY_EVEN = 2;
        public static final int DEVICE_NET_DATABIT_7 = 0;
        public static final int DEVICE_NET_DATABIT_8 = 1;
        public static final int DEVICE_NET_STOPBIT_1 = 0;
        public static final int DEVICE_NET_STOPBIT_2 = 1;
        public static final int DEVICE_NET_SERIAL_CTRLMODE_SOFT = 0;
        public static final int DEVICE_NET_SERIAL_CTRLMODE_HARD = 1;
        public int port;
        public int baudRate;
        public int parity;
        public int dataBits;
        public int stopBit;
        public int ctrlMode;

        public static SerialPortConfig createFromMap(Map<String, Object> param) {
            int v;
            SerialPortConfig config = new SerialPortConfig();
            config.port = SerialPortConfig.getInt(param, "uatIndex", -1);
            if (config.port != 0 && config.port != 1) {
                return null;
            }
            int c_baudRate = SerialPortConfig.getInt(param, "baudRate", 9600);
            switch (c_baudRate) {
                case 300: {
                    v = 0;
                    break;
                }
                case 600: {
                    v = 1;
                    break;
                }
                case 1200: {
                    v = 2;
                    break;
                }
                case 2400: {
                    v = 3;
                    break;
                }
                case 4800: {
                    v = 4;
                    break;
                }
                case 9600: {
                    v = 5;
                    break;
                }
                case 19200: {
                    v = 6;
                    break;
                }
                case 38400: {
                    v = 7;
                    break;
                }
                case 57600: {
                    v = 8;
                    break;
                }
                case 115200: {
                    v = 9;
                    break;
                }
                default: {
                    v = 5;
                }
            }
            config.baudRate = v;
            v = 0;
            Object parity0 = param.get("parity");
            if (parity0 != null) {
                String parity1 = parity0.toString();
                if ("PARITY_NONE".equals(parity1)) {
                    v = 0;
                } else if ("PARITY_ODD".equals(parity1)) {
                    v = 1;
                } else if ("PARITY_EVEN".equals(parity1)) {
                    v = 2;
                }
            }
            config.parity = v;
            v = SerialPortConfig.getInt(param, "dataBits", 8);
            config.dataBits = v == 7 ? 0 : 1;
            v = SerialPortConfig.getInt(param, "stopBits", 1);
            config.stopBit = v == 2 ? 1 : 0;
            config.ctrlMode = v = 0;
            return config;
        }

        public static SerialPortConfig parse(byte[] data, int offset, int length) {
            if (length >= 24) {
                ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                SerialPortConfig config = new SerialPortConfig();
                config.port = buf.getInt();
                config.baudRate = buf.getInt();
                config.parity = buf.getInt();
                config.dataBits = buf.getInt();
                config.stopBit = buf.getInt();
                config.ctrlMode = buf.getInt();
                return config;
            }
            return null;
        }

        public byte[] toDataBytes() {
            byte[] data = new byte[24];
            ByteBuffer buf = ByteBuffer.wrap(data);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.putInt(this.port);
            buf.putInt(this.baudRate);
            buf.putInt(this.parity);
            buf.putInt(this.dataBits);
            buf.putInt(this.stopBit);
            buf.putInt(this.ctrlMode);
            return data;
        }

        private static int getInt(Map<String, Object> param, String key, int defalutValue) {
            Object a = param.get(key);
            if (a == null) {
                return defalutValue;
            }
            if (a instanceof Number) {
                return ((Number)a).intValue();
            }
            String ax = a.toString();
            if (ax.length() == 0) {
                return defalutValue;
            }
            try {
                return Integer.parseInt(ax);
            }
            catch (Exception ex) {
                return defalutValue;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SerialPortConfig [port=");
            builder.append(this.port);
            builder.append(", baudRate=");
            builder.append(this.baudRate);
            builder.append(", parity=");
            builder.append(this.parity);
            builder.append(", dataBits=");
            builder.append(this.dataBits);
            builder.append(", stopBit=");
            builder.append(this.stopBit);
            builder.append(", ctrlMode=");
            builder.append(this.ctrlMode);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.baudRate;
            result = 31 * result + this.ctrlMode;
            result = 31 * result + this.dataBits;
            result = 31 * result + this.parity;
            result = 31 * result + this.port;
            result = 31 * result + this.stopBit;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerialPortConfig other = (SerialPortConfig)obj;
            if (this.baudRate != other.baudRate) {
                return false;
            }
            if (this.ctrlMode != other.ctrlMode) {
                return false;
            }
            if (this.dataBits != other.dataBits) {
                return false;
            }
            if (this.parity != other.parity) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return this.stopBit == other.stopBit;
        }
    }
}

