/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionA1;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class QTCKNewhannelDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
CarparkLoudspeakerAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private static ConcurrentHashMap<String, Properties> synConMap = new ConcurrentHashMap();
    private ScheduledFuture<?> shedule;
    private boolean checkSeriaSetingok = false;
    private AtomicBoolean checkingConfig = new AtomicBoolean(false);
    private Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    private Object displayLock = new Object();
    private AtomicInteger sendSeq = new AtomicInteger(0);
    private volatile long nextSynchrizedTimeMills;
    private volatile Long diplayTime;
    private boolean clearDynDisplay = true;
    private volatile byte currentVolumeValue = (byte)-1;
    private int sendWaitMills = 80;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;

    public QTCKNewhannelDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    QTCKNewhannelDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + QTCKNewhannelDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 4000L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectIfNotConnected1() {
        Object config;
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            this.nextSynchrizedTimeMills = 0L;
            this.clearDynDisplay = true;
            return;
        }
        if (!this.checkSeriaSetingok) {
            config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        if (this.isWorkingProperly()) {
            byte v;
            this.checkConfig();
            this.checkSyncTime();
            config = this.displayLock;
            synchronized (config) {
                Long a1 = this.diplayTime;
                if (this.clearDynDisplay || a1 != null && ServiceUtil.getServiceContext().currentTimeMillis() > a1) {
                    Long ax;
                    if (this.clearDynDisplay) {
                        this.clearDynDisplay = false;
                    }
                    if (a1 != null && (ax = this.diplayTime) != null && a1.longValue() == ax.longValue()) {
                        this.diplayTime = null;
                    }
                    this.dispLayInfoTimeTable.clear();
                }
            }
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            Volume volume = applicationService.getVolume(this.equipment);
            if (volume != null && (v = this.getVolumeValue(volume)) != this.currentVolumeValue) {
                this.setVolume0(v);
            }
        }
    }

    private void checkSyncTime() {
        long synTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (synTimeMills > this.nextSynchrizedTimeMills) {
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                return;
            }
            Calendar cl = Calendar.getInstance();
            int sec = cl.get(13);
            int min = cl.get(12);
            int hour = cl.get(11);
            int day = cl.get(5);
            int month = cl.get(2) + 1;
            int week = cl.get(7) - 1;
            int year = cl.get(1) - 2000;
            if (year < 0) {
                year = 0;
            }
            byte[] dateBytes = new byte[]{(byte)year, (byte)month, (byte)day, (byte)week, (byte)hour, (byte)min, (byte)sec};
            byte[] sendData = this.toSendBytes((byte)16, dateBytes);
            OperationFuture<Integer> of = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
            of.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void operationComplete(OperationFuture<Integer> f) {
                    if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                        QTCKNewhannelDisplayAction.this.nextSynchrizedTimeMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
        }
    }

    private byte getSeq() {
        int x = Math.abs(this.sendSeq.incrementAndGet());
        return (byte)(x % 255);
    }

    private void doSynConfig(Properties config, Properties oldP) throws Throwable {
        Properties synP = synConMap.get(this.equipment.getEquipmentNo());
        if (synP == null || !config.equals(synP)) {
            if (!this.isWorkingProperly()) {
                return;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                return;
            }
            int portIndex = this.getUatIndex();
            for (Map.Entry<Object, Object> entry : config.entrySet()) {
                try {
                    String oldV;
                    String curentV;
                    if (entry.getKey() == null || entry.getValue() == null || !(entry.getKey() instanceof String) || (curentV = (String)entry.getValue()).length() < 4) continue;
                    String string = oldV = oldP == null ? null : oldP.getProperty((String)entry.getKey());
                    if (oldV != null && curentV.equals(oldV)) continue;
                    byte cmd = (byte)Integer.parseInt(curentV.substring(0, 2), 16);
                    byte[] data = BytesTool.hexStringToByteArray((String)curentV.substring(2));
                    byte[] sendData = this.toSendBytes(cmd, data);
                    OperationFuture<Integer> of = action.sendNoResponseRS485Data(portIndex, sendData, this.sendWaitMills);
                    try {
                        Integer s = (Integer)of.get(3L, TimeUnit.SECONDS);
                        if (s != null && s == 0) continue;
                        throw new Exception("\u8d85\u65f6");
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + ex.getMessage() + ",cmd: 0x" + Integer.toHexString(cmd) + ", \u4e0b\u53d1\u6570\u636e:" + BytesTool.byteArrayToHexString((byte[])sendData)));
                        return;
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + ex.getMessage()));
                    return;
                }
            }
            synConMap.put(this.equipment.getEquipmentNo(), config);
        }
    }

    private void checkConfig() {
        if (!this.isWorkingProperly()) {
            return;
        }
        if (this.checkingConfig.compareAndSet(false, true)) {
            try {
                final Properties curentP = this.getconfig();
                final Properties synP = synConMap.get(this.equipment.getEquipmentNo());
                if (synP == null || !curentP.equals(synP)) {
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    QTCKNewhannelDisplayAction.this.doSynConfig(curentP, synP);
                                }
                                catch (Throwable ex) {
                                    ServiceLog.getLog().warn((Object)"\u540c\u6b65\u914d\u7f6e\u5f02\u5e38", ex);
                                    QTCKNewhannelDisplayAction.this.checkingConfig.set(false);
                                }
                            }
                            finally {
                                QTCKNewhannelDisplayAction.this.checkingConfig.set(false);
                            }
                        }
                    });
                } else {
                    this.checkingConfig.set(false);
                }
            }
            catch (Throwable ex) {
                this.checkingConfig.set(false);
                ServiceLog.getLog().warn((Object)"\u68c0\u67e5\u914d\u7f6e\u5f02\u5e38", ex);
            }
        }
    }

    private byte getconfigByteValue(EquipmentConfig config, String key, byte defualtValue) {
        if (config == null) {
            return defualtValue;
        }
        Integer v = config.getConfigIntValue(key);
        if (v == null) {
            return defualtValue;
        }
        return v.byteValue();
    }

    private Properties getconfig() {
        Properties p = new Properties();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        byte st = this.getScreenTypeCmd();
        p.setProperty("S11", BytesTool.byteArrayToHexString((byte[])new byte[]{17, st}));
        byte display_type = this.getconfigByteValue(config, "display_type", (byte)1);
        p.setProperty("S12", BytesTool.byteArrayToHexString((byte[])new byte[]{18, display_type}));
        byte xspkxss = this.getconfigByteValue(config, "xspkxss", (byte)1);
        p.setProperty("S13", BytesTool.byteArrayToHexString((byte[])new byte[]{19, xspkxss}));
        byte cpmz_dh = this.getconfigByteValue(config, "cpmz_dh", (byte)0);
        p.setProperty("S14", BytesTool.byteArrayToHexString((byte[])new byte[]{20, cpmz_dh}));
        byte time_dp = this.getconfigByteValue(config, "time_dp", (byte)1);
        p.setProperty("S15", BytesTool.byteArrayToHexString((byte[])new byte[]{21, time_dp}));
        int displayCount = this.getDisplayCount();
        int i = 1;
        while (i <= displayCount) {
            block7: {
                byte adTyValue;
                int lineByte;
                block14: {
                    String adTyKey;
                    block13: {
                        block9: {
                            block12: {
                                block10: {
                                    block11: {
                                        block8: {
                                            if (st != 2) break block8;
                                            lineByte = i == 3 ? 4 : (i == 4 ? 3 : (int)((byte)i));
                                            break block9;
                                        }
                                        if (st != 3) break block10;
                                        if (i != 1) break block11;
                                        lineByte = 2;
                                        break block9;
                                    }
                                    if (i != 2) break block7;
                                    lineByte = 4;
                                    break block9;
                                }
                                if (st != 0) break block12;
                                if (i > 2) break block7;
                                lineByte = (byte)i;
                                break block9;
                            }
                            lineByte = (byte)i;
                        }
                        if (this.equipment.getUse() != 1) break block13;
                        adTyKey = "display_position_" + i + "_free_type";
                        adTyValue = this.getconfigByteValue(config, adTyKey, (byte)1);
                        break block14;
                    }
                    if (this.equipment.getUse() != 2) break block7;
                    adTyKey = "display_position_" + i + "_type";
                    adTyValue = this.getconfigByteValue(config, adTyKey, (byte)2);
                }
                if (adTyValue == 1) {
                    String adKey = this.equipment.getUse() == 1 ? "display_position_" + i + "_free_type1" : "display_position_" + i + "_type1";
                    String adValue = config.getConfigValue(adKey);
                    if (adValue != null && (adValue = adValue.trim()).length() != 0) {
                        byte[] txtBytes;
                        try {
                            adValue = ServiceUtil.getString(adValue, 56, "GBK");
                            txtBytes = adValue.getBytes("GBK");
                        }
                        catch (Exception ex) {
                            break block7;
                        }
                        byte[] adBytes = new byte[txtBytes.length + 4];
                        adBytes[0] = 48;
                        adBytes[1] = lineByte;
                        adBytes[2] = this.getLineColor(i);
                        adBytes[3] = 0;
                        System.arraycopy(txtBytes, 0, adBytes, 4, txtBytes.length);
                        p.setProperty("AD" + i, BytesTool.byteArrayToHexString((byte[])adBytes));
                    }
                }
            }
            ++i;
        }
        return p;
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        EquipmentConfig config1 = this.equipment.getEquipmentConfig();
        Integer display_tyle = config1.getConfigIntValue("display_tyle");
        int dt = display_tyle != null ? display_tyle : 0;
        OperationFuture<Integer> f = null;
        long curretMills = ServiceUtil.getServiceContext().currentTimeMillis();
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            if (dt == 2 && v <= 9999 && this.getEquipment().getUse() == 1) {
                Long x = this.dispLayInfoTimeTable.get(config.screenIndex);
                if (x != null && curretMills < x) {
                    OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                    h.setResult((Object)0);
                    return h;
                }
                f = this.setSpace0(v);
                continue;
            }
            f = this.display0(60, config.screenIndex, String.valueOf(config.spacefix) + v, true);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    private OperationFuture<Integer> setSpace0(int space) {
        if (space < 0) {
            space = 0;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)52, String.format("%04d", space).getBytes());
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return result;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        return action.isWorkingProperly();
    }

    @Override
    public boolean isVerticalScreen() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_tyle = config.getConfigIntValue("display_tyle");
        if (display_tyle == null) {
            display_tyle = 0;
        }
        return display_tyle == 1 || display_tyle == 2;
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public boolean isSupportTrafficLights() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("trafficLights");
        return v != null && "1".equals(v);
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        if (sec < 1) {
            sec = 1;
        } else if (sec > 255) {
            sec = 255;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)113, new byte[]{(byte)sec});
        OperationFuture<Integer> op = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return op;
    }

    public OperationFuture<Integer> lightRedORGreen(byte redOrGreen) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (redOrGreen != 0) {
            redOrGreen = 1;
        }
        byte[] sendData = this.toSendBytes((byte)112, new byte[]{redOrGreen});
        OperationFuture<Integer> op = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return op;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, false);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, boolean spaceInfo) {
        Object object = this.displayLock;
        synchronized (object) {
            byte[] dx;
            byte[] sendText;
            CameraUartAction action;
            block45: {
                block52: {
                    OperationFutureHandler h;
                    block54: {
                        block53: {
                            int dt;
                            block51: {
                                block46: {
                                    Long x;
                                    if (!this.isWorkingProperly()) {
                                        OperationFutureHandler h2 = ServiceUtil.getServiceContext().createOperationFuture();
                                        h2.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                                        return h2;
                                    }
                                    action = this.getWorkingCameraUartAction();
                                    if (action == null) {
                                        OperationFutureHandler h3 = ServiceUtil.getServiceContext().createOperationFuture();
                                        h3.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                                        return h3;
                                    }
                                    if (text == null || text.length() == 0) {
                                        OperationFutureHandler h4 = ServiceUtil.getServiceContext().createOperationFuture();
                                        h4.setResult((Object)0);
                                        return h4;
                                    }
                                    if (text.endsWith(",")) {
                                        text = text.substring(0, text.length() - 1);
                                    }
                                    if (displayTimes < 1) {
                                        displayTimes = 1;
                                    } else if (displayTimes > 255) {
                                        displayTimes = 255;
                                    }
                                    long lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(displayTimes * 1500);
                                    if (!spaceInfo) {
                                        this.dispLayInfoTimeTable.put(position, lockMills);
                                    } else if (this.equipment.getUse() == 1 && (x = this.dispLayInfoTimeTable.get(position)) != null && ServiceUtil.getServiceContext().currentTimeMillis() < x) {
                                        OperationFutureHandler h5 = ServiceUtil.getServiceContext().createOperationFuture();
                                        h5.setResult((Object)0);
                                        return h5;
                                    }
                                    EquipmentConfig config = this.equipment.getEquipmentConfig();
                                    Integer display_tyle = config.getConfigIntValue("display_tyle");
                                    dt = display_tyle != null ? display_tyle : 0;
                                    if (dt != 2 || position != 2 || spaceInfo) break block46;
                                    try {
                                        int showLineIndex;
                                        String line2;
                                        String line1;
                                        block49: {
                                            block47: {
                                                block50: {
                                                    String playMoney;
                                                    String moneyV;
                                                    block48: {
                                                        block44: {
                                                            String s;
                                                            moneyV = null;
                                                            int i1 = text.indexOf("\u8bf7\u7f34\u8d39");
                                                            if (i1 == -1) {
                                                                i1 = text.indexOf("\u8bf7\u8865\u7f34");
                                                                if (i1 != -1) {
                                                                    moneyV = "\u8bf7\u8865\u7f34";
                                                                }
                                                            } else {
                                                                moneyV = "\u8bf7\u7f34\u8d39";
                                                            }
                                                            playMoney = null;
                                                            if (i1 != -1 && (i1 = (s = text.substring(i1 + 3)).indexOf(20803)) != -1) {
                                                                String money1 = s.substring(0, i1);
                                                                moneyV = String.valueOf(moneyV) + money1 + "\u5143";
                                                                try {
                                                                    float a = Float.parseFloat(money1);
                                                                    if (a == (float)((int)a)) {
                                                                        playMoney = String.valueOf((int)a);
                                                                        break block44;
                                                                    }
                                                                    playMoney = money1;
                                                                    int h1 = playMoney.lastIndexOf(46);
                                                                    if (h1 != -1 && playMoney.endsWith("0")) {
                                                                        playMoney = playMoney.substring(0, playMoney.length() - 1);
                                                                    }
                                                                }
                                                                catch (Exception exception) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (playMoney == null || playMoney.length() <= 0) break block47;
                                                        if (playMoney.getBytes("GBK").length <= 6) break block48;
                                                        line1 = "\u3000\u3000\u3000\u3000";
                                                        line2 = text;
                                                        showLineIndex = 5;
                                                        break block49;
                                                    }
                                                    showLineIndex = 7;
                                                    line1 = playMoney;
                                                    line2 = text;
                                                    if (moneyV == null) break block49;
                                                    if (!(line2 = line2.replace(moneyV, "")).startsWith(",")) break block50;
                                                    line2 = line2.substring(1);
                                                    break block49;
                                                }
                                                if (line2.endsWith(",")) {
                                                    line2 = line2.substring(0, line2.length() - 1);
                                                    break block49;
                                                } else if (line2.indexOf(",,") != -1) {
                                                    line2 = line2.replace(",,", ",");
                                                }
                                                break block49;
                                            }
                                            showLineIndex = 5;
                                            if (text.indexOf("\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4\u653e\u884c") != -1) {
                                                line1 = "\u4eba\u5de5\u786e\u8ba4";
                                                line2 = text.replace("\u8bf7\u7b49\u5f85\u4eba\u5de5\u786e\u8ba4\u653e\u884c", "\u8bf7\u7a0d\u540e");
                                            } else if (text.endsWith("\u4e00\u8def\u987a\u98ce") || text.endsWith("\u4e00\u8def\u5e73\u5b89") || text.endsWith("\u7981\u6b62\u901a\u884c") || text.endsWith("\u8f66\u4f4d\u5df2\u6ee1") || text.endsWith("\u6b22\u8fce\u5149\u4e34") || text.endsWith("\u7981\u6b62\u5165\u573a") || text.endsWith("\u7981\u6b62\u79bb\u573a")) {
                                                line1 = text.substring(text.length() - 4, text.length());
                                                line2 = text.substring(0, text.length() - 4);
                                                if (line2.endsWith(",")) {
                                                    line2 = line2.substring(0, line2.length() - 1);
                                                }
                                            } else {
                                                String a = text.length() > 4 ? text.substring(0, 4) : text;
                                                if (a.endsWith(",")) {
                                                    a = String.valueOf(a.substring(0, a.length() - 1)) + "\uff0c";
                                                }
                                                if (a.getBytes("GBK").length == 8) {
                                                    line1 = a;
                                                    line2 = text.substring(0, 4);
                                                } else {
                                                    line1 = "\u3000\u3000\u3000\u3000";
                                                    line2 = text;
                                                }
                                            }
                                        }
                                        this.display0(displayTimes, showLineIndex, line1, spaceInfo);
                                        if (line2 == null || line2.length() == 0) {
                                            line2 = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date());
                                        }
                                        text = line2;
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
                                    }
                                }
                                text = ServiceUtil.getString(text, 56, "GBK");
                                try {
                                    sendText = text.getBytes("GBK");
                                }
                                catch (UnsupportedEncodingException e) {
                                    h = ServiceUtil.getServiceContext().createOperationFuture();
                                    h.setException((Throwable)e);
                                    return h;
                                }
                                dx = new byte[sendText.length + 4];
                                if (dt != 1) break block51;
                                dx[0] = position == 3 ? 4 : (position == 4 ? 3 : (byte)position);
                                break block45;
                            }
                            if (dt != 2) break block52;
                            if (position != 1) break block53;
                            dx[0] = 1;
                            break block45;
                        }
                        if (position != 2) break block54;
                        dx[0] = 3;
                        break block45;
                    }
                    if (position == 6) {
                        dx[0] = 6;
                        break block45;
                    } else if (position == 5) {
                        dx[0] = 5;
                        break block45;
                    } else {
                        if (position != 7) {
                            h = ServiceUtil.getServiceContext().createOperationFuture();
                            h.setResult((Object)0);
                            return h;
                        }
                        dx[0] = 7;
                    }
                    break block45;
                }
                dx[0] = (byte)position;
            }
            dx[1] = (byte)displayTimes;
            dx[2] = this.getLineColor(position);
            dx[3] = 0;
            System.arraycopy(sendText, 0, dx, 4, sendText.length);
            byte[] sendData = this.toSendBytes((byte)49, dx);
            if (spaceInfo) {
                System.out.println(BytesTool.byteArrayToHexString((byte[])sendData));
            }
            OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
            if (!spaceInfo) {
                final int dpT = displayTimes;
                result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> futrue) {
                        if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null && (Integer)futrue.getResult() == 0) {
                            QTCKNewhannelDisplayAction.this.diplayTime = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(dpT * 1500);
                        }
                    }
                });
            }
            return result;
        }
    }

    public OperationFuture<Integer> finishDynamicDisplay(int position) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte d = position == 1 ? (byte)1 : (position == 2 ? (byte)2 : (position == 3 ? (byte)4 : 8));
        byte[] sendData = this.toSendBytes((byte)51, new byte[]{d});
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return result;
    }

    public byte getScreenTypeCmd() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_tyle = config.getConfigIntValue("display_tyle");
        if (display_tyle == null) {
            display_tyle = 0;
        }
        if (display_tyle == 0) {
            Integer display_count = config.getConfigIntValue("display_count");
            if (display_count == null) {
                display_count = 2;
            }
            if (display_count == 2) {
                return 0;
            }
            return 1;
        }
        if (display_tyle == 1) {
            return 2;
        }
        if (display_tyle == 2) {
            return 3;
        }
        return 0;
    }

    public byte[] toSendBytes(byte fun, byte[] data) {
        int len = data.length;
        byte[] sendb = new byte[13 + data.length];
        int index = 0;
        sendb[index++] = -6;
        sendb[index++] = 88;
        sendb[index++] = this.getSeq();
        sendb[index++] = this.getRs485Address();
        sendb[index++] = 0;
        sendb[index++] = 0;
        sendb[index++] = this.getScreenTypeCmd();
        sendb[index++] = fun;
        if (len > 255) {
            sendb[index++] = (byte)(len >> 8);
            sendb[index++] = (byte)len;
        } else {
            sendb[index++] = 0;
            sendb[index++] = (byte)len;
        }
        if (data.length > 0) {
            System.arraycopy(data, 0, sendb, index, data.length);
            index += data.length;
        }
        int crc = QTCKNewhannelDisplayAction.crc16(sendb, 2, index - 2);
        sendb[index++] = (byte)(crc >> 8);
        sendb[index++] = (byte)crc;
        sendb[index++] = -81;
        return sendb;
    }

    private static int crc16(byte[] data, int offset, int length) {
        int index = offset;
        int crc = 0;
        while (length-- > 0) {
            int i = 128;
            while (i != 0) {
                if ((crc & 0x8000) != 0) {
                    crc *= 2;
                    crc ^= 0x8005;
                } else {
                    crc *= 2;
                }
                if ((data[index] & i) != 0) {
                    crc ^= 0x8005;
                }
                i /= 2;
            }
            ++index;
        }
        return crc;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        this.checkConfig();
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        DynLoudspeakerAction a = this.getDynLoudspeakerAction();
        if (a != null) {
            return null;
        }
        return this;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        boolean isSuportDyn = Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("voice_type"));
        if (isSuportDyn) {
            return this;
        }
        return null;
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        byte[] sendText;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        try {
            text = ServiceUtil.getString(text, 100, "GBK");
            sendText = text.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)e);
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)82, sendText);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return result;
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        byte[] sendd;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (codes.length > 100) {
            sendd = new byte[100];
            System.arraycopy(codes, 0, sendd, 0, sendd.length);
        } else {
            sendd = codes;
        }
        byte[] sendData = this.toSendBytes((byte)81, sendd);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        return result;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        final byte volumeValue = this.getVolumeValue(volume);
        OperationFuture<Integer> result = this.setVolume0(volumeValue);
        result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> f) {
                if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    if (QTCKNewhannelDisplayAction.this.getDynLoudspeakerAction() != null) {
                        QTCKNewhannelDisplayAction.this.play("\u97f3\u91cf\u8bbe\u7f6e\u6210\u529f, \u97f3\u91cf: " + volumeValue);
                    } else {
                        QTCKNewhannelDisplayAction.this.play(9, (byte)(77 + volumeValue));
                    }
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return result;
    }

    private OperationFuture<Integer> setVolume0(byte volumeValue) {
        if (volumeValue < 0) {
            volumeValue = 0;
        } else if (volumeValue > 9) {
            volumeValue = (byte)9;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)80, new byte[]{volumeValue});
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
        final byte xa = volumeValue;
        result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> f) {
                if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    QTCKNewhannelDisplayAction.this.currentVolumeValue = xa;
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return result;
    }

    protected byte getVolumeValue(Volume volume) {
        if (volume == null) {
            return 5;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        byte x = night ? (byte)Math.round((float)volume.getNightVolume() / 10.0f) : (byte)Math.round((float)volume.getDayVolume() / 10.0f);
        if (x > 9) {
            x = 9;
        } else if (x < 0) {
            x = 0;
        }
        return x;
    }

    private byte getRs485Address() {
        int h;
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer addr = config.getConfigIntValue("RS485_ADDR");
        if (addr != null && (h = addr.intValue()) >= 0 && h <= 255) {
            return (byte)h;
        }
        return 100;
    }

    private int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    private byte getLineColor(int lineIndex) {
        String key = this.equipment.getUse() == 1 ? "display_position_" + lineIndex + "_color" : "display_position_" + lineIndex + "_color1";
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer color = config.getConfigIntValue(key);
        if (color != null && color >= 1 && color <= 8) {
            return color.byteValue();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<Integer> displayQrCode(int displayTimes, String qrContent, String lineMsg) {
        Object object = this.displayLock;
        synchronized (object) {
            byte[] msgBytes;
            byte[] qrData1;
            OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
            if (qrContent == null || qrContent.length() == 0) {
                opHander.setResult((Object)1);
                return opHander;
            }
            if (!this.isWorkingProperly()) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            if (qrContent == null || qrContent.length() == 0) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u7f3a\u5c11\u4e8c\u7ef4\u7801\u5185\u5bb9"));
                return h;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            if (lineMsg == null || lineMsg.length() == 0) {
                lineMsg = "\u8bf7\u626b\u7801";
            }
            try {
                qrData1 = qrContent.getBytes("GBK");
                msgBytes = lineMsg.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                try {
                    qrData1 = qrContent.getBytes("GB2312");
                    msgBytes = lineMsg.getBytes("GB2312");
                }
                catch (Exception ex) {
                    opHander.setResult((Object)1);
                    return opHander;
                }
            }
            if (qrData1.length + msgBytes.length + 4 > 199) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u4e8c\u7ef4\u7801\u957f\u5ea6\u8fc7\u957f"));
                return h;
            }
            long lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.SECONDS.toMillis(255L);
            this.diplayTime = lockMills;
            int i = 1;
            while (i <= 4) {
                this.dispLayInfoTimeTable.put(i, lockMills);
                ++i;
            }
            byte[] contentData = new byte[qrData1.length + msgBytes.length + 4];
            int index = 0;
            contentData[index++] = (byte)qrData1.length;
            contentData[index++] = -2;
            contentData[index++] = 8;
            contentData[index++] = this.getLineColor(4);
            System.arraycopy(qrData1, 0, contentData, index, qrData1.length);
            System.arraycopy(msgBytes, 0, contentData, index += qrData1.length, msgBytes.length);
            byte[] sendData = this.toSendBytes((byte)50, contentData);
            OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.sendWaitMills);
            return result;
        }
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionA1();
        }
        return staticLoudSpeakerServiceAction;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }
}

