/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionA1;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class QTCKhannelDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
CarparkLoudspeakerAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private static ConcurrentHashMap<String, ConfigParam> synConMap = new ConcurrentHashMap();
    private ScheduledFuture<?> shedule;
    private boolean checkSeriaSetingok = false;
    private AtomicBoolean checkingConfig = new AtomicBoolean(false);
    private Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    private Object displayLock = new Object();
    private long nextExeSynTimeMills;
    private AtomicInteger sequence = new AtomicInteger(0);
    private volatile long lastCheckConfigMills;
    protected volatile byte currentVolumeValue = (byte)-1;
    private static final long waitNorsponseMills = 100L;
    private volatile ScheduledFuture<?> greenShedule;
    protected boolean clearDynDisplay = true;
    protected volatile Long diplayTime;
    private int protocolVersion;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;

    public QTCKhannelDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    QTCKhannelDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + QTCKhannelDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 5000L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    synchronized void stop() {
        ScheduledFuture<?> greenShedule0;
        if (this.shedule != null) {
            this.shedule.cancel(true);
        }
        if ((greenShedule0 = this.greenShedule) != null) {
            greenShedule0.cancel(true);
            this.greenShedule = null;
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    protected int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    private byte[] toSendBytes(byte cmd, byte ... data) {
        int x = Math.abs(this.sequence.incrementAndGet()) % 256;
        byte seq = (byte)x;
        byte bn = -128;
        return this.toSendBytes0(seq, bn, cmd, data);
    }

    private byte[] toSendBytes0(byte seq, byte bn, byte cmd, byte ... data) {
        int version = this.getProtocolVersion();
        int len = data.length;
        byte[] sendBytes = new byte[10 + len];
        int index = 0;
        sendBytes[index++] = version == 2 ? -86 : -1;
        sendBytes[index++] = version == 2 ? 85 : 34;
        sendBytes[index++] = seq;
        sendBytes[index++] = bn;
        sendBytes[index++] = cmd;
        sendBytes[index++] = (byte)(len >> 8);
        sendBytes[index++] = (byte)len;
        byte[] byArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sendBytes[index++] = b;
            ++n2;
        }
        int crc = QTCKhannelDisplayAction.CRC16(sendBytes, 3, sendBytes.length - 6);
        sendBytes[index++] = (byte)(crc >> 8);
        sendBytes[index++] = (byte)crc;
        sendBytes[index++] = version == 2 ? -81 : -14;
        return sendBytes;
    }

    private static int CRC16(byte[] ptr, int offset, int len) {
        int index = offset;
        int crc = 0;
        int _0x8005 = 32773;
        while (len-- > 0) {
            int i = 128;
            while (i != 0) {
                if ((crc & 0x8000) != 0) {
                    crc *= 2;
                    crc ^= _0x8005;
                } else {
                    crc *= 2;
                }
                if ((ptr[index] & i) != 0) {
                    crc ^= _0x8005;
                }
                i /= 2;
            }
            ++index;
        }
        return crc;
    }

    public void connectIfNotConnected1() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            return;
        }
        if (!this.checkSeriaSetingok) {
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        int version1 = this.getProtocolVersion();
        if (this.protocolVersion == 0) {
            this.protocolVersion = version1;
        } else if (version1 != this.protocolVersion) {
            synConMap.remove(this.equipment.getEquipmentNo());
            this.protocolVersion = version1;
        }
        long currntMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (currntMills > this.nextExeSynTimeMills) {
            Calendar cl = Calendar.getInstance();
            int year = cl.get(1) - 2000;
            if (year < 0) {
                year = 0;
            }
            int month = cl.get(2) + 1;
            int day = cl.get(5);
            int hour = cl.get(11);
            int minus = cl.get(12);
            int sec = cl.get(13);
            int week = cl.get(7) - 1;
            byte[] data = new byte[]{(byte)sec, (byte)minus, (byte)hour, (byte)day, (byte)month, (byte)week, (byte)year};
            byte[] sendData = this.toSendBytes((byte)-44, data);
            OperationFuture<Integer> op = this.doSend(action, sendData);
            try {
                Integer a = (Integer)op.get(5000L, TimeUnit.MILLISECONDS);
                if (a != null && a == 0) {
                    this.nextExeSynTimeMills = currntMills + TimeUnit.MINUTES.toMillis(60L);
                } else {
                    ServiceLog.getLog().warn((Object)"\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5931\u8d25");
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + ex.getMessage()));
            }
        }
        if (this.isWorkingProperly()) {
            ApplicationService applicationService;
            Volume volume;
            if (ServiceUtil.getServiceContext().currentTimeMillis() - this.lastCheckConfigMills >= 60000L) {
                this.checkConfig();
            }
            if ((volume = (applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getVolume(this.equipment)) != null) {
                byte v = this.getVolumeValue(volume);
                if (this.currentVolumeValue == -1) {
                    this.currentVolumeValue = v;
                } else if (v != this.currentVolumeValue) {
                    try {
                        Integer t = (Integer)this.setVolume0(action, v).get(4L, TimeUnit.SECONDS);
                        if (t == null || t != 0) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5931\u8d25!"));
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().error((Object)(String.valueOf(this.equipment.getName()) + ",\u8bbe\u7f6e\u97f3\u91cf\u5927\u5c0f\u5f02\u5e38!" + ex.getMessage()));
                    }
                }
            }
            final Long a1 = this.diplayTime;
            if (this.clearDynDisplay || a1 != null && ServiceUtil.getServiceContext().currentTimeMillis() > a1) {
                this.finishDynamicDisplay(action).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> futrue) {
                        if (!futrue.isCancelled()) {
                            if (futrue.getException() != null) {
                                ServiceLog.getLog().error((Object)(String.valueOf(QTCKhannelDisplayAction.this.getEquipment().getName()) + ", \u7ec8\u6b62\u663e\u793a\u4e34\u65f6\u4fe1\u606f \u5f02\u5e38!" + futrue.getException().getMessage()));
                            } else if (futrue.getResult() == null || (Integer)futrue.getResult() != 0) {
                                ServiceLog.getLog().warn((Object)(String.valueOf(QTCKhannelDisplayAction.this.getEquipment().getName()) + ", \u7ec8\u6b62\u4e34\u65f6\u663e\u793a\u4fe1\u606f \u5931\u8d25!"));
                            } else {
                                if (QTCKhannelDisplayAction.this.clearDynDisplay) {
                                    QTCKhannelDisplayAction.this.clearDynDisplay = false;
                                }
                                if (a1 != null && a1 == QTCKhannelDisplayAction.this.diplayTime) {
                                    QTCKhannelDisplayAction.this.diplayTime = null;
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private int getProtocolVersion() {
        String protocolVersion0 = this.equipment.getEquipmentConfig().getConfigValue("protocol_version");
        if (protocolVersion0 != null && protocolVersion0.length() > 0 && "2".equals(protocolVersion0)) {
            return 2;
        }
        return 1;
    }

    private OperationFuture<Integer> doSend(CameraUartAction action, byte[] sendBytes) {
        return action.sendNoResponseRS485Data(this.getUatIndex(), sendBytes, 100L);
    }

    protected OperationFuture<Integer> finishDynamicDisplay(CameraUartAction action) {
        return this.doSend(action, this.toSendBytes((byte)-42, new byte[0]));
    }

    protected OperationFuture<Integer> setVolume0(CameraUartAction action, final byte volumeValue) {
        OperationFuture<Integer> op = this.doSend(action, this.toSendBytes((byte)-46, 2, volumeValue));
        op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> da) {
                if (da.getException() == null && da.getResult() != null && (Integer)da.getResult() == 0) {
                    QTCKhannelDisplayAction.this.currentVolumeValue = volumeValue;
                }
            }
        });
        return op;
    }

    private byte getColorByte(int displayType, int colorType) {
        byte r;
        if (displayType == 0) {
            switch (colorType) {
                case 0: {
                    r = 7;
                    break;
                }
                case 1: {
                    r = 15;
                    break;
                }
                case 2: {
                    r = 63;
                    break;
                }
                case 3: {
                    r = 56;
                    break;
                }
                case 4: {
                    r = -8;
                    break;
                }
                case 5: {
                    r = -64;
                    break;
                }
                case 6: {
                    r = -57;
                    break;
                }
                case 7: {
                    r = -1;
                    break;
                }
                default: {
                    r = 0;
                    break;
                }
            }
        } else {
            switch (colorType) {
                case 0: {
                    r = 0;
                    break;
                }
                case 2: {
                    r = 2;
                    break;
                }
                case 3: {
                    r = 1;
                    break;
                }
                default: {
                    r = 0;
                }
            }
        }
        return r;
    }

    private ConfigParam getconfig() {
        byte[] adTextBytes;
        String adText;
        Integer actionType;
        int showType;
        Integer showTypex;
        Integer colorType;
        int i;
        ConfigParam p = new ConfigParam();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        if (display_count < 1) {
            display_count = 1;
        } else if (display_count > 4) {
            display_count = 4;
        }
        Integer display_tyle = config.getConfigIntValue("display_tyle");
        if (display_tyle == null) {
            display_tyle = 0;
        }
        byte[] byArray = new byte[2];
        byArray[0] = 16;
        byte[] x10 = byArray;
        if (display_tyle == 1) {
            x10[1] = 2;
        } else if (display_count == 4) {
            x10[1] = 1;
        }
        byte[] x25 = new byte[]{37, 1};
        Integer display_type = config.getConfigIntValue("display_type");
        if (display_type == null) {
            display_type = 1;
        }
        if (display_type == 0) {
            x25[1] = 0;
        }
        byte[] byArray2 = new byte[3];
        byArray2[0] = 39;
        byArray2[1] = 65;
        byte[] x27_41 = byArray2;
        byte[] byArray3 = new byte[3];
        byArray3[0] = 39;
        byArray3[1] = 66;
        byte[] x27_42 = byArray3;
        byte[] byArray4 = new byte[3];
        byArray4[0] = 39;
        byArray4[1] = 66;
        byte[] x27_43 = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = 39;
        byArray5[1] = 66;
        byte[] x27_44 = byArray5;
        byte[][] x27 = new byte[][]{x27_41, x27_42, x27_43, x27_44};
        byte[] byArray6 = new byte[3];
        byArray6[0] = 40;
        byArray6[1] = 65;
        byte[] x28_41 = byArray6;
        byte[] byArray7 = new byte[3];
        byArray7[0] = 40;
        byArray7[1] = 66;
        byte[] x28_42 = byArray7;
        byte[] byArray8 = new byte[3];
        byArray8[0] = 40;
        byArray8[1] = 67;
        byte[] x28_43 = byArray8;
        byte[] byArray9 = new byte[3];
        byArray9[0] = 40;
        byArray9[1] = 68;
        byte[] x28_44 = byArray9;
        byte[][] x28 = new byte[][]{x28_41, x28_42, x28_43, x28_44};
        byte[] x0C = new byte[]{12, this.getColorByte(display_type, 0)};
        byte[] x0D = new byte[]{13, this.getColorByte(display_type, 0)};
        byte[] x0E = new byte[]{14, this.getColorByte(display_type, 0)};
        byte[] x0F = new byte[]{15, this.getColorByte(display_type, 0)};
        byte[][] colorBytes = new byte[][]{x0C, x0D, x0E, x0F};
        byte[][] adBytes = new byte[][]{new byte[0], new byte[0], new byte[0], new byte[0]};
        if (this.equipment.getUse() == 1) {
            i = 1;
            while (i <= display_count) {
                colorType = config.getConfigIntValue("display_position_" + i + "_color");
                if (colorType == null) {
                    colorType = 0;
                }
                if ((showTypex = config.getConfigIntValue("display_position_" + i + "_free_type")) == null) {
                    showTypex = 1;
                }
                showType = showTypex;
                actionType = config.getConfigIntValue("display_position_" + i + "_action");
                if (actionType == null) {
                    actionType = 0;
                }
                if (actionType < 0) {
                    actionType = 0;
                } else if (actionType > 2) {
                    actionType = 2;
                }
                if (showType == 0) {
                    adText = config.getConfigValue("display_position_" + i + "_free_type0");
                    x27[i - 1][2] = 7;
                } else if (showType == 1) {
                    adText = config.getConfigValue("display_position_" + i + "_free_type1");
                } else if (showType == 2) {
                    adText = null;
                } else if (showType == 3) {
                    adText = null;
                    x27[i - 1][2] = 15;
                } else {
                    adText = null;
                }
                adTextBytes = null;
                if (adText != null && adText.length() > 0) {
                    adText = ServiceUtil.getString(adText, 88, "GBK");
                    try {
                        adTextBytes = adText.getBytes("GBK");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (adTextBytes != null) {
                    adBytes[i - 1] = adTextBytes;
                }
                colorBytes[i - 1][1] = this.getColorByte(display_type, colorType);
                x28[i - 1][2] = actionType.byteValue();
                ++i;
            }
        } else if (this.equipment.getUse() == 2) {
            i = 1;
            while (i <= display_count) {
                colorType = config.getConfigIntValue("display_position_" + i + "_color1");
                if (colorType == null) {
                    colorType = 0;
                }
                if ((showTypex = config.getConfigIntValue("display_position_" + i + "_type")) == null) {
                    showTypex = 2;
                }
                showType = showTypex;
                actionType = config.getConfigIntValue("display_position_" + i + "_action1");
                if (actionType == null) {
                    actionType = 0;
                }
                if (actionType < 0) {
                    actionType = 0;
                } else if (actionType > 2) {
                    actionType = 2;
                }
                if (showType == 0) {
                    adText = config.getConfigValue("display_position_" + i + "_type0");
                    x27[i - 1][2] = 7;
                } else if (showType == 1) {
                    adText = config.getConfigValue("display_position_" + i + "_type1");
                } else if (showType == 2) {
                    adText = null;
                } else if (showType == 3) {
                    adText = null;
                    x27[i - 1][2] = 15;
                } else {
                    adText = null;
                }
                adTextBytes = null;
                if (adText != null && adText.length() > 0) {
                    adText = ServiceUtil.getString(adText, 88, "GBK");
                    try {
                        adTextBytes = adText.getBytes("GBK");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                if (adTextBytes != null) {
                    adBytes[i - 1] = adTextBytes;
                }
                colorBytes[i - 1][1] = this.getColorByte(display_type, colorType);
                x28[i - 1][2] = actionType.byteValue();
                ++i;
            }
        }
        byte[] timeType = null;
        int i2 = 0;
        while (i2 < x27.length) {
            byte x1 = x27[i2][2];
            if (x1 == 7 || x1 == 15) {
                timeType = x27[i2];
                break;
            }
            ++i2;
        }
        if (timeType == null) {
            timeType = x27[0];
        }
        p.screenStyle = x10;
        p.screenType = x25;
        p.timeType = timeType;
        p.actionType1 = x28[0];
        p.actionType2 = x28[1];
        p.actionType3 = x28[2];
        p.actionType4 = x28[3];
        p.colorType1 = colorBytes[0];
        p.colorType2 = colorBytes[1];
        p.colorType3 = colorBytes[2];
        p.colorType4 = colorBytes[3];
        p.ad1 = adBytes[0];
        p.ad2 = adBytes[1];
        p.ad3 = adBytes[2];
        p.ad4 = adBytes[3];
        return p;
    }

    private void checkConfig() {
        if (!this.isWorkingProperly()) {
            return;
        }
        if (this.checkingConfig.compareAndSet(false, true)) {
            try {
                final ConfigParam curentP = this.getconfig();
                ConfigParam synP = synConMap.get(this.equipment.getEquipmentNo());
                if (synP == null) {
                    synP = new ConfigParam();
                    synConMap.put(this.equipment.getEquipmentNo(), synP);
                }
                if (synP.isNeedRestEqConfig(curentP)) {
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    QTCKhannelDisplayAction.this.doSynConfig(curentP);
                                }
                                catch (Throwable ex) {
                                    ServiceLog.getLog().warn((Object)"\u540c\u6b65\u914d\u7f6e\u5f02\u5e38", ex);
                                    QTCKhannelDisplayAction.this.checkingConfig.set(false);
                                    QTCKhannelDisplayAction.this.lastCheckConfigMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                }
                            }
                            finally {
                                QTCKhannelDisplayAction.this.checkingConfig.set(false);
                                QTCKhannelDisplayAction.this.lastCheckConfigMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            }
                        }
                    });
                } else {
                    this.checkingConfig.set(false);
                }
            }
            catch (Throwable ex) {
                this.checkingConfig.set(false);
                ServiceLog.getLog().warn((Object)("\u68c0\u67e5\u914d\u7f6e\u5f02\u5e38:" + ex.getMessage()));
            }
        }
    }

    private void doSynConfig(ConfigParam newConfig) throws Throwable {
        ConfigParam synP = synConMap.get(this.equipment.getEquipmentNo());
        if (synP == null) {
            synP = new ConfigParam();
            synConMap.put(this.equipment.getEquipmentNo(), synP);
        }
        if (synP.isNeedRestEqConfig(newConfig)) {
            if (!this.isWorkingProperly()) {
                return;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                return;
            }
            int dpCount = this.getDisplayCount();
            byte D2 = -46;
            byte D5 = -43;
            Field[] fields = ConfigParam.class.getDeclaredFields();
            String ad1 = "ad1";
            String ad2 = "ad2";
            String ad3 = "ad3";
            String ad4 = "ad4";
            String l3 = "3";
            String l4 = "4";
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.getType().equals(byte[].class)) {
                    byte[] a = (byte[])f.get(synP);
                    byte[] b = (byte[])f.get(newConfig);
                    if (b != null && b.length > 0 && ConfigParam.isChanged(a, b)) {
                        String fName = f.getName();
                        if ((fName.endsWith(l3) || fName.endsWith(l4)) && dpCount <= 2) {
                            f.set(synP, b);
                        } else {
                            byte[] data;
                            byte cmd;
                            if (fName.equals(ad1)) {
                                cmd = D5;
                                data = new byte[b.length + 2];
                                data[0] = 65;
                                data[1] = 81;
                                System.arraycopy(b, 0, data, 2, b.length);
                            } else if (fName.equals(ad2)) {
                                cmd = D5;
                                data = new byte[b.length + 2];
                                data[0] = 66;
                                data[1] = 81;
                                System.arraycopy(b, 0, data, 2, b.length);
                            } else if (fName.equals(ad3)) {
                                cmd = D5;
                                data = new byte[b.length + 2];
                                data[0] = 67;
                                data[1] = 81;
                                System.arraycopy(b, 0, data, 2, b.length);
                            } else if (fName.equals(ad4)) {
                                cmd = D5;
                                data = new byte[b.length + 2];
                                data[0] = 68;
                                data[1] = 81;
                                System.arraycopy(b, 0, data, 2, b.length);
                            } else {
                                cmd = D2;
                                data = b;
                            }
                            byte[] sx = this.toSendBytes(cmd, data);
                            OperationFuture<Integer> op = this.doSend(action, sx);
                            try {
                                Integer s = (Integer)op.get(5L, TimeUnit.SECONDS);
                                if (s == null || s != 0) {
                                    throw new Exception("\u8d85\u65f6");
                                }
                                f.set(synP, b);
                            }
                            catch (Throwable ex) {
                                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + ex.getMessage() + ",\u53c2\u6570\u6570\u636e:" + fName));
                                return;
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected byte getVolumeValue(Volume volume) {
        if (volume == null) {
            return 5;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        if (night) {
            int x = Math.round((float)volume.getNightVolume() / 10.0f);
            if (x > 9) {
                x = 9;
            } else if (x < 0) {
                x = 0;
            }
            return (byte)x;
        }
        int x = Math.round((float)volume.getDayVolume() / 10.0f);
        if (x > 9) {
            x = 9;
        } else if (x < 0) {
            x = 0;
        }
        return (byte)x;
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.display0(60, config.screenIndex, String.valueOf(config.spacefix) + v, true);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        if (!action.isWorkingProperly()) {
            this.clearDynDisplay = true;
            return false;
        }
        return true;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        DynLoudspeakerAction a = this.getDynLoudspeakerAction();
        if (a != null) {
            return null;
        }
        return this;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        boolean isSuportDyn = Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("voice_type"));
        if (isSuportDyn) {
            return this;
        }
        return null;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte v = this.getVolumeValue(volume);
        OperationFuture<Integer> f = this.setVolume0(action, v);
        final byte xv = (byte)(v + 77);
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> f) {
                if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    if (QTCKhannelDisplayAction.this.getDynLoudspeakerAction() != null) {
                        QTCKhannelDisplayAction.this.play("\u97f3\u91cf\u8bbe\u7f6e\u6210\u529f");
                    } else {
                        QTCKhannelDisplayAction.this.play(9, xv);
                    }
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return f;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        this.checkConfig();
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)-38, codes);
        OperationFuture<Integer> result = this.doSend(action, sendData);
        return result;
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, false);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, boolean spaceInfo) {
        Object object = this.displayLock;
        synchronized (object) {
            Long x;
            byte[] sendText;
            if (!this.isWorkingProperly()) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            if (text == null || text.length() == 0) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            text = ServiceUtil.getString(text, 88, "GBK");
            try {
                sendText = text.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)e);
                return h;
            }
            if (!spaceInfo) {
                this.dispLayInfoTimeTable.put(position, ServiceUtil.getServiceContext().currentTimeMillis());
            } else if (this.equipment.getUse() == 1 && (x = this.dispLayInfoTimeTable.get(position)) != null && ServiceUtil.getServiceContext().currentTimeMillis() - x < 15000L) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            byte cmd = -43;
            byte[] data = new byte[sendText.length + 2];
            data[0] = position <= 1 ? 65 : (position == 2 ? 66 : (position == 3 ? 67 : 68));
            data[1] = sendText.length <= 8 ? 37 : 82;
            System.arraycopy(sendText, 0, data, 2, sendText.length);
            if (displayTimes < 1) {
                displayTimes = 1;
            }
            byte[] sendData = this.toSendBytes(cmd, data);
            OperationFuture<Integer> result = this.doSend(action, sendData);
            if (!spaceInfo) {
                final int displayTimes0 = displayTimes;
                result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> futrue) {
                        if (!futrue.isCancelled() && futrue.getException() == null && futrue.getResult() != null && (Integer)futrue.getResult() == 0) {
                            QTCKhannelDisplayAction.this.diplayTime = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(displayTimes0 * 1500);
                        }
                    }
                });
            }
            return result;
        }
    }

    @Override
    public boolean isSupportTrafficLights() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("trafficLights");
        return v != null && "1".equals(v);
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        ScheduledFuture<?> greenShedule0 = this.greenShedule;
        if (greenShedule0 != null) {
            greenShedule0.cancel(true);
            this.greenShedule = null;
        }
        if (sec <= 5) {
            return this.lightGreen0(1);
        }
        int count = sec % 4 == 0 ? sec / 4 : sec / 4 + 1;
        return this.lightGreen0(count);
    }

    public OperationFuture<Integer> lightGreen0(int count) {
        if (count <= 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        OperationFuture<Integer> f = this.doSend(action, this.toSendBytes((byte)-41, new byte[1]));
        final int mCount = count - 1;
        if (mCount > 0) {
            f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                }

                public void operationComplete(OperationFuture<Integer> f1) {
                    if (f1.getException() == null && f1.getResult() != null && (Integer)f1.getResult() == 0) {
                        QTCKhannelDisplayAction.this.lightGreen0(mCount);
                    }
                }
            });
        }
        return f;
    }

    public OperationFuture<Integer> lightRed() {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        return this.doSend(action, this.toSendBytes((byte)-41, 1));
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        byte[] sendText;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        text = ServiceUtil.getString(text, 88, "GB2312");
        try {
            sendText = text.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)e);
            return h;
        }
        byte[] sendData = this.toSendBytes((byte)-45, sendText);
        OperationFuture<Integer> result = this.doSend(action, sendData);
        return result;
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int diplaySec, String qrContent, String lineMsg) {
        byte[] lineData1;
        byte[] qrData1;
        final OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
        if (qrContent == null || qrContent.length() == 0 || lineMsg == null || lineMsg.length() == 0) {
            opHander.setResult((Object)1);
            return opHander;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        final CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        try {
            qrData1 = qrContent.getBytes("GBK");
            lineData1 = lineMsg.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            try {
                qrData1 = qrContent.getBytes("GB2312");
                lineData1 = lineMsg.getBytes("GB2312");
            }
            catch (Exception ex) {
                opHander.setResult((Object)1);
                return opHander;
            }
        }
        byte[] qrData = new byte[qrData1.length + 1];
        qrData[0] = 0;
        byte[] lineData = new byte[lineData1.length + 1];
        lineData[0] = 1;
        System.arraycopy(qrData1, 0, qrData, 1, qrData1.length);
        System.arraycopy(lineData1, 0, lineData, 1, lineData1.length);
        byte[] sendQrData = this.toSendBytes((byte)-37, qrData);
        final byte[] sendlineData = this.toSendBytes((byte)-37, lineData);
        this.doSend(action, sendQrData).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
                opHander.setException((Throwable)new TimeoutException());
            }

            public void operationComplete(final OperationFuture<Integer> f) {
                if (f.getException() != null) {
                    opHander.setException(f.getException());
                } else if (f.isCancelled()) {
                    opHander.cancel(true);
                } else {
                    Integer a = (Integer)f.getResult();
                    if (a == null) {
                        opHander.setResult(null);
                    } else if (a == 0) {
                        QTCKhannelDisplayAction.this.doSend(action, sendlineData).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                                opHander.setException(f.getException());
                            }

                            public void operationComplete(OperationFuture<Integer> f2) {
                                if (f2.getException() != null) {
                                    opHander.setException(f2.getException());
                                } else if (f2.isCancelled()) {
                                    opHander.cancel(true);
                                } else {
                                    opHander.setResult((Object)((Integer)f2.getResult()));
                                }
                            }
                        });
                    } else {
                        opHander.setResult((Object)a);
                    }
                }
            }
        });
        return opHander;
    }

    @Override
    public boolean isVerticalScreen() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_tyle = config.getConfigIntValue("display_tyle");
        if (display_tyle == null) {
            display_tyle = 0;
        }
        return display_tyle == 1;
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionA1();
        }
        return staticLoudSpeakerServiceAction;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    static class ConfigParam {
        byte[] screenStyle;
        byte[] screenType;
        byte[] timeType;
        byte[] actionType1;
        byte[] actionType2;
        byte[] actionType3;
        byte[] actionType4;
        byte[] colorType1;
        byte[] colorType2;
        byte[] colorType3;
        byte[] colorType4;
        byte[] ad1;
        byte[] ad2;
        byte[] ad3;
        byte[] ad4;

        ConfigParam() {
        }

        private static boolean isChanged(byte[] a, byte[] newA) {
            if (newA != null && newA.length > 0) {
                if (a == null || a.length == 0) {
                    return true;
                }
                if (!Arrays.equals(a, newA)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isNeedRestEqConfig(ConfigParam newOther) {
            if (newOther == null) {
                return false;
            }
            Field[] fields = ConfigParam.class.getDeclaredFields();
            try {
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (true) {
                    byte[] b;
                    byte[] a;
                    if (n2 >= n) {
                        return false;
                    }
                    Field f = fieldArray[n2];
                    if (f.getType().equals(byte[].class) && ConfigParam.isChanged(a = (byte[])f.get(this), b = (byte[])f.get(newOther))) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }
}

