/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.driver.RS485ThreadHandler;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.TCPConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class QYCameraAction
extends AbstractEquipmentAction
implements PlateRegCameraAction,
CameraUartAction,
RoadBarrierAction,
ServiceAction {
    private static final String LIBRARY_NAME = "NetSDK";
    private ScheduledFuture<?> shedule;
    private volatile Long hwnd;
    public static final String ACTION_NAME = "/QYCameraAction";
    private volatile Collection<PlateEntry> whiteList;
    private final RS485ThreadHandler[] rs485ThreadHandlers = new RS485ThreadHandler[2];
    private volatile boolean stopped = false;
    private static final String op_plateCaptureData = "plateCaptureData";
    private static final String op_RS485RECEIVEDATA = "rs485resData";
    private static final String OP_PARAM_NAME = "op";
    private static final String pwds = "admin_cy,000000";
    private volatile boolean connected;
    private Object downloadLocak = new Object();
    private LocalProcessTransport localProcessTransport;

    public QYCameraAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    QYCameraAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    QYCameraAction.this.connected = false;
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u6444\u50cf\u673a\u5f02\u5e38,ip:" + QYCameraAction.this.equipment.getIp() + ",\u539f\u56e0: " + ex.getMessage()));
                }
            }
        }, 1000L, 4000L, TimeUnit.MILLISECONDS);
    }

    synchronized void stop() {
        try {
            this.stopped = true;
            if (this.shedule != null) {
                this.shedule.cancel(true);
            }
            int i = 0;
            while (i < this.rs485ThreadHandlers.length) {
                RS485ThreadHandler rs485ThreadHandler = this.rs485ThreadHandlers[i];
                if (rs485ThreadHandler != null) {
                    rs485ThreadHandler.stop();
                    this.rs485ThreadHandlers[i] = null;
                }
                ++i;
            }
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            String opName = "[" + this.equipment.getIp() + "]\u5173\u95ed\u76f8\u673a\u8fde\u63a5";
            String serviceName = "disConnect";
            long timeoutMills = 3000L;
            paramMap.put("cameraId", this.equipment.getEquipmentNo());
            paramMap.put("ip", this.equipment.getIp());
            this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)"", (Throwable)ex);
        }
    }

    private void connectIfNotConnected1() throws Exception {
        ScheduledFuture<?> shedule1 = this.shedule;
        this.stopped = false;
        if (shedule1 == null || shedule1.isCancelled()) {
            return;
        }
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            throw new Exception("\u76f8\u673aip\u672a\u914d\u7f6e");
        }
        OperationFuture<Integer> f = this.getLocalProcessTransport().loadNativeDriveIfNeed("com.wovoe.carmera.drive.qy.Drive", "\u52a0\u8f7dQY\u76f8\u673a\u672c\u5730\u9a71\u52a8");
        Integer a = (Integer)f.get(6500L, TimeUnit.MILLISECONDS);
        if (a == null || a != 0) {
            this.connected = false;
            return;
        }
        if (shedule1 == null || shedule1.isCancelled()) {
            this.connected = false;
            return;
        }
        f = this.registerIfNeed();
        a = (Integer)f.get(10500L, TimeUnit.MILLISECONDS);
        if (a == null || a != 0) {
            this.connected = false;
            return;
        }
        if (shedule1 == null || shedule1.isCancelled()) {
            this.connected = false;
            return;
        }
        this.connected = true;
    }

    private OperationFuture<Integer> registerIfNeed() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "\u8fde\u63a5\u76f8\u673a[" + this.equipment.getIp() + "]";
        String serviceName = "connectIfNotConnect";
        long timeoutMills = 10000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("pwds", pwds);
        Long x = this.hwnd;
        if (x != null) {
            paramMap.put("componentID", x.toString());
        }
        paramMap.put("reciveRegPlate", String.valueOf(this.isNeedRegPlate()));
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    public boolean isNeedRegPlate() {
        List<String> list = this.equipment.getChannelNos();
        boolean r = false;
        if (list != null) {
            for (String channelNo : list) {
                boolean bl = r = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) != null;
                if (r) break;
            }
        }
        return r;
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u9519\u8bef\u53c2\u6570:componentID:" + x));
            return xf;
        }
        this.hwnd = hwnd0;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u64ad\u653e\u89c6\u9891";
        String serviceName = "playVisible";
        long timeoutMills = 5000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("componentID", hwnd0.toString());
        paramMap.put("pwds", pwds);
        paramMap.put("reciveRegPlate", String.valueOf(this.isNeedRegPlate()));
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u505c\u6b62\u64ad\u653e";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        if (param == null || param.get("savePath") == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570: savePath"));
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u6293\u62cd\u56fe\u7247";
        String serviceName = "capture";
        long timeoutMills = 7000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("savePath", (String)param.get("savePath"));
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> triggerRegPlate() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u89e6\u53d1\u8f6f\u8bc6\u522b";
        String serviceName = "triggerRegPlate";
        long timeoutMills = 5000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    @Override
    public boolean isWorkingProperly() {
        if (!this.connected) {
            this.whiteList = null;
        }
        return this.connected;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        return this.controlGate0(1, 0);
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        return this.controlGate0(2, 1);
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    private OperationFuture<Integer> controlGate0(int controlState, int ioPort) {
        String name1;
        if (controlState == 1) {
            name1 = "\u5f00\u95f8";
        } else if (controlState == 2) {
            name1 = "\u5173\u95f8";
        } else if (controlState == 3) {
            name1 = "\u505c\u95f8";
        } else {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new Exception("\u9519\u8bef\u63a7\u5236\u503c"));
            return f;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]" + name1;
        String serviceName = "controlGate";
        long timeoutMills = 5000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("controlState", String.valueOf(controlState));
        paramMap.put("ioPort", String.valueOf(ioPort));
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        int flowControl;
        int parity;
        int _screen_mode;
        int stopBits1;
        int baudRate;
        int baudRate1;
        int dataBits1;
        int uatIndex;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570"));
            return xf;
        }
        Object uatIndex0 = param.get("uatIndex");
        if (uatIndex0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570uatIndex"));
            return xf;
        }
        if (uatIndex0 instanceof Integer) {
            uatIndex = (Integer)uatIndex0;
        } else {
            try {
                uatIndex = Integer.parseInt(uatIndex0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (uatIndex != 0 && uatIndex != 1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u65700\u6216\u80051"));
            return xf;
        }
        String protocol = (String)param.get("protocol");
        if (protocol == null || protocol.length() == 0) {
            protocol = "RS485";
        }
        int uacType = "RS485".equals(protocol) ? 1 : ("RS232".equals(protocol) ? 2 : 0);
        Object dataBits0 = param.get("dataBits");
        if (dataBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570dataBits"));
            return xf;
        }
        if (dataBits0 instanceof Integer) {
            dataBits1 = (Integer)dataBits0;
        } else {
            try {
                dataBits1 = Integer.parseInt(dataBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (dataBits1 < 5 || dataBits1 > 8) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570dataBits\u5fc5\u987b\u662f\u30105\u30016\u30017\u30018\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        int dataBits = dataBits1;
        Object baudRate0 = param.get("baudRate");
        if (baudRate0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570baudRate"));
            return xf;
        }
        if (baudRate0 instanceof Integer) {
            baudRate1 = (Integer)baudRate0;
        } else {
            try {
                baudRate1 = Integer.parseInt(baudRate0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        switch (baudRate1) {
            case 1200: {
                baudRate = 0;
                break;
            }
            case 2400: {
                baudRate = 1;
                break;
            }
            case 4800: {
                baudRate = 2;
                break;
            }
            case 9600: {
                baudRate = 3;
                break;
            }
            case 19200: {
                baudRate = 4;
                break;
            }
            case 38400: {
                baudRate = 5;
                break;
            }
            case 57600: {
                baudRate = 6;
                break;
            }
            case 115200: {
                baudRate = 7;
                break;
            }
            default: {
                baudRate = -1;
            }
        }
        if (baudRate == -1) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u30101200\u30012400\u30014800\u30019600\u300119200\u300138400\u300157600\u3001115200\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object stopBits0 = param.get("stopBits");
        if (stopBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570stopBits"));
            return xf;
        }
        if (stopBits0 instanceof Integer) {
            stopBits1 = (Integer)stopBits0;
        } else {
            try {
                stopBits1 = Integer.parseInt(stopBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (stopBits1 < 0 || stopBits1 > 2) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u30100\u30011\u30012\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        int stopBits = stopBits1;
        Object screen_mode0 = param.get("screen_mode");
        if (screen_mode0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570screen_mode"));
            return xf;
        }
        if (screen_mode0 instanceof Integer) {
            _screen_mode = (Integer)screen_mode0;
        } else {
            try {
                _screen_mode = Integer.parseInt(screen_mode0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (_screen_mode != 1 && _screen_mode != 2 && _screen_mode != 3) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570screen_mode\u5fc5\u987b\u662f\u6574\u65701\u6216\u80052"));
            return xf;
        }
        int screen_mode = _screen_mode == 1 ? 1 : (_screen_mode == 2 ? 0 : (_screen_mode == 3 ? 2 : 0));
        Object parity0 = param.get("parity");
        if (parity0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570parity"));
            return xf;
        }
        String parity1 = parity0.toString();
        if ("PARITY_NONE".equals(parity1)) {
            parity = 0;
        } else if ("PARITY_ODD".equals(parity1)) {
            parity = 1;
        } else if ("PARITY_EVEN".equals(parity1)) {
            parity = 2;
        } else if ("PARITY_MARK".equals(parity1)) {
            parity = 3;
        } else if ("PARITY_SPACE".equals(parity1)) {
            parity = 4;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570parity\u5fc5\u987b\u662fPARITY_NONE\u3001PARITY_ODD\u3001PARITY_EVEN\u3001PARITY_MARK\u3001PARITY_SPACE"));
            return xf;
        }
        Object flowControl0 = param.get("flowControl");
        if (flowControl0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570flowControl"));
            return xf;
        }
        String flowControl1 = flowControl0.toString();
        if ("NONE".equals(flowControl1)) {
            flowControl = 0;
        } else if ("HARDWARE".equals(flowControl1)) {
            flowControl = 1;
        } else if ("XON".equals(flowControl1)) {
            flowControl = 2;
        } else if ("XOFF".equals(flowControl1)) {
            flowControl = 3;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570flowControl\u5fc5\u987b\u662fNONE\u3001HARDWARE\u3001XON\u3001XOFF"));
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("uatIndex", String.valueOf(uatIndex));
        paramMap.put("baudRate", String.valueOf(baudRate));
        paramMap.put("dataBits", String.valueOf(dataBits));
        paramMap.put("parity", String.valueOf(parity));
        paramMap.put("stopBits", String.valueOf(stopBits));
        paramMap.put("flowControl", String.valueOf(flowControl));
        paramMap.put("screen_mode", String.valueOf(screen_mode));
        paramMap.put("uacType", String.valueOf(uacType));
        String opName = "[" + this.equipment.getIp() + "]\u68c0\u67e5\u5e76\u8bbe\u7f6e\u4e32\u53e3\u64cd\u4f5c";
        String serviceName = "setSerialIfNeed";
        long timeoutMills = 5000L;
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (data == null || data.length == 0) {
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        RS485ThreadHandler shandler = this.getRS485ThreadHandler(portIndex);
        if (shandler == null || !shandler.isStarted()) {
            if (this.stopped) {
                f.setException((Throwable)new IllegalStateException("\u9a71\u52a8\u5df2\u7ecf\u505c\u6b62!"));
                return f;
            }
            f.setException((Throwable)new IllegalStateException("\u521d\u59cb\u5316\u53d1\u9001\u4e32\u53e3\u7ebf\u7a0b\u5931\u8d25!"));
            return f;
        }
        shandler.sendToQueue(data, handler, f, waitMills);
        return f;
    }

    @Override
    public boolean isSupportWhiteList() {
        return true;
    }

    @Override
    public boolean isSupportBlackList() {
        return false;
    }

    @Override
    public void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList0, Collection<PlateEntry> blackList0, PlateRegCameraAction.ImportPlateCallback callback) throws Exception {
        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, false);
    }

    private OperationFuture<Integer> exportCsv(String filePath) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] \u5bfc\u51fa\u767d\u540d\u5355csv\u6587\u4ef6";
        String serviceName = "exportWhiteListCsv";
        long timeoutMills = 60000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("csvFilePath", filePath);
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    private OperationFuture<Integer> clearAllBlackWiteList() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "] \u6e05\u7a7a\u6240\u6709\u9ed1\u767d\u540d\u5355";
        String serviceName = "clearBlackWhiteList";
        long timeoutMills = 30000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    private OperationFuture<Map<File, Integer>> importWhiteList(List<File> fileList) {
        OperationFutureHandler xf;
        block5: {
            xf = ServiceUtil.getServiceContext().createOperationFuture();
            try {
                TCPConnection conn = this.getLocalProcessTransport().getProcessConnection();
                if (conn != null && conn.isConnected()) {
                    String opName = "[" + this.equipment.getIp() + "] \u5bfc\u5165\u767d\u540d\u5355";
                    RequestSender sender = conn.createRequest();
                    sender.setHeader("cameraId", this.equipment.getEquipmentNo());
                    sender.setHeader("ip", this.equipment.getIp());
                    sender.setHeader(OP_PARAM_NAME, "importWhiteList");
                    sender.setRequestActionName(ACTION_NAME);
                    StringBuilder sbr = new StringBuilder();
                    for (File f : fileList) {
                        if (sbr.length() > 0) {
                            sbr.append(',');
                        }
                        sbr.append(f.getAbsolutePath());
                    }
                    byte[] data = sbr.toString().getBytes("UTF-8");
                    sender.setSendData(data);
                    sender.setNeedEncrypt(false);
                    sender.doRequest((SendCallback)new SendCallback0(opName){

                        @Override
                        public void onException(Throwable exception) {
                            try {
                                super.onException(exception);
                            }
                            finally {
                                xf.setException(exception);
                            }
                        }
                    }, (ReceiveCallback)new ReceiveCallback0(opName, 300000L){

                        @Override
                        protected void opSuccess(Receiver receiver) {
                            if (receiver.getData() != null && receiver.getDataLength() > 0) {
                                try {
                                    String[] s1;
                                    String sttr = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8");
                                    LinkedHashMap<File, Integer> resultMap = new LinkedHashMap<File, Integer>();
                                    String[] stringArray = s1 = sttr.split(";");
                                    int n = s1.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        if ((s = s.trim()).length() != 0) {
                                            int ko = s.lastIndexOf(44);
                                            resultMap.put(new File(s.substring(0, ko)), Integer.valueOf(s.substring(ko + 1)));
                                        }
                                        ++n2;
                                    }
                                    xf.setResult(resultMap);
                                }
                                catch (Exception ex) {
                                    xf.setException((Throwable)new Exception("\u54cd\u5e94\u6570\u636e\u5f02\u5e38:" + ex.getMessage()));
                                }
                            } else {
                                xf.setException((Throwable)new Exception("\u54cd\u5e94\u6570\u636e\u5f02\u5e38"));
                            }
                        }

                        @Override
                        protected void opError(Receiver receiver) {
                            String evl1;
                            String evl = receiver == null ? null : receiver.getHeaderValue("msg");
                            String string = evl1 = receiver == null ? null : receiver.getHeaderValue("msg1");
                            if (evl == null) {
                                evl = "";
                            }
                            if (evl1 == null) {
                                evl1 = "";
                            }
                            xf.setException((Throwable)new Exception("\u5bfc\u5165\u767d\u540d\u5355\u64cd\u4f5c\u5931\u8d25!" + evl + " " + evl1));
                        }
                    });
                    break block5;
                }
                throw new Exception("\u672a\u8fde\u63a5!");
            }
            catch (Exception ex) {
                xf.setException((Throwable)ex);
            }
        }
        return xf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList0, Collection<PlateEntry> blackList0, PlateRegCameraAction.ImportPlateCallback callback, boolean onlyCheck) throws Exception {
        try {
            if (callback != null) {
                callback.onCheck(this.equipment.getEquipmentNo(), onlyCheck);
            }
            if (!this.isWorkingProperly()) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            Object object = this.downloadLocak;
            synchronized (object) {
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat df3 = new SimpleDateFormat("yyyyMMddHHmmss");
                Collection<PlateEntry> whiteList1 = this.whiteList;
                if (whiteList1 == null) {
                    Iterator<PlateEntry> resultCsv;
                    Integer result;
                    File tempDir = PathFinder.findRuntimeTempDayDir();
                    File csvFile = new File(tempDir, "QYR_" + this.equipment.getEquipmentNo() + "_" + System.currentTimeMillis() + "_" + RandomStringGenerator.getDefaultInstance().getNewString(6) + ".csv");
                    if (callback != null) {
                        callback.onQueryAll(this.equipment.getEquipmentNo());
                    }
                    if ((result = (Integer)(resultCsv = this.exportCsv(csvFile.getAbsolutePath())).get(61L, TimeUnit.SECONDS)) == null) {
                        throw new Exception("\u5bfc\u51fa\u76f8\u673a\u767d\u540d\u5355\u8d85\u65f6!");
                    }
                    if (result != 0) {
                        throw new Exception("\u5bfc\u51fa\u76f8\u673a\u767d\u540d\u5355\u5931\u8d25!");
                    }
                    if (!csvFile.exists() || !csvFile.isFile()) {
                        throw new Exception("\u767d\u540d\u5355\u6587\u4ef6\u4e0d\u5b58\u5728! \u6587\u4ef6: " + csvFile);
                    }
                    HashSet<String> vset = new HashSet<String>();
                    whiteList1 = new LinkedList<PlateEntry>();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "GB2312"));){
                        String line;
                        char lsr = ',';
                        String del = String.valueOf(lsr);
                        while ((line = reader.readLine()) != null) {
                            String[] lineSpit;
                            if ((line = line.trim()).length() == 0 || line.indexOf(44) == -1 || (lineSpit = line.split(del)).length < 6) continue;
                            try {
                                Integer.parseInt(lineSpit[0]);
                            }
                            catch (Exception ex) {
                                continue;
                            }
                            String palte = lineSpit[1].trim();
                            if (palte.length() != 7 && palte.length() != 8) continue;
                            String beginTime = lineSpit[4].trim();
                            String endTime = lineSpit[5].trim();
                            if (beginTime.length() != 14 || endTime.length() != 14 || vset.contains(palte)) continue;
                            vset.add(palte);
                            whiteList1.add(new PlateEntry(palte, df1.format(df3.parse(beginTime)), df1.format(df3.parse(endTime))));
                        }
                    }
                    try {
                        csvFile.delete();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u5220\u9664\u6587\u4ef6:" + csvFile + "\u5931\u8d25"), (Throwable)ex);
                    }
                    this.whiteList = whiteList1;
                }
                if (callback != null) {
                    callback.onQueryAllFinish(this.equipment.getEquipmentNo(), whiteList1.size(), 0, whiteList0 == null ? 0 : whiteList0.size(), blackList0 == null ? 0 : blackList0.size());
                }
                HashMap<String, PlateEntry> whilteListMap = new HashMap<String, PlateEntry>();
                if (whiteList0 != null && !whiteList0.isEmpty()) {
                    for (PlateEntry en : whiteList0) {
                        whilteListMap.put(en.getPlate(), en);
                    }
                }
                int insertW = 0;
                int updateW = 0;
                int deleteW = 0;
                int synW = 0;
                LinkedList<PlateEntry> errorWList = null;
                LinkedList<PlateEntry> successWList = null;
                if (onlyCheck) {
                    errorWList = new LinkedList<PlateEntry>();
                    successWList = new LinkedList<PlateEntry>();
                }
                for (PlateEntry en : whiteList1) {
                    PlateEntry n = (PlateEntry)whilteListMap.remove(en.getPlate());
                    if (n == null) {
                        ++deleteW;
                        if (errorWList == null) continue;
                        errorWList.add(en);
                        continue;
                    }
                    if (n.equals(en)) {
                        ++synW;
                        if (successWList == null) continue;
                        successWList.add(en);
                        continue;
                    }
                    ++updateW;
                    if (errorWList == null) continue;
                    errorWList.add(en);
                }
                if (!whilteListMap.isEmpty()) {
                    insertW += whilteListMap.size();
                    if (errorWList != null) {
                        errorWList.addAll(whilteListMap.values());
                    }
                }
                if (onlyCheck && ServiceLog.getLog().isInfoEnabled()) {
                    String ip = this.equipment.getIp();
                    ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u767d\u540d\u5355\u603b\u8f66\u724c\u6570: " + whiteList0.size()));
                    ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + successWList.size()));
                    ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + successWList.size()));
                    ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + errorWList.size() + " " + errorWList));
                }
                if (insertW == 0 && updateW == 0 && deleteW == 0) {
                    if (callback != null) {
                        if (onlyCheck) {
                            LinkedList<PlateEntry> blac = new LinkedList<PlateEntry>();
                            callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, successWList, errorWList, blac, blac);
                        }
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), 0, 0, 0, synW, 0, 0, 0, 0, onlyCheck);
                    }
                } else {
                    block56: {
                        if (callback != null) {
                            if (onlyCheck) {
                                LinkedList<PlateEntry> blac = new LinkedList<PlateEntry>();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, successWList, errorWList, blac, blac);
                            }
                            callback.onCheckReusult(this.equipment.getEquipmentNo(), insertW, updateW, deleteW, synW, 0, 0, 0, 0, onlyCheck);
                        }
                        if (onlyCheck) {
                            return;
                        }
                        if (ServiceLog.getLog().isInfoEnabled()) {
                            ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u53d1\u73b0\u8f66\u724c\u9700\u8981\u540c\u6b65\uff0c\u51c6\u5907\u4e0b\u8f7d\u6700\u65b0\u7684\u8f66\u724c\u4fe1\u606f! "));
                        }
                        if (callback != null) {
                            callback.onStartDownlod(this.equipment.getEquipmentNo());
                        }
                        try {
                            if (whiteList0 == null || whiteList0.isEmpty()) {
                                Integer reult = (Integer)this.clearAllBlackWiteList().get(31L, TimeUnit.SECONDS);
                                if (reult == null) {
                                    throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u8d85\u65f6!");
                                }
                                if (reult != 0) {
                                    throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u5931\u8d25!");
                                }
                                if (ServiceLog.getLog().isInfoEnabled()) {
                                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u9ed1\u767d\u540d\u5355\u6210\u529f! "));
                                }
                                break block56;
                            }
                            File tempDir = PathFinder.findRuntimeTempDayDir();
                            int pageSize = 2000;
                            int offset = 0;
                            int fileIndex = 0;
                            String f1 = "QYW_" + this.equipment.getEquipmentNo() + "_" + System.currentTimeMillis() + "_" + RandomStringGenerator.getDefaultInstance().getNewString(6);
                            LinkedList<File> fileList = new LinkedList<File>();
                            File file = new File(tempDir, String.valueOf(f1) + "_" + fileIndex++ + ".ini");
                            fileList.add(file);
                            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GB2312"));){
                                char lha = '@';
                                String v1s = "@ABCD@1234567890";
                                String v2s = "@10@10@";
                                String vll = "-";
                                String luius = "000000";
                                String luius1 = "235959";
                                for (PlateEntry entry : whiteList0) {
                                    if (offset > 0 && offset % pageSize == 0) {
                                        out.close();
                                        file = new File(tempDir, String.valueOf(f1) + "_" + fileIndex++ + ".ini");
                                        fileList.add(file);
                                        out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GB2312"));
                                    }
                                    StringBuilder sbr = new StringBuilder(100);
                                    sbr.append(++offset).append(lha).append(entry.getPlate());
                                    sbr.append(v2s);
                                    sbr.append(entry.getBeginDate().replace(vll, "")).append(luius).append(lha);
                                    sbr.append(entry.getEndDate().replace(vll, "")).append(luius1).append(v1s);
                                    out.println(sbr.toString());
                                }
                            }
                            OperationFuture<Map<File, Integer>> reuf = this.importWhiteList(fileList);
                            Map rmap = (Map)reuf.get(301000L, TimeUnit.MILLISECONDS);
                            if (rmap == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u5bfc\u5165\u767d\u540d\u5355\u8d85\u65f6! \u6587\u4ef6\u8def\u5f84\uff1a" + fileList);
                            }
                            for (Map.Entry entry : rmap.entrySet()) {
                                if ((Integer)entry.getValue() == 0) {
                                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u5bfc\u5165\u767d\u540d\u5355:" + entry.getKey() + " \u6210\u529f!"));
                                    if (!((File)entry.getKey()).exists() || !((File)entry.getKey()).isFile()) continue;
                                    ((File)entry.getKey()).delete();
                                    continue;
                                }
                                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u5bfc\u5165\u767d\u540d\u5355:" + entry.getKey() + " \u5931\u8d25! \u9519\u8bef\u4ee3\u7801:" + entry.getValue()));
                            }
                        }
                        finally {
                            this.whiteList = null;
                        }
                    }
                    this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, true);
                }
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                callback.onDownlodException(this.equipment.getEquipmentNo(), ex);
            }
            throw ex;
        }
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = QYCameraAction.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/qy_lprsdk/" + QYCameraAction.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = QYCameraAction.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/qy_lprsdk/" + QYCameraAction.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/qy_lprsdk/" + QYCameraAction.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "NetSDK.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "NetSDK.so";
        }
        return "NetSDK.dll";
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RS485ThreadHandler getRS485ThreadHandler(int index) {
        RS485ThreadHandler rs485ThreadHandler;
        block7: {
            if (this.stopped) {
                return null;
            }
            if (index < 0 || index >= this.rs485ThreadHandlers.length) {
                return null;
            }
            rs485ThreadHandler = this.rs485ThreadHandlers[index];
            if (rs485ThreadHandler != null) break block7;
            QYCameraAction qYCameraAction = this;
            synchronized (qYCameraAction) {
                block6: {
                    rs485ThreadHandler = this.rs485ThreadHandlers[index];
                    if (rs485ThreadHandler != null) break block7;
                    if (!this.stopped) break block6;
                    return null;
                }
                rs485ThreadHandler = new RS485ThreadHandler(index){

                    @Override
                    protected OperationFuture<Boolean> directSend(byte[] data) {
                        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                        try {
                            TCPConnection conn = QYCameraAction.this.getLocalProcessTransport().getProcessConnection();
                            if (conn != null) {
                                RequestSender sender = conn.createRequest();
                                sender.setHeader(QYCameraAction.OP_PARAM_NAME, "sendRS485Data");
                                sender.setHeader("cameraId", QYCameraAction.this.equipment.getEquipmentNo());
                                sender.setHeader("ip", QYCameraAction.this.equipment.getIp());
                                sender.setHeader("uatIndex", String.valueOf(this.portIndex));
                                sender.setSendData(data);
                                sender.setRequestActionName(QYCameraAction.ACTION_NAME);
                                sender.setNeedEncrypt(false);
                                sender.doRequest(new SendCallback(){

                                    public void onException(Throwable throwabe) {
                                        xf.setException(throwabe);
                                    }

                                    public void onCompleted() {
                                    }
                                }, new ReceiveCallback(){

                                    public void onWaitTimeout() throws Exception {
                                        xf.setException((Throwable)new TimeoutException("\u7b49\u5f85\u6570\u636e\u662f\u5426\u6210\u529f\u53d1\u9001\u4e32\u53e3\u64cd\u4f5c\u8d85\u65f6"));
                                    }

                                    public long getWaitTimeoutMills() {
                                        return 3000L;
                                    }

                                    public void doReceiver(Receiver receiver, int paramInt) throws Exception {
                                        String result = receiver.getHeaderValue("result");
                                        if ("true".equals(result)) {
                                            xf.setResult((Object)Boolean.TRUE);
                                        } else {
                                            String invokeerror = receiver.getHeaderValue("invokeerror");
                                            if ("1".equals(invokeerror)) {
                                                xf.setResult((Object)Boolean.FALSE);
                                            } else {
                                                String errmsg = receiver.getHeaderValue("msg");
                                                if (errmsg == null || errmsg.length() == 0) {
                                                    errmsg = "\u8c03\u7528\u76f8\u673a\u4e32\u53e3\u53d1\u9001\u6570\u636e\u5931\u8d25";
                                                }
                                                try {
                                                    xf.setException((Throwable)new Exception(errmsg));
                                                }
                                                finally {
                                                    ServiceLog.getLog().warn((Object)(String.valueOf(QYCameraAction.this.equipment.getIp()) + ":" + errmsg));
                                                }
                                            }
                                        }
                                    }
                                });
                            } else {
                                xf.setException((Throwable)new Exception("\u672c\u5730\u8fde\u63a5\u672a\u5efa\u7acb"));
                            }
                        }
                        catch (Throwable ex) {
                            xf.setException(ex);
                        }
                        return xf;
                    }
                };
                rs485ThreadHandler.start();
                this.rs485ThreadHandlers[index] = rs485ThreadHandler;
            }
        }
        return rs485ThreadHandler;
    }

    public void service(Receiver request) throws Exception {
        String _uatIndex;
        String op = request.getHeaderValue(OP_PARAM_NAME);
        if (op_plateCaptureData.equals(op)) {
            String plateNumber = request.getHeaderValue("plateNumber");
            String plateColor = request.getHeaderValue("plateColor");
            String vehicleColor = request.getHeaderValue("vehicleColor");
            String savePath = request.getHeaderValue("savePath");
            String smallSavePath = request.getHeaderValue("smallSavePath");
            String carLogo = request.getHeaderValue("carLogo");
            String _carSpeed = request.getHeaderValue("carSpeed");
            String _carType = request.getHeaderValue("carType");
            String carTypeName = request.getHeaderValue("carTypeName");
            String _plateConfidence = request.getHeaderValue("plateConfidence");
            String _plateType = request.getHeaderValue("plateType");
            String plateTypeName = request.getHeaderValue("plateTypeName");
            String _plateJudge = request.getHeaderValue("plateJudge");
            String plateJudgeName = request.getHeaderValue("plateJudgeName");
            String _dir = request.getHeaderValue("dir");
            String dirName = request.getHeaderValue("dirName");
            if (plateNumber != null) {
                CameraEvent event = new CameraEvent(this.equipment, plateNumber, plateColor, savePath);
                event.setCarLogo(carLogo);
                if (_carSpeed != null && _carSpeed.length() > 0) {
                    try {
                        event.setCarSpeed(Integer.valueOf(_carSpeed));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (_carType != null && _carType.length() > 0) {
                    try {
                        event.setCarType(Integer.valueOf(_carType));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setCarTypeDes(carTypeName);
                if (_dir != null && _dir.length() > 0) {
                    try {
                        event.setDir(Integer.valueOf(_dir));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setDirDes(dirName);
                if (_plateConfidence != null && _plateConfidence.length() > 0) {
                    try {
                        event.setPlateConfidence(Float.valueOf(_plateConfidence));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (_plateJudge != null && _plateJudge.length() > 0) {
                    try {
                        event.setPlateJudge(Integer.valueOf(_plateJudge));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setPlateJudgeDes(plateJudgeName);
                event.setPlateSmallPath(smallSavePath);
                if (_plateType != null && _plateType.length() > 0) {
                    try {
                        event.setPlateType(Integer.valueOf(_plateType));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                event.setPlateTypeDes(plateTypeName);
                event.setVehicleColor(vehicleColor);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
            }
        } else if (op_RS485RECEIVEDATA.equals(op) && (_uatIndex = request.getHeaderValue("uatIndex")) != null && _uatIndex.length() > 0) {
            RS485ThreadHandler rs485ThreadHandler;
            int uatIndex;
            try {
                uatIndex = Integer.parseInt(_uatIndex);
            }
            catch (Exception ex) {
                uatIndex = -1;
            }
            if (uatIndex >= 0 && uatIndex < this.rs485ThreadHandlers.length && (rs485ThreadHandler = this.rs485ThreadHandlers[uatIndex]) != null && rs485ThreadHandler.isStarted()) {
                byte[] data = request.getData();
                int dataOffset = request.getDataOffset();
                int datalen = request.getDataLength();
                if (data != null && datalen > 0) {
                    rs485ThreadHandler.handleRecevie(data, dataOffset, datalen);
                }
            }
        }
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    private static class ReceiveCallback0
    implements ReceiveCallback {
        String opName;
        long timeoutMills;

        ReceiveCallback0(String opName, long timeoutMills) {
            this.opName = opName;
            this.timeoutMills = timeoutMills;
        }

        public void onWaitTimeout() throws Exception {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.opName) + " \u8d85\u65f6!"));
            this.opError(null);
        }

        public long getWaitTimeoutMills() {
            return this.timeoutMills;
        }

        protected void opSuccess(Receiver receiver) {
        }

        protected void opError(Receiver receiver) {
        }

        public void doReceiver(Receiver receiver, int sendId) throws Exception {
            String rx = receiver.getHeaderValue("result");
            if ("true".equals(rx)) {
                if (ServiceLog.getLog().isDebugEnabled()) {
                    ServiceLog.getLog().debug((Object)(String.valueOf(this.opName) + " \u64cd\u4f5c\u6210\u529f!"));
                }
                this.opSuccess(receiver);
            } else {
                if ("error".equals(rx) || "false".equals(rx)) {
                    String msg1;
                    StringBuilder sbr = new StringBuilder();
                    sbr.append(String.valueOf(this.opName) + " \u64cd\u4f5c\u5931\u8d25! ");
                    String msg = receiver.getHeaderValue("msg");
                    if (msg != null) {
                        sbr.append(' ').append(msg);
                    }
                    if ((msg1 = receiver.getHeaderValue("msg1")) != null) {
                        sbr.append(' ').append(msg1);
                    }
                    ServiceLog.getLog().warn((Object)sbr.toString());
                }
                this.opError(receiver);
            }
        }
    }

    private static class SendCallback0
    implements SendCallback {
        String opName;

        SendCallback0(String opName) {
            this.opName = opName;
        }

        public void onException(Throwable exception) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.opName) + " \u547d\u4ee4\u53d1\u9001\u5931\u8d25!" + exception.getMessage()));
        }

        public void onCompleted() {
            if (ServiceLog.getLog().isDebugEnabled()) {
                ServiceLog.getLog().debug((Object)(String.valueOf(this.opName) + " \u547d\u4ee4\u53d1\u9001\u6210\u529f!"));
            }
        }
    }
}

