/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.QYCameraAction;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QYCameraDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_qy_ip_camera_driver";

    public QYCameraDriver() {
        this.init();
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        QYCameraAction c = new QYCameraAction(equipment, this);
        this.setAction(equipment, c);
        c.getLocalProcessTransport().register(equipment.getEquipmentNo(), c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        QYCameraAction c = (QYCameraAction)equipment.getEquipmentAction();
        c.getLocalProcessTransport().unRegister(equipment.getEquipmentNo());
        c.stop();
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("ip");
        p.setParameterNameDes("IP\u5730\u5740");
        p.setUnique(true);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("userName");
        p.setParameterDefaultValue("admin");
        p.setParameterNameDes("\u767b\u5f55\u7528\u6237");
        p.setUnique(false);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("userPwd");
        p.setParameterDefaultValue("admin");
        p.setParameterNameDes("\u767b\u5f55\u5bc6\u7801");
        p.setUnique(false);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("internetMediaStreamType");
        p.setParameterNameDes("\u4e92\u8054\u7f51\u76d1\u63a7\u4f7f\u7528\u7801\u6d41");
        p.setParameterDefaultValue("main_stream");
        p.setInputType(1);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues.add(new KeyValueEntry((Object)"main_stream", (Object)"\u5206\u8fa8\u7387\u9ad8\u7801\u6d41(\u4e00\u822c\u4e3a\u4e3b\u7801\u6d41)"));
        parameterSelectValues.add(new KeyValueEntry((Object)"sub_stream", (Object)"\u5206\u8fa8\u7387\u4f4e\u7801\u6d41(\u4e00\u822c\u4e3a\u5b50\u7801\u6d41)"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("QY-LPR01")) + "\u8f66\u724c\u8bc6\u522b\u76f8\u673a\u9a71\u52a8";
        this.equipmentType = 33;
        this.description = "\u7528\u4e8e\u8f66\u724c\u8bc6\u522b";
        this.parentDriverNames = null;
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.driverType = 0;
        this.pcEquipment = false;
        this.channelEquipment = true;
        this.defaultUse = 1;
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u8f66\u724c\u8bc6\u522b\u76f8\u673a";
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }
}

