/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.ParkingSpace;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.ParkingSpaceScreenAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ParingSpaceVo;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.CommunicationHandleManger;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.SimpleAttributeHolder;
import com.wovoe.framework.communication.udp.UDPConfig;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class VSDScreenAction
extends AbstractEquipmentAction
implements ParkingSpaceScreenAction,
EquipmentConfigChanngedListener {
    private static final Object startPortUdpLock = new Object();
    public static final String NAME_UDP_PC_VSDSCREEN_HANDLE = "UDP_PC_VSDScreen_Handle";
    public static final String CONFIG_UDP_VSDSCREEN_PORT = "accept.udp.vsdscreen.port";
    private static volatile UDPConfig udpConfig;
    private volatile long lastRevMills;

    public VSDScreenAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    void start() {
        VSDScreenAction.checkUDPEndpointStart();
    }

    void stop() {
    }

    @Override
    public boolean isWorkingProperly() {
        return ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills < 11000L;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
    }

    @Override
    public void displaySpace(ParkingSpace parkingSpace) {
        List<String> channelNos;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config != null && config.getCarpark_deploy_type() == 1 && config.getNet_mode() == 2 && config.getHost_use() == 1 && (channelNos = this.equipment.getChannelNos()) != null && !channelNos.isEmpty()) {
            HostSate hostSate;
            String channelNo = channelNos.get(0);
            PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
            if (channel != null && (hostSate = channel.getLanConnectManageHostState()) != null) {
                String state;
                boolean connected = false;
                Map<String, String> enx = hostSate.getLanConnectedEqSatesMap();
                if (enx != null && (state = enx.get(this.getEquipment().getEquipmentNo())) != null && EquipmentState.CONNECTED.name().equals(state)) {
                    connected = true;
                }
                this.lastRevMills = connected ? ServiceUtil.getServiceContext().currentTimeMillis() : ServiceUtil.getServiceContext().currentTimeMillis() - 20000L;
                return;
            }
        }
        StringBuilder sbr = new StringBuilder();
        Integer displaySize = this.equipment.getEquipmentConfig().getConfigIntValue("display_count");
        int size = displaySize == null ? 1 : (displaySize < 1 ? 1 : (displaySize > 20 ? 20 : displaySize));
        String defaultKey = "r-a_0";
        sbr.append('!');
        int i = 1;
        while (i <= size) {
            int numFormat = 0;
            String spaceKey = this.equipment.getEquipmentConfig().getConfigValue("display_position_" + i + "_type");
            String txc = this.equipment.getEquipmentConfig().getConfigValue("display_position_" + i + "_numformat");
            if (txc != null && txc.length() > 0) {
                try {
                    numFormat = Integer.parseInt(txc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.checkIsValueKey(spaceKey)) {
                spaceKey = defaultKey;
            }
            ParingSpaceVo paringSpaceVo = parkingSpace.getRemainSpaceInfo(spaceKey);
            if (i > 1) {
                sbr.append('/');
            }
            if (numFormat > 1) {
                String format = "%0" + numFormat + "d";
                sbr.append(String.format(format, paringSpaceVo.getRemain()));
            } else {
                sbr.append(String.valueOf(paringSpaceVo.getRemain()));
            }
            ++i;
        }
        sbr.append('#');
        byte[] dataBytes = sbr.toString().getBytes();
        byte[] sendBytes = new byte[dataBytes.length + 2];
        sendBytes[0] = 85;
        System.arraycopy(dataBytes, 0, sendBytes, 1, dataBytes.length);
        sendBytes[sendBytes.length - 1] = -86;
        CommunicationHandle h1 = CommunicationHandleManger.getCommunicationHandle((String)NAME_UDP_PC_VSDSCREEN_HANDLE);
        if (h1 == null) {
            ServiceLog.getLog().warn((Object)"UDP_PC_VSDScreen_Handle \u672a\u6ce8\u518c!");
            return;
        }
        InetSocketAddress socektAddress = this.getDestSocketAddress();
        if (socektAddress == null) {
            return;
        }
        VSDScreenPacket appPacket = new VSDScreenPacket();
        appPacket.setAttribute("send.target.address", socektAddress);
        ByteBufferPacket sendPacket = new ByteBufferPacket(ByteBuffer.wrap(sendBytes));
        sendPacket.setSocketAddress((SocketAddress)socektAddress);
        appPacket.sendBytes = new ByteArrayPacket[]{sendPacket};
        h1.send((AppProtocolPacket)appPacket, new SendCallbackHandler(){

            public void onSendTimeout(CommunicationHandle arg0) {
            }

            public void onSendException(Throwable ex, CommunicationHandle arg1) {
                ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5f02\u5e38! " + ex.getMessage()));
            }

            public void onSendCompleted(CommunicationHandle arg0) {
            }
        });
    }

    private InetSocketAddress getDestSocketAddress() {
        InetSocketAddress socektAddress;
        String ip = this.equipment.getEquipmentConfig().getConfigValue("ip");
        if (ip == null || ip.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u4f59\u4f4d\u9519\u8bef! " + this.getEquipment().getName() + " ip\u672a\u8bbe\u7f6e"));
            return null;
        }
        Integer port = this.equipment.getEquipmentConfig().getConfigIntValue("netPort");
        if (port == null) {
            port = 6666;
        } else if (port < 1) {
            port = 6666;
        } else if (port > 65535) {
            port = 6666;
        }
        try {
            socektAddress = new InetSocketAddress(ip, (int)port);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u4f59\u4f4d\u9519\u8bef! " + this.getEquipment().getName() + ", \u65e0\u6548\u7f51\u7edc\u5730\u5740: " + ip + ":" + port));
            return null;
        }
        return socektAddress;
    }

    private boolean checkIsValueKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        if (!key.startsWith("r-")) {
            return false;
        }
        String v = key.substring(2);
        String[] vs = v.split("-");
        if (vs.length == 1) {
            if (vs[0].startsWith("a_")) {
                if ("a_0".equals(vs[0])) {
                    return true;
                }
                String areaNo = vs[0].substring(2);
                return ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(areaNo) != null;
            }
        } else if (vs.length == 2 && vs[0].startsWith("a_") && (vs[1].startsWith("d_") || vs[1].startsWith("s_"))) {
            Map<String, String> spaceTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap();
            if (spaceTypeMap == null) {
                return false;
            }
            String areaNo = vs[0].substring(2);
            String spaceTypeNo = vs[1].substring(2);
            return ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap().get(areaNo) != null && spaceTypeMap.get(spaceTypeNo) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUDPEndpointStart() {
        Object object = startPortUdpLock;
        synchronized (object) {
            if (ServiceUtil.getServiceContext().getUDPEndpoint().isShutdown()) {
                return;
            }
            if (udpConfig != null) {
                UDPConfig config = ServiceUtil.getServiceContext().getUDPEndpoint().getUDPConfig(NAME_UDP_PC_VSDSCREEN_HANDLE);
                if (config == null) {
                    udpConfig = null;
                } else if (config.getAcceptPort() != udpConfig.getAcceptPort()) {
                    udpConfig = config;
                }
            }
            if (udpConfig == null && ServiceUtil.getServiceContext().getUDPEndpoint().getUDPConfig(NAME_UDP_PC_VSDSCREEN_HANDLE) == null) {
                String v = ServiceUtil.getServiceContext().getConfig().getProperty(CONFIG_UDP_VSDSCREEN_PORT, "").trim();
                int portp = -1;
                if (v != null && v.length() > 0) {
                    try {
                        portp = Integer.parseInt(v);
                    }
                    catch (Exception ex) {
                        portp = -1;
                    }
                }
                if (portp <= 0 || portp > 65535) {
                    int end = 10000;
                    int begin = 6171;
                    boolean success = false;
                    int port = begin;
                    while (port < end) {
                        VSDScreenUDPConfig udpConfig0 = new VSDScreenUDPConfig(port);
                        try {
                            ServiceUtil.getServiceContext().getUDPEndpoint().bind((UDPConfig)udpConfig0);
                            success = true;
                            udpConfig = udpConfig0;
                            break;
                        }
                        catch (Exception e) {
                            ServiceLog.getLog().warn((Object)e.getMessage(), (Throwable)e);
                            ++port;
                        }
                    }
                    if (!success) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(new Object(), "\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8", 3, 12000));
                        ServiceLog.getLog().warn((Object)("\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8"));
                    }
                } else {
                    VSDScreenUDPConfig udpConfig0 = new VSDScreenUDPConfig(portp);
                    try {
                        ServiceUtil.getServiceContext().getUDPEndpoint().bind((UDPConfig)udpConfig0);
                        udpConfig = udpConfig0;
                    }
                    catch (Exception e) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(udpConfig0, "\u9519\u8bef\uff1a\u65e0\u6cd5\u5728\u7aef\u53e3" + portp + "\u542f\u52a8UDP\u4fa6\u542c\uff0c\u539f\u56e0: " + e.getMessage(), 3, 12000));
                        ServiceLog.getLog().warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private static class VSDScreenPacket
    extends SimpleAttributeHolder
    implements AppProtocolPacket {
        private ByteArrayPacket[] sendBytes;

        private VSDScreenPacket() {
        }
    }

    private static class VSDScreenUDPConfig
    implements UDPConfig {
        private int port;

        public VSDScreenUDPConfig(int port) {
            this.port = port;
        }

        public ProtocolHandlerChain createProtocolHandlerChain(UDPEndpoint udpEndpoint) {
            ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
            rwchain.appendNextProtocolHandler((ProtocolHandler)new VSDScreenUDPProtocol());
            rwchain.appendNextProtocolHandler((ProtocolHandler)new RootWriteProtocolHandler());
            return rwchain;
        }

        public int getACKTimeoutMills() {
            return 0;
        }

        public String getAcceptName() {
            return VSDScreenAction.NAME_UDP_PC_VSDSCREEN_HANDLE;
        }

        public int getAcceptPort() {
            return this.port;
        }

        public int getReSendTimes() {
            return 0;
        }
    }

    private static class VSDScreenUDPProtocol
    extends AbstractProtocolHandler {
        private VSDScreenUDPProtocol() {
        }

        protected boolean handleRead(ProtocolContext context) throws Exception {
            if (context.getMessage() instanceof ByteArrayPacket) {
                Collection<Equipment> col;
                ByteArrayPacket byteArray = (ByteArrayPacket)context.getMessage();
                SocketAddress sourceAddress = (SocketAddress)context.getAttribute("receive.source.address");
                if (sourceAddress != null && sourceAddress instanceof InetSocketAddress && (col = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10)) != null) {
                    for (Equipment eq : col) {
                        VSDScreenAction action;
                        InetSocketAddress socektAddress;
                        if (!(eq.getEquipmentAction() instanceof VSDScreenAction) || (socektAddress = (action = (VSDScreenAction)eq.getEquipmentAction()).getDestSocketAddress()) == null || !socektAddress.equals((InetSocketAddress)sourceAddress)) continue;
                        if (byteArray.getByteArray() != null && byteArray.getByteArrayLength() == 2 && byteArray.getByteArray()[byteArray.getByteArrayOffset()] == 79 && byteArray.getByteArray()[byteArray.getByteArrayOffset() + 1] == 75) {
                            action.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                            break;
                        }
                        String ax = byteArray.getByteArrayLength() == 0 ? "\u8fd4\u56de0\u4e2a\u5b57\u8282\u957f\u5ea6\u6570\u636e" : BytesTool.byteArrayToHexString((byte[])byteArray.getByteArray(), (int)byteArray.getByteArrayOffset(), (int)byteArray.getByteArrayLength()).toUpperCase();
                        ServiceLog.getLog().warn((Object)("\u5411\u4f59\u4f4d\u5c4f: " + action.getEquipment().getName() + ", " + socektAddress + " \u53d1\u9001\u4f59\u4f4d\u540e\u8fd4\u56de\u9519\u8bef\u7684\u6570\u636e, HEX: " + ax));
                        break;
                    }
                }
            }
            return true;
        }

        protected boolean handleWrite(ProtocolContext context) throws Exception {
            Object message = context.getMessage();
            if (message instanceof VSDScreenPacket) {
                VSDScreenPacket p = (VSDScreenPacket)((Object)message);
                if (p.sendBytes == null || p.sendBytes.length == 0) {
                    return false;
                }
                context.setMessage((Object)p.sendBytes);
            }
            return true;
        }
    }
}

