/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.VSDScreenAction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VSDScreenDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_vsd_net_screen_driver";

    public VSDScreenDriver() {
        this.init();
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("VSD")) + "\u4f59\u4f4d\u5c4f\u63a7\u5236\u5361\u3010\u7f51\u53e3\u3011\u9a71\u52a8";
        this.parentDriverNames = null;
        this.equipmentType = 10;
        this.defaultUse = 2;
        this.description = "\u7528\u4e8e\u663e\u793a\u4f59\u4f4d\u4fe1\u606f";
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(2, "\u4f59\u4f4d\u4fe1\u606f\u5c4f");
        return m;
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u4f59\u4f4d\u5c4f";
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        VSDScreenAction c = new VSDScreenAction(equipment, this);
        this.setAction(equipment, c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        ((VSDScreenAction)equipment.getEquipmentAction()).stop();
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        Map<String, String> spaceTypeMap;
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("ip");
        p.setParameterNameDes("IP\u5730\u5740");
        p.setUnique(true);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("netPort");
        p.setParameterNameDes("\u8fde\u63a5\u7aef\u53e3");
        p.setParameterDefaultValue("6666");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_count");
        p.setParameterNameDes("\u5c4f\u5206\u533a\u663e\u793a\u6570\u91cf");
        p.setParameterDefaultValue("1");
        p.setInputType(1);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>();
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"1\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"2\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"3", (Object)"3\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4", (Object)"4\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"5", (Object)"5\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"6", (Object)"6\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"7", (Object)"7\u4e2a\u663e\u793a\u533a"));
        parameterSelectValues.add(new KeyValueEntry((Object)"8", (Object)"8\u4e2a\u663e\u793a\u533a"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        LinkedList<KeyValueEntry<String, String>> parameterSelectValues1 = new LinkedList<KeyValueEntry<String, String>>();
        parameterSelectValues1.add(new KeyValueEntry((Object)"r-a_0", (Object)"\u6240\u6709\u573a\u533a\u603b\u4f59\u4f4d"));
        Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
        if (areaMap != null) {
            for (CarparkArea area : areaMap.values()) {
                if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                    parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + "\u4f59\u4f4d(\u542b\u5b50\u533a\u57df)")));
                    parameterSelectValues1.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)("r-as_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + "\u4f59\u4f4d(\u4e0d\u542b\u5b50\u533a\u57df)")));
                    continue;
                }
                parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + "\u4f59\u4f4d")));
            }
        }
        if ((spaceTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap()) != null && !spaceTypeMap.isEmpty()) {
            for (Map.Entry<String, String> s1 : spaceTypeMap.entrySet()) {
                if (areaMap == null || areaMap.isEmpty()) continue;
                for (CarparkArea area : areaMap.values()) {
                    if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                        parameterSelectValues1.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)("r-a_" + area.getArea_no() + "-d_" + s1.getKey()), (Object)(String.valueOf(area.getArea_name()) + s1.getValue() + "\u4f59\u4f4d(\u542b\u5b50\u533a\u57df)")));
                        parameterSelectValues1.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)("r-a_" + area.getArea_no() + "-s_" + s1.getKey()), (Object)(String.valueOf(area.getArea_name()) + s1.getValue() + "\u4f59\u4f4d(\u4e0d\u542b\u5b50\u533a\u57df)")));
                        continue;
                    }
                    parameterSelectValues1.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)("r-a_" + area.getArea_no() + "-d_" + s1.getKey()), (Object)(String.valueOf(area.getArea_name()) + s1.getValue() + "\u4f59\u4f4d")));
                }
            }
        }
        int i = 1;
        while (i <= parameterSelectValues.size()) {
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_type");
            p.setParameterNameDes("\u7b2c" + i + "\u5757\u533a\u57df\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setParameterDefaultValue("2");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_numformat");
            p.setParameterNameDes("\u7b2c" + i + "\u5757\u533a\u57df\u6700\u5c0f\u663e\u793a\u4f4d\u6570");
            p.setParameterDefaultValue("1");
            p.setUse(2);
            pl.add(p);
            ++i;
        }
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }
}

