/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.RsuAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.http.HttpUtil;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class WanjiRsuAction
extends AbstractEquipmentAction
implements RsuAction {
    private static Map<String, String> errCodeDesMap = new HashMap<String, String>();
    private static final String SUCCESS = "0000";
    private static final String REQUEST_SUCCESS = "SUCCESS";
    private static final String R_CODE = "rCode";
    private static long MILLS_20200101000;
    private volatile long conectMills;
    private final Object lock = new Object();
    private ScheduledFuture<?> scheduledFuture;
    private AtomicBoolean downloadingBlackList = new AtomicBoolean(false);

    static {
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        cl.set(2020, 0, 1, 0, 0, 0);
        MILLS_20200101000 = cl.getTimeInMillis();
        errCodeDesMap.put("2001", "\u62a5\u6587\u89e3\u6790\u9519\u8bef");
        errCodeDesMap.put("2002", "\u53c2\u6570\u3001\u683c\u5f0f\u65e0\u6548");
        errCodeDesMap.put("2003", "\u6570\u636e\u5408\u6cd5\u6027\u51fa\u9519");
        errCodeDesMap.put("2004", "\u7cfb\u7edf\u547d\u4ee4\u91cd\u590d\u4e0d\u4e88\u5904\u7406");
        errCodeDesMap.put("2005", "\u6307\u5b9a\u7f16\u53f7\u8f66\u573a\u672a\u5728\u7ebf");
        errCodeDesMap.put("2006", "\u7cfb\u7edf\u672a\u5c31\u7eea");
        errCodeDesMap.put("2007", "\u7cfb\u7edf\u9519\u8bef");
        errCodeDesMap.put("3001", "\u8d85\u65f6\u672a\u68c0\u6d4b\u5230 OBU");
        errCodeDesMap.put("3002", "OBU \u89e3\u5bc6\u5931\u8d25");
        errCodeDesMap.put("3003", "OBU \u8fc7\u671f");
        errCodeDesMap.put("3004", "OBU \u88ab\u62c6\u5378");
        errCodeDesMap.put("3005", "\u672a\u627e\u5230\u5bf9\u5e94\u8f66\u724c\u7684 OBU");
        errCodeDesMap.put("3006", "OBU \u672a\u68c0\u6d4b\u5230 IC \u5361");
        errCodeDesMap.put("4001", "IC \u5361\u8fc7\u671f");
        errCodeDesMap.put("4002", "IC \u5361\u672a\u6fc0\u6d3b");
        errCodeDesMap.put("4003", "IC \u5361\u672a\u7ed1\u5b9a\uff08\u5361\u548c OBU \u4e0d\u4e00\u81f4\uff09");
        errCodeDesMap.put("4004", "\u8bfb\u53d6 0015 \u6587\u4ef6\u5931\u8d25");
        errCodeDesMap.put("4005", "\u8f66\u5361\u4e0d\u4e00\u81f4\uff08\u9650\u4e8c\u7248\u5361\uff09\uff08\u9650\u5237\u5361\uff09");
        errCodeDesMap.put("4006", "\u672a\u77e5\u7c7b\u578b\u7684 IC \u5361");
        errCodeDesMap.put("4007", "\u590d\u4f4d\u9519\u8bef");
        errCodeDesMap.put("4008", "\u6d88\u8d39\u8ba4\u8bc1\u5931\u8d25");
        errCodeDesMap.put("4009", "\u6263\u8d39\u5931\u8d25");
        errCodeDesMap.put("4010", "MAC1 \u6821\u9a8c\u5931\u8d25");
        errCodeDesMap.put("4011", "MAC2 \u6821\u9a8c\u5931\u8d25");
        errCodeDesMap.put("4012", "\u83b7\u53d6\u5361\u7247\u4f59\u989d\u5931\u8d25");
        errCodeDesMap.put("4013", "\u6d88\u8d39\u8865\u507f\u64cd\u4f5c\u5931\u8d25");
        errCodeDesMap.put("4014", "IC \u5361\u9ed1\u540d\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7");
        errCodeDesMap.put("4015", "IC \u4f59\u989d\u4e0d\u8db3");
        errCodeDesMap.put("4016", "24 \u5c0f\u65f6\u9ed1\u540d\u5355\u4e0b\u8f7d\u5931\u8d25");
        errCodeDesMap.put("5001", "\u5929\u7ebf\u672a\u6253\u5f00");
        errCodeDesMap.put("5002", "\u5929\u7ebf\u6253\u5f00\u4e32\u53e3\u5931\u8d25");
        errCodeDesMap.put("6001", "\u8bfb\u5361\u5668\u672a\u6253\u5f00");
        errCodeDesMap.put("6002", "\u8bfb\u5361\u5668\u521d\u59cb\u5316\u5931\u8d25");
        errCodeDesMap.put("6003", "\u8bfb\u5361\u5668/\u667a\u80fd\u7ec8\u7aef\u4e0d\u5b58\u5728");
        errCodeDesMap.put("6004", "\u5f53\u524d\u8bbe\u522b\u88ab\u5360\u7528");
        errCodeDesMap.put("7001", "\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728");
        errCodeDesMap.put("7002", "\u6263\u8d39\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e");
        errCodeDesMap.put("7003", "RSU \u6263\u8d39\u5f02\u5e38\uff0c\u8f6c\u8bfb\u5361\u5668\u505a\u4ea4\u6613\u8865\u507f");
        errCodeDesMap.put("7004", "\u4ea4\u6613\u8d85\u65f6");
        errCodeDesMap.put("7005", "\u91cd\u590d\u6263\u8d39");
        errCodeDesMap.put("7006", "\u4ea4\u6613\u8fdb\u884c\u4e2d");
        errCodeDesMap.put("7007", "\u4ea4\u6613\u8bb0\u5f55\u4e0d\u5b58\u5728(\u4ec5\u9650\u4ea4\u6613\u67e5\u8be2\u63a5\u53e3)");
        errCodeDesMap.put("7008", "\u8f66\u724c\u53f7\u8bfb\u53d6\u9519\u8bef");
        errCodeDesMap.put("7009", "\u5f53\u524d\u8f66\u9053\u6709\u4ea4\u6613\u5b58\u5728");
        errCodeDesMap.put("7010", "\u7a0b\u5e8f\u4e0d\u53ef\u8fde");
        errCodeDesMap.put("7011", "\u8f66\u9053\u53f7\u4e0d\u5b58\u5728");
        errCodeDesMap.put("7012", "\u4ea4\u6613\u6570\u636e\u5199\u5165\u5931\u8d25");
    }

    public WanjiRsuAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.scheduledFuture == null) {
            this.scheduledFuture = ServiceUtil.getServiceContext().schedule(new JobTask(){

                protected void doRun() throws Exception {
                    WanjiRsuAction.this.heartBeat();
                }
            }, 3000L, 7000L, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stop() {
        ScheduledFuture<?> scheduledFuture0 = this.scheduledFuture;
        if (scheduledFuture0 != null) {
            this.scheduledFuture = null;
            scheduledFuture0.cancel(true);
        }
        this.downloadingBlackList.set(false);
    }

    private void heartBeat() {
        try {
            int port;
            String domain;
            int h;
            String s;
            String laneId = this.getLaneId();
            if (laneId == null || laneId.length() == 0) {
                this.conectMills = 0L;
                return;
            }
            String requestUrl = this.getRequstUrl();
            if (requestUrl == null || requestUrl.length() == 0) {
                this.conectMills = 0L;
                return;
            }
            if (requestUrl.startsWith("http://")) {
                s = requestUrl.substring(7);
                h = s.indexOf(47);
                if (h != -1) {
                    s = s.substring(0, h);
                }
                if ((h = s.indexOf(58)) != -1) {
                    domain = s.substring(0, h);
                    try {
                        port = Integer.parseInt(s.substring(h + 1));
                    }
                    catch (Exception ex) {
                        this.conectMills = 0L;
                        return;
                    }
                } else {
                    domain = s;
                    port = 80;
                }
            } else if (requestUrl.startsWith("https://")) {
                s = requestUrl.substring(8);
                h = s.indexOf(47);
                if (h != -1) {
                    s = s.substring(0, h);
                }
                if ((h = s.indexOf(58)) != -1) {
                    domain = s.substring(0, h);
                    try {
                        port = Integer.parseInt(s.substring(h + 1));
                    }
                    catch (Exception ex) {
                        this.conectMills = 0L;
                        return;
                    }
                } else {
                    domain = s;
                    port = 443;
                }
            } else {
                this.conectMills = 0L;
                return;
            }
            boolean success = false;
            try {
                Socket socket = new Socket();
                try {
                    socket.connect(new InetSocketAddress(InetAddress.getByName(domain), port), 6000);
                    success = true;
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().info((Object)("\u65e0\u6cd5\u8fde\u63a5ETC\u5730\u5740\uff1a" + domain + ":" + port));
            }
            if (success) {
                this.conectMills = ServiceUtil.getServiceContext().currentTimeMillis();
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public boolean isWorkingProperly() {
        if (this.getRequstUrl() == null || this.getIntegratorId() == null || this.getLotCode() == null || this.getLaneId() == null || this.getToken() == null) {
            this.conectMills = 0L;
            return false;
        }
        return ServiceUtil.getServiceContext().currentTimeMillis() - this.conectMills < 15000L;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    private String createRequestJson(Map<String, String> requestMap) {
        if (requestMap == null) {
            return null;
        }
        return GsonBuilder.create().toJson(requestMap);
    }

    private String getIntegratorId() {
        return this.getConfigValue("integratorId");
    }

    private String getLotCode() {
        return this.getConfigValue("lotCode");
    }

    private String getLaneId() {
        return this.getConfigValue("laneId");
    }

    private String getRequstUrl() {
        String url = this.getConfigValue("request_url");
        if (url != null && !url.startsWith("http://") && !url.startsWith("https://")) {
            url = null;
        }
        return url;
    }

    private String getConfigValue(String key) {
        String v = this.getEquipment().getEquipmentConfig().getConfigValue(key);
        if (v == null || v.length() == 0) {
            return null;
        }
        return v;
    }

    private String getToken() {
        String token;
        block4: {
            try {
                token = this.getConfigValue("token_secret_key");
                if (token != null && token.length() != 0) break block4;
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        String v = new String(BytesTool.unCompress((String)token), "UTF-8");
        if (v == null || v.length() == 0) {
            return v;
        }
        return v;
    }

    private Map<String, String> createRequestMap(Object jsonData) {
        if (jsonData == null) {
            return null;
        }
        String integratorId = this.getIntegratorId();
        if (integratorId == null || integratorId.length() == 0) {
            return null;
        }
        String lotCode = this.getLotCode();
        if (lotCode == null || lotCode.length() == 0) {
            return null;
        }
        String token = this.getToken();
        if (token == null || token.length() == 0) {
            return null;
        }
        String ts = String.valueOf(System.currentTimeMillis() / 1000L);
        LinkedHashMap<String, String> requsetMap = new LinkedHashMap<String, String>();
        String cmd = "ETC";
        requsetMap.put("cmd", cmd);
        requsetMap.put("integratorId", integratorId);
        requsetMap.put("lotCode", lotCode);
        requsetMap.put("ts", ts);
        String auth = CryptoUtil.MD5Encode((String)(String.valueOf(cmd) + integratorId + lotCode + ts + token)).toLowerCase();
        requsetMap.put("auth", auth);
        requsetMap.put("data", GsonBuilder.create().toJson(jsonData));
        return requsetMap;
    }

    private void downloadBlackList() {
    }

    private <T> KeyValueEntry<String, T> doRquest(Object dataMap, Class<?> resultClass, int connectTimeoutMills, int readTimeout) {
        Object returnMap;
        String resultJosn;
        if (dataMap == null) {
            return new KeyValueEntry((Object)"PARAM_ERROR", null);
        }
        String requestUrl = this.getRequstUrl();
        if (requestUrl == null || requestUrl.length() == 0) {
            return new KeyValueEntry((Object)"CONFIG_ERROR", null);
        }
        Map<String, String> requestMap = this.createRequestMap(dataMap);
        if (requestMap == null) {
            return new KeyValueEntry((Object)"CONFIG_ERROR", null);
        }
        String requestJon = this.createRequestJson(requestMap);
        try {
            if (connectTimeoutMills <= 0) {
                connectTimeoutMills = 5000;
            }
            if (readTimeout <= 0) {
                readTimeout = 7000;
            }
            resultJosn = HttpUtil.doJsonRquest((String)requestUrl, null, (String)requestJon, (int)connectTimeoutMills, (int)readTimeout);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + "\u7f51\u7edc\u5f02\u5e38\uff01" + ex));
            return new KeyValueEntry((Object)"REQUEST_ERROR", null);
        }
        if (resultJosn == null || resultJosn.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + ", \u8fd4\u56de\u7a7a\u503c"));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", null);
        }
        try {
            if (Map.class.equals(resultClass)) {
                Map returnMap0 = (Map)GsonBuilder.create().fromJson(resultJosn, new TypeToken<Map<String, String>>(){}.getType());
                String rCode = (String)returnMap0.get(R_CODE);
                if (rCode == null || rCode.length() == 0) {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + ", \u8fd4\u56de\u6570\u636e\u7f3a\u5c11rCode:" + resultJosn));
                    return new KeyValueEntry((Object)"RESPONSE_ERROR", null);
                }
                if (rCode.startsWith("20")) {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + ",\u901a\u4fe1\u5f02\u5e38\uff01 \u8fd4\u56de\u6570\u636e:" + resultJosn));
                }
                returnMap0.put("responseJson", resultJosn);
                returnMap = returnMap0;
                if ("4016".equals(rCode)) {
                    this.downloadBlackList();
                }
            } else {
                returnMap = GsonBuilder.create().fromJson(resultJosn, resultClass);
                if (returnMap instanceof DeductResult) {
                    DeductResult result = (DeductResult)returnMap;
                    if (result.getRcode() == null || result.getRcode().length() == 0) {
                        ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + ", \u8fd4\u56de\u6570\u636e\u7f3a\u5c11rCode:" + resultJosn));
                        return new KeyValueEntry((Object)"RESPONSE_ERROR", null);
                    }
                    if ("4016".equals(result.getRcode())) {
                        this.downloadBlackList();
                    }
                    result.setResponseJson(resultJosn);
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u8bf7\u6c42ETC\u5730\u5740\uff1a" + requestUrl + ", \u6570\u636e\uff1a" + requestJon + ", \u8fd4\u56de\u4e0d\u662fjson\u7684\u6570\u636e:" + resultJosn));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", null);
        }
        return new KeyValueEntry((Object)REQUEST_SUCCESS, returnMap);
    }

    @Override
    public boolean isSupportDeduct() {
        CarparkHost host;
        String slaveHostNo;
        List<String> channelNos = this.equipment.getChannelNos();
        String channelNo = null;
        if (channelNos != null && !channelNos.isEmpty()) {
            channelNo = channelNos.get(0);
        }
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            return false;
        }
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        return config == null || config.getHost_use() != 1 || config.getNet_mode() != 2 || config.getCarpark_deploy_type() != 1 || (slaveHostNo = channel.getChannel().getSlave_managed_host_no()) == null || slaveHostNo.length() <= 0 || slaveHostNo.equals(ServiceUtil.getServiceContext().getLocalHostNo()) || (host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(slaveHostNo)) == null || host.getHost_use() != 1 || host.getNet_mode() != 2;
    }

    String getVehplateColor(String plateColor) {
        if (plateColor == null || plateColor.length() == 0) {
            return "0";
        }
        if (plateColor.indexOf(34013) != -1) {
            return "0";
        }
        if (plateColor.indexOf("\u7eff\u9ec4") != -1 || plateColor.indexOf("\u9ec4\u7eff") != -1) {
            return "5";
        }
        if (plateColor.indexOf("\u7eff\u767d") != -1 || plateColor.indexOf("\u767d\u7eff") != -1) {
            return "4";
        }
        if (plateColor.indexOf("\u7eff") != -1) {
            return "6";
        }
        if (plateColor.indexOf("\u9ec4") != -1) {
            return "1";
        }
        if (plateColor.indexOf("\u9ed1") != -1) {
            return "2";
        }
        if (plateColor.indexOf("\u767d") != -1) {
            return "3";
        }
        return "0";
    }

    private String getParkTime(Date enterTime, Date exitTime) {
        int hour;
        int tSec = (int)((exitTime.getTime() - enterTime.getTime()) / 1000L);
        if (tSec <= 0) {
            return "0\u52060\u79d2";
        }
        int sec = tSec % 60;
        int tminite = sec / 60;
        int minite = tminite % 60;
        int thour = tminite / 60;
        int day = 0;
        if (thour > 24) {
            day = thour / 24;
            hour = thour % 24;
        } else {
            hour = thour;
        }
        StringBuffer b = new StringBuffer();
        if (day > 0) {
            b.append(day).append("\u5929");
            b.append(hour).append("\u5c0f\u65f6");
        } else if (hour > 0) {
            b.append(hour).append("\u5c0f\u65f6");
        }
        b.append(minite).append("\u5206").append(sec).append("\u79d2");
        return b.toString();
    }

    private String createSerialNo(String plateNumber, Date time) {
        byte[] plateB;
        try {
            plateB = plateNumber.getBytes("GBK");
        }
        catch (Exception ex) {
            plateB = plateNumber.getBytes();
        }
        int plateLen = plateB.length;
        if (plateLen > 11) {
            plateLen = 11;
        }
        int maxLen = 16;
        int r1 = maxLen - 4 - plateLen;
        byte[] rm = new byte[maxLen];
        int sec = (int)((time.getTime() - MILLS_20200101000) / 1000L);
        byte[] timeBytes = BytesTool.intToBytes((int)sec);
        System.arraycopy(timeBytes, 0, rm, 0, timeBytes.length);
        System.arraycopy(plateB, 0, rm, 4, plateLen);
        int i = plateLen + 4;
        while (i < maxLen) {
            rm[i] = (byte)r1;
            ++i;
        }
        return BytesTool.byteArrayToHexString((byte[])rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueEntry<String, Object> deduct(String plateNumber, String plateColor, BigDecimal deductMoney, Date enterTime, Date exitTime, String enterRecordNo, Map<String, Object> dedcutContext) {
        Object object = this.lock;
        synchronized (object) {
            if (plateNumber == null || plateNumber.length() == 0) {
                return new KeyValueEntry((Object)"PARAM_ERROR", (Object)"\u7f3a\u5c11\u8f66\u724c\u53f7");
            }
            if (deductMoney == null) {
                return new KeyValueEntry((Object)"PARAM_ERROR", (Object)"\u7f3a\u5c11\u6263\u8d39\u91d1\u989d");
            }
            int money = (int)(deductMoney.doubleValue() * 100.0);
            if (money <= 0) {
                return new KeyValueEntry((Object)"PARAM_ERROR", (Object)"\u6263\u8d39\u91d1\u989d\u4e0d\u5f97\u5c11\u4e8e1\u5206\u94b1");
            }
            if (enterTime == null) {
                return new KeyValueEntry((Object)"PARAM_ERROR", (Object)"\u7f3a\u5c11\u8fdb\u573a\u65f6\u95f4");
            }
            if (exitTime == null) {
                return new KeyValueEntry((Object)"PARAM_ERROR", (Object)"\u7f3a\u5c11\u79bb\u573a\u65f6\u95f4");
            }
            String laneId = this.getLaneId();
            if (laneId == null || laneId.length() == 0) {
                return new KeyValueEntry((Object)"CONFIG_ERROR", (Object)"laneId\u4e3a\u914d\u7f6e");
            }
            String vehplateColor = this.getVehplateColor(plateColor);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String paySerialNo = this.createSerialNo(plateNumber, enterTime);
            LinkedHashMap<String, Object> deductMap = new LinkedHashMap<String, Object>();
            deductMap.put("laneId", laneId);
            deductMap.put("sType", "9001");
            deductMap.put("tType", "0");
            deductMap.put("paySerialNo", paySerialNo);
            deductMap.put("transAmount", money);
            deductMap.put("vehplateColor", vehplateColor);
            deductMap.put("vehplateNo", plateNumber);
            deductMap.put("parkTime", this.getParkTime(enterTime, exitTime));
            deductMap.put("enterTime", df.format(enterTime));
            deductMap.put("leaveTime", df.format(exitTime));
            String exitOrderNo = paySerialNo;
            deductMap.put("exitOrderNo", exitOrderNo);
            deductMap.put("file1", "");
            deductMap.put("file2", "");
            deductMap.put("file3", "");
            deductMap.put("file4", "");
            deductMap.put("file5", "");
            KeyValueEntry kv = this.doRquest(deductMap, DeductResult.class, 5000, 10000);
            if (!REQUEST_SUCCESS.equals(kv.getKey())) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u539f\u56e0\uff1a" + (String)kv.getKey()));
                return new KeyValueEntry((Object)((String)kv.getKey()), (Object)"\u6263\u8d39\u5931\u8d25");
            }
            DeductResult result = (DeductResult)kv.getValue();
            if (!SUCCESS.equals(result.getRcode())) {
                String errMsg = errCodeDesMap.get(result.getRcode());
                if (errMsg == null || errMsg.length() == 0) {
                    errMsg = "\u672a\u77e5";
                }
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u7801: " + result.getRcode() + ", \u539f\u56e0\uff1a" + errMsg + ", \u54cd\u5e94json:" + result.getResponseJson()));
                return new KeyValueEntry((Object)"ERROR", (Object)"\u6263\u8d39\u5931\u8d25");
            }
            if (result.getPaySerialNo() == null || result.getPaySerialNo().length() == 0) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u64cd\u4f5c\u6210\u529f,\u4f46\u662f\u7f3a\u5c11paySerialNo, \u54cd\u5e94json:" + result.getResponseJson()));
                return new KeyValueEntry((Object)"ERROR", (Object)"\u6263\u8d39\u5931\u8d25");
            }
            if (!paySerialNo.equals(result.getPaySerialNo())) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u64cd\u4f5c\u6210\u529f,\u8bf7\u6c42paySerialNo\u4e0e\u54cd\u5e94\u7684\u4e0d\u76f8\u7b49\uff01 \u8bf7\u6c42\u7684\u662f" + paySerialNo + ", \u54cd\u5e94json:" + result.getResponseJson()));
                return new KeyValueEntry((Object)"ERROR", (Object)"\u6263\u8d39\u5931\u8d25");
            }
            if (result.getTransAmount() == null) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u64cd\u4f5c\u6210\u529f,\u4f46\u662f\u7f3a\u5c11transAmount, \u54cd\u5e94json:" + result.getResponseJson()));
                return new KeyValueEntry((Object)"ERROR", (Object)"\u6263\u8d39\u5931\u8d25");
            }
            if (result.getTransAmount() <= 0) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u8bf7\u6c42\u5931\u8d25\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u64cd\u4f5c\u6210\u529f,\u4f46\u662f\u8fd4\u56de\u4ea4\u6613\u91d1\u989d: " + result.getTransAmount() + "\u9519\u8bef, \u54cd\u5e94json:" + result.getResponseJson()));
                return new KeyValueEntry((Object)"ERROR", (Object)"\u6263\u8d39\u5931\u8d25");
            }
            if (result.getTransAmount() != money) {
                ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u7684\u91d1\u989d\u548c\u8bf7\u6c42\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff01\u8f66\u724c\uff1a" + plateNumber + ", \u8fd4\u56de\u64cd\u4f5c\u6210\u529f,\u4f46\u662f\u4ea4\u6613\u91d1\u989dtransAmount\u4e0d\u7b49\u4e8e\u8bf7\u6c42\u7684" + money + ", \u54cd\u5e94json:" + result.getResponseJson()));
            } else {
                ServiceLog.getLog().info((Object)("ETC\u6263\u8d39\u6210\u529f\uff01\u8f66\u724c: " + plateNumber + ", \u6263\u8d39\u91d1\u989d: " + deductMoney + "\u5143\uff0c\u54cd\u5e94\u6570\u636e: " + result.getResponseJson()));
            }
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            Date tranDate = cl.getTime();
            if (result.getTransTime() != null && result.getTransTime().length() > 0) {
                try {
                    Date d = df.parse(result.getTransTime());
                    long x = tranDate.getTime() / 1000L - d.getTime() / 1000L;
                    int x1 = (int)Math.abs(x);
                    if (x1 >= 15) {
                        ServiceLog.getLog().warn((Object)("ETC\u6263\u8d39\u7684\u65f6\u95f4\u4e0e\u7cfb\u7edf\u65f6\u95f4\u8bef\u5dee\u8d85\u8fc715\u79d2\uff0c\u7cfb\u7edf\u65f6\u95f4:" + df.format(d) + ", \u6263\u8d39\u65f6\u95f4\uff1a" + result.getTransTime() + ", \u662f\u5426etc\u8bbe\u5907\u65f6\u95f4\u4e0e\u4e3b\u673a\u4e4b\u95f4\u7684\u8bef\u5dee\u592a\u5927"));
                    } else {
                        tranDate = d;
                    }
                }
                catch (Exception d) {
                    // empty catch block
                }
            }
            HashMap<String, Object> deuctReturnMap = new HashMap<String, Object>();
            deuctReturnMap.put("orderNo", paySerialNo);
            deuctReturnMap.put("plateNumber", plateNumber);
            deuctReturnMap.put("tranMoney", new BigDecimal(result.getTransAmount().doubleValue() / 100.0).setScale(2, 4));
            deuctReturnMap.put("tranTime", tranDate);
            if (result.getObuId() != null && result.getObuId().length() > 0) {
                deuctReturnMap.put("obuId", result.getObuId());
            }
            if (result.getPayType() != null && result.getPayType().length() > 0) {
                if ("2".equals(result.getPayType())) {
                    deuctReturnMap.put("payTypeDes", "ETC");
                } else if ("3".equals(result.getPayType())) {
                    deuctReturnMap.put("payTypeDes", "ETC-\u5fae\u4fe1");
                } else if ("4".equals(result.getPayType())) {
                    deuctReturnMap.put("payTypeDes", "ETC-\u652f\u4ed8\u5b9d");
                }
            }
            String tx = "";
            if ("06".equals(result.getTransType())) {
                tx = "\u4f20\u7edf";
            } else if ("09".equals(result.getTransType())) {
                tx = "\u590d\u5408";
            }
            if ("22".equals(result.getCardType())) {
                tx = String.valueOf(tx) + "\u50a8\u503c\u5361";
            } else if ("23".equals(result.getCardType())) {
                tx = String.valueOf(tx) + "\u8bb0\u8d26\u5361";
            }
            if (tx != null && tx.length() > 0) {
                deuctReturnMap.put("cardTypeDes", tx);
            }
            deuctReturnMap.put("originalData", result.getResponseJson());
            return new KeyValueEntry((Object)REQUEST_SUCCESS, deuctReturnMap);
        }
    }

    public static void main(String[] args) {
        int port;
        String domain;
        String requestUrl = "https://127.0.0.1:80/sss/sss";
        if (requestUrl.startsWith("http://")) {
            String s = requestUrl.substring(7);
            int h = s.indexOf(47);
            if (h != -1) {
                s = s.substring(0, h);
            }
            if ((h = s.indexOf(58)) != -1) {
                domain = s.substring(0, h);
                try {
                    port = Integer.parseInt(s.substring(h + 1));
                }
                catch (Exception ex) {
                    return;
                }
            } else {
                domain = s;
                port = 80;
            }
        } else if (requestUrl.startsWith("https://")) {
            String s = requestUrl.substring(8);
            int h = s.indexOf(47);
            if (h != -1) {
                s = s.substring(0, h);
            }
            if ((h = s.indexOf(58)) != -1) {
                domain = s.substring(0, h);
                try {
                    port = Integer.parseInt(s.substring(h + 1));
                }
                catch (Exception ex) {
                    return;
                }
            } else {
                domain = s;
                port = 443;
            }
        } else {
            return;
        }
        System.out.println(domain);
        System.out.println(port);
    }

    public static class DeductResult {
        private String laneId;
        @SerializedName(value="sType")
        private String stype;
        @SerializedName(value="rCode")
        private String rcode;
        private String paySerialNo;
        private String exitOrderNo;
        private Integer transAmount;
        private String chargingType;
        private String transTime;
        private String cardChipNo;
        private String terminalId;
        private String psamId;
        private String cardSerialNo;
        private String psamSerialNo;
        private String cardRnd;
        private String tac;
        private String cardNetNo;
        private Long transBeforeBalance;
        private Long balance;
        private String transType;
        private String cardType;
        private String deviceType;
        private String deviceNo;
        private String originalTransInfo;
        private String remark;
        private String payType;
        private String obuId;
        private String vehicleType;
        private String algorithmType;
        private String issuerIdentifier;
        private String serialNumber;
        private String responseJson;

        public String getLaneId() {
            return this.laneId;
        }

        public void setLaneId(String laneId) {
            this.laneId = laneId;
        }

        public String getStype() {
            return this.stype;
        }

        public void setStype(String stype) {
            this.stype = stype;
        }

        public String getRcode() {
            return this.rcode;
        }

        public void setRcode(String rcode) {
            this.rcode = rcode;
        }

        public String getPaySerialNo() {
            return this.paySerialNo;
        }

        public void setPaySerialNo(String paySerialNo) {
            this.paySerialNo = paySerialNo;
        }

        public String getExitOrderNo() {
            return this.exitOrderNo;
        }

        public void setExitOrderNo(String exitOrderNo) {
            this.exitOrderNo = exitOrderNo;
        }

        public Integer getTransAmount() {
            return this.transAmount;
        }

        public void setTransAmount(Integer transAmount) {
            this.transAmount = transAmount;
        }

        public String getChargingType() {
            return this.chargingType;
        }

        public void setChargingType(String chargingType) {
            this.chargingType = chargingType;
        }

        public String getTransTime() {
            return this.transTime;
        }

        public void setTransTime(String transTime) {
            this.transTime = transTime;
        }

        public String getCardChipNo() {
            return this.cardChipNo;
        }

        public void setCardChipNo(String cardChipNo) {
            this.cardChipNo = cardChipNo;
        }

        public String getTerminalId() {
            return this.terminalId;
        }

        public void setTerminalId(String terminalId) {
            this.terminalId = terminalId;
        }

        public String getPsamId() {
            return this.psamId;
        }

        public void setPsamId(String psamId) {
            this.psamId = psamId;
        }

        public String getCardSerialNo() {
            return this.cardSerialNo;
        }

        public void setCardSerialNo(String cardSerialNo) {
            this.cardSerialNo = cardSerialNo;
        }

        public String getPsamSerialNo() {
            return this.psamSerialNo;
        }

        public void setPsamSerialNo(String psamSerialNo) {
            this.psamSerialNo = psamSerialNo;
        }

        public String getCardRnd() {
            return this.cardRnd;
        }

        public void setCardRnd(String cardRnd) {
            this.cardRnd = cardRnd;
        }

        public String getTac() {
            return this.tac;
        }

        public void setTac(String tac) {
            this.tac = tac;
        }

        public String getCardNetNo() {
            return this.cardNetNo;
        }

        public void setCardNetNo(String cardNetNo) {
            this.cardNetNo = cardNetNo;
        }

        public Long getTransBeforeBalance() {
            return this.transBeforeBalance;
        }

        public void setTransBeforeBalance(Long transBeforeBalance) {
            this.transBeforeBalance = transBeforeBalance;
        }

        public Long getBalance() {
            return this.balance;
        }

        public void setBalance(Long balance) {
            this.balance = balance;
        }

        public String getTransType() {
            return this.transType;
        }

        public void setTransType(String transType) {
            this.transType = transType;
        }

        public String getCardType() {
            return this.cardType;
        }

        public void setCardType(String cardType) {
            this.cardType = cardType;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public String getDeviceNo() {
            return this.deviceNo;
        }

        public void setDeviceNo(String deviceNo) {
            this.deviceNo = deviceNo;
        }

        public String getOriginalTransInfo() {
            return this.originalTransInfo;
        }

        public void setOriginalTransInfo(String originalTransInfo) {
            this.originalTransInfo = originalTransInfo;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public String getPayType() {
            return this.payType;
        }

        public void setPayType(String payType) {
            this.payType = payType;
        }

        public String getObuId() {
            return this.obuId;
        }

        public void setObuId(String obuId) {
            this.obuId = obuId;
        }

        public String getVehicleType() {
            return this.vehicleType;
        }

        public void setVehicleType(String vehicleType) {
            this.vehicleType = vehicleType;
        }

        public String getAlgorithmType() {
            return this.algorithmType;
        }

        public void setAlgorithmType(String algorithmType) {
            this.algorithmType = algorithmType;
        }

        public String getIssuerIdentifier() {
            return this.issuerIdentifier;
        }

        public void setIssuerIdentifier(String issuerIdentifier) {
            this.issuerIdentifier = issuerIdentifier;
        }

        public String getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getResponseJson() {
            return this.responseJson;
        }

        public void setResponseJson(String responseJson) {
            this.responseJson = responseJson;
        }
    }
}

