/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.WanjiRsuAction;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WanjiRsuDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_wanji_etc_rsu_driver";

    public WanjiRsuDriver() {
        this.init();
    }

    @Override
    public String getEquipmentTypeName() {
        return "ETC[RSU]";
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(1, "ETC\u6263\u8d39");
        return m;
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        WanjiRsuAction action = new WanjiRsuAction(equipment, this);
        this.setAction(equipment, action);
        action.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        WanjiRsuAction action = (WanjiRsuAction)equipment.getEquipmentAction();
        action.stop();
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> list) {
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("request_url");
        p.setParameterNameDes("\u63a5\u53e3\u8bf7\u6c42\u5730\u5740");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("integratorId");
        p.setParameterNameDes("\u96c6\u6210\u5546ID");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("token_secret_key");
        p.setParameterNameDes("\u7b7e\u540dtoken");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("lotCode");
        p.setParameterNameDes("\u8f66\u573a\u7f16\u7801");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("laneId");
        p.setParameterNameDes("\u8f66\u9053\u7f16\u53f7");
        list.add(p);
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("WJ-RSU01")) + "ETC\u6263\u8d39\u7ec8\u7aef\u9a71\u52a8";
        this.equipmentType = 34;
        this.description = "ETC\u8bbe\u5907";
        this.parentDriverNames = null;
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.driverType = 0;
        this.pcEquipment = false;
        this.channelEquipment = true;
        this.defaultUse = 1;
    }
}

