/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WlykLaneDisplayAction
extends AbstractEquipmentAction
implements CarChannelDisplayAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private ScheduledFuture<?> shedule;
    private static final String ACTION_NAME = "/ParkingDisplayLanLaneHandleAction";
    private static int port = 5100;
    private String version;
    private long lastRevTimeMills;
    private boolean needSetConfig = true;
    private String eqIp;

    public WlykLaneDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
        opHander.setResult((Object)0);
        return opHander;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        return null;
    }

    @Override
    public EquipmentState getEquipmentState() {
        boolean workp = this.isWorkingProperly();
        if (workp) {
            return EquipmentState.CONNECTED;
        }
        return EquipmentState.DISCONNECTED;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        return null;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        return this;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (!this.isWorkingProperly()) {
                f.setException((Throwable)new IOException("Not connected"));
                return f;
            }
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(this.eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "setVolume");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("volume", String.valueOf(this.getVolumeValue(volume)));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": send set volume data error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": set volume timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        WlykLaneDisplayAction.this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        f.setResult((Object)0);
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": fail to set volume! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.eqIp) + ": set volume error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    protected int getVolumeValue(Volume volume) {
        if (volume == null) {
            return 90;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        if (night) {
            return volume.getNightVolume();
        }
        return volume.getDayVolume();
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        return this.play(text);
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public int getDisplayCount() {
        return 3;
    }

    @Override
    public boolean isSupportTrafficLights() {
        return false;
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
        h.setResult((Object)1);
        return h;
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int diplayTimes, String qrContent, String lineMsg) {
        return this.displayQrCode(diplayTimes, qrContent, lineMsg, null);
    }

    public OperationFuture<Integer> displayQrCode(int diplayTimes, String qrContent, String line1, String line2) {
        if (qrContent == null || qrContent.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u7f3a\u5c11\u4e8c\u7ef4\u7801\u5185\u5bb9"));
            return h;
        }
        return this.displayAndPlay(qrContent, null, diplayTimes, line1, line2, null, null);
    }

    synchronized void start() {
        this.equipment.addEquipmentConfigChanngedListener(this);
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.needSetConfig = true;
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                String ip = WlykLaneDisplayAction.this.equipment.getIp();
                if (ip == null || ip.length() == 0) {
                    return;
                }
                if (WlykLaneDisplayAction.this.eqIp == null || !ip.equals(WlykLaneDisplayAction.this.eqIp)) {
                    WlykLaneDisplayAction.this.eqIp = ip;
                }
                WlykLaneDisplayAction.this.sendHeartBeat();
            }
        }, 1000L, 3000L, TimeUnit.MILLISECONDS);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
            this.shedule = null;
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    private void sendHeartBeat() {
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(this.eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setAttribute("send.attempt.times", (Object)2);
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "heartbeat");
            requestSender.setHeader("synTime", "5000");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": send heart beat data error! " + ex.getMessage()));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": wait heart beat response timeout! "));
                }

                public long getWaitTimeoutMills() {
                    return 3000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        WlykLaneDisplayAction.this.version = r.getHeaderValue("version");
                        WlykLaneDisplayAction.this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (WlykLaneDisplayAction.this.needSetConfig) {
                            WlykLaneDisplayAction.this.needSetConfig = false;
                            WlykLaneDisplayAction.this.setConfig();
                        }
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": fail to keep conntion! cause: " + r.getHeaderValue("respMsg")));
                    }
                }
            });
        }
        catch (IOException e) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.eqIp) + ": send heart beat error: " + e.getMessage()));
        }
    }

    public String getVersion() {
        if (this.isWorkingProperly()) {
            return this.version;
        }
        return null;
    }

    private OperationFuture<Boolean> setConfig() {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            String qrcode_content = "qrcode_content";
            String display_qrcode = "display_qrcode";
            HashMap<String, String> configMap = new HashMap<String, String>();
            EquipmentConfig config1 = this.equipment.getEquipmentConfig();
            Enumeration<String> enus = config1.getConfigKeys();
            String configIp = "ip";
            while (enus.hasMoreElements()) {
                String configKey = enus.nextElement();
                String value = config1.getConfigValue(configKey);
                if (value == null || value.length() <= 0 || configIp.equals(configKey) || qrcode_content.equals(configKey) || display_qrcode.equals(configKey)) continue;
                configMap.put(configKey, value);
            }
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(this.eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "setDisplayConfig");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            byte[] data = GsonBuilder.create().toJson(configMap).getBytes("UTF-8");
            requestSender.setSendData(data);
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    WlykLaneDisplayAction.this.needSetConfig = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": send config data error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    WlykLaneDisplayAction.this.needSetConfig = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": set config data timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        WlykLaneDisplayAction.this.needSetConfig = false;
                        WlykLaneDisplayAction.this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        f.setResult((Object)Boolean.TRUE);
                    } else {
                        WlykLaneDisplayAction.this.needSetConfig = true;
                        ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": fail to set reomote config! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)Boolean.FALSE);
                    }
                }
            });
        }
        catch (Exception ex) {
            this.needSetConfig = true;
            ServiceLog.getLog().warn((Object)(String.valueOf(this.eqIp) + ": set remote config error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)1);
            return h;
        }
        if (displayTimes <= 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)1);
            return h;
        }
        String line1 = null;
        String line2 = null;
        String line3 = null;
        if (position == 1) {
            line1 = text;
        } else if (position == 2) {
            line2 = text;
        } else {
            line3 = text;
        }
        return this.displayAndPlay(null, null, displayTimes, line1, line2, line3, null);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        String line1 = null;
        String line2 = null;
        String line3 = null;
        if (texts != null && texts.length > 0) {
            if (texts.length == 1) {
                line1 = texts[0];
            } else if (texts.length == 2) {
                line1 = texts[0];
                line2 = texts[1];
            } else if (texts.length >= 3) {
                line1 = texts[0];
                line2 = texts[1];
                line3 = texts[2];
            }
        }
        return this.displayAndPlay(null, null, displayTimes, line1, line2, line3, null);
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    public OperationFuture<Integer> displayAndPlay(String qrCodeContent, String displayId, int displaySecs, String line1, String line2, String line3, String playText) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            Integer volume;
            if (!this.isWorkingProperly()) {
                f.setException((Throwable)new IOException("Not connected"));
                return f;
            }
            if (playText != null && playText.length() > 0 && (volume = this.equipment.getEquipmentConfig().getConfigIntValue("volume_size")) != null && volume == 0) {
                playText = null;
                if (line1 == null && line2 == null && line3 == null) {
                    f.setResult((Object)0);
                    return f;
                }
            }
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(this.eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "displayAndPlay");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            if (qrCodeContent != null && qrCodeContent.length() > 0) {
                requestSender.setHeader("eventType", "displayQrCode");
            } else if (line1 == null && line2 == null && line3 == null && playText == null) {
                requestSender.setHeader("eventType", "clearDisplay");
            } else {
                requestSender.setHeader("eventType", "displayMessage");
            }
            requestSender.setHeader("displaySecs", String.valueOf(displaySecs));
            if (qrCodeContent != null) {
                requestSender.setHeader("qrCodeContent", qrCodeContent);
            }
            if (displayId != null) {
                requestSender.setHeader("displayId", displayId);
            }
            if (line1 != null) {
                requestSender.setHeader("line1", line1);
            }
            if (line2 != null) {
                requestSender.setHeader("line2", line2);
            }
            if (line3 != null) {
                requestSender.setHeader("line3", line3);
            }
            Locale locale = WlykLaneDisplayAction.getLocale();
            String lan = String.valueOf(locale.getLanguage()) + "_" + locale.getCountry();
            requestSender.setHeader("locale", lan);
            if (playText != null) {
                requestSender.setHeader("voice", playText);
            }
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": send display data error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": display and play timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        WlykLaneDisplayAction.this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        f.setResult((Object)0);
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(WlykLaneDisplayAction.this.eqIp) + ": fail to display! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.eqIp) + ": display and play error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static Locale getLocale() {
        return Locale.CHINA;
    }

    public OperationFuture<Integer> clearDisplay(String displayId, int delaySecs) {
        return this.displayAndPlay(null, displayId, delaySecs, null, null, null, null);
    }

    @Override
    public boolean isWorkingProperly() {
        boolean connected;
        boolean bl = connected = ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevTimeMills <= 6500L;
        if (!connected) {
            this.needSetConfig = true;
        }
        return connected;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        this.setConfig();
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)1);
            return h;
        }
        Integer volume = this.equipment.getEquipmentConfig().getConfigIntValue("volume_size");
        if (volume != null && volume == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return this.displayAndPlay(null, null, 0, null, null, null, text);
    }

    public static OperationFuture<Integer> reStartApp(final String eqIp) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "reStartApp");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send restart app error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": restart app timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)0);
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to restart app! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": restart app error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<Integer> rebootSystem(final String eqIp) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "rebootSystem");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send reboot system error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": reboot system timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)0);
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to reboot system! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": reboot system error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<KeyValueEntry<String, String>> getVersion(final String eqIp, long timeoutMIlls) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "getVersion");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            final long lMills = timeoutMIlls <= 0L ? 5000L : timeoutMIlls;
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send query version data error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": get version timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return lMills;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)new KeyValueEntry((Object)r.getHeaderValue("serial"), (Object)r.getHeaderValue("version")));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to get version! cause: " + r.getHeaderValue("respMsg")));
                        f.setException((Throwable)new IOException(r.getHeaderValue("respMsg")));
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": get version error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<KeyValueEntry<String, String>> uploadPic(final String eqIp, String picTypeName, String extension, byte[] picData, long timeoutMIlls) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "uploadDisplayPic");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("picTypeName", picTypeName);
            requestSender.setHeader("extension", extension);
            requestSender.setSendData(picData);
            final long lMills = timeoutMIlls <= 0L ? 5000L : timeoutMIlls;
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send picture data error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": upload picture timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return lMills;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)"SUCCESS"));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to upload picture! cause: " + r.getHeaderValue("respMsg")));
                        f.setException((Throwable)new IOException(r.getHeaderValue("respMsg")));
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": upload picture error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<KeyValueEntry<String, String>> delDisplayPic(final String eqIp, String picTypeName, long timeoutMIlls) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "delDisplayPic");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("picTypeName", picTypeName);
            final long lMills = timeoutMIlls <= 0L ? 5000L : timeoutMIlls;
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": delete picture error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": delete picture timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return lMills;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)"SUCCESS"));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to delete picture! cause: " + r.getHeaderValue("respMsg")));
                        f.setException((Throwable)new IOException(r.getHeaderValue("respMsg")));
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": delete picture error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<Integer> downloadVideoByUrl(final String eqIp, String path, int httpPort, int crc, String notifyId, String notifyPath, String extend) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "downloadVideoByUrl");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("downloadPath", path);
            requestSender.setHeader("httpPort", String.valueOf(httpPort));
            requestSender.setHeader("crc", String.valueOf(crc));
            requestSender.setHeader("notifyId", String.valueOf(notifyId));
            requestSender.setHeader("notifyPath", notifyPath);
            requestSender.setHeader("extend", extend);
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send download video request error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": download video timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        f.setResult((Object)0);
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to download! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": download error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    public static OperationFuture<Integer> upgradeByUrl(final String eqIp, String path, int httpPort, String upgrageVersion, int crc) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getWlykDiplayUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(eqIp, port));
            RequestSender requestSender = conn.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "upgradeByUrl");
            requestSender.setHeader("tMills", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("upgradeHttpPath", path);
            requestSender.setHeader("upgradeHttpPort", String.valueOf(httpPort));
            requestSender.setHeader("version", upgrageVersion);
            requestSender.setHeader("crc", String.valueOf(crc));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable arg0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": send upgrage request error! cause: " + arg0.getMessage()));
                    f.setException(arg0);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": upgrage timeout!"));
                    f.setException((Throwable)new TimeoutException("wait response timeout"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }

                public void doReceiver(Receiver r, int arg1) throws Exception {
                    if ("SUCCESS".equals(r.getHeaderValue("respCode"))) {
                        String state = r.getHeaderValue("state");
                        if ("1".equals(state)) {
                            f.setResult((Object)0);
                        } else {
                            f.setResult((Object)10000);
                        }
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": fail to upgrage! cause: " + r.getHeaderValue("respMsg")));
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(eqIp) + ": upgrage error!"));
            f.setException((Throwable)ex);
        }
        return f;
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }
}

