/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.conn.udp.ParkingDisplayLanBroadcastServiceAction;
import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentInet;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.EquipmentSearcher;
import com.wovoe.carpark.equipment.driver.WlykLaneDisplayAction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ParkingDisplayNetwork;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WlykLaneDisplayDeriver
extends AbstractEquipmentDriver
implements EquipmentSearcher {
    public static final String DRIVER_NAME = "wlyk_lcd_net_screen_driver";

    public WlykLaneDisplayDeriver() {
        this.init();
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("YF-ARC-X001")) + " LCD\u8f66\u9053\u5c4f\u9a71\u52a8";
        this.parentDriverNames = null;
        this.equipmentType = 10;
        this.defaultUse = 1;
        this.description = "";
        this.supplier = "WLYK";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u8f66\u9053\u663e\u793a\u5c4f";
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        WlykLaneDisplayAction c = new WlykLaneDisplayAction(equipment, this);
        this.setAction(equipment, c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        ((WlykLaneDisplayAction)equipment.getEquipmentAction()).stop();
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> list) {
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("ip");
        p.setParameterNameDes("IP\u5730\u5740");
        p.setUnique(true);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("lock_screen_time");
        p.setParameterDefaultValue("0");
        p.setParameterNameDes("\u9501\u5c4f\u7a7a\u95f2\u65f6\u95f4");
        ArrayList<Object> ioList = new ArrayList<KeyValueEntry<String, String>>();
        ioList.add(new KeyValueEntry((Object)"0", (Object)"\u4ece\u4e0d"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"1 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"5", (Object)"5 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"10", (Object)"10 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"15", (Object)"15 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"30", (Object)"30 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"60", (Object)"60 \u5206\u949f"));
        ioList.add(new KeyValueEntry((Object)"120", (Object)"120 \u5206\u949f"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("volume_size");
        p.setParameterDefaultValue("90");
        p.setParameterNameDes("\u97f3\u91cf");
        ioList = new ArrayList();
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u9759\u97f3"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"1%"));
        ioList.add(new KeyValueEntry((Object)"3", (Object)"3%"));
        ioList.add(new KeyValueEntry((Object)"5", (Object)"5%"));
        ioList.add(new KeyValueEntry((Object)"8", (Object)"8%"));
        ioList.add(new KeyValueEntry((Object)"10", (Object)"10%"));
        ioList.add(new KeyValueEntry((Object)"15", (Object)"15%"));
        ioList.add(new KeyValueEntry((Object)"20", (Object)"20%"));
        ioList.add(new KeyValueEntry((Object)"25", (Object)"25%"));
        ioList.add(new KeyValueEntry((Object)"30", (Object)"30%"));
        ioList.add(new KeyValueEntry((Object)"35", (Object)"35%"));
        ioList.add(new KeyValueEntry((Object)"40", (Object)"40%"));
        ioList.add(new KeyValueEntry((Object)"45", (Object)"45%"));
        ioList.add(new KeyValueEntry((Object)"50", (Object)"50%"));
        ioList.add(new KeyValueEntry((Object)"55", (Object)"55%"));
        ioList.add(new KeyValueEntry((Object)"60", (Object)"60%"));
        ioList.add(new KeyValueEntry((Object)"65", (Object)"65%"));
        ioList.add(new KeyValueEntry((Object)"70", (Object)"70%"));
        ioList.add(new KeyValueEntry((Object)"75", (Object)"75%"));
        ioList.add(new KeyValueEntry((Object)"80", (Object)"80%"));
        ioList.add(new KeyValueEntry((Object)"83", (Object)"83%"));
        ioList.add(new KeyValueEntry((Object)"85", (Object)"85%"));
        ioList.add(new KeyValueEntry((Object)"88", (Object)"88%"));
        ioList.add(new KeyValueEntry((Object)"90", (Object)"90%"));
        ioList.add(new KeyValueEntry((Object)"93", (Object)"93%"));
        ioList.add(new KeyValueEntry((Object)"95", (Object)"95%"));
        ioList.add(new KeyValueEntry((Object)"98", (Object)"98%"));
        ioList.add(new KeyValueEntry((Object)"100", (Object)"100%"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("voice_pitch");
        p.setParameterDefaultValue("1.0");
        p.setParameterNameDes("\u97f3\u9ad8");
        ioList = new ArrayList();
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0.1", (Object)"10"));
        ioList.add(new KeyValueEntry((Object)"0.2", (Object)"20"));
        ioList.add(new KeyValueEntry((Object)"0.3", (Object)"30"));
        ioList.add(new KeyValueEntry((Object)"0.4", (Object)"40"));
        ioList.add(new KeyValueEntry((Object)"0.5", (Object)"50"));
        ioList.add(new KeyValueEntry((Object)"0.6", (Object)"60"));
        ioList.add(new KeyValueEntry((Object)"0.7", (Object)"70"));
        ioList.add(new KeyValueEntry((Object)"0.8", (Object)"80"));
        ioList.add(new KeyValueEntry((Object)"0.9", (Object)"90"));
        ioList.add(new KeyValueEntry((Object)"1.0", (Object)"100"));
        ioList.add(new KeyValueEntry((Object)"1.1", (Object)"110"));
        ioList.add(new KeyValueEntry((Object)"1.2", (Object)"120"));
        ioList.add(new KeyValueEntry((Object)"1.3", (Object)"130"));
        ioList.add(new KeyValueEntry((Object)"1.4", (Object)"140"));
        ioList.add(new KeyValueEntry((Object)"1.5", (Object)"150"));
        ioList.add(new KeyValueEntry((Object)"1.6", (Object)"160"));
        ioList.add(new KeyValueEntry((Object)"1.7", (Object)"170"));
        ioList.add(new KeyValueEntry((Object)"1.8", (Object)"180"));
        ioList.add(new KeyValueEntry((Object)"1.9", (Object)"190"));
        ioList.add(new KeyValueEntry((Object)"2.0", (Object)"200"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("speech_rate");
        p.setParameterDefaultValue("0.9");
        p.setParameterNameDes("\u8bed\u901f");
        ioList = new ArrayList();
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0.1", (Object)"10"));
        ioList.add(new KeyValueEntry((Object)"0.2", (Object)"20"));
        ioList.add(new KeyValueEntry((Object)"0.3", (Object)"30"));
        ioList.add(new KeyValueEntry((Object)"0.4", (Object)"40"));
        ioList.add(new KeyValueEntry((Object)"0.5", (Object)"50"));
        ioList.add(new KeyValueEntry((Object)"0.6", (Object)"60"));
        ioList.add(new KeyValueEntry((Object)"0.7", (Object)"70"));
        ioList.add(new KeyValueEntry((Object)"0.8", (Object)"80"));
        ioList.add(new KeyValueEntry((Object)"0.9", (Object)"90"));
        ioList.add(new KeyValueEntry((Object)"1.0", (Object)"100"));
        ioList.add(new KeyValueEntry((Object)"1.1", (Object)"110"));
        ioList.add(new KeyValueEntry((Object)"1.2", (Object)"120"));
        ioList.add(new KeyValueEntry((Object)"1.3", (Object)"130"));
        ioList.add(new KeyValueEntry((Object)"1.4", (Object)"140"));
        ioList.add(new KeyValueEntry((Object)"1.5", (Object)"150"));
        ioList.add(new KeyValueEntry((Object)"1.6", (Object)"160"));
        ioList.add(new KeyValueEntry((Object)"1.7", (Object)"170"));
        ioList.add(new KeyValueEntry((Object)"1.8", (Object)"180"));
        ioList.add(new KeyValueEntry((Object)"1.9", (Object)"190"));
        ioList.add(new KeyValueEntry((Object)"2.0", (Object)"200"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("home_page_bg_type");
        p.setParameterNameDes("\u9996\u9875\u80cc\u666f");
        ioList = new ArrayList(2);
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u663e\u793a\u56fe\u7247"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"\u663e\u793a\u89c6\u9891"));
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_title");
        p.setParameterNameDes("\u9996\u9875\u6807\u9898");
        p.setParameterDefaultValue("\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_title_font_size");
        p.setParameterNameDes("\u6807\u9898\u5b57\u4f53\u5927\u5c0f");
        p.setParameterDefaultValue("45");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_title_font_color");
        p.setParameterNameDes("\u6807\u9898\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#FFFFFF");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("basic_bottom_line1_font_color");
        p.setParameterNameDes("\u4e3b\u9875\u811a\u6ce81\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#FFFFFF");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("basic_bottom_line2_font_color");
        p.setParameterNameDes("\u4e3b\u9875\u811a\u6ce82\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#00FFFFFF");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_bg_style");
        p.setParameterDefaultValue("0");
        p.setParameterNameDes("\u4fe1\u606f\u663e\u793a\u6837\u5f0f");
        ioList = new ArrayList(2);
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u4f7f\u7528\u80cc\u666f\u989c\u8272\u6837\u5f0f"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"\u4f7f\u7528\u80cc\u666f\u56fe\u7247\u6837\u5f0f"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display_mode");
        p.setParameterDefaultValue("0");
        p.setParameterNameDes("\u663e\u793a\u6a21\u5f0f");
        ioList = new ArrayList(2);
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u6eda\u52a8\u663e\u793a"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"\u56fa\u5b9a\u663e\u793a"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display1_bg_color");
        p.setParameterNameDes("\u7b2c1\u884c\u80cc\u666f\u989c\u8272");
        p.setParameterDefaultValue("#000000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display1_font_color");
        p.setParameterNameDes("\u7b2c1\u884c\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#00FA46");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display1_font_size");
        p.setParameterNameDes("\u7b2c1\u884c\u5b57\u4f53\u5927\u5c0f");
        p.setParameterDefaultValue("200");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display2_bg_color");
        p.setParameterNameDes("\u7b2c2\u884c\u80cc\u666f\u989c\u8272");
        p.setParameterDefaultValue("#000000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display2_font_color");
        p.setParameterNameDes("\u7b2c2\u884c\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#FF0000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display2_font_size");
        p.setParameterNameDes("\u7b2c2\u884c\u5b57\u4f53\u5927\u5c0f");
        p.setParameterDefaultValue("180");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display3_bg_color");
        p.setParameterNameDes("\u7b2c3\u884c\u80cc\u666f\u989c\u8272");
        p.setParameterDefaultValue("#000000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display3_font_color");
        p.setParameterNameDes("\u7b2c3\u884c\u5b57\u4f53\u989c\u8272");
        p.setParameterDefaultValue("#F1FF66");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_display3_font_size");
        p.setParameterNameDes("\u7b2c3\u884c\u5b57\u4f53\u5927\u5c0f");
        p.setParameterDefaultValue("180");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_qrcode");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u663e\u793a");
        ioList = new ArrayList(3);
        ioList.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u5173\u95ed"));
        ioList.add(new KeyValueEntry((Object)"1", (Object)"\u52a8\u6001\u4e8c\u7ef4\u7801"));
        ioList.add(new KeyValueEntry((Object)"2", (Object)"\u9759\u6001\u4e8c\u7ef4\u7801"));
        p.setInputType(1);
        p.setParameterSelectValues(ioList);
        p.setParameterDefaultValue("0");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("qrcode_content");
        p.setParameterNameDes("\u9759\u6001\u4e8c\u7ef4\u7801\u5185\u5bb9");
        p.setParameterDefaultValue("0");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode1_bg_color");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c1\u884c\u80cc\u666f\u8272");
        p.setParameterDefaultValue("#000000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode1_font_color");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c1\u884c\u5b57\u989c\u8272");
        p.setParameterDefaultValue("0xFF0000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode1_font_size");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c1\u884c\u5b57\u5927\u5c0f");
        p.setParameterDefaultValue("140");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode2_bg_color");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c2\u884c\u80cc\u666f\u8272");
        p.setParameterDefaultValue("#000000");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode2_font_color");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c2\u884c\u5b57\u989c\u8272");
        p.setParameterDefaultValue("0x00FA46");
        list.add(p);
        p = new EquipmentParameter();
        p.setParameterName("pass_qrcode2_font_size");
        p.setParameterNameDes("\u4e8c\u7ef4\u7801\u4e0b\u65b9\u7b2c2\u884c\u5b57\u5927\u5c0f");
        p.setParameterDefaultValue("140");
        list.add(p);
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }

    @Override
    public OperationFuture<Boolean> search(int maxSearchMills, final EquipmentSearcher.SearchCallbak callback1) {
        final OperationFutureHandler opF = ServiceUtil.getServiceContext().createOperationFuture();
        ParkingDisplayLanBroadcastServiceAction.findParkingDisplayNetworks(6000L, 5179, new ParkingDisplayLanBroadcastServiceAction.SearchCallbak(){

            @Override
            public void onFind(ParkingDisplayNetwork netWork) {
                EquipmentInet inet = new EquipmentInet();
                inet.setDriverName(WlykLaneDisplayDeriver.DRIVER_NAME);
                inet.setMac(netWork.getMacHex());
                inet.setIpV4(netWork.getIpV4());
                inet.setNetMask(netWork.getMask());
                inet.setGateWay(netWork.getGateway());
                inet.setDeviceId(netWork.getDeviceId());
                inet.setDns1(netWork.getDns1());
                inet.setDns2(netWork.getDns2());
                inet.setSupportSetDHCP(netWork.getSupportSetDHCP());
                inet.setSupportSetStaticIP(netWork.getSupportSetStaticIP());
                if (Constants.YES_STR.equals(netWork.getSupportSetStaticIP())) {
                    inet.setSupportSetDns("1");
                } else {
                    inet.setSupportSetDns("0");
                }
                inet.setNetMode(netWork.getNetMode());
                inet.setDeviceInfo(String.valueOf(netWork.getDeviceId()) + ", " + netWork.getEthName() + ", " + netWork.getVersion());
                if (callback1 != null) {
                    callback1.onFind(inet);
                }
            }

            @Override
            public void onFinish() {
                try {
                    callback1.onFinish();
                }
                finally {
                    opF.setResult((Object)Boolean.TRUE);
                }
            }
        });
        return opF;
    }

    @Override
    public OperationFuture<KeyValueEntry<Integer, String>> setEquipmentInetAddress(EquipmentInet inet, int waitTimeMills) {
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        ParkingDisplayNetwork network = new ParkingDisplayNetwork();
        network.setDeviceId(inet.getDeviceId());
        network.setMacHex(inet.getMac());
        network.setNetMode(inet.getNetMode());
        network.setDns1(inet.getDns1());
        network.setDns2(inet.getDns2());
        network.setIpV4(inet.getIpV4());
        network.setMask(inet.getNetMask());
        network.setGateway(inet.getGateWay());
        OperationFuture<Integer> f = ParkingDisplayLanBroadcastServiceAction.setParkingDisplayNetworks(waitTimeMills, 5179, network);
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> r) {
                if (r.getException() != null) {
                    handler.setResult((Object)new KeyValueEntry((Object)100009, (Object)"\u5185\u90e8\u9519\u8bef"));
                } else {
                    Integer r1 = (Integer)r.getResult();
                    if (r1 == null) {
                        handler.setResult((Object)new KeyValueEntry((Object)100008, (Object)"\u54cd\u5e94\u8d85\u65f6"));
                    } else if (r1 == 101) {
                        handler.setResult((Object)new KeyValueEntry((Object)100008, (Object)"\u54cd\u5e94\u8d85\u65f6"));
                    } else if (r1 == 1) {
                        handler.setResult((Object)new KeyValueEntry((Object)0, (Object)"Success"));
                    } else if (r1 == 0) {
                        handler.setResult((Object)new KeyValueEntry((Object)1, (Object)"\u9519\u8bef"));
                    } else if (r1 >= 6 && r1 < 10 || r1 == 4) {
                        handler.setResult((Object)new KeyValueEntry((Object)100001, (Object)"\u64cd\u4f5c\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef"));
                    } else if (r1 == 102) {
                        handler.setResult((Object)new KeyValueEntry((Object)100009, (Object)"\u5185\u90e8\u9519\u8bef"));
                    } else if (r1 == 100 || r1 == 2) {
                        handler.setResult((Object)new KeyValueEntry((Object)100007, (Object)"\u7f51\u7edc\u9519\u8bef"));
                    } else {
                        handler.setResult((Object)new KeyValueEntry((Object)100010, (Object)("\u9519\u8bef\u4ee3\u7801: " + r1)));
                    }
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return handler;
    }

    @Override
    public EquipmentSearcher getEquipmentSearcher() {
        return this;
    }
}

