/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionD0;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class YKTBoardDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
EquipmentConfigChanngedListener,
CarparkLoudspeakerAction,
RoadBarrierAction {
    private ScheduledFuture<?> shedule;
    private boolean checkSeriaSetingok = false;
    volatile long receiveheardbeatTimemills;
    private Object displayLock = new Object();
    private Volume volume;
    private AtomicInteger random = new AtomicInteger(0);
    private Map<Integer, Long> lockMap = new ConcurrentHashMap<Integer, Long>();
    private volatile int minuAu = -1;
    private static final long waitNorsponseMills = 250L;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;
    private ReceiveDataHandler<Integer> rReceiveDataHandler = new ReceiveDataHandler<Integer>(){
        int result;

        @Override
        public boolean handleData(byte[] data, int offset, int len) {
            YKTBoardDisplayAction.this.receiveheardbeatTimemills = ServiceUtil.getServiceContext().currentTimeMillis();
            return true;
        }

        @Override
        public Integer getResponseResult() {
            return this.result;
        }
    };

    public byte getNexByte() {
        int a = Math.abs(this.random.incrementAndGet()) % 254 + 1;
        return (byte)a;
    }

    private boolean canPlayVoice() {
        Volume volume0 = this.volume;
        if (volume0 == null) {
            return true;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume0.getDayBeginHour() * 60 + volume0.getDayBeginMins();
        int end = volume0.getDayEndHour() * 60 + volume0.getDayEndMins();
        boolean night = v < begin || v > end;
        return !(night ? volume0.getNightVolume() == 0 : volume0.getDayVolume() == 0);
    }

    public YKTBoardDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
            this.shedule = null;
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    synchronized void start() {
        try {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            this.volume = applicationService.getVolume(this.equipment);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    YKTBoardDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + YKTBoardDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 5000L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    public void connectIfNotConnected1() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            return;
        }
        if (!this.checkSeriaSetingok) {
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        if (this.isWorkingProperly()) {
            Calendar cl = Calendar.getInstance();
            int min = cl.get(12);
            if (min != this.minuAu) {
                this.minuAu = min;
                this.displayAd();
            } else {
                Properties p = this.getconfig();
                long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                int i = 1;
                while (i <= 4) {
                    Long v1;
                    String x = p.getProperty("x0" + i);
                    if (x != null && x.length() >= 2 && (v1 = this.lockMap.get(i)) != null && v1 <= currentMills) {
                        if (x.startsWith("0") || x.startsWith("1")) {
                            String text = x.substring(2);
                            if (x.startsWith("0")) {
                                SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                                text = String.valueOf(text) + " " + df.format(new Date());
                            }
                            if (text.length() > 0) {
                                this.display0(33, i, text, 1);
                            }
                        } else if (x.startsWith("3")) {
                            SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                            this.display0(33, i, df.format(new Date()), 1);
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.minuAu = -1;
        }
    }

    private int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    private byte getAddress() {
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue("RS485_ADDR");
        if (x == null) {
            return 1;
        }
        return x.byteValue();
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.display0(60, config.screenIndex, String.valueOf(config.spacefix) + v, 2);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        return action.isWorkingProperly();
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        DynLoudspeakerAction a = this.getDynLoudspeakerAction();
        if (a != null) {
            return null;
        }
        return this;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        return null;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        if (volume != null) {
            this.volume = volume;
        }
        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
        h.setResult((Object)0);
        return h;
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        if (!this.canPlayVoice()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        byte[] sendd = new byte[31];
        Arrays.fill(sendd, (byte)-14);
        sendd[0] = 97;
        if (codes.length > 30) {
            System.arraycopy(codes, 0, sendd, 1, 30);
        } else {
            System.arraycopy(codes, 0, sendd, 1, codes.length);
        }
        byte[] sendData = this.toSendBytes(this.getAddress(), (byte)-89, sendd);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, 250L);
        return result;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        if (this.isWorkingProperly()) {
            this.displayAd();
        }
    }

    private void displayAd() {
        Properties p = this.getconfig();
        int i = 1;
        while (i <= 4) {
            String x = p.getProperty("x0" + i);
            if (x != null && x.length() >= 2) {
                if (x.startsWith("0") || x.startsWith("1")) {
                    String text = x.substring(2);
                    if (x.startsWith("0")) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                        text = String.valueOf(text) + " " + df.format(new Date());
                    }
                    if (text.length() > 0) {
                        this.display0(33, i, text, 1);
                    }
                } else if (x.startsWith("3")) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
                    this.display0(33, i, df.format(new Date()), 1);
                }
            }
            ++i;
        }
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, 0);
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display0(displayTimes, position, s, 0);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    @Override
    public int getDisplayQrCodeType() {
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, int type) {
        Object object = this.displayLock;
        synchronized (object) {
            byte[] sendText;
            if (type == 0) {
                int times = 2000;
                this.lockMap.put(position, ServiceUtil.getServiceContext().currentTimeMillis() + (long)(times * displayTimes));
            } else {
                Long v1 = this.lockMap.get(position);
                if (v1 != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() < v1) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                    this.lockMap.remove(position);
                }
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            String text5 = ServiceUtil.getString(text, 46, "GBK");
            try {
                sendText = text5.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)e);
                return h;
            }
            byte[] text1 = new byte[sendText.length + 3];
            System.arraycopy(sendText, 0, text1, 2, sendText.length);
            text1[0] = (byte)position;
            int xk = sendText.length <= 8 ? 0 : 32;
            byte bk = this.getColor(position);
            text1[1] = (byte)(xk |= bk);
            text1[text1.length - 1] = 13;
            byte[] sendData = this.toSendBytes(this.getAddress(), (byte)-90, text1);
            OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, 250L);
            return result;
        }
    }

    public static byte[] toSendBytes(byte address, byte ranByte, byte fun, byte[] data) {
        int dataLen = 0;
        if (data != null && data.length > 0) {
            dataLen = data.length;
        }
        if (dataLen > 100) {
            dataLen = 100;
        }
        int len = 3 + dataLen;
        byte[] sendb = new byte[13 + len];
        sendb[0] = 85;
        sendb[1] = -43;
        sendb[2] = 68;
        sendb[3] = 0;
        sendb[4] = ranByte;
        sendb[5] = 0;
        sendb[6] = 0;
        sendb[7] = 0;
        sendb[8] = address;
        sendb[9] = 0;
        sendb[10] = (byte)len;
        int crc1 = YKTBoardDisplayAction.crc16(sendb, 1, 10);
        sendb[11] = (byte)crc1;
        sendb[12] = (byte)(crc1 >> 8);
        sendb[13] = fun;
        int offset = 14;
        if (dataLen > 0) {
            System.arraycopy(data, 0, sendb, offset, dataLen);
            offset += dataLen;
        }
        int crc2 = YKTBoardDisplayAction.crc16(sendb, 13, dataLen + 1);
        sendb[offset] = (byte)crc2;
        sendb[offset + 1] = (byte)(crc2 >> 8);
        return sendb;
    }

    public byte[] toSendBytes(byte address, byte fun, byte[] data) {
        return YKTBoardDisplayAction.toSendBytes(address, this.getNexByte(), fun, data);
    }

    public static int crc16(byte[] Bytes, int StartPos, int len) {
        int Cur_CRC_Value = 65535;
        int Polynomial = 33800;
        int end = len + StartPos;
        int i = StartPos;
        while (i < end) {
            Cur_CRC_Value ^= Bytes[i] & 0xFF;
            int j = 0;
            while (j < 8) {
                Cur_CRC_Value = (Cur_CRC_Value & 1) != 0 ? Cur_CRC_Value >> 1 ^ Polynomial : (Cur_CRC_Value >>= 1);
                ++j;
            }
            ++i;
        }
        return Cur_CRC_Value & 0xFFFF;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] sendData = this.toSendBytes(this.getAddress(), (byte)-48, new byte[]{2});
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, 250L);
        return result;
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] sendData = this.toSendBytes(this.getAddress(), (byte)-47, null);
        OperationFuture<Integer> result = action.sendHaveResponseRS485Data(this.getUatIndex(), sendData, this.rReceiveDataHandler);
        return result;
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public boolean isSupportTrafficLights() {
        return false;
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
        h.setResult((Object)1);
        return h;
    }

    private byte getconfigByteValue(EquipmentConfig config, String key, byte defualtValue) {
        if (config == null) {
            return defualtValue;
        }
        Integer v = config.getConfigIntValue(key);
        if (v == null) {
            return defualtValue;
        }
        return v.byteValue();
    }

    private byte getColor(int pos) {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        if (this.equipment.getUse() == 1) {
            return this.getconfigByteValue(config, "display_position_" + pos + "_color", (byte)1);
        }
        if (this.equipment.getUse() == 2) {
            return this.getconfigByteValue(config, "display_position_" + pos + "_color1", (byte)1);
        }
        return 1;
    }

    private Properties getconfig() {
        Properties p = new Properties();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        String x01 = null;
        String x02 = null;
        String x03 = null;
        String x04 = null;
        if (this.equipment.getUse() == 1) {
            int i = 1;
            while (i <= display_count) {
                byte color = this.getconfigByteValue(config, "display_position_" + i + "_color", (byte)1);
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_free_type", (byte)1);
                String context = String.valueOf(String.valueOf(showType)) + String.valueOf(color);
                if (showType == 0 || showType == 1) {
                    String text = config.getConfigValue("display_position_" + i + "_free_type" + showType);
                    if (text == null || text.length() == 0) {
                        text = "\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf";
                    }
                    context = String.valueOf(context) + text;
                }
                if (i == 1) {
                    x01 = context;
                } else if (i == 2) {
                    x02 = context;
                } else if (i == 3) {
                    x03 = context;
                } else if (i == 4) {
                    x04 = context;
                }
                ++i;
            }
        } else if (this.equipment.getUse() == 2) {
            int i = 1;
            while (i <= display_count) {
                byte color = this.getconfigByteValue(config, "display_position_" + i + "_color1", (byte)1);
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_type", (byte)2);
                String context = String.valueOf(String.valueOf(showType)) + String.valueOf(color);
                if (showType == 0 || showType == 1) {
                    String text = config.getConfigValue("display_position_" + i + "_type" + showType);
                    if (text == null || text.length() == 0) {
                        text = "\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf";
                    }
                    context = String.valueOf(context) + text;
                }
                if (i == 1) {
                    x01 = context;
                } else if (i == 2) {
                    x02 = context;
                } else if (i == 3) {
                    x03 = context;
                } else if (i == 4) {
                    x04 = context;
                }
                ++i;
            }
        }
        if (x01 != null && x01.length() > 0) {
            p.setProperty("x01", x01);
        }
        if (x02 != null && x02.length() > 0) {
            p.setProperty("x02", x02);
        }
        if (x03 != null && x03.length() > 0) {
            p.setProperty("x03", x03);
        }
        if (x04 != null && x04.length() > 0) {
            p.setProperty("x04", x04);
        }
        return p;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int sec, String qrContent, String lineMsg) {
        OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
        opHander.setResult((Object)1);
        return opHander;
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionD0();
        }
        return staticLoudSpeakerServiceAction;
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }
}

