/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.driver.CameraSign;
import com.wovoe.carpark.equipment.driver.RS485ThreadHandler;
import com.wovoe.carpark.equipment.driver.ZSCameraTcpProtocol;
import com.wovoe.carpark.equipment.driver.ZSConnector;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.PlateEntry;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;

public class ZSCameraAction
extends AbstractEquipmentAction
implements PlateRegCameraAction,
CameraUartAction,
RoadBarrierAction,
RoadBarrierStateSupport,
IoHandler,
ZSCameraTcpProtocol.ZSCameraPackageHandler,
InputIoDetectedAction {
    public static final String LIBRARY_NAME = "VzLPRSDK";
    private static final String ZSCameraTcpProtocolName = ZSCameraTcpProtocol.class.getName();
    private volatile IoSession iosession;
    private ScheduledFuture<?> jobTaskHandle;
    private volatile long throwMsgMills;
    private static final byte JSON_BEGIN = 123;
    private static final byte JSON_END = 125;
    private AtomicInteger idseq = new AtomicInteger(0);
    private static int SUCCESS_CODE = 200;
    private AtomicInteger seqFac = new AtomicInteger(0);
    private volatile long lastRevHeartBeat;
    public static final String ACTION_NAME = "/ZSCameraAction";
    private volatile Long hwnd;
    private volatile boolean stopped = false;
    private static final int serialcount = 2;
    private final SerialConfig[] serialConfigList = new SerialConfig[2];
    private final RS485ThreadHandler[] rs485ThreadHandlers = new RS485ThreadHandler[2];
    private final boolean[] initRs485List = new boolean[2];
    private static final String SESSION_SerialReadQueue = "ZSSerialReadQueue.";
    private Object downloadLocak = new Object();
    private volatile Collection<PlateEntry> whiteList;
    public static final int LC_UNKNOWN = 0;
    public static final int LC_BLUE = 1;
    public static final int LC_YELLOW = 2;
    public static final int LC_WHITE = 3;
    public static final int LC_BLACK = 4;
    public static final int LC_GREEN = 5;
    public static final int LCOLOUR_WHITE = 0;
    public static final int LCOLOUR_SILVER = 1;
    public static final int LCOLOUR_YELLOW = 2;
    public static final int LCOLOUR_PINK = 3;
    public static final int LCOLOUR_RED = 4;
    public static final int LCOLOUR_GREEN = 5;
    public static final int LCOLOUR_BLUE = 6;
    public static final int LCOLOUR_BROWN = 7;
    public static final int LCOLOUR_BLACK = 8;
    private static final String[] plateTypeString;
    private static final String[] DIRECTIONString;
    private static String[] brands;
    private static String[] carTypes;
    public static final int TT_Auto = 1;
    public static final int TT_Hand = 2;
    public static final int TT_SOFTWARE = 3;
    public static final int TT_VLOOP = 4;
    private static byte[][] witeListResult2Keys;
    private static byte[][] witeListResult3Keys;
    private final Object closeJobLock = new Object();
    private ScheduledFuture<?> getIoSateJobTaskHandle;
    private volatile long handleControlboxMills;
    private volatile boolean groundPressure;
    private volatile long groundPressureMills;
    private volatile long groundReleaseMills;
    private volatile boolean startCheckOpenPole;
    private volatile long poleOpenedMills;
    private volatile int nativeConnectErrorCounter;
    private volatile EquipmentState lastEquipmentState;
    private ZSConnector zsConnector;
    private volatile boolean checkSign;
    private String eq_serial_no;
    private LocalProcessTransport localProcessTransport;

    static {
        String[] stringArray = new String[20];
        stringArray[1] = "\u84dd\u724c\u5c0f\u6c7d\u8f66";
        stringArray[2] = "\u9ed1\u724c\u5c0f\u6c7d\u8f66";
        stringArray[3] = "\u5355\u6392\u9ec4\u724c";
        stringArray[4] = "\u53cc\u6392\u9ec4\u724c";
        stringArray[5] = "\u8b66\u8f66\u8f66\u724c";
        stringArray[6] = "\u6b66\u8b66\u8f66\u724c";
        stringArray[7] = "\u4e2a\u6027\u5316\u8f66\u724c";
        stringArray[8] = "\u5355\u6392\u519b\u8f66\u724c";
        stringArray[9] = "\u53cc\u6392\u519b\u8f66\u724c";
        stringArray[10] = "\u4f7f\u9986\u8f66\u724c";
        stringArray[11] = "\u9999\u6e2f\u8f66\u724c";
        stringArray[12] = "\u519c\u7528\u8f66\u724c";
        stringArray[13] = "\u6559\u7ec3\u8f66\u724c";
        stringArray[14] = "\u6fb3\u95e8\u8f66\u724c";
        stringArray[15] = "\u53cc\u5c42\u6b66\u8b66\u8f66\u724c";
        stringArray[16] = "\u6b66\u8b66\u603b\u961f\u8f66\u724c";
        stringArray[17] = "\u53cc\u5c42\u6b66\u8b66\u603b\u961f\u8f66\u724c";
        stringArray[18] = "\u6c11\u822a\u8f66\u724c";
        stringArray[19] = "\u65b0\u80fd\u6e90\u8f66\u724c";
        plateTypeString = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[1] = "\u5de6";
        stringArray2[2] = "\u53f3";
        stringArray2[3] = "\u4e0a";
        stringArray2[4] = "\u4e0b";
        DIRECTIONString = stringArray2;
        witeListResult2Keys = new byte[][]{"\"white_list_operator\"".getBytes(), "\"operator_type\"".getBytes(), "\"select\"".getBytes(), "\"dldb_rec\"".getBytes()};
        witeListResult3Keys = new byte[][]{"\"white_list_operator\"".getBytes(), "\"operator_type\"".getBytes(), "\"select_fuzzy\"".getBytes(), "\"dldb_rec\"".getBytes()};
    }

    public static String getPlateColor(Integer colorType) {
        String cl;
        if (colorType == null) {
            return "\u84dd";
        }
        switch (colorType) {
            case 1: {
                cl = "\u84dd";
                break;
            }
            case 2: {
                cl = "\u9ec4";
                break;
            }
            case 3: {
                cl = "\u767d";
                break;
            }
            case 4: {
                cl = "\u9ed1";
                break;
            }
            case 5: {
                cl = "\u7eff";
                break;
            }
            default: {
                cl = "\u84dd";
            }
        }
        return cl;
    }

    public static String getCarColor(Integer carColorType) {
        String cl;
        if (carColorType == null) {
            return null;
        }
        switch (carColorType) {
            case 0: {
                cl = "\u767d\u8272";
                break;
            }
            case 1: {
                cl = "\u94f6\u8272";
                break;
            }
            case 2: {
                cl = "\u9ec4\u8272";
                break;
            }
            case 3: {
                cl = "\u7c89\u8272";
                break;
            }
            case 4: {
                cl = "\u7ea2\u8272";
                break;
            }
            case 5: {
                cl = "\u7eff\u8272";
                break;
            }
            case 6: {
                cl = "\u84dd\u8272";
                break;
            }
            case 7: {
                cl = "\u68d5\u8272";
                break;
            }
            case 8: {
                cl = "\u9ed1\u8272";
                break;
            }
            default: {
                cl = null;
            }
        }
        return cl;
    }

    public static String getCarType(Integer carType) {
        if (carType == null) {
            return null;
        }
        if (carTypes == null) {
            carTypes = new String[]{"\u8f7f\u8f66", "SUV", "MPV", "\u9762\u5305\u8f66", "Jeep", "\u76ae\u5361", "\u5c0f\u578b\u5ba2\u8f66", "\u4e2d\u578b\u5ba2\u8f66", "\u5927\u578b\u5ba2\u8f66", "\u5c0f\u578b\u8d27\u8f66", "\u4e2d\u578b\u8d27\u8f66", "\u91cd\u578b\u8d27\u8f66", "\u8dd1\u8f66"};
        }
        if (carType >= 0 && carType < carTypes.length) {
            return carTypes[carType];
        }
        return null;
    }

    public static String getBrand(Integer brandType) {
        if (brandType == null) {
            return null;
        }
        if (brands == null) {
            brands = new String[]{"\u6bd4\u4e9a\u8fea", "\u4e00\u6c7d", "\u5b9d\u9a6c\u8ff7\u4f60", "\u8363\u5a01", "\u5409\u666e", "\u4e30\u7530", "\u94c3\u6728", "\u957f\u5b89", "\u96ea\u94c1\u9f99", "\u96ea\u4f5b\u5170", "\u957f\u57ce", "\u51ef\u8fea\u62c9\u514b", "\u672c\u7530", "\u4e94\u83f1", "\u96f7\u514b\u8428\u65af", "\u798f\u7279", "\u4e1c\u98ce\u98ce\u795e", "\u6c83\u5c14\u6c83", "\u5927\u4f17", "\u798f\u7530", "\u5317\u6c7d", "\u5409\u5229", "\u5947\u745e", "\u4e2d\u534e", "\u65af\u67ef\u8fbe", "\u65af\u5df4\u9c81", "\u5e7f\u6c7d\u4f20\u797a", "\u4e09\u83f1", "\u6d77\u9a6c", "\u73b0\u4ee3", "\u540d\u7235", "\u957f\u5b89\u5546\u7528", "\u5954\u9a70", "\u5b9d\u9a8f", "\u8def\u864e", "\u522b\u514b", "\u54c8\u5f17", "\u8d77\u4e9a", "\u5c3c\u6851", "\u6c5f\u94c3", "\u9a6c\u81ea\u8fbe", "\u6c5f\u6dee", "\u5965\u8fea", "\u4e1c\u5357", "\u6807\u81f4", "\u91d1\u676f", "\u5b9d\u9a6c", "\u4fdd\u65f6\u6377", "\u98ce\u9a70", "\u53cc\u73af", "\u4e2d\u5174", "\u83f2\u4e9a\u7279", "\u5927\u8fd0", "\u534e\u6cf0", "\u5317\u4eac", "\u730e\u8c79\u6c7d\u8f66", "\u5317\u6c7d\u5236\u9020", "\u4e1c\u98ce\u98ce\u884c", "\u798f\u7530\u65f6\u4ee3", "\u51ef\u9a6c", "\u4e2d\u987a", "\u5bbe\u5229", "\u660c\u6cb3", "\u514b\u83b1\u65af\u52d2", "\u4e0a\u6c7d\u5927\u901a", "\u7eb3\u667a\u6377", "\u534e\u666e", "\u5e7f\u6c7d\u65e5\u91ce", "\u5317\u6c7d\u7ec5\u5b9d", "\u4e09\u4e00\u91cd\u5de5", "\u9053\u5947", "\u8bb4\u6b4c", "\u5f00\u745e", "\u4f17\u6cf0", "\u5409\u5229\u6c7d\u8f66", "\u96f7\u8bfa", "\u4e1c\u98ce\u98ce\u5ea6", "\u9655\u6c7d", "\u4e2d\u56fd\u91cd\u6c7d", "\u5b89\u51ef", "\u6b27\u5b9d", "\u6377\u8c79", "\u9646\u98ce", "\u4e94\u5341\u94c3", "\u9ec4\u6d77", "\u4f9d\u7ef4\u67ef", "\u89e3\u653e", "\u534e\u83f1", "\u5510\u9a8f", "\u4e2d\u901a", "\u798f\u7530\u6b27\u66fc", "\u91d1\u9f99", "\u83b2\u82b1\u6c7d\u8f66", "\u542f\u8fb0", "\u6052\u901a", "\u7406\u5ff5", "\u5317\u5954", "\u4e1c\u98ce\u591a\u5229\u5361", "\u5317\u65b9", "\u8dc3\u8fdb", "\u529b\u5e06", "\u5317\u6c7d\u5a01\u65fa", "\u798f\u7530\u5965\u94c3", "\u98de\u789f", "\u4e1c\u98ce\u67f3\u6c7d", "\u54c8\u98de", "\u91d1\u65c5", "\u5b87\u901a", "\u82f1\u83f2\u5c3c\u8fea", "\u6797\u80af", "\u51ef\u8fea\u62c9\u514bATS", "\u4e1c\u98ce\u98ce\u5149"};
        }
        if (brandType >= 0 && brandType < brands.length) {
            return brands[brandType];
        }
        return null;
    }

    public ZSCameraAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    private void throwErrTipMsg(String msg) {
        long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
        if (c1 - this.throwMsgMills > 10000L) {
            this.throwMsgMills = c1;
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 8000));
        }
    }

    @Override
    public boolean isConnGround(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        Integer ioOp1 = this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
        return ioOp1 != null && ioOp1 == 4;
    }

    @Override
    public boolean isGroundPressure(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        return this.isWorkingProperly() && this.groundPressure;
    }

    public boolean hasLineGround() {
        return this.isWorkingProperly() && this.groundPressureMills > 0L;
    }

    public long getPressureMills() {
        if (this.isWorkingProperly() && this.groundPressure && this.groundPressureMills > 0L) {
            return ServiceUtil.getServiceContext().currentTimeMillis() - this.groundPressureMills;
        }
        return 0L;
    }

    private void throwTipErrorMsg(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        String key = String.valueOf(this.getClass().getSimpleName()) + "-" + this.getEquipment().getEquipmentNo() + "-throwTipErrorMsg00009";
        if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 30L, TimeUnit.SECONDS);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            ServiceLog.getLog().warn((Object)msg);
        }
    }

    private boolean checkSign(ZSConnector zsConnector) {
        String encryptData;
        String serialNo;
        boolean needCheckCameraSign;
        block19: {
            needCheckCameraSign = ServiceUtil.getServiceContext().getAuthInfo().isN();
            try {
                serialNo = (String)this.getCameraSn().get(6L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + this.getEquipment().getIp() + "\u5e8f\u5217\u53f7\u7f51\u7edc\u5f02\u5e38\uff01" + (ex instanceof ExecutionException ? ex.getCause() : ex)));
                return true;
            }
            if (serialNo == null || serialNo.length() == 0) {
                ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + this.getEquipment().getIp() + "\u5e8f\u5217\u53f7\u5931\u8d25\uff01"));
                return true;
            }
            this.eq_serial_no = serialNo;
            try {
                KeyValueEntry<String, String> kv = zsConnector.getUserData();
                if (kv != null && "SUCCESS".equals(kv.getKey())) {
                    encryptData = (String)kv.getValue();
                    break block19;
                }
                return true;
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a: " + this.getEquipment().getIp() + "\u7b7e\u540d\u6570\u636e\u7f51\u7edc\u5f02\u5e38\uff01" + (ex instanceof ExecutionException ? ex.getCause() : ex)));
                return true;
            }
        }
        String realEncryptData = null;
        if (encryptData != null && encryptData.length() > 4 && encryptData.startsWith("WL")) {
            try {
                int hexLen = BytesTool.hexStringToByteArray((String)encryptData.substring(2, 4))[0] & 0xFF;
                String x = encryptData.substring(4, hexLen + 4);
                if (x.endsWith("YK")) {
                    realEncryptData = x.substring(0, x.length() - 2);
                }
            }
            catch (Exception hexLen) {
                // empty catch block
            }
        }
        if (realEncryptData == null || realEncryptData.length() == 0) {
            return true;
        }
        encryptData = realEncryptData;
        Key aeskey = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
        CameraSign cameraSign = CameraSign.parse(encryptData, aeskey);
        if (cameraSign == null) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + this.getEquipment().getIp() + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u672a\u7b7e\u540d, \u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e");
                return false;
            }
            return true;
        }
        if (!serialNo.equals(cameraSign.getSerialNo())) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + this.getEquipment().getIp() + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u7b7e\u540d\u6570\u636e\u9519\u8bef");
                return false;
            }
            return true;
        }
        if (ServiceUtil.getServiceContext().getAuthInfo().getOrgId() != cameraSign.getOrgId()) {
            if (needCheckCameraSign) {
                this.throwTipErrorMsg("\u76f8\u673a:" + this.getEquipment().getIp() + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u53d1\u884c\u4e3b\u4f53\u9519\u8bef\uff01\u76f8\u673a\u53d1\u884c\u4e3b\u4f53:" + cameraSign.getOrgId() + "[" + cameraSign.getLicenceId() + "]");
            } else {
                this.throwTipErrorMsg("\u76f8\u673a:" + this.getEquipment().getIp() + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u5df2\u88ab\u5382\u5546\u52a0\u5bc6\uff01\u76f8\u673a\u53d1\u884c\u4e3b\u4f53:" + cameraSign.getOrgId() + "[" + cameraSign.getLicenceId() + "]");
            }
            return false;
        }
        if (!CameraSign.checkSign(encryptData, aeskey, ServiceUtil.getServiceContext().getAuthInfo().getL())) {
            this.throwTipErrorMsg("\u76f8\u673a:" + this.getEquipment().getIp() + "[" + this.getEquipment().getName() + "] \u62d2\u7edd\u8fde\u63a5\uff0c\u539f\u56e0\uff1a\u76f8\u673a\u7b7e\u540d\u9519\u8bef\uff01\u76f8\u673a\u53d1\u884c\u8bb8\u53ef\u8bc1:" + cameraSign.getLicenceId());
            return false;
        }
        return true;
    }

    private void setZsConnector() {
        ZSConnector zsConnector0;
        String userPwd;
        if (this.getEquipment() == null) {
            return;
        }
        EquipmentConfig config = this.getEquipment().getEquipmentConfig();
        if (config == null) {
            return;
        }
        String userName = config.getConfigValue("login_user");
        if (userName == null || userName.length() == 0) {
            userName = "admin";
        }
        if ((userPwd = config.getConfigValue("login_pwd")) == null || userPwd.length() == 0) {
            userPwd = "admin";
        }
        if ((zsConnector0 = this.zsConnector) != null) {
            zsConnector0.setIp(this.getEquipment().getIp(), userName, userPwd);
        }
    }

    private void doCheckSign() {
        try {
            ZSConnector zsConnector0 = this.zsConnector;
            IoSession iosession0 = this.iosession;
            if (this.checkSign && zsConnector0 != null && zsConnector0.isConnected() && iosession0 != null && iosession0.isConnected()) {
                this.checkSign = false;
                if (!this.checkSign(zsConnector0)) {
                    this.disConnect();
                    return;
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + "]\u6821\u9a8c\u7b7e\u540d\u5f02\u5e38!  " + ex.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = false;
            if (this.jobTaskHandle == null) {
                this.zsConnector = new ZSConnector();
                this.setZsConnector();
                this.zsConnector.start();
                this.jobTaskHandle = ServiceUtil.getServiceContext().schedule(new JobTask(){
                    private volatile int errCount = 0;

                    private void checkOfflineState() {
                        if (ZSCameraAction.this.stopped) {
                            return;
                        }
                        if (!ZSCameraAction.this.isNeedRegPlate()) {
                            return;
                        }
                        ZSCameraAction.this.doGetOfflineState().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                            }

                            public void operationComplete(OperationFuture<Integer> f) {
                                if (f.getException() == null && f.getResult() != null) {
                                    if (ZSCameraAction.this.stopped) {
                                        return;
                                    }
                                    if ((Integer)f.getResult() != 1) {
                                        ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5f53\u524d\u4e3a\u8131\u673a\u72b6\u6001! \u8fd9\u5c06\u6539\u53d8\u6210\u8054\u673a!"));
                                        ZSCameraAction.this.doRegOfflineCheck();
                                    }
                                }
                            }
                        });
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void doRun() throws Exception {
                        boolean connected;
                        Object object = ZSCameraAction.this.closeJobLock;
                        synchronized (object) {
                            if (ZSCameraAction.this.stopped) {
                                return;
                            }
                        }
                        ZSCameraAction.this.setZsConnector();
                        IoSession session = ZSCameraAction.this.iosession;
                        boolean bl = connected = session != null && session.isConnected() && !session.isClosing();
                        if (connected && (this.errCount >= 2 || ServiceUtil.getServiceContext().currentTimeMillis() - ZSCameraAction.this.lastRevHeartBeat >= 15000L)) {
                            this.errCount = 0;
                            ZSCameraAction.this.disConnect();
                            ZSCameraAction.this.nativeDisConnect();
                            connected = false;
                        }
                        if (!connected) {
                            Integer d;
                            ZSCameraAction.this.eq_serial_no = null;
                            if (!ZSCameraAction.this.doConnect()) {
                                return;
                            }
                            connected = true;
                            Object object2 = ZSCameraAction.this.closeJobLock;
                            synchronized (object2) {
                                if (ZSCameraAction.this.stopped) {
                                    ZSCameraAction.this.disConnect();
                                    return;
                                }
                            }
                            ZSCameraAction.this.checkSign = true;
                            ZSCameraAction.this.doCheckSign();
                            IoSession s = ZSCameraAction.this.iosession;
                            if (s == null || s.isClosing() || !s.isConnected()) {
                                return;
                            }
                            try {
                                d = (Integer)ZSCameraAction.this.setCameraTime(null).get(6L, TimeUnit.SECONDS);
                                if (d == null || d != 0) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u8bbe\u7f6e\u65f6\u95f4\u5931\u8d25! "));
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u8bbe\u7f6e\u65f6\u95f4\u5f02\u5e38!  " + ex.getMessage()));
                            }
                            try {
                                d = (Integer)ZSCameraAction.this.configIvsresult().get(6L, TimeUnit.SECONDS);
                                if (d == null || d != 0) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u8bbe\u7f6e\u8f66\u724c\u8bc6\u522b\u63a8\u9001\u914d\u7f6e\u5931\u8d25! "));
                                    ZSCameraAction.this.disConnect();
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u8bbe\u7f6e\u8f66\u724c\u8bc6\u522b\u63a8\u9001\u914d\u7f6e\u5f02\u5e38!  " + ex.getMessage()));
                                ZSCameraAction.this.disConnect();
                                return;
                            }
                            ZSCameraAction.this.lastRevHeartBeat = ServiceUtil.getServiceContext().currentTimeMillis();
                            ZSCameraAction.this.connectIfNotConnected1();
                        } else {
                            final 1 task = this;
                            ZSCameraAction.this.sendHearbeat().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                    1 v0 = this;
                                    v0.errCount = v0.errCount + 1;
                                    if (errCount >= 2) {
                                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                task.run();
                                            }
                                        });
                                    }
                                }

                                public void operationComplete(OperationFuture<Integer> f) {
                                    if (f.getResult() != null && (Integer)f.getResult() == 0) {
                                        errCount = 0;
                                        this.checkOfflineState();
                                    } else {
                                        this.waitCompleteTimeout();
                                    }
                                }
                            });
                            ZSCameraAction.this.connectIfNotConnected1();
                            ZSCameraAction.this.doCheckSign();
                            IoSession session1 = ZSCameraAction.this.iosession;
                            String ip = ZSCameraAction.this.equipment.getIp();
                            if (session1 != null && ip != null && ip.length() > 0) {
                                EquipmentConfig config = ZSCameraAction.this.equipment.getEquipmentConfig();
                                Integer port = config.getConfigIntValue("port");
                                if (port == null) {
                                    port = 8131;
                                }
                                if (!new InetSocketAddress(ip, (int)port).equals(session1.getRemoteAddress())) {
                                    session1.close(true);
                                }
                            }
                        }
                    }
                }, 2L, 5L, TimeUnit.SECONDS);
            }
            if (this.getIoSateJobTaskHandle == null) {
                this.getIoSateJobTaskHandle = ServiceUtil.getServiceContext().getScheduledExecutorService().scheduleAtFixedRate(new Runnable(){
                    private long nextQueryTimlls1;
                    private long nextQueryTimlls2;

                    private void doRunx2() {
                        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (currentMills < this.nextQueryTimlls2) {
                            return;
                        }
                        int ioInputIndex = 1;
                        Integer ioOp = ZSCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO2");
                        if (ioOp == null) {
                            return;
                        }
                        final int ioOpValue = ioOp;
                        if (ioOpValue != 1 && ioOpValue != 2 && ioOpValue != 3 && ioOpValue != 5) {
                            ZSCameraAction.this.startCheckOpenPole = false;
                            return;
                        }
                        if (ioOpValue == 5) {
                            ZSCameraAction.this.startCheckOpenPole = false;
                            if (ServiceUtil.getServiceContext().getFirefightingJob() == null) {
                                return;
                            }
                        }
                        this.nextQueryTimlls2 = currentMills + 6000L;
                        ZSCameraAction.this.doGetIOState(ioInputIndex).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                            }

                            public void operationComplete(OperationFuture<Integer> f) {
                                long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                nextQueryTimlls2 = c1;
                                if (f.getException() != null) {
                                    ServiceLog.getLog().warn((Object)("[" + ZSCameraAction.this.equipment.getIp() + "] \u67e5\u8be2Io2\u72b6\u6001\u5f02\u5e38\uff01 \u539f\u56e0: " + f.getException().getMessage()));
                                } else if (f.getResult() != null && ((Integer)f.getResult() == 0 || (Integer)f.getResult() == 1)) {
                                    if (ioOpValue == 1 || ioOpValue == 2 || ioOpValue == 3) {
                                        ZSCameraAction.this.handleGateState(ioOpValue, (Integer)f.getResult());
                                    } else if (ioOpValue == 5) {
                                        ZSCameraAction.this.handleFirefighting(ioOpValue, (Integer)f.getResult());
                                    }
                                }
                            }
                        });
                    }

                    private void doRunx1() {
                        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (currentMills < this.nextQueryTimlls1) {
                            return;
                        }
                        int ioInputIndex = 0;
                        Integer ioOp = ZSCameraAction.this.equipment.getEquipmentConfig().getConfigIntValue("inputIO1");
                        if (ioOp == null) {
                            return;
                        }
                        final int ioOpValue = ioOp;
                        if (ioOpValue != 4) {
                            ZSCameraAction.this.startCheckOpenPole = false;
                            return;
                        }
                        this.nextQueryTimlls1 = currentMills + 6000L;
                        ZSCameraAction.this.doGetIOState(ioInputIndex).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                            }

                            public void operationComplete(OperationFuture<Integer> f) {
                                long c1 = ServiceUtil.getServiceContext().currentTimeMillis();
                                nextQueryTimlls1 = c1;
                                if (f.getException() != null) {
                                    ServiceLog.getLog().warn((Object)("[" + ZSCameraAction.this.equipment.getIp() + "] \u67e5\u8be2Io1\u72b6\u6001\u5f02\u5e38\uff01 \u539f\u56e0: " + f.getException().getMessage()));
                                } else if (f.getResult() != null && ((Integer)f.getResult() == 0 || (Integer)f.getResult() == 1)) {
                                    if (ioOpValue == 4) {
                                        int ioValue = (Integer)f.getResult();
                                        if (ioValue == 0) {
                                            if (!ZSCameraAction.this.groundPressure) {
                                                ZSCameraAction.this.groundPressure = true;
                                                ZSCameraAction.this.groundPressureMills = c1;
                                                ZSCameraAction.this.startCheckOpenPole = false;
                                                List<String> channelNos = ZSCameraAction.this.equipment.getChannelNos();
                                                if (channelNos != null && !channelNos.isEmpty()) {
                                                    VehicleDetectorEvent event = new VehicleDetectorEvent(ZSCameraAction.this.equipment, 0, 1, channelNos.get(0));
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                                }
                                            }
                                        } else if (ioValue == 1 && ZSCameraAction.this.groundPressure) {
                                            ZSCameraAction.this.groundPressure = false;
                                            ZSCameraAction.this.groundReleaseMills = c1;
                                            ZSCameraAction.this.poleOpenedMills = 0L;
                                            ZSCameraAction.this.startCheckOpenPole = true;
                                            List<String> channelNos = ZSCameraAction.this.equipment.getChannelNos();
                                            if (channelNos != null && !channelNos.isEmpty()) {
                                                VehicleDetectorEvent event = new VehicleDetectorEvent(ZSCameraAction.this.equipment, 0, 0, channelNos.get(0));
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
                                            }
                                        }
                                    } else {
                                        ZSCameraAction.this.startCheckOpenPole = false;
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void run() {
                        try {
                            if (!ZSCameraAction.this.isWorkingProperly()) {
                                return;
                            }
                            if (!ZSCameraAction.this.isNeedRegPlate()) {
                                return;
                            }
                            this.doRunx1();
                            this.doRunx2();
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                    }
                }, 3000L, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void handleFirefighting(int configV, int ioValue) {
        if (configV != 5) {
            return;
        }
        if (ioValue == 0) {
            try {
                if (ServiceUtil.getServiceContext().getFirefightingJob() != null) {
                    ServiceUtil.getServiceContext().getFirefightingJob().firefighting(this.equipment.getEquipmentNo(), this.equipment.getName(), false);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private long handleGateState(int configV, int ioValue) {
        EquipmentState state = null;
        if (configV == 1) {
            state = ioValue == 0 ? EquipmentState.BARRIER_RAISED_IN_PLACE : EquipmentState.BARRIER_DROPPED_IN_PLACE;
        } else if (configV == 2) {
            state = ioValue == 0 ? EquipmentState.BARRIER_DROPPED_IN_PLACE : EquipmentState.BARRIER_RAISED_IN_PLACE;
        } else if (configV == 3) {
            if (ioValue == 0) {
                this.triggerIllOpenPole();
            }
            return 0L;
        }
        if (state != null) {
            Collection<Equipment> eqs;
            long openedPoleDuration;
            boolean autoDownloadPole;
            block29: {
                autoDownloadPole = false;
                openedPoleDuration = 0L;
                if (state == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    if (this.startCheckOpenPole) {
                        if (this.poleOpenedMills > 0L) {
                            String channelNo = null;
                            List<String> chs = this.equipment.getChannelNos();
                            if (chs != null && !chs.isEmpty()) {
                                channelNo = chs.get(0);
                            }
                            if (channelNo != null && channelNo.length() > 0) {
                                String v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_POLE_DOWN_TIMEOUT");
                                if (v != null && v.length() > 0) {
                                    try {
                                        int a = Integer.parseInt(v);
                                        if (a > 0) {
                                            long timeoutMills = a * 1000;
                                            openedPoleDuration = ServiceUtil.getServiceContext().currentTimeMillis() - this.poleOpenedMills;
                                            if (openedPoleDuration >= timeoutMills) {
                                                autoDownloadPole = true;
                                                this.startCheckOpenPole = false;
                                                this.poleOpenedMills = 0L;
                                            }
                                            break block29;
                                        }
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                    catch (Exception ex) {
                                        this.startCheckOpenPole = false;
                                        this.poleOpenedMills = 0L;
                                    }
                                } else {
                                    this.startCheckOpenPole = false;
                                    this.poleOpenedMills = 0L;
                                }
                            } else {
                                this.startCheckOpenPole = false;
                                this.poleOpenedMills = 0L;
                            }
                        } else {
                            this.poleOpenedMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                    }
                } else if (this.lastEquipmentState == EquipmentState.BARRIER_RAISED_IN_PLACE) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                } else if (this.startCheckOpenPole && ServiceUtil.getServiceContext().currentTimeMillis() - this.groundReleaseMills >= 5000L) {
                    this.startCheckOpenPole = false;
                    this.poleOpenedMills = 0L;
                }
            }
            if ((eqs = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9)) != null) {
                Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    for (Equipment e : eqs) {
                        PassChannel passChannel;
                        if (e.getParentEquipmentNo() == null || !this.equipment.getEquipmentNo().equals(e.getParentEquipmentNo())) continue;
                        if (e.getEquipmentAction() instanceof RoadBarrierStateAction) {
                            ((RoadBarrierStateAction)e.getEquipmentAction()).setPoleSate(state, handleType, channelNos.get(0));
                        }
                        if (!autoDownloadPole) continue;
                        boolean isAlwaysOpen = false;
                        if (e.getEquipmentAction() instanceof AlwaysOpenAction) {
                            isAlwaysOpen = ((AlwaysOpenAction)e.getEquipmentAction()).isAlwaysOpen();
                        }
                        if (isAlwaysOpen || !(e.getEquipmentAction() instanceof RoadBarrierAction) || (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNos.get(0))) == null || passChannel.getLanConnectManageHostState() != null) continue;
                        ((RoadBarrierAction)e.getEquipmentAction()).doDownPoleAction();
                        ServiceLog.getLog().info((Object)("\u68c0\u6d4b\u5230\u8f66\u8f86\u79bb\u5f00\u8bc6\u522b\u533a\u540e\uff0c\u6ca1\u6709\u4efb\u4f55\u8f66\u8f86\uff0c\u9053\u95f8\u6746\u5f53\u524d\u662f\u5f00\u5230\u4f4d\uff0c\u8fd9\u79cd\u72b6\u6001\u5df2\u7ecf\u8fde\u7eed" + openedPoleDuration + "\u6beb\u79d2, \u9053\u95f8\u672a\u8bbe\u7f6e\u5e38\u5f00, \u8fd9\u5c06\u53d1\u9001\u843d\u6746\u6307\u4ee4"));
                    }
                }
            }
            this.lastEquipmentState = state;
        }
        return 0L;
    }

    protected void triggerIllOpenPole() {
        Integer handleType = this.equipment.getEquipmentConfig().getConfigIntValue("illOpenPole_handtype");
        if (handleType != null && handleType != 2) {
            long xd1 = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.handleControlboxMills == 0L || xd1 - this.handleControlboxMills >= 5000L) {
                this.handleControlboxMills = xd1;
                List<String> channelNos = this.equipment.getChannelNos();
                if (channelNos != null && !channelNos.isEmpty()) {
                    EnumSet<RoadBarrierStateEvent.SignalType> signals = null;
                    block0: for (String channelNo : channelNos) {
                        Collection<Equipment> roadGateList = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
                        if (roadGateList == null || roadGateList.isEmpty()) continue;
                        for (Equipment eq : roadGateList) {
                            if (eq.getChannelNos() == null || !eq.getChannelNos().contains(channelNo) || eq.getEquipmentAction().getParentEquipmentAction() != this) continue;
                            if (signals == null) {
                                signals = EnumSet.noneOf(RoadBarrierStateEvent.SignalType.class);
                                signals.add(RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN);
                            }
                            EquipmentState state = eq.getEquipmentAction().getEquipmentState();
                            RoadBarrierStateEvent event = new RoadBarrierStateEvent(eq, state, state, signals, channelNo);
                            event.setControlBoxOpenHandleType(handleType);
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().asynThrowEvent(event);
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void stop() {
        var1_1 = this.closeJobLock;
        synchronized (var1_1) {
            this.stopped = true;
            if (this.zsConnector != null) {
                this.zsConnector.stop();
                this.zsConnector = null;
            }
            if (this.getIoSateJobTaskHandle != null) {
                this.getIoSateJobTaskHandle.cancel(true);
                this.getIoSateJobTaskHandle = null;
            }
            if (this.jobTaskHandle != null) {
                this.jobTaskHandle.cancel(true);
                this.jobTaskHandle = null;
            }
            try {
                try {
                    this.disConnect();
                }
                finally {
                    i = 0;
                    ** while (i < this.rs485ThreadHandlers.length)
                }
lbl-1000:
                // 1 sources

                {
                    rs485ThreadHandler = this.rs485ThreadHandlers[i];
                    if (rs485ThreadHandler != null) {
                        rs485ThreadHandler.stop();
                        this.rs485ThreadHandlers[i] = null;
                    }
                    ++i;
                    continue;
lbl29:
                    // 1 sources

                }
            }
            finally {
                this.hwnd = null;
                this.nativeDisConnect();
            }
        }
    }

    public String getEq_serial_no() {
        return this.eq_serial_no;
    }

    private void nativeDisConnect() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u5173\u95ed\u76f8\u673a\u8fde\u63a5";
        String serviceName = "disConnect";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    private synchronized void setSession(IoSession session) {
        if (session == null) {
            return;
        }
        if (this.iosession != null) {
            if (this.iosession == session) {
                return;
            }
            try {
                if (this.iosession.isConnected() && !this.iosession.isClosing()) {
                    this.iosession.close(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < this.serialConfigList.length) {
            this.serialConfigList[i] = null;
            ++i;
        }
        i = 0;
        while (i < this.initRs485List.length) {
            this.initRs485List[i] = false;
            ++i;
        }
        this.whiteList = null;
        session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        session.setAttribute((Object)ZSCameraTcpProtocolName, (Object)new ZSCameraTcpProtocol(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + "]"));
        i = 0;
        while (i < 2) {
            session.setAttribute((Object)(SESSION_SerialReadQueue + i), (Object)new SerialReadQueue());
            ++i;
        }
        this.iosession = session;
        this.lastRevHeartBeat = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    private void disConnect() {
        if (this.iosession != null) {
            if (this.iosession.isConnected() && !this.iosession.isClosing()) {
                this.iosession.close(true);
            }
            this.iosession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doConnect() {
        String ip = this.equipment.getIp();
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer port = config.getConfigIntValue("port");
        if (port == null) {
            port = 8131;
        }
        if (ip == null || ip.length() == 0) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "\u76f8\u673aip\u672a\u914d\u7f6e"));
            this.throwErrTipMsg(String.valueOf(this.equipment.getName()) + "\u76f8\u673aip\u672a\u914d\u7f6e");
            return false;
        }
        ConnectFuture future = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, (int)port), (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(IoSession session, ConnectFuture f) {
                ZSCameraAction.this.setSession(session);
            }
        });
        try {
            if (!future.await(9L, TimeUnit.SECONDS)) {
                future.cancel();
                return false;
            }
            if (future.getSession() == null) return false;
            if (!future.getSession().isConnected()) return false;
            Object object = this.closeJobLock;
            synchronized (object) {
                if (!this.stopped) return true;
                if (future.getSession().isClosing()) return false;
                future.getSession().close(true);
                return false;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "\u65e0\u6cd5\u8fde\u63a5\u5728\u5730\u5740: " + ip + ":" + port));
            return false;
        }
    }

    public OperationFuture<Integer> sendHearbeat() {
        String opName = "\u53d1\u9001\u5fc3\u8df3";
        byte sendSeq = this.getSendSeq();
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(null, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), "", "heartBeat", this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = ZSCameraAction.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSCameraAction.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = ZSCameraAction.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSCameraAction.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSCameraAction.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "VzLPRSDK.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "VzLPRSDK.so";
        }
        return "VzLPRSDK.dll";
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectIfNotConnected1() throws Exception {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
        }
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            throw new Exception("\u76f8\u673aip\u672a\u914d\u7f6e");
        }
        OperationFuture<Integer> f = this.getLocalProcessTransport().loadNativeDriveIfNeed("com.wovoe.camera.drive.zs.Drive", "\u52a0\u8f7dZS\u76f8\u673a\u672c\u5730\u9a71\u52a8");
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> xd) {
                if (xd.getException() == null && xd.getResult() != null && (Integer)xd.getResult() == 0) {
                    OperationFuture opf = ZSCameraAction.this.registerIfNeed();
                    opf.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> f6) {
                            if (f6.getException() == null && f6.getResult() != null && (Integer)f6.getResult() == 0) {
                                ZSCameraAction.this.nativeConnectErrorCounter = 0;
                            } else if (!ZSCameraAction.this.isWorkingProperly()) {
                                ZSCameraAction.this.nativeConnectErrorCounter = 0;
                            } else {
                                ZSCameraAction zSCameraAction = ZSCameraAction.this;
                                zSCameraAction.nativeConnectErrorCounter = zSCameraAction.nativeConnectErrorCounter + 1;
                                if (ZSCameraAction.this.nativeConnectErrorCounter >= 2) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "] TCP\u80fd\u8fde\u63a5\u4e0a\uff01\u4f46\u662f\u4f7f\u7528\u76f8\u673a\u5382\u5546SDK\u65e0\u6cd5\u8fde\u63a5\u6b64\u76f8\u673a! SDK\u4f30\u8ba1\u51fa\u73b0\u9519\u8bef! \u8fd9\u5c06\u5c1d\u8bd5\u91cd\u542fSDK, \u8fd9\u4f1a\u5f71\u54cd\u89c6\u9891\u663e\u793a\uff0c \u5e76\u4e0d\u4f1a\u5f71\u54cd\u8f66\u724c\u8bc6\u522b"));
                                    ZSCameraAction.this.getLocalProcessTransport().tryRestart();
                                } else {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "] TCP\u80fd\u8fde\u63a5\u4e0a\uff01\u4f46\u662f\u4f7f\u7528\u76f8\u673a\u5382\u5546SDK\u65e0\u6cd5\u8fde\u63a5\u6b64\u76f8\u673a! SDK\u95ee\u9898\uff1f\u7a0d\u540e\u91cd\u65b0\u68c0\u6d4b..."));
                                }
                            }
                        }

                        public void waitCompleteTimeout() {
                        }
                    });
                }
            }
        });
    }

    private void setNativeReusetParam(Map<String, String> paramMap) {
        Map<String, CarparkChannel> chMap;
        List<String> list;
        boolean showOsdName;
        String userPwd;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("port", "80");
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String userName = config.getConfigValue("login_user");
        if (userName == null || userName.length() == 0) {
            userName = "admin";
        }
        if ((userPwd = config.getConfigValue("login_pwd")) == null || userPwd.length() == 0) {
            userPwd = "admin";
        }
        paramMap.put("userName", userName);
        paramMap.put("userPwd", userPwd);
        Long x = this.hwnd;
        if (x != null) {
            paramMap.put("componentID", x.toString());
        }
        String osdText = null;
        boolean bl = showOsdName = !"0".equals(config.getConfigValue("osdChannelName"));
        if (showOsdName && (list = this.equipment.getChannelNos()) != null && !list.isEmpty() && (chMap = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap()) != null && !chMap.isEmpty()) {
            for (String s : list) {
                CarparkChannel ch = chMap.get(s);
                if (ch == null || ch.getChannel_name() == null || ch.getChannel_name().length() <= 0) continue;
                osdText = ch.getChannel_name();
                break;
            }
        }
        if (osdText != null) {
            paramMap.put("osdText", osdText);
        }
    }

    private OperationFuture<Integer> registerIfNeed() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "\u8fde\u63a5\u76f8\u673a[" + this.equipment.getIp() + "]";
        String serviceName = "connectIfNotConnect";
        long timeoutMills = 10000L;
        this.setNativeReusetParam(paramMap);
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u9519\u8bef\u53c2\u6570:componentID:" + x));
            return xf;
        }
        this.hwnd = hwnd0;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setResult((Object)-1);
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u64ad\u653e\u89c6\u9891";
        String serviceName = "playVisible";
        long timeoutMills = 5000L;
        this.setNativeReusetParam(paramMap);
        paramMap.put("componentID", hwnd0.toString());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u505c\u6b62\u64ad\u653e";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        if (param == null || param.get("savePath") == null) {
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570: savePath"));
            return xf;
        }
        final String savePath = param.get("savePath").toString();
        String opName = "\u6293\u62cd\u56fe\u7247";
        byte sendSeq = this.getSendSeq();
        String cmd = "get_snapshot";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                Object s = super.handler((Map)responseMap);
                if (s != null && (Integer)s == 0) {
                    byte[] picData;
                    String imgdata = (String)responseMap.get("imgdata");
                    if (imgdata == null || imgdata.length() == 0) {
                        ServiceLog.getLog().info((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u6293\u62cd\u56fe\u7247\u4e3a\u7a7a: " + responseMap));
                        return -1000;
                    }
                    try {
                        picData = Base64.getDecoder().decode(imgdata);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().info((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u56fe\u7247\u4e0d\u662fbase64\u683c\u5f0f: " + imgdata));
                        return -20000;
                    }
                    try {
                        File saveF = new File(savePath);
                        File pa = saveF.getParentFile();
                        if (!pa.exists()) {
                            pa.mkdirs();
                        }
                        try (FileOutputStream out = new FileOutputStream(saveF);){
                            out.write(picData);
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().info((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]\u4fdd\u5b58\u56fe\u7247\u5f02\u5e38: " + ex.getMessage()));
                        return -30000;
                    }
                }
                return s;
            }
        }, 6000L);
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    @Override
    public boolean isWorkingProperly() {
        IoSession session = this.iosession;
        if (session == null) {
            return false;
        }
        if (!session.isConnected()) {
            return false;
        }
        return !session.isClosing();
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    public OperationFuture<Integer> setCameraTime(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String opName = "\u8bbe\u7f6e\u7cfb\u7edf\u65f6\u95f4";
        byte sendSeq = this.getSendSeq();
        String cmd = "set_time";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("timestring", df.format(date));
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public OperationFuture<String> getCameraSn() {
        String opName = "\u83b7\u53d6\u76f8\u673a\u5e8f\u5217\u53f7";
        byte sendSeq = this.getSendSeq();
        String cmd = "getsn";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<String>(){

            @Override
            public String handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    return null;
                }
                String value = (String)responseMap.get("value");
                return value;
            }
        }, 5000L);
    }

    public OperationFuture<Integer> set_user_data(byte[] data) {
        String opName = "\u8bbe\u7f6e\u76f8\u673a\u7b7e\u540d\u6570\u636e";
        byte sendSeq = this.getSendSeq();
        String cmd = "set_user_data";
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("data", Base64.getEncoder().encodeToString(data));
        dataMap.put("body", bodyMap);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public OperationFuture<String> get_user_data() {
        String opName = "\u83b7\u53d6\u76f8\u673a\u7b7e\u540d\u6570\u636e";
        byte sendSeq = this.getSendSeq();
        String cmd = "get_user_data";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<String>(){

            @Override
            public String handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    return null;
                }
                Object obj = responseMap.get("data");
                if (obj != null) {
                    return null;
                }
                if (obj instanceof Map) {
                    Map aMap = (Map)obj;
                    Object base64Data = aMap.get("data");
                    if (base64Data != null && base64Data instanceof String) {
                        return (String)base64Data;
                    }
                    return null;
                }
                return null;
            }
        }, 5000L);
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        return this.doOpenGateWithDelay(1100, 2);
    }

    public OperationFuture<Integer> doOpenGateWithDelay(int mills, int ioValue) {
        String opName = "IO\u5f00\u95f8";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "ioctl_resp";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("delay", mills);
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer io = config.getConfigIntValue("roadGateIO");
        if (io == null) {
            io = 0;
        }
        dataMap.put("io", io);
        dataMap.put("value", ioValue);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    protected OperationFuture<Integer> doRegOfflineCheck() {
        String opName = "\u6ce8\u518c\u8131\u673a\u68c0\u67e5\u529f\u80fd";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "reg_offline_check";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("interval", 3);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<Integer>(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code + ", \u54cd\u5e94\u6570\u636e: " + responseMap));
                    return -1;
                }
                return code;
            }
        }, 5000L);
    }

    protected OperationFuture<Integer> doGetOfflineState() {
        String opName = "\u83b7\u53d6\u76f8\u673a\u8131\u673a\u72b6\u6001";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String cmd = "get_offline_status";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<Integer>(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                    return -1;
                }
                Object body = responseMap.get("body");
                if (body == null || !(body instanceof Map)) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u8fd4\u56de\u7f3a\u5c11body, \u6216\u8005body \u4e0d\u662fMap! \u54cd\u5e94\u6570\u636e: " + responseMap));
                    return -1;
                }
                Integer value = ZSCameraAction.getInteger((Map)body, "offline_status");
                if (value == null) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94body\u7f3a\u5c11\u53c2\u6570offline_status\uff0c\u6216\u8005\u4e0d\u662f\u6574\u6570!  \u54cd\u5e94\u6570\u636e: " + responseMap));
                    return -1;
                }
                if (value != 0 && value != 1) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94body\u7684offline_status\u4e0d\u662f0\u4e5f\u4e0d\u662f1\uff0c\u54cd\u5e94\u7684offline_status\u4e3a:" + value));
                    return -1;
                }
                return value;
            }
        }, 5000L);
    }

    public OperationFuture<Integer> doGetOutIOState(int ioOutputIndex) {
        String opName = "\u83b7\u53d6\u8f93\u51faIO:" + ioOutputIndex + "\u72b6\u6001";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "get_gpio_out_value";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("gpio", ioOutputIndex);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<Integer>(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                    return -1;
                }
                Integer value = ZSCameraAction.getInteger(responseMap, "value");
                if (value == null) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94\u7f3a\u5c11\u53c2\u6570value\uff0c\u6216\u8005\u4e0d\u662f\u6574\u6570"));
                    return -1;
                }
                if (value != 0 && value != 1) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94\u7684value\u4e0d\u662f0\u4e5f\u4e0d\u662f1\uff0c\u54cd\u5e94\u7684value\u4e3a:" + value));
                    return -1;
                }
                return value;
            }
        }, 5000L);
    }

    private OperationFuture<Integer> doGetIOState(int ioInputIndex) {
        String opName = "\u83b7\u53d6IO\u72b6\u6001";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "get_gpio_value";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("gpio", ioInputIndex);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<Integer>(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                    return -1;
                }
                Integer value = ZSCameraAction.getInteger(responseMap, "value");
                if (value == null) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94\u7f3a\u5c11\u53c2\u6570value\uff0c\u6216\u8005\u4e0d\u662f\u6574\u6570"));
                    return -1;
                }
                if (value != 0 && value != 1) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25!  \u54cd\u5e94\u7684value\u4e0d\u662f0\u4e5f\u4e0d\u662f1\uff0c\u54cd\u5e94\u7684value\u4e3a:" + value));
                    return -1;
                }
                return value;
            }
        }, 5000L);
    }

    public OperationFuture<Integer> configIvsresult() {
        String opName = "\u914d\u7f6e\u8f66\u724c\u8bc6\u522b\u53c2\u6570";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "ivsresult";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("enable", true);
        dataMap.put("format", "json");
        dataMap.put("image", true);
        dataMap.put("image_type", 2);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public OperationFuture<KeyValueEntry<Integer, SerialConfig>> getSerialConfig(final int portIndex) {
        if (portIndex < 0 || portIndex >= this.serialConfigList.length) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u4e32\u53e3\u7d22\u5f15\u5e94\u8be5\u5728\u8303\u56f4[0," + this.serialConfigList.length + "),\u4f46\u662f\u4e3a\uff1a" + portIndex));
            return xf;
        }
        String opName = "\u67e5\u8be2\u4e32\u53e3" + portIndex + "\u914d\u7f6e\u53c2\u6570";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "get_serial_para";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("serial_port", portIndex);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<KeyValueEntry<Integer, SerialConfig>>(){

            @Override
            public KeyValueEntry<Integer, SerialConfig> handler(Map<?, ?> responseMap) throws Exception {
                int opCode = this.getOpCode(responseMap);
                if (opCode != 0) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + this.opName + " \u64cd\u4f5c\u5931\u8d25: " + opCode));
                    return new KeyValueEntry((Object)opCode, null);
                }
                Object body = responseMap.get("body");
                if (body == null || !(body instanceof Map)) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + this.opName + " \u64cd\u4f5c\u5931\u8d25:\u7f3a\u5c11body,\u6216\u7c7b\u578b\u9519\u8bef " + responseMap));
                    return new KeyValueEntry((Object)-100, null);
                }
                Map bodyConfig = (Map)body;
                Integer baud_rate = ZSCameraAction.getInteger(bodyConfig, "baud_rate");
                Integer data_bits = ZSCameraAction.getInteger(bodyConfig, "data_bits");
                Integer parity = ZSCameraAction.getInteger(bodyConfig, "parity");
                Integer stop_bits = ZSCameraAction.getInteger(bodyConfig, "stop_bits");
                if (baud_rate == null || data_bits == null || parity == null || stop_bits == null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + this.opName + " \u64cd\u4f5c\u5931\u8d25:body\u6570\u636e\u9519\u8bef " + responseMap));
                    return new KeyValueEntry((Object)-100, null);
                }
                Integer serial_port = ZSCameraAction.getInteger(responseMap, "serial_port");
                if (serial_port == null || serial_port != portIndex) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + this.opName + " \u64cd\u4f5c\u5931\u8d25:serial_port\u9519\u8bef ,\u67e5\u8be2\u7684\u662f: " + portIndex + ",\u4f46\u8fd4\u56de\u7684\u7ed3\u679c\u662f: " + (serial_port == null ? "null" : Integer.valueOf(serial_port)) + ", \u6570\u636e: " + responseMap));
                    return new KeyValueEntry((Object)-100, null);
                }
                SerialConfig config = new SerialConfig();
                config.baud_rate = baud_rate;
                config.data_bits = data_bits;
                config.parity = parity;
                config.stop_bits = stop_bits;
                config.serial_port = serial_port;
                ((ZSCameraAction)ZSCameraAction.this).serialConfigList[portIndex] = config;
                return new KeyValueEntry((Object)opCode, (Object)config);
            }
        }, 5000L);
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        String opName = "IO\u843d\u95f8";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "ioctl_resp";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("delay", 500);
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer openIo = config.getConfigIntValue("roadGateIO");
        if (openIo == null) {
            openIo = 0;
        }
        if (openIo != 0) {
            openIo = 1;
        }
        int io = openIo == 0 ? 1 : 0;
        dataMap.put("io", io);
        dataMap.put("value", 2);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        int parity;
        int stopBits1;
        int baudRate1;
        int uatIndex;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u76f8\u673a\u672a\u8fde\u63a5"));
            return xf;
        }
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570"));
            return xf;
        }
        Object uatIndex0 = param.get("uatIndex");
        if (uatIndex0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570uatIndex"));
            return xf;
        }
        if (uatIndex0 instanceof Integer) {
            uatIndex = (Integer)uatIndex0;
        } else {
            try {
                uatIndex = Integer.parseInt(uatIndex0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        if (uatIndex < 0 || uatIndex >= this.serialConfigList.length) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570uatIndex\u5fc5\u987b\u662f\u6574\u6570,\u4e14\u5728\u8303\u56f4: [0," + this.serialConfigList.length + ")"));
            return xf;
        }
        int dataBits = 8;
        Object baudRate0 = param.get("baudRate");
        if (baudRate0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570baudRate"));
            return xf;
        }
        if (baudRate0 instanceof Integer) {
            baudRate1 = (Integer)baudRate0;
        } else {
            try {
                baudRate1 = Integer.parseInt(baudRate0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        int baudRate = baudRate1;
        Object stopBits0 = param.get("stopBits");
        if (stopBits0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570stopBits"));
            return xf;
        }
        if (stopBits0 instanceof Integer) {
            stopBits1 = (Integer)stopBits0;
        } else {
            try {
                stopBits1 = Integer.parseInt(stopBits0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        int stopBits = stopBits1;
        if (stopBits != 1 && stopBits != 2) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570stopBits\u5fc5\u987b\u662f\u30101\u30012\u3011\u4e2d\u7684\u4e00\u4e2a"));
            return xf;
        }
        Object parity0 = param.get("parity");
        if (parity0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570parity"));
            return xf;
        }
        String parity1 = parity0.toString();
        if ("PARITY_NONE".equals(parity1)) {
            parity = 0;
        } else if ("PARITY_ODD".equals(parity1)) {
            parity = 1;
        } else if ("PARITY_EVEN".equals(parity1)) {
            parity = 2;
        } else {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u53c2\u6570parity\u5fc5\u987b\u662fPARITY_NONE\u3001PARITY_ODD\u3001PARITY_EVEN"));
            return xf;
        }
        final SerialConfig config = new SerialConfig();
        config.baud_rate = baudRate;
        config.data_bits = dataBits;
        config.parity = parity;
        config.stop_bits = stopBits;
        config.serial_port = uatIndex;
        SerialConfig config0 = this.serialConfigList[uatIndex];
        if (config0 != null) {
            if (config0.equals(config)) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setResult((Object)0);
                return xf;
            }
            return this.setSerialConfig(config);
        }
        final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        OperationFuture<KeyValueEntry<Integer, SerialConfig>> f9 = this.getSerialConfig(uatIndex);
        f9.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<KeyValueEntry<Integer, SerialConfig>>(){

            public void waitCompleteTimeout() {
                xf.setException((Throwable)new TimeoutException());
            }

            public void operationComplete(OperationFuture<KeyValueEntry<Integer, SerialConfig>> f1) {
                if (f1.getException() != null) {
                    xf.setException(f1.getException());
                } else if (f1.getResult() == null) {
                    xf.setResult((Object)-1);
                } else {
                    KeyValueEntry en = (KeyValueEntry)f1.getResult();
                    if (en.getKey() == null) {
                        xf.setResult((Object)-1);
                    } else if ((Integer)en.getKey() != 0) {
                        xf.setResult((Object)((Integer)en.getKey()));
                    } else if (en.getValue() == null) {
                        xf.setResult((Object)-1);
                    } else if (config.equals(en.getValue())) {
                        xf.setResult((Object)0);
                    } else {
                        OperationFuture f = ZSCameraAction.this.setSerialConfig(config);
                        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void waitCompleteTimeout() {
                                xf.setException((Throwable)new TimeoutException());
                            }

                            public void operationComplete(OperationFuture<Integer> w) {
                                if (w.getException() != null) {
                                    xf.setException(w.getException());
                                } else {
                                    xf.setResult((Object)((Integer)w.getResult()));
                                }
                            }
                        });
                    }
                }
            }
        });
        return xf;
    }

    private OperationFuture<Integer> setSerialConfig(final SerialConfig config) {
        String opName = "\u914d\u7f6e\u4e32\u53e3" + config.serial_port + "\u53c2\u6570";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "set_serial_para";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("serial_port", config.serial_port);
        LinkedHashMap<String, Integer> body = new LinkedHashMap<String, Integer>();
        body.put("baud_rate", config.baud_rate);
        body.put("data_bits", config.data_bits);
        body.put("parity", config.parity);
        body.put("stop_bits", config.stop_bits);
        dataMap.put("body", body);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code == 0) {
                    ((ZSCameraAction)ZSCameraAction.this).serialConfigList[((SerialConfig)config).serial_port] = config;
                }
                return code;
            }
        }, 8000L);
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (data == null || data.length == 0) {
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        RS485ThreadHandler shandler = this.getRS485ThreadHandler(portIndex);
        if (shandler == null || !shandler.isStarted()) {
            if (this.stopped) {
                f.setException((Throwable)new IllegalStateException("\u9a71\u52a8\u5df2\u7ecf\u505c\u6b62!"));
                return f;
            }
            f.setException((Throwable)new IllegalStateException("\u521d\u59cb\u5316\u53d1\u9001\u4e32\u53e3\u7ebf\u7a0b\u5931\u8d25!"));
            return f;
        }
        shandler.sendToQueue(data, handler, f, waitMills);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RS485ThreadHandler getRS485ThreadHandler(int index) {
        RS485ThreadHandler rs485ThreadHandler;
        block7: {
            if (this.stopped) {
                return null;
            }
            if (index < 0 || index >= this.rs485ThreadHandlers.length) {
                return null;
            }
            rs485ThreadHandler = this.rs485ThreadHandlers[index];
            if (rs485ThreadHandler != null) break block7;
            Object object = this.closeJobLock;
            synchronized (object) {
                block6: {
                    rs485ThreadHandler = this.rs485ThreadHandlers[index];
                    if (rs485ThreadHandler != null) break block7;
                    if (!this.stopped) break block6;
                    return null;
                }
                rs485ThreadHandler = new RS485ThreadHandler(index){

                    @Override
                    protected OperationFuture<Boolean> directSend(final byte[] data) {
                        try {
                            if (ZSCameraAction.this.initRs485List[this.portIndex]) {
                                return ZSCameraAction.this.sendSerialData(this.portIndex, data);
                            }
                            final OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                            ZSCameraAction.this.startSerial(this.portIndex).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void waitCompleteTimeout() {
                                    xf.setException((Throwable)new TimeoutException());
                                }

                                public void operationComplete(OperationFuture<Integer> fn) {
                                    if (fn.getException() != null) {
                                        xf.setException(fn.getException());
                                    } else if (fn.getResult() != null && (Integer)fn.getResult() == 0) {
                                        ZSCameraAction.this.sendSerialData(portIndex, data).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Boolean>(){

                                            public void waitCompleteTimeout() {
                                                xf.setException((Throwable)new TimeoutException());
                                            }

                                            public void operationComplete(OperationFuture<Boolean> fg) {
                                                if (fg.getException() != null) {
                                                    xf.setException(fg.getException());
                                                } else {
                                                    xf.setResult((Object)((Boolean)fg.getResult()));
                                                }
                                            }
                                        });
                                    } else {
                                        xf.setResult((Object)Boolean.FALSE);
                                    }
                                }
                            });
                            return xf;
                        }
                        catch (Throwable ex) {
                            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                            xf.setException(ex);
                            return xf;
                        }
                    }
                };
                rs485ThreadHandler.start();
                this.rs485ThreadHandlers[index] = rs485ThreadHandler;
            }
        }
        return rs485ThreadHandler;
    }

    private OperationFuture<Boolean> sendSerialData0(int port, byte[] data) {
        try {
            String opName = "\u5411\u4e32\u53e3" + port + "\u53d1\u9001\u6570\u636e";
            byte sendSeq = this.getSendSeq();
            LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
            String cmd = "ttransmission";
            dataMap.put("cmd", cmd);
            String id = String.valueOf(this.getIdSeq());
            dataMap.put("id", id);
            dataMap.put("subcmd", "send");
            dataMap.put("datalen", data.length);
            dataMap.put("data", Base64.getEncoder().encodeToString(data));
            dataMap.put("comm", "rs485-" + (port + 1));
            ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
            WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
            return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<Boolean>(){

                @Override
                public Boolean handler(Map<?, ?> responseMap) throws Exception {
                    int code = this.getOpCode(responseMap);
                    if (code != 0) {
                        ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                    }
                    if (code == 0) {
                        return true;
                    }
                    return false;
                }
            }, 5000L);
        }
        catch (Exception ex) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)ex);
            return f;
        }
    }

    private OperationFuture<Boolean> sendSerialData(int port, byte[] data) {
        int pageSize = 50;
        if (data.length <= pageSize) {
            return this.sendSerialData0(port, data);
        }
        int offset = 0;
        int count = data.length / pageSize;
        byte[] ax = new byte[pageSize];
        OperationFuture<Boolean> f = null;
        int i = 0;
        while (i < count) {
            System.arraycopy(data, offset, ax, 0, ax.length);
            offset += pageSize;
            f = this.sendSerialData0(port, ax);
            ++i;
        }
        int rem = data.length - offset;
        if (rem > 0) {
            ax = new byte[rem];
            System.arraycopy(data, offset, ax, 0, ax.length);
            f = this.sendSerialData0(port, ax);
        }
        return f;
    }

    private OperationFuture<Integer> startSerial(final int port) {
        String opName = "\u6253\u5f00\u4e32\u53e3" + port;
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "ttransmission";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("subcmd", "init");
        dataMap.put("comm", port);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(){

            @Override
            public Integer handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code == 0) {
                    ((ZSCameraAction)ZSCameraAction.this).initRs485List[port] = true;
                } else {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u521d\u59cb\u5316\u4e32\u53e3 :  " + port + "\u5931\u8d25! " + code));
                }
                return code;
            }
        }, 8000L);
    }

    @Override
    public boolean isSupportWhiteList() {
        return true;
    }

    @Override
    public boolean isSupportBlackList() {
        return false;
    }

    @Override
    public void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList, Collection<PlateEntry> blackList, PlateRegCameraAction.ImportPlateCallback callback) throws Exception {
        this.downlodAllWhiteBlackList(whiteList, blackList, callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downlodAllWhiteBlackList(Collection<PlateEntry> whiteList01, Collection<PlateEntry> blackList01, PlateRegCameraAction.ImportPlateCallback callback, boolean onlyCheck) throws Exception {
        try {
            if (callback != null) {
                callback.onCheck(this.equipment.getEquipmentNo(), onlyCheck);
            }
            if (!this.isWorkingProperly()) {
                throw new Exception("\u8bbe\u5907" + this.equipment.getName() + "\u672a\u8fde\u63a5!");
            }
            Collection<PlateEntry> whiteList0 = whiteList01 != null ? whiteList01 : new LinkedList<PlateEntry>();
            Collection<PlateEntry> blackList0 = blackList01 != null ? blackList01 : new LinkedList<PlateEntry>();
            Object object = this.downloadLocak;
            synchronized (object) {
                Collection whiteList1 = this.whiteList;
                if (whiteList1 == null) {
                    KeyValueEntry en;
                    List<KeyValueEntry<Integer, Integer>> pageList;
                    OperationFuture<KeyValueEntry<Integer, Integer>> kvf;
                    KeyValueEntry kv;
                    if (callback != null) {
                        callback.onQueryAll(this.equipment.getEquipmentNo());
                    }
                    if ((kv = (KeyValueEntry)(kvf = this.queryWhiteListCount()).get(6L, TimeUnit.SECONDS)) == null || (Integer)kv.getKey() != 0 || kv.getValue() == null || (Integer)kv.getValue() < 0) {
                        throw new Exception("\u67e5\u8be2\u76f8\u673a\u767d\u540d\u5355\u5217\u603b\u6570\u5931\u8d25!  state: " + (kv == null || kv.getKey() == null ? -1 : (Integer)kv.getKey()));
                    }
                    int totalCount = (Integer)kv.getValue();
                    KeyValueEntry resultEn = new KeyValueEntry((Object)0, totalCount > 0 ? new ArrayList(totalCount) : new ArrayList());
                    if (totalCount > 0 && (pageList = ServiceUtil.getPaginationList(totalCount, 10)) != null && !pageList.isEmpty()) {
                        for (KeyValueEntry<Integer, Integer> pagekv : pageList) {
                            OperationFuture<KeyValueEntry<Integer, List<PlateEntry>>> enf = this.queryWhiteListPaging(5000, (Integer)pagekv.getKey(), (Integer)pagekv.getValue());
                            PlateEntry en2 = (KeyValueEntry)enf.get(6L, TimeUnit.SECONDS);
                            if (en2.getKey() == null || (Integer)en2.getKey() != 0) {
                                throw new Exception("\u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u5931\u8d25!  state: " + (en2 == null || en2.getKey() == null ? -1 : (Integer)en2.getKey()));
                            }
                            if (en2.getValue() == null || ((List)en2.getValue()).isEmpty()) continue;
                            ((List)resultEn.getValue()).addAll((Collection)en2.getValue());
                        }
                    }
                    if ((en = resultEn).getKey() == null || (Integer)en.getKey() != 0 || en.getValue() == null) {
                        throw new Exception("\u67e5\u8be2\u767d\u540d\u5355\u5217\u8868\u5931\u8d25!  state: " + (en == null || en.getKey() == null ? -1 : (Integer)en.getKey()));
                    }
                    this.whiteList = whiteList1 = (Collection)en.getValue();
                }
                if (callback != null) {
                    callback.onQueryAllFinish(this.equipment.getEquipmentNo(), whiteList1.size(), 0, whiteList0 == null ? 0 : whiteList0.size(), blackList0 == null ? 0 : blackList0.size());
                }
                HashMap<String, PlateEntry> oldWhilteListMap = new HashMap<String, PlateEntry>();
                if (whiteList1 != null && !whiteList1.isEmpty()) {
                    for (PlateEntry en : whiteList1) {
                        oldWhilteListMap.put(en.getPlate(), en);
                    }
                }
                int insertW = 0;
                int updateW = 0;
                int deleteW = 0;
                int sameW = 0;
                LinkedList<PlateEntry> insertOrUpdateList = new LinkedList<PlateEntry>();
                LinkedList delteList = new LinkedList();
                LinkedList<PlateEntry> sameList = new LinkedList<PlateEntry>();
                if (whiteList0 != null && !whiteList0.isEmpty()) {
                    for (PlateEntry en2 : whiteList0) {
                        PlateEntry n = (PlateEntry)oldWhilteListMap.remove(en2.getPlate());
                        if (n == null) {
                            ++insertW;
                            insertOrUpdateList.add(en2);
                            continue;
                        }
                        if (n.equals(en2)) {
                            ++sameW;
                            sameList.add(en2);
                            continue;
                        }
                        ++updateW;
                        insertOrUpdateList.add(en2);
                    }
                }
                if (!oldWhilteListMap.isEmpty()) {
                    deleteW += oldWhilteListMap.size();
                    delteList.addAll(oldWhilteListMap.values());
                }
                if (insertW == 0 && updateW == 0 && deleteW == 0) {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), 0, 0, 0, sameW, 0, 0, 0, 0, onlyCheck);
                    }
                } else {
                    if (callback != null) {
                        callback.onCheckReusult(this.equipment.getEquipmentNo(), insertW, updateW, deleteW, sameW, 0, 0, 0, 0, onlyCheck);
                    }
                    if (onlyCheck) {
                        return;
                    }
                    if (ServiceLog.getLog().isInfoEnabled()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u53d1\u73b0\u8f66\u724c\u9700\u8981\u540c\u6b65\uff0c\u51c6\u5907\u4e0b\u8f7d\u6700\u65b0\u7684\u8f66\u724c\u4fe1\u606f! "));
                    }
                    if (callback != null) {
                        callback.onStartDownlod(this.equipment.getEquipmentNo());
                    }
                    boolean needRecheck = false;
                    try {
                        if (whiteList0 == null || whiteList0.isEmpty()) {
                            Integer h = (Integer)this.delWhitePlate(null, 9000).get(10L, TimeUnit.SECONDS);
                            if (h == null) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u767d\u540d\u5355\u8d85\u65f6!");
                            }
                            if (h != 0) {
                                throw new Exception(String.valueOf(this.equipment.getIp()) + ": \u6e05\u7a7a\u767d\u540d\u5355\u5931\u8d25!");
                            }
                            ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u767d\u540d\u5355\u5df2\u88ab\u6e05\u7a7a"));
                            if (callback != null) {
                                LinkedList<PlateEntry> emptyList = new LinkedList<PlateEntry>();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, whiteList1, emptyList, emptyList, emptyList);
                            }
                            needRecheck = true;
                        } else {
                            Integer h;
                            LinkedList<PlateEntry> errWhiteList = new LinkedList<PlateEntry>();
                            LinkedList<PlateEntry> successWhiteList = new LinkedList<PlateEntry>();
                            if (!delteList.isEmpty()) {
                                for (PlateEntry en : delteList) {
                                    if (en.getPlate() != null && en.getPlate().length() > 0) {
                                        if (!this.isWorkingProperly()) {
                                            errWhiteList.add(en);
                                            continue;
                                        }
                                        try {
                                            h = (Integer)this.delWhitePlate(en.getPlate(), 6000).get(6500L, TimeUnit.MILLISECONDS);
                                            if (h != null && h == 0) {
                                                successWhiteList.add(en);
                                                continue;
                                            }
                                            errWhiteList.add(en);
                                        }
                                        catch (Exception ex) {
                                            errWhiteList.add(en);
                                        }
                                        continue;
                                    }
                                    errWhiteList.add(en);
                                }
                            }
                            if (!insertOrUpdateList.isEmpty()) {
                                for (PlateEntry en : insertOrUpdateList) {
                                    if (!this.isWorkingProperly()) {
                                        errWhiteList.add(en);
                                        continue;
                                    }
                                    try {
                                        h = (Integer)this.addWhitePlate(en, 6000).get(6500L, TimeUnit.MILLISECONDS);
                                        if (h != null && h == 0) {
                                            successWhiteList.add(en);
                                            continue;
                                        }
                                        errWhiteList.add(en);
                                    }
                                    catch (Exception ex) {
                                        errWhiteList.add(en);
                                    }
                                }
                            }
                            if (ServiceLog.getLog().isInfoEnabled()) {
                                String ip = this.equipment.getIp();
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u901a\u9053\u767d\u540d\u5355\u603b\u8f66\u724c\u6570: " + whiteList0.size()));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u76f8\u673a\u5df2\u5b58\u5728\u6570: " + sameW));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u6210\u529f\u6570: " + successWhiteList.size() + " " + successWhiteList));
                                ServiceLog.getLog().info((Object)(String.valueOf(ip) + ": \u767d\u540d\u5355\u672c\u6b21\u5931\u8d25\u6570: " + errWhiteList.size() + " " + errWhiteList));
                            }
                            if (callback != null) {
                                LinkedList<PlateEntry> emptyList = new LinkedList<PlateEntry>();
                                callback.onFinishDownlod(this.equipment.getEquipmentNo(), whiteList0, blackList0, successWhiteList, errWhiteList, emptyList, emptyList);
                            }
                            if (errWhiteList.size() == 0) {
                                needRecheck = true;
                            }
                        }
                    }
                    finally {
                        this.whiteList = null;
                    }
                    if (!onlyCheck && needRecheck) {
                        this.downlodAllWhiteBlackList(whiteList0, blackList0, callback, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (callback != null) {
                callback.onDownlodException(this.equipment.getEquipmentNo(), ex);
            }
            throw ex;
        }
    }

    private OperationFuture<KeyValueEntry<Integer, Integer>> queryWhiteListCount() {
        String opName = "\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u603b\u6570";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String cmd = "white_list_operator";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("operator_type", "select_count");
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send("\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u603b\u6570", this.iosession, p, waitResponseKey, new ResponseHandler<KeyValueEntry<Integer, Integer>>(){

            @Override
            public KeyValueEntry<Integer, Integer> handler(Map<?, ?> responseMap) throws Exception {
                int responseCode = this.getOpCode(responseMap);
                if (responseCode == 0) {
                    Integer total_count = ZSCameraAction.getInteger(responseMap, "total_count");
                    if (total_count == null || total_count < 0) {
                        return new KeyValueEntry((Object)-5, (Object)0);
                    }
                    return new KeyValueEntry((Object)responseCode, (Object)total_count);
                }
                return new KeyValueEntry((Object)responseCode, (Object)0);
            }
        }, 5000L);
    }

    OperationFuture<KeyValueEntry<Integer, List<PlateEntry>>> queryWhiteListPaging(int timeount, int start_pos, int select_count) {
        String opName = "\u5206\u9875\u67e5\u8be2\u767d\u540d\u5355, \u67e5\u8be2\u6570\u91cf\uff1a" + select_count + ", \u504f\u79fb\u91cf\uff1a" + start_pos;
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "white_list_operator";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("operator_type", "select_fuzzy");
        dataMap.put("plate", "");
        dataMap.put("start_pos", start_pos);
        dataMap.put("select_count", select_count);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<KeyValueEntry<Integer, List<PlateEntry>>>(){
            ConcurrentLinkedQueue<Map<?, ?>> receiveList;
            {
                this.receiveList = new ConcurrentLinkedQueue();
            }

            @Override
            public KeyValueEntry<Integer, List<PlateEntry>> handler(Map<?, ?> responseMapx) throws Exception {
                int code = this.getOpCode(responseMapx);
                if (code == 0) {
                    Map<?, ?> responseMap;
                    this.receiveList.offer(responseMapx);
                    Integer continue_recv = ZSCameraAction.getInteger(responseMapx, "continue_recv");
                    if (continue_recv != null && continue_recv == 1) {
                        return null;
                    }
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                    LinkedList<PlateEntry> entryList = new LinkedList<PlateEntry>();
                    while ((responseMap = this.receiveList.poll()) != null) {
                        Object obj = responseMap.get("dldb_rec");
                        if (obj == null || !(obj instanceof List)) continue;
                        List queryList = (List)responseMap.get("dldb_rec");
                        for (Object o : queryList) {
                            Map entryMap = (Map)o;
                            String plate = (String)entryMap.get("plate");
                            if (plate == null || plate.length() == 0) continue;
                            Integer time_seg_enable = ZSCameraAction.getInteger(entryMap, "time_seg_enable");
                            Integer enable = ZSCameraAction.getInteger(entryMap, "enable");
                            String enable_time = (String)entryMap.get("enable_time");
                            String overdue_time = (String)entryMap.get("overdue_time");
                            PlateEntry entry = new PlateEntry();
                            entry.setPlate(plate);
                            try {
                                entry.setBeginDate(df2.format(df1.parse(enable_time)));
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef:  " + enable_time));
                                entry.setBeginDate("2000-01-01");
                            }
                            try {
                                entry.setEndDate(df2.format(df1.parse(overdue_time)));
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef:  " + overdue_time));
                                entry.setEndDate(entry.getBeginDate());
                            }
                            if (enable == null || enable != 1) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u53d1\u73b0\u672a\u542f\u7528:  " + enable + ",\u6807\u8bb0\u9700\u8981\u4fee\u6539"));
                                entry.setBeginDate("2000-01-01");
                                entry.setEndDate("2000-01-01");
                            } else if (time_seg_enable != null && time_seg_enable != 0) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u53d1\u73b0\u542f\u7528\u65f6\u6bb5\u89c4\u5219:  " + time_seg_enable + ",\u6807\u8bb0\u9700\u8981\u4fee\u6539"));
                                entry.setBeginDate("2000-01-01");
                                entry.setEndDate("2000-01-01");
                            }
                            entryList.add(entry);
                        }
                    }
                    return new KeyValueEntry((Object)0, entryList);
                }
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                return new KeyValueEntry((Object)code, null);
            }
        }, timeount);
    }

    OperationFuture<KeyValueEntry<Integer, List<PlateEntry>>> queryWhiteList(String plate, int timeount) {
        String opName = plate == null ? "\u67e5\u8be2\u6240\u6709\u767d\u540d\u5355" : "\u67e5\u8be2\u767d\u540d\u5355\u8f66\u724c:" + plate;
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String cmd = "white_list_operator";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("operator_type", "select");
        if (plate != null) {
            dataMap.put("plate", plate);
        }
        dataMap.put("sub_type", "plate");
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<KeyValueEntry<Integer, List<PlateEntry>>>(){
            ConcurrentLinkedQueue<Map<?, ?>> receiveList;
            {
                this.receiveList = new ConcurrentLinkedQueue();
            }

            @Override
            public KeyValueEntry<Integer, List<PlateEntry>> handler(Map<?, ?> responseMapx) throws Exception {
                int code = this.getOpCode(responseMapx);
                if (code == 0) {
                    Map<?, ?> responseMap;
                    this.receiveList.offer(responseMapx);
                    Integer continue_recv = ZSCameraAction.getInteger(responseMapx, "continue_recv");
                    if (continue_recv != null && continue_recv == 1) {
                        return null;
                    }
                    SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
                    LinkedList<PlateEntry> entryList = new LinkedList<PlateEntry>();
                    while ((responseMap = this.receiveList.poll()) != null) {
                        Object obj = responseMap.get("dldb_rec");
                        if (obj == null || !(obj instanceof List)) continue;
                        List queryList = (List)responseMap.get("dldb_rec");
                        for (Object o : queryList) {
                            Map entryMap = (Map)o;
                            String plate = (String)entryMap.get("plate");
                            if (plate == null || plate.length() == 0) continue;
                            Integer time_seg_enable = ZSCameraAction.getInteger(entryMap, "time_seg_enable");
                            Integer enable = ZSCameraAction.getInteger(entryMap, "enable");
                            String enable_time = (String)entryMap.get("enable_time");
                            String overdue_time = (String)entryMap.get("overdue_time");
                            PlateEntry entry = new PlateEntry();
                            entry.setPlate(plate);
                            try {
                                entry.setBeginDate(df2.format(df1.parse(enable_time)));
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef:  " + enable_time));
                                entry.setBeginDate("2000-01-01");
                            }
                            try {
                                entry.setEndDate(df2.format(df1.parse(overdue_time)));
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef:  " + overdue_time));
                                entry.setEndDate(entry.getBeginDate());
                            }
                            if (enable == null || enable != 1) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u53d1\u73b0\u672a\u542f\u7528:  " + enable + ",\u6807\u8bb0\u9700\u8981\u4fee\u6539"));
                                entry.setBeginDate("2000-01-01");
                                entry.setEndDate("2000-01-01");
                            } else if (time_seg_enable != null && time_seg_enable != 0) {
                                ServiceLog.getLog().info((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] \u5185\u767d\u540d\u5355\u8f66\u724c" + plate + "\u53d1\u73b0\u542f\u7528\u65f6\u6bb5\u89c4\u5219:  " + time_seg_enable + ",\u6807\u8bb0\u9700\u8981\u4fee\u6539"));
                                entry.setBeginDate("2000-01-01");
                                entry.setEndDate("2000-01-01");
                            }
                            entryList.add(entry);
                        }
                    }
                    return new KeyValueEntry((Object)0, entryList);
                }
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + this.opName + " \u5931\u8d25! " + code));
                return new KeyValueEntry((Object)code, null);
            }
        }, timeount);
    }

    private OperationFuture<Integer> addWhitePlate(PlateEntry entry, int timeount) {
        return this.modifyWhitePlate(entry, timeount);
    }

    private OperationFuture<Integer> modifyWhitePlate(PlateEntry entry, int timeount) {
        String plateCode;
        if (entry.getPlate() == null || entry.getPlate().length() == 0) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new NullPointerException("\u7f3a\u5c11\u8f66\u724c"));
            return f;
        }
        if (entry.getBeginDate() == null || entry.getBeginDate().length() == 0) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new NullPointerException("\u7f3a\u5c11\u5f00\u59cb\u65e5\u671f,\u8f66\u724c\u53f7: " + entry.getPlate()));
            return f;
        }
        if (entry.getEndDate() == null || entry.getEndDate().length() == 0) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new NullPointerException("\u7f3a\u5c11\u7ed3\u675f\u65e5\u671f,\u8f66\u724c\u53f7: " + entry.getPlate()));
            return f;
        }
        try {
            plateCode = BytesTool.byteArrayToHexString((byte[])entry.getPlate().getBytes("GB2312"));
        }
        catch (UnsupportedEncodingException e) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)e);
            return f;
        }
        String opName = "\u65b0\u589e\u6216\u4fee\u6539\u767d\u540d\u5355\u8f66\u724c:" + entry.getPlate();
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        String cmd = "white_list_operator";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("operator_type", "update_or_add");
        LinkedHashMap<String, Object> dldb_rec = new LinkedHashMap<String, Object>();
        dldb_rec.put("create_time", String.valueOf(entry.getBeginDate()) + " 00:00:00");
        dldb_rec.put("enable_time", String.valueOf(entry.getBeginDate()) + " 00:00:00");
        dldb_rec.put("overdue_time", String.valueOf(entry.getEndDate()) + " 23:59:00");
        dldb_rec.put("enable", 1);
        dldb_rec.put("plate", entry.getPlate());
        dldb_rec.put("time_seg_enable", 0);
        dldb_rec.put("need_alarm", 0);
        dldb_rec.put("vehicle_code", plateCode);
        dldb_rec.put("vehicle_comment", "");
        dldb_rec.put("customer_id", Math.abs(entry.getPlate().hashCode()));
        dataMap.put("dldb_rec", dldb_rec);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), timeount);
    }

    private OperationFuture<Integer> delWhitePlate(String plate, int timeount) {
        String opName = plate == null ? "\u6e05\u7a7a\u6574\u4e2a\u767d\u540d\u5355" : "\u5220\u9664\u767d\u540d\u5355\u8f66\u724c:" + plate;
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String cmd = "white_list_operator";
        dataMap.put("cmd", cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put("id", id);
        dataMap.put("operator_type", "delete");
        if (plate != null) {
            dataMap.put("plate", plate);
        }
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), timeount);
    }

    @Override
    public OperationFuture<Integer> triggerRegPlate() {
        String opName = "\u8f6f\u89e6\u53d1\u8bc6\u522b\u8f66\u724c";
        byte sendSeq = this.getSendSeq();
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String cmd = "trigger";
        dataMap.put("cmd", cmd);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        return this.send(opName, this.iosession, p, null, null, 3000L);
    }

    public void exceptionCaught(IoSession session, Throwable e) throws Exception {
        try {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": " + e.getMessage()));
        }
        finally {
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        if (buf == null) {
            return;
        }
        ZSCameraTcpProtocol protocl = (ZSCameraTcpProtocol)session.getAttribute((Object)ZSCameraTcpProtocolName);
        protocl.parse(buf, this);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        ServiceLog.getLog().info((Object)("\u4e0e\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u5931\u53bb\u8fde\u63a5 "));
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private int getIdSeq() {
        return Math.abs(this.idseq.incrementAndGet());
    }

    private static Integer getInteger(Map<?, ?> dataMap, String key) {
        if (dataMap == null) {
            return null;
        }
        Object obj = dataMap.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            String v = (String)obj;
            if (v.length() == 0) {
                return null;
            }
            return Integer.valueOf(v);
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).intValue();
        }
        return Integer.valueOf(obj.toString());
    }

    private <R> OperationFuture<R> send(final String opName, IoSession session, ZSCameraTcpProtocol.ZSCameraPackage p, final WaitResponseKey waitResponseKey, ResponseHandler<R> handler, long waitMills) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.addCompleteListener(new OperationFuture.CompleteListener<R>(){

            public void operationComplete(OperationFuture<R> f1) {
                if (f1.getException() != null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + opName + " \u9519\u8bef: " + f1.getException()));
                }
            }

            public void waitCompleteTimeout() {
                ServiceLog.getLog().warn((Object)(String.valueOf(ZSCameraAction.this.equipment.getName()) + "[" + ZSCameraAction.this.equipment.getIp() + "]: " + opName + " \u8d85\u65f6"));
            }
        });
        if (session == null || !session.isConnected() || session.isClosing()) {
            f.setException((Throwable)new IOException("session is invalid! unconnected!"));
            return f;
        }
        try {
            IoBuffer buf = ZSCameraTcpProtocol.toSendBuf(p);
            if (waitResponseKey != null && handler != null) {
                handler.opName = opName;
                KeyValueEntry entry = new KeyValueEntry((Object)f, handler);
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)waitResponseKey, (Object)entry, handler, waitMills, TimeUnit.MILLISECONDS);
                WriteFuture wf = session.write((Object)buf);
                wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture s) {
                        if (s.isDone() && s.getException() != null) {
                            try {
                                KeyValueEntry entry = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey);
                                if (entry != null) {
                                    ((OperationFutureHandler)entry.getKey()).setException(s.getException());
                                }
                            }
                            finally {
                                if (s.getSession() != null && s.getSession().isConnected() && !s.getSession().isClosing()) {
                                    s.getSession().close(true);
                                }
                            }
                        }
                    }
                });
            } else {
                WriteFuture wf = session.write((Object)buf);
                wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture s) {
                        if (s.isDone()) {
                            if (s.getException() != null) {
                                try {
                                    f.setException(s.getException());
                                }
                                finally {
                                    if (s.getSession() != null && s.getSession().isConnected() && !s.getSession().isClosing()) {
                                        s.getSession().close(true);
                                    }
                                }
                            } else {
                                Integer v = s.isWritten() ? Integer.valueOf(0) : Integer.valueOf(1);
                                f.setResult((Object)v);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            f.setException((Throwable)ex);
        }
        return f;
    }

    private byte getSendSeq() {
        int seq1 = Math.abs(this.seqFac.incrementAndGet());
        return (byte)(seq1 % 256);
    }

    @Override
    public void handlerPackage(ZSCameraTcpProtocol.ZSCameraPackage p) throws Exception {
        KeyValueEntry entry;
        WaitResponseKey waitResponseKey = null;
        Map dataMap = null;
        if (p.isHeartBeat()) {
            this.lastRevHeartBeat = ServiceUtil.getServiceContext().currentTimeMillis();
            waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), "", "heartBeat", this.equipment.getEquipmentNo());
            HashMap<String, Object> dataMap1 = new HashMap<String, Object>();
            dataMap1.put("cmd", "heartBeat");
            dataMap1.put("state_code", 200);
            dataMap = dataMap1;
        } else {
            int jsonEndIndx = -1;
            int jsonFinish = 0;
            int end = p.getDataOffset() + p.getDataLen();
            int i = p.getDataOffset();
            while (i < end) {
                byte bz = p.getData()[i];
                if (bz == 123) {
                    ++jsonFinish;
                } else if (bz == 125 && --jsonFinish == 0) {
                    jsonEndIndx = i + 1;
                    break;
                }
                ++i;
            }
            int jsonEndLen = jsonEndIndx != -1 ? jsonEndIndx - p.getDataOffset() : p.getDataLen();
            boolean isWiteListResultList = ZSCameraAction.containsBytes(p.getData(), p.getDataOffset(), jsonEndLen, witeListResult2Keys) || ZSCameraAction.containsBytes(p.getData(), p.getDataOffset(), jsonEndLen, witeListResult3Keys);
            String chaset = isWiteListResultList ? "UTF-8" : "GB2312";
            String json = new String(p.getData(), p.getDataOffset(), jsonEndLen, chaset);
            if (json.indexOf("\"PlateResult\"") != -1 && json.indexOf("\"ivs_result\"") != -1) {
                RegPlateEntry regPlateEntry;
                try {
                    regPlateEntry = (RegPlateEntry)ServiceUtil.getHtmlEscapingGson().fromJson(json, RegPlateEntry.class);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u8fd4\u56de\u4e86\u4e00\u4e2a\u4e0d\u662fjson\u7684\u6570\u636e:  " + json));
                    return;
                }
                if (regPlateEntry.getPlateResult() == null || regPlateEntry.getPlateResult().getLicense() == null || regPlateEntry.getPlateResult().getLicense().length() == 0) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u8f66\u724c\u8bc6\u522b\u7ed3\u679c\u7f3a\u5c11\u8f66\u724c, \u6570\u636e:  " + json));
                    return;
                }
                this.handleRegPlate(p, regPlateEntry, ++jsonEndIndx);
            } else {
                try {
                    dataMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(json, LinkedHashMap.class);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u8fd4\u56de\u4e86\u4e00\u4e2a\u4e0d\u662fjson\u7684\u6570\u636e:  " + json));
                    return;
                }
                String cmd = (String)dataMap.get("cmd");
                if (cmd == null || cmd.length() == 0) {
                    if (json.length() > 2) {
                        ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u54cd\u5e94json\u7f3a\u5c11cmd! json:" + json));
                    }
                    return;
                }
                if ("ttransmission".equals(cmd) && "send".equals(dataMap.get("subcmd")) && dataMap.get("comm") != null && dataMap.get("data") != null && dataMap.get("datalen") != null) {
                    this.handleRs485Data(dataMap);
                } else {
                    Integer state_code = null;
                    try {
                        state_code = ZSCameraAction.getInteger(dataMap, "state_code");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("white_list_operator".equals(cmd) && "select".equals(dataMap.get("operator_type")) && state_code != null && state_code == SUCCESS_CODE && dataMap.get("continue_recv") != null) {
                        if (dataMap.containsKey("total_count")) {
                            Object id = dataMap.get("id");
                            String idstr = id != null ? id.toString() : null;
                            WaitResponseKey waitResponseKey0 = new WaitResponseKey(p.getSeq(), p.getDataType(), idstr, cmd, this.equipment.getEquipmentNo());
                            Integer continue_recv = ZSCameraAction.getInteger(dataMap, "continue_recv");
                            if (continue_recv != null && continue_recv == 1) {
                                KeyValueEntry entry2 = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)waitResponseKey0);
                                if (entry2 != null) {
                                    Object resultH = ((ResponseHandler)entry2.getValue()).handler(dataMap);
                                    if (resultH == null) {
                                        WaitResponseKey waitResponseKey1 = new WaitResponseKey(-1, -1, "selectoperator_type_dldb_rec", cmd, this.equipment.getEquipmentNo());
                                        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)waitResponseKey1, (Object)waitResponseKey0, null, 30L, TimeUnit.SECONDS);
                                        return;
                                    }
                                    waitResponseKey = waitResponseKey0;
                                } else {
                                    waitResponseKey = waitResponseKey0;
                                }
                            } else {
                                waitResponseKey = waitResponseKey0;
                            }
                        } else {
                            WaitResponseKey waitResponseKey1 = new WaitResponseKey(-1, -1, "selectoperator_type_dldb_rec", cmd, this.equipment.getEquipmentNo());
                            Integer continue_recv = ZSCameraAction.getInteger(dataMap, "continue_recv");
                            if (continue_recv != null && continue_recv == 1) {
                                WaitResponseKey waitResponseKey0 = (WaitResponseKey)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)waitResponseKey1);
                                if (waitResponseKey0 != null) {
                                    KeyValueEntry entry3 = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)waitResponseKey0);
                                    if (entry3 != null) {
                                        ((ResponseHandler)entry3.getValue()).handler(dataMap);
                                        return;
                                    }
                                    ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey1);
                                    return;
                                }
                                return;
                            }
                            WaitResponseKey waitResponseKey0 = (WaitResponseKey)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey1);
                            if (waitResponseKey0 == null) {
                                return;
                            }
                            waitResponseKey = waitResponseKey0;
                        }
                    } else {
                        Object id = dataMap.get("id");
                        String idstr = id != null ? id.toString() : null;
                        waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), idstr, cmd, this.equipment.getEquipmentNo());
                    }
                }
            }
        }
        if (waitResponseKey != null && dataMap != null && (entry = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey)) != null) {
            final HashMap<String, Object> responseMap = dataMap;
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            try {
                                Integer state_code = ZSCameraAction.getInteger(responseMap, "state_code");
                                if (state_code == null || state_code != SUCCESS_CODE) {
                                    String opName = ((ResponseHandler)entry.getValue()).opName;
                                    if (opName == null) {
                                        opName = "";
                                    }
                                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + ZSCameraAction.this.equipment.getName() + "[" + ZSCameraAction.this.equipment.getIp() + "] " + opName + "\u8fd4\u56de\u9519\u8bef\u72b6\u6001: " + responseMap));
                                }
                            }
                            catch (Exception state_code) {
                                Object result = ((ResponseHandler)entry.getValue()).handler(responseMap);
                                ((OperationFutureHandler)entry.getKey()).setResult(result);
                            }
                        }
                        finally {
                            Object result = ((ResponseHandler)entry.getValue()).handler(responseMap);
                            ((OperationFutureHandler)entry.getKey()).setResult(result);
                        }
                    }
                    catch (Exception ex) {
                        ((OperationFutureHandler)entry.getKey()).setException((Throwable)ex);
                    }
                }
            });
        }
    }

    public static boolean containsBytes(byte[] source, int sourceOffset, int sourceCount, byte[][] bytes) {
        if (source == null || bytes == null || bytes.length == 0) {
            return false;
        }
        byte[][] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] ab = byArray[n2];
            int r = ZSCameraAction.bytesIndexOf(source, sourceOffset, sourceCount, ab, 0, ab.length, 0);
            if (r == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int bytesIndexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source[j] == target[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    private void handleRs485Data(Map<?, ?> dataMap) throws Exception {
        RS485ThreadHandler rs485ThreadHandler;
        String dataStr;
        int uatIndex = ZSCameraAction.getInteger(dataMap, "comm");
        IoSession session = this.iosession;
        if (session == null) {
            return;
        }
        SerialReadQueue queue = (SerialReadQueue)session.getAttribute((Object)(SESSION_SerialReadQueue + uatIndex));
        if (queue == null) {
            return;
        }
        int datalen = ZSCameraAction.getInteger(dataMap, "datalen");
        byte[] data = null;
        if (datalen > 0 && (dataStr = (String)dataMap.get("data")) != null && dataStr.length() > 0) {
            try {
                data = Base64.getDecoder().decode(dataStr);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "] \u8fd4\u56de\u4e32\u53e3\u6570\u636e\u4e0d\u662fbase64\u6570\u636e: " + dataStr));
                return;
            }
        }
        if (data != null && datalen > 0 && uatIndex >= 0 && uatIndex < this.rs485ThreadHandlers.length && (rs485ThreadHandler = this.rs485ThreadHandlers[uatIndex]) != null && rs485ThreadHandler.isStarted()) {
            int dataOffset = 0;
            if (datalen > data.length) {
                datalen = data.length;
            }
            Rs485DataPackage p485 = new Rs485DataPackage(rs485ThreadHandler, data, dataOffset, datalen);
            queue.push(p485);
        }
    }

    private void handleRegPlate(final ZSCameraTcpProtocol.ZSCameraPackage p, final RegPlateEntry regPlateEntry, final int pigIndex) {
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ZSCameraAction.this.handleRegPlate0(p, regPlateEntry, pigIndex);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u5904\u7406\u8f66\u724c\u8bc6\u522b\u5f02\u5e38: ", (Throwable)ex);
                }
            }
        });
    }

    public boolean isNeedRegPlate() {
        List<String> list = this.equipment.getChannelNos();
        boolean r = false;
        if (list != null) {
            for (String channelNo : list) {
                boolean bl = r = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) != null;
                if (r) break;
            }
        }
        return r;
    }

    private static boolean isPlate(String plate) {
        if (plate == null || plate.length() == 0) {
            return false;
        }
        if ("_\u65e0_".equals(plate) || "\u65e0\u724c\u8f66".equals(plate) || "\u65e0\u8f66\u724c".equals(plate)) {
            return true;
        }
        return plate.length() >= 6 || plate.length() < 11;
    }

    private void handleRegPlate0(ZSCameraTcpProtocol.ZSCameraPackage p, RegPlateEntry regPlateEntry, int pigIndex) throws Exception {
        Long a;
        block53: {
            int dataEnd;
            block50: {
                if (!this.isNeedRegPlate()) {
                    return;
                }
                if (this.equipment.getUse() != 1) {
                    return;
                }
                dataEnd = p.getDataLen() + p.getDataOffset();
                if (dataEnd > pigIndex && p.getData()[pigIndex] == 0) {
                    ++pigIndex;
                }
                if (regPlateEntry.getImageformat() == null || regPlateEntry.getImageformat().length() == 0) {
                    regPlateEntry.setImageformat("jpg");
                }
                try {
                    String plateNumber = regPlateEntry.getPlateResult().getLicense();
                    if (plateNumber.length() <= 15) break block50;
                    byte[] bs = Base64.getDecoder().decode(plateNumber.getBytes());
                    boolean dcryptSuccess = false;
                    if (ServiceUtil.getServiceContext().getAuthInfo().isO() && ServiceUtil.getServiceContext().getAuthInfo().getK() != null) {
                        try {
                            String plate = ZSCameraAction.decrypt(bs, ServiceUtil.getServiceContext().getAuthInfo().getK(), "GBK").trim();
                            if (plate != null && plate.length() > 0 && ZSCameraAction.isPlate(plate)) {
                                regPlateEntry.getPlateResult().setLicense(plate);
                                dcryptSuccess = true;
                            }
                        }
                        catch (Exception plate) {
                            // empty catch block
                        }
                    }
                    boolean throwEncryptPlateMsg = true;
                    if (!dcryptSuccess) {
                        ZSConnector connector = this.zsConnector;
                        if (connector != null && connector.isConnected()) {
                            int i = 0;
                            while (i < 2) {
                                block52: {
                                    try {
                                        KeyValueEntry<String, Map<String, String>> kv = connector.getIvsResult(4000, 5000);
                                        if (kv.getValue() != null) {
                                            Map vm = (Map)kv.getValue();
                                            String plate = (String)vm.get("license");
                                            String uId = (String)vm.get("uId");
                                            if (plate != null && plate.length() > 0 && uId != null && uId.length() > 0 && regPlateEntry.id != null && uId.equals(regPlateEntry.id.toString()) && ZSCameraAction.isPlate(plate)) {
                                                regPlateEntry.getPlateResult().setLicense(plate);
                                                dcryptSuccess = true;
                                                break;
                                            }
                                            if (i == 0) {
                                                ServiceLog.getLog().info((Object)("reg uId:" + regPlateEntry.id + "  IvsResult: " + vm));
                                            }
                                            throwEncryptPlateMsg = false;
                                            break block52;
                                        }
                                        ServiceLog.getLog().info((Object)("IvsResult Error: " + (String)kv.getKey()));
                                    }
                                    catch (Exception kv) {
                                        // empty catch block
                                    }
                                }
                                Thread.sleep(500L);
                                ++i;
                            }
                        } else {
                            ServiceLog.getLog().info((Object)"IvsResult Error: unconnected");
                        }
                    }
                    if (!dcryptSuccess) {
                        ServiceLog.getLog().error((Object)("\u76f8\u673a:" + this.getEquipment().getIp() + ", \u8f66\u724c\u5df2\u52a0\u5bc6\uff01\u65e0\u6cd5\u89e3\u5bc6\u8f66\u724c! " + plateNumber));
                        if (throwEncryptPlateMsg) {
                            String msg = "\u8f66\u724c\u8bc6\u522b\u76f8\u673a\uff1a" + this.getEquipment().getIp() + ", \u6210\u529f\u8bc6\u522b\u8f66\u724c\uff0c\u4f46\u662f\u8f66\u724c\u5df2\u88ab\u52a0\u5bc6\uff01\u672a\u80fd\u6210\u529f\u89e3\u6790\uff01\u8fd9\u5c06\u4e22\u5f03\u8bc6\u522b\u8f66\u724c! \u52a0\u5bc6\u8f66\u724c\uff1a" + plateNumber;
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this.getEquipment(), msg, 4, 15000));
                        }
                        return;
                    }
                }
                catch (Exception plateNumber) {
                    // empty catch block
                }
            }
            if (regPlateEntry.getPlateResult().getLicense().indexOf(26080) != -1) {
                regPlateEntry.getPlateResult().setLicense("\u65e0\u724c\u8f66");
            }
            long xatime = System.currentTimeMillis();
            Random r = new Random();
            int ranx = Math.abs(r.nextInt());
            try {
                FileOutputStream out;
                File saveF;
                StringBuilder fileNameBtr;
                byte[] b1;
                try {
                    b1 = regPlateEntry.getPlateResult().getLicense().getBytes("GB2312");
                }
                catch (Exception ex) {
                    b1 = regPlateEntry.getPlateResult().getLicense().getBytes();
                }
                String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                if (regPlateEntry.getFullImgSize() == null || regPlateEntry.getFullImgSize() <= 0) break block53;
                int begin = pigIndex;
                if (dataEnd >= (pigIndex += regPlateEntry.getFullImgSize().intValue())) {
                    fileNameBtr = new StringBuilder(128).append("plate_").append(plateHex).append('_').append(xatime).append('_').append(ranx);
                    if (!regPlateEntry.getImageformat().startsWith(".")) {
                        fileNameBtr.append('.');
                    }
                    fileNameBtr.append(regPlateEntry.getImageformat());
                    try {
                        saveF = new File(this.getPlateSaveDir(), fileNameBtr.toString());
                        out = new FileOutputStream(saveF);
                        try {
                            out.write(p.getData(), begin, regPlateEntry.getFullImgSize());
                        }
                        finally {
                            out.close();
                        }
                        regPlateEntry.setLocoalBigPicPath(saveF.getAbsolutePath());
                    }
                    catch (IOException e) {
                        ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u5168\u666f\u56fe\u5931\u8d25!", (Throwable)e);
                    }
                }
                if (regPlateEntry.getClipImgSize() == null || regPlateEntry.getClipImgSize() <= 0) break block53;
                begin = pigIndex;
                if (dataEnd < (pigIndex += regPlateEntry.getClipImgSize().intValue())) break block53;
                fileNameBtr = new StringBuilder(128).append("plateSmall_").append(plateHex).append('_').append(xatime).append('_').append(ranx);
                if (!regPlateEntry.getImageformat().startsWith(".")) {
                    fileNameBtr.append('.');
                }
                fileNameBtr.append(regPlateEntry.getImageformat());
                try {
                    saveF = new File(this.getPlateSaveDir(), fileNameBtr.toString());
                    out = new FileOutputStream(saveF);
                    try {
                        out.write(p.getData(), begin, regPlateEntry.getClipImgSize());
                    }
                    finally {
                        out.close();
                    }
                    regPlateEntry.setLocoalSmallPicPath(saveF.getAbsolutePath());
                }
                catch (IOException e) {
                    ServiceLog.getLog().error((Object)"\u4fdd\u5b58\u8f66\u724c\u7279\u5199\u56fe\u5931\u8d25!", (Throwable)e);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u5904\u7406\u8f66\u724c\u8bc6\u522b\u56fe\u7247\u5f02\u5e38: ", (Throwable)ex);
            }
        }
        String plateNumber = regPlateEntry.getPlateResult().getLicense();
        String plateColor = ZSCameraAction.getPlateColor(regPlateEntry.getPlateResult().getColorType());
        String vehicleColor = ZSCameraAction.getCarColor(regPlateEntry.getPlateResult().getCarColor());
        String savePath = regPlateEntry.getLocoalBigPicPath();
        String smallSavePath = regPlateEntry.getLocoalSmallPicPath();
        CameraEvent event = new CameraEvent(this.equipment, plateNumber, plateColor, savePath);
        event.setPlateSmallPath(smallSavePath);
        event.setVehicleColor(vehicleColor);
        event.setPlateJudge(regPlateEntry.getPlateResult().getFake_plate());
        if (regPlateEntry.getPlateResult().getFake_plate() != null) {
            if (regPlateEntry.getPlateResult().getFake_plate() == 1) {
                event.setPlateJudgeDes("\u5047\u8f66\u724c");
            } else {
                event.setPlateJudgeDes("\u771f\u8f66\u724c");
            }
        }
        if (regPlateEntry.getPlateResult() != null && regPlateEntry.getPlateResult().getTimeStamp() != null && regPlateEntry.getPlateResult().getTimeStamp().getTimeval() != null && (a = regPlateEntry.getPlateResult().getTimeStamp().getTimeval().getSec()) != null) {
            event.setCameraRegPlateMills(a * 1000L);
        }
        if (regPlateEntry.getPlateResult().getConfidence() != null) {
            event.setPlateConfidence(Float.valueOf(regPlateEntry.getPlateResult().getConfidence().floatValue()));
        }
        if (regPlateEntry.getPlateResult().getType() != null && regPlateEntry.getPlateResult().getType() > 0 && regPlateEntry.getPlateResult().getType() < plateTypeString.length) {
            event.setPlateType(regPlateEntry.getPlateResult().getType());
            event.setPlateTypeDes(plateTypeString[regPlateEntry.getPlateResult().getType()]);
        }
        if (regPlateEntry.getPlateResult().getDirection() != null && regPlateEntry.getPlateResult().getDirection() > 0 && regPlateEntry.getPlateResult().getDirection() < DIRECTIONString.length) {
            event.setDir(regPlateEntry.getPlateResult().getDirection());
            event.setDirDes(DIRECTIONString[regPlateEntry.getPlateResult().getDirection()]);
        }
        if (regPlateEntry.getPlateResult().getCar_brand() != null) {
            String carTypeDes;
            String brand;
            if (regPlateEntry.getPlateResult().getCar_brand().getBrand() != null && (brand = ZSCameraAction.getBrand(regPlateEntry.getPlateResult().getCar_brand().getBrand())) != null && brand.length() > 0) {
                String year;
                if (regPlateEntry.getPlateResult().getCar_brand().getYear() != null && (year = regPlateEntry.getPlateResult().getCar_brand().getYear().toString()).length() == 4) {
                    brand = String.valueOf(brand) + year;
                }
                event.setCarLogo(brand);
            }
            if (regPlateEntry.getPlateResult().getType() != null && (carTypeDes = ZSCameraAction.getCarType(regPlateEntry.getPlateResult().getType())) != null && carTypeDes.length() > 0) {
                event.setCarType(regPlateEntry.getPlateResult().getType());
                event.setCarTypeDes(carTypeDes);
            }
        }
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
    }

    public static String decrypt(byte[] data, String pwd, String charset) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, new SecretKeySpec(ZSCameraAction.getKeyBytes(pwd), "AES"));
        byte[] result = cipher.doFinal(data);
        int len = 0;
        int i = 0;
        while (i < result.length) {
            if (result[i] == 0) break;
            ++len;
            ++i;
        }
        if (len > 0) {
            return new String(result, 0, len, charset);
        }
        return "";
    }

    private static byte[] getKeyBytes(String pwd) throws UnsupportedEncodingException {
        byte[] datab = pwd.getBytes("UTF-8");
        if (datab.length > 16) {
            byte[] ret = new byte[16];
            System.arraycopy(datab, 0, ret, 0, 16);
            return ret;
        }
        if (datab.length == 16) {
            return datab;
        }
        byte[] ret = new byte[16];
        System.arraycopy(datab, 0, ret, 0, datab.length);
        return ret;
    }

    public File getPlateSaveDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        File dateDir = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
        File eqFile = new File(dateDir, this.equipment.getEquipmentNo());
        if (!eqFile.exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    @Override
    public boolean isSupportBarrierStateDetected() {
        Integer ioOp = this.getEquipment().getEquipmentConfig().getConfigIntValue("inputIO2");
        return ioOp != null && (ioOp == 1 || ioOp == 2);
    }

    private static class OPResponseHandler
    extends ResponseHandler<Integer> {
        private OPResponseHandler() {
        }

        @Override
        public Integer handler(Map<?, ?> responseMap) throws Exception {
            return this.getOpCode(responseMap);
        }

        /* synthetic */ OPResponseHandler(OPResponseHandler oPResponseHandler, OPResponseHandler oPResponseHandler2) {
            this();
        }
    }

    public static class RegPlateEntry {
        private PlateResulT PlateResult;
        private Long active_id;
        private Integer clipImgSize;
        private String cmd;
        private Integer fullImgSize;
        private Long id;
        private String imageformat;
        private String timeString;
        private String locoalBigPicPath;
        private String locoalSmallPicPath;

        public PlateResulT getPlateResult() {
            return this.PlateResult;
        }

        public void setPlateResult(PlateResulT plateResult) {
            this.PlateResult = plateResult;
        }

        public Long getActive_id() {
            return this.active_id;
        }

        public void setActive_id(Long active_id) {
            this.active_id = active_id;
        }

        public Integer getClipImgSize() {
            return this.clipImgSize;
        }

        public void setClipImgSize(Integer clipImgSize) {
            this.clipImgSize = clipImgSize;
        }

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public Integer getFullImgSize() {
            return this.fullImgSize;
        }

        public void setFullImgSize(Integer fullImgSize) {
            this.fullImgSize = fullImgSize;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getImageformat() {
            return this.imageformat;
        }

        public void setImageformat(String imageformat) {
            this.imageformat = imageformat;
        }

        public String getTimeString() {
            return this.timeString;
        }

        public void setTimeString(String timeString) {
            this.timeString = timeString;
        }

        public String getLocoalBigPicPath() {
            return this.locoalBigPicPath;
        }

        public void setLocoalBigPicPath(String locoalBigPicPath) {
            this.locoalBigPicPath = locoalBigPicPath;
        }

        public String getLocoalSmallPicPath() {
            return this.locoalSmallPicPath;
        }

        public void setLocoalSmallPicPath(String locoalSmallPicPath) {
            this.locoalSmallPicPath = locoalSmallPicPath;
        }

        public static class Car_brand {
            private Integer brand;
            private Integer type;
            private Integer year;

            public Integer getBrand() {
                return this.brand;
            }

            public void setBrand(Integer brand) {
                this.brand = brand;
            }

            public Integer getType() {
                return this.type;
            }

            public void setType(Integer type) {
                this.type = type;
            }

            public Integer getYear() {
                return this.year;
            }

            public void setYear(Integer year) {
                this.year = year;
            }
        }

        public static class Location {
            private Rect RECT;

            public Rect getRECT() {
                return this.RECT;
            }

            public void setRECT(Rect rECT) {
                this.RECT = rECT;
            }
        }

        public static class PlateResulT {
            private Integer bright;
            private Integer carBright;
            private Integer carColor;
            private Car_brand car_brand;
            private Location car_location;
            private Integer colorType;
            private Integer colorValue;
            private Integer confidence;
            private Integer direction;
            private Integer enable_encrypt;
            private Integer fake_plate;
            private String license;
            private Location location;
            private Integer plate_distance;
            private Integer plate_true_width;
            private TimeStamp timeStamp;
            private Integer timeUsed;
            private Integer triggerType;
            private Integer type;

            public Integer getBright() {
                return this.bright;
            }

            public void setBright(Integer bright) {
                this.bright = bright;
            }

            public Integer getCarBright() {
                return this.carBright;
            }

            public void setCarBright(Integer carBright) {
                this.carBright = carBright;
            }

            public Integer getCarColor() {
                return this.carColor;
            }

            public void setCarColor(Integer carColor) {
                this.carColor = carColor;
            }

            public Car_brand getCar_brand() {
                return this.car_brand;
            }

            public void setCar_brand(Car_brand car_brand) {
                this.car_brand = car_brand;
            }

            public Location getCar_location() {
                return this.car_location;
            }

            public void setCar_location(Location car_location) {
                this.car_location = car_location;
            }

            public Integer getColorType() {
                return this.colorType;
            }

            public void setColorType(Integer colorType) {
                this.colorType = colorType;
            }

            public Integer getColorValue() {
                return this.colorValue;
            }

            public void setColorValue(Integer colorValue) {
                this.colorValue = colorValue;
            }

            public Integer getConfidence() {
                return this.confidence;
            }

            public void setConfidence(Integer confidence) {
                this.confidence = confidence;
            }

            public Integer getDirection() {
                return this.direction;
            }

            public void setDirection(Integer direction) {
                this.direction = direction;
            }

            public Integer getEnable_encrypt() {
                return this.enable_encrypt;
            }

            public void setEnable_encrypt(Integer enable_encrypt) {
                this.enable_encrypt = enable_encrypt;
            }

            public Integer getFake_plate() {
                return this.fake_plate;
            }

            public void setFake_plate(Integer fake_plate) {
                this.fake_plate = fake_plate;
            }

            public String getLicense() {
                return this.license;
            }

            public void setLicense(String license) {
                this.license = license;
            }

            public Location getLocation() {
                return this.location;
            }

            public void setLocation(Location location) {
                this.location = location;
            }

            public Integer getPlate_distance() {
                return this.plate_distance;
            }

            public void setPlate_distance(Integer plate_distance) {
                this.plate_distance = plate_distance;
            }

            public Integer getPlate_true_width() {
                return this.plate_true_width;
            }

            public void setPlate_true_width(Integer plate_true_width) {
                this.plate_true_width = plate_true_width;
            }

            public TimeStamp getTimeStamp() {
                return this.timeStamp;
            }

            public void setTimeStamp(TimeStamp timeStamp) {
                this.timeStamp = timeStamp;
            }

            public Integer getTimeUsed() {
                return this.timeUsed;
            }

            public void setTimeUsed(Integer timeUsed) {
                this.timeUsed = timeUsed;
            }

            public Integer getTriggerType() {
                return this.triggerType;
            }

            public void setTriggerType(Integer triggerType) {
                this.triggerType = triggerType;
            }

            public Integer getType() {
                return this.type;
            }

            public void setType(Integer type) {
                this.type = type;
            }
        }

        public static class Rect {
            private Integer bottom;
            private Integer left;
            private Integer right;
            private Integer top;

            public Integer getBottom() {
                return this.bottom;
            }

            public void setBottom(Integer bottom) {
                this.bottom = bottom;
            }

            public Integer getLeft() {
                return this.left;
            }

            public void setLeft(Integer left) {
                this.left = left;
            }

            public Integer getRight() {
                return this.right;
            }

            public void setRight(Integer right) {
                this.right = right;
            }

            public Integer getTop() {
                return this.top;
            }

            public void setTop(Integer top) {
                this.top = top;
            }
        }

        public static class TimeStamp {
            private TimeVal Timeval;

            public TimeVal getTimeval() {
                return this.Timeval;
            }

            public void setTimeval(TimeVal timeval) {
                this.Timeval = timeval;
            }
        }

        public static class TimeVal {
            private Long sec;
            private Integer usec;

            public Long getSec() {
                return this.sec;
            }

            public void setSec(Long sec) {
                this.sec = sec;
            }

            public Integer getUsec() {
                return this.usec;
            }

            public void setUsec(Integer usec) {
                this.usec = usec;
            }
        }
    }

    private static class ResponseHandler<R>
    implements TimeoutObjectPool.TimeoutCallback {
        public String opName;

        private ResponseHandler() {
        }

        public R handler(Map<?, ?> responseMap) throws Exception {
            return (R)responseMap;
        }

        protected int getOpCode(Map<?, ?> responseMap) {
            if (responseMap == null) {
                return -1;
            }
            Integer state_code = ZSCameraAction.getInteger(responseMap, "state_code");
            if (state_code == null) {
                return -1;
            }
            if (state_code == SUCCESS_CODE) {
                return 0;
            }
            if (state_code == 0) {
                return -2;
            }
            return state_code;
        }

        public void onTimeout(Object key, Object value) throws Exception {
            if (value != null && value instanceof KeyValueEntry) {
                KeyValueEntry entry = (KeyValueEntry)value;
                ((OperationFutureHandler)entry.getKey()).setException((Throwable)new TimeoutException("\u7b49\u5f85\u76f8\u673a\u54cd\u5e94\u8d85\u65f6!"));
            }
        }
    }

    private static class Rs485DataPackage {
        private byte[] data;
        private int offset;
        private int dataLen;
        private RS485ThreadHandler handler;

        public Rs485DataPackage(RS485ThreadHandler handler, byte[] data, int offset, int dataLen) {
            this.handler = handler;
            this.data = data;
            this.offset = offset;
            this.dataLen = dataLen;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getDataLen() {
            return this.dataLen;
        }

        public RS485ThreadHandler getHandler() {
            return this.handler;
        }
    }

    private static class SerialConfig {
        private int baud_rate;
        private int data_bits;
        private int parity;
        private int stop_bits;
        private int serial_port;

        private SerialConfig() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.baud_rate;
            result = 31 * result + this.data_bits;
            result = 31 * result + this.parity;
            result = 31 * result + this.serial_port;
            result = 31 * result + this.stop_bits;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerialConfig other = (SerialConfig)obj;
            if (this.baud_rate != other.baud_rate) {
                return false;
            }
            if (this.data_bits != other.data_bits) {
                return false;
            }
            if (this.parity != other.parity) {
                return false;
            }
            if (this.serial_port != other.serial_port) {
                return false;
            }
            return this.stop_bits == other.stop_bits;
        }
    }

    private static class SerialReadQueue
    implements Runnable {
        private ConcurrentLinkedQueue<Rs485DataPackage> queue = new ConcurrentLinkedQueue();
        private volatile boolean running = false;

        private SerialReadQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(Rs485DataPackage p) {
            if (p == null || p.getData() == null || p.getDataLen() == 0 || p.getHandler() == null) {
                return;
            }
            SerialReadQueue serialReadQueue = this;
            synchronized (serialReadQueue) {
                this.queue.offer(p);
                if (!this.running && this.queue.peek() != null) {
                    try {
                        ServiceUtil.getServiceContext().getWorkThreadPool().submit(this);
                    }
                    catch (Exception ex) {
                        this.queue.clear();
                        this.running = false;
                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Rs485DataPackage p;
                if ((p = this.queue.poll()) != null) {
                    try {
                        p.getHandler().handleRecevie(p.getData(), p.getOffset(), p.getDataLen());
                    }
                    catch (Throwable ex) {
                        ServiceLog.getLog().warn((Object)"", ex);
                    }
                    continue;
                }
                SerialReadQueue serialReadQueue = this;
                synchronized (serialReadQueue) {
                    if (this.queue.peek() == null) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
    }

    private static class WaitResponseKey {
        private byte seq;
        private byte dataType;
        private String id;
        private String cmd;
        private String eqNo;

        public WaitResponseKey(byte seq, byte dataType, String id, String cmd, String eqNo) {
            this.seq = seq;
            this.dataType = dataType;
            this.id = id;
            this.cmd = cmd;
            this.eqNo = eqNo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + this.dataType;
            result = 31 * result + (this.eqNo == null ? 0 : this.eqNo.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + this.seq;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitResponseKey other = (WaitResponseKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.dataType != other.dataType) {
                return false;
            }
            if (this.eqNo == null ? other.eqNo != null : !this.eqNo.equals(other.eqNo)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return this.seq == other.seq;
        }
    }
}

