/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.proxy.utils.ByteUtilities;

public class ZSCameraTcpProtocol {
    private static final int WAIT_V = 0;
    private static final int WAIT_Z = 1;
    private static final int WAIT_DATA_TYPE = 2;
    private static final int WAIT_P_SEQ = 3;
    private static final int WAIT_DATA_LEN = 4;
    private static final int WAIT_DATA = 5;
    public static final byte V_VALUE = 86;
    public static final byte Z_VALUE = 90;
    private static final int maxDataLen = 0x500000;
    private volatile int state = 0;
    private String logName;
    private byte dataType;
    private byte seq;
    private byte[] dataLenBytes = new byte[4];
    private int dataLenIndex = 0;
    private byte[] data;
    private int dataIndex = 0;

    public ZSCameraTcpProtocol(String logName) {
        if (logName == null) {
            logName = "";
        }
        this.logName = logName;
    }

    public synchronized void clear() {
        this.state = 0;
        this.dataType = 0;
        this.dataLenIndex = 0;
        this.dataIndex = 0;
        this.data = null;
    }

    public synchronized void parse(IoBuffer buf, ZSCameraPackageHandler handler) {
        if (buf == null) {
            return;
        }
        boolean logged = false;
        while (buf.hasRemaining()) {
            byte b = buf.get();
            if (this.state == 0) {
                if (b != 86) {
                    this.state = 0;
                    if (logged) continue;
                    logged = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u89e3\u6790\u9519\u8bef\uff01\u51fa\u73b0\u6570\u636e\u4e22\u5931\uff01\u671f\u5f85:" + 86 + ",\u4f46\u662f\u4e3a:" + b));
                    continue;
                }
                this.state = 1;
                continue;
            }
            if (this.state == 1) {
                if (b != 90) {
                    if (logged) continue;
                    logged = true;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u89e3\u6790\u9519\u8bef\uff01\u51fa\u73b0\u6570\u636e\u4e22\u5931\uff01\u671f\u5f85:" + 90 + ",\u4f46\u662f\u4e3a:" + b));
                    continue;
                }
                this.state = 2;
                continue;
            }
            if (this.state == 2) {
                this.dataType = b;
                this.state = 3;
                continue;
            }
            if (this.state == 3) {
                this.seq = b;
                this.dataLenIndex = 0;
                this.state = 4;
                continue;
            }
            if (this.state == 4) {
                this.dataLenBytes[this.dataLenIndex++] = b;
                if (this.dataLenIndex != this.dataLenBytes.length) continue;
                int dataLen = ByteUtilities.networkByteOrderToInt((byte[])this.dataLenBytes, (int)0, (int)this.dataLenBytes.length);
                if (dataLen == 0) {
                    try {
                        if (this.dataType != 1) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u89e3\u6790\u9519\u8bef\uff01\u975e\u5fc3\u8df3\u5305,\u6570\u636e\u957f\u5ea6\u4e3a0"));
                            continue;
                        }
                        if (handler == null) continue;
                        try {
                            ZSCameraPackage p = new ZSCameraPackage();
                            p.dataOffset = 0;
                            p.dataLen = dataLen;
                            p.data = null;
                            p.dataType = this.dataType;
                            p.seq = this.seq;
                            handler.handlerPackage(p);
                        }
                        catch (Exception e) {
                            ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u6570\u636e\u5f02\u5e38: " + e.getMessage()), (Throwable)e);
                        }
                        continue;
                    }
                    finally {
                        this.clear();
                    }
                }
                if (dataLen > 0x500000) {
                    try {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ": \u6570\u636e\u957f\u5ea6\u9519\u8bef\uff01\u6570\u636e\u957f\u5ea6\u8fc7\u5927,\u957f\u5ea6: " + dataLen));
                        continue;
                    }
                    finally {
                        this.clear();
                    }
                }
                this.dataIndex = 0;
                this.data = new byte[dataLen];
                this.state = 5;
                continue;
            }
            if (this.state == 5) {
                this.data[this.dataIndex++] = b;
                if (this.dataIndex != this.data.length) continue;
                try {
                    try {
                        if (handler != null) {
                            ZSCameraPackage p = new ZSCameraPackage();
                            p.dataOffset = 0;
                            p.dataLen = this.data.length;
                            p.data = this.data;
                            p.dataType = this.dataType;
                            p.seq = this.seq;
                            handler.handlerPackage(p);
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.logName) + ":\u5904\u7406\u5e94\u7528\u6570\u636e\u5f02\u5e38: " + ex.getMessage()), (Throwable)ex);
                        this.clear();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.clear();
                    throw throwable;
                }
                this.clear();
                continue;
            }
            this.clear();
        }
    }

    public static ZSCameraPackage toSendPackage(Object jsonObj, byte seq) {
        return ZSCameraTcpProtocol.toSendPackage(jsonObj, seq, "GB2312");
    }

    public static ZSCameraPackage toSendPackage(Object jsonObj, byte seq, String charset) {
        byte[] data;
        if (jsonObj == null) {
            data = null;
        } else {
            String jsn = ServiceUtil.getHtmlEscapingGson().toJson(jsonObj);
            try {
                data = jsn.getBytes(charset);
            }
            catch (Exception ex) {
                data = jsn.getBytes();
            }
        }
        ZSCameraPackage page = new ZSCameraPackage();
        page.data = data;
        page.dataOffset = 0;
        if (data == null) {
            page.dataType = (byte)1;
            page.dataLen = 0;
        } else {
            page.dataType = (byte)0;
            page.dataLen = data.length;
        }
        page.seq = seq;
        return page;
    }

    public static IoBuffer toSendBuf(ZSCameraPackage page) {
        int len = 8 + page.getDataLen();
        IoBuffer buf = IoBuffer.allocate((int)len);
        buf.put((byte)86);
        buf.put((byte)90);
        buf.put(page.getDataType());
        buf.put(page.getSeq());
        byte[] xe = ByteUtilities.intToNetworkByteOrder((int)page.getDataLen(), (int)4);
        buf.put(xe);
        if (page.getData() != null && page.getDataLen() > 0) {
            buf.put(page.getData(), page.getDataOffset(), page.getDataLen());
        }
        buf.flip();
        return buf;
    }

    public static class ZSCameraPackage {
        private int dataOffset;
        private int dataLen;
        private byte[] data;
        private byte seq;
        private byte dataType;

        public int getDataOffset() {
            return this.dataOffset;
        }

        public void setDataOffset(int dataOffset) {
            this.dataOffset = dataOffset;
        }

        public int getDataLen() {
            return this.dataLen;
        }

        public void setDataLen(int dataLen) {
            this.dataLen = dataLen;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public byte getSeq() {
            return this.seq;
        }

        public void setSeq(byte seq) {
            this.seq = seq;
        }

        public byte getDataType() {
            return this.dataType;
        }

        public void setDataType(byte dataType) {
            this.dataType = dataType;
        }

        public boolean isHeartBeat() {
            return this.dataType == 1;
        }
    }

    public static interface ZSCameraPackageHandler {
        public void handlerPackage(ZSCameraPackage var1) throws Exception;
    }
}

