/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.driver.ZSLoginAES;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpResponseLineStringCallback;
import com.wovoe.framework.http.HttpUtil;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ZSConnector
extends JobTask {
    public static final String NO_PLATE = "_\u65e0_";
    private volatile String connectIp;
    private String cookie;
    private volatile ScheduledFuture<?> sh;
    private volatile String userName;
    private volatile String pwd;

    public boolean isConnected() {
        String c = this.cookie;
        String v = this.connectIp;
        return c != null && c.length() > 0 && v != null && v.length() > 0 && this.sh != null;
    }

    public synchronized void setIp(String ip, String userName, String pwd) {
        if (ip == null || ip.length() == 0) {
            this.cookie = null;
            this.connectIp = ip;
        } else if (!ip.equals(this.connectIp)) {
            this.cookie = null;
            this.connectIp = ip;
        }
        if (userName == null || userName.length() == 0) {
            userName = "admin";
        }
        if (pwd == null || pwd.length() == 0) {
            pwd = "admin";
        }
        this.userName = userName;
        this.pwd = pwd;
    }

    public synchronized void stop() {
        if (this.sh != null) {
            try {
                this.cookie = null;
                this.sh.cancel(true);
            }
            finally {
                this.sh = null;
            }
        }
    }

    public synchronized void start() {
        if (this.sh == null) {
            this.sh = ServiceUtil.getServiceContext().schedule(this, 10L, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    public static Map<String, String> createHeadMap() {
        LinkedHashMap<String, String> requestHeader = new LinkedHashMap<String, String>();
        requestHeader.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3");
        requestHeader.put("Accept-Encoding", "gzip, deflate");
        requestHeader.put("Accept-Language", "zh-CN,zh;q=0.9");
        requestHeader.put("Cache-Control", "max-age=0");
        requestHeader.put("Connection", "keep-alive");
        requestHeader.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36");
        return requestHeader;
    }

    public static String getJsVersion(String ip, int port, int connectTimout, int readTimeout) throws Exception {
        String url = "http://" + ip;
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        url = String.valueOf(url) + "/js/launch.js?version=" + System.currentTimeMillis();
        String verion = (String)HttpUtil.doRequest((String)url, ZSConnector.createHeadMap(), null, null, null, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
            String webVersion = null;
            boolean findV;

            public String onComplete() {
                return this.webVersion;
            }

            public void onException(Throwable ex) {
            }

            public boolean callback(String line) {
                if (line != null && (line = line.trim()).length() > 0) {
                    int end;
                    int h;
                    if (line.startsWith("var version") && line.endsWith("{")) {
                        this.findV = true;
                    }
                    if (this.findV && line.startsWith("web:") && line.endsWith("\",") && (h = line.indexOf(34)) != -1 && (end = line.length() - 2) > h + 1) {
                        this.webVersion = line.substring(h + 1, end);
                    }
                }
                return true;
            }

            public boolean onHeaders(HttpResponse response) {
                return true;
            }
        }, (int)connectTimout, (int)readTimeout);
        return verion;
    }

    public static String getPwd(String ip, int port, String jsversion, int connectTimout, int readTimeout) throws Exception {
        String url = "http://" + ip;
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        url = String.valueOf(url) + "/style/old/js/login.js?version=" + jsversion;
        String pwd = (String)HttpUtil.doRequest((String)url, ZSConnector.createHeadMap(), null, null, null, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
            String returnPwd = null;
            String passwd1 = "passwd =";
            String passwd0 = "passwd=";
            boolean findV;
            String on_submit = "function on_submit()";

            public String onComplete() {
                return this.returnPwd;
            }

            public void onException(Throwable ex) {
            }

            public boolean callback(String line) {
                if (line != null && (line = line.trim()).length() > 0) {
                    if (line.startsWith(this.on_submit) && line.endsWith("{")) {
                        this.findV = true;
                    } else if (this.findV && (this.returnPwd == null || this.returnPwd.length() == 0)) {
                        String a;
                        if (line.startsWith(this.passwd1) && line.endsWith(";")) {
                            String a2 = line.substring(this.passwd1.length(), line.length() - 1).trim();
                            if (a2.length() > 2 && a2.startsWith("\"") && a2.endsWith("\"")) {
                                this.returnPwd = a2.substring(1, a2.length() - 1);
                            }
                        } else if (line.startsWith(this.passwd0) && line.equals(";") && (a = line.substring(this.passwd0.length(), line.length() - 1).trim()).length() > 2 && a.startsWith("\"") && a.endsWith("\"")) {
                            this.returnPwd = a.substring(1, a.length() - 1);
                        }
                    }
                }
                return true;
            }

            public boolean onHeaders(HttpResponse response) {
                return true;
            }
        }, (int)connectTimout, (int)readTimeout);
        return pwd;
    }

    public static String getWebPwd(String ip, int port, int connectTimout, int readTimeout) {
        try {
            String pwd;
            String version = ZSConnector.getJsVersion(ip, port, connectTimout, readTimeout);
            if (version != null && version.length() > 0 && version.indexOf(46) != -1 && (pwd = ZSConnector.getPwd(ip, port, version, connectTimout, readTimeout)) != null && pwd.length() > 0) {
                return pwd;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    boolean doConnect(String ip) {
        block10: {
            String outtext;
            String passwd;
            if (ip == null || ip.length() == 0) {
                return false;
            }
            String loginUrl = "http://" + ip + "/login.php";
            String username = this.userName;
            String pwd = this.pwd;
            if (username == null || username.length() == 0 || pwd == null || pwd.length() == 0) {
                return false;
            }
            String postdata = String.valueOf(username) + ":" + pwd;
            try {
                passwd = ZSConnector.getWebPwd(ip, 80, 3000, 5000);
            }
            catch (Exception ex) {
                passwd = null;
            }
            if (passwd == null || passwd.length() == 0) {
                passwd = "\u5929\u5929";
            }
            try {
                outtext = ZSLoginAES.encrypt(postdata, passwd, 128);
            }
            catch (Exception e) {
                return false;
            }
            Map<String, String> requestHeader = ZSConnector.createHeadMap();
            try {
                final String[] cokiev = new String[1];
                String resultV = (String)HttpUtil.doRequest((String)loginUrl, requestHeader, null, null, null, (String)outtext, (HttpResponseCallback)new HttpResponseLineStringCallback<String>(){
                    StringBuilder sbr = new StringBuilder();

                    public String onComplete() {
                        return this.sbr.toString();
                    }

                    public void onException(Throwable ex) {
                    }

                    public boolean callback(String line) {
                        if (line != null && (line = line.trim()).length() > 0) {
                            this.sbr.append(line.trim());
                        }
                        return true;
                    }

                    public boolean onHeaders(HttpResponse response) {
                        if (response.getResponseCode() != 200) {
                            return false;
                        }
                        Map headMap = response.getHeaders();
                        if (headMap != null && !headMap.isEmpty()) {
                            String SetCookieKey = "Set-Cookie";
                            String SetCookieKey1 = "set-cookie";
                            for (Map.Entry head1 : headMap.entrySet()) {
                                if (!SetCookieKey.equals(head1.getKey()) && !SetCookieKey1.equals(head1.getKey()) || head1.getValue() == null || ((List)head1.getValue()).isEmpty()) continue;
                                StringBuilder bsr = new StringBuilder();
                                for (String s : (List)head1.getValue()) {
                                    if (s == null || s.indexOf(61) == -1) continue;
                                    if (bsr.length() > 0) {
                                        bsr.append("; ");
                                    }
                                    bsr.append(s.trim());
                                }
                                String v = bsr.toString();
                                if (v.length() <= 0 || v.indexOf("sessionID=") == -1) continue;
                                cokiev[0] = v;
                            }
                        }
                        return true;
                    }
                }, (int)5000, (int)6000, null);
                if (resultV != null && resultV.indexOf("OK") != -1 && cokiev[0] != null && cokiev[0].length() > 0) {
                    this.cookie = "remember=1; " + cokiev[0] + "; outtext=" + URLEncoder.encode(outtext, "UTF-8");
                    ServiceLog.getLog().info((Object)("\u5df2\u6210\u529f\u8fde\u63a5\u76f8\u673a: " + ip + ": " + this.cookie));
                    return true;
                }
            }
            catch (Exception ex) {
                if (ex instanceof SocketTimeoutException) break block10;
                ServiceLog.getLog().error((Object)("\u767b\u5f55\u76f8\u673a: " + ip + " \u5931\u8d25!" + ex));
            }
        }
        return false;
    }

    protected void doRun() throws Exception {
        if (this.sh == null) {
            return;
        }
        String ip = this.connectIp;
        if (ip == null || ip.length() == 0) {
            this.cookie = null;
            return;
        }
        String _cookie = this.cookie;
        if (_cookie == null || _cookie.length() == 0) {
            this.doConnect(ip);
        } else {
            Map<String, String> requestHeader = ZSConnector.createHeadMap();
            requestHeader.put("Cookie", _cookie);
            String url = "http://" + ip + "/vb.htm?getnetip";
            try {
                String result = (String)HttpUtil.doRequest((String)url, requestHeader, null, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)4000, (int)4500);
                if (result == null || result.length() == 0) {
                    ServiceLog.getLog().error((Object)("\u8bf7\u6c42\u76f8\u673a:" + url + "\u8fd4\u56de\u7a7a\u6570\u636e"));
                    this.cookie = null;
                } else if (result.indexOf("OK") == -1 || result.indexOf("getnetip") == -1) {
                    this.cookie = null;
                    this.doConnect(ip);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u8bf7\u6c42\u76f8\u673a:" + url + "\u5f02\u5e38\uff01" + ex));
                this.cookie = null;
            }
        }
    }

    public KeyValueEntry<String, String> getUserData() {
        String result;
        String _cookie = this.cookie;
        if (_cookie == null || _cookie.length() == 0) {
            return new KeyValueEntry((Object)"ERROR", (Object)"\u76f8\u673a\u672a\u8fde\u63a5");
        }
        String ip = this.connectIp;
        if (ip == null || ip.length() == 0) {
            return new KeyValueEntry((Object)"ERROR", (Object)"\u76f8\u673aIP\u672a\u8bbe\u7f6e");
        }
        Map<String, String> requestHeader = ZSConnector.createHeadMap();
        requestHeader.put("Cookie", _cookie);
        String url = "http://" + ip + "/vb.htm?paratest=userdefinedcfg";
        try {
            result = (String)HttpUtil.doRequest((String)url, requestHeader, null, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)5000, (int)5000);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u8bf7\u6c42\u76f8\u673a: " + url + ", \u7f51\u7edc\u5f02\u5e38! " + ex));
            return new KeyValueEntry((Object)"NET_ERROR", (Object)"\u7f51\u7edc\u5f02\u5e38");
        }
        if (result == null || result.length() == 0) {
            return new KeyValueEntry((Object)"ERROR", (Object)"\u76f8\u673a\u8fd4\u56de\u7a7a\u6570\u636e");
        }
        if (result.indexOf("OK") != -1) {
            String key = "userdefinedcfg=";
            int x = result.indexOf("userdefinedcfg=");
            if (x != -1) {
                String v = result.substring(key.length() + x).trim();
                return new KeyValueEntry((Object)"SUCCESS", (Object)v);
            }
        }
        ServiceLog.getLog().error((Object)("\u83b7\u53d6\u76f8\u673a\u7528\u6237\u5b9a\u4e49\u6570\u636e\u5f02\u5e38\uff01\u8fd4\u56de\uff1a" + result));
        return new KeyValueEntry((Object)"ERROR", (Object)"\u64cd\u4f5c\u5931\u8d25");
    }

    public KeyValueEntry<String, Map<String, String>> getIvsResult(int connectTimeout, int readTimeout) {
        Map bodyMap;
        Object PlateResultObj;
        Object bodyObj;
        Map resutMap;
        String result;
        String _cookie = this.cookie;
        if (_cookie == null || _cookie.length() == 0) {
            return new KeyValueEntry((Object)"\u76f8\u673a\u672a\u8fde\u63a5", null);
        }
        String ip = this.connectIp;
        if (ip == null || ip.length() == 0) {
            return new KeyValueEntry((Object)"\u76f8\u673aIP\u672a\u8bbe\u7f6e", null);
        }
        Map<String, String> requestHeader = ZSConnector.createHeadMap();
        requestHeader.put("Cookie", _cookie);
        String url = "http://" + ip + "/ivs_result.php";
        try {
            result = (String)HttpUtil.doRequest((String)(String.valueOf(url) + "?_=" + System.currentTimeMillis()), requestHeader, null, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)connectTimeout, (int)readTimeout);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u8bf7\u6c42\u76f8\u673a: " + url + ", \u7f51\u7edc\u5f02\u5e38! " + ex));
            return new KeyValueEntry((Object)"\u7f51\u7edc\u5f02\u5e38", null);
        }
        if (result == null || result.length() == 0) {
            return new KeyValueEntry((Object)"\u76f8\u673a\u8fd4\u56de\u7a7a\u6570\u636e", null);
        }
        try {
            resutMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(result, Map.class);
        }
        catch (Exception ex) {
            this.cookie = null;
            this.run();
            return new KeyValueEntry((Object)"\u76f8\u673a\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e", null);
        }
        if (!resutMap.isEmpty() && (bodyObj = resutMap.get("body")) != null && bodyObj instanceof Map && (PlateResultObj = (bodyMap = (Map)bodyObj).get("PlateResult")) != null && PlateResultObj instanceof Map) {
            Map PlateResultMap = (Map)PlateResultObj;
            String license = ZSConnector.getString(PlateResultMap, "license");
            String trigger_time = ZSConnector.getString(PlateResultMap, "trigger_time");
            Long uId = ZSConnector.getLong(PlateResultMap, "uId");
            Integer is_fake_plate = ZSConnector.getInt(PlateResultMap, "is_fake_plate");
            if (license != null && license.length() > 0 && trigger_time != null && trigger_time.length() > 0 && uId != null) {
                HashMap<String, String> plateMap = new HashMap<String, String>();
                plateMap.put("license", license);
                plateMap.put("trigger_time", trigger_time);
                plateMap.put("uId", uId.toString());
                if (is_fake_plate != null) {
                    plateMap.put("is_fake_plate", is_fake_plate.toString());
                }
                return new KeyValueEntry((Object)"SUCCESS", plateMap);
            }
        }
        return new KeyValueEntry((Object)"FAIL", null);
    }

    public static Integer getInt(Map<?, ?> map, String key) {
        if (map == null || key == null) {
            return null;
        }
        Object o = map.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        String v = o.toString();
        if (v.length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(v);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Long getLong(Map<?, ?> map, String key) {
        if (map == null || key == null) {
            return null;
        }
        Object o = map.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        String v = o.toString();
        if (v.length() == 0) {
            return null;
        }
        try {
            return Long.valueOf(v);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getString(Map<?, ?> map, String key) {
        if (map == null || key == null) {
            return null;
        }
        Object o = map.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }
}

