/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import java.util.Base64;

public class ZSLoginAES {
    private static final int FF = 255;
    private static byte[] Sbox;
    private static byte[][] Rcon;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        Sbox = byArray;
        byte[][] byArrayArray = new byte[11][];
        byArrayArray[0] = new byte[4];
        byte[] byArray2 = new byte[4];
        byArray2[0] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = 2;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[4];
        byArray4[0] = 4;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[4];
        byArray5[0] = 8;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[4];
        byArray6[0] = 16;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[4];
        byArray7[0] = 32;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[4];
        byArray8[0] = 64;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[4];
        byArray9[0] = -128;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[4];
        byArray10[0] = 27;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[4];
        byArray11[0] = 54;
        byArrayArray[10] = byArray11;
        Rcon = byArrayArray;
    }

    public static String encrypt(String plaintext0, String password0, int nBits) throws Exception {
        int nBytes;
        byte[] pwBytes;
        byte[] password;
        int blockSize = 16;
        if (nBits != 128 && nBits != 192 && nBits != 256) {
            return "";
        }
        byte[] plaintext = plaintext0.getBytes("UTF-8");
        System.arraycopy(password, 0, pwBytes, 0, (password = password0.getBytes("UTF-8")).length > (pwBytes = new byte[nBytes = nBits / 8]).length ? pwBytes.length : password.length);
        byte[][] kep = ZSLoginAES.keyExpansion(pwBytes);
        byte[] key = ZSLoginAES.cipher(pwBytes, kep);
        if (nBytes > 16) {
            byte[] akey = new byte[nBytes];
            System.arraycopy(key, 0, akey, 0, key.length);
            System.arraycopy(key, 0, akey, key.length, nBytes - 16);
        }
        byte[] counterBlock = new byte[blockSize];
        long nonce = System.currentTimeMillis();
        long nonceSec = nonce / 1000L;
        int nonceMs = (int)(nonce % 1000L);
        int i = 0;
        while (i < 4) {
            counterBlock[i] = (byte)(nonceSec >>> i * 8 & 0xFFL);
            ++i;
        }
        i = 0;
        while (i < 4) {
            counterBlock[i + 4] = (byte)(nonceMs & 0xFF);
            ++i;
        }
        int totalCount = 8;
        byte[] ctrTxt = new byte[8];
        System.arraycopy(counterBlock, 0, ctrTxt, 0, ctrTxt.length);
        byte[][] keySchedule = ZSLoginAES.keyExpansion(key);
        int blockCount = (int)Math.ceil((double)plaintext.length / (double)blockSize);
        byte[][] ciphertxt = new byte[blockCount][];
        int FF = 255;
        int b = 0;
        while (b < blockCount) {
            int c = 0;
            while (c < 4) {
                counterBlock[15 - c] = (byte)(b >>> c * 8 & FF);
                ++c;
            }
            c = 0;
            while (c < 4) {
                counterBlock[15 - c - 4] = (byte)((long)b / 0x100000000L >>> c * 8);
                ++c;
            }
            byte[] cipherCntr = ZSLoginAES.cipher(counterBlock, keySchedule);
            int blockLength = b < blockCount - 1 ? blockSize : (plaintext.length - 1) % blockSize + 1;
            byte[] cipherChar = new byte[blockLength];
            int i2 = 0;
            while (i2 < blockLength) {
                cipherChar[i2] = (byte)(cipherCntr[i2] & FF ^ plaintext[b * blockSize + i2] & FF);
                ++i2;
            }
            ciphertxt[b] = cipherChar;
            totalCount += cipherChar.length;
            ++b;
        }
        byte[] finalBytes = new byte[totalCount];
        int offset = 0;
        System.arraycopy(ctrTxt, 0, finalBytes, offset, ctrTxt.length);
        offset += ctrTxt.length;
        int i3 = 0;
        while (i3 < ciphertxt.length) {
            System.arraycopy(ciphertxt[i3], 0, finalBytes, offset, ciphertxt[i3].length);
            offset += ciphertxt[i3].length;
            ++i3;
        }
        String base64 = Base64.getEncoder().encodeToString(finalBytes);
        return base64;
    }

    private static byte[][] keyExpansion(byte[] key) {
        int Nb = 4;
        int Nk = key.length / 4;
        int Nr = Nk + 6;
        int totalLen = Nb * (Nr + 1);
        byte[][] w = new byte[totalLen][];
        byte[] temp = new byte[4];
        int i = 0;
        while (i < Nk) {
            byte[] r = new byte[]{key[4 * i], key[4 * i + 1], key[4 * i + 2], key[4 * i + 3]};
            w[i] = r;
            ++i;
        }
        i = Nk;
        while (i < totalLen) {
            w[i] = new byte[4];
            int t = 0;
            while (t < 4) {
                temp[t] = w[i - 1][t];
                ++t;
            }
            if (i % Nk == 0) {
                temp = ZSLoginAES.subWord(ZSLoginAES.rotWord(temp));
                t = 0;
                while (t < 4) {
                    temp[t] = (byte)(temp[t] & 0xFF ^ Rcon[i / Nk][t] & 0xFF);
                    ++t;
                }
            } else if (Nk > 6 && i % Nk == 4) {
                temp = ZSLoginAES.subWord(temp);
            }
            t = 0;
            while (t < 4) {
                w[i][t] = (byte)(w[i - Nk][t] & 0xFF ^ temp[t] & 0xFF);
                ++t;
            }
            ++i;
        }
        return w;
    }

    private static byte[] rotWord(byte[] w) {
        byte tmp = w[0];
        int i = 0;
        while (i < 3) {
            w[i] = w[i + 1];
            ++i;
        }
        w[3] = tmp;
        return w;
    }

    private static byte[] subWord(byte[] w) {
        int i = 0;
        while (i < 4) {
            w[i] = Sbox[w[i] & 0xFF];
            ++i;
        }
        return w;
    }

    public static byte[] cipher(byte[] input, byte[][] w) {
        int Nb = 4;
        int Nr = w.length / Nb - 1;
        byte[][] state = new byte[4][4];
        int i = 0;
        while (i < 4 * Nb) {
            state[i % 4][i / 4] = input[i];
            ++i;
        }
        state = ZSLoginAES.addRoundKey(state, w, 0, Nb);
        int round = 1;
        while (round < Nr) {
            state = ZSLoginAES.subBytes(state, Nb);
            state = ZSLoginAES.shiftRows(state, Nb);
            state = ZSLoginAES.mixColumns(state, Nb);
            state = ZSLoginAES.addRoundKey(state, w, round, Nb);
            ++round;
        }
        state = ZSLoginAES.subBytes(state, Nb);
        state = ZSLoginAES.shiftRows(state, Nb);
        state = ZSLoginAES.addRoundKey(state, w, Nr, Nb);
        byte[] output = new byte[4 * Nb];
        int i2 = 0;
        while (i2 < 4 * Nb) {
            output[i2] = state[i2 % 4][i2 / 4];
            ++i2;
        }
        return output;
    }

    private static byte[][] addRoundKey(byte[][] state, byte[][] w, int rnd, int Nb) {
        int r = 0;
        while (r < 4) {
            int c = 0;
            while (c < Nb) {
                state[r][c] = (byte)(state[r][c] & 0xFF ^ w[rnd * 4 + c][r] & 0xFF);
                ++c;
            }
            ++r;
        }
        return state;
    }

    private static byte[][] subBytes(byte[][] s, int Nb) {
        int r = 0;
        while (r < 4) {
            int c = 0;
            while (c < Nb) {
                s[r][c] = Sbox[s[r][c] & 0xFF];
                ++c;
            }
            ++r;
        }
        return s;
    }

    private static byte[][] shiftRows(byte[][] s, int Nb) {
        byte[] t = new byte[4];
        int r = 1;
        while (r < 4) {
            int c = 0;
            while (c < 4) {
                t[c] = s[r][(c + r) % Nb];
                ++c;
            }
            c = 0;
            while (c < 4) {
                s[r][c] = t[c];
                ++c;
            }
            ++r;
        }
        return s;
    }

    private static byte[][] mixColumns(byte[][] s, int Nb) {
        int c = 0;
        while (c < 4) {
            int[] a = new int[4];
            int[] b = new int[4];
            int i = 0;
            while (i < 4) {
                a[i] = s[i][c] & 0xFF;
                b[i] = ((s[i][c] & 0x80) != 0 ? (s[i][c] & 0xFF) << 1 ^ 0x11B : (s[i][c] & 0xFF) << 1) & 0xFF;
                ++i;
            }
            s[0][c] = (byte)(b[0] ^ a[1] ^ b[1] ^ a[2] ^ a[3]);
            s[1][c] = (byte)(a[0] ^ b[1] ^ a[2] ^ b[2] ^ a[3]);
            s[2][c] = (byte)(a[0] ^ a[1] ^ b[2] ^ a[3] ^ b[3]);
            s[3][c] = (byte)(a[0] ^ b[0] ^ a[1] ^ a[2] ^ b[3]);
            ++c;
        }
        return s;
    }
}

