/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.SingleThreadRunQueue;
import com.wovoe.carpark.dto.CarparkAlarmEvent;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CameraAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.RoadBarrierStateSupport;
import com.wovoe.carpark.equipment.action.VehiclePassDetectedAction;
import com.wovoe.carpark.equipment.driver.ICECameraRoadGateAction;
import com.wovoe.carpark.equipment.driver.ZSCameraTcpProtocol;
import com.wovoe.carpark.equipment.driver.ZSRGEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.VehiclePassEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;

public class ZSRGCameraAction
extends AbstractEquipmentAction
implements IoHandler,
ZSCameraTcpProtocol.ZSCameraPackageHandler,
CameraAction,
InputIoDetectedAction,
VehiclePassDetectedAction {
    public static final String LIBRARY_NAME = "VzLPRSDK";
    public static final String ACTION_NAME = "/ZSCameraAction";
    private static final String ZSCameraTcpProtocolName = ZSCameraTcpProtocol.class.getName();
    private static final int SUCCESS_CODE = 200;
    private static final String RESP_FIELD_STATE_CODE = "state_code";
    private static final String RESP_FIELD_HEARTBEAT = "heartBeat";
    private static final String RESP_FIELD_CMD = "cmd";
    private static final String RESP_FIELD_ID = "id";
    private static final byte JSON_BEGIN = 123;
    private static final byte JSON_END = 125;
    private static final String JSON_CMD_common_alarm_result = "\"common_alarm_result\"";
    private static final String JSON_CMD_close_socket = "\"close_socket\"";
    private static final String JSON_RESP_FIELD_CMD = "\"cmd\"";
    private final Object closeJobLock = new Object();
    private volatile boolean stopped = false;
    private final JobTask connectCheckJobTask;
    private ScheduledFuture<?> connectCheckJobTaskHandle;
    private String eq_serial_no;
    private volatile int heartErrCount;
    private volatile long connectingMills;
    private volatile ConnectFuture connectFuture;
    private volatile IoSession iosession;
    private String connectIp;
    private int connectPort;
    private AtomicInteger idseq = new AtomicInteger(0);
    private AtomicInteger seqFac = new AtomicInteger(0);
    private volatile long lastRevHeartBeat;
    private LocalProcessTransport localProcessTransport;
    private volatile Long hwnd;
    private volatile int nativeConnectErrorCounter;
    private Map<Integer, List<EventResultEntry>> eventResultMap = new HashMap<Integer, List<EventResultEntry>>();
    private SingleThreadRunQueue singleThreadRunQueue = new SingleThreadRunQueue();
    private volatile EquipmentState roadBarrierState = EquipmentState.DISCONNECTED;
    private volatile long roadBarrierStateMills;
    private final Object roadBarrierStateLock = new Object();
    private final String checkAutoDownloadTaskKey = String.valueOf(ZSRGCameraAction.class.getSimpleName()) + "--checkAutoDownloadTask";

    public ZSRGCameraAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
        this.connectCheckJobTask = new JobTask(){

            protected void doRun() throws Exception {
                ZSRGCameraAction.this.doJobRun();
            }
        };
        this.roadBarrierStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.closeJobLock;
        synchronized (object) {
            this.stopped = false;
            if (this.connectCheckJobTaskHandle == null) {
                this.connectCheckJobTaskHandle = ServiceUtil.getServiceContext().schedule(this.connectCheckJobTask, 2L, 5L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (!this.stopped) {
                this.stopped = true;
                if (this.connectCheckJobTaskHandle != null) {
                    this.connectCheckJobTaskHandle.cancel(true);
                    this.connectCheckJobTaskHandle = null;
                }
                if (this.connectFuture != null && !this.connectFuture.isDone()) {
                    this.connectFuture.cancel();
                    this.connectFuture = null;
                    this.connectingMills = 0L;
                }
                if (this.iosession != null && this.iosession.isConnected()) {
                    this.iosession.close(true);
                }
                this.hwnd = null;
                this.nativeDisConnect();
            }
        }
    }

    public void hanleEventResult(final EventResult eventResult) {
        if (this.stopped) {
            return;
        }
        this.singleThreadRunQueue.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ZSRGCameraAction.this.hanleEventResult0(eventResult);
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)"\u5904\u7406\u4e8b\u4ef6\u5f02\u5e38", ex);
                }
            }
        }, ServiceUtil.getServiceContext().getWorkThreadPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJobRun() {
        boolean connected;
        if (this.stopped) {
            return;
        }
        String configIp = this.getConfigIp();
        int configPort = this.getConfigPort();
        IoSession session = this.iosession;
        boolean bl = connected = session != null && session.isConnected();
        if (connected) {
            String ip = this.connectIp;
            int port = this.connectPort;
            if (configIp == null || !configIp.equals(ip) || configPort != port) {
                this.disconnect();
                connected = false;
            }
        }
        if (connected && ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevHeartBeat >= 12000L) {
            this.disconnect();
            connected = false;
        }
        if (!connected) {
            if (configIp == null || configIp.length() == 0) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " Camera IP not configured"));
                return;
            }
            this.doConnect(configIp, configPort);
        } else {
            this.sendHearbeat().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                    ZSRGCameraAction zSRGCameraAction = ZSRGCameraAction.this;
                    zSRGCameraAction.heartErrCount = zSRGCameraAction.heartErrCount + 1;
                    if (ZSRGCameraAction.this.heartErrCount >= 2) {
                        ZSRGCameraAction.this.disconnect();
                        if (!ZSRGCameraAction.this.connectCheckJobTask.isRunning()) {
                            ZSRGCameraAction.this.connectCheckJobTask.run();
                        }
                    }
                }

                public void operationComplete(OperationFuture<Integer> f) {
                    if (f.getResult() != null && (Integer)f.getResult() == 0) {
                        if (ZSRGCameraAction.this.heartErrCount != 0) {
                            ZSRGCameraAction.this.heartErrCount = 0;
                        }
                    } else {
                        this.waitCompleteTimeout();
                    }
                }
            });
            if (this.isEnableGateStatusDetect() && this.isNeedHandleEvent()) {
                Object object = this.roadBarrierStateLock;
                synchronized (object) {
                    long cms;
                    if (this.roadBarrierState == EquipmentState.CONNECTED) {
                        long cms2 = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (cms2 - this.roadBarrierStateMills >= 8000L) {
                            this.setRoadBarrierState(EquipmentState.BARRIER_DROPPED_IN_PLACE);
                        }
                    } else if (this.roadBarrierState == EquipmentState.BARRIER_DROPPED_IN_PLACE) {
                        long cms3 = ServiceUtil.getServiceContext().currentTimeMillis();
                        if (cms3 - this.roadBarrierStateMills < 12000L) {
                            this.setRoadBarrierState(EquipmentState.BARRIER_DROPPED_IN_PLACE);
                        }
                    } else if (this.roadBarrierState == EquipmentState.BARRIER_RAISED_IN_PLACE && (cms = ServiceUtil.getServiceContext().currentTimeMillis()) - this.roadBarrierStateMills >= 12000L) {
                        this.setRoadBarrierState(EquipmentState.BARRIER_DROPPED_IN_PLACE);
                    }
                }
            }
            this.connectIfNotConnected1();
        }
    }

    private String getConfigIp() {
        return this.equipment.getIp();
    }

    private int getConfigPort() {
        int _port;
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer port = config.getConfigIntValue("port");
        if (port == null) {
            _port = 8131;
        } else {
            _port = port;
            if (_port < 1 || _port >= 65535) {
                _port = 8131;
            }
        }
        return _port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (this.iosession != null && this.iosession.isConnected()) {
                this.iosession.close(true);
            }
            this.eq_serial_no = null;
        }
        this.nativeDisConnect();
    }

    private void onSetConnectSuccess(IoSession session) {
        if (this.stopped) {
            session.close(true);
        } else {
            if (this.iosession != null && this.iosession.isConnected()) {
                this.iosession.close(true);
            }
            session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
            session.setAttribute((Object)ZSCameraTcpProtocolName, (Object)new ZSCameraTcpProtocol(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + "]"));
            this.lastRevHeartBeat = ServiceUtil.getServiceContext().currentTimeMillis();
            this.heartErrCount = 0;
            this.iosession = session;
        }
    }

    private void onConnectSuccess() {
        this.getCameraSn().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<String>(){

            public void operationComplete(OperationFuture<String> futrue) {
                final String sn = (String)futrue.getResult();
                if (sn != null && sn.length() > 0) {
                    ZSRGCameraAction.this.eq_serial_no = sn;
                    ZSRGCameraAction.this.setCameraTime(new Date()).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> futrue0) {
                            if (futrue0.getException() != null || futrue0.getResult() == null || (Integer)futrue0.getResult() != 0) {
                                ServiceLog.getLog().error((Object)("\u8bbe\u7f6e\u76f8\u673a: " + ZSRGCameraAction.this.equipment.getName() + "[" + ZSRGCameraAction.this.equipment.getIp() + "] \u65f6\u95f4\u5931\u8d25"));
                            }
                            ZSRGCameraAction.this.enableUploadEvent(sn).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                                public void operationComplete(OperationFuture<Integer> futrue1) {
                                    if (futrue1.getException() != null || futrue1.getResult() == null || (Integer)futrue1.getResult() != 0) {
                                        ServiceLog.getLog().error((Object)("\u8bbe\u7f6e\u76f8\u673a: " + ZSRGCameraAction.this.equipment.getName() + "[" + ZSRGCameraAction.this.equipment.getIp() + "] \u5f00\u542f\u4e0a\u62a5\u4e8b\u4ef6\u5931\u8d25"));
                                    }
                                }

                                public void waitCompleteTimeout() {
                                }
                            });
                        }

                        public void waitCompleteTimeout() {
                        }
                    });
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        this.connectIfNotConnected1();
    }

    public String getEq_serial_no() {
        return this.eq_serial_no;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(final String ip, final int port) {
        Object object = this.closeJobLock;
        synchronized (object) {
            ConnectFuture connectFuture0;
            if (this.stopped) {
                return;
            }
            if (this.iosession != null && this.iosession.isConnected()) {
                return;
            }
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            if (this.connectFuture != null && !this.connectFuture.isDone()) {
                if (currentMills - this.connectingMills >= 10000L) {
                    this.connectFuture.cancel();
                } else {
                    return;
                }
            }
            this.connectingMills = currentMills;
            this.connectIp = ip;
            this.connectPort = port;
            this.connectFuture = connectFuture0 = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)new InetSocketAddress(ip, port));
            connectFuture0.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ConnectFuture f) {
                    IoSession session = null;
                    Object object = ZSRGCameraAction.this.closeJobLock;
                    synchronized (object) {
                        if (f.isConnected()) {
                            session = f.getSession();
                            if (session != null && session.isConnected()) {
                                if (connectFuture0 != ZSRGCameraAction.this.connectFuture) {
                                    session.close(true);
                                    session = null;
                                } else {
                                    ZSRGCameraAction.this.onSetConnectSuccess(session);
                                }
                            } else {
                                session = null;
                            }
                        } else if (f.getException() != null) {
                            ServiceLog.getLog().warn((Object)("Failed to connect camera " + ZSRGCameraAction.this.equipment.getName() + "(" + ip + ":" + port + "), cause: " + f.getException()));
                        }
                        if (connectFuture0 == ZSRGCameraAction.this.connectFuture) {
                            ZSRGCameraAction.this.connectFuture = null;
                            ZSRGCameraAction.this.connectingMills = 0L;
                        }
                    }
                    if (session != null) {
                        ZSRGCameraAction.this.roadBarrierState = EquipmentState.CONNECTED;
                        ZSRGCameraAction.this.roadBarrierStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        ZSRGCameraAction.this.onConnectSuccess();
                    }
                }
            });
        }
    }

    @Override
    public boolean isWorkingProperly() {
        IoSession session = this.iosession;
        boolean connected = session != null && session.isConnected();
        return connected;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    @Override
    public OperationFuture<Integer> play(Map<String, Object> param) {
        Long hwnd0;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        Object x = param.get("componentID");
        if (x == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570:componentID"));
            return xf;
        }
        try {
            hwnd0 = x instanceof Long ? (Long)x : Long.valueOf(x.toString());
        }
        catch (Exception ex) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u9519\u8bef\u53c2\u6570:componentID:" + x));
            return xf;
        }
        this.hwnd = hwnd0;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setResult((Object)-1);
            return xf;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u64ad\u653e\u89c6\u9891";
        String serviceName = "playVisible";
        long timeoutMills = 5000L;
        this.setNativeReusetParam(paramMap);
        paramMap.put("componentID", hwnd0.toString());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> stopPlay(Map<String, Object> param) {
        this.hwnd = null;
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u505c\u6b62\u64ad\u653e";
        String serviceName = "stopPlay";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    @Override
    public OperationFuture<Integer> capture(Map<String, Object> param) {
        OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        handler.setResult((Object)-1);
        return handler;
    }

    @Override
    public boolean isNeedAlwaysPlaying() {
        return false;
    }

    @Override
    public Long getPlayingComponentID() {
        return this.hwnd;
    }

    public OperationFuture<Integer> sendHearbeat() {
        String opName = "\u53d1\u9001\u5fc3\u8df3";
        byte sendSeq = this.getSendSeq();
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(null, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), "", RESP_FIELD_HEARTBEAT, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public OperationFuture<String> getCameraSn() {
        String opName = "\u83b7\u53d6\u76f8\u673a\u5e8f\u5217\u53f7";
        byte sendSeq = this.getSendSeq();
        String cmd = "getsn";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put(RESP_FIELD_CMD, cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put(RESP_FIELD_ID, id);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new ResponseHandler<String>(){

            @Override
            public String handler(Map<?, ?> responseMap) throws Exception {
                int code = this.getOpCode(responseMap);
                if (code != 0) {
                    return null;
                }
                String value = (String)responseMap.get("value");
                return value;
            }
        }, 5000L);
    }

    public OperationFuture<Integer> setCameraTime(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String opName = "\u8bbe\u7f6e\u76f8\u673a\u65f6\u95f4";
        byte sendSeq = this.getSendSeq();
        String cmd = "set_time";
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        dataMap.put(RESP_FIELD_CMD, cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put(RESP_FIELD_ID, id);
        dataMap.put("timestring", df.format(date));
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    public OperationFuture<Integer> enableUploadEvent(String sn) {
        String opName = "\u4e8b\u4ef6\u4e0a\u62a5\u4f7f\u80fd";
        byte sendSeq = this.getSendSeq();
        String cmd = "stay_event_enable";
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put(RESP_FIELD_CMD, cmd);
        String id = String.valueOf(this.getIdSeq());
        dataMap.put(RESP_FIELD_ID, id);
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>();
        bodyMap.put("sn", sn);
        bodyMap.put("enable", Boolean.TRUE);
        bodyMap.put("format", "json");
        bodyMap.put("image", Boolean.TRUE);
        bodyMap.put("image_type", 2);
        ArrayList<LinkedHashMap<String, Object>> body = new ArrayList<LinkedHashMap<String, Object>>(1);
        body.add(bodyMap);
        dataMap.put("body", body);
        ZSCameraTcpProtocol.ZSCameraPackage p = ZSCameraTcpProtocol.toSendPackage(dataMap, sendSeq);
        WaitResponseKey waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), id, cmd, this.equipment.getEquipmentNo());
        return this.send(opName, this.iosession, p, waitResponseKey, new OPResponseHandler(), 5000L);
    }

    private void handleEnvent(ZSCameraTcpProtocol.ZSCameraPackage p, String dataJson, int pigBeginIndex) {
        ZSCameraImageEntry entry;
        ZSRGEvent rgEvent;
        if (!this.isNeedHandleEvent()) {
            return;
        }
        try {
            rgEvent = (ZSRGEvent)ServiceUtil.getHtmlEscapingGson().fromJson(dataJson, ZSRGEvent.class);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u8fd4\u56de\u4e86\u4e00\u4e2a\u65e0\u6cd5\u89e3\u6790\u7684json\u7684\u6570\u636e:  " + dataJson));
            return;
        }
        if (rgEvent.getUid() == null) {
            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u63a8\u9001\u4e8b\u4ef6\u7f3a\u5c11: uid" + dataJson));
            return;
        }
        List<ZSRGEvent.Result> results = rgEvent.getResults();
        if (results == null || results.isEmpty()) {
            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u63a8\u9001\u4e8b\u4ef6\u7f3a\u5c11: results! " + dataJson));
            return;
        }
        Map<Long, ZSCameraImageEntry> imageMap = this.paresePic(p.getData(), pigBeginIndex);
        ZSCameraImageEntry bigImage = null;
        ZSCameraImageEntry smallImage = null;
        if (rgEvent.getFull_image() != null && !rgEvent.getFull_image().isEmpty()) {
            for (ZSRGEvent.Image img : rgEvent.getFull_image()) {
                if (img == null || img.getFull_image_id() == null) continue;
                entry = imageMap.get(img.getFull_image_id());
                if (entry == null && img.getFull_image_id() < 0L) {
                    entry = imageMap.get(img.getFull_image_id() & 0xFFFFFFFFL);
                }
                if (entry == null) continue;
                bigImage = entry;
                break;
            }
        }
        if (rgEvent.getSmall_image() != null && !rgEvent.getSmall_image().isEmpty()) {
            for (ZSRGEvent.Image img : rgEvent.getSmall_image()) {
                if (img == null || img.getSmall_image_id() == null) continue;
                entry = imageMap.get(img.getSmall_image_id());
                if (entry == null && img.getSmall_image_id() < 0L) {
                    entry = imageMap.get(img.getSmall_image_id() & 0xFFFFFFFFL);
                }
                if (entry == null) continue;
                smallImage = entry;
                break;
            }
        }
        for (ZSRGEvent.Result result : results) {
            if (result == null) continue;
            if (result.getResult_id() == null) {
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u63a8\u9001\u4e8b\u4ef6\u7f3a\u5c11: results[].result_id! " + dataJson));
                continue;
            }
            if (result.getGroup_id() == null) {
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u63a8\u9001\u4e8b\u4ef6\u7f3a\u5c11: results[].group_id! " + dataJson));
                continue;
            }
            if (result.getEvent_type() == null) {
                ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u63a8\u9001\u4e8b\u4ef6\u7f3a\u5c11: results[].event_type! " + dataJson));
                continue;
            }
            int ruleId = 127;
            if (rgEvent.getDevice_info() != null && rgEvent.getDevice_info().getRule_id() != null) {
                ruleId = rgEvent.getDevice_info().getRule_id();
            }
            EventResult eventResult = new EventResult(ruleId, result, bigImage, smallImage);
            this.hanleEventResult(eventResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EventResultEntry> getEventResultEntryList(Integer eventType) {
        List<EventResultEntry> list;
        Map<Integer, List<EventResultEntry>> map = this.eventResultMap;
        synchronized (map) {
            list = this.eventResultMap.get(eventType);
            if (list == null) {
                list = new LinkedList<EventResultEntry>();
                this.eventResultMap.put(eventType, list);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventResultEntry findSameGroupIdEntry(long group_id, List<EventResultEntry> list) {
        List<EventResultEntry> list2 = list;
        synchronized (list2) {
            block8: {
                if (!list.isEmpty()) break block8;
                return null;
            }
            EventResultEntry rEntry = null;
            long timeoutMills = TimeUnit.MINUTES.toMillis(60L);
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            Iterator<EventResultEntry> its = list.iterator();
            while (its.hasNext()) {
                EventResultEntry entry = its.next();
                if (entry.start == null || entry.latest == null) {
                    its.remove();
                    continue;
                }
                if (entry.flagClosedMills != null && entry.flagClosedMills <= currentMills) {
                    its.remove();
                    continue;
                }
                if (currentMills - entry.start.revNonTimeMills >= timeoutMills) {
                    its.remove();
                    continue;
                }
                if (entry.end != null || entry.start.group_id != group_id) continue;
                rEntry = entry;
            }
            return rEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventResultEntry addNewEventResult(EventResult eventResult, List<EventResultEntry> list, boolean createLog, int alarmType, int alarmStatus, int reserveUnReleaseCount) {
        List<EventResultEntry> list2 = list;
        synchronized (list2) {
            if (!list.isEmpty()) {
                LinkedList<EventResultEntry> unFinishList = null;
                for (EventResultEntry entry : list) {
                    if (entry.end != null) {
                        if (entry.flagClosedMills != null) continue;
                        entry.flagClosedMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
                        if (entry.start != null) {
                            entry.start.bigImgData = null;
                            entry.start.smallImgData = null;
                        }
                        if (entry.latest == null) continue;
                        entry.latest.bigImgData = null;
                        entry.latest.smallImgData = null;
                        continue;
                    }
                    if (entry.flagClosedMills != null) continue;
                    if (unFinishList == null) {
                        unFinishList = new LinkedList<EventResultEntry>();
                    }
                    unFinishList.offer(entry);
                }
                int reserveCount = reserveUnReleaseCount - 1;
                if (reserveCount < 0) {
                    reserveCount = 0;
                }
                if (unFinishList != null && unFinishList.size() > reserveCount) {
                    EventResultEntry entry;
                    while ((entry = (EventResultEntry)unFinishList.poll()) != null) {
                        list.remove(entry);
                        if (unFinishList.size() <= reserveCount) break;
                    }
                }
            }
            EventResultEntry entry = new EventResultEntry();
            entry.start = eventResult;
            entry.latest = eventResult;
            entry.revTimes = 1;
            if (createLog) {
                CarparkAlarmEvent event = this.createCarparkAlarmEvent(eventResult, alarmType, alarmStatus);
                entry.dbLogId = event.getId();
                entry.lastestPlateNumber = event.getPlate_number();
                entry.startBigImagePath = event.getAlarm_start_pic_path();
                entry.lastestBigImagePath = event.getAlarm_latest_pic_path();
                entry.latestSmallImagePath = event.getAlarm_small_pic_path();
                entry.level = event.getAlarm_level();
                CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                commonDaoService.insert((Object)event);
            }
            list.add(entry);
            return entry;
        }
    }

    private void updateNewEventResult(EventResult eventRuslt, EventResultEntry entry, int levelMediumTimes, int levelHighTimes) {
        entry.latest = eventRuslt;
        ++entry.revTimes;
        if (entry.dbLogId != null) {
            File file;
            String absPath;
            String smallPic;
            String bigPic;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkAlarmEvent.class));
            updateP.addEQ(RESP_FIELD_ID, (Object)entry.dbLogId);
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            Date now = cl.getTime();
            cl.setTimeInMillis(eventRuslt.revSysTimeMills);
            cl.set(14, 0);
            updateP.addUpdate("alarm_times", (Object)entry.revTimes);
            updateP.addUpdate("alarm_latest_time", (Object)cl.getTime());
            updateP.addUpdate("last_updated_time", (Object)now);
            if (eventRuslt.plateNumber != null && eventRuslt.plateNumber.length() > 0 && !eventRuslt.plateNumber.equals(entry.lastestPlateNumber)) {
                updateP.addUpdate("plate_number", (Object)eventRuslt.plateNumber);
                entry.lastestPlateNumber = eventRuslt.plateNumber;
            }
            String delBigPicPath = null;
            if (eventRuslt.bigImgData != null && (bigPic = this.getDbSavePicPath(this.savePic(eventRuslt.bigImgType, eventRuslt.bigImgData, false, eventRuslt.plateNumber))) != null && bigPic.length() > 0) {
                String old = entry.lastestBigImagePath;
                entry.lastestBigImagePath = bigPic;
                updateP.addUpdate("alarm_latest_pic_path", (Object)bigPic);
                if (old != null && old.length() > 0 && !old.equals(entry.startBigImagePath)) {
                    delBigPicPath = old;
                }
            }
            String delSmallPicPath = null;
            if (eventRuslt.smallImgData != null && eventRuslt.plateNumber != null && eventRuslt.plateNumber.length() > 0 && (smallPic = this.getDbSavePicPath(this.savePic(eventRuslt.smallImageType, eventRuslt.smallImgData, true, eventRuslt.plateNumber))) != null && smallPic.length() > 0) {
                delSmallPicPath = entry.latestSmallImagePath;
                entry.latestSmallImagePath = smallPic;
                updateP.addUpdate("alarm_small_pic_path", (Object)smallPic);
            }
            if (eventRuslt.time != null && eventRuslt.time.length() > 0) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    updateP.addUpdate("alarm_latest_device_time", (Object)df.parse(eventRuslt.time));
                }
                catch (Exception df) {
                    // empty catch block
                }
            }
            if (entry.level < 2 && levelHighTimes > 0 && entry.revTimes >= levelHighTimes) {
                updateP.addUpdate("alarm_level", (Object)2);
                entry.level = 2;
            }
            if (entry.level < 1 && levelMediumTimes > 0 && entry.revTimes >= levelMediumTimes) {
                updateP.addUpdate("alarm_level", (Object)1);
                entry.level = 1;
            }
            commonDaoService.update(updateP);
            RecordSaveService saveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            if (delBigPicPath != null && delBigPicPath.length() > 0 && (absPath = saveService.getLocalPicPath(delBigPicPath)) != null && absPath.length() > 0 && (file = new File(absPath)).exists() && file.isFile()) {
                file.delete();
            }
            if (delSmallPicPath != null && delSmallPicPath.length() > 0 && (absPath = saveService.getLocalPicPath(delSmallPicPath)) != null && absPath.length() > 0 && (file = new File(absPath)).exists() && file.isFile()) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishEvent(EventResult eventResult, final EventResultEntry entry, List<EventResultEntry> list, int alarm_status) {
        if (entry.end != null || entry.flagClosedMills != null) {
            return;
        }
        boolean notifyCloudFinish = false;
        boolean delayRemoveFinishImage = false;
        final byte[] bigImageData = eventResult.bigImgData;
        final byte[] smallImageData = eventResult.smallImgData;
        EventResultEntry eventResultEntry = entry;
        synchronized (eventResultEntry) {
            entry.end = eventResult;
            if (!entry.notifyCloudFinish && entry.cloudId != null) {
                entry.notifyCloudFinish = true;
                notifyCloudFinish = true;
            } else if (entry.notifyCloudAlarm) {
                delayRemoveFinishImage = true;
            }
        }
        entry.flagClosedMills = ServiceUtil.getServiceContext().currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L);
        if (entry.dbLogId != null) {
            File file;
            RecordSaveService saveService;
            String absPath;
            String smallPic;
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            CommonParam updateP = new CommonParam(commonDaoService.getTableName(CarparkAlarmEvent.class));
            updateP.addEQ(RESP_FIELD_ID, (Object)entry.dbLogId);
            Calendar cl = Calendar.getInstance();
            cl.set(14, 0);
            Date now = cl.getTime();
            cl.setTimeInMillis(eventResult.revSysTimeMills);
            cl.set(14, 0);
            updateP.addUpdate("alarm_status", (Object)alarm_status);
            updateP.addUpdate("alarm_release_time", (Object)cl.getTime());
            updateP.addUpdate("last_updated_time", (Object)now);
            String bigPicPath = this.getDbSavePicPath(this.savePic(eventResult.bigImgType, bigImageData, false, eventResult.plateNumber));
            if (bigPicPath != null && bigPicPath.length() > 0) {
                updateP.addUpdate("alarm_release_pic_path", (Object)bigPicPath);
            }
            if (eventResult.plateNumber != null && eventResult.plateNumber.length() > 0 && !eventResult.plateNumber.equals(entry.lastestPlateNumber)) {
                updateP.addUpdate("plate_number", (Object)eventResult.plateNumber);
                entry.lastestPlateNumber = eventResult.plateNumber;
            }
            String delSmallPicPath = null;
            if (eventResult.smallImgData != null && eventResult.plateNumber != null && eventResult.plateNumber.length() > 0 && (smallPic = this.getDbSavePicPath(this.savePic(eventResult.smallImageType, smallImageData, true, eventResult.plateNumber))) != null && smallPic.length() > 0) {
                delSmallPicPath = entry.latestSmallImagePath;
                entry.latestSmallImagePath = smallPic;
                updateP.addUpdate("alarm_small_pic_path", (Object)smallPic);
            }
            commonDaoService.update(updateP);
            if (delSmallPicPath != null && delSmallPicPath.length() > 0 && (absPath = (saveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class)).getLocalPicPath(delSmallPicPath)) != null && absPath.length() > 0 && (file = new File(absPath)).exists() && file.isFile()) {
                file.delete();
            }
        }
        if (entry.tipEndMills > 0L) {
            this.tipEventResult(eventResult);
        }
        if (notifyCloudFinish) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    ZSRGCameraAction.this.doNotifyCloudFinish(entry.end, entry.cloudId, bigImageData, smallImageData);
                }
            });
        }
        if (entry.start != null) {
            entry.start.bigImgData = null;
            entry.start.smallImgData = null;
        }
        if (entry.latest != null) {
            entry.latest.bigImgData = null;
            entry.latest.smallImgData = null;
        }
        if (entry.end != null && !delayRemoveFinishImage) {
            entry.end.bigImgData = null;
            entry.end.smallImgData = null;
        }
    }

    private CarparkAlarmEvent createCarparkAlarmEvent(EventResult eventRuslt, int alarmType, int alarmStatus) {
        CarparkAlarmEvent event = new CarparkAlarmEvent();
        event.setAlarm_ref_id(eventRuslt.result_id);
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        Date now = cl.getTime();
        cl.setTimeInMillis(eventRuslt.revSysTimeMills);
        cl.set(14, 0);
        event.setAlarm_start_time(cl.getTime());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (eventRuslt.time != null && eventRuslt.time.length() > 0) {
            try {
                event.setAlarm_start_device_time(df.parse(eventRuslt.time));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        event.setAlarm_type(alarmType);
        event.setAlarm_status(alarmStatus);
        event.setAlarm_type_id(eventRuslt.group_id);
        event.setAlarm_times(1);
        event.setAlarm_latest_time(event.getAlarm_start_time());
        event.setAlarm_latest_device_time(event.getAlarm_start_device_time());
        event.setAlarm_level(0);
        event.setHost_no(ServiceUtil.getServiceContext().getLocalHostNo());
        event.setDevice_no(this.equipment.getEquipmentNo());
        List<String> cls = this.equipment.getChannelNos();
        event.setChannel_no(cls == null || cls.isEmpty() ? "" : cls.get(0));
        event.setPlate_number(eventRuslt.plateNumber);
        event.setCreated_time(now);
        event.setLast_updated_time(now);
        event.setCarpark_id(ServiceUtil.getServiceContext().getCarparkId());
        event.setProject_id(ServiceUtil.getServiceContext().getProjectId());
        if (eventRuslt.bigImgData != null) {
            event.setAlarm_start_pic_path(this.getDbSavePicPath(this.savePic(eventRuslt.bigImgType, eventRuslt.bigImgData, false, eventRuslt.plateNumber)));
            event.setAlarm_latest_pic_path(event.getAlarm_start_pic_path());
        }
        if (eventRuslt.plateNumber != null && eventRuslt.plateNumber.length() > 0 && eventRuslt.smallImgData != null) {
            event.setAlarm_small_pic_path(this.getDbSavePicPath(this.savePic(eventRuslt.smallImageType, eventRuslt.smallImgData, true, eventRuslt.plateNumber)));
        }
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        long id = appService.createLocalRecordSeq("ck_carpark_alarm_event_seq");
        event.setId(id);
        return event;
    }

    private String getDbSavePicPath(String localSavePth) {
        RecordSaveService saveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        return saveService.getDbPicPath(localSavePth);
    }

    private String savePic(int imgType, byte[] imgData, boolean small, String plate) {
        if (imgData == null || imgData.length == 0) {
            return null;
        }
        try {
            byte[] saveImageData;
            int height;
            int width;
            String namex;
            long xatime = System.currentTimeMillis();
            Random r = new Random();
            int ranx = Math.abs(r.nextInt());
            if (plate != null && plate.length() > 0) {
                byte[] b1;
                try {
                    b1 = plate.getBytes("GB2312");
                }
                catch (Exception ex) {
                    b1 = plate.getBytes();
                }
                String plateHex = BytesTool.byteArrayToHexString((byte[])b1);
                namex = small ? "plateSmall_" + plateHex : "plate_" + plateHex;
            } else {
                namex = "snapshot_";
            }
            if (small) {
                width = 105;
                height = 35;
            } else {
                width = 1024;
                height = 576;
            }
            StringBuilder fileNameBtr = new StringBuilder(128).append(namex).append('_').append(xatime).append('_').append(ranx);
            try {
                byte[] d = ServiceUtil.compressPic(new ByteArrayInputStream(imgData), width, height, 0.75f);
                if (d != null && d.length > 0) {
                    saveImageData = d;
                    fileNameBtr.append(".jpg");
                } else {
                    if (imgType == 0) {
                        fileNameBtr.append(".jpg");
                    } else {
                        fileNameBtr.append(".png");
                    }
                    saveImageData = imgData;
                }
            }
            catch (Exception ex) {
                if (imgType == 0) {
                    fileNameBtr.append(".jpg");
                } else {
                    fileNameBtr.append(".png");
                }
                saveImageData = imgData;
            }
            File saveF = new File(this.getPicSaveDir(), fileNameBtr.toString());
            try (FileOutputStream out = new FileOutputStream(saveF);){
                out.write(saveImageData);
            }
            return saveF.getAbsolutePath();
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u5904\u7406\u56fe\u7247\u5f02\u5e38: ", (Throwable)ex);
            return null;
        }
    }

    public File getPicSaveDir() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        File dateDir = new File(PathFinder.findLocalPicDir(), df.format(new Date()));
        File eqFile = new File(dateDir, this.equipment.getEquipmentNo());
        if (!eqFile.exists()) {
            eqFile.mkdirs();
        }
        return eqFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(final EventResultEntry entry, int levelMediumTimes, int levelHighTimes) {
        int tiemeout;
        long currentMills;
        if (levelMediumTimes > 0 && entry.revTimes >= levelMediumTimes && (currentMills = ServiceUtil.getServiceContext().currentTimeMillis()) >= entry.tipEndMills && (tiemeout = this.tipEventResult(entry.latest)) > 0) {
            entry.tipEndMills = currentMills + (long)tiemeout;
        }
        if (levelHighTimes > 0 && entry.revTimes >= levelHighTimes && entry.cloudId == null && !entry.notifyCloudAlarm) {
            boolean aCloud = false;
            EventResultEntry eventResultEntry = entry;
            synchronized (eventResultEntry) {
                if (entry.cloudId == null && !entry.notifyCloudAlarm) {
                    entry.notifyCloudAlarm = true;
                    aCloud = true;
                }
            }
            if (aCloud) {
                try {
                    final EventResult eventResult = entry.latest;
                    final byte[] bigImageData = eventResult.bigImgData;
                    final byte[] smallImageData = eventResult.smallImgData;
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block29: {
                                Long cloudId = null;
                                try {
                                    try {
                                        cloudId = ZSRGCameraAction.this.doAdviceCloudResult(eventResult, bigImageData, smallImageData);
                                    }
                                    catch (Throwable ex) {
                                        ServiceLog.getLog().warn((Object)"\u901a\u77e5\u4e91\u7aef\u5f02\u5e38", ex);
                                        boolean notifyFinish = false;
                                        byte[] bigImageData0 = null;
                                        byte[] smallImageData0 = null;
                                        EventResultEntry eventResultEntry = entry;
                                        synchronized (eventResultEntry) {
                                            if (cloudId != null) {
                                                entry.cloudId = cloudId;
                                                entry.notifyCloudAlarm = false;
                                                if (entry.end != null && !entry.notifyCloudFinish) {
                                                    entry.notifyCloudFinish = true;
                                                    notifyFinish = true;
                                                    bigImageData0 = entry.end.bigImgData;
                                                    smallImageData0 = entry.end.smallImgData;
                                                    entry.end.bigImgData = null;
                                                    entry.end.smallImgData = null;
                                                }
                                            } else if (entry.end != null) {
                                                entry.end.bigImgData = null;
                                                entry.end.smallImgData = null;
                                            }
                                        }
                                        if (notifyFinish) {
                                            ZSRGCameraAction.this.doNotifyCloudFinish(entry.end, cloudId, bigImageData0, smallImageData0);
                                        }
                                        break block29;
                                    }
                                }
                                catch (Throwable throwable) {
                                    boolean notifyFinish = false;
                                    byte[] bigImageData0 = null;
                                    byte[] smallImageData0 = null;
                                    EventResultEntry eventResultEntry = entry;
                                    synchronized (eventResultEntry) {
                                        if (cloudId != null) {
                                            entry.cloudId = cloudId;
                                            entry.notifyCloudAlarm = false;
                                            if (entry.end != null && !entry.notifyCloudFinish) {
                                                entry.notifyCloudFinish = true;
                                                notifyFinish = true;
                                                bigImageData0 = entry.end.bigImgData;
                                                smallImageData0 = entry.end.smallImgData;
                                                entry.end.bigImgData = null;
                                                entry.end.smallImgData = null;
                                            }
                                        } else if (entry.end != null) {
                                            entry.end.bigImgData = null;
                                            entry.end.smallImgData = null;
                                        }
                                    }
                                    if (notifyFinish) {
                                        ZSRGCameraAction.this.doNotifyCloudFinish(entry.end, cloudId, bigImageData0, smallImageData0);
                                    }
                                    throw throwable;
                                }
                                boolean notifyFinish = false;
                                byte[] bigImageData0 = null;
                                byte[] smallImageData0 = null;
                                EventResultEntry eventResultEntry = entry;
                                synchronized (eventResultEntry) {
                                    if (cloudId != null) {
                                        entry.cloudId = cloudId;
                                        entry.notifyCloudAlarm = false;
                                        if (entry.end != null && !entry.notifyCloudFinish) {
                                            entry.notifyCloudFinish = true;
                                            notifyFinish = true;
                                            bigImageData0 = entry.end.bigImgData;
                                            smallImageData0 = entry.end.smallImgData;
                                            entry.end.bigImgData = null;
                                            entry.end.smallImgData = null;
                                        }
                                    } else if (entry.end != null) {
                                        entry.end.bigImgData = null;
                                        entry.end.smallImgData = null;
                                    }
                                }
                                if (notifyFinish) {
                                    ZSRGCameraAction.this.doNotifyCloudFinish(entry.end, cloudId, bigImageData0, smallImageData0);
                                }
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    EventResultEntry eventResultEntry2 = entry;
                    synchronized (eventResultEntry2) {
                        entry.notifyCloudAlarm = false;
                    }
                }
            }
        }
    }

    private Long doAdviceCloudResult(EventResult eventResult, byte[] bigImageData, byte[] smallImageData) {
        return null;
    }

    private void doNotifyCloudFinish(EventResult eventResult, Long cloudId, byte[] bigImageData, byte[] smallImageData) {
    }

    private int tipEventResult(EventResult eventResult) {
        String passChannelName;
        if (eventResult == null) {
            return 0;
        }
        int eventType = eventResult.event_type;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeStr = df.format(new Date(eventResult.revSysTimeMills));
        PassChannel passChannel = null;
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos != null && !channelNos.isEmpty()) {
            passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNos.get(0));
        }
        String string = passChannelName = passChannel == null ? "" : passChannel.getChannel().getChannel_name();
        if (eventType == 80) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u51fa\u73b0\u4eba\u5458\u957f\u65f6\u95f4\u6ede\u7559\u9884\u8b66, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        if (eventType == 73) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u4eba\u5458\u6ede\u7559\u9884\u8b66\u89e3\u9664, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 15000));
            return 15000;
        }
        if (eventType == 112) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u51fa\u73b0\u975e\u673a\u52a8\u8f66\u957f\u65f6\u95f4\u6ede\u7559\u9884\u8b66, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        if (eventType == 113) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u975e\u673a\u52a8\u8f66\u6ede\u7559\u9884\u8b66\u89e3\u9664, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 15000));
            return 15000;
        }
        if (eventType == 144) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u51fa\u73b0\u62e5\u5835\u9884\u8b66, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        if (eventType == 145) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u62e5\u5835\u9884\u8b66\u89e3\u9664, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 15000));
            return 15000;
        }
        if (eventType == 81) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u8f66\u8f86" + (eventResult.plateNumber == null ? "" : eventResult.plateNumber) + "\u957f\u65f6\u95f4\u6ede\u7559, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        if (eventType == 82) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u8f66\u8f86" + (eventResult.plateNumber == null ? "" : eventResult.plateNumber) + "\u6ede\u7559\u89e3\u9664, \u9884\u8b66ID: " + eventResult.group_id;
            ServiceLog.getLog().info((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2, 15000));
            return 15000;
        }
        if (eventType == 84) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u8f66\u8f86" + (eventResult.plateNumber == null ? "" : eventResult.plateNumber) + "\u5012\u8f66\u6298\u8fd4";
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        if (eventType == 129) {
            String msg = "[" + timeStr + "] " + passChannelName + ": \u9053\u95f8\u6746\u957f\u65f6\u95f4\u672a\u5f52\u4f4d";
            ServiceLog.getLog().warn((Object)msg);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 20000));
            return 60000;
        }
        return 0;
    }

    private int getNotifyTimes(String key) {
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue(key);
        if (x == null || x < 0) {
            return 0;
        }
        return x;
    }

    private void hanleEventResult0(EventResult eventResult) throws Exception {
        int eventType = eventResult.event_type;
        boolean createLog = false;
        if (eventType == 80) {
            int levelMediumTimes = this.getNotifyTimes("personStayAlarmMediumAfterTimes");
            int levelHighTimes = this.getNotifyTimes("personStayAlarmHighAfterTimes");
            List<EventResultEntry> list = this.getEventResultEntryList(80);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry == null) {
                entry = this.addNewEventResult(eventResult, list, createLog, 2, 0, 2);
            } else {
                this.updateNewEventResult(eventResult, entry, levelMediumTimes, levelHighTimes);
            }
            this.notifyEvent(entry, levelMediumTimes, levelHighTimes);
        } else if (eventType == 73) {
            List<EventResultEntry> list = this.getEventResultEntryList(80);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
        } else if (eventType == 112) {
            int levelMediumTimes = this.getNotifyTimes("nonMotorStayAlarmMediumAfterTimes");
            int levelHighTimes = this.getNotifyTimes("nonMotorStayAlarmHighAfterTimes");
            List<EventResultEntry> list = this.getEventResultEntryList(112);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry == null) {
                entry = this.addNewEventResult(eventResult, list, createLog, 3, 0, 2);
            } else {
                this.updateNewEventResult(eventResult, entry, levelMediumTimes, levelHighTimes);
            }
            this.notifyEvent(entry, levelMediumTimes, levelHighTimes);
        } else if (eventType == 113) {
            List<EventResultEntry> list = this.getEventResultEntryList(112);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
        } else if (eventType == 144) {
            int levelMediumTimes = this.getNotifyTimes("vehicleJamAlarmMediumAfterTimes");
            int levelHighTimes = this.getNotifyTimes("vehicleJamAlarmHighAfterTimes");
            List<EventResultEntry> list = this.getEventResultEntryList(144);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry == null) {
                entry = this.addNewEventResult(eventResult, list, createLog, 4, 0, 2);
            } else {
                this.updateNewEventResult(eventResult, entry, levelMediumTimes, levelHighTimes);
            }
            this.notifyEvent(entry, levelMediumTimes, levelHighTimes);
        } else if (eventType == 145) {
            List<EventResultEntry> list = this.getEventResultEntryList(144);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
        } else if (eventType == 81) {
            int levelMediumTimes = this.getNotifyTimes("vehicleStayAlarmMediumAfterTimes");
            int levelHighTimes = this.getNotifyTimes("vehicleStayAlarmHighAfterTimes");
            List<EventResultEntry> list = this.getEventResultEntryList(81);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry == null) {
                entry = this.addNewEventResult(eventResult, list, createLog, 5, 0, 2);
            } else {
                this.updateNewEventResult(eventResult, entry, levelMediumTimes, levelHighTimes);
            }
            if (this.isEnableGroundStatusDetect()) {
                VehiclePassEvent passEvent = this.createVehiclePassEvent(eventResult);
                if (passEvent != null) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(passEvent);
                }
                this.cancelAutoDownPoleWhenNoCar();
            }
            this.notifyEvent(entry, levelMediumTimes, levelHighTimes);
        } else if (eventType == 82) {
            List<EventResultEntry> list;
            EventResultEntry entry;
            VehiclePassEvent passEvent;
            boolean enableGroundStatusDetect = this.isEnableGroundStatusDetect();
            if (enableGroundStatusDetect && (passEvent = this.createVehiclePassEvent(eventResult)) != null) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(passEvent);
            }
            if ((entry = this.findSameGroupIdEntry(eventResult.group_id, list = this.getEventResultEntryList(81))) != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
            if (enableGroundStatusDetect) {
                this.startCheckAutoDownPoleWhenNoCar(6000L);
            }
        } else if (eventType == 83) {
            if (this.isEnableGroundStatusDetect()) {
                VehiclePassEvent passEvent = this.createVehiclePassEvent(eventResult);
                if (passEvent != null) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(passEvent);
                }
                this.startCheckAutoDownPoleWhenNoCar(6000L);
            }
        } else if (eventType == 84) {
            boolean enableGroundStatusDetect = this.isEnableGroundStatusDetect();
            if (enableGroundStatusDetect) {
                String vehicleTurnBackHandleType = this.equipment.getEquipmentConfig().getConfigValue("vehicleTurnBackHandleType");
                if (vehicleTurnBackHandleType == null || vehicleTurnBackHandleType.length() == 0) {
                    vehicleTurnBackHandleType = Constants.YES_STR;
                }
                if (Constants.YES_STR.equals(vehicleTurnBackHandleType)) {
                    VehiclePassEvent passEvent = this.createVehiclePassEvent(eventResult);
                    if (passEvent != null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(passEvent);
                    } else {
                        this.tipEventResult(eventResult);
                    }
                } else {
                    this.tipEventResult(eventResult);
                }
            } else {
                this.tipEventResult(eventResult);
            }
            if (enableGroundStatusDetect) {
                this.startCheckAutoDownPoleWhenNoCar(6000L);
            }
        } else if (eventType == 129) {
            this.setRoadBarrierState(EquipmentState.BARRIER_RAISED_IN_PLACE);
            int levelMediumTimes = this.getNotifyTimes("gatePoleAlarmMediumAfterTimes");
            int levelHighTimes = this.getNotifyTimes("gatePoleAlarmHighAfterTimes");
            eventResult.group_id = 0L;
            List<EventResultEntry> list = this.getEventResultEntryList(129);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry == null) {
                entry = this.addNewEventResult(eventResult, list, createLog, 6, 0, 1);
            } else {
                this.updateNewEventResult(eventResult, entry, levelMediumTimes, levelHighTimes);
            }
        } else if (eventType == 131) {
            this.setRoadBarrierState(EquipmentState.BARRIER_RAISED_IN_PLACE);
        } else if (eventType == 130) {
            this.setRoadBarrierState(EquipmentState.BARRIER_DROPPED_IN_PLACE);
            eventResult.group_id = 0L;
            List<EventResultEntry> list = this.getEventResultEntryList(129);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
        } else if (eventType == 129) {
            this.setRoadBarrierState(EquipmentState.BARRIER_DROPPED_IN_PLACE);
            eventResult.group_id = 0L;
            List<EventResultEntry> list = this.getEventResultEntryList(129);
            EventResultEntry entry = this.findSameGroupIdEntry(eventResult.group_id, list);
            if (entry != null) {
                this.finishEvent(eventResult, entry, list, 100);
            }
        } else {
            ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "] \u7ed9\u4e86\u4e00\u4e2a\u6682\u4e0d\u652f\u6301\u7684\u4e8b\u4ef6\u7c7b\u578b:  " + eventType));
        }
    }

    private void startCheckAutoDownPoleWhenNoCar(long delay) {
        this.cancelAutoDownPoleWhenNoCar();
        if (delay > 0L) {
            long mills = this.getAutoDownloadMills();
            if (mills > 0L && !this.haveCar()) {
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)this.checkAutoDownloadTaskKey, (Object)this.checkAutoDownloadTaskKey, new TimeoutObjectPool.TimeoutCallback(){

                    public void onTimeout(Object key, Object value) throws Exception {
                        ZSRGCameraAction.this.singleThreadRunQueue.submit(new Runnable(){

                            @Override
                            public void run() {
                                ZSRGCameraAction.this.checkAndDownloadPole();
                            }
                        });
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.checkAndDownloadPole();
        }
    }

    private void checkAndDownloadPole() {
        PassChannel passChannel;
        ICECameraRoadGateAction roadAction;
        long mills;
        if (this.isEnableGroundStatusDetect() && (mills = this.getAutoDownloadMills()) > 0L && !this.haveCar() && (roadAction = this.getRoadBarrierStateAction()) != null && roadAction.isSupportBarrierStateDetected() && (roadAction.getEquipmentState() == EquipmentState.BARRIER_RAISED_IN_PLACE || roadAction.getEquipmentState() == EquipmentState.BARRIER_RAISING) && (passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(this.getChannelNo())) != null && passChannel.getLanConnectManageHostState() == null && !roadAction.isAlwaysOpen()) {
            roadAction.doDownPoleAction();
            ServiceLog.getLog().info((Object)"\u68c0\u6d4b\u5230\u8f66\u8f86\u79bb\u5f00\u8bc6\u522b\u533a\u540e\uff0c\u6ca1\u6709\u4efb\u4f55\u8f66\u8f86\uff0c\u9053\u95f8\u6746\u5f53\u524d\u662f\u5f00\u5230\u4f4d, \u9053\u95f8\u672a\u8bbe\u7f6e\u5e38\u5f00, \u8fd9\u5c06\u53d1\u9001\u843d\u6746\u6307\u4ee4");
        }
    }

    private void cancelAutoDownPoleWhenNoCar() {
        ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this.checkAutoDownloadTaskKey);
    }

    private long getAutoDownloadMills() {
        String v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(this.getChannelNo(), "CHANNEL_POLE_DOWN_TIMEOUT");
        if (v != null && v.length() > 0) {
            try {
                int a = Integer.parseInt(v);
                if (a > 0) {
                    return (long)a * 1000L;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    private String getChannelNo() {
        List<String> list = this.equipment.getChannelNos();
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRoadBarrierState(EquipmentState state) {
        ICECameraRoadGateAction action;
        Object object = this.roadBarrierStateLock;
        synchronized (object) {
            this.roadBarrierState = state;
            this.roadBarrierStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
        }
        if (this.isEnableGateStatusDetect() && (action = this.getRoadBarrierStateAction()) != null) {
            boolean hasIoConn = false;
            RoadBarrierAction rAction = action.getRealRoadBarrierAction();
            if (rAction != null && rAction != action && rAction instanceof RoadBarrierStateSupport && ((RoadBarrierStateSupport)((Object)rAction)).isSupportBarrierStateDetected()) {
                hasIoConn = true;
            }
            if (!hasIoConn) {
                List<String> channelNos = this.equipment.getChannelNos();
                action.setPoleSate(state, null, channelNos == null || channelNos.isEmpty() ? null : channelNos.get(0));
            }
        }
    }

    public ICECameraRoadGateAction getRoadBarrierStateAction() {
        ICECameraRoadGateAction gateAction = null;
        List<String> list = this.equipment.getChannelNos();
        if (list != null && !list.isEmpty()) {
            String channelNo = list.get(0);
            Collection<Equipment> cl = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(9);
            if (cl != null) {
                for (Equipment eq : cl) {
                    List<String> list0 = eq.getChannelNos();
                    if (list0 == null || !list0.contains(channelNo) || !(eq.getEquipmentAction() instanceof ICECameraRoadGateAction)) continue;
                    if (gateAction == null) {
                        gateAction = (ICECameraRoadGateAction)eq.getEquipmentAction();
                        continue;
                    }
                    if (eq.getName().compareTo(gateAction.getEquipment().getName()) >= 0) continue;
                    gateAction = (ICECameraRoadGateAction)eq.getEquipmentAction();
                }
            }
        }
        return gateAction;
    }

    private VehiclePassEvent createVehiclePassEvent(EventResult eventResult) {
        int passEventType;
        if (eventResult.plateError) {
            return null;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || channelNos.isEmpty()) {
            return null;
        }
        int eventType = eventResult.event_type;
        if (eventType == 81) {
            passEventType = 0;
        } else if (eventType == 82) {
            passEventType = 3;
        } else if (eventType == 83) {
            passEventType = 1;
        } else if (eventType == 84) {
            passEventType = 2;
        } else {
            return null;
        }
        VehiclePassEvent passEvent = new VehiclePassEvent(this.equipment, channelNos.get(0));
        passEvent.setEventPassId(eventResult.group_id);
        passEvent.setEventType(passEventType);
        passEvent.setRevNonTimeMills(eventResult.revNonTimeMills);
        passEvent.setRevSysTimeMills(eventResult.revSysTimeMills);
        Date deviceTime = null;
        if (eventResult.time != null && eventResult.time.length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                deviceTime = df.parse(eventResult.time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deviceTime != null) {
            passEvent.setRevDeviceMills(deviceTime.getTime());
        } else {
            passEvent.setRevDeviceMills(eventResult.revSysTimeMills);
        }
        if (eventResult.plateNumber == null || eventResult.plateNumber.length() == 0) {
            if (eventType == 81) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6\u8fd4\u56de\u7a7a\u8f66\u724c\u53f7, \u8fd9\u5c06\u5f53\u6210\u65e0\u724c\u8f66\u5904\u7406"));
            } else if (eventType == 82) {
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6\u8fd4\u56de\u7a7a\u8f66\u724c\u53f7, \u8fd9\u5c06\u5f53\u6210\u65e0\u724c\u8f66\u5904\u7406"));
            } else if (eventType == 83) {
                passEventType = 1;
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u901a\u8fc7\u4e8b\u4ef6\u8fd4\u56de\u7a7a\u8f66\u724c\u53f7, \u8fd9\u5c06\u5f53\u6210\u65e0\u724c\u8f66\u5904\u7406"));
            } else if (eventType == 84) {
                passEventType = 2;
                ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6298\u8fd4\u4e8b\u4ef6\u8fd4\u56de\u7a7a\u8f66\u724c\u53f7, \u8fd9\u5c06\u5f53\u6210\u65e0\u724c\u8f66\u5904\u7406"));
            }
            passEvent.setPlateNumber("\u65e0\u724c\u8f66");
        } else {
            if (eventResult.plateNumber.length() >= 10) {
                if (eventType == 81) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6\u8fd4\u56de\u9519\u8bef\u7684\u8f66\u724c\u53f7: " + eventResult.plateNumber + ", \u8fd9\u5c06\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u4e8b\u4ef6"));
                } else if (eventType == 82) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6ede\u7559\u4e8b\u4ef6\u8fd4\u56de\u9519\u8bef\u7684\u8f66\u724c\u53f7: " + eventResult.plateNumber + ", \u8fd9\u5c06\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u4e8b\u4ef6"));
                } else if (eventType == 83) {
                    passEventType = 1;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u901a\u8fc7\u4e8b\u4ef6\u8fd4\u56de\u9519\u8bef\u7684\u8f66\u724c\u53f7: " + eventResult.plateNumber + ", \u8fd9\u5c06\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u4e8b\u4ef6"));
                } else if (eventType == 84) {
                    passEventType = 2;
                    ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + " (" + this.equipment.getIp() + ") \u8f66\u8f86\u6298\u8fd4\u4e8b\u4ef6\u8fd4\u56de\u9519\u8bef\u7684\u8f66\u724c\u53f7: " + eventResult.plateNumber + ", \u8fd9\u5c06\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u4e8b\u4ef6"));
                }
                return null;
            }
            passEvent.setPlateNumber(eventResult.plateNumber);
        }
        passEvent.setPlateColor(eventResult.plateColor);
        if (eventResult.confidence != null) {
            passEvent.setPlateConfidence(Float.valueOf(eventResult.confidence.floatValue()));
        }
        if (eventResult.plateType != null && eventResult.plateType.length() > 0) {
            passEvent.setPlateType(0);
            passEvent.setPlateTypeDes(eventResult.plateType);
        }
        passEvent.setPicFormatType(eventResult.bigImgType);
        passEvent.setPicData(eventResult.bigImgData);
        passEvent.setPlateSmallPicFormatType(eventResult.smallImageType);
        passEvent.setPlateSmallPicData(eventResult.smallImgData);
        return passEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveCar() {
        List<EventResultEntry> list;
        List<EventResultEntry> list2 = list = this.getEventResultEntryList(81);
        synchronized (list2) {
            block4: {
                if (list.isEmpty()) break block4;
                EventResultEntry last = list instanceof LinkedList ? (EventResultEntry)((LinkedList)list).peekLast() : list.get(list.size() - 1);
                if (last.end != null || last.flagClosedMills != null || last.latest == null || ServiceUtil.getServiceContext().currentTimeMillis() - last.latest.revNonTimeMills >= 12000L) break block4;
                return true;
            }
        }
        return false;
    }

    public boolean isEnableGroundStatusDetect() {
        return Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("groundStatusDetect"));
    }

    public boolean isEnableGateStatusDetect() {
        return Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("gateStatusDetect"));
    }

    private Map<Long, ZSCameraImageEntry> paresePic(byte[] data, int offset) {
        if (data == null || data.length == 0 || offset < 0 || data.length <= offset) {
            return Collections.emptyMap();
        }
        HashMap<Long, ZSCameraImageEntry> rMap = new HashMap<Long, ZSCameraImageEntry>();
        int headLength = 12;
        while (offset < data.length) {
            if (data.length < offset + headLength) {
                ServiceLog.getLog().warn((Object)"\u56fe\u7247\u5934\u6570\u636e\u89e3\u6790\u9519\u8bef");
                break;
            }
            if (data[offset++] != 86) {
                ServiceLog.getLog().warn((Object)"\u56fe\u7247\u5934\u6570\u636e\u89e3\u6790\u9519\u8bef");
                break;
            }
            if (data[offset++] != 90) {
                ServiceLog.getLog().warn((Object)"\u56fe\u7247\u5934\u6570\u636e\u89e3\u6790\u9519\u8bef");
                break;
            }
            ZSCameraImageEntry e = new ZSCameraImageEntry();
            e.image_type = (data[offset + 1] & 0xFF) << 8;
            e.image_type |= data[offset] & 0xFF;
            long image_id = (long)BytesTool.bytesToIntL((byte[])data, (int)(offset += 2)) & 0xFFFFFFFFL;
            int image_length = BytesTool.bytesToIntL((byte[])data, (int)(offset += 4));
            if (image_length < 0) {
                ServiceLog.getLog().warn((Object)"\u56fe\u7247\u6570\u636e\u89e3\u6790\u9519\u8bef");
                break;
            }
            int image_offset = offset += 4;
            if ((offset += image_length) > data.length) {
                ServiceLog.getLog().warn((Object)"\u56fe\u7247\u5934\u6570\u636e\u89e3\u6790\u9519\u8bef");
                break;
            }
            if (image_length > 0) {
                e.data = new byte[image_length];
                System.arraycopy(data, image_offset, e.data, 0, image_length);
                rMap.put(image_id, e);
            }
            if (offset == data.length) break;
        }
        return rMap;
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "VzLPRSDK.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "VzLPRSDK.so";
        }
        return "VzLPRSDK.dll";
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = ZSRGCameraAction.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSRGCameraAction.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = ZSRGCameraAction.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSRGCameraAction.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752864\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/VzLPRSDK/" + ZSRGCameraAction.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)(String.valueOf(this.equipment.getIp()) + ": \u4f7f\u752832\u4f4d\u89c6\u9891\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u65e0\u6cd5\u627e\u5230\u76f8\u673a\u89c6\u9891\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u76f8\u673a\u89c6\u9891\u65e0\u6cd5\u663e\u793a!!!!"));
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private void nativeDisConnect() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "[" + this.equipment.getIp() + "]\u5173\u95ed\u76f8\u673a\u8fde\u63a5";
        String serviceName = "disConnect";
        long timeoutMills = 3000L;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    private OperationFuture<Integer> registerIfNeed() {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        String opName = "\u8fde\u63a5\u76f8\u673a[" + this.equipment.getIp() + "]";
        String serviceName = "connectIfNotConnect";
        long timeoutMills = 10000L;
        this.setNativeReusetParam(paramMap);
        return this.getLocalProcessTransport().doRemoteService(ACTION_NAME, serviceName, paramMap, timeoutMills, opName);
    }

    private void setNativeReusetParam(Map<String, String> paramMap) {
        String userPwd;
        paramMap.put("cameraId", this.equipment.getEquipmentNo());
        paramMap.put("ip", this.equipment.getIp());
        paramMap.put("port", "80");
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String userName = config.getConfigValue("login_user");
        if (userName == null || userName.length() == 0) {
            userName = "admin";
        }
        if ((userPwd = config.getConfigValue("login_pwd")) == null || userPwd.length() == 0) {
            userPwd = "admin";
        }
        paramMap.put("userName", userName);
        paramMap.put("userPwd", userPwd);
        Long x = this.hwnd;
        if (x != null) {
            paramMap.put("componentID", x.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectIfNotConnected1() {
        Object object = this.closeJobLock;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
        }
        String ip = this.equipment.getIp();
        if (ip == null || ip.length() == 0) {
            return;
        }
        OperationFuture<Integer> f = this.getLocalProcessTransport().loadNativeDriveIfNeed("com.wovoe.camera.drive.zs.Drive", "\u52a0\u8f7dZS\u76f8\u673a\u672c\u5730\u9a71\u52a8");
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> xd) {
                if (xd.getException() == null && xd.getResult() != null && (Integer)xd.getResult() == 0) {
                    OperationFuture opf = ZSRGCameraAction.this.registerIfNeed();
                    opf.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void operationComplete(OperationFuture<Integer> f6) {
                            if (f6.getException() == null && f6.getResult() != null && (Integer)f6.getResult() == 0) {
                                ZSRGCameraAction.this.nativeConnectErrorCounter = 0;
                            } else if (!ZSRGCameraAction.this.isWorkingProperly()) {
                                ZSRGCameraAction.this.nativeConnectErrorCounter = 0;
                            } else {
                                ZSRGCameraAction zSRGCameraAction = ZSRGCameraAction.this;
                                zSRGCameraAction.nativeConnectErrorCounter = zSRGCameraAction.nativeConnectErrorCounter + 1;
                                if (ZSRGCameraAction.this.nativeConnectErrorCounter >= 2) {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSRGCameraAction.this.equipment.getName()) + "[" + ZSRGCameraAction.this.equipment.getIp() + "] TCP\u80fd\u8fde\u63a5\u4e0a\uff01\u4f46\u662f\u4f7f\u7528\u76f8\u673a\u5382\u5546SDK\u65e0\u6cd5\u8fde\u63a5\u6b64\u76f8\u673a! SDK\u4f30\u8ba1\u51fa\u73b0\u9519\u8bef! \u8fd9\u5c06\u5c1d\u8bd5\u91cd\u542fSDK, \u8fd9\u4f1a\u5f71\u54cd\u89c6\u9891\u663e\u793a\uff0c \u5e76\u4e0d\u4f1a\u5f71\u54cd\u9884\u8b66"));
                                    ZSRGCameraAction.this.getLocalProcessTransport().tryRestart();
                                } else {
                                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSRGCameraAction.this.equipment.getName()) + "[" + ZSRGCameraAction.this.equipment.getIp() + "] TCP\u80fd\u8fde\u63a5\u4e0a\uff01\u4f46\u662f\u4f7f\u7528\u76f8\u673a\u5382\u5546SDK\u65e0\u6cd5\u8fde\u63a5\u6b64\u76f8\u673a! SDK\u95ee\u9898\uff1f\u7a0d\u540e\u91cd\u65b0\u68c0\u6d4b..."));
                                }
                            }
                        }

                        public void waitCompleteTimeout() {
                        }
                    });
                }
            }
        });
    }

    public void exceptionCaught(IoSession session, Throwable e) throws Exception {
        try {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": " + e));
        }
        finally {
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        IoBuffer buf = (IoBuffer)message;
        if (buf == null) {
            return;
        }
        ZSCameraTcpProtocol protocol = (ZSCameraTcpProtocol)session.getAttribute((Object)ZSCameraTcpProtocolName);
        protocol.parse(buf, this);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        ServiceLog.getLog().info((Object)("Lost connection with\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]"));
        this.roadBarrierState = EquipmentState.DISCONNECTED;
        this.roadBarrierStateMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus arg1) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private <R> OperationFuture<R> send(final String opName, IoSession session, ZSCameraTcpProtocol.ZSCameraPackage p, final WaitResponseKey waitResponseKey, ResponseHandler<R> handler, long waitMills) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.addCompleteListener(new OperationFuture.CompleteListener<R>(){

            public void operationComplete(OperationFuture<R> f1) {
                if (f1.getException() != null) {
                    ServiceLog.getLog().warn((Object)(String.valueOf(ZSRGCameraAction.this.equipment.getName()) + "[" + ZSRGCameraAction.this.equipment.getIp() + "]: " + opName + " error: " + f1.getException()));
                }
            }

            public void waitCompleteTimeout() {
                ServiceLog.getLog().warn((Object)(String.valueOf(ZSRGCameraAction.this.equipment.getName()) + "[" + ZSRGCameraAction.this.equipment.getIp() + "]: " + opName + " timeout"));
            }
        });
        if (session == null || !session.isConnected() || session.isClosing()) {
            f.setException((Throwable)new IOException("session is invalid! unconnected!"));
            return f;
        }
        try {
            IoBuffer buf = ZSCameraTcpProtocol.toSendBuf(p);
            if (waitResponseKey != null && handler != null) {
                handler.opName = opName;
                KeyValueEntry entry = new KeyValueEntry((Object)f, handler);
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)waitResponseKey, (Object)entry, handler, waitMills, TimeUnit.MILLISECONDS);
                WriteFuture wf = session.write((Object)buf);
                wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture s) {
                        if (s.isDone() && s.getException() != null) {
                            try {
                                KeyValueEntry entry = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey);
                                if (entry != null) {
                                    ((OperationFutureHandler)entry.getKey()).setException(s.getException());
                                }
                            }
                            finally {
                                if (s.getSession() != null && s.getSession().isConnected() && !s.getSession().isClosing()) {
                                    s.getSession().close(true);
                                }
                            }
                        }
                    }
                });
            } else {
                WriteFuture wf = session.write((Object)buf);
                wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                    public void operationComplete(WriteFuture s) {
                        if (s.isDone()) {
                            if (s.getException() != null) {
                                try {
                                    f.setException(s.getException());
                                }
                                finally {
                                    if (s.getSession() != null && s.getSession().isConnected() && !s.getSession().isClosing()) {
                                        s.getSession().close(true);
                                    }
                                }
                            } else {
                                Integer v = s.isWritten() ? Integer.valueOf(0) : Integer.valueOf(1);
                                f.setResult((Object)v);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            f.setException((Throwable)ex);
        }
        return f;
    }

    private byte getSendSeq() {
        int seq1 = Math.abs(this.seqFac.incrementAndGet());
        return (byte)(seq1 % 256);
    }

    private int getIdSeq() {
        return Math.abs(this.idseq.incrementAndGet());
    }

    private static Integer getInteger(Map<?, ?> dataMap, String key) {
        if (dataMap == null) {
            return null;
        }
        Object obj = dataMap.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            String v = (String)obj;
            if (v.length() == 0) {
                return null;
            }
            return Integer.valueOf(v);
        }
        return Integer.valueOf(obj.toString());
    }

    @Override
    public void handlerPackage(ZSCameraTcpProtocol.ZSCameraPackage p) throws Exception {
        KeyValueEntry entry;
        WaitResponseKey waitResponseKey = null;
        Map dataMap = null;
        boolean useThread = false;
        if (p.isHeartBeat()) {
            this.lastRevHeartBeat = ServiceUtil.getServiceContext().currentTimeMillis();
            waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), "", RESP_FIELD_HEARTBEAT, this.equipment.getEquipmentNo());
            HashMap<String, Object> dataMap1 = new HashMap<String, Object>();
            dataMap1.put(RESP_FIELD_CMD, RESP_FIELD_HEARTBEAT);
            dataMap1.put(RESP_FIELD_STATE_CODE, 200);
            dataMap = dataMap1;
        } else {
            int jsonEndIndx = -1;
            int jsonFinish = 0;
            int end = p.getDataOffset() + p.getDataLen();
            int i = p.getDataOffset();
            while (i < end) {
                byte bz = p.getData()[i];
                if (bz == 123) {
                    ++jsonFinish;
                } else if (bz == 125 && --jsonFinish == 0) {
                    jsonEndIndx = i + 1;
                    break;
                }
                ++i;
            }
            int jsonEndLen = jsonEndIndx != -1 ? jsonEndIndx - p.getDataOffset() : p.getDataLen();
            String chaset = "UTF-8";
            String json = new String(p.getData(), p.getDataOffset(), jsonEndLen, chaset);
            if (ZSRGCameraAction.isCmd(json, JSON_CMD_common_alarm_result)) {
                int dataEnd = p.getDataLen() + p.getDataOffset();
                int pigBeginIndex = -1;
                int i2 = jsonEndIndx;
                while (i2 < dataEnd) {
                    if (p.getData()[i2] == 0) {
                        pigBeginIndex = i2;
                        break;
                    }
                    ++i2;
                }
                this.handleEnvent(p, json, pigBeginIndex + 1);
            } else if (!ZSRGCameraAction.isCmd(json, JSON_CMD_close_socket)) {
                try {
                    dataMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(json, LinkedHashMap.class);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u8fd4\u56de\u4e86\u4e00\u4e2a\u4e0d\u662fjson\u7684\u6570\u636e:  " + json));
                    return;
                }
                String cmd = (String)dataMap.get(RESP_FIELD_CMD);
                if (cmd == null || cmd.length() == 0) {
                    if (json.length() > 2) {
                        ServiceLog.getLog().warn((Object)("\u76f8\u673a\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "]\u54cd\u5e94json\u7f3a\u5c11cmd! json:" + json));
                    }
                    return;
                }
                Object id = dataMap.get(RESP_FIELD_ID);
                String idstr = id != null ? id.toString() : null;
                waitResponseKey = new WaitResponseKey(p.getSeq(), p.getDataType(), idstr, cmd, this.equipment.getEquipmentNo());
            }
        }
        if (waitResponseKey != null && dataMap != null && (entry = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitResponseKey)) != null) {
            HashMap<String, Object> responseMap = dataMap;
            this.handleResponseZS0(responseMap, (KeyValueEntry<OperationFutureHandler<Object>, ResponseHandler<Object>>)entry, useThread);
        }
    }

    private static boolean isCmd(String json, String cmdValue) {
        if (json == null || json.length() == 0 || cmdValue == null || cmdValue.length() == 0) {
            return false;
        }
        int h = json.indexOf(cmdValue);
        if (h == -1) {
            return false;
        }
        String x = json.substring(0, h).trim();
        if (x.charAt(x.length() - 1) != ':') {
            return false;
        }
        return (x = x.substring(0, x.length() - 1).trim()).endsWith(JSON_RESP_FIELD_CMD);
    }

    private void handleResponseZS0(final Map<?, ?> responseMap, final KeyValueEntry<OperationFutureHandler<Object>, ResponseHandler<Object>> entry, boolean async) {
        if (async) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    ZSRGCameraAction.this.handleResponseZS1(responseMap, (KeyValueEntry<OperationFutureHandler<Object>, ResponseHandler<Object>>)entry);
                }
            });
        } else {
            this.handleResponseZS1(responseMap, entry);
        }
    }

    private void handleResponseZS1(Map<?, ?> responseMap, KeyValueEntry<OperationFutureHandler<Object>, ResponseHandler<Object>> entry) {
        try {
            try {
                try {
                    Integer state_code = ZSRGCameraAction.getInteger(responseMap, RESP_FIELD_STATE_CODE);
                    if (state_code == null || state_code != 200) {
                        String opName = ((ResponseHandler)entry.getValue()).opName;
                        if (opName == null) {
                            opName = "";
                        }
                        ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "[" + this.equipment.getIp() + "] Return error! " + responseMap + ", Operation: " + opName));
                    }
                }
                catch (Exception state_code) {
                    Object result = ((ResponseHandler)entry.getValue()).handler(responseMap);
                    ((OperationFutureHandler)entry.getKey()).setResult(result);
                }
            }
            finally {
                Object result = ((ResponseHandler)entry.getValue()).handler(responseMap);
                ((OperationFutureHandler)entry.getKey()).setResult(result);
            }
        }
        catch (Exception ex) {
            ((OperationFutureHandler)entry.getKey()).setException((Throwable)ex);
        }
    }

    @Override
    public boolean isConnGround(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        return this.isEnableGateStatusDetect();
    }

    @Override
    public boolean isGroundPressure(String channelNo) {
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        List<String> channelNos = this.equipment.getChannelNos();
        if (channelNos == null || !channelNos.contains(channelNo)) {
            return false;
        }
        return this.haveCar();
    }

    @Override
    public boolean isPassDetectedSupported() {
        return this.isEnableGroundStatusDetect();
    }

    public boolean isNeedHandleEvent() {
        List<String> list = this.equipment.getChannelNos();
        boolean r = false;
        if (list != null) {
            for (String channelNo : list) {
                boolean bl = r = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) != null;
                if (r) break;
            }
        }
        return r;
    }

    static class EventResult {
        int rule_id;
        int event_type;
        long group_id;
        long result_id;
        String time;
        int bigImgType;
        byte[] bigImgData;
        int smallImageType;
        byte[] smallImgData;
        String plateColor;
        String plateNumber;
        boolean plateError;
        Integer confidence;
        Integer plateWidth;
        String plateType;
        long revSysTimeMills;
        long revNonTimeMills;

        public EventResult copy() {
            EventResult r = new EventResult();
            r.rule_id = this.rule_id;
            r.event_type = this.event_type;
            r.group_id = this.group_id;
            r.result_id = this.result_id;
            r.time = this.time;
            r.bigImgType = this.bigImgType;
            r.bigImgData = this.bigImgData;
            r.smallImageType = this.smallImageType;
            r.smallImgData = this.smallImgData;
            r.plateColor = this.plateColor;
            r.plateNumber = this.plateNumber;
            r.plateError = this.plateError;
            r.confidence = this.confidence;
            r.plateWidth = this.plateWidth;
            r.plateType = this.plateType;
            r.revSysTimeMills = this.revSysTimeMills;
            r.revNonTimeMills = this.revNonTimeMills;
            return r;
        }

        private EventResult() {
        }

        public EventResult(int ruleId, ZSRGEvent.Result r, ZSCameraImageEntry bigImage, ZSCameraImageEntry smallImage) {
            this.rule_id = ruleId;
            this.revSysTimeMills = System.currentTimeMillis();
            this.revNonTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.event_type = r.getEvent_type();
            this.group_id = r.getGroup_id();
            this.result_id = r.getResult_id();
            this.time = r.getTime();
            if (bigImage != null) {
                this.bigImgType = bigImage.image_type;
                this.bigImgData = bigImage.data;
            }
            if (smallImage != null) {
                this.smallImageType = smallImage.image_type;
                this.smallImgData = smallImage.data;
            }
            if (r.getPlate_result() != null) {
                if (r.getPlate_result().getColor_type() != null && r.getPlate_result().getColor_type().length() > 0) {
                    try {
                        this.plateColor = new String(Base64.getDecoder().decode(r.getPlate_result().getColor_type()), "UTF-8");
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u89e3\u6790\u8f66\u724c\u989c\u8272\u4fe1\u606f\u5f02\u5e38 " + r.getPlate_result().getColor_type()));
                    }
                }
                if (r.getPlate_result().getLicense() != null && r.getPlate_result().getLicense().length() > 0) {
                    try {
                        this.plateNumber = new String(Base64.getDecoder().decode(r.getPlate_result().getLicense()), "UTF-8");
                    }
                    catch (Exception ex) {
                        this.plateError = true;
                        ServiceLog.getLog().warn((Object)("\u89e3\u6790\u8f66\u724c\u53f7\u4fe1\u606f\u5f02\u5e38 " + r.getPlate_result().getLicense()));
                    }
                }
                if (r.getPlate_result().getType() != null && r.getPlate_result().getType().length() > 0) {
                    try {
                        this.plateType = new String(Base64.getDecoder().decode(r.getPlate_result().getType()), "UTF-8");
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u89e3\u6790\u8f66\u724c\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38 " + r.getPlate_result().getType()));
                    }
                }
                if (r.getPlate_result().getConfidence() != null) {
                    this.confidence = r.getPlate_result().getConfidence();
                }
                if (r.getPlate_result().getPlate_true_width() != null) {
                    this.plateWidth = r.getPlate_result().getPlate_true_width();
                }
            }
        }
    }

    private static class EventResultEntry {
        EventResult start;
        EventResult latest;
        EventResult end;
        int revTimes;
        Long dbLogId;
        volatile Long cloudId;
        Long flagClosedMills;
        String startBigImagePath;
        String lastestPlateNumber;
        String lastestBigImagePath;
        String latestSmallImagePath;
        int level;
        long tipEndMills;
        volatile boolean notifyCloudAlarm;
        volatile boolean notifyCloudFinish;

        private EventResultEntry() {
        }
    }

    private static class OPResponseHandler
    extends ResponseHandler<Integer> {
        private OPResponseHandler() {
        }

        @Override
        public Integer handler(Map<?, ?> responseMap) throws Exception {
            return this.getOpCode(responseMap);
        }
    }

    private static class ResponseHandler<R>
    implements TimeoutObjectPool.TimeoutCallback {
        public String opName;

        private ResponseHandler() {
        }

        public R handler(Map<?, ?> responseMap) throws Exception {
            return (R)responseMap;
        }

        protected int getOpCode(Map<?, ?> responseMap) {
            if (responseMap == null) {
                return -1;
            }
            Integer state_code = ZSRGCameraAction.getInteger(responseMap, ZSRGCameraAction.RESP_FIELD_STATE_CODE);
            if (state_code == null) {
                return -1;
            }
            if (state_code == 200) {
                return 0;
            }
            if (state_code == 0) {
                return -2;
            }
            return state_code;
        }

        public void onTimeout(Object key, Object value) throws Exception {
            if (value != null && value instanceof KeyValueEntry) {
                KeyValueEntry entry = (KeyValueEntry)value;
                ((OperationFutureHandler)entry.getKey()).setException((Throwable)new TimeoutException("Waiting for camera response timeout!"));
            }
        }
    }

    private static class WaitResponseKey {
        private byte seq;
        private byte dataType;
        private String id;
        private String cmd;
        private String eqNo;

        public WaitResponseKey(byte seq, byte dataType, String id, String cmd, String eqNo) {
            this.seq = seq;
            this.dataType = dataType;
            this.id = id;
            this.cmd = cmd;
            this.eqNo = eqNo;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + this.dataType;
            result = 31 * result + (this.eqNo == null ? 0 : this.eqNo.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + this.seq;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitResponseKey other = (WaitResponseKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.dataType != other.dataType) {
                return false;
            }
            if (this.eqNo == null ? other.eqNo != null : !this.eqNo.equals(other.eqNo)) {
                return false;
            }
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return this.seq == other.seq;
        }
    }

    private static class ZSCameraImageEntry {
        int image_type;
        byte[] data;

        private ZSCameraImageEntry() {
        }
    }
}

