/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.wovoe.carpark.equipment.onvif.OnvifClient;
import com.wovoe.carpark.equipment.onvif.OnvifClientFactory;
import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifDeviceClient;
import com.wovoe.carpark.equipment.onvif.OnvifExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.internal.Util;

public class DefaultOnvifClientFactory
implements OnvifClientFactory {
    private ExecutorService executorService;
    private ConnectionPool connectionPool;

    public DefaultOnvifClientFactory() {
        this.connectionPool = new ConnectionPool();
        this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkHttp Dispatcher", (boolean)false));
    }

    public DefaultOnvifClientFactory(ExecutorService executorService, ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.executorService = executorService;
    }

    @Override
    public OnvifClient createOnvifClient(OnvifDevice onvifDevice) {
        OnvifExecutor onvifExecutor = new OnvifExecutor(this.executorService, this.connectionPool);
        OnvifDeviceClient client = new OnvifDeviceClient(onvifExecutor, onvifDevice);
        return client;
    }

    public void destroy() {
        this.executorService.shutdown();
        this.connectionPool.evictAll();
    }
}

