/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfile;
import com.wovoe.carpark.equipment.onvif.OnvifMediaStreamUriListener;
import com.wovoe.carpark.equipment.onvif.OnvifRequest;
import com.wovoe.carpark.equipment.onvif.OnvifResponseListener;
import com.wovoe.carpark.equipment.onvif.OnvifType;

public class GetMediaStreamUriRequest
implements OnvifRequest {
    private final OnvifMediaProfile mediaProfile;
    private final OnvifMediaStreamUriListener listener;

    public GetMediaStreamUriRequest(OnvifMediaProfile mediaProfile, OnvifMediaStreamUriListener listener) {
        this.mediaProfile = mediaProfile;
        this.listener = listener;
    }

    public OnvifMediaProfile getMediaProfile() {
        return this.mediaProfile;
    }

    @Override
    public String getXml() {
        return "<GetStreamUri xmlns=\"http://www.onvif.org/ver10/media/wsdl\"><StreamSetup><Stream xmlns=\"http://www.onvif.org/ver10/schema\">RTP-Unicast</Stream><Transport xmlns=\"http://www.onvif.org/ver10/schema\"><Protocol>RTSP</Protocol></Transport></StreamSetup><ProfileToken>" + this.mediaProfile.getToken() + "</ProfileToken>" + "</GetStreamUri>";
    }

    @Override
    public OnvifType getType() {
        return OnvifType.GET_STREAM_URI;
    }

    @Override
    public String getUrlForRequest(OnvifDevice device) {
        return String.valueOf(device.getHostName()) + device.getPath().getStreamURIPath();
    }

    @Override
    public OnvifResponseListener getOnvifResponseListener() {
        return this.listener;
    }
}

