/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifRequest;
import com.wovoe.carpark.equipment.onvif.OnvifResponseListener;
import com.wovoe.carpark.equipment.onvif.OnvifXMLBuilder;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OnvifExecutor {
    private static final Logger logger = Logger.getLogger(OnvifExecutor.class.getName());
    private OkHttpClient client;
    private MediaType reqBodyType;
    private RequestBody reqBody;
    private Credentials credentials;

    OnvifExecutor(ExecutorService executorService, ConnectionPool connectionPool) {
        if (executorService == null || connectionPool == null) {
            throw new NullPointerException();
        }
        this.credentials = new Credentials("username", "password");
        DigestAuthenticator authenticator = new DigestAuthenticator(this.credentials);
        ConcurrentHashMap authCache = new ConcurrentHashMap();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectionPool(connectionPool);
        builder.dispatcher(new Dispatcher(executorService));
        builder.connectTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)authenticator, authCache)).addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache));
        this.client = builder.build();
        this.reqBodyType = MediaType.parse((String)"application/soap+xml; charset=utf-8;");
    }

    void sendRequest(OnvifDevice device, OnvifRequest request) {
        this.credentials.setUserName(device.getUsername());
        this.credentials.setPassword(device.getPassword());
        this.reqBody = RequestBody.create((MediaType)this.reqBodyType, (String)(String.valueOf(OnvifXMLBuilder.getSoapHeader()) + request.getXml() + OnvifXMLBuilder.getEnvelopeEnd()));
        this.performXmlRequest(device, request, this.buildOnvifRequest(device, request));
    }

    private void performXmlRequest(final OnvifDevice device, final OnvifRequest request, Request xmlRequest) {
        if (xmlRequest == null) {
            return;
        }
        this.client.newCall(xmlRequest).enqueue(new Callback(){

            public void onResponse(Call call, Response xmlResponse) throws IOException {
                OnvifResponseListener l;
                boolean success;
                String errorMessage;
                String responseStr;
                block27: {
                    responseStr = null;
                    errorMessage = null;
                    success = false;
                    try {
                        try {
                            ResponseBody xmlBody = xmlResponse.body();
                            if (xmlResponse.code() == 200) {
                                success = true;
                                if (xmlBody != null) {
                                    responseStr = xmlBody.string();
                                }
                            } else {
                                errorMessage = "HTTP error:" + xmlResponse.code();
                                if (xmlBody != null) {
                                    try {
                                        errorMessage = String.valueOf(errorMessage) + ":" + xmlBody.string();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        catch (Throwable ex) {
                            errorMessage = ex.getMessage();
                            try {
                                if (xmlResponse != null) {
                                    xmlResponse.close();
                                }
                                break block27;
                            }
                            catch (Exception ex2) {
                                logger.log(Level.WARNING, "Close Response error! " + ex2);
                            }
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (xmlResponse != null) {
                                xmlResponse.close();
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.WARNING, "Close Response error! " + ex);
                        }
                        throw throwable;
                    }
                    try {
                        if (xmlResponse != null) {
                            xmlResponse.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Close Response error! " + ex);
                    }
                }
                if ((l = request.getOnvifResponseListener()) != null) {
                    if (success) {
                        try {
                            l.onSuccessReceived(device, request, responseStr);
                        }
                        catch (Throwable ex) {
                            logger.log(Level.WARNING, "Invoke " + l.getClass().getSimpleName() + ".onSuccessReceived Exception", ex);
                        }
                    } else {
                        try {
                            l.onError(device, request, xmlResponse.code(), errorMessage);
                        }
                        catch (Throwable ex) {
                            logger.log(Level.WARNING, "Invoke " + l.getClass().getSimpleName() + ".onError Exception", ex);
                        }
                    }
                }
            }

            public void onFailure(Call call, IOException e) {
                OnvifResponseListener l = request.getOnvifResponseListener();
                if (l != null) {
                    try {
                        l.onError(device, request, -1, e.getMessage());
                    }
                    catch (Throwable ex) {
                        logger.log(Level.WARNING, "Invoke " + l.getClass().getSimpleName() + ".onError Exception", ex);
                    }
                }
            }
        });
    }

    private Request buildOnvifRequest(OnvifDevice device, OnvifRequest request) {
        return new Request.Builder().url(request.getUrlForRequest(device)).addHeader("Content-Type", "text/xml; charset=utf-8").post(this.reqBody).build();
    }
}

