/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfile;
import com.wovoe.carpark.equipment.onvif.OnvifRequest;
import com.wovoe.carpark.equipment.onvif.OnvifResponseListener;
import com.wovoe.carpark.equipment.onvif.OnvifXMLBuilder;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class OnvifMediaProfileListener
implements OnvifResponseListener {
    private static final String KEY_PROFILES = "Profiles";
    private static final String ATTR_TOKEN = "token";
    private static final String ATTR_NAME = "Name";
    private static final String VideoEncoderConfiguration = "VideoEncoderConfiguration";
    private static final String ATTR_Encoding = "Encoding";
    private static final String ATTR_Width = "Width";
    private static final String ATTR_Height = "Height";
    private static final String ATTR_Quality = "Quality";
    private static final String ATTR_FrameRateLimit = "FrameRateLimit";
    private static final String ATTR_EncodingInterval = "EncodingInterval";
    private static final String ATTR_BitrateLimit = "BitrateLimit";
    private static final String ATTR_GovLength = "GovLength";
    private static final String AudioEncoderConfiguration = "AudioEncoderConfiguration";
    private static final String ATTR_Bitrate = "Bitrate";
    private static final String ATTR_SampleRate = "SampleRate";

    @Override
    public void onSuccessReceived(OnvifDevice onvifDevice, OnvifRequest onvifRequest, String xml) {
        if (xml == null || xml.length() == 0) {
            this.onError(onvifDevice, onvifRequest, -2, "Device response null or empty content!");
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            Node rootNode = document.getFirstChild();
            List<Node> profilesList = OnvifXMLBuilder.findNodeList(rootNode, KEY_PROFILES);
            ArrayList<OnvifMediaProfile> mediaProfilesList = new ArrayList<OnvifMediaProfile>(profilesList == null ? 0 : profilesList.size());
            if (profilesList != null && !profilesList.isEmpty()) {
                for (Node node : profilesList) {
                    String tokenValue;
                    Node node1 = node.getAttributes().getNamedItem(ATTR_TOKEN);
                    if (node1 == null || (tokenValue = node1.getNodeValue()) == null || tokenValue.length() <= 0) continue;
                    OnvifMediaProfile file = new OnvifMediaProfile();
                    file.setToken(tokenValue);
                    mediaProfilesList.add(file);
                    NodeList subNodeList = node.getChildNodes();
                    if (subNodeList == null) continue;
                    int len = subNodeList.getLength();
                    int i = 0;
                    while (i < len) {
                        List<Node> attrList;
                        Node node23 = subNodeList.item(i);
                        if (OnvifXMLBuilder.nodeNameEq(node23, ATTR_NAME)) {
                            file.setName(node23.getTextContent());
                        } else if (OnvifXMLBuilder.nodeNameEq(node23, VideoEncoderConfiguration)) {
                            attrList = OnvifXMLBuilder.findNodes(node23, ATTR_Encoding, ATTR_Width, ATTR_Height, ATTR_Quality, ATTR_FrameRateLimit, ATTR_EncodingInterval, ATTR_BitrateLimit, ATTR_GovLength);
                            if (attrList != null && !attrList.isEmpty()) {
                                for (Node node2 : attrList) {
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Encoding)) {
                                        file.setVideo_Encoding(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Width)) {
                                        file.setVideo_Width(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Height)) {
                                        file.setVideo_Height(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Quality)) {
                                        file.setVideo_Quality(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_FrameRateLimit)) {
                                        file.setVideo_FrameRateLimit(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_EncodingInterval)) {
                                        file.setVideo_EncodingInterval(node2.getTextContent());
                                        continue;
                                    }
                                    if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_BitrateLimit)) {
                                        file.setVideo_BitrateLimit(node2.getTextContent());
                                        continue;
                                    }
                                    if (!OnvifXMLBuilder.nodeNameEq(node2, ATTR_GovLength)) continue;
                                    file.setVideo_GovLength(node2.getTextContent());
                                }
                            }
                        } else if (OnvifXMLBuilder.nodeNameEq(node23, AudioEncoderConfiguration) && (attrList = OnvifXMLBuilder.findNodes(node23, ATTR_Encoding, ATTR_Bitrate, ATTR_SampleRate)) != null && !attrList.isEmpty()) {
                            for (Node node2 : attrList) {
                                if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Encoding)) {
                                    file.setAudio_Encoding(node2.getTextContent());
                                    continue;
                                }
                                if (OnvifXMLBuilder.nodeNameEq(node2, ATTR_Bitrate)) {
                                    file.setAudio_Bitrate(node2.getTextContent());
                                    continue;
                                }
                                if (!OnvifXMLBuilder.nodeNameEq(node2, ATTR_SampleRate)) continue;
                                file.setAudio_SampleRate(node2.getTextContent());
                            }
                        }
                        ++i;
                    }
                }
            }
            this.onSuccess(mediaProfilesList);
        }
        catch (Exception ex) {
            this.onError(onvifDevice, onvifRequest, -2, "Parse xml error! cause: " + ex + ", xml: " + xml);
        }
    }

    public abstract void onSuccess(List<OnvifMediaProfile> var1);
}

