/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifRequest;
import com.wovoe.carpark.equipment.onvif.OnvifResponseListener;
import com.wovoe.carpark.equipment.onvif.OnvifXMLBuilder;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class OnvifMediaStreamUriListener
implements OnvifResponseListener {
    private static final String ATTR_MediaUri = "MediaUri";
    private static final String Attr_Uri = "Uri";

    @Override
    public void onSuccessReceived(OnvifDevice onvifDevice, OnvifRequest onvifRequest, String xml) {
        if (xml == null || xml.length() == 0) {
            this.onError(onvifDevice, onvifRequest, -3, "Device response null or empty content!");
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            Node rootNode = document.getFirstChild();
            List<Node> profilesList = OnvifXMLBuilder.findNodeList(rootNode, ATTR_MediaUri);
            String uri = null;
            if (profilesList != null && !profilesList.isEmpty()) {
                for (Node node : profilesList) {
                    List<Node> nodeList = OnvifXMLBuilder.findNodeList(node, Attr_Uri);
                    if (nodeList != null && !nodeList.isEmpty()) {
                        for (Node node1 : nodeList) {
                            if (OnvifXMLBuilder.nodeNameEq(node1, Attr_Uri) && (uri = node1.getTextContent()) != null && uri.length() > 0) break;
                        }
                    }
                    if (uri != null && uri.length() > 0) break;
                }
            }
            this.onSuccess(uri);
        }
        catch (Exception ex) {
            this.onError(onvifDevice, onvifRequest, -2, "Parse xml error! cause: " + ex + ", xml: " + xml);
        }
    }

    public abstract void onSuccess(String var1);
}

