/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.onvif;

import com.wovoe.carpark.equipment.onvif.OnvifClient;
import com.wovoe.carpark.equipment.onvif.OnvifDevice;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfile;
import com.wovoe.carpark.equipment.onvif.OnvifMediaProfileListener;
import com.wovoe.carpark.equipment.onvif.OnvifMediaStreamUriListener;
import com.wovoe.carpark.equipment.onvif.OnvifRequest;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xml.sax.SAXException;

public class RtspUriTool {
    public static OperationFuture<List<OnvifMediaProfile>> getOnvifMediaProfileList(String ipOrDomain, int port, String userName, String pwd) {
        String url = "http://" + ipOrDomain;
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        return RtspUriTool.getOnvifMediaProfileList(url, userName, pwd);
    }

    public static OperationFuture<List<OnvifMediaProfile>> getOnvifMediaProfileList(String onvifDeviceBasicUrl, String userName, String pwd) {
        final OperationFutureHandler resultF = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            OnvifDevice device = new OnvifDevice(onvifDeviceBasicUrl, userName, pwd);
            final OnvifClient client = ServiceUtil.getServiceContext().getOnvifClientFactory().createOnvifClient(device);
            client.requestMediaProfiles(new OnvifMediaProfileListener(){
                private volatile int count;
                private volatile int finishCounter;

                @Override
                public void onError(OnvifDevice onvifDevice, OnvifRequest onvifRequest, int errorCode, String errorMessage) {
                    if (errorCode == -1) {
                        resultF.setException((Throwable)new ConnectException(errorMessage));
                    } else if (errorCode < -1) {
                        resultF.setException((Throwable)new SAXException(errorMessage));
                    } else {
                        resultF.setException((Throwable)new IOException(String.valueOf(errorCode) + ": " + errorMessage));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void finish(List<OnvifMediaProfile> mediaProfiles) {
                    boolean invokeCallback;
                    1 var3_2 = this;
                    synchronized (var3_2) {
                        ++this.finishCounter;
                        invokeCallback = this.finishCounter >= this.count;
                    }
                    if (invokeCallback) {
                        resultF.setResult(mediaProfiles);
                    }
                }

                @Override
                public void onSuccess(final List<OnvifMediaProfile> mediaProfiles) {
                    if (mediaProfiles != null && !mediaProfiles.isEmpty()) {
                        this.count = mediaProfiles.size();
                        for (final OnvifMediaProfile profile : mediaProfiles) {
                            client.requestMediaStreamProfiles(profile, new OnvifMediaStreamUriListener(){
                                private AtomicBoolean ax = new AtomicBoolean(false);

                                @Override
                                public void onError(OnvifDevice onvifDevice, OnvifRequest onvifRequest, int errorCode, String errorMessage) {
                                    if (this.ax.compareAndSet(false, true)) {
                                        this.finish(mediaProfiles);
                                    }
                                }

                                @Override
                                public void onSuccess(String uri) {
                                    if (this.ax.compareAndSet(false, true)) {
                                        profile.setUri(uri);
                                        this.finish(mediaProfiles);
                                    }
                                }
                            });
                        }
                    } else {
                        resultF.setResult(mediaProfiles);
                    }
                }
            });
        }
        catch (Throwable ex) {
            resultF.setException(ex);
        }
        return resultF;
    }

    public static OperationFuture<List<OnvifMediaProfile>> getOnvifMediaProfileListUseShortCache(String ipOrDomain, int port, String userName, String pwd) {
        String url = "http://" + ipOrDomain;
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        return RtspUriTool.getOnvifMediaProfileListUseShortCache(url, userName, pwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationFuture<List<OnvifMediaProfile>> getOnvifMediaProfileListUseShortCache(String onvifDeviceBasicUrl, String userName, String pwd) {
        OperationFuture r;
        QueryKey kq = new QueryKey(onvifDeviceBasicUrl, userName, pwd);
        Object lock = ServiceUtil.getServiceContext().getKeyLockManager().getLock(kq);
        try {
            Object object = lock;
            synchronized (object) {
                Object obj = ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)kq);
                if (obj != null && obj instanceof OperationFuture) {
                    r = (OperationFuture)obj;
                } else {
                    r = RtspUriTool.getOnvifMediaProfileList(onvifDeviceBasicUrl, userName, pwd);
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)kq, (Object)r, null, 5L, TimeUnit.SECONDS);
                }
            }
        }
        finally {
            ServiceUtil.getServiceContext().getKeyLockManager().releaseLock(lock);
        }
        return r;
    }

    private static class QueryKey {
        private String onvifDeviceBasicUrl;
        private String userName;
        private String pwd;

        public QueryKey(String onvifDeviceBasicUrl, String userName, String pwd) {
            this.onvifDeviceBasicUrl = onvifDeviceBasicUrl;
            this.userName = userName;
            this.pwd = pwd;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.onvifDeviceBasicUrl == null ? 0 : this.onvifDeviceBasicUrl.hashCode());
            result = 31 * result + (this.pwd == null ? 0 : this.pwd.hashCode());
            result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryKey other = (QueryKey)obj;
            if (this.onvifDeviceBasicUrl == null ? other.onvifDeviceBasicUrl != null : !this.onvifDeviceBasicUrl.equals(other.onvifDeviceBasicUrl)) {
                return false;
            }
            if (this.pwd == null ? other.pwd != null : !this.pwd.equals(other.pwd)) {
                return false;
            }
            return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
        }
    }
}

