/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event;

import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventDispatcher;
import com.wovoe.carpark.event.CarparkEventID;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.CarparkEventListenerManager;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultCarparkEventListenerManager
implements CarparkEventListenerManager,
CarparkEventDispatcher {
    protected Map<Integer, Collection<CarparkEventListener>> reference = new ConcurrentHashMap<Integer, Collection<CarparkEventListener>>();
    private static final Logger logger = Logger.getLogger(DefaultCarparkEventListenerManager.class.getName());
    private AtomicLong threadCounter;
    private Executor executor;

    public DefaultCarparkEventListenerManager() {
        this(null);
    }

    public DefaultCarparkEventListenerManager(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerParkingEventListener(CarparkEventListener l) {
        int[] ids;
        if (l != null && (ids = l.getIntestEventId()) != null && ids.length > 0) {
            Map<Integer, Collection<CarparkEventListener>> map = this.reference;
            synchronized (map) {
                int[] nArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    this.registerIntestEvent(id, l);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterParkingEventListener(CarparkEventListener l) {
        int[] ids;
        if (l != null && (ids = l.getIntestEventId()) != null && ids.length > 0) {
            Map<Integer, Collection<CarparkEventListener>> map = this.reference;
            synchronized (map) {
                int[] nArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    this.removeIntestEvent(id, l);
                    ++n2;
                }
            }
        }
    }

    private void registerIntestEvent(int hparkingEventId, CarparkEventListener eventHandler) {
        Integer key = new Integer(hparkingEventId);
        Collection<CarparkEventListener> set = this.reference.get(key);
        if (set == null) {
            set = new CopyOnWriteArraySet<CarparkEventListener>();
            this.reference.put(key, set);
        }
        set.add(eventHandler);
    }

    private void removeIntestEvent(int hparkingEventId, CarparkEventListener eventHandler) {
        Collection<CarparkEventListener> set = this.reference.get(hparkingEventId);
        if (set != null) {
            set.remove(eventHandler);
            if (set.isEmpty()) {
                this.reference.remove(hparkingEventId);
            }
        }
    }

    @Override
    public boolean dispatch(CarparkEvent<?> event) {
        if (event != null) {
            LinkedList<Integer> eventIds = CarparkEventID.getParents(event.getEventId());
            if (eventIds == null) {
                eventIds = new LinkedList();
            }
            eventIds.offerFirst(event.getEventId());
            for (Integer id : eventIds) {
                Collection<CarparkEventListener> handles;
                if (id == null || (handles = this.reference.get(id)) == null) continue;
                for (CarparkEventListener handle : handles) {
                    try {
                        handle.handleEvent(event);
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, handle + "handle event error!", ex);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void asynThrowEvent(CarparkEvent<?> event) {
        Runnable command = this.newTask(event);
        Executor executor1 = this.executor;
        if (executor1 != null) {
            executor1.execute(command);
        } else {
            if (this.threadCounter == null) {
                this.threadCounter = new AtomicLong(0L);
            }
            new Thread(command, "ParkingEvent-dispatcher-" + this.threadCounter.incrementAndGet()).start();
        }
    }

    Runnable newTask(final CarparkEvent<?> event) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultCarparkEventListenerManager.this.dispatch(event);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "dispatch event error!", ex);
                }
            }
        };
    }

    @Override
    public void syncThrowEvent(CarparkEvent<?> event) {
        this.dispatch(event);
    }
}

