/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.app;

import com.wovoe.carpark.event.DefaultCarparkEvent;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.internel.ServiceUtil;

public class CarArrivedEvent
extends DefaultCarparkEvent<Object> {
    private static final long serialVersionUID = 4783765232235994196L;
    private long carArrivedTimeMills;
    private long systemMills;
    private String channelNo;
    private OriginalSourceType originalSourceType;
    private VehicleDetectorEvent vehicleDetectorEvent;
    private CaptureEvent captureEvent;
    private String plateNumber;

    public CarArrivedEvent(Object source, OriginalSourceType sourceType, String channelNo, VehicleDetectorEvent vehicleDetectorEvent) {
        super(source, 4092);
        if (vehicleDetectorEvent == null) {
            this.carArrivedTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
            this.systemMills = System.currentTimeMillis();
        } else {
            this.carArrivedTimeMills = vehicleDetectorEvent.getTimeMills();
            this.systemMills = vehicleDetectorEvent.getSystemMills();
        }
        this.originalSourceType = sourceType;
        this.channelNo = channelNo;
        this.vehicleDetectorEvent = vehicleDetectorEvent;
    }

    public VehicleDetectorEvent getVehicleDetectorEvent() {
        return this.vehicleDetectorEvent;
    }

    public long getCarArrivedTimeMills() {
        return this.carArrivedTimeMills;
    }

    public long getSystemMills() {
        return this.systemMills;
    }

    public void setSystemMills(long systemMills) {
        this.systemMills = systemMills;
    }

    public String getPlateNumber() {
        return this.plateNumber;
    }

    public void setPlateNumber(String plateNumber) {
        this.plateNumber = plateNumber;
    }

    public String getChannelNo() {
        return this.channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo;
    }

    public OriginalSourceType getOriginalSourceType() {
        return this.originalSourceType;
    }

    public void setOriginalSourceType(OriginalSourceType originalSourceType) {
        this.originalSourceType = originalSourceType;
    }

    public void setVehicleDetectorEvent(VehicleDetectorEvent vehicleDetectorEvent) {
        this.vehicleDetectorEvent = vehicleDetectorEvent;
    }

    public void setCarArrivedTimeMills(long carArrivedTimeMills) {
        this.carArrivedTimeMills = carArrivedTimeMills;
    }

    public CaptureEvent getCaptureEvent() {
        return this.captureEvent;
    }

    public void setCaptureEvent(CaptureEvent captureEvent) {
        this.captureEvent = captureEvent;
    }

    public static enum OriginalSourceType {
        ARTIFICIAL,
        GROUND_SENSE,
        PLATE_RECOGNIZED;

    }
}

