/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.equipment;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.event.DefaultCarparkEvent;
import com.wovoe.carpark.internel.ServiceUtil;

public class DetectedPassEvent
extends DefaultCarparkEvent<Equipment> {
    private static final long serialVersionUID = 4875756559623280038L;
    private String mediaNumber;
    private MediaType mediaType;
    private Object mediaInfo;
    private boolean longDistance;
    private String plateNumber;
    private String plateColor;
    private String channelNo;
    private final long readTimeMills;
    private final long readSystemTimeMills;
    private int pressGroudValue = -1;

    public DetectedPassEvent(Equipment equipment, String mediaNumber, MediaType mediaType) {
        super(equipment, 103);
        this.mediaNumber = mediaNumber;
        this.mediaType = mediaType;
        this.readTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.readSystemTimeMills = System.currentTimeMillis();
    }

    public long getReadTimeMills() {
        return this.readTimeMills;
    }

    public long getReadSystemTimeMills() {
        return this.readSystemTimeMills;
    }

    public boolean isLongDistance() {
        return this.longDistance;
    }

    public void setLongDistance(boolean longDistance) {
        this.longDistance = longDistance;
    }

    public String getMediaNumber() {
        return this.mediaNumber;
    }

    public void setMediaNumber(String mediaNumber) {
        this.mediaNumber = mediaNumber;
    }

    public Object getMediaInfo() {
        return this.mediaInfo;
    }

    public void setMediaInfo(Object mediaInfo) {
        this.mediaInfo = mediaInfo;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getPlateNumber() {
        return this.plateNumber;
    }

    public void setPlateNumber(String plateNumber) {
        this.plateNumber = plateNumber;
    }

    public String getPlateColor() {
        return this.plateColor;
    }

    public void setPlateColor(String plateColor) {
        this.plateColor = plateColor;
    }

    public String getChannelNo() {
        return this.channelNo;
    }

    public void setChannelNo(String channelNo) {
        this.channelNo = channelNo;
    }

    public int getPressGroudValue() {
        return this.pressGroudValue;
    }

    public void setPressGroudValue(int pressGroudValue) {
        this.pressGroudValue = pressGroudValue;
    }

    public int toIntMediaType() {
        int v;
        MediaType media = this.mediaType;
        if (media == null) {
            v = 1;
        } else {
            switch (media) {
                case IC: {
                    v = 0;
                    break;
                }
                case ID: {
                    v = 1;
                    break;
                }
                case OBU: {
                    v = 6;
                    break;
                }
                case PLATE: {
                    v = 6;
                    break;
                }
                default: {
                    v = 1;
                }
            }
        }
        return v;
    }

    public static enum MediaType {
        IC,
        ID,
        PLATE,
        OBU;

    }
}

