/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.listener;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.DBConfigCache;
import com.wovoe.carpark.InvalidPassportNumberKey;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PlateRecognizedEventListener;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkChannel;
import com.wovoe.carpark.dto.CarparkPassRecord;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.PlateRegCameraAction;
import com.wovoe.carpark.equipment.driver.ZSRGCameraAction;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.DefaultCarparkEvent;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.CarArrivedEvent;
import com.wovoe.carpark.event.app.CarLeftEvent;
import com.wovoe.carpark.event.app.ConfirmPassEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.ParkingFullReStartSessionEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.event.equipment.VehiclePassEvent;
import com.wovoe.carpark.event.equipment.VehicleTypeEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.carpark.service.impl.remote.CommonRemoteServiceImpl;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CarChannelPassProcessEventListener
implements CarparkEventListener {
    private static final ConcurrentHashMap<String, EX> eventsMap = new ConcurrentHashMap();

    public static void closeAllChannelEx() {
        try {
            Iterator<Map.Entry<String, EX>> its = eventsMap.entrySet().iterator();
            while (its.hasNext()) {
                Map.Entry<String, EX> en = its.next();
                if (en.getValue().channelWorkThread != null) {
                    try {
                        en.getValue().channelWorkThread.shutdown();
                        en.getValue().channelWorkThread.shutdownNow();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                its.remove();
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public int[] getIntestEventId() {
        return new int[]{4604, 4092, 4348, 1276, 5372, 105, 112};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EX getEventExcutor(String channelNo) {
        EX ex = eventsMap.get(channelNo);
        if (ex == null) {
            ConcurrentHashMap<String, EX> concurrentHashMap = eventsMap;
            synchronized (concurrentHashMap) {
                ex = eventsMap.get(channelNo);
                if (ex == null) {
                    ex = new EX(channelNo, this);
                    eventsMap.put(channelNo, ex);
                }
            }
        }
        return ex;
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (event == null) {
            return;
        }
        JavaBeanMap eventMap = new JavaBeanMap(event);
        String channelNo = (String)eventMap.get((Object)"channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)"\u901a\u9053\u53f7\u4e3a\u7a7a\uff0c\u9519\u8bef\u7684\u901a\u9053\u4e8b\u4ef6\uff01\u7f3a\u5c11\u901a\u9053\u7f16\u53f7\uff01 ");
            }
            if (applicationService.getMessageLog().hasHandlers()) {
                applicationService.getMessageLog().warn("\u901a\u9053\u53f7\u4e3a\u7a7a\uff0c\u9519\u8bef\u7684\u901a\u9053\u4e8b\u4ef6 ");
            }
            return;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)("\u9519\u8bef\u7684\u901a\u9053\u7f16\u53f7" + channelNo + "\uff0c\u65e0\u6cd5\u627e\u5230\u7ba1\u7406\u901a\u9053\uff01\u65e0\u6cd5\u5904\u7406\u6b64\u901a\u9053\u4e8b\u4ef6\uff01\ufe0f "));
            }
            if (applicationService.getMessageLog().hasHandlers()) {
                applicationService.getMessageLog().warn("\u9519\u8bef\u7684\u901a\u9053\u7f16\u53f7" + channelNo + "\uff0c\u65e0\u6cd5\u627e\u5230\u7ba1\u7406\u901a\u9053\uff01\u65e0\u6cd5\u5904\u7406\u6b64\u901a\u9053\u4e8b\u4ef6\uff01\ufe0f ");
            }
            return;
        }
        this.getEventExcutor(channelNo).handle(event);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEvent0(CarparkEvent<?> e1) throws Exception {
        if (e1 instanceof PlateRecognizedEvent) {
            e = (PlateRecognizedEvent)e1;
            hChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(e.getChannelNo());
            try {
                if (hChannel != null) {
                    for (PlateRecognizedEventListener l : hChannel.getPlateRecognizedEventListeners()) {
                        try {
                            l.onRecognizedBeforeProcess((PlateRecognizedEvent)e1);
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().error((Object)"", (Throwable)ex);
                        }
                    }
                }
                if (e.getEventPassId() == null) {
                    hChannel.getPassEventHandler().handlePlateRecognized(e, this);
                }
                this.handlePlateRecognizedEvent(e);
            }
            finally {
                if (hChannel == null) return;
                ** for (l : hChannel.getPlateRecognizedEventListeners())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    l.onRecognizedWhenProcess((PlateRecognizedEvent)e1);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)"", (Throwable)ex);
                }
                continue;
lbl27:
                // 1 sources

                return;
            }
        } else if (e1 instanceof ReadPassportNumberEvent) {
            rev = (ReadPassportNumberEvent)e1;
            try {
                this.handleReadPassportNumberEvent(rev);
                return;
            }
            catch (Exception ex) {
                try {
                    ServiceLog.getLog().error((Object)"\u5904\u7406\u653e\u884c\u6d41\u7a0b\u5f02\u5e38", (Throwable)ex);
                    return;
                }
                finally {
                    rev.triggerPassError("\u5904\u7406\u653e\u884c\u6d41\u7a0b\u5f02\u5e38");
                }
            }
        } else if (e1 instanceof CarArrivedEvent) {
            this.handleCarArrivedEvent((CarArrivedEvent)e1);
            return;
        } else if (e1 instanceof CarLeftEvent) {
            this.handleCarLeftEvent((CarLeftEvent)e1);
            return;
        } else if (e1 instanceof ParkingFullReStartSessionEvent) {
            this.handleParkingFullReStartSessionEvent((ParkingFullReStartSessionEvent)e1);
            return;
        } else if (e1 instanceof VehicleTypeEvent) {
            this.handleVehicleTypeEvent((VehicleTypeEvent)e1);
            return;
        } else {
            if (!(e1 instanceof VehiclePassEvent)) return;
            this.handleVehiclePassEvent((VehiclePassEvent)e1);
        }
    }

    private void handleVehiclePassEvent(VehiclePassEvent event) {
        String channelNo = event.getChannelNo();
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel != null) {
            passChannel.getPassEventHandler().handleVehiclePassEvent(event, this);
        }
    }

    private void handleVehicleTypeEvent(VehicleTypeEvent event) {
        SearchParam serachP;
        CommonDaoService commonDaoService;
        CarparkPresenceRecord record;
        ChannelArea channelArea;
        if (event.getPlateNumber() == null || event.getPlateNumber().length() == 0) {
            return;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(event.getChannelNo());
        if (passChannel == null) {
            return;
        }
        if (event.getVehicleType() == null || event.getVehicleType().length() == 0) {
            return;
        }
        Object otType = PassChannel.getCarTypeOrPlateType(event.getVehicleType());
        CarparkCarType carType = null;
        if (otType != null && otType instanceof CarparkCarType) {
            carType = (CarparkCarType)otType;
        }
        if (carType == null && event.getVehicleType() != null && event.getVehicleType().length() > 0) {
            for (CarparkCarType carType1 : ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap().values()) {
                if (carType1.getCar_type_name() == null || carType1.getCar_type_name().indexOf(event.getVehicleType()) == -1) continue;
                carType = carType1;
                break;
            }
        }
        if (carType == null) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u672a\u627e\u5230\u8f66\u8f86\u7c7b\u578b\u4e3a\uff1a" + event.getVehicleType() + " \u5b9a\u4e49\uff0c\u7cfb\u7edf\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8f66\u8f86\u7c7b\u578b\u3002", 3));
            return;
        }
        Collection<PassSession> sessions = passChannel.getSessions();
        PassSession sameSession = null;
        for (PassSession session : sessions) {
            boolean samePlate = false;
            if (session.getPlateRecognizedEvent() != null && event.getPlateNumber().equals(session.getPlateRecognizedEvent().getPlateNumber())) {
                samePlate = true;
            }
            if (samePlate) continue;
            ReadPassportNumberEvent e = session.getReadPassportNumberEvent();
            if (e != null) {
                if (e.getPlateRecognizedEvent() != null && event.getPlateNumber().equals(e.getPlateRecognizedEvent().getPlateNumber())) {
                    samePlate = true;
                }
                if (!samePlate && e.getPlateNumber() != null && e.getPlateNumber().length() > 0 && e.getPlateNumber().equals(event.getPlateNumber())) {
                    samePlate = true;
                }
            }
            if (!samePlate) continue;
            sameSession = session;
        }
        boolean handled = false;
        if (!(sameSession == null || sameSession.getCarType() != null && carType.getCar_type_no().equals(sameSession.getCarType().getCar_type_no()))) {
            if (sameSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                ConfirmPassDialogCallback callback;
                sameSession.setCarType(carType);
                if (sameSession.getChargeFilter() != null) {
                    try {
                        sameSession.getChargeFilter().doFilter(sameSession);
                    }
                    catch (Exception e) {
                        ServiceLog.getLog().warn((Object)"\u8ba1\u8d39\u9519\u8bef", (Throwable)e);
                    }
                }
                if ((callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                    callback.doUpdateSession(sameSession);
                }
                handled = true;
            } else if (sameSession.getSessionState() == PassSession.SessionState.WAIT_CAR_LEAVE || sameSession.getSessionState() == PassSession.SessionState.CAR_LEAVING || sameSession.getSessionState() == PassSession.SessionState.CAR_LEFT) {
                channelArea = (ChannelArea)sameSession.getAttribute("channelArea");
                Date passTime = (Date)sameSession.getAttribute("passTime");
                if (channelArea != null && passTime != null && channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                    handled = true;
                    CommonDaoService commonDaoService2 = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                    SearchParam serachP2 = new SearchParam().setQueryFields(new String[]{"id", "enter_record_no", "enter_car_type_no", "enter_time", "enter_plate", "passport_number", "medium_type", "enter_channel_no"}).addEQ("enter_time", (Object)passTime).addEQ("enter_channel_no", (Object)passChannel.getChannelNo());
                    if (sameSession.getPassport() != null && sameSession.getPassport().getMedium_type() != null && sameSession.getPassport().getPassport_number() != null && sameSession.getPassport().getPassport_number().length() > 0) {
                        serachP2.addEQ("passport_number", (Object)sameSession.getPassport().getPassport_number());
                        serachP2.addEQ("medium_type", (Object)sameSession.getPassport().getMedium_type());
                    } else {
                        String passPlate = sameSession.getPassPlate() == null ? event.getPlateNumber() : sameSession.getPassPlate();
                        serachP2.addEQ("enter_plate", (Object)passPlate);
                    }
                    CarparkPresenceRecord record2 = (CarparkPresenceRecord)commonDaoService2.selectOne(serachP2, CarparkPresenceRecord.class);
                    if (!(record2 == null || record2.getEnter_car_type_no() != null && carType.getCar_type_no().equals(record2.getEnter_car_type_no()))) {
                        RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                        recordSaveService.modifyPresenceCarType(record2.getId(), record2.getEnter_car_type_no(), carType.getCar_type_no(), "0", "\u8f66\u578b\u8bc6\u522b\u5668", ServiceUtil.getNow(), true);
                    }
                }
            }
        }
        if (!(handled || (channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo())) == null || channelArea.getEnterAreas() == null || channelArea.getEnterAreas().isEmpty() || (record = (CarparkPresenceRecord)(commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class)).selectOne(serachP = new SearchParam().setQueryFields(new String[]{"id", "enter_record_no", "enter_car_type_no", "enter_time", "enter_plate", "passport_number", "medium_type", "enter_channel_no"}).addEQ("enter_plate", (Object)event.getPlateNumber()).addEQ("area_no", (Object)channelArea.getEnterAreas().get(0).getArea_no()), CarparkPresenceRecord.class)) == null || record.getEnter_car_type_no() != null && carType.getCar_type_no().equals(record.getEnter_car_type_no()))) {
            RecordSaveService recordSaveService = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            recordSaveService.modifyPresenceCarType(record.getId(), record.getEnter_car_type_no(), carType.getCar_type_no(), "0", "\u8f66\u578b\u8bc6\u522b\u5668", ServiceUtil.getNow(), true);
        }
        passChannel.addVehicleTypeEvent(event);
    }

    private void handleParkingFullReStartSessionEvent(ParkingFullReStartSessionEvent event) {
        PassSession session;
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(event.getChannelNo());
        if (passChannel != null && (session = passChannel.getLastSession()) != null && session.isValid() && session.getSessionState() == PassSession.SessionState.CANCELED && session.removeAttribute("PARKING_FULL_QUEUE_FLAG") != null) {
            session.reStart();
        }
    }

    private void handleCarArrivedEvent(CarArrivedEvent event) {
        Collection<PassSession> cls;
        String channelNo = event.getChannelNo();
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            return;
        }
        if (event.getOriginalSourceType() != CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
            return;
        }
        if (event.getVehicleDetectorEvent() == null) {
            return;
        }
        if (event.getVehicleDetectorEvent().getType() == 0 && (cls = passChannel.getSessions()) != null) {
            PassSession pe = null;
            for (PassSession session : cls) {
                if (session.isTempSession() || session.getCarLeftEvent() != null || session.getSessionState() == PassSession.SessionState.CAR_LEFT) continue;
                if (session.getSessionState() == PassSession.SessionState.PENDING) {
                    if (session.getCarArrivedEvent() != null) {
                        if (event.getCarArrivedTimeMills() - session.getCarArrivedEvent().getCarArrivedTimeMills() < 3000L) {
                            if (session.getCarArrivedEvent().getPlateNumber() != null && session.getCarArrivedEvent().getPlateNumber().length() > 0) {
                                event.setPlateNumber(session.getCarArrivedEvent().getPlateNumber());
                            }
                            if (session.getCarArrivedEvent().getCaptureEvent() != null) {
                                event.setCaptureEvent(session.getCarArrivedEvent().getCaptureEvent());
                            }
                            session.setCarArrivedEvent(event);
                            session.resetSessionTimeoutMills(1200000);
                        }
                    } else {
                        session.setCarArrivedEvent(event);
                        session.resetSessionTimeoutMills(1200000);
                    }
                    return;
                }
                if (session.getReadPassportNumberEvent() == null || session.getReadPassportNumberEvent().isManualTrigger() && session.getCarArrivedEvent() == null || session.getPlateRecognizedEvent() == null && session.getReadPassportNumberEvent().getDetectedPassEvent() == null) continue;
                pe = session;
            }
            if (pe != null) {
                if (pe.getCarArrivedEvent() != null) {
                    if (pe.getCarArrivedEvent().getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.PLATE_RECOGNIZED) {
                        pe.getCarArrivedEvent().setOriginalSourceType(CarArrivedEvent.OriginalSourceType.GROUND_SENSE);
                    }
                } else {
                    pe.setCarArrivedEvent(event);
                }
            }
        }
    }

    private void handleCarLeftEvent(CarLeftEvent event) {
        Collection<PassSession> cls;
        String channelNo = event.getChannelNo();
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            ApplicationService applicationService;
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)("channel \u4e3a\u7a7a\uff0c\u9519\u8bef\u7684\u901a\u9053\u7f16\u53f7: " + channelNo + " \u4e0d\u5904\u7406\u672c\u6b21\u6709\u8f66\u6765\u4e8b\u4ef6! "));
            }
            if ((applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getMessageLog().hasHandlers()) {
                applicationService.getMessageLog().warn("\u9519\u8bef\u901a\u9053\u7f16\u53f7: " + channelNo + " \u4e0d\u5904\u7406\u672c\u6b21\u6709\u8f66\u6765\u4e8b\u4ef6!");
            }
            return;
        }
        if (event.getOriginalSourceType() != CarLeftEvent.OriginalSourceType.GROUND_SENSE) {
            return;
        }
        if (event.getVehicleDetectorEvent() == null) {
            return;
        }
        if (event.getVehicleDetectorEvent().getType() == 0 && (cls = passChannel.getSessions()) != null) {
            for (PassSession session : cls) {
                long sessionTimeoutMills;
                if (session.isTempSession()) continue;
                if (session.getSessionState() == PassSession.SessionState.PENDING) {
                    session.setCarLeftEvent(event);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    break;
                }
                if (session.getReadPassportNumberEvent() == null || session.getPlateRecognizedEvent() == null && session.getReadPassportNumberEvent().getDetectedPassEvent() == null || session.getCarArrivedEvent() == null || session.getCarArrivedEvent().getOriginalSourceType() != CarArrivedEvent.OriginalSourceType.GROUND_SENSE || session.getCarLeftEvent() != null || session.getSessionState() != PassSession.SessionState.PROCESSING && session.getSessionState() != PassSession.SessionState.WAIT_PAY && session.getSessionState() != PassSession.SessionState.OPEN_DIALOG && session.getSessionState() != PassSession.SessionState.CANCELED && session.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && session.getSessionState() != PassSession.SessionState.CAR_LEAVING) continue;
                session.setCarLeftEvent(event);
                if (session.getSessionState() == PassSession.SessionState.CANCELED) {
                    if (session.getAttribute("PARKING_FULL_QUEUE_FLAG") != null) {
                        session.removeAttribute("PARKING_FULL_QUEUE_FLAG");
                    }
                    int newtimeoutMills = 15000;
                    long sessionTimeoutMills2 = (int)(ServiceUtil.getServiceContext().currentTimeMillis() - session.getCreatedTimeMills()) + newtimeoutMills;
                    if (sessionTimeoutMills2 >= (long)session.getSessionTimeoutMills()) break;
                    session.resetSessionTimeoutMills(newtimeoutMills);
                    break;
                }
                if (session.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && session.getSessionState() != PassSession.SessionState.CAR_LEAVING) break;
                if (session.getSessionState() == PassSession.SessionState.WAIT_CAR_LEAVE) {
                    session.setSessionState(PassSession.SessionState.CAR_LEAVING);
                }
                int newtimeoutMills = 60000;
                try {
                    String sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(session.getPassChannel().getChannelNo(), "CHANNEL_PASS_SUCCESS_TIMEOUT_SEC");
                    if (sv != null && sv.length() > 0) {
                        int t = Integer.parseInt(sv);
                        if (t < 10) {
                            t = 10;
                        } else if (t > 1200) {
                            t = 1200;
                        }
                        newtimeoutMills = t * 1000;
                    }
                }
                catch (Exception t) {
                    // empty catch block
                }
                if ((sessionTimeoutMills = (long)((int)(ServiceUtil.getServiceContext().currentTimeMillis() - session.getCreatedTimeMills()) + newtimeoutMills)) >= (long)session.getSessionTimeoutMills()) break;
                session.resetSessionTimeoutMills(newtimeoutMills);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnableFakePlate(String channelNo) {
        try {
            String v = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "FAKE_PLATE_FILTER");
            if (v == null) return false;
            if (v.length() == 0) return false;
            if (Constants.NO_STR.equals(v)) {
                return false;
            }
            String[] ax = v.split(",");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = "2000-01-01 ";
            Calendar cl = Calendar.getInstance();
            cl.set(2000, 0, 1);
            long currentMills = cl.getTimeInMillis();
            String[] stringArray = ax;
            int n = ax.length;
            int n2 = 0;
            while (true) {
                int ind;
                if (n2 >= n) {
                    return false;
                }
                String x = stringArray[n2];
                if ((x = x.trim()).length() != 0 && (ind = x.indexOf(45)) != -1) {
                    String begin = x.substring(0, ind).trim();
                    String end = x.substring(ind + 1).trim();
                    if (begin.length() == 8 && end.length() == 8) {
                        try {
                            Date d1 = df.parse(String.valueOf(date) + begin);
                            Date d2 = df.parse(String.valueOf(date) + end);
                            if (currentMills >= d1.getTime() && currentMills <= d2.getTime()) {
                                return true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void handlePlateRecognizedEvent(PlateRecognizedEvent event) {
        Collection<PassSession> cl;
        String channelNo = event.getChannelNo();
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u7ba1\u7406\u901a\u9053\uff01\u901a\u9053\u7f16\u53f7\uff1a" + channelNo + ", \u4e22\u5f03\u8be5\u8f66\u724c\u8bc6\u522b\u4e8b\u4ef6\uff0c\u8bc6\u522b\u8f66\u724c\uff1a" + event.getPlateNumber()));
            return;
        }
        String plateNumber = event.getPlateNumber();
        if (plateNumber == null) {
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)"\u8f66\u724c\u8bc6\u522b\u4e8b\u4ef6\u4e2d\u8f66\u724c\u53f7\u7801\u5c45\u7136\u4e3a\u7a7a\uff01");
            }
            return;
        }
        if (ServiceUtil.getServiceContext().currentTimeMillis() < passChannel.getNotHandleRegPlateTimeMills()) {
            ServiceLog.getLog().info((Object)("\u8be5\u901a\u9053\u76ee\u524d\u4e0d\u518d\u5904\u7406\u8bc6\u522b\u8f66\u724c\uff0c\u4e22\u5f03\u8f66\u724c:" + plateNumber + ", \u8fd8\u5269: " + (passChannel.getNotHandleRegPlateTimeMills() - ServiceUtil.getServiceContext().currentTimeMillis()) / 1000L + "\u79d2\u5c06\u89e3\u9664\u6b64\u72b6\u6001"));
            return;
        }
        boolean noPlate = plateNumber.equals("\u65e0\u724c\u8f66") || plateNumber.equals("\u65e0\u8f66\u724c") || plateNumber.indexOf("_\u65e0_") != -1;
        boolean noPlatex = false;
        if (noPlate) {
            PassSession lastSession = passChannel.getLastSession();
            if (lastSession != null) {
                Equipment eq;
                if (lastSession.getPlateRecognizedEvent() != null && event.getCameraEquipmentNo() != null && !event.getCameraEquipmentNo().equals(lastSession.getPlateRecognizedEvent().getCameraEquipmentNo()) && (eq = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(lastSession.getPlateRecognizedEvent().getCameraEquipmentNo())) != null && eq.getEquipmentAction() instanceof PlateRegCameraAction && event.getRegTimeMills() - lastSession.getPlateRecognizedEvent().getRegTimeMills() <= 4000L) {
                    ServiceLog.getLog().info((Object)("\u5f53\u524d\u8f66\u9053\uff0c\u4e22\u5f03\u65e0\u724c\u8f66\u8f93\u51fa, \u539f\u56e0\u76f8\u540c\u8f66\u9053\u4e0d\u540c\u76f8\u673a4\u79d2\u5185\u5df2\u7ecf\u8f93\u51fa\u8f66\u724c:" + lastSession.getPlateRecognizedEvent().getPlateNumber()));
                    return;
                }
                PassSession.SessionState s = lastSession.getSessionState();
                if (s == PassSession.SessionState.PENDING) {
                    CarArrivedEvent existArrivedEvent = lastSession.getCarArrivedEvent();
                    if (existArrivedEvent != null) {
                        if (existArrivedEvent.getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                            existArrivedEvent.setPlateNumber("\u65e0\u8f66\u724c");
                            if (event.getPicPath() != null && event.getPicPath().length() > 0) {
                                try {
                                    OperationFutureHandler captureHandle = ServiceUtil.getServiceContext().createOperationFuture();
                                    captureHandle.setResult((Object)0);
                                    CaptureEvent caevent = new CaptureEvent((Equipment)event.getSource(), event.getPicPath(), 16, 1, (OperationFuture<Integer>)captureHandle, System.currentTimeMillis(), channelNo);
                                    existArrivedEvent.setCaptureEvent(caevent);
                                }
                                catch (Exception captureHandle) {
                                    // empty catch block
                                }
                            }
                            lastSession.setPlateRecognizedEvent(event);
                            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                            try {
                                if (passChannel.getLanConnectManageHostState() == null) {
                                    displayVoiceService.playWhenNoplate(passChannel);
                                    lastSession.setAttribute("PLAY_NOPLATE_VOICE_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                            }
                            if (event.getEventPassId() != null && lastSession.getEventPassId() == null) {
                                passChannel.getPassEventHandler().bindPassSession(lastSession, event.getEventPassId());
                            }
                            return;
                        }
                        if (existArrivedEvent.getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.PLATE_RECOGNIZED && "\u65e0\u8f66\u724c".equals(existArrivedEvent.getPlateNumber()) && ServiceUtil.getServiceContext().currentTimeMillis() - existArrivedEvent.getCarArrivedTimeMills() <= 3000L) {
                            return;
                        }
                    }
                    lastSession.setSessionState(PassSession.SessionState.CANCELED);
                    passChannel.invalidateSessionBefore(lastSession);
                    passChannel.invalidateSession(lastSession);
                } else {
                    if (s == PassSession.SessionState.WAIT_PAY) {
                        lastSession.setSessionState(PassSession.SessionState.CANCELED);
                    }
                    passChannel.invalidateSessionBefore(lastSession);
                }
            }
            VehicleDetectorEvent vehicleDetectorEvent = null;
            List<Equipment> eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
            if (eqList != null && !eqList.isEmpty()) {
                for (Equipment eq : eqList) {
                    if (!(eq.getEquipmentAction() instanceof InputIoDetectedAction) || !((InputIoDetectedAction)eq.getEquipmentAction()).isConnGround(event.getChannelNo()) || !((InputIoDetectedAction)eq.getEquipmentAction()).isGroundPressure(event.getChannelNo())) continue;
                    vehicleDetectorEvent = new VehicleDetectorEvent(eq, 0, 1, event.getChannelNo());
                    break;
                }
            }
            CarArrivedEvent newArrivedEvent = vehicleDetectorEvent == null ? new CarArrivedEvent(event.getSource(), CarArrivedEvent.OriginalSourceType.PLATE_RECOGNIZED, channelNo, null) : new CarArrivedEvent(event.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, vehicleDetectorEvent);
            newArrivedEvent.setPlateNumber("\u65e0\u8f66\u724c");
            try {
                OperationFutureHandler captureHandle = ServiceUtil.getServiceContext().createOperationFuture();
                captureHandle.setResult((Object)0);
                CaptureEvent caevent = new CaptureEvent((Equipment)event.getSource(), event.getPicPath(), 16, 1, (OperationFuture<Integer>)captureHandle, System.currentTimeMillis(), channelNo);
                newArrivedEvent.setCaptureEvent(caevent);
            }
            catch (Exception captureHandle) {
                // empty catch block
            }
            PassSession newSession = passChannel.openSession();
            newSession.setPlateRecognizedEvent(event);
            newSession.setCarArrivedEvent(newArrivedEvent);
            if (newArrivedEvent.getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                newSession.resetSessionTimeoutMills(1200000);
            }
            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            if (passChannel.getLanConnectManageHostState() == null) {
                displayVoiceService.playWhenNoplate(passChannel);
                newSession.setAttribute("PLAY_NOPLATE_VOICE_MILLS", ServiceUtil.getServiceContext().currentTimeMillis());
            }
            if (event.getEventPassId() != null && newSession.getEventPassId() == null) {
                passChannel.getPassEventHandler().bindPassSession(newSession, event.getEventPassId());
            }
            return;
        }
        if (plateNumber.startsWith("\u65e0")) {
            noPlatex = true;
        }
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (!noPlatex) {
            Collection<PassSession> sessionList;
            block171: {
                ChannelArea channelArea;
                if (this.isEnableFakePlate(channelNo) && event.getPlateJudgeDes() != null && event.getPlateJudgeDes().indexOf("\u5047\u8f66\u724c") != -1) {
                    ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u8f66\u724c\u8bc6\u522b\u76f8\u673a\u5224\u65ad\u6b64\u8f66\u724c\u4e3a\u5047\u8f66\u724c\uff0c\u8fd9\u5c06\u4e22\u5f03\u8be5\u8f66\u724c: " + event.getPlateNumber()));
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u8f66\u724c: " + plateNumber + "\uff0c\u539f\u56e0: \u5047\u8f66\u724c", 2));
                    return;
                }
                Object discardReson = ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)("PASS_CHANNEL_DISCARD_PLATE_" + channelNo + ":" + plateNumber));
                if (discardReson != null) {
                    ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u8f66\u724c: " + plateNumber + "\uff0c\u539f\u56e0: " + discardReson));
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u8f66\u724c: " + plateNumber + "\uff0c\u539f\u56e0: " + discardReson, 2));
                    return;
                }
                DBConfigCache dbcache = ServiceUtil.getServiceContext().getDBConfigCache();
                String plateFilter = dbcache.getChannelStrategyValue(channelNo, "CHANNEL_PLATE_FILTER");
                if (plateFilter == null || plateFilter.length() == 0) {
                    plateFilter = "TTTTT,ZZZZZ";
                }
                if (plateFilter != null && plateFilter.length() > 0) {
                    String[] zdddd;
                    String[] stringArray = zdddd = plateFilter.split(",");
                    int n = zdddd.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String z = stringArray[n2];
                        if ((z = z.trim()).length() > 0 && plateNumber.endsWith(z)) {
                            ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u4e22\u5f03\u8f66\u724c: " + plateNumber + "\uff0c\u539f\u56e0: \u8f66\u724c:" + plateNumber + "\u88ab\u5b9a\u4e49\u6210\u65e0\u6548!"));
                            if (applicationService.getMessageLog().hasHandlers()) {
                                applicationService.getMessageLog().debug(channelNo, "\u8f66\u724c:" + plateNumber + "\u88ab\u5b9a\u4e49\u6210\u65e0\u6548!");
                            }
                            return;
                        }
                        ++n2;
                    }
                }
                if ((channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(channelNo)) != null) {
                    int noHanleSec;
                    String noHanleSec1;
                    if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
                        noHanleSec1 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_EXIT_NOT_REG_SECS");
                        if (noHanleSec1 != null && noHanleSec1.length() > 0) {
                            noHanleSec = 0;
                            try {
                                noHanleSec = Integer.parseInt(noHanleSec1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (noHanleSec > 0) {
                                try {
                                    int sec;
                                    Object filterArea;
                                    CarparkChannel channel;
                                    SearchParam preseceRecordParam = new SearchParam().addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                    preseceRecordParam.addEQ("enter_plate", (Object)plateNumber);
                                    String filterPassChannelNo = null;
                                    String filterEnterChannelNo = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_EXIT_NOT_REG_REF_ENTER");
                                    if (!(filterEnterChannelNo == null || filterEnterChannelNo.length() <= 0 || Constants.NO_STR.equals(filterEnterChannelNo) || channelNo.equals(filterEnterChannelNo) || (channel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(filterEnterChannelNo)) == null || (filterArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(filterEnterChannelNo)) == null || filterArea.getEnterAreas() == null || filterArea.getEnterAreas().isEmpty())) {
                                        boolean found = false;
                                        for (CarparkArea area : channelArea.getExitAreas()) {
                                            for (CarparkArea area1 : filterArea.getEnterAreas()) {
                                                if (!area.getArea_no().equals(area1.getArea_no())) continue;
                                                found = true;
                                                break;
                                            }
                                            if (found) break;
                                        }
                                        if (found) {
                                            filterPassChannelNo = filterEnterChannelNo;
                                        }
                                    }
                                    if (filterPassChannelNo != null && filterPassChannelNo.length() > 0) {
                                        preseceRecordParam.addEQ("enter_channel_no", (Object)filterPassChannelNo);
                                    } else if (channelArea.getExitAreas().size() == 1) {
                                        preseceRecordParam.addEQ("area_no", (Object)channelArea.getExitAreas().get(0).getArea_no());
                                    } else {
                                        for (CarparkArea area : channelArea.getExitAreas()) {
                                            preseceRecordParam.addIN("area_no", (Object)area.getArea_no());
                                        }
                                    }
                                    preseceRecordParam.setQueryFields(new String[]{"enter_time", "enter_plate"});
                                    preseceRecordParam.setOrder_by("enter_time");
                                    Pagination pagination = new Pagination();
                                    pagination.setNeedQueryCount(false);
                                    pagination.setRecordsCount(1L);
                                    pagination.setGotoPage(1);
                                    pagination.setPageSize(1);
                                    CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                    CarparkPresenceRecord r = (CarparkPresenceRecord)commonDaoService.selectOne(preseceRecordParam, CarparkPresenceRecord.class, pagination);
                                    if (r == null || r.getEnter_time() == null || (sec = (int)((System.currentTimeMillis() - r.getEnter_time().getTime()) / 1000L)) < 0 || sec >= noHanleSec) break block171;
                                    int min = noHanleSec / 60;
                                    int sec1 = noHanleSec % 60;
                                    String z = "";
                                    if (min > 0) {
                                        z = String.valueOf(z) + min + "\u5206\u949f";
                                    }
                                    if (sec1 > 0) {
                                        z = String.valueOf(z) + sec1 + "\u79d2";
                                    }
                                    if (filterPassChannelNo != null) {
                                        CarparkChannel channel2 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(filterPassChannelNo);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + plateNumber + "\uff0c\u4ece" + channel2.getChannel_name() + "\u8fdb\u573a\u4e0d\u8d85\u8fc7: " + z + ", \u672c\u8f66\u9053\u6682\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u79bb\u573a", 2));
                                    } else {
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + plateNumber + "\uff0c\u8fdb\u573a\u4e0d\u8d85\u8fc7: " + z + ", \u7981\u6b62\u4ece\u672c\u8f66\u9053\u79bb\u573a", 2));
                                    }
                                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                    try {
                                        if (passChannel.getLanConnectManageHostState() == null) {
                                            displayVoiceService.displayMsg(passChannel, "\u505c\u8f66\u4e0d\u8db3" + z + ", \u8bf7\u7a0d\u540e\u518d\u4ece\u672c\u8f66\u9053\u79bb\u573a", plateNumber, false);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                                    }
                                    return;
                                }
                                catch (Exception ex) {
                                    ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                                }
                            }
                        }
                    } else if (channelArea.getEnterAreas() != null && !channelArea.getEnterAreas().isEmpty()) {
                        PassChannel exPassChannel;
                        ChannelArea filterArea;
                        CarparkChannel channel;
                        String filterExitChannelNo;
                        Object r;
                        block172: {
                            noHanleSec1 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_ENTER_NOT_REG_SECS");
                            if (noHanleSec1 != null && noHanleSec1.length() > 0) {
                                noHanleSec = 0;
                                try {
                                    noHanleSec = Integer.parseInt(noHanleSec1);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                if (noHanleSec > 0) {
                                    try {
                                        int sec;
                                        ChannelArea filterArea2;
                                        CarparkChannel channel3;
                                        SearchParam passRecordParam = new SearchParam().addEQ("project_id", (Object)ServiceUtil.getServiceContext().getProjectId()).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                        passRecordParam.addEQ("pass_plate", (Object)plateNumber);
                                        Calendar cl2 = Calendar.getInstance();
                                        cl2.set(14, 0);
                                        cl2.add(11, -24);
                                        passRecordParam.addGT("pass_time", (Object)cl2.getTime());
                                        passRecordParam.addNotEQ("exit_time", null);
                                        String filterPassChannelNo = null;
                                        String filterExitChannelNo2 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_ENTER_NOT_REG_REF_EXIT");
                                        if (!(filterExitChannelNo2 == null || filterExitChannelNo2.length() <= 0 || Constants.NO_STR.equals(filterExitChannelNo2) || channelNo.equals(filterExitChannelNo2) || (channel3 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(filterExitChannelNo2)) == null || (filterArea2 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(filterExitChannelNo2)) == null || filterArea2.getExitAreas() == null || filterArea2.getExitAreas().isEmpty())) {
                                            boolean found = false;
                                            Iterator<CarparkArea> sec1 = channelArea.getEnterAreas().iterator();
                                            if (sec1.hasNext()) {
                                                CarparkArea area = sec1.next();
                                                for (CarparkArea area1 : filterArea2.getExitAreas()) {
                                                    if (!area.getArea_no().equals(area1.getArea_no())) continue;
                                                    found = true;
                                                    break;
                                                }
                                            }
                                            if (found) {
                                                filterPassChannelNo = filterExitChannelNo2;
                                            }
                                        }
                                        if (filterPassChannelNo != null && filterPassChannelNo.length() > 0) {
                                            passRecordParam.addEQ("exit_channel_no", (Object)filterPassChannelNo);
                                        } else {
                                            passRecordParam.addEQ("area_no", (Object)channelArea.getEnterAreas().get(0).getArea_no());
                                        }
                                        passRecordParam.setQueryFields(new String[]{"pass_time", "exit_time", "pass_plate"});
                                        passRecordParam.setOrder_by("pass_time DESC");
                                        Pagination pagination = new Pagination();
                                        pagination.setNeedQueryCount(false);
                                        pagination.setRecordsCount(1L);
                                        pagination.setPageSize(1);
                                        pagination.setGotoPage(1);
                                        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                        r = (CarparkPassRecord)commonDaoService.selectOne(passRecordParam, CarparkPassRecord.class, pagination);
                                        if (r == null || ((CarparkPassRecord)r).getExit_time() == null || (sec = (int)((System.currentTimeMillis() - ((CarparkPassRecord)r).getExit_time().getTime()) / 1000L)) < 0 || sec >= noHanleSec) break block172;
                                        int min = noHanleSec / 60;
                                        int sec1 = noHanleSec % 60;
                                        String z = "";
                                        if (min > 0) {
                                            z = String.valueOf(z) + min + "\u5206\u949f";
                                        }
                                        if (sec1 > 0) {
                                            z = String.valueOf(z) + sec1 + "\u79d2";
                                        }
                                        if (filterPassChannelNo != null) {
                                            CarparkChannel channel4 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(filterPassChannelNo);
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + plateNumber + "\uff0c\u8be5\u8f66\u724c\u4ece" + channel4.getChannel_name() + "\u79bb\u573a\u4e0d\u8d85\u8fc7: " + z + ", \u672c\u8f66\u9053\u6682\u4e0d\u5904\u7406\u6b64\u8f66\u724c\u5165\u573a", 2));
                                        } else {
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passChannel, String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + plateNumber + "\uff0c\u79bb\u573a\u4e0d\u8d85\u8fc7: " + z + ", \u7981\u6b62\u4ece\u672c\u8f66\u9053\u5165\u573a", 2));
                                        }
                                        DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                        try {
                                            if (passChannel.getLanConnectManageHostState() == null) {
                                                displayVoiceService.displayMsg(passChannel, "\u79bb\u573a\u4e0d\u8db3" + z + ", \u8bf7\u7a0d\u540e\u518d\u4ece\u672c\u8f66\u9053\u5165\u573a", plateNumber, false);
                                            }
                                        }
                                        catch (Exception ex) {
                                            ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                                        }
                                        return;
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                                    }
                                }
                            }
                        }
                        if (!((filterExitChannelNo = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_ENTER_NOT_REG_EXIT_PAY")) == null || filterExitChannelNo.length() <= 0 || Constants.NO_STR.equals(filterExitChannelNo) || filterExitChannelNo.equals(channelNo) || (channel = ServiceUtil.getServiceContext().getDBConfigCache().getChannelsMap().get(filterExitChannelNo)) == null || (filterArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(filterExitChannelNo)) == null || filterArea.getExitAreas() == null || filterArea.getExitAreas().isEmpty() || (exPassChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(filterExitChannelNo)) == null)) {
                            Collection<PassSession> sessionList2 = exPassChannel.getSessions();
                            PassSession plateConfirmSession = null;
                            if (sessionList2 != null) {
                                r = sessionList2.iterator();
                                while (r.hasNext()) {
                                    PassSession s = (PassSession)r.next();
                                    if (s.getSessionState() != PassSession.SessionState.WAIT_PAY && s.getSessionState() != PassSession.SessionState.OPEN_DIALOG || s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().isManualTrigger()) continue;
                                    plateConfirmSession = s;
                                }
                            }
                            if (plateConfirmSession != null) {
                                boolean discard;
                                int connGroudCount = 0;
                                int pesureCount = 0;
                                List<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
                                if (eqs != null && !eqs.isEmpty()) {
                                    for (Equipment eq : eqs) {
                                        InputIoDetectedAction act;
                                        Object ac = eq.getEquipmentAction();
                                        if (ac == null || !(ac instanceof InputIoDetectedAction) || !(act = (InputIoDetectedAction)ac).isConnGround(filterExitChannelNo)) continue;
                                        ++connGroudCount;
                                        if (!act.isGroundPressure(filterExitChannelNo)) continue;
                                        ++pesureCount;
                                    }
                                }
                                if (connGroudCount > 0) {
                                    if (pesureCount == 0) {
                                        discard = false;
                                        ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u8bc6\u522b\u5230\u8f66\u724c: " + event.getPlateNumber() + ", \u5171\u95f8\u8f66\u9053\uff1a" + plateConfirmSession.getPassChannel().getChannel().getChannel_name() + ", \u6b63\u5728\u5f39\u6846\u786e\u8ba4\u8f66\u724c\uff1a" + plateConfirmSession.getPassPlate() + ", \u4f46\u662f\u6ca1\u6709\u68c0\u6d4b\u5230\u51fa\u53e3\u5730\u611f\u4fe1\u53f7\uff0c\u5f39\u6846\u65e0\u6548, \u8fd9\u5c06\u5904\u7406\u5165\u53e3\u8f66\u724c"));
                                    } else {
                                        discard = true;
                                        ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u8bc6\u522b\u5230\u8f66\u724c: " + event.getPlateNumber() + ", \u5171\u95f8\u8f66\u9053\uff1a" + plateConfirmSession.getPassChannel().getChannel().getChannel_name() + ", \u6b63\u5728\u5f39\u6846\u786e\u8ba4\u8f66\u724c\uff1a" + plateConfirmSession.getPassPlate() + ", \u51fa\u53e3\u5730\u611f\u88ab\u538b\u7740\u4e86\uff0c\u5f39\u6846\u6709\u6548, \u8fd9\u5c06\u4e22\u5f03\u5165\u53e3\u8f66\u724c"));
                                    }
                                } else {
                                    discard = true;
                                    ServiceLog.getLog().info((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u8bc6\u522b\u5230\u8f66\u724c: " + event.getPlateNumber() + ", \u5171\u95f8\u8f66\u9053\uff1a" + plateConfirmSession.getPassChannel().getChannel().getChannel_name() + ", \u6b63\u5728\u5f39\u6846\u786e\u8ba4\u8f66\u724c\uff1a" + plateConfirmSession.getPassPlate() + ", \u51fa\u53e3\u6ca1\u6709\u5730\u611f\uff0c\u5f39\u6846\u6709\u6548, \u8fd9\u5c06\u4e22\u5f03\u5165\u53e3\u8f66\u724c\u76f4\u5230\u5f39\u6846\u8d85\u65f6"));
                                }
                                if (discard) {
                                    DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                                    try {
                                        if (passChannel.getLanConnectManageHostState() == null) {
                                            Cost cost = (Cost)plateConfirmSession.getAttribute("pass_cost");
                                            if (cost != null && cost.getCash().doubleValue() > 0.0) {
                                                displayVoiceService.displayMsg(passChannel, "\u79bb\u573a\u8f66\u8f86\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5176\u5148\u79bb\u573a\u518d\u8fdb\u573a", plateNumber, true);
                                            } else {
                                                displayVoiceService.displayMsg(passChannel, "\u79bb\u573a\u8f66\u8f86\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5176\u5148\u79bb\u573a\u518d\u8fdb\u573a", plateNumber, true);
                                            }
                                        }
                                    }
                                    catch (Exception ex) {
                                        ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
            }
            String v9 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_DIALOG_DISCARD_SAMEPLATE_SEC");
            long discardTime = 60L;
            try {
                if (v9 != null && v9.length() > 0) {
                    discardTime = Long.parseLong(v9);
                }
            }
            catch (Exception ex) {
                discardTime = 60L;
            }
            if ((discardTime *= 1000L) < 60000L) {
                discardTime = 60000L;
            }
            if ((sessionList = passChannel.getSessions()) != null) {
                for (PassSession s : sessionList) {
                    if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG || s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().isManualTrigger() || s.getReadPassportNumberEvent().getPassportMediumType() != 6) continue;
                    PlateRecognizedEvent ave = s.getPlateRecognizedEvent();
                    if (ave == null) {
                        ave = s.getReadPassportNumberEvent().getPlateRecognizedEvent();
                    }
                    if (ave == null || ave.getPlateNumber() == null || !ave.getPlateNumber().equals(plateNumber) || event.getRegTimeMills() - ave.getRegTimeMills() <= discardTime) continue;
                    s.removeCancelPassRecord();
                    s.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    s.setSessionState(PassSession.SessionState.CANCELED);
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback == null) continue;
                    callback.doClosePassDialog(s);
                }
            }
        }
        if (applicationService.getMessageLog().hasHandlers()) {
            StringBuilder sbr = new StringBuilder(128);
            sbr.append(",\u8bc6\u522b\u5230\u8f66\u724c\uff1a").append(noPlatex ? "\u65e0\u724c\u8f66" : plateNumber).append(", \u989c\u8272:").append(event.getPlateColor()).append(", \u8bbe\u5907:");
            Equipment eqm = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(event.getCameraEquipmentNo());
            if (eqm != null) {
                sbr.append(eqm.getName());
                sbr.append(" [").append(eqm.getIp()).append("]");
            }
            sbr.append("\u3002");
            applicationService.getMessageLog().debug(channelNo, sbr.toString());
        }
        if (ServiceLog.getLog().isDebugEnabled()) {
            ServiceLog.getLog().debug((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + "\u8bc6\u522b\u5230\u8f66\u724c: " + event.getPlateNumber()));
        }
        PassSession newSession = null;
        PassSession lastSession = passChannel.getLastSession();
        if (lastSession != null) {
            long x;
            if (noPlatex && lastSession.getPlateRecognizedEvent() != null && lastSession.getPlateRecognizedEvent().getPlateNumber() != null && lastSession.getPlateRecognizedEvent().getPlateNumber().startsWith("\u65e0") && ((x = event.getRegTimeMills() - lastSession.getPlateRecognizedEvent().getRegTimeMills()) < 3000L || lastSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG && x <= 60000L)) {
                return;
            }
            PassSession.SessionState s = lastSession.getSessionState();
            if (s == PassSession.SessionState.PENDING) {
                CarArrivedEvent existArrivedEvent = lastSession.getCarArrivedEvent();
                if (existArrivedEvent != null && lastSession.getPlateRecognizedEvent() == null && existArrivedEvent.getOriginalSourceType() == CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                    lastSession.setPlateRecognizedEvent(event);
                    existArrivedEvent.setPlateNumber(plateNumber);
                    newSession = lastSession;
                }
                passChannel.invalidateSessionBefore(lastSession);
                if (newSession == null) {
                    lastSession.setSessionState(PassSession.SessionState.CANCELED);
                    passChannel.invalidateSession(lastSession);
                }
            } else {
                Object channelArea;
                Boolean samePlate = null;
                if (lastSession.getPlateRecognizedEvent() != null) {
                    if (lastSession.getPlateRecognizedEvent().getPlateNumber().equals(event.getPlateNumber())) {
                        samePlate = Boolean.TRUE;
                        if (event.getRegTimeMills() - lastSession.getPlateRecognizedEvent().getRegTimeMills() < 3000L) {
                            return;
                        }
                    } else {
                        samePlate = Boolean.FALSE;
                    }
                } else if (lastSession.getCarArrivedEvent() != null && lastSession.getCarArrivedEvent().getPlateNumber() != null && lastSession.getCarArrivedEvent().getPlateNumber().equals("\u65e0\u8f66\u724c")) {
                    samePlate = Boolean.FALSE;
                }
                passChannel.invalidateSessionBefore(lastSession);
                if (samePlate != null && samePlate.booleanValue()) {
                    if (s == PassSession.SessionState.CANCELED) {
                        passChannel.invalidateSession(lastSession);
                    } else {
                        if (s == PassSession.SessionState.OPEN_DIALOG || s == PassSession.SessionState.WAIT_PAY) {
                            return;
                        }
                        if ((s == PassSession.SessionState.WAIT_CAR_LEAVE || s == PassSession.SessionState.CAR_LEAVING) && lastSession.getPlateRecognizedEvent() != null) {
                            Long v1 = (Long)lastSession.getAttribute("SAVED_PASSRECORD_MILLS");
                            if (v1 == null) {
                                v1 = lastSession.getPlateRecognizedEvent().getRegTimeMills();
                            }
                            long x2 = event.getRegTimeMills() - v1;
                            ChannelArea chanenlArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
                            if (chanenlArea != null) {
                                int newtimeoutMills = 60000;
                                try {
                                    String sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_PASS_SUCCESS_TIMEOUT_SEC");
                                    if (sv != null && sv.length() > 0) {
                                        int t = Integer.parseInt(sv);
                                        if (t < 10) {
                                            t = 10;
                                        } else if (t > 1200) {
                                            t = 1200;
                                        }
                                        newtimeoutMills = t * 1000;
                                    }
                                }
                                catch (Exception t) {
                                    // empty catch block
                                }
                                if (x2 < (long)newtimeoutMills) {
                                    boolean discard;
                                    String sv1 = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_PASS_SUCCESS_HANDLE_METHOD");
                                    boolean bl = discard = sv1 != null && "0".equals(sv1);
                                    if (discard) {
                                        String msg = String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + newtimeoutMills / 1000 + "\u79d2\u5185\u8fde\u7eed\u91cd\u65b0\u8bc6\u522b\u5230\u653e\u884c\u6210\u529f\u8f66\u724c! \u8fd9\u5c06\u4e22\u5f03\u6b64\u8f66\u724c: " + event.getPlateNumber();
                                        ServiceLog.getLog().info((Object)msg);
                                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                        return;
                                    }
                                    CarparkArea area = null;
                                    boolean enter = false;
                                    if (chanenlArea.getEnterAreas() != null && !chanenlArea.getEnterAreas().isEmpty()) {
                                        area = chanenlArea.getEnterAreas().get(0);
                                        enter = true;
                                    } else if (chanenlArea.getExitAreas() != null && !chanenlArea.getExitAreas().isEmpty() && (area = (CarparkArea)lastSession.getAttribute("PASS_EXIT_AREA")) == null) {
                                        area = chanenlArea.getExitAreas().get(chanenlArea.getExitAreas().size() - 1);
                                    }
                                    if (area != null) {
                                        String msg;
                                        String msg2;
                                        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                                        SearchParam serachP = new SearchParam().setQueryFields(new String[]{"enter_time"}).addEQ("enter_plate", (Object)plateNumber).addNotEQ("enter_time", null).addEQ("area_no", (Object)area.getArea_no()).addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                                        CarparkPresenceRecord record = (CarparkPresenceRecord)commonDaoService.selectOne(serachP, CarparkPresenceRecord.class);
                                        if (enter) {
                                            if (record != null && record.getEnter_time() != null && System.currentTimeMillis() - record.getEnter_time().getTime() < (long)newtimeoutMills) {
                                                if (x2 > 10000L) {
                                                    boolean localOpen = false;
                                                    if (passChannel.getLanConnectManageHostState() == null) {
                                                        passChannel.openPole(lastSession);
                                                        localOpen = true;
                                                    }
                                                    msg2 = String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + newtimeoutMills / 1000 + "\u79d2\u5185\u8fde\u7eed\u91cd\u65b0\u8bc6\u522b\u5230\u653e\u884c\u6210\u529f\u8f66\u724c!  \u8fd9\u5c06\u91cd\u65b0\u5f00\u95f8\u653e\u884c: " + event.getPlateNumber() + ", " + (localOpen ? "\u672c\u673a\u5f00\u95f8\u5904\u7406" : "\u7531\u76d2\u5b50\u5f00\u95f8\u5904\u7406");
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg2, 2));
                                                    ServiceLog.getLog().info((Object)(String.valueOf(msg2) + ", \u53ef\u80fd\u662f\u524d\u8f66\u5728\u672a\u79bb\u5f00\u9053\u95f8\uff0c\u9053\u95f8\u672a\u843d\u6746\uff0c\u540e\u8f66\u76f4\u63a5\u5f00\u95f8\u653e\u884c\uff0c\u524d\u8f66\u79bb\u5f00\u843d\u6746\u5bfc\u81f4\u540e\u8f66\u65e0\u6cd5\u79bb\u5f00"));
                                                } else {
                                                    msg = String.valueOf(passChannel.getChannel().getChannel_name()) + ": 10\u79d2\u5185\u8fde\u7eed\u91cd\u65b0\u8bc6\u522b\u5230\u653e\u884c\u6210\u529f\u8f66\u724c! \u8fd9\u5c06\u4e22\u5f03\u6b64\u8f66\u724c: " + event.getPlateNumber();
                                                    ServiceLog.getLog().info((Object)msg);
                                                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                                }
                                                return;
                                            }
                                        } else if (record == null) {
                                            if (x2 > 10000L) {
                                                boolean localOpen = false;
                                                if (passChannel.getLanConnectManageHostState() == null) {
                                                    passChannel.openPole(lastSession);
                                                    localOpen = true;
                                                }
                                                msg2 = String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + newtimeoutMills / 1000 + "\u79d2\u5185\u8fde\u7eed\u91cd\u65b0\u8bc6\u522b\u5230\u653e\u884c\u6210\u529f\u8f66\u724c!  \u8fd9\u5c06\u91cd\u65b0\u5f00\u95f8\u653e\u884c: " + event.getPlateNumber() + (localOpen ? "\u672c\u673a\u5f00\u95f8\u5904\u7406" : "\u7531\u76d2\u5b50\u5f00\u95f8\u5904\u7406");
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg2, 2));
                                                ServiceLog.getLog().info((Object)(String.valueOf(msg2) + ", \u53ef\u80fd\u662f\u524d\u8f66\u5728\u672a\u79bb\u5f00\u9053\u95f8\uff0c\u9053\u95f8\u672a\u843d\u6746\uff0c\u540e\u8f66\u76f4\u63a5\u5f00\u95f8\u653e\u884c\uff0c\u524d\u8f66\u79bb\u5f00\u843d\u6746\u5bfc\u81f4\u540e\u8f66\u65e0\u6cd5\u79bb\u5f00"));
                                            } else {
                                                msg = String.valueOf(passChannel.getChannel().getChannel_name()) + ": 10\u79d2\u5185\u8fde\u7eed\u91cd\u65b0\u8bc6\u522b\u5230\u653e\u884c\u6210\u529f\u8f66\u724c! \u8fd9\u5c06\u4e22\u5f03\u6b64\u8f66\u724c: " + event.getPlateNumber();
                                                ServiceLog.getLog().info((Object)msg);
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                if (!(s != PassSession.SessionState.WAIT_PAY && s != PassSession.SessionState.OPEN_DIALOG || (channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(channelNo)) == null || channelArea.getExitAreas() == null || channelArea.getExitAreas().isEmpty() || lastSession.getPlateRecognizedEvent() == null || lastSession.getPlateRecognizedEvent().getPlateNumber().equals(event.getPlateNumber()))) {
                    boolean noEnter = false;
                    if (lastSession.getConfirmPassExceptions() != null && lastSession.getConfirmPassExceptions().contains(3)) {
                        noEnter = true;
                    } else if (lastSession.getAllowPassExcetpions() != null && lastSession.getAllowPassExcetpions().contains(3)) {
                        noEnter = true;
                    }
                    if (!noEnter) {
                        long zv;
                        String sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_DI_ORTHR_REG_NO_ENTER_DIS_TIME");
                        int xv = 120;
                        try {
                            if (sv != null && sv.length() > 0) {
                                int z;
                                xv = z = Integer.parseInt(sv);
                            }
                        }
                        catch (Exception z) {
                            // empty catch block
                        }
                        if (xv > 0 && (zv = event.getRegTimeMills() - lastSession.getPlateRecognizedEvent().getRegTimeMills()) < (long)(xv * 1000)) {
                            SearchParam preseceRecordParam = new SearchParam().addEQ("carpark_id", (Object)ServiceUtil.getServiceContext().getCarparkId());
                            preseceRecordParam.addEQ("enter_plate", (Object)plateNumber);
                            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                            preseceRecordParam.setTableName(commonDaoService.getTableName(CarparkPresenceRecord.class));
                            long count = commonDaoService.selectCount(preseceRecordParam);
                            if (count == 0L) {
                                String msg = String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + lastSession.getPlateRecognizedEvent().getPlateNumber() + " \u6b63\u5728\u786e\u8ba4\u4e2d! " + xv + "\u79d2\u5185\u6536\u5230\u4e00\u4e2a\u65e0\u5165\u573a\u8bb0\u5f55\u8f66\u724c\uff1a" + event.getPlateNumber() + ", \u8fd9\u5c06\u4e22\u5f03\u6b64\u8f66\u724c ";
                                ServiceLog.getLog().info((Object)msg);
                                msg = String.valueOf(passChannel.getChannel().getChannel_name()) + ": " + lastSession.getPlateRecognizedEvent().getPlateNumber() + " \u6b63\u5728\u786e\u8ba4\u4e2d! \u6536\u5230\u4e00\u4e2a\u65e0\u5165\u573a\u8bb0\u5f55\u8f66\u724c\uff1a" + event.getPlateNumber() + ", \u8fd9\u5c06\u4e22\u5f03\u6b64\u8f66\u724c ";
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 2));
                                return;
                            }
                        }
                    }
                }
            }
        }
        if ((cl = passChannel.getSessions()) != null) {
            for (PassSession s : cl) {
                if (s.getSessionState() != PassSession.SessionState.OPEN_DIALOG) continue;
                if (s.getPlateRecognizedEvent() != null && plateNumber.equals(s.getPlateRecognizedEvent().getPlateNumber())) {
                    return;
                }
                if (s.getReadPassportNumberEvent() == null || s.getReadPassportNumberEvent().getPlateNumber() == null || !s.getReadPassportNumberEvent().getPlateNumber().equals(plateNumber)) continue;
                return;
            }
        }
        ReadPassportNumberEvent revent = null;
        DetectedPassEvent obuEvent = passChannel.getDetectedObuEvent();
        if (obuEvent != null && obuEvent.getPlateNumber() != null && obuEvent.getMediaType() == DetectedPassEvent.MediaType.OBU && event.getRegTimeMills() - obuEvent.getReadTimeMills() <= 5000L && (plateNumber.equals(obuEvent.getPlateNumber()) || applicationService.plateEquals(plateNumber, obuEvent.getPlateNumber(), 1))) {
            revent = new ReadPassportNumberEvent(obuEvent.getSource(), obuEvent.getPlateNumber(), obuEvent.toIntMediaType(), passChannel.getChannelNo());
            revent.setDetectedPassEvent(obuEvent);
            revent.setPlateRecognizedEvent(event);
            revent.setPlateNumber(obuEvent.getPlateNumber());
        }
        if (revent == null) {
            revent = new ReadPassportNumberEvent(event.getSource(), event.getPlateNumber(), 6, passChannel.getChannelNo());
            revent.setPlateNumber(event.getPlateNumber());
            revent.setPlateRecognizedEvent(event);
        }
        if (newSession == null) {
            newSession = passChannel.openSession();
        }
        newSession.setReadPassportNumberEvent(revent);
        newSession.setPlateRecognizedEvent(event);
        VehicleDetectorEvent vehicleDetectorEvent = null;
        List<Equipment> eqList = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
        if (eqList != null && !eqList.isEmpty()) {
            for (Equipment eq : eqList) {
                if (!(eq.getEquipmentAction() instanceof InputIoDetectedAction) || !((InputIoDetectedAction)eq.getEquipmentAction()).isConnGround(event.getChannelNo()) || !((InputIoDetectedAction)eq.getEquipmentAction()).isGroundPressure(event.getChannelNo())) continue;
                vehicleDetectorEvent = new VehicleDetectorEvent(eq, 0, 1, event.getChannelNo());
                break;
            }
        }
        if (newSession.getCarArrivedEvent() == null) {
            CarArrivedEvent newArrivedEvent = vehicleDetectorEvent == null ? new CarArrivedEvent(event.getSource(), CarArrivedEvent.OriginalSourceType.PLATE_RECOGNIZED, channelNo, null) : new CarArrivedEvent(event.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, vehicleDetectorEvent);
            newArrivedEvent.setPlateNumber(plateNumber);
            newSession.setCarArrivedEvent(newArrivedEvent);
        } else if (vehicleDetectorEvent != null) {
            CarArrivedEvent newArrivedEvent = new CarArrivedEvent(event.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, vehicleDetectorEvent);
            newArrivedEvent.setPlateNumber(plateNumber);
            newSession.setCarArrivedEvent(newArrivedEvent);
        } else {
            newSession.getCarArrivedEvent().setPlateNumber(plateNumber);
        }
        if (event.getEventPassId() != null && newSession.getEventPassId() == null) {
            passChannel.getPassEventHandler().bindPassSession(newSession, event.getEventPassId());
        }
        newSession.start();
    }

    private void handleReadPassportNumberEvent(ReadPassportNumberEvent event) {
        PassSession passSession;
        ApplicationService applicationService;
        String channelNo = event.getChannelNo();
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u7ba1\u7406\u901a\u9053\uff01\u901a\u9053\u7f16\u53f7\uff1a" + channelNo + ", \u4e22\u5f03\u8be5\u8bfb\u5361\u4e8b\u4ef6\uff0c(" + Constants.getMediumTypeDes(event.getPassportMediumType()) + ")\uff1a" + event.getPassportNumber()));
            event.triggerPassError("\u65e0\u6548\u653e\u884c\u901a\u9053");
            return;
        }
        String passportNumber = event.getPassportNumber();
        if (passportNumber == null || passportNumber.length() == 0) {
            ApplicationService applicationService2;
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)("\u901a\u884c\u8bc1\u53f7\u4e3a\u7a7a\uff0c\u4e22\u5f03\u8be5\u4e8b\u4ef6! \u4ecb\u8d28\u7c7b\u578b: " + event.getPassportMediumType() + " " + Constants.getMediumTypeDes(event.getPassportMediumType())));
            }
            if ((applicationService2 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class)).getMessageLog().hasHandlers()) {
                applicationService2.getMessageLog().warn(channelNo, "\u65e0\u6548\u901a\u884c\u8bc1\u53f7!");
            }
            event.triggerPassError("\u5361\u53f7\u4e3a\u7a7a");
            return;
        }
        if (event.getPassSessionData() != null) {
            Collection<PassSession> cls = passChannel.getSessions();
            if (cls != null) {
                for (PassSession session : cls) {
                    ConfirmPassDialogCallback callback;
                    if (session.getReadPassportNumberEvent() == null) {
                        session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                        session.setSessionState(PassSession.SessionState.CANCELED);
                        passChannel.invalidateSession(session);
                        continue;
                    }
                    if (!session.getReadPassportNumberEvent().getPassportNumber().equals(passportNumber) || event.getPassportMediumType() != session.getReadPassportNumberEvent().getPassportMediumType()) continue;
                    PassSession.SessionState st = session.getSessionState();
                    session.removeCancelPassRecord();
                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    if (st == PassSession.SessionState.OPEN_DIALOG && (callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                        callback.doClosePassDialog(session);
                    }
                    passChannel.invalidateSession(session);
                }
            }
            DefaultCarparkEvent vehicleDetectorEvent = null;
            List<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
            if (eqs != null && !eqs.isEmpty()) {
                String chanelNo = passChannel.getChannelNo();
                for (Equipment eq : eqs) {
                    InputIoDetectedAction act;
                    Object ac = eq.getEquipmentAction();
                    if (!(ac instanceof InputIoDetectedAction) || !(act = (InputIoDetectedAction)ac).isConnGround(chanelNo) || !act.isGroundPressure(chanelNo)) continue;
                    vehicleDetectorEvent = new VehicleDetectorEvent(eq, 0, 1, chanelNo);
                    break;
                }
            }
            PassSession passSession2 = passChannel.openSession();
            passSession2.setReadPassportNumberEvent(event);
            if (vehicleDetectorEvent != null) {
                CarArrivedEvent newArrivedEvent = new CarArrivedEvent(vehicleDetectorEvent.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, (VehicleDetectorEvent)vehicleDetectorEvent);
                passSession2.setCarArrivedEvent(newArrivedEvent);
            }
            passSession2.start();
            return;
        }
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(channelNo);
        boolean exit = channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty();
        Collection<PassSession> cl = passChannel.getSessions();
        if (cl != null) {
            for (PassSession s : cl) {
                if (s.getSessionState() == PassSession.SessionState.OPEN_DIALOG) {
                    if (event.isUserScan() || event.getDetectedPassEvent() == null) {
                        if (s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().getPassportNumber().equals(passportNumber)) {
                            Cost cost = (Cost)s.getAttribute("pass_cost");
                            if (exit || cost != null && cost.getActualCharge().doubleValue() > 0.0) {
                                if (event.getRemoteExeHandler() != null && !event.getRemoteExeHandler().isDone()) {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    result.put("responseCode", "0");
                                    result.put("responseMsg", "success");
                                    CommonRemoteServiceImpl.setQueryPassSessionResult(s, result);
                                    event.getRemoteExeHandler().setResult(result);
                                }
                            } else {
                                event.triggerPassError("\u503c\u73ed\u4eba\u5458\u6b63\u5728\u786e\u8ba4\u60a8\u7684\u8eab\u4efd\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e...", "1");
                            }
                            return;
                        }
                        if (s.getPassPlate() != null && event.getPlateNumber() != null && event.getPlateNumber().equals(s.getPassPlate())) {
                            Cost cost = (Cost)s.getAttribute("pass_cost");
                            if (exit || cost.getActualCharge().doubleValue() > 0.0) {
                                if (event.getRemoteExeHandler() != null && !event.getRemoteExeHandler().isDone()) {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    result.put("responseCode", "0");
                                    result.put("responseMsg", "success");
                                    CommonRemoteServiceImpl.setQueryPassSessionResult(s, result);
                                    event.getRemoteExeHandler().setResult(result);
                                }
                                return;
                            }
                        }
                        if (s.getReadPassportNumberEvent() != null && s.getReadPassportNumberEvent().isManualTrigger()) {
                            event.triggerPassError("\u503c\u73ed\u4eba\u5458\u6b63\u5728\u8fdb\u884c\u4eba\u5de5\u653e\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "1");
                            return;
                        }
                        String pla = s.getPassPlate();
                        if (pla != null && pla.length() > 0) {
                            event.triggerPassError("\u503c\u73ed\u4eba\u5458\u6b63\u5728\u786e\u8ba4\u8f66\u724c " + pla + " \u653e\u884c\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "1");
                        } else {
                            event.triggerPassError("\u503c\u73ed\u4eba\u5458\u6b63\u5728\u786e\u8ba4\u5361\u53f7 " + s.getReadPassportNumberEvent().getPassportNumber() + " \u653e\u884c\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "1");
                        }
                        return;
                    }
                    if (s.getReadPassportNumberEvent() == null || !s.getReadPassportNumberEvent().getPassportNumber().equals(passportNumber)) continue;
                    ApplicationService applicationService3 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    if (applicationService3.getMessageLog().hasHandlers()) {
                        applicationService3.getMessageLog().debug(channelNo, "\u901a\u884c\u8bc1\u53f7\u6b63\u5728\u5f39\u51fa\u6846\u4e2d\uff0c\u4e22\u5f03\u5361\u53f7:" + event.getPassportNumber());
                    }
                    if (event.getPassportMediumType() == 0 || event.getPassportMediumType() == 1) {
                        ServiceLog.getLog().info((Object)("\u8be5\u5361\u53f7\u6b63\u5728\u4eba\u5de5\u5904\u7406\u4e2d\uff0c\u4e22\u5f03\u5361\u53f7: " + event.getPassportNumber()));
                        if (event.getDetectedPassEvent() != null && !event.getDetectedPassEvent().isLongDistance()) {
                            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                            try {
                                if (passChannel.getLanConnectManageHostState() == null) {
                                    displayVoiceService.playConfirmPass(s);
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                            }
                        }
                    }
                    if (event.getRemoteExeHandler() != null && !event.getRemoteExeHandler().isDone()) {
                        event.triggerPassError("\u503c\u73ed\u4eba\u5458\u6b63\u5728\u786e\u8ba4\u60a8\u7684\u8eab\u4efd\u4fe1\u606f\uff0c\u8bf7\u7a0d\u540e...", "1");
                    }
                    return;
                }
                if (s.getSessionState() != PassSession.SessionState.WAIT_PAY || !event.isUserScan() && event.getDetectedPassEvent() != null) continue;
                if (event.getRemoteExeHandler() != null && !event.getRemoteExeHandler().isDone()) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("responseCode", "0");
                    result.put("responseMsg", "success");
                    CommonRemoteServiceImpl.setQueryPassSessionResult(s, result);
                    event.getRemoteExeHandler().setResult(result);
                }
                return;
            }
        }
        if (!event.isManualTrigger()) {
            InvalidPassportNumberKey invalidkey = new InvalidPassportNumberKey(channelNo, event.getPassportNumber(), InvalidPassportNumberKey.getCacheMediumType(event));
            if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)invalidkey) != null) {
                ApplicationService applicationService4 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                if (applicationService4.getMessageLog().hasHandlers()) {
                    boolean isObu = event.getDetectedPassEvent() != null && event.getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU;
                    String v = isObu ? "OBU" : Constants.getMediumTypeDes(event.getPassportMediumType());
                    applicationService4.getMessageLog().debug(channelNo, "\u8be5\u901a\u884c\u8bc1\u5df2\u7ecf\u5904\u7406\u8fc7\uff0c\u5c06\u88ab\u4e22\u5f03\uff0c" + v + ":" + event.getPassportNumber());
                }
                event.triggerPassError("\u8be5\u5361\u53f7\u5df2\u88ab\u5904\u7406\u8fc7\uff0c\u77ed\u65f6\u95f4\u5185\u4e0d\u518d\u91cd\u590d\u5904\u7406");
                ServiceLog.getLog().info((Object)("\u8be5\u5361\u53f7\u5df2\u88ab\u5904\u7406\u8fc7\uff0c\u77ed\u65f6\u95f4\u5185\u4e0d\u518d\u91cd\u590d\u5904\u7406: " + event.getPassportNumber()));
                return;
            }
        }
        if (event.getDetectedPassEvent() != null && event.getDetectedPassEvent().getMediaType() == DetectedPassEvent.MediaType.OBU) {
            passChannel.setDetectedObuEvent(event.getDetectedPassEvent());
            applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            if (applicationService.getMessageLog().hasHandlers()) {
                applicationService.getMessageLog().debug(channelNo, "\u5df2\u6210\u529f\u8bc6\u522bobu\u8f66\u724c:" + event.getDetectedPassEvent().getPlateNumber() + "\uff0c\u7b49\u5f85\u8f66\u724c\u8bc6\u522b...");
            }
            event.triggerPassError("\u7b49\u5f85\u8f66\u724c\u8bc6\u522b...");
            return;
        }
        if (event.getPassportMediumType() == 0 || event.getPassportMediumType() == 1 || event.isUserScan()) {
            String sv;
            passSession = passChannel.getLastSession();
            if (!(passSession == null || passSession.getSessionState() != PassSession.SessionState.CANCELED || passSession.getReadPassportNumberEvent() == null || !event.isUserScan() && event.getDetectedPassEvent() != null || passSession.getCarLeftEvent() != null || passSession.getPlateRecognizedEvent() == null || passSession.getReadPassportNumberEvent().getPassportMediumType() != 6 || "\u65e0\u724c\u8f66".equals(passSession.getPlateRecognizedEvent().getPlateNumber()) || "\u65e0\u8f66\u724c".equals(passSession.getPlateRecognizedEvent().getPlateNumber()))) {
                LinkedList<Boolean> xeqList = null;
                List<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
                if (eqs != null && !eqs.isEmpty()) {
                    String chanelNo = passChannel.getChannelNo();
                    for (Equipment eq : eqs) {
                        Object act;
                        Object ac = eq.getEquipmentAction();
                        if (!(ac instanceof InputIoDetectedAction) || !(act = (InputIoDetectedAction)ac).isConnGround(chanelNo)) continue;
                        if (xeqList == null) {
                            xeqList = new LinkedList<Boolean>();
                        }
                        xeqList.add(act.isGroundPressure(chanelNo));
                    }
                }
                if (xeqList != null && !xeqList.isEmpty()) {
                    boolean isGroundPressure = false;
                    for (Boolean a : xeqList) {
                        if (!a.booleanValue()) continue;
                        isGroundPressure = a;
                        break;
                    }
                    if (isGroundPressure) {
                        event.triggerPassError(String.valueOf(passSession.getPlateRecognizedEvent().getPlateNumber()) + ", \u7981\u6b62\u901a\u884c");
                        return;
                    }
                }
            }
            if (passSession != null && passSession.getReadPassportNumberEvent() != null && passSession.getReadPassportNumberEvent().getPassportNumber().equals(event.getPassportNumber())) {
                if (passSession.getSessionState() == PassSession.SessionState.CANCELED) {
                    if (event.getReadTimeMills() - passSession.getReadPassportNumberEvent().getReadTimeMills() < 60000L) {
                        passSession.setReadPassportNumberEvent(event);
                        passSession.setSessionState(PassSession.SessionState.PENDING);
                        passSession.start();
                        return;
                    }
                } else {
                    if (passSession.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                        return;
                    }
                    if (!(passSession.getSessionState() != PassSession.SessionState.WAIT_CAR_LEAVE && passSession.getSessionState() != PassSession.SessionState.CAR_LEAVING && passSession.getSessionState() != PassSession.SessionState.CAR_LEFT || event.getReadTimeMills() - passSession.getReadPassportNumberEvent().getReadTimeMills() >= 60000L || !event.isUserScan() && event.getDetectedPassEvent() != null)) {
                        event.triggerPassError("\u5df2\u653e\u884c\u6210\u529f\uff01\u8bf7\u4e0d\u8981\u91cd\u590d\u626b\u4e00\u626b\uff01");
                        return;
                    }
                }
            }
            DefaultCarparkEvent vehicleDetectorEvent = null;
            boolean hasLineConnGroud = false;
            ZSRGCameraAction zsRGCameraAction = null;
            List<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getEquipmentsByActionClass(InputIoDetectedAction.class);
            if (eqs != null && !eqs.isEmpty()) {
                String chanelNo = passChannel.getChannelNo();
                for (Equipment eq : eqs) {
                    InputIoDetectedAction act;
                    ZSRGCameraAction aa;
                    Object ac = eq.getEquipmentAction();
                    if (ac instanceof ZSRGCameraAction && eq.getChannelNos() != null && eq.getChannelNos().contains(chanelNo) && (aa = (ZSRGCameraAction)ac).isWorkingProperly() && aa.isEnableGroundStatusDetect()) {
                        zsRGCameraAction = aa;
                    }
                    if (!(ac instanceof InputIoDetectedAction) || !(act = (InputIoDetectedAction)ac).isConnGround(chanelNo)) continue;
                    hasLineConnGroud = true;
                    if (!act.isGroundPressure(chanelNo)) continue;
                    vehicleDetectorEvent = new VehicleDetectorEvent(eq, 0, 1, chanelNo);
                    break;
                }
            }
            if (event.isUserScan() || event.getDetectedPassEvent() == null) {
                sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_SCAN_PASS");
                if (sv == null || sv.length() == 0) {
                    sv = "1";
                }
                if ("1".equals(sv)) {
                    DisplayVoiceService displayVoiceService;
                    ApplicationService applicationService5;
                    if ((passSession == null || passSession.getSessionState() != PassSession.SessionState.PENDING) && vehicleDetectorEvent == null) {
                        applicationService5 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        if (applicationService5.getMessageLog().hasHandlers()) {
                            applicationService5.getMessageLog().debug(channelNo, "\u672a\u80fd\u68c0\u6d4b\u5230\u8f66\u8f86\uff0c\u4e22\u5f03\u5361\u53f7:" + event.getPassportNumber());
                        }
                        displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        try {
                            if (passChannel.getLanConnectManageHostState() == null) {
                                displayVoiceService.notDetectedCar(passChannel);
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                        }
                        event.triggerPassError("\u672a\u68c0\u6d4b\u5230\u8f66\u8f86");
                        return;
                    }
                    if (hasLineConnGroud && vehicleDetectorEvent == null) {
                        applicationService5 = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                        if (applicationService5.getMessageLog().hasHandlers()) {
                            applicationService5.getMessageLog().debug(channelNo, "\u672a\u80fd\u68c0\u6d4b\u5230\u8f66\u8f86\uff0c\u4e22\u5f03\u5361\u53f7:" + event.getPassportNumber());
                        }
                        displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        try {
                            if (passChannel.getLanConnectManageHostState() == null) {
                                displayVoiceService.notDetectedCar(passChannel);
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                        }
                        event.triggerPassError("\u672a\u68c0\u6d4b\u5230\u8f66\u8f86");
                        return;
                    }
                } else if ("3".equals(sv)) {
                    boolean allow = false;
                    if (passSession != null && passSession.getCarLeftEvent() == null) {
                        String plateNumber;
                        if (passSession.getSessionState() == PassSession.SessionState.PENDING) {
                            if (passSession.getPlateRecognizedEvent() != null && (plateNumber = passSession.getPlateRecognizedEvent().getPlateNumber()) != null && plateNumber.length() > 0) {
                                boolean noPlate;
                                boolean bl = noPlate = plateNumber.equals("\u65e0\u724c\u8f66") || plateNumber.equals("\u65e0\u8f66\u724c") || plateNumber.indexOf("_\u65e0_") != -1;
                                if (noPlate) {
                                    allow = true;
                                }
                            }
                        } else if (passSession.getSessionState() == PassSession.SessionState.CANCELED && passSession.getPlateRecognizedEvent() != null && (plateNumber = passSession.getPlateRecognizedEvent().getPlateNumber()) != null && plateNumber.length() > 0) {
                            boolean noPlate;
                            boolean bl = noPlate = plateNumber.equals("\u65e0\u724c\u8f66") || plateNumber.equals("\u65e0\u8f66\u724c") || plateNumber.indexOf("_\u65e0_") != -1;
                            if (noPlate) {
                                if (passSession.getAttribute("GUI_CANCEL") == null || passSession.getReadPassportNumberEvent() == null) {
                                    if (vehicleDetectorEvent == null) {
                                        if (event.getReadTimeMills() - passSession.getPlateRecognizedEvent().getRegTimeMills() < 180000L) {
                                            allow = true;
                                            passSession.clearAllAttributes();
                                            passSession.setSessionState(PassSession.SessionState.PENDING);
                                        }
                                    } else {
                                        allow = true;
                                        passSession.clearAllAttributes();
                                        passSession.setSessionState(PassSession.SessionState.PENDING);
                                    }
                                } else {
                                    event.triggerPassError("\u60a8\u5df2\u88ab\u53d6\u6d88(\u7981\u6b62)\u901a\u884c\uff0c\u5982\u679c\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u8f66\u573a\u7ba1\u7406\u5458");
                                    return;
                                }
                            }
                        }
                    }
                    if (!allow) {
                        event.triggerPassError("\u672a\u68c0\u6d4b\u5230\u65e0\u724c\u8f66\uff0c\u5fc5\u987b\u65e0\u724c\u8f66\u624d\u5141\u8bb8\u626b\u7801\u653e\u884c");
                        return;
                    }
                }
                if (passSession != null && passSession.getSessionState() == PassSession.SessionState.PENDING) {
                    passSession.setReadPassportNumberEvent(event);
                    if (vehicleDetectorEvent != null) {
                        if (passSession.getCarArrivedEvent() == null) {
                            CarArrivedEvent newArrivedEvent = new CarArrivedEvent(vehicleDetectorEvent.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, (VehicleDetectorEvent)vehicleDetectorEvent);
                            passSession.setCarArrivedEvent(newArrivedEvent);
                        } else if (passSession.getCarArrivedEvent().getOriginalSourceType() != CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                            passSession.getCarArrivedEvent().setOriginalSourceType(CarArrivedEvent.OriginalSourceType.GROUND_SENSE);
                        }
                    }
                    passChannel.invalidateSessionBefore(passSession);
                    passSession.start();
                    return;
                }
                if (passSession != null) {
                    passChannel.invalidateSessionBefore(passSession);
                    if (passSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG) {
                        passChannel.invalidateSession(passSession);
                    }
                }
                passSession = passChannel.openSession();
                passSession.setReadPassportNumberEvent(event);
                if (vehicleDetectorEvent != null) {
                    CarArrivedEvent newArrivedEvent = new CarArrivedEvent(vehicleDetectorEvent.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, (VehicleDetectorEvent)vehicleDetectorEvent);
                    passSession.setCarArrivedEvent(newArrivedEvent);
                }
                passSession.start();
                return;
            }
            sv = ServiceUtil.getServiceContext().getDBConfigCache().getChannelStrategyValue(channelNo, "CHANNEL_SWIPE_CARD_PASS");
            if (sv == null || sv.length() == 0) {
                sv = "2";
            }
            if ("1".equals(sv) && vehicleDetectorEvent == null && event.getDetectedPassEvent() != null && !event.getDetectedPassEvent().isLongDistance()) {
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                try {
                    if (passChannel.getLanConnectManageHostState() == null) {
                        displayVoiceService.notDetectedCar(passChannel);
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)"\u64ad\u62a5\u5f02\u5e38", (Throwable)ex);
                }
                event.triggerPassError("\u672a\u68c0\u6d4b\u5230\u8f66\u8f86");
                return;
            }
            if (passSession != null && passSession.getSessionState() != PassSession.SessionState.PENDING) {
                passChannel.invalidateSessionBefore(passSession);
                if (passSession.getSessionState() != PassSession.SessionState.OPEN_DIALOG) {
                    passChannel.invalidateSession(passSession);
                }
                passSession = null;
            }
            if (passSession == null) {
                passSession = passChannel.openSession();
            }
            passSession.setReadPassportNumberEvent(event);
            if (vehicleDetectorEvent != null) {
                if (passSession.getCarArrivedEvent() == null) {
                    CarArrivedEvent newArrivedEvent = new CarArrivedEvent(vehicleDetectorEvent.getSource(), CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, (VehicleDetectorEvent)vehicleDetectorEvent);
                    passSession.setCarArrivedEvent(newArrivedEvent);
                } else if (passSession.getCarArrivedEvent().getOriginalSourceType() != CarArrivedEvent.OriginalSourceType.GROUND_SENSE) {
                    passSession.getCarArrivedEvent().setOriginalSourceType(CarArrivedEvent.OriginalSourceType.GROUND_SENSE);
                }
            }
            if (event.getDetectedPassEvent() != null && event.getDetectedPassEvent().isLongDistance()) {
                InvalidPassportNumberKey invalidkey = new InvalidPassportNumberKey(channelNo, event.getPassportNumber(), InvalidPassportNumberKey.getCacheMediumType(event));
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)invalidkey, (Object)invalidkey, null, 30L, TimeUnit.SECONDS);
            }
            passSession.start();
            return;
        }
        if (event.getPassportMediumType() == 6) {
            if (event.isManualTrigger()) {
                passSession = passChannel.getLastSession();
                if (passSession != null && passSession.getSessionState() == PassSession.SessionState.PENDING) {
                    passSession.setReadPassportNumberEvent(event);
                    passSession.start();
                } else {
                    if (passSession != null) {
                        passChannel.invalidateSessionBefore(passSession);
                        if (passSession.getReadPassportNumberEvent() != null && passSession.getReadPassportNumberEvent().getPassportMediumType() == 6 && passSession.getReadPassportNumberEvent().getPlateNumber() != null && passSession.getReadPassportNumberEvent().getPlateNumber().equals(event.getPlateNumber())) {
                            if (passSession.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                                passSession.setAttribute("GUI_CAN_CANCEL", Boolean.TRUE);
                                passSession.setSessionState(PassSession.SessionState.OPEN_DIALOG);
                                passSession.resetSessionTimeoutMills((int)TimeUnit.MINUTES.toMillis(15L));
                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new ConfirmPassEvent(passSession.getPassChannel(), passSession));
                                return;
                            }
                            if (passSession.getSessionState() == PassSession.SessionState.CANCELED) {
                                if (passSession.getAttribute("GUI_CANCEL") != null) {
                                    passChannel.invalidateSession(passSession);
                                } else {
                                    passSession.getReadPassportNumberEvent().setManualTrigger(true);
                                    passSession.reStart();
                                    return;
                                }
                            }
                        }
                    }
                    passSession = passChannel.openSession();
                    passSession.setReadPassportNumberEvent(event);
                    passSession.start();
                }
            } else {
                applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                if (applicationService.getMessageLog().hasHandlers()) {
                    applicationService.getMessageLog().debug(channelNo, "\u7a0b\u5e8f\u903b\u8f91\u9519\u8bef\uff0c\u8bc6\u522b\u8f66\u724c\u4e8b\u4ef6\u5e94\u8be5\u5728\u8bc6\u522b\u8f66\u724c\u4e8b\u4ef6\u5904\u7406\u8005\u4e2d\u5904\u7406\uff0c\u8bf7\u68c0\u6d4b\u7a0b\u5e8f\uff0c\u8f66\u724c:" + event.getPlateNumber());
                }
                ServiceLog.getLog().warn((Object)("\u7a0b\u5e8f\u903b\u8f91\u9519\u8bef\uff0c\u8bc6\u522b\u8f66\u724c\u4e8b\u4ef6\u5e94\u8be5\u5728\u8bc6\u522b\u8f66\u724c\u4e8b\u4ef6\u5904\u7406\u8005\u4e2d\u5904\u7406\uff0c\u8bf7\u68c0\u6d4b\u7a0b\u5e8f\uff0c\u8f66\u724c:" + event.getPlateNumber()));
            }
            return;
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private static final String namePrefix = "carpark-work-thread-channelEX-";

        private DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, namePrefix + this.threadNumber.getAndIncrement());
            return t;
        }
    }

    private static class EX {
        private final String channelNo;
        private final ExecutorService channelWorkThread;
        private final CarChannelPassProcessEventListener l;
        private volatile ExTask currentTask;
        private static final DefaultThreadFactory ExThreadFactory = new DefaultThreadFactory();

        private EX(String channelNo, CarChannelPassProcessEventListener l) {
            this.channelNo = channelNo;
            this.l = l;
            this.channelWorkThread = Executors.newSingleThreadExecutor(ExThreadFactory);
        }

        public void handle(CarparkEvent<?> e) {
            String name = Thread.currentThread().getName();
            if (name != null && name.startsWith("carpark-work-thread-channelEX-")) {
                new ExTask(e, this.l, this.channelNo, null).run();
            } else {
                long s1;
                Thread t1;
                ExTask ct = this.currentTask;
                if (ct != null && (t1 = ct.runThread) != null && t1 != Thread.currentThread() && (s1 = ct.handleTimeMills) > 0L && ServiceUtil.getServiceContext().currentTimeMillis() - s1 > 60000L) {
                    Thread.State tt = t1.getState();
                    StringBuilder sbr = new StringBuilder(128);
                    StackTraceElement[] trace = t1.getStackTrace();
                    sbr.append("\u8f66\u901a\u9053\u4e1a\u52a1\u653e\u884c\u6d41\u7a0b\u5bf9\u4e00\u4e2a\u5e94\u7528\u4e8b\u4ef6\u5904\u7406\u8d85\u8fc7\u4e8660\u79d2\uff0c\u5904\u7406\u7ebf\u7a0b\u72b6\u6001:").append((Object)tt);
                    if (tt == Thread.State.BLOCKED || tt == Thread.State.WAITING || tt == Thread.State.TIMED_WAITING) {
                        t1.interrupt();
                        sbr.append(", \u4e2d\u65ad\u6b64\u7ebf\u7a0b\u8fd0\u884c\uff01");
                    }
                    sbr.append("\r\n");
                    sbr.append(t1.toString()).append(":");
                    int i = 0;
                    while (i < trace.length) {
                        sbr.append("\r\n\tat ").append(trace[i]);
                        ++i;
                    }
                    ServiceLog.getLog().warn((Object)sbr.toString());
                    ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    if (applicationService.getMessageLog().hasHandlers()) {
                        applicationService.getMessageLog().error(this.channelNo, sbr.toString());
                    }
                }
                ExTask task = new ExTask(e, this.l, this.channelNo, this);
                this.channelWorkThread.submit(task);
            }
        }
    }

    private static class ExTask
    implements Runnable {
        private volatile long handleTimeMills = 0L;
        private CarparkEvent<?> e1;
        private CarChannelPassProcessEventListener l;
        private String channelNo;
        private final EX ex;
        private volatile Thread runThread;

        private ExTask(CarparkEvent<?> e1, CarChannelPassProcessEventListener l, String channelNo, EX ex) {
            this.e1 = e1;
            this.l = l;
            this.channelNo = channelNo;
            this.ex = ex;
        }

        @Override
        public void run() {
            try {
                try {
                    this.runThread = Thread.currentThread();
                    if (this.ex != null) {
                        this.ex.currentTask = this;
                    }
                    this.handleTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
                    this.l.handleEvent0(this.e1);
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)"\u5904\u7406\u8f66\u8f86\u901a\u9053\u653e\u884c\u6d41\u7a0b\u5f02\u5e38!", ex);
                    ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                    if (applicationService.getMessageLog().hasHandlers()) {
                        applicationService.getMessageLog().error(this.channelNo, "\u5904\u7406\u8f66\u8f86\u901a\u9053\u653e\u884c\u6d41\u7a0b\u5f02\u5e38!", ex);
                    }
                    this.handleTimeMills = 0L;
                    if (this.ex != null) {
                        this.ex.currentTask = null;
                    }
                }
            }
            finally {
                this.handleTimeMills = 0L;
                if (this.ex != null) {
                    this.ex.currentTask = null;
                }
            }
        }
    }
}

