/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.listener;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.PayCodePayTask;
import com.wovoe.carpark.ValidateUtil;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.ScanCodeFoundEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.DisplayVoiceService;
import java.util.concurrent.TimeUnit;

public class ChannelPayCodeEventListener
implements CarparkEventListener {
    @Override
    public int[] getIntestEventId() {
        return new int[]{6652};
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (event instanceof ScanCodeFoundEvent) {
            this.handleScanCodeFoundEvent((ScanCodeFoundEvent)event);
        }
    }

    private void handleScanCodeFoundEvent(ScanCodeFoundEvent event) {
        String payCode = event.getScanCode();
        if (payCode == null || payCode.length() == 0) {
            return;
        }
        if (!ValidateUtil.isNumeric(payCode)) {
            return;
        }
        String channelNo = event.getChannelNo();
        if (channelNo == null || channelNo.length() == 0) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6cd5\u627e\u5230\u5408\u9002\u7684\u901a\u9053, \u8fd9\u5c06\u4e22\u5f03\u4e8c\u7ef4\u7801\u6216\u6761\u7801: " + channelNo));
            return;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            ServiceLog.getLog().warn((Object)("\u65e0\u6548\u901a\u9053\u53f7\uff1a" + channelNo + ", \u8fd9\u5c06\u4e22\u5f03\u4e8c\u7ef4\u7801\u6216\u6761\u7801: " + payCode));
            return;
        }
        ChannelArea channelArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
        if (channelArea.getExitAreas() != null && !channelArea.getExitAreas().isEmpty()) {
            CarparkArea area = channelArea.getExitAreas().get(channelArea.getExitAreas().size() - 1);
            if (area.getArea_level() == 1) {
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                PassSession session = passChannel.getCurrentHandleSession();
                if (session == null) {
                    displayVoiceService.notDetectedCar(passChannel);
                } else {
                    Cost cost = (Cost)session.getAttribute("pass_cost");
                    if (cost == null || cost.getCash().doubleValue() <= 0.0) {
                        displayVoiceService.playConfirmPass(session);
                    } else if (session.getAttribute("PASS_NOSENSE_PLAYING") != null) {
                        displayVoiceService.displaySenselessPaying(session.getPassChannel(), session.getPassPlate(), "\u6b63\u5728\u65e0\u611f\u652f\u4ed8...\u8bf7\u6682\u65f6\u4e0d\u8981\u4f7f\u7528\u4ed8\u6b3e\u7801\u652f\u4ed8!");
                    } else if (session.getAttribute("SCANCODE_PLAYING") != null) {
                        displayVoiceService.displaySenselessPaying(session.getPassChannel(), session.getPassPlate(), "\u5c97\u4ead\u6b63\u5728\u4f7f\u7528\u626b\u7801\u62a2\u652f\u4ed8\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u652f\u4ed8!");
                    } else {
                        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        Long scanPaying = (Long)session.getAttribute("PASS_SCANCODE_PLAYING");
                        if (scanPaying != null && currentMills - scanPaying < TimeUnit.SECONDS.toMillis(65L)) {
                            displayVoiceService.displayScanPayMsg(session, "\u4ed8\u6b3e\u7801\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u8bf7\u7a0d\u540e...", "\u4ed8\u6b3e\u7801\u6b63\u5728\u652f\u4ed8\u4e2d\uff0c\u8bf7\u7a0d\u540e...", 8);
                        } else {
                            this.doScanPayCode(session, payCode);
                        }
                    }
                }
            } else {
                ServiceLog.getLog().warn((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u5185\u573a\u79bb\u573a\u4e0d\u652f\u6301\u4ed8\u6b3e\u7801, \u8fd9\u5c06\u4e22\u5f03\u4ed8\u6b3e\u7801: " + payCode));
                PassSession session = passChannel.getCurrentHandleSession();
                DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                if (session != null) {
                    displayVoiceService.playConfirmPass(session);
                } else {
                    displayVoiceService.notDetectedCar(passChannel);
                }
            }
        } else {
            ServiceLog.getLog().warn((Object)(String.valueOf(passChannel.getChannel().getChannel_name()) + ": \u5165\u573a\u4e0d\u652f\u6301\u4ed8\u6b3e\u7801, \u8fd9\u5c06\u4e22\u5f03\u4ed8\u6b3e\u7801: " + payCode));
            DisplayVoiceService displayVoiceService = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            PassSession session = passChannel.getCurrentHandleSession();
            if (session != null) {
                displayVoiceService.playConfirmPass(session);
            } else {
                displayVoiceService.notDetectedCar(passChannel);
            }
        }
    }

    private void doScanPayCode(PassSession passSession, String scanCode) {
        Cost cost = (Cost)passSession.getAttribute("pass_cost");
        if (cost != null && cost.getCash().doubleValue() > 0.0) {
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            String msg = null;
            if (applicationService.isAlipayScanCode(scanCode)) {
                if (!applicationService.isEnableAliPayCode()) {
                    if (applicationService.isEnableWeixinPayCode()) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u5931\u8d25!  \u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u53ef\u4f7f\u7528\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(passSession, "\u8bf7\u4f7f\u7528\u5fae\u4fe1\u4ed8\u6b3e\u7801\uff0c\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u5931\u8d25!  \u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u5982\u679c\u9700\u8981\u5f00\u901a\u8bf7\u8054\u7cfb\u670d\u52a1\u5546", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(passSession, "\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    }
                    return;
                }
                msg = "\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else if (applicationService.isWeixinPayScanCode(scanCode)) {
                if (!applicationService.isEnableWeixinPayCode()) {
                    if (applicationService.isEnableAliPayCode()) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u5931\u8d25!  \u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u53ef\u4f7f\u7528\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\u652f\u4ed8", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(passSession, "\u8bf7\u4f7f\u7528\u652f\u4ed8\u5b9d\u4ed8\u6b3e\u7801\uff0c\u5fae\u4fe1\u4ed8\u6b3e\u7801\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    } else {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u5931\u8d25!  \u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a\uff0c\u5982\u679c\u9700\u8981\u5f00\u901a\u8bf7\u8054\u7cfb\u670d\u52a1\u5546", 4));
                        DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                        sp.displayScanPayMsg(passSession, "\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8\u529f\u80fd\u672a\u5f00\u901a", "\u652f\u4ed8\u5931\u8d25", 8);
                    }
                    return;
                }
                msg = "\u5fae\u4fe1\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else if (scanCode.length() > 15 && scanCode.length() < 27) {
                msg = "\u4ed8\u6b3e\u7801\u652f\u4ed8";
            } else {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, "\u652f\u4ed8\u5931\u8d25! \u65e0\u6cd5\u8bc6\u522b\u7684\u4ed8\u6b3e\u7801: " + scanCode + ", \u53ea\u652f\u6301\u5fae\u4fe1\u6216\u652f\u4ed8\u5b9d\u7684\u4ed8\u6b3e\u7801\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\u6216\u8f93\u5165", 4));
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.displayScanPayMsg(passSession, "\u672a\u80fd\u8bc6\u522b\u7684\u4ed8\u6b3e\u7801", "\u652f\u4ed8\u5931\u8d25", 8);
                return;
            }
            if (!ServiceUtil.getServiceContext().isConnectedCloud()) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession, String.valueOf(msg) + "\u5931\u8d25! \u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc", 4));
                DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
                sp.displayScanPayMsg(passSession, "\u652f\u4ed8\u5931\u8d25\uff0c\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", "\u652f\u4ed8\u5931\u8d25", 8);
                return;
            }
            DisplayVoiceService sp = (DisplayVoiceService)ServiceUtil.getServiceContext().getService(DisplayVoiceService.class);
            sp.displayScanPayMsg(passSession, String.valueOf(msg) + "\u4e2d...", String.valueOf(msg) + "\u4e2d", 8);
            PayCodePayTask task = new PayCodePayTask(passSession, scanCode);
            task.start(true);
        }
    }
}

