/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.listener;

import com.wovoe.carpark.ChannelArea;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.dto.CarparkPresenceRecord;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.CarArrivedEvent;
import com.wovoe.carpark.event.app.CarLeftEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.equipment.CameraEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.event.equipment.VehicleDetectorEvent;
import com.wovoe.carpark.event.equipment.VehicleTypeEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.ObjectCreateCallback;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class EquipmentEventListener
implements CarparkEventListener {
    private static final ConcurrentHashMap<String, WaitPlateEventEntry> waitPlateEventChannelMap = new ConcurrentHashMap();

    @Override
    public int[] getIntestEventId() {
        return new int[]{100};
    }

    @Override
    public void handleEvent(CarparkEvent<?> e) throws Exception {
        if (e == null) {
            return;
        }
        if (e instanceof CameraEvent) {
            this.handleCameraEvent((CameraEvent)e);
        } else if (e instanceof DetectedPassEvent) {
            this.handleDetectedPassEvent((DetectedPassEvent)e);
        } else if (e instanceof VehicleDetectorEvent) {
            this.handleVehicleDetectorEvent((VehicleDetectorEvent)e);
        } else if (e instanceof VehicleTypeEvent) {
            this.handleVehicleTypeEvent((VehicleTypeEvent)e);
        }
    }

    private boolean hanleMutiCameraEvent0(PlateRecognizedEvent e) {
        PassChannel hChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(e.getChannelNo());
        if (hChannel == null) {
            return false;
        }
        List<Equipment> list = hChannel.getWorkNormalPlateRegCameras();
        if (list == null || list.size() < 2) {
            return false;
        }
        WaitPlateEventEntry entry = waitPlateEventChannelMap.get(e.getChannelNo());
        if (entry == null) {
            WaitPlateEventEntry en = new WaitPlateEventEntry();
            WaitPlateEventEntry old = waitPlateEventChannelMap.putIfAbsent(e.getChannelNo(), en);
            if (old != null) {
                en = old;
            }
            entry = en;
        }
        entry.putPlateRecognizedEvent(e, list.size());
        return true;
    }

    private void handleVehicleTypeEvent(VehicleTypeEvent event) {
        if (!ServiceUtil.isZvalid()) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8f6f\u4ef6\u4f7f\u7528\u5df2\u5230\u671f\uff01\u8f66\u724c\u8bc6\u522b\u6a21\u5757\u5df2\u505c\u7528\uff01\u5982\u679c\u9700\u8981\u5ef6\u671f\u8bf7\u8054\u7cfb\u8f66\u573a\u9500\u552e\u4eba\u5458\uff01", 3, 10000));
            return;
        }
        try {
            RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
            recrodserive.saveVehicleTypeEvent(event, true);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u8f66\u578b\u8bc6\u522b\u6570\u636e\u65e5\u5fd7\u5f02\u5e38\uff01", (Throwable)ex);
        }
    }

    private void handleCameraEvent(CameraEvent event) {
        if (!ServiceUtil.isZvalid()) {
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u8f6f\u4ef6\u4f7f\u7528\u5df2\u5230\u671f\uff01\u8f66\u724c\u8bc6\u522b\u6a21\u5757\u5df2\u505c\u7528\uff01\u5982\u679c\u9700\u8981\u5ef6\u671f\u8bf7\u8054\u7cfb\u8f66\u573a\u9500\u552e\u4eba\u5458\uff01", 3, 10000));
            return;
        }
        Equipment eq = (Equipment)event.getSource();
        List<String> channelNos = eq.getChannelNos();
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        if (channelNos == null || channelNos.isEmpty()) {
            if (ServiceLog.getLog().isWarnEnabled()) {
                ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u627e\u5230\u901a\u9053,\u4e8b\u4ef6CameraEvent\u9519\u8bef:\u8bbe\u5907\u672a\u5305\u542b\u901a\u9053\u4fe1\u606f!");
            }
            if (applicationService.getMessageLog().hasHandlers()) {
                applicationService.getMessageLog().warn("\u65e0\u6cd5\u627e\u5230\u901a\u9053,\u65e0\u6cd5\u627e\u5230\u901a\u9053,\u6444\u50cf\u5934\u4e8b\u4ef6\u9519\u8bef:\u8bbe\u5907\u672a\u5305\u542b\u901a\u9053\u4fe1\u606f!");
            }
            return;
        }
        String channelNo = channelNos.get(0);
        boolean softTrigger = false;
        if (event.getPlateNumber() != null && event.getPlateNumber().length() > 0) {
            String newPlate;
            Object waitTriggerRegPlate = eq.getAttribute("waitTriggerRegPlate");
            if (waitTriggerRegPlate != null && waitTriggerRegPlate instanceof Long) {
                Long l = (Long)waitTriggerRegPlate;
                if (ServiceUtil.getServiceContext().currentTimeMillis() - l <= 3500L) {
                    String key = String.valueOf(channelNo) + "_" + eq.getEquipmentNo() + "_triggerRegPlate";
                    Object obj = ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
                    if (obj != null && obj instanceof ObjectCreateCallback) {
                        softTrigger = true;
                        try {
                            ObjectCreateCallback c = (ObjectCreateCallback)obj;
                            c.createSuccess((Object)event.getPlateNumber());
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"", (Throwable)ex);
                        }
                        if ("\u65e0\u724c\u8f66".equals(event.getPlateNumber()) || "\u65e0\u8f66\u724c".equals(event.getPlateNumber())) {
                            return;
                        }
                    }
                }
            }
            PlateRecognizedEvent e = new PlateRecognizedEvent(event.getSource(), channelNo, event.getPlateNumber(), event.getPicPath());
            e.setCameraEquipmentNo(eq.getEquipmentNo());
            e.setCarLogo(event.getCarLogo());
            e.setCarSpeed(event.getCarSpeed());
            e.setCarType(event.getCarType());
            e.setCarTypeDes(event.getCarTypeDes());
            e.setDir(event.getDir());
            e.setDirDes(event.getDirDes());
            e.setPlateColor(event.getPlateColor());
            e.setPlateConfidence(event.getPlateConfidence());
            e.setPlateJudge(event.getPlateJudge());
            e.setPlateJudgeDes(event.getPlateJudgeDes());
            e.setPlateType(event.getPlateType());
            e.setPlateTypeDes(event.getPlateTypeDes());
            e.setVehicleColor(event.getVehicleColor());
            e.setCarmeraRegTimeMills(event.getCameraRegPlateMills());
            if (event.getPlateSmallPath() != null && event.getPlateSmallPath().length() > 0) {
                e.setPlateSmallPath(event.getPlateSmallPath());
            }
            if (softTrigger) {
                e.setTrigger_method(1);
            }
            if (e.getPlateNumber() != null && e.getPlateNumber().length() > 0) {
                boolean uploadToServer;
                PassChannel ch = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
                if (ch == null) {
                    uploadToServer = false;
                } else {
                    if (ch.getLasetSaveUploadRegPlate() == null) {
                        uploadToServer = true;
                    } else if (!e.getPlateNumber().equals(ch.getLasetSaveUploadRegPlate())) {
                        uploadToServer = true;
                    } else {
                        long mills = ServiceUtil.getServiceContext().currentTimeMillis();
                        long timoutMills = e.getPlateNumber() != null && e.getPlateNumber().length() > 5 && e.getPlateNumber().indexOf(26080) == -1 ? 5000L : 30000L;
                        uploadToServer = mills - ch.getLasetSaveUploadRegPlateMills() >= timoutMills;
                    }
                    if (uploadToServer) {
                        ch.setLasetSaveUploadRegPlate(e.getPlateNumber());
                        ch.setLasetSaveUploadRegPlateMills(ServiceUtil.getServiceContext().currentTimeMillis());
                    }
                }
                RecordSaveService recrodserive = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
                recrodserive.savePlateRecognizedEvent(e, uploadToServer);
            }
            if ((newPlate = applicationService.replacePlate(event.getPlateNumber())) != null && newPlate.length() > 0 && !newPlate.equals(event.getPlateNumber())) {
                event.setPlateNumber(newPlate);
                e.setPlateNumber(newPlate);
            }
            if (!this.hanleMutiCameraEvent0(e)) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(e);
            }
        }
    }

    private void handleVehicleDetectorEvent(VehicleDetectorEvent event) {
        String channelNo = event.getChannelNo();
        if (channelNo == null || channelNo.length() == 0) {
            return;
        }
        if (event.getType() == 0) {
            if (event.getPressValue() == 1) {
                CarArrivedEvent e = new CarArrivedEvent(this, CarArrivedEvent.OriginalSourceType.GROUND_SENSE, channelNo, event);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(e);
            } else {
                CarLeftEvent e = new CarLeftEvent(this, CarLeftEvent.OriginalSourceType.GROUND_SENSE, channelNo, event);
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(e);
            }
        } else {
            event.getType();
        }
    }

    private void handleDetectedPassEvent(DetectedPassEvent event) {
        Equipment eq = (Equipment)event.getSource();
        ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        String channelNo = event.getChannelNo();
        if (channelNo == null || channelNo.length() == 0) {
            List<String> channelNos = eq.getChannelNos();
            if (channelNos == null || channelNos.isEmpty()) {
                ServiceLog.getLog().warn((Object)"\u65e0\u6cd5\u627e\u5230\u901a\u9053,\u4e8b\u4ef6DetectedPassEvent\u9519\u8bef:\u8bbe\u5907\u672a\u5305\u542b\u901a\u9053\u4fe1\u606f!");
                if (applicationService.getMessageLog().hasHandlers()) {
                    applicationService.getMessageLog().warn("\u65e0\u6cd5\u627e\u5230\u901a\u9053,\u901a\u884c\u8bc1\u4e8b\u4ef6\u9519\u8bef:\u672a\u5305\u542b\u901a\u9053\u4fe1\u606f!");
                }
                return;
            }
            channelNo = channelNos.get(0);
        }
        ReadPassportNumberEvent e = event.getPlateNumber() != null && event.getPlateNumber().length() > 0 ? new ReadPassportNumberEvent(this, event.getPlateNumber(), 6, channelNo) : new ReadPassportNumberEvent(this, event.getMediaNumber(), event.toIntMediaType(), channelNo);
        e.setDetectedPassEvent(event);
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(e);
    }

    private static final class WaitPlateEventEntry
    implements Runnable {
        private volatile CountDownLatch countDownLatch;
        private final Map<String, PlateRecognizedEvent> waitMap = new HashMap<String, PlateRecognizedEvent>();
        private ReentrantLock lock = new ReentrantLock();

        private WaitPlateEventEntry() {
        }

        public void putPlateRecognizedEvent(PlateRecognizedEvent event, int size) {
            this.lock.lock();
            try {
                this.check();
                if (this.countDownLatch == null || this.countDownLatch.getCount() <= 0L) {
                    this.countDownLatch = new CountDownLatch(size);
                    this.waitMap.put(event.getCameraEquipmentNo(), event);
                    this.countDownLatch.countDown();
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(this);
                } else if (this.waitMap.containsKey(event.getCameraEquipmentNo())) {
                    this.waitMap.put(event.getCameraEquipmentNo(), event);
                } else {
                    this.waitMap.put(event.getCameraEquipmentNo(), event);
                    this.countDownLatch.countDown();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void check() {
            if (this.waitMap.isEmpty()) {
                if (this.countDownLatch != null) {
                    while (this.countDownLatch.getCount() > 0L) {
                        this.countDownLatch.countDown();
                    }
                    this.countDownLatch = null;
                }
            } else {
                Iterator<Map.Entry<String, PlateRecognizedEvent>> it = this.waitMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, PlateRecognizedEvent> e = it.next();
                    if (ServiceUtil.getServiceContext().currentTimeMillis() - e.getValue().getRegTimeMills() <= 1500L) continue;
                    it.remove();
                }
                if (this.waitMap.isEmpty() && this.countDownLatch != null) {
                    while (this.countDownLatch.getCount() > 0L) {
                        this.countDownLatch.countDown();
                    }
                    this.countDownLatch = null;
                }
            }
        }

        @Override
        public void run() {
            try {
                try {
                    this.countDownLatch.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LinkedHashMap<String, PlateRecognizedEvent> envetm = new LinkedHashMap<String, PlateRecognizedEvent>();
                this.lock.lock();
                try {
                    this.countDownLatch = null;
                    Iterator<Map.Entry<String, PlateRecognizedEvent>> it = this.waitMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, PlateRecognizedEvent> en = it.next();
                        if (!envetm.containsKey(en.getValue().getPlateNumber())) {
                            envetm.put(en.getValue().getPlateNumber(), en.getValue());
                        }
                        it.remove();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (envetm.isEmpty()) {
                    return;
                }
                if (envetm.size() == 1) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent((CarparkEvent)ServiceUtil.getFirstElement(envetm.values()));
                    return;
                }
                PlateRecognizedEvent noplte = null;
                Iterator it = envetm.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    PlateRecognizedEvent event = (PlateRecognizedEvent)entry.getValue();
                    if (event.getPlateNumber() != null && event.getPlateNumber().indexOf("_\u65e0_") != -1) {
                        event.setPlateNumber("\u65e0\u724c\u8f66");
                    }
                    if (!"\u65e0\u724c\u8f66".equals(event.getPlateNumber()) && !"\u65e0\u8f66\u724c".equals(event.getPlateNumber())) continue;
                    noplte = event;
                    it.remove();
                }
                if (envetm.size() == 0) {
                    if (noplte != null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(noplte);
                        return;
                    }
                } else {
                    if (envetm.size() == 1) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent((CarparkEvent)ServiceUtil.getFirstElement(envetm.values()));
                        return;
                    }
                    PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(((PlateRecognizedEvent)ServiceUtil.getFirstElement(envetm.values())).getChannelNo());
                    if (passChannel == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent((CarparkEvent)ServiceUtil.getFirstElement(envetm.values()));
                        return;
                    }
                    ChannelArea chanenlArea = ServiceUtil.getServiceContext().getDBConfigCache().getChannelAreas().get(passChannel.getChannelNo());
                    if (chanenlArea == null) {
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent((CarparkEvent)ServiceUtil.getFirstElement(envetm.values()));
                        return;
                    }
                    if (chanenlArea.getEnterAreas() == null || chanenlArea.getEnterAreas().isEmpty() || chanenlArea.getEnterAreas().get(0).getArea_level() != 1) {
                        PlateRecognizedEvent throwEvent = null;
                        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
                        for (PlateRecognizedEvent event : envetm.values()) {
                            long count = commonDaoService.selectCount(new SearchParam(commonDaoService.getTableName(CarparkPresenceRecord.class)).addEQ("enter_plate", (Object)event.getPlateNumber()));
                            if (count <= 0L) continue;
                            throwEvent = event;
                            break;
                        }
                        if (throwEvent != null) {
                            envetm.remove(throwEvent.getPlateNumber());
                            if (!envetm.isEmpty()) {
                                throwEvent.setMutiCameraRecognizedEventList(envetm.values());
                            }
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(throwEvent);
                            return;
                        }
                    }
                    PriorityQueue<PlateRecognizedEvent> op = new PriorityQueue<PlateRecognizedEvent>(envetm.size(), new Comparator<PlateRecognizedEvent>(){

                        @Override
                        public int compare(PlateRecognizedEvent o1, PlateRecognizedEvent o2) {
                            Float b;
                            Float a = Float.valueOf(o1.getPlateConfidence() == null ? 0.0f : o1.getPlateConfidence().floatValue());
                            int h = a.compareTo(b = Float.valueOf(o2.getPlateConfidence() == null ? 0.0f : o2.getPlateConfidence().floatValue()));
                            if (h == 0) {
                                long y;
                                long x = o1.getRegTimeMills();
                                return x < (y = o2.getRegTimeMills()) ? -1 : (x == y ? 0 : 1);
                            }
                            return 0 - h;
                        }
                    });
                    for (PlateRecognizedEvent event : envetm.values()) {
                        op.offer(event);
                    }
                    if (!op.isEmpty()) {
                        PlateRecognizedEvent throwEvent = op.poll();
                        envetm.remove(throwEvent.getPlateNumber());
                        if (!envetm.isEmpty()) {
                            throwEvent.setMutiCameraRecognizedEventList(envetm.values());
                        }
                        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(throwEvent);
                        return;
                    }
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

