/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.event.listener;

import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.charge.Cost;
import com.wovoe.carpark.dto.CarparkEscapeOrder;
import com.wovoe.carpark.event.CarparkEvent;
import com.wovoe.carpark.event.CarparkEventListener;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.equipment.RoadBarrierStateEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;

public class RoadBarrierControlBoxListener
implements CarparkEventListener {
    @Override
    public int[] getIntestEventId() {
        return new int[]{363};
    }

    @Override
    public void handleEvent(CarparkEvent<?> event) throws Exception {
        if (!(event instanceof RoadBarrierStateEvent)) {
            return;
        }
        RoadBarrierStateEvent re = (RoadBarrierStateEvent)event;
        if (re.getSource() == null || re.getSignals() == null || !re.getSignals().contains((Object)RoadBarrierStateEvent.SignalType.CONTROL_BOX_OPEN)) {
            return;
        }
        if (re.getChannelNo() == null) {
            return;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(re.getChannelNo());
        if (channel == null) {
            return;
        }
        if (channel.getLanConnectManageHostState() != null) {
            return;
        }
        if (re.getControlBoxOpenHandleType() == 1) {
            try {
                ServiceLog.getLog().warn((Object)("\u901a\u9053:" + channel.getChannel().getChannel_name() + ",\u63a5\u6536\u5230\u4e00\u4e2a\u9065\u63a7\u5668\u5f00\u95f8\u8d77\u6746\u4fe1\u53f7\uff0c\u975e\u6cd5\u8d77\u6746"));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u68c0\u6d4b\u5230\u9065\u63a7\u5668\u5f00\u95f8\uff0c\u975e\u6cd5\u8d77\u6746", 3));
            }
            finally {
                PassSession cancelSession = channel.getLastSession();
                String plate = null;
                if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                    plate = cancelSession.getPassPlate();
                }
                channel.exceptionPass(false, 0, "1", "\u9053\u95f8\u9065\u63a7\u5668\u5f00\u95f8", plate);
                if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                    cancelSession.setSessionState(PassSession.SessionState.CAR_LEAVING);
                }
            }
        }
        PassSession session = channel.getLastConfirmDialogSession();
        if (session != null && session.getReadPassportNumberEvent() != null && !session.getReadPassportNumberEvent().isManualTrigger()) {
            try {
                ServiceLog.getLog().warn((Object)("\u901a\u9053:" + channel.getChannel().getChannel_name() + ",\u63a5\u6536\u5230\u4e00\u4e2a\u9065\u63a7\u5668\u5f00\u95f8\u8d77\u6746\u4fe1\u53f7\uff0c\u5f53\u4eba\u5de5\u786e\u8ba4\u5904\u7406"));
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u68c0\u6d4b\u5230\u9065\u63a7\u5668\u5f00\u95f8\uff0c\u5f53\u4eba\u5de5\u786e\u8ba4\u653e\u884c", 3));
            }
            finally {
                block33: {
                    session.setAttribute("CONTROL_BOX_OPEN_POLE", Boolean.TRUE);
                    Cost cost = (Cost)session.getAttribute("pass_cost");
                    CarparkEscapeOrder escapeOrder = (CarparkEscapeOrder)session.getAttribute("ESCAPE_ORDER");
                    if (escapeOrder != null && cost != null && cost.getCash().doubleValue() > 0.0) {
                        cost = new Cost();
                        session.setAttribute("pass_cost", cost);
                        session.removeAttribute("ESCAPE_ORDER");
                        session.removeAttribute("IGNORE_ESCAPE_ORDER_COST");
                    }
                    try {
                        try {
                            ServiceUtil.getServiceContext().getPassFilterChain().excecuteBehindPassFilters(session, session.getConfirmPassFilter());
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"\u4fdd\u5b58\u653e\u884c\u6570\u636e\u5f02\u5e38\uff01", (Throwable)ex);
                            session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                            session.setSessionState(PassSession.SessionState.CANCELED);
                            String message = String.valueOf(session.getPassChannel().getChannel().getChannel_name()) + "\u653e\u884c\u5f02\u5e38\uff01\u5185\u90e8\u9519\u8bef\uff01";
                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(session, message, 4));
                            ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                            if (callback != null) {
                                callback.doClosePassDialog(session);
                            }
                            break block33;
                        }
                    }
                    catch (Throwable throwable) {
                        ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                        if (callback != null) {
                            callback.doClosePassDialog(session);
                        }
                        throw throwable;
                    }
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback != null) {
                        callback.doClosePassDialog(session);
                    }
                }
            }
        }
        try {
            ServiceLog.getLog().warn((Object)("\u901a\u9053:" + channel.getChannel().getChannel_name() + ",\u63a5\u6536\u5230\u4e00\u4e2a\u9065\u63a7\u5668\u5f00\u95f8\u8d77\u6746\u4fe1\u53f7\uff0c\u975e\u6cd5\u8d77\u6746"));
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u68c0\u6d4b\u5230\u9065\u63a7\u5668\u5f00\u95f8\uff0c\u975e\u6cd5\u8d77\u6746", 3));
        }
        finally {
            PassSession cancelSession = channel.getLastSession();
            String plate = null;
            if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                plate = cancelSession.getPassPlate();
            }
            channel.exceptionPass(false, 0, "1", "\u9053\u95f8\u9065\u63a7\u5668\u5f00\u95f8", plate);
            if (cancelSession != null && cancelSession.getSessionState() == PassSession.SessionState.CANCELED) {
                cancelSession.setSessionState(PassSession.SessionState.CAR_LEAVING);
            }
        }
    }
}

