/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@Deprecated
public class BrowserFrame
extends JFrame {
    public static BrowserFrame instance = null;
    private static final long serialVersionUID = -9151184576029915720L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine webEngine;
    private WebView browser;
    private volatile boolean disposed = false;

    public BrowserFrame(int width, int height) {
        this.initComponents(width, height);
    }

    private void initComponents(int width, int height) {
        CountDownLatch l = this.createScene(width, height);
        try {
            l.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getContentPane().add((Component)this.jfxPanel, "Center");
        this.setPreferredSize(new Dimension(width, height));
        this.pack();
    }

    private CountDownLatch createScene(final int width, final int height) {
        final CountDownLatch l = new CountDownLatch(1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserFrame.this.browser = new WebView();
                    BrowserFrame.this.webEngine = BrowserFrame.this.browser.getEngine();
                    BrowserFrame.this.browser.setPrefSize((double)(width - 10), (double)(height - 30));
                    ScrollPane scrollPane = new ScrollPane();
                    scrollPane.setContent((Node)BrowserFrame.this.browser);
                    BrowserFrame.this.jfxPanel.setScene(new Scene((Parent)scrollPane));
                    BrowserFrame.this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                        public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                            if (newState == Worker.State.SUCCEEDED) {
                                final String title = BrowserFrame.this.webEngine.getTitle();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (title != null) {
                                            BrowserFrame.this.setTitle(title);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                finally {
                    l.countDown();
                }
            }
        });
        return l;
    }

    public void loadURL(final String url) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (!BrowserFrame.this.isVisible()) {
                    BrowserFrame.this.setVisible(true);
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BrowserFrame.this.webEngine.load(url);
                    }
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

