/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class CarparkJOptionPane
extends JOptionPane {
    private static final long serialVersionUID = -4371892471844984639L;

    private static int styleFromMessageType(int messageType) {
        switch (messageType) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    public CarparkJOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        super(message, messageType, optionType, icon, options, initialValue);
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, Image iconImage) throws HeadlessException {
        CarparkJOptionPane pane = new CarparkJOptionPane(message, messageType, optionType, icon, options, initialValue);
        pane.setInitialValue(initialValue);
        pane.setComponentOrientation((parentComponent == null ? CarparkJOptionPane.getRootFrame() : parentComponent).getComponentOrientation());
        int style = CarparkJOptionPane.styleFromMessageType(messageType);
        JDialog dialog = pane.createDialog(parentComponent, title, style);
        if (iconImage != null) {
            dialog.setIconImage(iconImage);
        }
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int counter = 0;
        int maxCounter = options.length;
        while (counter < maxCounter) {
            if (options[counter].equals(selectedValue)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return CarparkJOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return CarparkJOptionPane.getWindowForComponent(parentComponent.getParent());
    }

    private JDialog createDialog(Component parentComponent, String title, int style) throws HeadlessException {
        Window window = CarparkJOptionPane.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        this.initDialog(dialog, style, parentComponent);
        return dialog;
    }

    private void initDialog(final JDialog dialog, int style, Component parentComponent) {
        boolean supportsWindowDecorations;
        dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(style);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                CarparkJOptionPane.this.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    CarparkJOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        dialog.addWindowListener(adapter);
        dialog.addWindowFocusListener(adapter);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                CarparkJOptionPane.this.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == CarparkJOptionPane.this && event.getPropertyName().equals("value") && event.getNewValue() != null && event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    dialog.setVisible(false);
                }
            }
        });
    }

    public static void main(String[] args) {
        CarparkJOptionPane.showOptionDialog(null, "<html><div style='font-size:20px;'>\u4f60\u7684\u4fe1\u606f\u54c8\u54c8\u54c8<br>2222222</div></html>", "\u6d4b\u8bd5", 0, 0, null, null, null, null);
    }
}

