/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.gui;

import com.wovoe.carpark.gui.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DateTimePicker
implements MouseListener,
WindowListener {
    private Calendar calendar;
    private Calendar now;
    private JPanel calendarPanel;
    private Font font = new Font("Times", 0, DateTimePicker.getFontSize(14));
    private SimpleDateFormat sdf;
    private Popup pop;
    private TitlePanel titlePanel;
    private BodyPanel bodyPanel;
    private FooterPanel footerPanel;
    private JSpinner hourSpin;
    private JSpinner minuteSpin;
    private JSpinner secondSpin;
    private static final String DEFAULTDATETIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DEFAULTDATEFORMAT = "yyyy-MM-dd";
    private static final String[] showTEXT = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static WeekLabel[] weekLabels = new WeekLabel[7];
    private static int defaultStartDAY = 0;
    private static Color hoverColor = Color.BLUE;
    private static Dimension rootSize;
    private DateTimePickerCallback datetimePickerCallback;
    private boolean dateOnly;
    private boolean showClear;
    private Component invoker;
    private static Color clBgCololr;
    public static Color buttonBgColor;

    static {
        clBgCololr = Color.decode("#FAFAFA");
    }

    public SimpleDateFormat getFormat() {
        return this.sdf;
    }

    private DateTimePicker(Date date, String format, int startDAY, DateTimePickerCallback datetimePickerCallback, boolean dateOnly, boolean showClear) {
        this.datetimePickerCallback = datetimePickerCallback;
        this.showClear = showClear;
        this.dateOnly = dateOnly;
        if (startDAY > -1 && startDAY < 7) {
            defaultStartDAY = startDAY;
        }
        int dayIndex = defaultStartDAY;
        int i = 0;
        while (i < 7) {
            if (dayIndex > 6) {
                dayIndex = 0;
            }
            DateTimePicker.weekLabels[i] = new WeekLabel(dayIndex, showTEXT[dayIndex]);
            weekLabels[i].setFont(this.font);
            ++dayIndex;
            ++i;
        }
        this.sdf = new SimpleDateFormat(format);
        this.now = Calendar.getInstance();
        this.calendar = Calendar.getInstance();
        if (date != null) {
            this.calendar.setTime(date);
        }
        this.initCalendarPanel();
    }

    public static DateTimePicker createDateTimePicker(Date date, String format, DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return new DateTimePicker(date, format, defaultStartDAY, datetimePickerCallback, false, showClear);
    }

    public static DateTimePicker createDateTimePicker(Date date, DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return new DateTimePicker(date, DEFAULTDATETIMEFORMAT, defaultStartDAY, datetimePickerCallback, false, showClear);
    }

    public static DateTimePicker createDateTimePicker(DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return DateTimePicker.createDateTimePicker(null, datetimePickerCallback, showClear);
    }

    public static DateTimePicker createDatePicker(Date date, String format, DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return new DateTimePicker(date, format, defaultStartDAY, datetimePickerCallback, true, showClear);
    }

    public static DateTimePicker createDatePicker(Date date, DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return new DateTimePicker(date, DEFAULTDATEFORMAT, defaultStartDAY, datetimePickerCallback, true, showClear);
    }

    public static DateTimePicker createDatePicker(DateTimePickerCallback datetimePickerCallback, boolean showClear) {
        return DateTimePicker.createDatePicker(null, datetimePickerCallback, showClear);
    }

    public String getDateTime() {
        return this.sdf.format(this.calendar.getTime());
    }

    public DateTimePicker setDateTime(String dateTime) {
        Date d;
        try {
            d = this.sdf.parse(dateTime);
        }
        catch (Exception ex) {
            d = new Date();
        }
        this.calendar.setTime(d);
        this.refresh();
        return this;
    }

    private void initCalendarPanel() {
        this.calendarPanel = new JPanel(new BorderLayout());
        this.calendarPanel.setBackground(clBgCololr);
        this.calendarPanel.setBorder(BorderFactory.createLineBorder(new Color(170, 170, 170)));
        this.titlePanel = new TitlePanel();
        this.calendarPanel.add((Component)this.titlePanel, "North");
        this.bodyPanel = new BodyPanel();
        this.calendarPanel.add((Component)this.bodyPanel, "Center");
        this.footerPanel = new FooterPanel();
        this.calendarPanel.add((Component)this.footerPanel, "South");
        this.bodyPanel.setBackground(clBgCololr);
        this.footerPanel.setBackground(clBgCololr);
    }

    public void hidePanel() {
        if (this.pop != null) {
            this.pop.hide();
            this.pop = null;
            if (this.invoker != null) {
                Window grabbedWindow;
                Window window = grabbedWindow = this.invoker instanceof Window ? (Window)this.invoker : SwingUtilities.getWindowAncestor(this.invoker);
                if (grabbedWindow != null) {
                    grabbedWindow.removeMouseListener(this);
                    grabbedWindow.removeWindowListener(this);
                }
                this.invoker = null;
            }
        }
    }

    public boolean isShow() {
        return this.pop != null;
    }

    public void showPicker(Component owner) {
        if (this.invoker == owner) {
            if (this.isShow()) {
                this.hidePanel();
            } else {
                this.showPanel(owner);
            }
        } else {
            this.showPanel(owner);
        }
    }

    public void showPicker(Component owner, int x, int y) {
        if (this.invoker == owner) {
            if (this.isShow()) {
                this.hidePanel();
            } else {
                this.showPanel(owner, x, y);
            }
        } else {
            this.showPanel(owner, x, y);
        }
    }

    public void showPanel(Component owner, int x, int y) {
        Window grabbedWindow;
        this.hidePanel();
        this.pop = PopupFactory.getSharedInstance().getPopup(owner, this.calendarPanel, x, y);
        this.pop.show();
        if (this.footerPanel != null && this.footerPanel.emptyLabel != null) {
            this.footerPanel.remove(this.footerPanel.emptyLabel);
            this.footerPanel.updateUI();
            this.footerPanel.emptyLabel = null;
        }
        this.invoker = owner;
        Window window = grabbedWindow = this.invoker instanceof Window ? (Window)this.invoker : SwingUtilities.getWindowAncestor(this.invoker);
        if (grabbedWindow != null) {
            int n;
            MouseListener[] mls = grabbedWindow.getMouseListeners();
            boolean fx = false;
            if (mls != null && mls.length > 0) {
                MouseListener[] mouseListenerArray = mls;
                n = mls.length;
                int n2 = 0;
                while (n2 < n) {
                    MouseListener l = mouseListenerArray[n2];
                    if (l == this) {
                        fx = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!fx) {
                grabbedWindow.addMouseListener(this);
            }
            WindowListener[] ls = grabbedWindow.getWindowListeners();
            fx = false;
            if (ls != null && ls.length > 0) {
                WindowListener[] windowListenerArray = ls;
                int n3 = ls.length;
                n = 0;
                while (n < n3) {
                    WindowListener l = windowListenerArray[n];
                    if (l == this) {
                        fx = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!fx) {
                grabbedWindow.addWindowListener(this);
            }
        }
    }

    public void showPanel(Component owner) {
        Point show = new Point(0, owner.getHeight());
        SwingUtilities.convertPointToScreen(show, owner);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = show.x;
        int y = show.y;
        Dimension s1 = DateTimePicker.getBsize(new Dimension(200, 167));
        if (x > size.width - s1.width) {
            x = size.width - s1.width;
        }
        if (y > size.height - s1.height) {
            y -= s1.height;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.showPanel(owner, x, y);
    }

    private void commit() {
        String datestr = this.sdf.format(this.calendar.getTime());
        if (this.datetimePickerCallback != null) {
            this.datetimePickerCallback.onPicking(datestr);
        }
        if (this.dateOnly) {
            try {
                this.hidePanel();
            }
            finally {
                if (this.datetimePickerCallback != null) {
                    this.datetimePickerCallback.doPick(datestr);
                }
            }
        }
    }

    private int getSelectedHour() {
        return (Integer)this.hourSpin.getValue();
    }

    private int getSelectedMinite() {
        return (Integer)this.minuteSpin.getValue();
    }

    private int getSelectedSecond() {
        return (Integer)this.secondSpin.getValue();
    }

    private void refresh() {
        this.titlePanel.updateDate();
        this.bodyPanel.updateDate();
        this.footerPanel.updateDate();
    }

    private static Dimension getBsize(Dimension size) {
        int h = (int)Math.round(DateTimePicker.getRootSize().getHeight() * size.getHeight() / 768.0);
        int w = (int)Math.round(DateTimePicker.getRootSize().getWidth() * size.getWidth() / 1024.0);
        return new Dimension(w, h);
    }

    public static Dimension getRootSize() {
        if (rootSize == null) {
            rootSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return rootSize;
    }

    public static void setRootSize(Dimension rootSize0) {
        rootSize = rootSize0;
    }

    private static int getFontSize(int fontSize) {
        return (int)Math.round(DateTimePicker.getRootSize().getHeight() * (double)fontSize / 768.0);
    }

    private static int getGWidth(int w) {
        return (int)Math.round(DateTimePicker.getRootSize().getWidth() * (double)w / 1024.0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pp = e.getLocationOnScreen();
        if (this.calendarPanel != null && !this.isPressArea(this.calendarPanel, pp)) {
            if (this.invoker != null) {
                if (!this.isPressArea(this.invoker, pp)) {
                    this.hidePanel();
                }
            } else {
                this.hidePanel();
            }
        }
    }

    private boolean isPressArea(Component c, Point pp) {
        Point p = c.getLocationOnScreen();
        Dimension size = c.getSize();
        int x1 = p.x;
        int x2 = x1 + size.width;
        int y1 = p.y;
        int y2 = y1 + size.height;
        return x1 <= pp.x && pp.x <= x2 && y1 <= pp.y && pp.y <= y2;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.hidePanel();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class BodyPanel
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 5677718768457235447L;
        private List<DayPanel> dayLabelList;
        private Color selectedColor;
        private Color nowDayColor;
        private Color moveOnColor;
        private Color notSelectColor;

        public BodyPanel() {
            super(new GridLayout(7, 7));
            this.dayLabelList = new ArrayList<DayPanel>(42);
            this.selectedColor = Color.decode("#489EED");
            this.nowDayColor = Color.decode("#A9D5FF");
            this.moveOnColor = Color.decode("#E5E5E5");
            this.setPreferredSize(DateTimePicker.getBsize(new Dimension(200, 140)));
            this.setBackground(clBgCololr);
            this.notSelectColor = this.getBackground();
            this.initMonthPanel();
        }

        private void initMonthPanel() {
            WeekLabel[] weekLabelArray = weekLabels;
            int n = weekLabelArray.length;
            int n2 = 0;
            while (n2 < n) {
                WeekLabel weekLabel = weekLabelArray[n2];
                this.add(weekLabel);
                ++n2;
            }
            int i = 0;
            while (i < 42) {
                DayPanel p = new DayPanel();
                this.dayLabelList.add(p);
                this.add(p);
                p.dayLabel.addMouseListener(this);
                ++i;
            }
            this.updateDate();
        }

        public void updateDate() {
            Date temp = DateTimePicker.this.calendar.getTime();
            Calendar cal = Calendar.getInstance();
            cal.setTime(temp);
            cal.set(5, 1);
            int index = cal.get(7);
            if (index > defaultStartDAY) {
                cal.add(5, -index + defaultStartDAY);
            } else {
                cal.add(5, -index + defaultStartDAY - 7);
            }
            Date now0 = new Date();
            DateTimePicker.this.now.setTime(now0);
            int nowYear = DateTimePicker.this.now.get(1);
            int nowMonth = DateTimePicker.this.now.get(2);
            int nowDay = DateTimePicker.this.now.get(5);
            int selectYear = DateTimePicker.this.calendar.get(1);
            int selectMonth = DateTimePicker.this.calendar.get(2);
            int selectDay = DateTimePicker.this.calendar.get(5);
            int i = 0;
            while (i < this.dayLabelList.size()) {
                DayPanel p = this.dayLabelList.get(i);
                cal.add(5, 1);
                p.setValue(cal);
                if (p.year == selectYear && p.month == selectMonth && p.day == selectDay) {
                    p.setBackground(this.selectedColor);
                    p.isSelected = true;
                    p.moveInColor = this.selectedColor;
                    p.moveOutColor = this.selectedColor;
                } else if (p.year == nowYear && p.month == nowMonth && p.day == nowDay) {
                    p.isSelected = false;
                    p.setBackground(this.nowDayColor);
                    p.moveOutColor = this.nowDayColor;
                    p.moveInColor = this.selectedColor;
                } else {
                    p.isSelected = false;
                    p.setBackground(this.notSelectColor);
                    p.moveOutColor = this.notSelectColor;
                    p.moveInColor = this.moveOnColor;
                }
                if (p.year == selectYear && p.month == selectMonth) {
                    p.dayLabel.setForeground(Color.BLACK);
                } else {
                    p.dayLabel.setForeground(Color.LIGHT_GRAY);
                }
                ++i;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DayPanel p = this.getDayPanel(e);
            if (p != null) {
                DateTimePicker.this.calendar.set(1, p.year);
                DateTimePicker.this.calendar.set(2, p.month);
                DateTimePicker.this.calendar.set(5, p.day);
                DateTimePicker.this.refresh();
                DateTimePicker.this.commit();
            }
        }

        private DayPanel getDayPanel(MouseEvent e) {
            Object s = e.getSource();
            if (s != null) {
                Container p;
                if (s instanceof DayPanel) {
                    return (DayPanel)s;
                }
                if (s instanceof Component && (p = ((Component)s).getParent()) instanceof DayPanel) {
                    return (DayPanel)p;
                }
            }
            return null;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            DayPanel p = this.getDayPanel(e);
            if (p != null) {
                p.setBackground(p.moveInColor);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DayPanel p = this.getDayPanel(e);
            if (p != null) {
                p.setBackground(p.moveOutColor);
            }
        }
    }

    public static interface DateTimePickerCallback {
        public void onPicking(String var1);

        public void doPick(String var1);

        public void onPickClear();
    }

    class DayPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private boolean isSelected;
        private JLabel dayLabel;
        private int year;
        private int month;
        private int day;
        private Color moveOutColor;
        private Color moveInColor;

        public boolean isSelect() {
            return this.isSelected;
        }

        public DayPanel() {
            super(new BorderLayout());
            this.dayLabel = new JLabel();
            this.dayLabel.setFont(DateTimePicker.this.font);
            this.dayLabel.setHorizontalAlignment(0);
            this.add((Component)this.dayLabel, "Center");
            this.setBackground(clBgCololr);
            this.moveOutColor = this.getBackground();
        }

        public void setValue(Calendar cal) {
            this.year = cal.get(1);
            this.month = cal.get(2);
            this.day = cal.get(5);
            String v = String.valueOf(this.day);
            if (!v.equals(this.dayLabel.getText())) {
                this.dayLabel.setText(v);
            }
        }
    }

    private class FooterPanel
    extends JPanel
    implements ChangeListener {
        private static final long serialVersionUID = 8135037333899746736L;
        private JLabel emptyLabel;

        public FooterPanel() {
            this.initFooterPanel();
        }

        private void initFooterPanel() {
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.decode("#AAAAAA")));
            if (DateTimePicker.this.dateOnly) {
                this.setLayout(new GridLayout(1, DateTimePicker.this.showClear ? 2 : 1));
                Font f = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, DateTimePicker.getFontSize(12));
                if (DateTimePicker.this.showClear) {
                    final JPanel p1 = new JPanel(new BorderLayout());
                    p1.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.decode("#AAAAAA")));
                    final JLabel clearLabel = new JLabel("\u6e05\u9664");
                    p1.add((Component)clearLabel, "Center");
                    clearLabel.setHorizontalAlignment(0);
                    clearLabel.setFont(f);
                    clearLabel.setCursor(new Cursor(12));
                    this.add(p1);
                    clearLabel.addMouseListener(new MouseAdapter(){
                        Color moveOnColor = Color.decode("#E5E5E5");
                        Color moveOutColor;
                        {
                            this.moveOutColor = jPanel.getBackground();
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            p1.setBackground(this.moveOnColor);
                            clearLabel.setForeground(hoverColor);
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            clearLabel.setForeground(Color.BLACK);
                            p1.setBackground(this.moveOutColor);
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            this.mouseExited(e);
                            if (DateTimePicker.this.datetimePickerCallback != null) {
                                DateTimePicker.this.datetimePickerCallback.onPickClear();
                            }
                            DateTimePicker.this.hidePanel();
                        }
                    });
                }
                final JPanel p2 = new JPanel(new BorderLayout());
                final JLabel dateLabel = new JLabel("\u4eca\u5929");
                p2.add((Component)dateLabel, "Center");
                dateLabel.setHorizontalAlignment(0);
                dateLabel.setFont(f);
                dateLabel.setCursor(new Cursor(12));
                dateLabel.addMouseListener(new MouseAdapter(){
                    Color moveOnColor = Color.decode("#E5E5E5");
                    Color moveOutColor;
                    {
                        this.moveOutColor = jPanel.getBackground();
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        p2.setBackground(this.moveOnColor);
                        dateLabel.setForeground(hoverColor);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        dateLabel.setForeground(Color.BLACK);
                        p2.setBackground(this.moveOutColor);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        this.mouseExited(e);
                        Date d = new Date();
                        DateTimePicker.this.calendar.setTime(d);
                        DateTimePicker.this.now.setTime(d);
                        DateTimePicker.this.refresh();
                        DateTimePicker.this.commit();
                    }
                });
                dateLabel.setBorder(BorderFactory.createEmptyBorder(DateTimePicker.getGWidth(5), 0, DateTimePicker.getGWidth(5), 0));
                this.add(p2);
            } else {
                JButton clear;
                this.setLayout(new FlowLayout());
                int currentHour = DateTimePicker.this.calendar.get(11);
                int currentMinute = DateTimePicker.this.calendar.get(12);
                int currentSecond = DateTimePicker.this.calendar.get(13);
                DateTimePicker.this.hourSpin = new JSpinner(new SpinnerNumberModel(currentHour, 0, 23, 1));
                this.setSpin(DateTimePicker.this.hourSpin);
                DateTimePicker.this.hourSpin.addChangeListener(this);
                DateTimePicker.this.hourSpin.setFont(DateTimePicker.this.font);
                this.add(DateTimePicker.this.hourSpin);
                JLabel a = new JLabel("\u65f6");
                a.setFont(DateTimePicker.this.font);
                this.add(a);
                DateTimePicker.this.minuteSpin = new JSpinner(new SpinnerNumberModel(currentMinute, 0, 59, 1));
                this.setSpin(DateTimePicker.this.minuteSpin);
                DateTimePicker.this.minuteSpin.setFont(DateTimePicker.this.font);
                DateTimePicker.this.minuteSpin.addChangeListener(this);
                this.add(DateTimePicker.this.minuteSpin);
                a = new JLabel("\u5206");
                a.setFont(DateTimePicker.this.font);
                this.add(a);
                DateTimePicker.this.secondSpin = new JSpinner(new SpinnerNumberModel(currentSecond, 0, 59, 1));
                this.setSpin(DateTimePicker.this.secondSpin);
                DateTimePicker.this.secondSpin.setFont(DateTimePicker.this.font);
                DateTimePicker.this.secondSpin.addChangeListener(this);
                this.add(DateTimePicker.this.secondSpin);
                a = new JLabel("\u79d2");
                a.setFont(DateTimePicker.this.font);
                this.add(a);
                Font f = new Font(SwingUtil.getFontFamily(SwingUtil.DEFAULT_FONT_NAME), 0, DateTimePicker.getFontSize(11));
                if (DateTimePicker.this.showClear) {
                    clear = new JButton("\u6e05\u9664");
                    clear.setFont(f);
                    clear.setCursor(new Cursor(12));
                    if (buttonBgColor != null) {
                        clear.setBackground(buttonBgColor);
                    }
                    this.add(clear);
                    clear.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (DateTimePicker.this.datetimePickerCallback != null) {
                                    DateTimePicker.this.datetimePickerCallback.onPickClear();
                                }
                            }
                            finally {
                                DateTimePicker.this.hidePanel();
                            }
                        }
                    });
                }
                clear = new JButton("\u4eca\u5929");
                clear.setCursor(new Cursor(12));
                clear.setFont(f);
                if (buttonBgColor != null) {
                    clear.setBackground(buttonBgColor);
                }
                this.add(clear);
                clear.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Date d = new Date();
                        DateTimePicker.this.calendar.setTime(d);
                        DateTimePicker.this.now.setTime(d);
                        DateTimePicker.this.refresh();
                        DateTimePicker.this.commit();
                    }
                });
                JButton ok = new JButton("\u786e\u5b9a");
                if (buttonBgColor != null) {
                    ok.setBackground(buttonBgColor);
                }
                ok.setFont(f);
                ok.setCursor(new Cursor(12));
                this.add(ok);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            DateTimePicker.this.calendar.set(11, DateTimePicker.this.getSelectedHour());
                            DateTimePicker.this.calendar.set(12, DateTimePicker.this.getSelectedMinite());
                            DateTimePicker.this.calendar.set(13, DateTimePicker.this.getSelectedSecond());
                            DateTimePicker.this.commit();
                            String datestr = DateTimePicker.this.sdf.format(DateTimePicker.this.calendar.getTime());
                            if (DateTimePicker.this.datetimePickerCallback != null) {
                                DateTimePicker.this.datetimePickerCallback.doPick(datestr);
                            }
                        }
                        finally {
                            DateTimePicker.this.hidePanel();
                        }
                    }
                });
                this.emptyLabel = new JLabel(" ");
                this.add(this.emptyLabel);
            }
        }

        private void setSpin(JSpinner spinner) {
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, "0");
            spinner.setEditor(editor);
            JFormattedTextField textField = ((JSpinner.NumberEditor)spinner.getEditor()).getTextField();
            textField.setEditable(true);
            DefaultFormatterFactory factory = (DefaultFormatterFactory)textField.getFormatterFactory();
            NumberFormatter formatter = (NumberFormatter)factory.getDefaultFormatter();
            formatter.setAllowsInvalid(false);
        }

        public void updateDate() {
            if (!DateTimePicker.this.dateOnly) {
                int currentHour = DateTimePicker.this.calendar.get(11);
                int currentMinute = DateTimePicker.this.calendar.get(12);
                int currentSecond = DateTimePicker.this.calendar.get(13);
                DateTimePicker.this.hourSpin.setValue(currentHour);
                DateTimePicker.this.minuteSpin.setValue(currentMinute);
                DateTimePicker.this.secondSpin.setValue(currentSecond);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!DateTimePicker.this.dateOnly && e.getSource() != null && e.getSource() instanceof JSpinner) {
                DateTimePicker.this.calendar.set(11, DateTimePicker.this.getSelectedHour());
                DateTimePicker.this.calendar.set(12, DateTimePicker.this.getSelectedMinite());
                DateTimePicker.this.calendar.set(13, DateTimePicker.this.getSelectedSecond());
                DateTimePicker.this.commit();
            }
        }
    }

    private class TitlePanel
    extends JPanel {
        private static final long serialVersionUID = -2865282186037420798L;
        private JLabel preYear;
        private JLabel preMonth;
        private JLabel center;
        private JLabel nextMonth;
        private JLabel nextYear;
        private JLabel centercontainer;

        public TitlePanel() {
            super(new BorderLayout());
            this.setBackground(new Color(190, 200, 200));
            this.initTitlePanel();
        }

        private void initTitlePanel() {
            this.preYear = new JLabel("<<", 0);
            this.preYear.setFont(DateTimePicker.this.font);
            this.preMonth = new JLabel("<", 0);
            this.preMonth.setFont(DateTimePicker.this.font);
            this.center = new JLabel("", 0);
            this.center.setFont(DateTimePicker.this.font);
            this.centercontainer = new JLabel("", 0);
            this.nextMonth = new JLabel(">", 0);
            this.nextMonth.setFont(DateTimePicker.this.font);
            this.nextYear = new JLabel(">>", 0);
            this.nextYear.setFont(DateTimePicker.this.font);
            this.preYear.setToolTipText("\u4e0a\u4e00\u5e74");
            this.preMonth.setToolTipText("\u4e0a\u4e2a\u6708");
            this.nextMonth.setToolTipText("\u4e0b\u4e2a\u6708");
            this.nextYear.setToolTipText("\u4e0b\u4e00\u5e74");
            this.preYear.setBorder(BorderFactory.createEmptyBorder(DateTimePicker.getGWidth(2), DateTimePicker.getGWidth(10), 0, 0));
            this.preMonth.setBorder(BorderFactory.createEmptyBorder(DateTimePicker.getGWidth(2), DateTimePicker.getGWidth(15), 0, 0));
            this.nextMonth.setBorder(BorderFactory.createEmptyBorder(DateTimePicker.getGWidth(2), 0, 0, DateTimePicker.getGWidth(15)));
            this.nextYear.setBorder(BorderFactory.createEmptyBorder(DateTimePicker.getGWidth(2), 0, 0, DateTimePicker.getGWidth(10)));
            this.centercontainer.setLayout(new BorderLayout());
            this.centercontainer.add((Component)this.preMonth, "West");
            this.centercontainer.add((Component)this.center, "Center");
            this.centercontainer.add((Component)this.nextMonth, "East");
            this.add((Component)this.preYear, "West");
            this.add((Component)this.centercontainer, "Center");
            this.add((Component)this.nextYear, "East");
            this.setPreferredSize(DateTimePicker.getBsize(new Dimension(200, 25)));
            this.updateDate();
            this.preYear.addMouseListener(new MouseAdapter0(this.preYear, 1, -1));
            this.preMonth.addMouseListener(new MouseAdapter0(this.preMonth, 2, -1));
            this.nextMonth.addMouseListener(new MouseAdapter0(this.nextMonth, 2, 1));
            this.nextYear.addMouseListener(new MouseAdapter0(this.nextYear, 1, 1));
        }

        private void updateDate() {
            this.center.setText(String.valueOf(DateTimePicker.this.calendar.get(1)) + "\u5e74" + (DateTimePicker.this.calendar.get(2) + 1) + "\u6708");
        }

        class MouseAdapter0
        extends MouseAdapter {
            JLabel label;
            private int type;
            private int value;

            public MouseAdapter0(JLabel label, int type, int value) {
                this.label = label;
                this.type = type;
                this.value = value;
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                this.label.setCursor(new Cursor(12));
                this.label.setForeground(hoverColor);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                this.label.setCursor(new Cursor(0));
                this.label.setForeground(Color.BLACK);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                DateTimePicker.this.calendar.add(this.type, this.value);
                this.label.setForeground(Color.WHITE);
                DateTimePicker.this.refresh();
                if (DateTimePicker.this.datetimePickerCallback != null) {
                    String datestr = DateTimePicker.this.sdf.format(DateTimePicker.this.calendar.getTime());
                    DateTimePicker.this.datetimePickerCallback.onPicking(datestr);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                this.label.setForeground(Color.BLACK);
            }
        }
    }

    private class WeekLabel
    extends JLabel {
        private static final long serialVersionUID = -8053965084432740110L;
        private String name;

        public WeekLabel(int index, String name) {
            super(name, 0);
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

